/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.rss.client.RisingFallingCondDialog$1;
import hec.rss.model.OpRule;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJLabel;
import rma.swing.RmaJTextField;

public class RisingFallingCondDialog
extends RmaJDialog
implements ItemListener,
ButtonCmdPanelListener {
    ButtonCmdPanel _buttonCmdPanel = new ButtonCmdPanel(12);
    JLabel _ruleLabel = new JLabel("Rule:");
    RmaJTextField _ruleName_TF = new RmaJTextField("rule name");
    JLabel _conditionLabel = new JLabel("Condition:");
    RmaJComboBox _conditionCombo = new RmaJComboBox();
    JLabel _parameterLabel = new JLabel("Parameter:");
    RmaJComboBox _parameterCombo = new RmaJComboBox();
    RmaJLabel _toleranceLabel = new RmaJLabel("Tolerance (%S):");
    RmaJDecimalField _tolerance_DF = new RmaJDecimalField();
    JLabel _periodLabel = new JLabel("Averaging Period (hrs):");
    RmaJDecimalField _avgPeriod_DF = new RmaJDecimalField();
    OpRule _opRule;
    boolean _isOk = false;
    public static final String[] _conditionNames = new String[]{"Rising", "Rising or Constant", "Falling or Constant", "Falling"};
    public static final String[] _parameterNames = new String[]{"Pool Elevation", "Inflow"};
    private static Insets a = RmaInsets.INSETS5500;

    public RisingFallingCondDialog(Dialog dialog, boolean bl) {
        super(dialog, bl);
        this.buildControls();
    }

    /*
     * Unable to fully structure code
     */
    public void fillForm(OpRule var1_1) {
        this._opRule = var1_1;
        this.clearForm();
        for (var1_2 = 0; var1_2 < RisingFallingCondDialog._conditionNames.length; ++var1_2) {
            this._conditionCombo.addItem((Object)RisingFallingCondDialog._conditionNames[var1_2]);
        }
        for (var1_2 = 0; var1_2 < RisingFallingCondDialog._parameterNames.length; ++var1_2) {
            this._parameterCombo.addItem((Object)RisingFallingCondDialog._parameterNames[var1_2]);
        }
        if (this._opRule == null) {
            return;
        }
        this._ruleName_TF.setText(this._opRule.getName());
        var1_2 = this._opRule.getRiseFallCondition();
        if (var1_2 == 0) ** GOTO lbl-1000
        if (var1_2 == 1) {
            this._conditionCombo.setSelectedItem((Object)"Rising");
        } else if (var1_2 == 2) {
            this._conditionCombo.setSelectedItem((Object)"Rising or Constant");
        } else if (var1_2 == 3) {
            this._conditionCombo.setSelectedItem((Object)"Falling or Constant");
        } else if (var1_2 == 4) {
            this._conditionCombo.setSelectedItem((Object)"Falling");
        } else lbl-1000:
        // 2 sources

        {
            this._conditionCombo.setSelectedIndex(-1);
        }
        var1_2 = this._opRule.getParameterType();
        if (var1_2 == 1) {
            this._parameterCombo.setSelectedItem((Object)"Pool Elevation");
        } else if (var1_2 == 2) {
            this._parameterCombo.setSelectedItem((Object)"Inflow");
        } else {
            this._parameterCombo.setSelectedIndex(-1);
        }
        var2_4 = this._opRule.getAveragingPeriod();
        if (var2_4 == -2147483648) {
            this._avgPeriod_DF.setValue(-Infinity);
        } else {
            var5_5 = (double)var2_4 / 3600.0;
            this._avgPeriod_DF.setValue(var5_5);
        }
        var5_5 = this._opRule.getRiseFallTolerance();
        var2_4 = -1;
        if (var1_2 == 1) {
            var2_4 = Parameter.PARAMID_ELEV;
        } else if (var1_2 == 2) {
            var2_4 = Parameter.PARAMID_FLOW;
        }
        var1_2 = this._opRule.getUnitSystem();
        var1_3 = new ParamDouble(var5_5, var2_4, var1_2, 3);
        this._tolerance_DF.setValue(var1_3);
        this._toleranceLabel.setLabelFor((Component)this._tolerance_DF);
    }

    public boolean saveForm() {
        if (this._opRule == null) {
            return false;
        }
        int n = 0;
        if (this._conditionCombo.getSelectedIndex() < 0) {
            n = 0;
        } else {
            String string = (String)this._conditionCombo.getSelectedItem();
            if (string.equalsIgnoreCase("Rising")) {
                n = 1;
            } else if (string.equalsIgnoreCase("Rising or Constant")) {
                n = 2;
            } else if (string.equalsIgnoreCase("Falling or Constant")) {
                n = 3;
            } else if (string.equalsIgnoreCase("Falling")) {
                n = 4;
            }
        }
        this._opRule.setRiseFallCondition(n);
        int n2 = 0;
        if (this._parameterCombo.getSelectedIndex() < 0) {
            n2 = 0;
        } else {
            String string = (String)this._parameterCombo.getSelectedItem();
            if (string.equalsIgnoreCase("Pool Elevation")) {
                n2 = 1;
            } else if (string.equalsIgnoreCase("Inflow")) {
                n2 = 2;
            }
        }
        this._opRule.setParameterType(n2);
        int n3 = Integer.MIN_VALUE;
        double d = this._avgPeriod_DF.getValueUndefined();
        if (d != Double.NEGATIVE_INFINITY) {
            n3 = (int)(d * 3600.0);
        }
        this._opRule.setAveragingPeriod(n3);
        this._opRule.setRiseFallTolerance(this._tolerance_DF.getValueUndefined());
        return true;
    }

    public void clearForm() {
    }

    public void setOk(boolean bl) {
        this._isOk = bl;
    }

    public boolean isOk() {
        return this._isOk;
    }

    public void buttonCmdActionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getID() == 8) {
            this.cmdOK_Action();
            return;
        }
        if (actionEvent.getID() == 4) {
            this.cmdCancel_Action();
        }
    }

    public void cmdOK_Action() {
        this.saveForm();
        this.setOk(true);
        this.setVisible(false);
    }

    public void cmdCancel_Action() {
        this.setOk(false);
        this.setVisible(false);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 2) {
            return;
        }
    }

    private void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Rising / Falling Condition");
        this.setSize(280, 200);
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.getContentPane().add((Component)jPanel, new RmaGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this._ruleLabel, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, a, 0, 0));
        jPanel.add((Component)this._ruleName_TF, new RmaGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, a, 0, 0));
        this._ruleName_TF.setEditable(false);
        jPanel.add((Component)this._conditionLabel, new RmaGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, a, 0, 0));
        jPanel.add((Component)this._conditionCombo, new RmaGridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, a, 0, 0));
        jPanel.add((Component)this._parameterLabel, new RmaGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, a, 0, 0));
        jPanel.add((Component)this._parameterCombo, new RmaGridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, a, 0, 0));
        jPanel = new JPanel(new GridBagLayout());
        this.getContentPane().add((Component)jPanel, new RmaGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this._periodLabel, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, a, 0, 0));
        jPanel.add((Component)this._avgPeriod_DF, new RmaGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, a, 0, 0));
        jPanel.add((Component)this._toleranceLabel, new RmaGridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 0, a, 0, 0));
        jPanel.add((Component)this._tolerance_DF, new RmaGridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 2, a, 0, 0));
        this.getContentPane().add((Component)this._buttonCmdPanel, new RmaGridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this._buttonCmdPanel.addCmdPanelListener((ButtonCmdPanelListener)this);
        this._toleranceLabel.setLabelFor((Component)this._tolerance_DF);
        this.setLocation();
        this._parameterCombo.addItemListener((ItemListener)new RisingFallingCondDialog$1(this));
    }
}

