/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.map.LocalPt;
import hec.map.LocalRect;
import hec.map.LocalRegion;
import hec.map.MapCanvas;
import hec.map.MapGlyph;
import hec.map.MapMouseAdapter;
import hec.map.MapPanel;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.model.StreamElement;
import hec.rss.client.RSS;
import hec.rss.client.RssSystemGlyph;
import hec.rss.model.DiversionElement;
import hec.rss.model.Element;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import rma.swing.RmaImage;

public class RssDiversionMouseAdapter
extends MapMouseAdapter
implements MouseListener,
MouseMotionListener {
    public static final String POINTER_CURSOR = "DiversionCursor";
    RssSystemGlyph _sysglyph = null;
    Vector _ptVec = new Vector();
    boolean _creatingDiv = false;
    boolean _editingDiv = false;
    boolean _movingOutflow = false;
    boolean _movingInflow = false;
    boolean _toolTipShowing = false;
    int _inFlowType = 0;
    LocalPt _beginPt = new LocalPt();
    LocalPt _endPt = new LocalPt();
    LocalPt _pt = new LocalPt();
    LocalPt _pt0 = new LocalPt();
    LocalPt _selectedPt = null;
    WorldPt _selectedWPt = null;
    LocalRect _lrc = new LocalRect();
    WorldRect _wrc = new WorldRect();
    DiversionElement _diversionElem;
    RssNode _selectedNode = null;
    RssNode _divNode0;
    RssNode _divNode1;
    StreamElement _stream = null;
    private Cursor _divCursor;
    static int[] _xpt = new int[4];
    static int[] _ypt = new int[4];
    static int[] _xp = new int[4000];
    static int[] _yp = new int[4000];

    public RssDiversionMouseAdapter(MapPanel object, MapCanvas mapCanvas) {
        super(object, mapCanvas);
        try {
            object = RmaImage.loadURLImage((Component)mapCanvas, (String)"Images/pointers/DiversionCursor.gif");
            this._divCursor = Toolkit.getDefaultToolkit().createCustomCursor((Image)object, new Point(0, 0), POINTER_CURSOR);
            return;
        }
        catch (Exception exception) {
            System.out.println("init:failed to find cursor image: Images/pointer/DiversionCursor.gif. Error:" + String.valueOf(exception));
            return;
        }
    }

    public void init() {
        this.findGlyph();
    }

    public void abort() {
        this.findGlyph();
        if (this._sysglyph != null) {
            this._sysglyph.clearSelection();
        }
        this._creatingDiv = false;
        this._editingDiv = false;
        this._diversionElem = null;
    }

    boolean findGlyph() {
        this._sysglyph = null;
        List list = this._mapPanel.managerGlyphList();
        for (int i = 0; i < list.size(); ++i) {
            MapGlyph mapGlyph = (MapGlyph)list.get(i);
            if (mapGlyph == null || !(mapGlyph instanceof RssSystemGlyph)) continue;
            this._sysglyph = (RssSystemGlyph)mapGlyph;
            break;
        }
        return this._sysglyph != null;
    }

    WorldPt findJunction(LocalPt object) {
        double d;
        if (!this.findGlyph()) {
            return null;
        }
        WorldPt worldPt = this._mapPanel.scale().lp2wp((LocalPt)object);
        object = this._sysglyph.findJunction(worldPt, d = this._mapPanel.scale().x2e(((LocalPt)object).x + 5) - this._mapPanel.scale().x2e(((LocalPt)object).x));
        if (object == null) {
            return null;
        }
        return ((Element)object).getReferencePt();
    }

    WorldPt findReservoir(WorldPt worldPt) {
        if (!this.findGlyph()) {
            return null;
        }
        ReservoirElement reservoirElement = this._sysglyph.findReservoir(worldPt);
        if (reservoirElement == null) {
            return null;
        }
        return worldPt;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.findGlyph()) {
            return;
        }
        if (this._creatingDiv && !mouseEvent.isControlDown()) {
            this._creatingDiv = false;
            mouseEvent = new LocalPt(mouseEvent.getX(), mouseEvent.getY());
            this._mapPanel.scale().lp2wp((LocalPt)mouseEvent);
            WorldPt worldPt = this.findJunction((LocalPt)mouseEvent);
            if (worldPt != null) {
                mouseEvent = this._mapPanel.scale().wp2lp(worldPt);
                this._divNode1 = this._sysglyph.createDiversionNode((LocalPt)mouseEvent, this._divNode0);
            } else {
                this._divNode1 = null;
            }
            this._sysglyph.createDiversion(this._divNode0, this._divNode1, this._ptVec, this._inFlowType);
            return;
        }
        if (this._selectedNode != null) {
            mouseEvent = this._mapPanel.scale().lp2wp(this._pt);
            double d = this._stream.getLine().getCoordAtLocation((WorldPt)mouseEvent);
            this._selectedNode.setStreamCoord(d);
            this._selectedNode.setStreamIndex(this._stream.getIndex());
            this._selectedNode.setStreamName(this._stream.getName());
            this._selectedNode.setStreamStation(this._stream.getStationByCoord(d));
            this._selectedNode.setLocation((WorldPt)mouseEvent);
            this._selectedNode = null;
            this._diversionElem.getSystem().setModified(true);
            this._mapPanel.paintMap();
            return;
        }
        if (this._selectedPt != null) {
            this._sysglyph.connectDiversionElement(this._diversionElem, this._selectedPt);
            if (this._movingOutflow) {
                LocalPt localPt = new LocalPt(mouseEvent.getX(), mouseEvent.getY());
                this._mapPanel.scale().lp2wp(localPt);
                mouseEvent = this.findJunction(localPt);
                if (mouseEvent != null) {
                    RssNode rssNode = ((Element)this._diversionElem).getDownstreamNode();
                    if (rssNode != null) {
                        rssNode.setLocation((WorldPt)mouseEvent);
                    } else {
                        localPt = this._mapPanel.scale().wp2lp((WorldPt)mouseEvent);
                        this._divNode1 = this._sysglyph.createDiversionNode(localPt, this._divNode0);
                        ((Element)this._diversionElem).addNode(this._divNode1, 0);
                    }
                    WorldPt worldPt = this._diversionElem.getLine().getLastPt();
                    worldPt.init((WorldPt)mouseEvent);
                } else {
                    RssNode rssNode = ((Element)this._diversionElem).getDownstreamNode();
                    if (rssNode != null) {
                        ((Element)this._diversionElem).removeNode(rssNode);
                    }
                }
                this._diversionElem.getSystem().setModified(true);
            }
            this._selectedPt = null;
            this._selectedWPt = null;
            this._movingOutflow = false;
            this._mapPanel.paintMap();
            this._diversionElem.getSystem().setModified(true);
            return;
        }
        if (!mouseEvent.isPopupTrigger()) {
            RssDiversionMouseAdapter.pressedButton3((MouseEvent)mouseEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        LocalPt localPt;
        if ((mouseEvent.isPopupTrigger() || RssDiversionMouseAdapter.pressedButton3((MouseEvent)mouseEvent)) && !mouseEvent.isControlDown()) {
            if (!this.findGlyph()) {
                return;
            }
            localPt = new LocalPt(mouseEvent.getX(), mouseEvent.getY());
            this._sysglyph.diversionPopupMenu(localPt);
        }
        if (this._creatingDiv) {
            this._pt0.init(this._pt);
            this._pt.init(mouseEvent.getX(), mouseEvent.getY());
            RssDiversionMouseAdapter rssDiversionMouseAdapter = this;
            rssDiversionMouseAdapter.drawPt(rssDiversionMouseAdapter._pt, true);
            localPt = this._mapPanel.scale().lp2wp(new LocalPt(this._pt));
            this._ptVec.addElement(localPt);
            return;
        }
        if (this._editingDiv && mouseEvent.isControlDown() && mouseEvent.isShiftDown()) {
            this._pt.init(mouseEvent.getX(), mouseEvent.getY());
            localPt = this._mapPanel.scale().lp2wp(this._pt);
            double d = this._mapPanel.scale().x2e(this._pt.x + 5) - this._mapPanel.scale().x2e(this._pt.x);
            this._diversionElem.getLine().removePt((WorldPt)localPt, d);
            this._mapPanel.paintMap();
            return;
        }
        if (this._editingDiv && mouseEvent.isControlDown() && this._diversionElem != null) {
            this._pt.init(mouseEvent.getX(), mouseEvent.getY());
            localPt = this._mapPanel.scale().lp2wp(this._pt);
            double d = this._mapPanel.scale().x2e(this._pt.x + 5) - this._mapPanel.scale().x2e(this._pt.x);
            this._diversionElem.getLine().insertPt((WorldPt)localPt, d);
            this._diversionElem.getSystem().setModified(true);
            RssDiversionMouseAdapter rssDiversionMouseAdapter = this;
            rssDiversionMouseAdapter.drawDiversionElement(rssDiversionMouseAdapter._diversionElem, false);
            return;
        }
        if (!this._creatingDiv && mouseEvent.isControlDown()) {
            if (!this.findGlyph()) {
                RSS.app();
                JOptionPane.showMessageDialog((Component)ClientApp.frame(), "Please create/open a Reservoir Network first");
                return;
            }
            if (!this._sysglyph.isWriteLocked()) {
                JOptionPane.showMessageDialog((Component)this._mapPanel, "You must first lock the Reservoir Network.", "Cannot Create Diversion", 1);
                return;
            }
            LocalPt localPt2 = new LocalPt(mouseEvent.getX(), mouseEvent.getY());
            this._mapPanel.scale().lp2wp(localPt2);
            localPt = this.findJunction(localPt2);
            if (localPt == null) {
                this._inFlowType = 0;
                return;
            }
            this._inFlowType = 2;
            LocalPt localPt3 = this._mapPanel.scale().wp2lp((WorldPt)localPt);
            this._pt0.init(localPt3);
            this._pt.init(this._pt0);
            RssDiversionMouseAdapter rssDiversionMouseAdapter = this;
            rssDiversionMouseAdapter.drawPt(rssDiversionMouseAdapter._pt, true);
            this._divNode0 = this._sysglyph.createDiversionNode(this._pt, null);
            this._ptVec.removeAllElements();
            this._mapPanel.scale().lp2wp(new LocalPt(this._pt));
            if (this._divNode0 == null) {
                return;
            }
            this._creatingDiv = true;
            this._ptVec.addElement(this._divNode0.getLocation());
            return;
        }
        if (this._editingDiv && this._diversionElem != null) {
            this._pt.init(mouseEvent.getX(), mouseEvent.getY());
            this._pt0.init(this._pt);
            localPt = new LocalPt();
            WorldPt worldPt = ((Element)this._diversionElem).getReferencePt();
            this._mapPanel.scale().wp2lp(worldPt, localPt);
            this._lrc.init(this._pt.x - 8, this._pt.y - 8, this._pt.x + 8, this._pt.y + 8);
            if (this._lrc.contains(localPt)) {
                this._selectedNode = ((Element)this._diversionElem).getUpstreamNode();
                if (this._selectedNode == null) {
                    return;
                }
                this._stream = this._selectedNode.getStream();
                double d = this._stream.getLine().getCoordAtLocation(worldPt);
                this._stream.getStationByCoord(d);
                localPt = this._mapPanel.scale().wp2lp(this._stream.getLocationByCoord(d));
                this._pt.init(localPt);
                this._movingInflow = true;
                this._movingOutflow = false;
                this._selectedPt = localPt;
                this._selectedWPt = worldPt;
                return;
            }
            this._movingInflow = false;
            worldPt = this._diversionElem.getLine().getLastPt();
            this._mapPanel.scale().wp2lp(worldPt, localPt);
            this._lrc.init(this._pt.x - 8, this._pt.y - 8, this._pt.x + 8, this._pt.y + 8);
            if (this._lrc.contains(localPt)) {
                if (((Element)this._diversionElem).getDownstreamNode() != null) {
                    return;
                }
                this._movingOutflow = true;
                this._selectedPt = localPt;
                this._selectedWPt = worldPt;
            } else {
                this._movingOutflow = false;
                this._lrc.init(this._pt.x - 3, this._pt.y - 3, this._pt.x + 3, this._pt.y + 3);
                for (int i = 0; i < this._diversionElem.getLine().pts.size(); ++i) {
                    worldPt = (WorldPt)this._diversionElem.getLine().pts.elementAt(i);
                    if (worldPt == null) continue;
                    this._mapPanel.scale().wp2lp(worldPt, localPt);
                    if (!this._lrc.contains(localPt)) continue;
                    this._selectedPt = localPt;
                    this._selectedWPt = worldPt;
                    return;
                }
            }
            this._diversionElem.getSystem().setModified(true);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this._creatingDiv) {
            Graphics graphics = this._mapCanvas.getGraphics();
            graphics.setXORMode(new Color(255, 255, 255));
            graphics.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
            this._pt.init(mouseEvent.getX(), mouseEvent.getY());
            graphics.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
            graphics.setPaintMode();
            graphics.dispose();
        }
    }

    @Override
    public void mouseDragged(MouseEvent object) {
        if (this._selectedNode != null && this._diversionElem != null && this._diversionElem.getInflowType() == 1) {
            Graphics graphics = this._mapCanvas.getGraphics();
            graphics.setXORMode(new Color(255, 255, 255));
            graphics.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
            if (!this._pt.equals(this._pt0)) {
                RssDiversionMouseAdapter rssDiversionMouseAdapter = this;
                rssDiversionMouseAdapter.drawPt(rssDiversionMouseAdapter._pt, true);
            }
            LocalPt localPt = new LocalPt(((MouseEvent)object).getX(), ((MouseEvent)object).getY());
            WorldPt worldPt = this._mapPanel.scale().lp2wp(localPt);
            object = this._sysglyph.findReservoir(worldPt);
            if (object == null) {
                return;
            }
            double d = ((Element)object).getDownstreamNode().getStreamCoord();
            this._diversionElem.getLine().getCoordAtLocation(worldPt);
            if (this._movingInflow) {
                double d2;
                worldPt = this._mapPanel.scale().lp2wp(localPt);
                double d3 = this._stream.getLine().getCoordAtLocation(worldPt);
                this._stream.getStationByCoord(d3);
                double d4 = ((Element)this._diversionElem).getUpstreamNode().getStreamCoord();
                if (d2 < d) {
                    return;
                }
                if (d3 < d4) {
                    object = this._sysglyph.findDownstreamNode(this._stream, d4);
                    if (object != null && d3 < ((RssNode)object).getStreamCoord()) {
                        System.out.println("downstream");
                        return;
                    }
                } else {
                    object = this._sysglyph.findUpstreamNode(this._stream, d4);
                    if (object != null && d3 > ((RssNode)object).getStreamCoord()) {
                        System.out.println("upstream");
                        return;
                    }
                }
                localPt = this._mapPanel.scale().wp2lp(this._stream.getLocationByCoord(d3));
                this._mapPanel.scale().lp2wp(localPt);
            }
            this._pt.init(localPt);
            graphics.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
            if (!this._pt.equals(this._pt0)) {
                RssDiversionMouseAdapter rssDiversionMouseAdapter = this;
                rssDiversionMouseAdapter.drawPt(rssDiversionMouseAdapter._pt, true);
            }
            graphics.setPaintMode();
            graphics.dispose();
            return;
        }
        if (this._selectedPt != null && this._diversionElem != null) {
            RssDiversionMouseAdapter rssDiversionMouseAdapter = this;
            rssDiversionMouseAdapter.drawDiversionElement(rssDiversionMouseAdapter._diversionElem, true);
            this._selectedPt.init(((MouseEvent)object).getX(), ((MouseEvent)object).getY());
            this._mapPanel.scale().lp2wp(this._selectedPt, this._selectedWPt);
            RssDiversionMouseAdapter rssDiversionMouseAdapter2 = this;
            rssDiversionMouseAdapter2.drawDiversionElement(rssDiversionMouseAdapter2._diversionElem, true);
        }
    }

    @Override
    public void mouseClicked(MouseEvent object) {
        if (!this._creatingDiv) {
            if (((MouseEvent)object).getClickCount() == 2) {
                if (!this.findGlyph()) {
                    RSS.app();
                    JOptionPane.showMessageDialog((Component)ClientApp.frame(), "Please create/open a Reservoir Network first");
                    return;
                }
                if (!this._sysglyph.isWriteLocked()) {
                    JOptionPane.showMessageDialog((Component)this._mapPanel, "You must first lock the Reservoir Network.", "Cannot Edit Diversion", 1);
                    return;
                }
                this._pt.init(((MouseEvent)object).getX(), ((MouseEvent)object).getY());
                object = this._sysglyph.selectDiversion(this._pt, false, true);
                if (object != null) {
                    this._editingDiv = true;
                    if (((DiversionElement)object).getDiversionProjectId() != Long.MIN_VALUE) {
                        this._sysglyph.selectDiversion(this._pt, false, false);
                        JOptionPane.showMessageDialog((Component)this._mapPanel, "This diversion is associated with a Watershed Diversion Project.\nPlease edit the diversion in the Watershed Setup Module, then update this Network", "Cannot Edit Diversion", 1);
                        this._editingDiv = false;
                        object = null;
                    }
                } else {
                    this._editingDiv = false;
                }
                this._diversionElem = object;
                return;
            }
            if (!this._editingDiv) {
                if (!this.findGlyph()) {
                    return;
                }
                this._pt.init(((MouseEvent)object).getX(), ((MouseEvent)object).getY());
                object = this._sysglyph.selectDiversion(this._pt, false, false);
                this._editingDiv = false;
                this._diversionElem = object;
            }
        }
    }

    void drawPt(LocalPt localPt, boolean bl) {
        Graphics graphics = this._mapCanvas.getGraphics();
        if (bl) {
            graphics.setXORMode(new Color(255, 255, 255));
        } else {
            graphics.setColor(Color.black);
        }
        RssDiversionMouseAdapter._xpt[0] = localPt.x - 3;
        RssDiversionMouseAdapter._ypt[0] = localPt.y;
        RssDiversionMouseAdapter._xpt[1] = localPt.x;
        RssDiversionMouseAdapter._ypt[1] = localPt.y + 3;
        RssDiversionMouseAdapter._xpt[2] = localPt.x + 3;
        RssDiversionMouseAdapter._ypt[2] = localPt.y;
        RssDiversionMouseAdapter._xpt[3] = localPt.x;
        RssDiversionMouseAdapter._ypt[3] = localPt.y - 3;
        graphics.fillPolygon(_xpt, _ypt, 4);
        graphics.setPaintMode();
        graphics.dispose();
    }

    void drawRegion(LocalRegion localRegion, boolean bl) {
        Graphics graphics = this._mapCanvas.getGraphics();
        if (bl) {
            graphics.setXORMode(new Color(255, 255, 255));
        } else {
            graphics.setColor(Color.black);
        }
        bl = false;
        for (int i = 0; i < localRegion.pts.size() && i < 4000; ++i) {
            LocalPt localPt = (LocalPt)localRegion.pts.elementAt(i);
            if (localPt == null) continue;
            RssDiversionMouseAdapter._xpt[0] = localPt.x - 3;
            RssDiversionMouseAdapter._ypt[0] = localPt.y;
            RssDiversionMouseAdapter._xpt[1] = localPt.x;
            RssDiversionMouseAdapter._ypt[1] = localPt.y + 3;
            RssDiversionMouseAdapter._xpt[2] = localPt.x + 3;
            RssDiversionMouseAdapter._ypt[2] = localPt.y;
            RssDiversionMouseAdapter._xpt[3] = localPt.x;
            RssDiversionMouseAdapter._ypt[3] = localPt.y - 3;
            graphics.fillPolygon(_xpt, _ypt, 4);
            RssDiversionMouseAdapter._xp[bl] = localPt.x;
            RssDiversionMouseAdapter._yp[bl] = localPt.y;
            bl += 1;
        }
        graphics.drawPolygon(_xp, _yp, bl ? 1 : 0);
        graphics.setPaintMode();
        graphics.dispose();
    }

    void drawDiversionElement(DiversionElement diversionElement, boolean bl) {
        if (this._sysglyph == null || diversionElement == null) {
            return;
        }
        Graphics graphics = this._mapCanvas.getGraphics();
        this._sysglyph.drawSelectedDiversion(graphics, this._mapPanel.scale(), diversionElement, bl, this._editingDiv);
        graphics.dispose();
    }

    public Cursor getCursor() {
        if (this._divCursor == null) {
            return super.getCursor();
        }
        return this._divCursor;
    }
}

