/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import com.google.common.flogger.FluentLogger;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientMode;
import hec.clientapp.client.HecClientFrame;
import hec.clientapp.client.OptionDialog;
import hec.clientapp.client.OptionsDirectoryPanel;
import hec.gui.ExampleWatersheds;
import hec.model.WatershedLocation;
import hec.rss.RssRmiWorkspace;
import hec.rss.client.RSS;
import hec.rss.client.RSimNetworkMode;
import hec.rss.client.RSimSimulationMode;
import hec.rss.client.RssAltConfigMode;
import hec.rss.client.RssFrame$1;
import hec.rss.client.RssReportsTableListener;
import hec.rss.client.RssSysConfigMode;
import hec.rss.client.RssWatershedConfigMode;
import hec.rss.client.WatershedInfoAction;
import hec.rss.server.RssAdvancedOptions;
import hec.rss.wq.client.WaterQualityMode;
import hec.rss.wq.ui.WaterQualityOptionPanel;
import hec.watershed.client.ObjectChooser;
import hec.watershed.client.StationMouseAdapter;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import rma.swing.DefaultJPanel;
import rma.swing.RmaImage;
import rma.swing.RmaJFrame;
import rma.swing.RmaJTextField;

public class RssFrame
extends HecClientFrame
implements ActionListener,
ItemListener {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    private WaterQualityMode _wqMode;
    private boolean _wqMouseAdaptersAdded = false;
    RssWatershedConfigMode _watershedConfigMode;

    public RssFrame() {
        this.setSize(800, 600);
        this.setAlertPanel(false);
        this.setToolPanel(false);
        if (Boolean.getBoolean("oldrss")) {
            this.createModes();
        } else {
            this.createModes2();
        }
        Image image = RmaImage.loadURLImage((Component)((Object)this), (String)"Images/rss.gif");
        if (image != null) {
            this.setIconImage(image);
            RmaJFrame.setDefaultIconImage((Image)image);
        }
        this.setAppTitle("HEC-ResSim ");
        this.setIconMenuEnabled(false);
        this.updateTitle();
        this.resetWorkspace();
    }

    protected void buildMenus() {
        super.buildMenus();
        this.menuView.remove(this.iconMenu);
        Serializable serializable = this.menuFile.insert(new WatershedInfoAction(), 4);
        this.addWorkspaceEnabledComponent((Component)serializable);
        if (Desktop.isDesktopSupported()) {
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                serializable = new JMenuItem("User's Manual");
                ((AbstractButton)serializable).setActionCommand("usersManual");
                ((JComponent)serializable).setToolTipText("Opens the webpage to the ResSim User's Manual");
                ((AbstractButton)serializable).setIcon(RmaImage.getImageIcon((String)"Images/rss/webLink.gif"));
                ((AbstractButton)serializable).addActionListener(actionEvent -> this.browseUrl("User's Manual", "https://www.hec.usace.army.mil/confluence/ResSimDocs/rs4um"));
                int n = this.menuHelp.getMenuComponentCount();
                this.menuHelp.add((Component)serializable, n - 2);
                serializable = new JMenuItem("Online Resources");
                ((AbstractButton)serializable).setActionCommand("onlineResources");
                ((JComponent)serializable).setToolTipText("Opens the webpage for ResSim Online Resources");
                ((AbstractButton)serializable).setIcon(RmaImage.getImageIcon((String)"Images/rss/webLink.gif"));
                ((AbstractButton)serializable).addActionListener(actionEvent -> this.browseUrl("Online Resources", "https://www.hec.usace.army.mil/confluence/ResSimDocs"));
                n = this.menuHelp.getMenuComponentCount();
                this.menuHelp.add((Component)serializable, n - 2);
                serializable = new JMenuItem("Release Notes");
                ((AbstractButton)serializable).setActionCommand("releaseNotes");
                ((JComponent)serializable).setToolTipText("Opens the webpage to the ResSim Release Notes");
                ((AbstractButton)serializable).setIcon(RmaImage.getImageIcon((String)"Images/rss/webLink.gif"));
                ((AbstractButton)serializable).addActionListener(actionEvent -> this.browseUrl("Release Notes", "https://www.hec.usace.army.mil/confluence/ResSimDocs/rs4um/release-notes"));
                n = this.menuHelp.getMenuComponentCount();
                this.menuHelp.add((Component)serializable, n - 2);
            }
            if (((File)(serializable = new File("Examples/ExampleWatersheds.zip"))).exists()) {
                JMenuItem jMenuItem = new JMenuItem("Install Example Watersheds...");
                jMenuItem.setActionCommand("installExampleWatersheds");
                jMenuItem.addActionListener(this);
                int n = this.menuHelp.getMenuComponentCount();
                this.menuHelp.insertSeparator(n - 1);
                this.menuHelp.add((Component)jMenuItem, n - 1);
            }
        }
        this.menuItemAbout.setText("About HEC-ResSim");
    }

    private void browseUrl(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            return;
        }
        try {
            Desktop.getDesktop().browse(new URI(string2));
            return;
        }
        catch (IOException | URISyntaxException exception) {
            System.out.println("browseUrlError " + String.valueOf(exception));
            JOptionPane.showMessageDialog((Component)((Object)this), "Failed to display " + string + ".\nWeb page URL is " + string2, "Error", 0);
            return;
        }
    }

    private void launchPdf(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            return;
        }
        try {
            Desktop.getDesktop().open(new File(string2));
            return;
        }
        catch (IOException iOException) {
            System.out.println("launchPdf:Error " + String.valueOf(iOException));
            JOptionPane.showMessageDialog((Component)((Object)this), "Failed to display " + string + ".\nAcrobat Reader may not be installed or configured correctly.", "Error", 0);
            return;
        }
    }

    public void setRssApp(RSS rSS) {
        super.setApp((ClientApp)rSS);
    }

    public void updateTitle() {
        Object object = this.getAppTitle();
        ClientApp.app();
        if (ClientApp.Workspace() != null) {
            ClientApp.app();
            object = (String)object + " - " + ClientApp.Workspace().getTitleName();
        }
        this.setTitle((String)object);
    }

    protected String getHelpAboutImageFilename() {
        return "Images/rss/dam256contrastbrighter.gif";
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (!(object instanceof JButton) && object instanceof JMenuItem) {
            String string = ((AbstractButton)(object = (JMenuItem)object)).getActionCommand();
            if ("installExampleWatersheds".equals(string)) {
                this.installExampleWatershedsAction();
                return;
            }
            if ("quickStartGuide".equals(string)) {
                this.launchPdf("Quick Start Guide", ((Component)object).getName());
            } else if ("usersManual".equals(string)) {
                this.launchPdf("User's Manual", ((Component)object).getName());
            } else if ("releaseNotes".equals(string)) {
                this.launchPdf("Release Notes", ((Component)object).getName());
            }
        }
        super.actionPerformed(actionEvent);
    }

    private void installExampleWatershedsAction() {
        Object object = ClientApp.app().getWatershedLocations(false);
        if (object == null || ((Vector)object).size() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "There are no Watershed Locations defined.\nYou first need to define a Watershed Location", "No Watershed Locations", 1);
            this.menuItemOptions_Action(OptionsDirectoryPanel.class);
        }
        object = ClientApp.app().getWatershedLocations(false);
        ObjectChooser objectChooser = new ObjectChooser((Frame)((Object)this), true, 0, 1L);
        objectChooser.setTitle("Select Location ");
        objectChooser.setTitleLabel("Watershed Locations");
        objectChooser.setObjectList((Vector)object);
        objectChooser.setNamePanelBorderTitle("");
        objectChooser.setLocationRelativeTo((Component)((Object)this));
        objectChooser.setVisible(true);
        if (!objectChooser.ok()) {
            return;
        }
        object = (WatershedLocation)objectChooser.getSelectedObject();
        if (object == null) {
            return;
        }
        object = object.getDirectory();
        objectChooser = new ExampleWatersheds();
        objectChooser.installExampleWatersheds((String)object, null);
    }

    void menuSaveAll_Action(ActionEvent actionEvent) {
        ClientApp.Workspace().saveAllManagers();
    }

    void createModes2() {
        this._watershedConfigMode = new RssWatershedConfigMode(this);
        RssFrame rssFrame = this;
        rssFrame.addMode((ClientMode)rssFrame._watershedConfigMode);
        RssReportsTableListener rssReportsTableListener = new RSimNetworkMode(this);
        this.addMode((ClientMode)rssReportsTableListener);
        this._wqMode = new WaterQualityMode(this);
        rssReportsTableListener = new RSimSimulationMode(this);
        this.addMode((ClientMode)rssReportsTableListener);
    }

    void createModes() {
        this._watershedConfigMode = new RssWatershedConfigMode(this);
        RssFrame rssFrame = this;
        rssFrame.addMode((ClientMode)rssFrame._watershedConfigMode);
        ClientMode clientMode = new RssSysConfigMode(this);
        this.addMode(clientMode);
        clientMode = new RssAltConfigMode(this);
        this.addMode(clientMode);
        clientMode = new ClientMode((HecClientFrame)this);
        clientMode.setMenuName("Alternative Analysis");
        Object object = new RmaJTextField("Alternative Analysis");
        object.setEditable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridheight = 1;
        clientMode.addControlPanelComponent((Component)object, gridBagConstraints);
        object = new JSeparator();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.ipadx = 75;
        clientMode.addControlPanelComponent((Component)object, gridBagConstraints);
        object = new JButton("Run Setup...");
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 0;
        clientMode.addControlPanelComponent((Component)object, gridBagConstraints);
        this.addMode(clientMode, false);
    }

    public void menuItemOptions_Action(Class clazz) {
        this._optionsDialog = new OptionDialog((Frame)((Object)this), true, false);
        if (this.getAppTitle() != "") {
            this._optionsDialog.setTitle(this.getAppTitle() + " Options");
        }
        super.menuItemOptions_Action(clazz);
    }

    protected void menuItemSave_Action(ActionEvent actionEvent) {
        if (!ClientApp.app().saveWorkspace()) {
            ClientApp.app().postError("An unspecified problem was encountered during the Save process. The log files will contain additional details.", "Problem encountered during Save Action");
            return;
        }
        this.updateTitle();
    }

    public void helpAbout() {
        this.helpAbout("HEC-ResSim");
    }

    public static boolean classExists(String string) {
        try {
            Thread.currentThread().getContextClassLoader().loadClass(string);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public void setHasWaterQualityMode(boolean bl) {
        boolean bl2 = false;
        ClientMode[] clientModeArray = ClientApp.frame().getModes();
        for (int i = 0; i < clientModeArray.length; ++i) {
            if (!(clientModeArray[i] instanceof WaterQualityMode)) continue;
            bl2 = true;
            break;
        }
        if (bl) {
            if (!bl2) {
                this._watershedConfigMode.a(true);
                RssFrame rssFrame = this;
                rssFrame.addMode(rssFrame._wqMode, true, 2);
            }
            if (!this._wqMouseAdaptersAdded) {
                this._mapPanel.addMapToolClassLoader(string -> StationMouseAdapter.class);
                this._wqMouseAdaptersAdded = true;
                return;
            }
        } else if (bl2) {
            RssFrame rssFrame = this;
            rssFrame.removeMode(rssFrame._wqMode);
            this._watershedConfigMode.a(false);
        }
    }

    public void resetWorkspace() {
        super.resetWorkspace();
        if (ClientApp.Workspace() != null) {
            RssRmiWorkspace rssRmiWorkspace = (RssRmiWorkspace)ClientApp.Workspace().getChildWorkspace("rss");
            RssAdvancedOptions rssAdvancedOptions = null;
            try {
                rssAdvancedOptions = rssRmiWorkspace.getRssAdvancedOptions();
            }
            catch (RemoteException remoteException) {
                System.out.println("resetWorkspace:error getting ResSim Options " + String.valueOf(remoteException));
            }
            if (rssAdvancedOptions != null) {
                boolean bl = rssAdvancedOptions.hasWaterQuality();
                this.setHasWaterQualityMode(bl);
            }
            RssFrame$1 rssFrame$1 = new RssFrame$1(this);
            if (SwingUtilities.isEventDispatchThread()) {
                rssFrame$1.run();
                return;
            }
            try {
                SwingUtilities.invokeAndWait(rssFrame$1);
                return;
            }
            catch (Exception exception) {}
        }
    }

    public DefaultJPanel getWatershedDataAccessoryPanel() {
        return new WaterQualityOptionPanel();
    }
}

