/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.map.LocalPt;
import hec.map.LocalRect;
import hec.map.LocalRegion;
import hec.map.MapCanvas;
import hec.map.MapMouseAdapter;
import hec.map.MapPanel;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.streamAlignment.StreamAlignmentGlyph;
import hec.model.StreamElement;
import hec.rss.client.RSS;
import hec.rss.client.RssSystemGlyph;
import hec.rss.model.JunctionElement;
import hec.rss.model.RssNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.JOptionPane;
import rma.swing.RmaImage;

public class RssJuncMouseAdapter
extends MapMouseAdapter
implements MouseListener,
MouseMotionListener {
    public static final String POINTER_CURSOR = "JunctionCursor";
    RssSystemGlyph _sysglyph = null;
    StreamAlignmentGlyph _alignGlyph;
    Vector _ptVec = new Vector();
    Vector _nodeVec = new Vector();
    boolean _creatingRegion = false;
    boolean _editingRegion = false;
    LocalPt _beginPt = new LocalPt();
    LocalPt _endPt = new LocalPt();
    LocalPt _pt = new LocalPt();
    LocalPt _pt0 = new LocalPt();
    LocalPt _selectedPt = null;
    WorldPt _selectedWPt = null;
    LocalRect _lrc = new LocalRect();
    WorldRect _wrc = new WorldRect();
    JunctionElement _junc = null;
    StreamElement _stream = null;
    boolean _moving = false;
    private Cursor _juncCursor;
    static int[] _xpt = new int[4];
    static int[] _ypt = new int[4];
    static int[] _xp = new int[4000];
    static int[] _yp = new int[4000];

    public RssJuncMouseAdapter(MapPanel object, MapCanvas mapCanvas) {
        super(object, mapCanvas);
        try {
            object = RmaImage.loadURLImage((Component)mapCanvas, (String)"Images/pointers/JunctionCursor.gif");
            this._juncCursor = Toolkit.getDefaultToolkit().createCustomCursor((Image)object, new Point(0, 0), POINTER_CURSOR);
            return;
        }
        catch (Exception exception) {
            System.out.println("init:failed to find cursor image: Images/pointer/JunctionCursor.gif. Error:" + String.valueOf(exception));
            return;
        }
    }

    public void init() {
        this.findRssSystemGlyph();
    }

    public void abort() {
        this.findRssSystemGlyph();
        if (this._sysglyph != null) {
            this._sysglyph.clearSelection();
        }
        this._creatingRegion = false;
        this._editingRegion = false;
        this._junc = null;
    }

    boolean findStreamGlyph() {
        this._alignGlyph = (StreamAlignmentGlyph)this._mapPanel.findGlyphOfClass(StreamAlignmentGlyph.class.getName());
        return this._alignGlyph != null;
    }

    boolean findRssSystemGlyph() {
        this._sysglyph = (RssSystemGlyph)this._mapPanel.findGlyphOfClass(RssSystemGlyph.class.getName());
        return this._sysglyph != null;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this._moving && this._junc != null) {
            mouseEvent = this._mapPanel.scale().lp2wp(this._pt);
            double d = this._stream.getLine().getCoordAtLocation((WorldPt)mouseEvent);
            double d2 = this._stream.getStationByCoord(d);
            this._junc = this._sysglyph.moveJunction(this._junc, (WorldPt)mouseEvent, this._stream, d, d2);
            this._moving = false;
            this._mapPanel.paintMap();
            return;
        }
        if (!(this._creatingRegion && mouseEvent.isControlDown() || this._creatingRegion && !mouseEvent.isControlDown())) {
            if (!this._editingRegion && !this._creatingRegion && mouseEvent.isControlDown()) {
                if (!this.findRssSystemGlyph()) {
                    RSS.app();
                    JOptionPane.showMessageDialog((Component)ClientApp.frame(), "Please create/open a Reservoir Network first");
                    return;
                }
                if (!this.findStreamGlyph()) {
                    RSS.app();
                    JOptionPane.showMessageDialog((Component)ClientApp.frame(), "Please create a Stream Alignment first");
                    return;
                }
                if (!this._sysglyph.isWriteLocked()) {
                    JOptionPane.showMessageDialog((Component)this._mapPanel, "You must first lock the Reservoir Network.", "Cannot Create Junction", 1);
                    return;
                }
                this._pt0.init(mouseEvent.getX(), mouseEvent.getY());
                this._pt.init(this._pt0);
                this._selectedWPt = this._mapPanel.scale().lp2wp(this._pt0);
                mouseEvent = this._alignGlyph.findReach(this._selectedWPt);
                if (mouseEvent == null) {
                    JOptionPane.showMessageDialog((Component)this._mapPanel, "Junctions must be placed on a stream", "Cannot Create Junction", 1);
                    return;
                }
                if (this._sysglyph.findReach(this._selectedWPt) != null) {
                    JOptionPane.showMessageDialog((Component)this._mapPanel, "Junctions cannot be placed in a Reach", "Cannot Create Junction", 1);
                    return;
                }
                if (this._sysglyph.findReservoir(this._selectedWPt) != null) {
                    JOptionPane.showMessageDialog((Component)this._mapPanel, "Junctions cannot be placed in a Reservoir", "Cannot Create Junction", 1);
                    return;
                }
                double d = mouseEvent.getStationByLocation(this._selectedWPt);
                WorldPt worldPt = mouseEvent.getLocationByStation(d);
                this._junc = this._sysglyph.createJunctionElement(worldPt);
                if (this._junc == null) {
                    return;
                }
                if (this._junc.getNodeCount() == 0) {
                    if (this._junc.getStream() != null) {
                        mouseEvent = this._junc.getStream();
                    }
                    d = mouseEvent.getStationByLocation(worldPt);
                    RssNode rssNode = this._sysglyph._sysmap.createNode(worldPt);
                    rssNode.setStream((StreamElement)mouseEvent);
                    this._junc.addNode(rssNode, 0);
                    this._junc.setStreamStation((StreamElement)mouseEvent, d);
                }
                this._sysglyph._sysmap.setModified(true);
                this._mapPanel.paintMap();
                return;
            }
            if (this._selectedPt == null && (mouseEvent.isPopupTrigger() || RssJuncMouseAdapter.pressedButton3((MouseEvent)mouseEvent)) && !this.findRssSystemGlyph()) {
                return;
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent object) {
        if (((MouseEvent)object).isPopupTrigger() || RssJuncMouseAdapter.pressedButton3((MouseEvent)object)) {
            if (!this.findRssSystemGlyph()) {
                return;
            }
            object = new LocalPt(((MouseEvent)object).getX(), ((MouseEvent)object).getY());
            this._sysglyph.junctionPopupMenu((LocalPt)object);
            return;
        }
        if (!this._creatingRegion && (this._creatingRegion || !((InputEvent)object).isControlDown()) && this._editingRegion && this._junc != null && this._stream != null) {
            this._pt.init(((MouseEvent)object).getX(), ((MouseEvent)object).getY());
            this._pt0.init(this._pt);
            object = new LocalPt();
            WorldPt worldPt = this._junc.getReferencePt();
            this._mapPanel.scale().wp2lp(worldPt, (LocalPt)object);
            this._lrc.init(this._pt.x - 8, this._pt.y - 8, this._pt.x + 8, this._pt.y + 8);
            if (!this._lrc.contains((LocalPt)object)) {
                return;
            }
            worldPt = this._mapPanel.scale().lp2wp(this._pt);
            double d = this._stream.getLine().getCoordAtLocation(worldPt);
            this._stream.getStationByCoord(d);
            object = this._mapPanel.scale().wp2lp(this._stream.getLocationByCoord(d));
            this._pt.init((LocalPt)object);
            object = this._mapCanvas.getGraphics();
            ((Graphics)object).setXORMode(new Color(255, 255, 255));
            ((Graphics)object).fillRect(this._pt.x - 5, this._pt.y - 5, 10, 10);
            ((Graphics)object).setPaintMode();
            ((Graphics)object).dispose();
            this._moving = true;
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent object) {
        if (this._editingRegion && this._junc != null && this._moving) {
            Graphics graphics = this._mapCanvas.getGraphics();
            graphics.setXORMode(new Color(255, 255, 255));
            graphics.fillRect(this._pt.x - 5, this._pt.y - 5, 10, 10);
            object = new LocalPt(((MouseEvent)object).getX(), ((MouseEvent)object).getY());
            object = this._mapPanel.scale().lp2wp((LocalPt)object);
            double d = this._stream.getLine().getCoordAtLocation((WorldPt)object);
            this._stream.getStationByCoord(d);
            double d2 = this._junc.getDownstreamNode().getStreamCoord();
            if (d < d2) {
                object = this._sysglyph.findDownstreamNode(this._stream, d2);
                if (object != null && d < ((RssNode)object).getStreamCoord()) {
                    d = ((RssNode)object).getStreamCoord();
                }
            } else {
                object = this._sysglyph.findUpstreamNode(this._stream, d2);
                if (object != null && d > ((RssNode)object).getStreamCoord()) {
                    d = ((RssNode)object).getStreamCoord();
                }
            }
            object = this._mapPanel.scale().wp2lp(this._stream.getLocationByCoord(d));
            this._pt.init((LocalPt)object);
            graphics.fillRect(this._pt.x - 5, this._pt.y - 5, 10, 10);
            graphics.setPaintMode();
            graphics.dispose();
        }
    }

    @Override
    public void mouseClicked(MouseEvent object) {
        if (!this._creatingRegion && ((MouseEvent)object).getClickCount() == 2) {
            if (!this.findRssSystemGlyph()) {
                RSS.app();
                JOptionPane.showMessageDialog((Component)ClientApp.frame(), "Please create/open a Reservoir Network first");
                return;
            }
            if (!this._sysglyph.isWriteLocked()) {
                JOptionPane.showMessageDialog((Component)this._mapPanel, "You must first lock the Reservoir Network.", "Cannot Edit Junction", 1);
                return;
            }
            this._pt.init(((MouseEvent)object).getX(), ((MouseEvent)object).getY());
            object = this._sysglyph.selectJunction(this._pt, false, false);
            if (object != null && ((JunctionElement)object).getComputationPointId() == Long.MIN_VALUE) {
                this._sysglyph.selectJunction(this._pt, false, true);
                this._editingRegion = true;
                this._stream = ((JunctionElement)object).getStream();
            } else if (object != null) {
                JOptionPane.showMessageDialog((Component)this._mapPanel, "Edit the Common Computation Point associated with this Junction in the Watershed Setup Module, then update this Network", "ResSim Message", 1);
            } else {
                this._editingRegion = false;
                this._stream = null;
            }
            this._junc = object;
            return;
        }
        if (!this._editingRegion) {
            if (!this.findRssSystemGlyph()) {
                return;
            }
            this._pt.init(((MouseEvent)object).getX(), ((MouseEvent)object).getY());
            object = this._sysglyph.selectJunction(this._pt, false, false);
            this._editingRegion = false;
            this._junc = object;
        }
    }

    void drawPt(LocalPt localPt, boolean bl) {
        Graphics graphics = this._mapCanvas.getGraphics();
        if (bl) {
            graphics.setXORMode(new Color(255, 255, 255));
        } else {
            graphics.setColor(Color.black);
        }
        RssJuncMouseAdapter._xpt[0] = localPt.x - 3;
        RssJuncMouseAdapter._ypt[0] = localPt.y;
        RssJuncMouseAdapter._xpt[1] = localPt.x;
        RssJuncMouseAdapter._ypt[1] = localPt.y + 3;
        RssJuncMouseAdapter._xpt[2] = localPt.x + 3;
        RssJuncMouseAdapter._ypt[2] = localPt.y;
        RssJuncMouseAdapter._xpt[3] = localPt.x;
        RssJuncMouseAdapter._ypt[3] = localPt.y - 3;
        graphics.fillPolygon(_xpt, _ypt, 4);
        graphics.setPaintMode();
        graphics.dispose();
    }

    void drawRegion(LocalRegion localRegion, boolean bl) {
        Graphics graphics = this._mapCanvas.getGraphics();
        if (bl) {
            graphics.setXORMode(new Color(255, 255, 255));
        } else {
            graphics.setColor(Color.black);
        }
        bl = false;
        for (int i = 0; i < localRegion.pts.size() && i < 4000; ++i) {
            LocalPt localPt = (LocalPt)localRegion.pts.elementAt(i);
            if (localPt == null) continue;
            RssJuncMouseAdapter._xpt[0] = localPt.x - 3;
            RssJuncMouseAdapter._ypt[0] = localPt.y;
            RssJuncMouseAdapter._xpt[1] = localPt.x;
            RssJuncMouseAdapter._ypt[1] = localPt.y + 3;
            RssJuncMouseAdapter._xpt[2] = localPt.x + 3;
            RssJuncMouseAdapter._ypt[2] = localPt.y;
            RssJuncMouseAdapter._xpt[3] = localPt.x;
            RssJuncMouseAdapter._ypt[3] = localPt.y - 3;
            graphics.fillPolygon(_xpt, _ypt, 4);
            RssJuncMouseAdapter._xp[bl] = localPt.x;
            RssJuncMouseAdapter._yp[bl] = localPt.y;
            bl += 1;
        }
        graphics.drawPolygon(_xp, _yp, bl ? 1 : 0);
        graphics.setPaintMode();
        graphics.dispose();
    }

    void drawJunc(JunctionElement junctionElement, boolean bl) {
        if (this._sysglyph == null || junctionElement == null) {
            return;
        }
        Graphics graphics = this._mapCanvas.getGraphics();
        this._sysglyph.drawSelectedJunction(graphics, this._mapPanel.scale(), junctionElement, bl, this._editingRegion);
        graphics.dispose();
    }

    public Cursor getCursor() {
        if (this._juncCursor == null) {
            return super.getCursor();
        }
        return this._juncCursor;
    }
}

