/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.map.LocalPt;
import hec.map.MapCanvas;
import hec.map.MapMouseAdapter;
import hec.map.MapPanel;
import hec.rss.client.RssSystemGlyph;
import hec.rss.model.DiversionElement;
import hec.rss.model.Element;
import hec.rss.model.JunctionElement;
import hec.rss.model.ReachElement;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssNode;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class RssNetworkConnectivityAdapter
extends MapMouseAdapter
implements ActionListener {
    private RssSystemGlyph _sysglyph;
    private Element _elem;
    private List<Element> _selections = new ArrayList<Element>();

    public RssNetworkConnectivityAdapter(MapPanel mapPanel, MapCanvas mapCanvas) {
        super(mapPanel, mapCanvas);
    }

    public void init() {
        this.findGlyph();
    }

    public void abort() {
        this.findGlyph();
        if (this._sysglyph != null) {
            this._sysglyph.clearSelection();
        }
    }

    boolean findGlyph() {
        this._sysglyph = (RssSystemGlyph)this._mapPanel.findGlyphOfClass(RssSystemGlyph.class.getName());
        return this._sysglyph != null;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.findGlyph()) {
            return;
        }
        if (mouseEvent.isPopupTrigger() || RssNetworkConnectivityAdapter.pressedButton3((MouseEvent)mouseEvent)) {
            this._sysglyph.clearSelection();
            Object object = new LocalPt(mouseEvent.getX(), mouseEvent.getY());
            object = this._sysglyph.findObject((LocalPt)object);
            if (object instanceof Element) {
                this._elem = (Element)object;
                this._sysglyph.addSelection(this._elem, false);
                object = new JPopupMenu();
                JMenuItem jMenuItem = new JMenuItem("Show Upstream Connectivity");
                jMenuItem.setActionCommand("upstreamConnectivity");
                jMenuItem.addActionListener(this);
                ((JPopupMenu)object).add(jMenuItem);
                jMenuItem = new JMenuItem("Show Downstream Connectivity");
                jMenuItem.setActionCommand("downstreamConnectivity");
                jMenuItem.addActionListener(this);
                ((JPopupMenu)object).add(jMenuItem);
                ((JPopupMenu)object).show((Component)this._mapPanel.viewport(), mouseEvent.getX(), mouseEvent.getY());
            }
            return;
        }
        this._sysglyph.clearSelection();
        LocalPt localPt = new LocalPt(mouseEvent.getX(), mouseEvent.getY());
        localPt = this._sysglyph.findObject(localPt);
        if (localPt instanceof Element) {
            this._elem = (Element)localPt;
            this.upstreamConnectivity(true);
            this._selections.remove(this._elem);
            this.downstreamConnectivity(false);
            this._selections.clear();
        }
    }

    @Override
    public void actionPerformed(ActionEvent object) {
        if (!((object = ((EventObject)object).getSource()) instanceof JMenuItem)) {
            return;
        }
        object = (JMenuItem)object;
        if ("upstreamConnectivity".equals(object = ((AbstractButton)object).getActionCommand())) {
            this.upstreamConnectivity(true);
        } else if ("downstreamConnectivity".equals(object)) {
            this.downstreamConnectivity(true);
        }
        this._selections.clear();
    }

    private void downstreamConnectivity(boolean bl) {
        if (!this.findGlyph()) {
            return;
        }
        if (bl) {
            this._sysglyph.clearSelection();
        }
        RssNetworkConnectivityAdapter rssNetworkConnectivityAdapter = this;
        rssNetworkConnectivityAdapter.selectElement(rssNetworkConnectivityAdapter._elem, 0);
        this._sysglyph.addSelections(this._selections, false);
    }

    private void upstreamConnectivity(boolean bl) {
        if (!this.findGlyph()) {
            return;
        }
        if (bl) {
            this._sysglyph.clearSelection();
        }
        RssNetworkConnectivityAdapter rssNetworkConnectivityAdapter = this;
        rssNetworkConnectivityAdapter.selectElement(rssNetworkConnectivityAdapter._elem, 1);
        this._sysglyph.addSelections(this._selections, false);
    }

    private void selectNode(RssNode rssReturnStatusConstants, int n) {
        rssReturnStatusConstants = n == 1 ? rssReturnStatusConstants.getUpstreamElement() : rssReturnStatusConstants.getDownstreamElement();
        if (rssReturnStatusConstants == null) {
            return;
        }
        this.selectElement((Element)rssReturnStatusConstants, n);
    }

    private void selectElement(Element object, int n) {
        if (object == null || this._selections.contains(object)) {
            return;
        }
        System.out.println("selectElement:selecting " + String.valueOf(object));
        if (object instanceof ReservoirElement) {
            this._selections.add((Element)object);
            ReservoirElement cfr_ignored_0 = (ReservoirElement)object;
            Vector vector = ((Element)object).getNodeVector();
            Vector vector2 = ((Element)object).getNodeDirVector();
            for (int i = 0; i < vector.size(); ++i) {
                object = (Integer)vector2.get(i);
                if ((Integer)object != n) continue;
                RssNode rssNode = (RssNode)vector.get(i);
                this.selectNode(rssNode, n);
            }
            return;
        }
        if (object instanceof JunctionElement) {
            this._selections.add((Element)object);
            JunctionElement cfr_ignored_1 = (JunctionElement)object;
            Vector vector = ((Element)object).getNodeVector();
            Vector vector3 = ((Element)object).getNodeDirVector();
            for (int i = 0; i < vector.size(); ++i) {
                RssNode rssNode;
                object = (Integer)vector3.get(i);
                if ((Integer)object == n) {
                    rssNode = (RssNode)vector.get(i);
                    this.selectNode(rssNode, n);
                    continue;
                }
                rssNode = (RssNode)vector.get(i);
                if (n != 0 || rssNode.getUpstreamElement() == null || !(rssNode.getUpstreamElement().getParent() instanceof DiversionElement)) continue;
                object = (DiversionElement)rssNode.getUpstreamElement().getParent();
                this._selections.add((Element)object);
                object = ((Element)object).getNodeVector();
                if (((Vector)object).size() <= 1) continue;
                this.selectNode((RssNode)((Vector)object).get(1), n);
            }
            return;
        }
        if (object instanceof ReachElement) {
            this._selections.add((Element)object);
            RssNode rssNode = n == 1 ? ((Element)object).getUpstreamNode() : ((Element)object).getDownstreamNode();
            if (rssNode != null) {
                this.selectNode(rssNode, n);
            }
            return;
        }
        if (object instanceof DiversionElement) {
            this._selections.add((Element)object);
            Object object2 = ((Element)object).getNodeVector();
            if (n == 1 && ((Vector)object2).size() > 0) {
                object2 = (RssNode)((Vector)object2).get(0);
                object = ((RssNode)object2).getDownstreamElement();
                this.selectElement((Element)object, n);
            }
            return;
        }
        if (n == 1 || n == 0) {
            Element element = ((Element)object).getParent();
            if (element != null) {
                this.selectElement(element, n);
                return;
            }
            this.selectUpstreamNodes((Element)object, n);
            return;
        }
        int n2 = ((Element)object).getChildElementCount();
        for (int i = 0; i < n2; ++i) {
            Element element = ((Element)object).getChildElementAt(i);
            this._selections.add(element);
        }
    }

    private void selectUpstreamNodes(Element object, int n) {
        Vector vector = ((Element)object).getNodeVector();
        object = ((Element)object).getNodeDirVector();
        for (int i = 0; i < vector.size(); ++i) {
            Object object2 = (Integer)((Vector)object).get(i);
            if ((Integer)object2 != n) continue;
            object2 = (RssNode)vector.get(i);
            this.selectNode((RssNode)object2, n);
        }
    }
}

