/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.map.LocalPt;
import hec.map.LocalRect;
import hec.map.LocalRegion;
import hec.map.MapCanvas;
import hec.map.MapGlyph;
import hec.map.MapMouseAdapter;
import hec.map.MapPanel;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.streamAlignment.StreamAlignmentGlyph;
import hec.model.StreamElement;
import hec.rss.client.RSS;
import hec.rss.client.RssSystemGlyph;
import hec.rss.model.Element;
import hec.rss.model.ReachElement;
import hec.rss.model.RssNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import rma.swing.RmaImage;

public class RssRchMouseAdapter
extends MapMouseAdapter
implements MouseListener,
MouseMotionListener {
    public static final String POINTER_CURSOR = "ReachCursor";
    RssSystemGlyph _sysglyph = null;
    StreamAlignmentGlyph _alignglyph = null;
    Vector _ptVec = new Vector();
    boolean _creatingRch = false;
    boolean _editingRch = false;
    LocalPt _beginPt = new LocalPt();
    LocalPt _endPt = new LocalPt();
    LocalPt _pt = new LocalPt();
    LocalPt _pt0 = new LocalPt();
    LocalPt _selectedPt = null;
    WorldPt _selectedWPt = null;
    LocalRect _lrc = new LocalRect();
    WorldRect _wrc = new WorldRect();
    ReachElement _reach = null;
    StreamElement _stream = null;
    RssNode _rchNode0 = null;
    RssNode _rchNode1 = null;
    boolean _moving = false;
    Cursor _reachCursor;
    static int[] _xpt = new int[4];
    static int[] _ypt = new int[4];
    static int[] _xp = new int[4000];
    static int[] _yp = new int[4000];

    public RssRchMouseAdapter(MapPanel object, MapCanvas mapCanvas) {
        super(object, mapCanvas);
        try {
            object = RmaImage.loadURLImage((Component)mapCanvas, (String)"Images/pointers/ReachCursor.gif");
            this._reachCursor = Toolkit.getDefaultToolkit().createCustomCursor((Image)object, new Point(0, 0), POINTER_CURSOR);
            return;
        }
        catch (Exception exception) {
            System.out.println("init:failed to find cursor image: Images/pointer/ReachCursor.gif. Error:" + String.valueOf(exception));
            return;
        }
    }

    public void init() {
        this.findGlyph();
    }

    public void abort() {
        this.findGlyph();
        if (this._sysglyph != null) {
            this._sysglyph.clearSelection();
        }
        this._creatingRch = false;
        this._editingRch = false;
        this._reach = null;
    }

    boolean findGlyph() {
        this._sysglyph = null;
        this._alignglyph = null;
        List list = this._mapPanel.managerGlyphList();
        for (int i = 0; i < list.size(); ++i) {
            MapGlyph mapGlyph = (MapGlyph)list.get(i);
            if (mapGlyph == null) continue;
            if (mapGlyph instanceof RssSystemGlyph) {
                this._sysglyph = (RssSystemGlyph)mapGlyph;
            }
            if (mapGlyph instanceof StreamAlignmentGlyph) {
                this._alignglyph = (StreamAlignmentGlyph)mapGlyph;
            }
            if (this._sysglyph == null || this._alignglyph == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this._creatingRch) {
            if (this._pt.equals(this._pt0)) {
                this._creatingRch = false;
                if (this._rchNode0 != null && this._rchNode0.getUpstreamElement() == null && this._rchNode0.getDownstreamElement() == null) {
                    this._sysglyph.getDeleteNode(this._rchNode0);
                }
                this._rchNode0 = null;
                this._rchNode1 = null;
                this._moving = false;
                return;
            }
            this._rchNode1 = this._sysglyph.createReachNode(this._pt, this._stream, this._rchNode0);
            if (this._rchNode1 != null) {
                this._creatingRch = false;
                this._pt = this._mapPanel.scale().wp2lp(this._rchNode1.getLocation());
                this._ptVec.addElement(new LocalPt(this._pt));
                this._sysglyph.createReach(this._rchNode0, this._rchNode1, this._pt);
                this._rchNode0 = null;
                this._rchNode1 = null;
                this._stream = null;
                this._moving = false;
                return;
            }
        } else if (!this._creatingRch && mouseEvent.isControlDown()) {
            if (!this.findGlyph()) {
                JOptionPane.showMessageDialog((Component)RSS.frame(), "Please create/open a Reservoir Network first");
                return;
            }
            if (!this._sysglyph.isWriteLocked()) {
                JOptionPane.showMessageDialog((Component)this._mapPanel, "You must first lock the Reservoir Network.", "Cannot Create Reach", 1);
                return;
            }
            this._ptVec.removeAllElements();
            this._pt0.init(mouseEvent.getX(), mouseEvent.getY());
            this._pt.init(this._pt0);
            this._rchNode0 = this._sysglyph.createReachNode(this._pt, null, null);
            if (this._rchNode0 != null) {
                this._creatingRch = true;
                this._stream = this._alignglyph.findReach(this._rchNode0.getStreamIndex());
                this._mapPanel.printStatus("Creating Reach on Stream " + this._stream.getName());
                this._pt0 = this._mapPanel.scale().wp2lp(this._rchNode0.getLocation());
                this._pt.init(this._pt0);
                RssRchMouseAdapter rssRchMouseAdapter = this;
                rssRchMouseAdapter.drawPt(rssRchMouseAdapter._pt, true);
                this._moving = false;
                this._ptVec.addElement(new LocalPt(this._pt));
                return;
            }
        } else {
            if (this._selectedPt != null) {
                this._selectedPt = null;
                this._selectedWPt = null;
                this._mapPanel.paintMap();
                return;
            }
            if (!mouseEvent.isPopupTrigger()) {
                RssRchMouseAdapter.pressedButton3((MouseEvent)mouseEvent);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        LocalPt localPt;
        if (mouseEvent.isPopupTrigger() || RssRchMouseAdapter.pressedButton3((MouseEvent)mouseEvent)) {
            if (!this.findGlyph()) {
                return;
            }
            localPt = new LocalPt(mouseEvent.getX(), mouseEvent.getY());
            this._sysglyph.reachPopupMenu(localPt);
        }
        if (!this._creatingRch && this._editingRch && this._reach != null) {
            this._pt.init(mouseEvent.getX(), mouseEvent.getY());
            this._pt0.init(this._pt);
            localPt = new LocalPt();
            mouseEvent = ((Element)this._reach).getReferencePt();
            this._mapPanel.scale().wp2lp((WorldPt)mouseEvent, localPt);
            this._lrc.init(this._pt.x - 8, this._pt.y - 8, this._pt.x + 8, this._pt.y + 8);
            if (this._lrc.contains(localPt)) {
                this._selectedPt = localPt;
                this._selectedWPt = mouseEvent;
                return;
            }
            this._lrc.init(this._pt.x - 3, this._pt.y - 3, this._pt.x + 3, this._pt.y + 3);
            for (int i = 0; i < this._reach.getLine().pts.size(); ++i) {
                mouseEvent = (WorldPt)this._reach.getLine().pts.elementAt(i);
                if (mouseEvent == null) continue;
                this._mapPanel.scale().wp2lp((WorldPt)mouseEvent, localPt);
                if (!this._lrc.contains(localPt)) continue;
                this._selectedPt = localPt;
                this._selectedWPt = mouseEvent;
                return;
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent object) {
        if (this._creatingRch && this._rchNode0 != null) {
            double d;
            Graphics graphics = this._mapCanvas.getGraphics();
            graphics.setXORMode(new Color(255, 255, 255));
            graphics.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
            if (!this._pt.equals(this._pt0)) {
                RssRchMouseAdapter rssRchMouseAdapter = this;
                rssRchMouseAdapter.drawPt(rssRchMouseAdapter._pt, true);
            }
            this._moving = true;
            object = new LocalPt(((MouseEvent)object).getX(), ((MouseEvent)object).getY());
            object = this._mapPanel.scale().lp2wp((LocalPt)object);
            double d2 = this._stream.getLine().getCoordAtLocation((WorldPt)object);
            if (d >= this._rchNode0.getStreamCoord()) {
                d2 = this._rchNode0.getStreamCoord();
            }
            if ((object = this._sysglyph.findDownstreamNode(this._stream, this._rchNode0.getStreamCoord())) != null && d2 < ((RssNode)object).getStreamCoord()) {
                d2 = ((RssNode)object).getStreamCoord();
            }
            object = this._mapPanel.scale().wp2lp(this._stream.getLocationByCoord(d2));
            this._pt.init((LocalPt)object);
            graphics.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
            if (!this._pt.equals(this._pt0)) {
                RssRchMouseAdapter rssRchMouseAdapter = this;
                rssRchMouseAdapter.drawPt(rssRchMouseAdapter._pt, true);
            }
            graphics.setPaintMode();
            graphics.dispose();
            return;
        }
        super.mouseMoved((MouseEvent)object);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this._selectedPt != null && this._reach != null) {
            RssRchMouseAdapter rssRchMouseAdapter = this;
            rssRchMouseAdapter.drawImpactRegion(rssRchMouseAdapter._reach, true);
            this._selectedPt.init(mouseEvent.getX(), mouseEvent.getY());
            this._mapPanel.scale().lp2wp(this._selectedPt, this._selectedWPt);
            RssRchMouseAdapter rssRchMouseAdapter2 = this;
            rssRchMouseAdapter2.drawImpactRegion(rssRchMouseAdapter2._reach, true);
        }
    }

    @Override
    public void mouseClicked(MouseEvent object) {
        if (!this._creatingRch) {
            if (((MouseEvent)object).getClickCount() == 2) {
                if (!this.findGlyph()) {
                    return;
                }
                if (!this._sysglyph.isWriteLocked()) {
                    JOptionPane.showMessageDialog((Component)this._mapPanel, "You must first lock the Reservoir Network.", "Cannot Edit Reach", 1);
                    return;
                }
                this._pt.init(((MouseEvent)object).getX(), ((MouseEvent)object).getY());
                object = this._sysglyph.selectReach(this._pt, false, true);
                this._editingRch = object != null;
                this._reach = object;
                return;
            }
            if (!this._editingRch) {
                if (!this.findGlyph()) {
                    return;
                }
                this._pt.init(((MouseEvent)object).getX(), ((MouseEvent)object).getY());
                object = this._sysglyph.selectReach(this._pt, ((InputEvent)object).isShiftDown(), false);
                this._editingRch = false;
                this._reach = object;
            }
        }
    }

    void drawPt(LocalPt localPt, boolean bl) {
        Graphics graphics = this._mapCanvas.getGraphics();
        if (bl) {
            graphics.setXORMode(new Color(255, 255, 255));
        } else {
            graphics.setColor(Color.black);
        }
        RssRchMouseAdapter._xpt[0] = localPt.x - 5;
        RssRchMouseAdapter._ypt[0] = localPt.y;
        RssRchMouseAdapter._xpt[1] = localPt.x;
        RssRchMouseAdapter._ypt[1] = localPt.y + 5;
        RssRchMouseAdapter._xpt[2] = localPt.x + 5;
        RssRchMouseAdapter._ypt[2] = localPt.y;
        RssRchMouseAdapter._xpt[3] = localPt.x;
        RssRchMouseAdapter._ypt[3] = localPt.y - 5;
        graphics.fillPolygon(_xpt, _ypt, 4);
        graphics.setPaintMode();
        graphics.dispose();
    }

    void drawRegion(LocalRegion localRegion, boolean bl) {
        Graphics graphics = this._mapCanvas.getGraphics();
        if (bl) {
            graphics.setXORMode(new Color(255, 255, 255));
        } else {
            graphics.setColor(Color.black);
        }
        bl = false;
        for (int i = 0; i < localRegion.pts.size() && i < 4000; ++i) {
            LocalPt localPt = (LocalPt)localRegion.pts.elementAt(i);
            if (localPt == null) continue;
            RssRchMouseAdapter._xpt[0] = localPt.x - 5;
            RssRchMouseAdapter._ypt[0] = localPt.y;
            RssRchMouseAdapter._xpt[1] = localPt.x;
            RssRchMouseAdapter._ypt[1] = localPt.y + 5;
            RssRchMouseAdapter._xpt[2] = localPt.x + 5;
            RssRchMouseAdapter._ypt[2] = localPt.y;
            RssRchMouseAdapter._xpt[3] = localPt.x;
            RssRchMouseAdapter._ypt[3] = localPt.y - 5;
            graphics.fillPolygon(_xpt, _ypt, 4);
            RssRchMouseAdapter._xp[bl] = localPt.x;
            RssRchMouseAdapter._yp[bl] = localPt.y;
            bl += 1;
        }
        graphics.drawPolygon(_xp, _yp, bl ? 1 : 0);
        graphics.setPaintMode();
        graphics.dispose();
    }

    void drawImpactRegion(ReachElement reachElement, boolean bl) {
        if (this._sysglyph == null || reachElement == null) {
            return;
        }
        Graphics graphics = this._mapCanvas.getGraphics();
        this._sysglyph.drawSelectedReach(graphics, this._mapPanel.scale(), reachElement, bl, this._editingRch);
        graphics.dispose();
    }

    public Cursor getCursor() {
        if (this._reachCursor == null) {
            return super.getCursor();
        }
        return this._reachCursor;
    }
}

