/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.model.AbstractSimulation;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.clientapp.model.SimulationRun;
import hec.io.Identifier;
import hec.model.RunInfo;
import hec.rss.client.reports.PrintableReport;
import hec.rss.model.RssRun;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.JTableHeader;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaInsets;
import rma.swing.RmaJLabel;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextArea;
import rma.swing.print.PageText;
import rma.swing.table.GroupableTableHeader;
import rma.util.RMAIO;

public class RssReportsJPanel
extends JPanel
implements PrintableReport {
    protected RmaJTable rTbl_table;
    protected RmaJTextArea _footerTxtArea;
    private JScrollPane _sp;
    protected List _runvec = null;
    private List<Identifier> _runsIdsVector = null;
    private Vector _runNames;
    private String _wkspPath;
    private String[] titleHeader = new String[2];
    private Object[] titleCriteria = new Object[3];
    private List<String> _failedRunNames;
    protected ManagerProxyListContainer _wksp;

    public RssReportsJPanel(Vector vector, String string, int n, ManagerProxyListContainer managerProxyListContainer) {
        this._wksp = managerProxyListContainer;
        this._runNames = vector;
        this._wkspPath = string;
        this.getRunVec(vector, string, managerProxyListContainer);
        RssReportsJPanel rssReportsJPanel = this;
        rssReportsJPanel.init(rssReportsJPanel._runvec, n);
    }

    public RssReportsJPanel(Vector vector, int n) {
        this._wksp = ClientApp.Workspace();
        this.init(vector, n);
    }

    public RssReportsJPanel(String[] stringArray, String[] stringArray2, boolean bl) {
        this._wksp = ClientApp.Workspace();
        if (bl) {
            this.rTbl_table = new RmaJTable((Component)this);
            this.rTbl_table.setTableHeader((JTableHeader)new GroupableTableHeader(this.rTbl_table.getColumnModel()));
        } else {
            this.rTbl_table = new RmaJTable((Component)this);
        }
        this._sp = this.rTbl_table.getScrollPane();
        this.rTbl_table.setUnitsHeaderRenderer();
        this.titleHeader = stringArray;
        this.titleCriteria = stringArray2;
        this.makeForm();
    }

    public RssReportsJPanel(List<SimulationRun> list, int n, AbstractSimulation abstractSimulation, String string) {
        this._wksp = abstractSimulation;
        this._runvec = this.getRunVec(list, string, abstractSimulation);
        RssReportsJPanel rssReportsJPanel = this;
        rssReportsJPanel.init(rssReportsJPanel._runvec, n);
    }

    public void closeRuns() {
        if (this._wksp == null) {
            return;
        }
        for (int i = 0; i < this._runsIdsVector.size(); ++i) {
            Identifier identifier = this._runsIdsVector.get(i);
            if (identifier == null) continue;
            this._wksp.unloadManager("rss", identifier);
        }
    }

    public List getRunVec(Vector vector, String string) {
        return this.getRunVec(vector, string, this._wksp);
    }

    public List getRunVec(List<SimulationRun> object, String string, AbstractSimulation abstractSimulation) {
        Object object2;
        int n;
        new ArrayList();
        RmiFileManager rmiFileManager = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        Object object3 = new ArrayList();
        this._runvec = new ArrayList();
        this._runsIdsVector = new Vector<Identifier>();
        this._failedRunNames = new ArrayList<String>();
        for (n = 0; n < object.size(); ++n) {
            object2 = object.get(n);
            if (object2 instanceof SimulationRun) {
                object3 = object2;
                object3 = object3.getModelNames("rss");
                object3.size();
                continue;
            }
            if (!(object2 instanceof RunInfo)) continue;
            object2 = (RunInfo)object2;
            object3.add(object2.runName);
        }
        int n2 = object3.size();
        ArrayList<SimulationRun> arrayList = n2 > 1 ? new ArrayList<SimulationRun>(n2) : null;
        for (n = 0; n < n2; ++n) {
            object = (String)object3.get(n);
            object2 = RMAIO.userNameToFileName((String)object);
            if ((object2 = this.getRunId((String)object2, string, rmiFileManager)) == null) {
                object2 = this.getRunId((String)object, string, rmiFileManager);
            }
            if (object2 == null) {
                System.out.println("Failed to open ResSim Run file for " + (String)object);
                this._failedRunNames.add((String)object);
                continue;
            }
            if ((object = this.getRssRun((ManagerProxyListContainer)abstractSimulation, (Identifier)object2, (String)object, abstractSimulation.getOutputDSSFilePath())) == null) continue;
            object2 = new RunInfo(object.getName(), object.getDisplayName());
            new RunInfo(object.getName(), object.getDisplayName()).run = object;
            if (arrayList != null) {
                arrayList.add((SimulationRun)object2);
            } else {
                this._runvec.add(object2);
            }
            this._runsIdsVector.add(object.getIdentifier());
        }
        if (arrayList != null) {
            this._runvec.addAll(arrayList);
        }
        return this._runvec;
    }

    private RssRun getRssRun(ManagerProxyListContainer managerProxyListContainer, Identifier identifier, String string, String string2) {
        RssRun rssRun = (RssRun)managerProxyListContainer.openManager("rss", identifier);
        if (rssRun == null) {
            rssRun = (RssRun)managerProxyListContainer.newManager("rss", RssRun.class.getName());
            if (rssRun == null) {
                System.out.println("Failed to load ResSim run from " + identifier.getPath());
                this._failedRunNames.add(string);
                return null;
            }
            rssRun.setIdentifier(identifier);
            rssRun.readFile(identifier);
            rssRun.setDSSOutputFile(string2);
        }
        rssRun.setName(string);
        rssRun.setRunId(string);
        return rssRun;
    }

    public List getRunVec(Vector vector, String string, ManagerProxyListContainer managerProxyListContainer) {
        System.out.println("getRunVec:have " + vector.size() + " runs");
        if (this._runvec != null) {
            return this._runvec;
        }
        this._runvec = new Vector();
        this._runsIdsVector = new Vector<Identifier>();
        RmiFileManager rmiFileManager = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        this._failedRunNames = new ArrayList<String>();
        for (int i = 0; i < vector.size(); ++i) {
            RunInfo runInfo;
            RssRun rssRun;
            Object object = vector.get(i);
            if (object == null) {
                System.out.println("getRunVec:run " + i + " is null");
                continue;
            }
            System.out.println("getRunVec:run " + i + " is a " + String.valueOf(object.getClass()));
            if (object instanceof RssRun) {
                rssRun = (RssRun)object;
                runInfo = new RunInfo(rssRun.getName(), rssRun.getDisplayName());
                new RunInfo(rssRun.getName(), rssRun.getDisplayName()).run = rssRun;
                this._runvec.add(runInfo);
                this._runsIdsVector.add(rssRun.getIdentifier());
                continue;
            }
            String string2 = object.toString();
            object = RMAIO.userNameToFileName((String)string2);
            if ((object = this.getRunId((String)object, string, rmiFileManager)) == null) {
                object = this.getRunId(string2, string, rmiFileManager);
            }
            runInfo = (RunInfo)vector.get(i);
            if (object == null) {
                System.out.println("Failed to open ResSim Run file for " + string2);
                this._failedRunNames.add(string2);
                continue;
            }
            rssRun = (RssRun)managerProxyListContainer.openManager("rss", object);
            if (rssRun == null) {
                rssRun = (RssRun)managerProxyListContainer.newManager("rss", RssRun.class.getName());
                if (rssRun == null) {
                    System.out.println("Failed to load ResSim run from " + object.getPath());
                    this._failedRunNames.add(string2);
                    continue;
                }
                rssRun.setIdentifier((Identifier)object);
                rssRun.readFile((Identifier)object);
                rssRun.setDSSOutputFile(string + "/forecast.dss");
            }
            rssRun.setName(string2);
            rssRun.setRunId(string2);
            this._runsIdsVector.add(rssRun.getIdentifier());
            runInfo.run = rssRun;
            this._runvec.add(runInfo);
        }
        return this._runvec;
    }

    public List getFailedRunNames() {
        return this._failedRunNames;
    }

    protected Identifier getRunId(String object, String string, RmiFileManager rmiFileManager) {
        object = string + "/rss/" + (String)object + ".rssrun";
        string = new Identifier((String)object);
        try {
            rmiFileManager = rmiFileManager.openFile(ClientApp.app().getUser(), (Identifier)string);
            if (rmiFileManager == null) {
                System.out.println("Failed to open ResSim run file " + string.getPath());
            }
            return rmiFileManager;
        }
        catch (RemoteException remoteException) {
            System.out.println("RemoteException opening " + (String)object + " error " + String.valueOf(remoteException));
            return null;
        }
    }

    private void init(List list, int n) {
        if (n == 3 || list != null && list.size() > 1) {
            this.rTbl_table = new RmaJTable((Component)this);
            this.rTbl_table.setTableHeader((JTableHeader)new GroupableTableHeader(this.rTbl_table.getColumnModel()));
            this.rTbl_table.setMlHeaderRenderer();
        } else {
            this.rTbl_table = new RmaJTable((Component)this);
        }
        this._sp = this.rTbl_table.getScrollPane();
        if (list.size() > 1) {
            this.rTbl_table.setAutoResizeMode(0);
        }
        RunInfo runInfo = null;
        ArrayList arrayList = new ArrayList();
        if (list != null) {
            if (list.size() > 0) {
                Object object = list.get(0);
                arrayList.clear();
                if (object instanceof RunInfo) {
                    runInfo = (RunInfo)object;
                    object = (RssRun)runInfo.run;
                    arrayList.add(object);
                } else if (object instanceof RssRun) {
                    runInfo = null;
                    object = (RssRun)object;
                    arrayList.add(object);
                } else {
                    List list2 = (List)object;
                    for (int i = 0; i < list2.size(); ++i) {
                        runInfo = (RunInfo)list2.get(i);
                        arrayList.add((RssRun)runInfo.run);
                    }
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    object = (RssRun)arrayList.get(i);
                    if (object == null) continue;
                    if (this._wksp != null) {
                        this.titleHeader[0] = "rss".equals(ClientApp.app().getAppType()) ? "Simulation: " + this._wksp.toString() : "Forecast: " + this._wksp.toString();
                    } else {
                        ((RssRun)object).getAlternative();
                        this.titleHeader[0] = "Alternative: " + ((RssRun)object).getReportKey();
                    }
                    this.titleHeader[1] = list.size() == 1 ? (runInfo != null ? "Alternative:\n" + ((RssRun)runInfo.run).getReportKey() : "Run: " + object.getName()) : "";
                    TimeZone timeZone = ClientApp.Workspace().getWatershedTimeZone();
                    object = ((RssRun)object).getRunTimeWindow();
                    if (object == null) continue;
                    String string = "Start Time: ";
                    this.titleCriteria[0] = new RmaJLabel("Lookback:  ", object.getLookbackTime(), timeZone, "dd MMM yyyy kk:mm");
                    if ("cavi".equals(ClientApp.app().getAppType())) {
                        string = "Forecast Time: ";
                    }
                    this.titleCriteria[1] = new RmaJLabel(string, object.getStartTime(), timeZone, "dd MMM yyyy kk:mm");
                    this.titleCriteria[2] = new RmaJLabel("End Time:  ", object.getEndTime(), timeZone, "dd MMM yyyy kk:mm");
                }
            } else {
                this.titleHeader[0] = "No valid data available";
            }
        }
        this.makeForm();
    }

    private void makeForm() {
        Object object;
        Object object2;
        int n = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        Serializable serializable = new Insets(3, 3, 0, 3);
        Insets insets = new Insets(0, 3, 0, 3);
        Insets insets2 = new Insets(0, 3, 3, 3);
        Insets insets3 = new Insets(3, 3, 3, 3);
        this.setSize(450, 330);
        this.setLayout(new GridBagLayout());
        this._sp.setVerticalScrollBarPolicy(20);
        this._sp.setHorizontalScrollBarPolicy(30);
        this.rTbl_table.setEnabled(false);
        this.add((Component)jPanel, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, insets3, 0, 0));
        Object object3 = new String("Workspace: " + ClientApp.Workspace().getTitleName());
        while (n < this.titleHeader.length) {
            object2 = new JLabel(this.titleHeader[n]);
            object = ((Component)object2).getFont();
            ((JComponent)object2).setFont(new Font(((Font)object).getName(), ((Font)object).getStyle(), ((Font)object).getSize() + 1));
            object3 = (String)object3 + "\n " + this.titleHeader[n];
            if (n == 0) {
                jPanel.add((Component)object2, new RmaGridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 10, 0, serializable, 0, 0));
                continue;
            }
            if (n == this.titleHeader.length - 1) {
                jPanel.add((Component)object2, new RmaGridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 10, 0, insets2, 0, 0));
                continue;
            }
            jPanel.add((Component)object2, new RmaGridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
        }
        object2 = new PageText((String)object3, 0);
        this.rTbl_table.setPrintTitle((PageText)object2);
        object = new String("");
        n = 0;
        while (n < this.titleCriteria.length) {
            if (this.titleCriteria[n] == null) {
                ++n;
                continue;
            }
            serializable = this.titleCriteria[n] instanceof JLabel ? (JLabel)this.titleCriteria[n] : new JLabel(this.titleCriteria[n].toString());
            object = (String)object + "\n " + ((JLabel)serializable).getText();
            jPanel.add((Component)serializable, new RmaGridBagConstraints(0, this.titleHeader.length + n++, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        }
        object = (String)object + "\n ";
        object2 = new PageText((String)object, 2);
        this.rTbl_table.setPrintOtherInfo((PageText)object2);
        RssReportsJPanel rssReportsJPanel = this;
        rssReportsJPanel.add((Component)rssReportsJPanel._sp, new RmaGridBagConstraints(0, 1, 1, 1, 1.0, 2.0, 10, 1, insets3, 0, 0));
        if (this._runvec != null && this._runvec.size() > 1) {
            this.rTbl_table.setAutoResizeMode(0);
        }
        RmaGridBagConstraints rmaGridBagConstraints = new RmaGridBagConstraints();
        this._footerTxtArea = new RmaJTextArea();
        rmaGridBagConstraints.gridx = 0;
        rmaGridBagConstraints.gridy = 0;
        rmaGridBagConstraints.gridwidth = 1;
        rmaGridBagConstraints.anchor = 18;
        rmaGridBagConstraints.fill = 1;
        rmaGridBagConstraints.insets = RmaInsets.insets((int)10, (int)10, (int)0, (int)0);
        jPanel2.add((Component)this._footerTxtArea, rmaGridBagConstraints);
        rmaGridBagConstraints = new RmaGridBagConstraints();
        new RmaGridBagConstraints().gridx = 0;
        rmaGridBagConstraints.gridy = 2;
        rmaGridBagConstraints.gridwidth = 1;
        rmaGridBagConstraints.anchor = 18;
        rmaGridBagConstraints.fill = 1;
        rmaGridBagConstraints.insets = RmaInsets.insets((int)10, (int)10, (int)0, (int)0);
        this.add((Component)jPanel2, rmaGridBagConstraints);
        jPanel2.setVisible(false);
    }

    public void printReport() {
        this.rTbl_table.printData();
    }

    @Override
    public void printPreviewReport() {
        this.rTbl_table.printPreview();
    }

    @Override
    public void exportReport() {
        this.rTbl_table.exportData();
    }

    public RmaJTable getTable() {
        return this.rTbl_table;
    }

    public Vector getRunNames() {
        return this._runNames;
    }

    public String getWkspPath() {
        return this._wkspPath;
    }

    public ManagerProxyListContainer getWorkspace() {
        return this._wksp;
    }
}

