/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.map.LocalPt;
import hec.map.LocalRect;
import hec.map.MapCanvas;
import hec.map.MapGlyph;
import hec.map.MapMouseAdapter;
import hec.map.MapPanel;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.streamAlignment.StreamAlignmentGlyph;
import hec.model.StreamElement;
import hec.model.StreamSegment;
import hec.rss.client.RSS;
import hec.rss.client.RssResMouseAdapter$1;
import hec.rss.client.RssSystemGlyph;
import hec.rss.model.Element;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import rma.swing.RmaImage;

public class RssResMouseAdapter
extends MapMouseAdapter
implements KeyListener,
MouseListener,
MouseMotionListener {
    public static final String POINTER_CURSOR = "ReservoirCursor";
    public static final int READY = 0;
    public static final int CREATING = 1;
    public static final int EDITING = 2;
    static int[] _xpt = new int[4];
    static int[] _ypt = new int[4];
    LocalPt _pt = new LocalPt();
    WorldPt _wpt = new WorldPt();
    LocalPt _pt0 = new LocalPt();
    LocalPt _pt1 = new LocalPt();
    WorldPt _wpt0 = new WorldPt();
    Vector _wptList = new Vector();
    Vector _nodeVec = new Vector();
    RssNode _selectedNode = null;
    LocalPt _selectedPt = null;
    WorldPt _selectedWPt = null;
    LocalRect _lrc = new LocalRect();
    WorldRect _wrc = new WorldRect();
    RssNode _node = new RssNode();
    ReservoirElement _reservoir;
    int _mode = 0;
    boolean _moving = false;
    RssSystemGlyph _sysglyph = null;
    StreamAlignmentGlyph _alignglyph = null;
    private Action _escapeAction;
    private Cursor _resCursor;

    public RssResMouseAdapter(MapPanel object, MapCanvas mapCanvas) {
        super(object, mapCanvas);
        try {
            object = RmaImage.loadURLImage((Component)mapCanvas, (String)"Images/pointers/ReservoirCursor.gif");
            this._resCursor = Toolkit.getDefaultToolkit().createCustomCursor((Image)object, new Point(0, 0), POINTER_CURSOR);
            return;
        }
        catch (Exception exception) {
            System.out.println("init:failed to find cursor image: Images/pointer/ReservoirCursor.gif. Error:" + String.valueOf(exception));
            return;
        }
    }

    public void init() {
        super.init();
        if (this._escapeAction == null) {
            this._escapeAction = new RssResMouseAdapter$1(this);
        }
        if (this._mapPanel.getActionMap().get("resEscapeKey") == null) {
            this._mapPanel.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "resEscapeKey");
            this._mapPanel.getActionMap().put("resEscapeKey", this._escapeAction);
        }
    }

    protected void escapeKeyAction() {
        switch (this._mode) {
            case 1: {
                this.removeRecentReserviorNode();
                return;
            }
            case 2: {
                this.abortEditing();
            }
        }
    }

    boolean findRssSystemGlyph() {
        this._sysglyph = null;
        List list = this._mapPanel.managerGlyphList();
        for (int i = 0; i < list.size(); ++i) {
            MapGlyph mapGlyph = (MapGlyph)list.get(i);
            if (mapGlyph == null || !(mapGlyph instanceof RssSystemGlyph)) continue;
            this._sysglyph = (RssSystemGlyph)mapGlyph;
            break;
        }
        return this._sysglyph != null;
    }

    protected boolean findStreamAlignmentGlyph() {
        this._alignglyph = null;
        List list = this._mapPanel.managerGlyphList();
        for (int i = 0; i < list.size(); ++i) {
            MapGlyph mapGlyph = (MapGlyph)list.get(i);
            if (mapGlyph == null || !(mapGlyph instanceof StreamAlignmentGlyph)) continue;
            this._alignglyph = (StreamAlignmentGlyph)mapGlyph;
            break;
        }
        return this._alignglyph != null;
    }

    public void abort() {
        super.abort();
        this._selectedNode = null;
        this._selectedPt = null;
        this._selectedWPt = null;
        this._mode = 0;
        this._moving = false;
        this._mapPanel.getInputMap(1).remove(KeyStroke.getKeyStroke(27, 0));
        this._mapPanel.getActionMap().remove("resEscapeKey");
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this._mode == 0) {
            this.readyMouseReleased(mouseEvent);
            return;
        }
        if (this._mode == 1) {
            this.creatingMouseReleased(mouseEvent);
            return;
        }
        if (this._mode == 2) {
            this.editingMouseReleased(mouseEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this._mode == 0) {
            this.readyMousePressed(mouseEvent);
            return;
        }
        if (this._mode == 1) {
            this.creatingMousePressed(mouseEvent);
            return;
        }
        if (this._mode == 2) {
            this.editingMousePressed(mouseEvent);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this._mode == 0) {
            this.readyMouseMoved(mouseEvent);
            return;
        }
        if (this._mode == 1) {
            this.creatingMouseMoved(mouseEvent);
            return;
        }
        if (this._mode == 2) {
            this.editingMouseMoved(mouseEvent);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this._mode == 0) {
            this.readyMouseReleased(mouseEvent);
            return;
        }
        if (this._mode == 1) {
            this.creatingMouseDragged(mouseEvent);
            return;
        }
        if (this._mode == 2) {
            this.editingMouseDragged(mouseEvent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this._mode == 0) {
            this.readyMouseClicked(mouseEvent);
            return;
        }
        if (this._mode == 1) {
            this.creatingMouseClicked(mouseEvent);
            return;
        }
        if (this._mode == 2) {
            this.editingMouseClicked(mouseEvent);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (this._mode == 1) {
            if (keyEvent.getKeyCode() == 27) {
                this.removeRecentReserviorNode();
                return;
            }
        } else if (this._mode == 2 && keyEvent.getKeyCode() == 27) {
            this.abortEditing();
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    void readyMouseReleased(MouseEvent mouseEvent) {
    }

    void readyMousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() || RssResMouseAdapter.pressedButton3((MouseEvent)mouseEvent)) {
            this.showPopupMenu(mouseEvent);
        }
    }

    void readyMouseMoved(MouseEvent mouseEvent) {
        super.mouseMoved(mouseEvent);
    }

    void readyMouseDragged(MouseEvent mouseEvent) {
    }

    void readyMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isControlDown()) {
            this.initiateCreateReservoir(mouseEvent);
            return;
        }
        if (mouseEvent.getClickCount() == 2) {
            this.selectReservoirForEditing(mouseEvent);
            return;
        }
        this.selectReservoir(mouseEvent);
    }

    void creatingMouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isControlDown()) {
            this.addReservoirNode(mouseEvent);
            return;
        }
        this.addReservoirNode(mouseEvent);
        this.createReservoir(mouseEvent);
    }

    void creatingMousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() || RssResMouseAdapter.pressedButton3((MouseEvent)mouseEvent)) {
            this.showPopupMenu(mouseEvent);
        }
    }

    void creatingMouseMoved(MouseEvent mouseEvent) {
        Graphics graphics = this._mapCanvas.getGraphics();
        graphics.setXORMode(Color.white);
        if (this._moving) {
            graphics.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
            RssResMouseAdapter rssResMouseAdapter = this;
            rssResMouseAdapter.drawPt(rssResMouseAdapter._pt, true);
        }
        this._moving = true;
        this._pt1.init(mouseEvent.getX(), mouseEvent.getY());
        mouseEvent = this._alignglyph.findNearestReach(this._pt1);
        if (mouseEvent != null) {
            WorldPt worldPt = this._mapPanel.scale().lp2wp(this._pt1);
            mouseEvent.getLine().getNearestLocation(worldPt, this._wpt);
            this._mapPanel.scale().wp2lp(this._wpt, this._pt1);
        }
        if (this._sysglyph.findReservoir(this._wpt) == null && this._sysglyph.findReach(this._wpt) == null || this._sysglyph.findJunction(this._wpt) != null) {
            this._pt.init(this._pt1);
            if (mouseEvent != null) {
                this._node.setStream((StreamElement)mouseEvent);
                this._node.setStreamIndex(mouseEvent.getIndex());
                this._node.setStreamName(mouseEvent.getName());
                this._node.setStreamStation(mouseEvent.getStationByLocation(this._wpt));
                this._node.setStreamCoord(mouseEvent.getCoordByLocation(this._wpt));
                this._node.setLocation(this._wpt);
            }
        }
        graphics.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
        RssResMouseAdapter rssResMouseAdapter = this;
        rssResMouseAdapter.drawPt(rssResMouseAdapter._pt, true);
        graphics.setPaintMode();
        graphics.dispose();
    }

    void creatingMouseDragged(MouseEvent mouseEvent) {
    }

    void creatingMouseClicked(MouseEvent mouseEvent) {
    }

    void editingMouseReleased(MouseEvent object) {
        if (this._selectedNode != null) {
            object = new RssNode();
            object.setStream(this._selectedNode.getStream());
            object.setStreamIndex(this._selectedNode.getStreamIndex());
            object.setStreamName(this._selectedNode.getStreamName());
            ((RssNode)object).setStreamStation(this._selectedNode.getStreamStation());
            object.setStreamCoord(this._selectedNode.getStreamCoord());
            object.setLocation(new WorldPt(this._selectedNode.getLocation()));
            this._selectedNode.setStream(this._node.getStream());
            this._selectedNode.setStreamIndex(this._node.getStreamIndex());
            this._selectedNode.setStreamName(this._node.getStreamName());
            this._selectedNode.setStreamStation(this._node.getStreamStation());
            this._selectedNode.setStreamCoord(this._node.getStreamCoord());
            this._selectedNode.setLocation(new WorldPt(this._node.getLocation()));
            Vector vector = new Vector();
            Vector<StreamSegment> vector2 = new Vector<StreamSegment>();
            String string = this._alignglyph.getStreamSegmentsByNodes(this._reservoir.getNodeVector(), vector, vector2);
            if (string != null) {
                JOptionPane.showMessageDialog((Component)this._mapPanel, string, "Cannot change reservoir node location", 1);
                this._selectedNode.setStream(((RssNode)object).getStream());
                this._selectedNode.setStreamIndex(object.getStreamIndex());
                this._selectedNode.setStreamName(object.getStreamName());
                this._selectedNode.setStreamStation(object.getStreamStation());
                this._selectedNode.setStreamCoord(((RssNode)object).getStreamCoord());
                this._selectedNode.setLocation(new WorldPt(((RssNode)object).getLocation()));
            } else {
                this._reservoir.getNodeDirVector().removeAllElements();
                this._reservoir.getNodeDirVector().addAll(vector);
                this._reservoir.setStreamSegmentVector(vector2);
            }
            this._selectedNode = null;
            this._mapPanel.paintMap();
        }
        if (this._selectedPt != null) {
            this._selectedPt = null;
            this._selectedWPt = null;
            this._mapPanel.paintMap();
        }
    }

    void editingMousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() || RssResMouseAdapter.pressedButton3((MouseEvent)mouseEvent)) {
            this.showPopupMenu(mouseEvent);
            return;
        }
        if (mouseEvent.isControlDown() && mouseEvent.isShiftDown()) {
            this._pt.init(mouseEvent.getX(), mouseEvent.getY());
            mouseEvent = this._mapPanel.scale().lp2wp(this._pt);
            double d = this._mapPanel.scale().x2e(this._pt.x + 5) - this._mapPanel.scale().x2e(this._pt.x);
            this._reservoir.getRegion().removePt((WorldPt)mouseEvent, d);
            this._mapPanel.paintMap();
            return;
        }
        if (mouseEvent.isControlDown()) {
            this._pt.init(mouseEvent.getX(), mouseEvent.getY());
            mouseEvent = this._mapPanel.scale().lp2wp(this._pt);
            double d = this._mapPanel.scale().x2e(this._pt.x + 5) - this._mapPanel.scale().x2e(this._pt.x);
            this._reservoir.getRegion().insertPt((WorldPt)mouseEvent, d);
            RssResMouseAdapter rssResMouseAdapter = this;
            rssResMouseAdapter.drawReservoir(rssResMouseAdapter._reservoir, false, false);
            return;
        }
        this._pt.init(mouseEvent.getX(), mouseEvent.getY());
        this._pt0.init(this._pt);
        this._lrc.init(this._pt.x - 8, this._pt.y - 8, this._pt.x + 8, this._pt.y + 8);
        mouseEvent = new LocalPt();
        WorldPt worldPt = ((Element)this._reservoir).getReferencePt();
        this._mapPanel.scale().wp2lp(worldPt, (LocalPt)mouseEvent);
        if (this._lrc.contains((LocalPt)mouseEvent)) {
            this._selectedPt = mouseEvent;
            this._selectedWPt = worldPt;
            return;
        }
        this._lrc.init(this._pt.x - 3, this._pt.y - 3, this._pt.x + 3, this._pt.y + 3);
        for (int i = 0; i < this._reservoir.getRegion().pts.size(); ++i) {
            worldPt = (WorldPt)this._reservoir.getRegion().pts.elementAt(i);
            if (worldPt == null) continue;
            this._mapPanel.scale().wp2lp(worldPt, (LocalPt)mouseEvent);
            if (!this._lrc.contains((LocalPt)mouseEvent)) continue;
            this._selectedPt = mouseEvent;
            this._selectedWPt = worldPt;
            return;
        }
    }

    void editingMouseMoved(MouseEvent mouseEvent) {
        super.mouseMoved(mouseEvent);
    }

    void editingMouseDragged(MouseEvent mouseEvent) {
        if (this._selectedNode != null && this._reservoir != null) {
            Object object;
            Graphics graphics = this._mapCanvas.getGraphics();
            graphics.setXORMode(Color.white);
            RssResMouseAdapter rssResMouseAdapter = this;
            rssResMouseAdapter.drawPt(rssResMouseAdapter._pt, true);
            this._pt1.init(mouseEvent.getX(), mouseEvent.getY());
            mouseEvent = this._alignglyph.findReach(this._selectedNode.getStreamIndex());
            if (mouseEvent != null) {
                object = this._mapPanel.scale().lp2wp(this._pt1);
                mouseEvent.getLine().getNearestLocation(object, this._wpt);
                this._mapPanel.scale().wp2lp(this._wpt, this._pt1);
            }
            if ((object = this._sysglyph.findReservoir(this._wpt)) == null || object == this._reservoir) {
                this._pt.init(this._pt1);
                if (mouseEvent != null) {
                    this._node.setStreamStation(mouseEvent.getStationByLocation(this._wpt));
                    this._node.setStreamCoord(mouseEvent.getCoordByLocation(this._wpt));
                    this._node.setLocation(new WorldPt(this._wpt));
                }
            }
            RssResMouseAdapter rssResMouseAdapter2 = this;
            rssResMouseAdapter2.drawPt(rssResMouseAdapter2._pt, true);
            graphics.setPaintMode();
            graphics.dispose();
            return;
        }
        if (this._selectedPt != null && this._reservoir != null) {
            RssResMouseAdapter rssResMouseAdapter = this;
            rssResMouseAdapter.drawReservoir(rssResMouseAdapter._reservoir, true, false);
            this._selectedPt.init(mouseEvent.getX(), mouseEvent.getY());
            this._mapPanel.scale().lp2wp(this._selectedPt, this._selectedWPt);
            RssResMouseAdapter rssResMouseAdapter3 = this;
            rssResMouseAdapter3.drawReservoir(rssResMouseAdapter3._reservoir, true, false);
        }
    }

    void editingMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.selectReservoirForEditing(mouseEvent);
        }
    }

    void removeRecentReserviorNode() {
        Graphics graphics = this._mapCanvas.getGraphics();
        int n = this._wptList.size();
        if (n <= 1) {
            this._wptList.removeAllElements();
            this._mode = 0;
            this._moving = false;
            this._mapPanel.paintMap();
            return;
        }
        graphics.setXORMode(Color.white);
        if (this._moving) {
            RssResMouseAdapter rssResMouseAdapter = this;
            rssResMouseAdapter.drawPt(rssResMouseAdapter._pt, true);
            graphics.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
        }
        RssResMouseAdapter rssResMouseAdapter = this;
        rssResMouseAdapter.drawPt(rssResMouseAdapter._pt0, true);
        WorldPt worldPt = (WorldPt)this._wptList.elementAt(n - 2);
        this._mapPanel.scale().wp2lp(worldPt, this._pt1);
        graphics.drawLine(this._pt0.x, this._pt0.y, this._pt1.x, this._pt1.y);
        this._wptList.removeElementAt(n - 1);
        this._nodeVec.removeElementAt(n - 1);
        this._pt0.init(this._pt1);
        if (this._moving) {
            graphics.setXORMode(Color.white);
            graphics.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
            RssResMouseAdapter rssResMouseAdapter2 = this;
            rssResMouseAdapter2.drawPt(rssResMouseAdapter2._pt, true);
        }
        graphics.setPaintMode();
        graphics.dispose();
    }

    void initiateCreateReservoir(MouseEvent object) {
        if (!this.findRssSystemGlyph()) {
            RSS.app();
            JOptionPane.showMessageDialog((Component)ClientApp.frame(), "Please create/open a Reservoir Network first");
            return;
        }
        if (!this._sysglyph.isWriteLocked()) {
            JOptionPane.showMessageDialog((Component)this._mapPanel, "You must first lock the reservoir network.", "Cannot create reservoir", 1);
            return;
        }
        if (!this.findStreamAlignmentGlyph()) {
            return;
        }
        this._pt.init(((MouseEvent)object).getX(), ((MouseEvent)object).getY());
        this._mapPanel.scale().lp2wp(this._pt, this._wpt);
        if ((this._sysglyph.findReservoir(this._wpt) != null || this._sysglyph.findReach(this._wpt) != null) && this._sysglyph.findJunction(this._wpt) == null) {
            JOptionPane.showMessageDialog((Component)this._mapPanel, "A reservoir or reach already exists at this location", "Cannot create reservoir", 1);
            return;
        }
        object = this._alignglyph.findReach(this._pt);
        if (object == null) {
            JOptionPane.showMessageDialog((Component)this._mapPanel, "Click near a stream to begin creating a reservoir.", "Cannot create reservoir", 1);
            return;
        }
        this._wptList.removeAllElements();
        this._nodeVec.removeAllElements();
        this._mapPanel.scale().lp2wp(this._pt, this._wpt);
        object.getLine().getNearestLocation(this._wpt, this._wpt0);
        this._mapPanel.scale().wp2lp(this._wpt0, this._pt0);
        this._wptList.addElement(new WorldPt(this._wpt0));
        this._node.setStream((StreamElement)object);
        this._node.setStreamIndex(object.getIndex());
        this._node.setStreamName(object.getName());
        this._node.setStreamStation(object.getStationByLocation(this._wpt0));
        this._node.setStreamCoord(object.getCoordByLocation(this._wpt0));
        object = new RssNode();
        object.setStream(this._node.getStream());
        object.setStreamIndex(this._node.getStreamIndex());
        object.setStreamName(this._node.getStreamName());
        ((RssNode)object).setStreamStation(this._node.getStreamStation());
        object.setStreamCoord(this._node.getStreamCoord());
        object.setLocation(new WorldPt(this._wpt0));
        this._nodeVec.addElement(object);
        RssResMouseAdapter rssResMouseAdapter = this;
        rssResMouseAdapter.drawPt(rssResMouseAdapter._pt0, false);
        this._pt.init(this._pt0);
        this._mode = 1;
    }

    void addReservoirNode(MouseEvent object) {
        this._mapPanel.scale().lp2wp(this._pt, this._wpt);
        object = (WorldPt)this._wptList.lastElement();
        if (object != null && this._wpt.equals((WorldPt)object)) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        this._wptList.addElement(new WorldPt(this._wpt));
        object = new RssNode();
        object.setStream(this._node.getStream());
        object.setStreamIndex(this._node.getStreamIndex());
        object.setStreamName(this._node.getStreamName());
        ((RssNode)object).setStreamStation(this._node.getStreamStation());
        object.setStreamCoord(this._node.getStreamCoord());
        object.setLocation(new WorldPt(this._node.getLocation()));
        this._nodeVec.addElement(object);
        RssResMouseAdapter rssResMouseAdapter = this;
        rssResMouseAdapter.drawPt(rssResMouseAdapter._pt, false);
        this._pt0.init(this._pt);
        this._moving = false;
    }

    void createReservoir(MouseEvent serializable) {
        serializable = new Vector();
        Vector<StreamSegment> vector = new Vector<StreamSegment>();
        Object object = this._alignglyph.getStreamSegmentsByNodes(this._nodeVec, (Vector)serializable, vector);
        if (object != null) {
            JOptionPane.showMessageDialog((Component)this._mapPanel, object, "Cannot create reservoir", 1);
            this._mapPanel.paintMap();
        } else {
            object = new Vector();
            for (int i = 0; i < this._wptList.size(); ++i) {
                ((Vector)object).addElement(this._mapPanel.scale().wp2lp((WorldPt)this._wptList.elementAt(i)));
            }
            this._sysglyph.createReservoir((Vector)object, this._nodeVec, (Vector)serializable, vector);
        }
        this._mode = 0;
        this._moving = false;
    }

    void showPopupMenu(MouseEvent mouseEvent) {
        if (!this.findRssSystemGlyph()) {
            return;
        }
        this._pt.init(mouseEvent.getX(), mouseEvent.getY());
        this._sysglyph.reservoirPopupMenu(this._pt);
    }

    void selectReservoir(MouseEvent object) {
        if (!this.findRssSystemGlyph()) {
            return;
        }
        this._pt.init(((MouseEvent)object).getX(), ((MouseEvent)object).getY());
        object = this._sysglyph.selectReservoir(this._pt, false, false);
        this.setReservoir((ReservoirElement)object);
    }

    void abortEditing() {
        this._selectedPt = null;
        this._selectedWPt = null;
        this.setReservoir(null);
        this._mode = 0;
        if (!this.findRssSystemGlyph()) {
            return;
        }
        this._sysglyph.clearSelection();
    }

    void selectReservoirForEditing(MouseEvent object) {
        if (!this.findRssSystemGlyph()) {
            return;
        }
        if (!this._sysglyph.isWriteLocked()) {
            JOptionPane.showMessageDialog((Component)this._mapPanel, "You must first lock the watershed configuration.", "Cannot edit reservoir", 1);
            return;
        }
        this._pt.init(((MouseEvent)object).getX(), ((MouseEvent)object).getY());
        object = this._sysglyph.selectReservoir(this._pt, false, true);
        this._mode = object != null ? 2 : 0;
        this.setReservoir((ReservoirElement)object);
    }

    synchronized void drawPt(LocalPt localPt, boolean bl) {
        Graphics graphics = this._mapCanvas.getGraphics();
        if (bl) {
            graphics.setXORMode(Color.white);
        } else {
            graphics.setColor(Color.black);
        }
        RssResMouseAdapter._xpt[0] = localPt.x - 5;
        RssResMouseAdapter._ypt[0] = localPt.y;
        RssResMouseAdapter._xpt[1] = localPt.x;
        RssResMouseAdapter._ypt[1] = localPt.y + 5;
        RssResMouseAdapter._xpt[2] = localPt.x + 5;
        RssResMouseAdapter._ypt[2] = localPt.y;
        RssResMouseAdapter._xpt[3] = localPt.x;
        RssResMouseAdapter._ypt[3] = localPt.y - 5;
        graphics.fillPolygon(_xpt, _ypt, 4);
        graphics.setPaintMode();
        graphics.dispose();
    }

    void drawReservoir(ReservoirElement reservoirElement, boolean bl, boolean bl2) {
        if (this._sysglyph == null || reservoirElement == null) {
            return;
        }
        Graphics graphics = this._mapCanvas.getGraphics();
        this._sysglyph.drawSelectedReservoir(graphics, this._mapPanel.scale(), reservoirElement, bl, this._mode == 2, bl2);
        graphics.dispose();
    }

    private void setReservoir(ReservoirElement reservoirElement) {
        this._reservoir = reservoirElement;
    }

    public Cursor getCursor() {
        if (this._resCursor == null) {
            return super.getCursor();
        }
        return this._resCursor;
    }
}

