/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientMode;
import hec.rss.client.AlternativeEditor;
import hec.rss.client.RSimSimulationMode;
import hec.rss.client.RssRunOptionPanel$1;
import hec.rss.client.RssRunOptionPanel$2;
import hec.rss.model.RssAlt;
import hec.rss.model.RssRun;
import hec.rss.wq.model.AltWaterQualityOptions;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import rma.lang.Modifiable;
import rma.swing.JButtonGroup;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJRadioButton;
import rma.util.RMAUtil;

public class RssRunOptionPanel
extends JPanel
implements Modifiable {
    private RssRun _run;
    RmaJCheckBox _computeUnreg;
    RmaJCheckBox _computeHoldouts;
    RmaJComboBox<String> _logLevel;
    RmaJRadioButton _computeInstFlows;
    RmaJRadioButton _computePerAvgFlows;
    RmaJRadioButton _computeDefaultFlows;
    private RssAlt _alt;
    private boolean _ignoreModifiedEvents;
    private boolean _modified;
    private RmaJCheckBox _computeWq;
    private RmaJCheckBox _useHotstartCheck;
    private AlternativeEditor _editor;

    public RssRunOptionPanel(AlternativeEditor alternativeEditor) {
        super(new GridBagLayout());
        this._editor = alternativeEditor;
        this.buildControls();
        this.addListeners();
    }

    protected void buildControls() {
        this.buildRadioPanel();
        this._computeUnreg = new RmaJCheckBox("Compute Unregulated Flows");
        this._computeUnreg.setToolTipText("<html>Select this checkbox to have ResSim compute Unregulated Flows</html>");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)5);
        RssRunOptionPanel rssRunOptionPanel = this;
        rssRunOptionPanel.add((Component)rssRunOptionPanel._computeUnreg, gridBagConstraints);
        this._computeHoldouts = new RmaJCheckBox("Compute Holdouts");
        this._computeHoldouts.setToolTipText("<html>Select this checkbox to have ResSim compute holdouts</html>");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        RssRunOptionPanel rssRunOptionPanel2 = this;
        rssRunOptionPanel2.add((Component)rssRunOptionPanel2._computeHoldouts, gridBagConstraints);
        this._useHotstartCheck = new RmaJCheckBox("Enable Hotstart");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        RssRunOptionPanel rssRunOptionPanel3 = this;
        rssRunOptionPanel3.add((Component)rssRunOptionPanel3._useHotstartCheck, gridBagConstraints);
        this._computeWq = new RssRunOptionPanel$1(this, "Compute Water Quality");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        RssRunOptionPanel rssRunOptionPanel4 = this;
        rssRunOptionPanel4.add((Component)rssRunOptionPanel4._computeWq, gridBagConstraints);
        this._computeWq.setVisible(this._editor.hasWatershedWq());
        this._computeWq.setEnabled(!(ClientApp.frame().getCurrentMode() instanceof RSimSimulationMode));
        JLabel jLabel = new JLabel("Log Level:");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.add((Component)jLabel, gridBagConstraints);
        this._logLevel = new RmaJComboBox((Object[])new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"});
        this._logLevel.setModifiable(true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        RssRunOptionPanel rssRunOptionPanel5 = this;
        rssRunOptionPanel5.add((Component)rssRunOptionPanel5._logLevel, gridBagConstraints);
        EventQueue.invokeLater(() -> this._editor.setWqPanelEnabled(this._computeWq.isSelected()));
    }

    protected void buildRadioPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder("Flow Computation Method"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.01;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)5, (int)5, (int)0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        this.add((Component)jPanel, gridBagConstraints);
        this._computeDefaultFlows = new RmaJRadioButton("Program Determined", true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this._computeDefaultFlows, gridBagConstraints);
        this._computePerAvgFlows = new RmaJRadioButton("Period Average");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.ipadx = 60;
        jPanel.add((Component)this._computePerAvgFlows, gridBagConstraints);
        this._computeInstFlows = new RmaJRadioButton("Instantaneous");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this._computeInstFlows, gridBagConstraints);
        jPanel = new JButtonGroup();
        jPanel.add((AbstractButton)this._computePerAvgFlows);
        jPanel.add((AbstractButton)this._computeInstFlows);
        jPanel.add((AbstractButton)this._computeDefaultFlows);
    }

    private void addListeners() {
        this._computeWq.addActionListener(actionEvent -> this.computeWqSelected());
        this._useHotstartCheck.addActionListener(actionEvent -> this.setHotstartTabState());
    }

    private void setHotstartTabState() {
        boolean bl = this._useHotstartCheck.isSelected();
        this._editor.setTabEnabled(this._editor.getHotstartPanel(), bl, "Enable by Selecting " + this._useHotstartCheck.getText() + " on the Run Control tab");
    }

    private void computeWqSelected() {
        this._editor.setWqPanelEnabled(this._computeWq.isSelected());
    }

    public boolean savePanel(RssAlt rssAlt) {
        if (!this.isEnabled()) {
            return true;
        }
        if (rssAlt == null) {
            rssAlt = this._alt;
        }
        if (rssAlt == null) {
            return true;
        }
        if (rssAlt != null) {
            rssAlt.setComputeHoldout(this._computeHoldouts.isSelected());
            rssAlt.setComputeUnReg(this._computeUnreg.isSelected());
            if (this._logLevel.getSelectedIndex() != -1) {
                rssAlt.setLogLevel(this._logLevel.getSelectedIndex() + 1);
            }
            if (this._computeDefaultFlows.isSelected()) {
                rssAlt.setFlowComputeType(0);
            } else if (this._computeInstFlows.isSelected() || this._computePerAvgFlows.isSelected()) {
                rssAlt.setPerAvgFlow(this._computePerAvgFlows.isSelected());
            }
            rssAlt.getHotstartOptions().setEnabled(this._useHotstartCheck.isSelected());
            this.saveWqOptions(rssAlt);
        } else if (this._run != null) {
            this._run.setComputeHoldout(this._computeHoldouts.isSelected());
            this._run.setComputeUnReg(this._computeUnreg.isSelected());
            if (this._logLevel.getSelectedIndex() != -1) {
                this._run.setLogLevel(this._logLevel.getSelectedIndex() + 1);
            }
            if (this._run.getAlternative() != null) {
                this._run.getAlternative().setPerAvgFlow(this._computePerAvgFlows.isSelected());
                this._run.getAlternative().getHotstartOptions().setEnabled(this._useHotstartCheck.isSelected());
            }
            this._run.getRunTimeWindow().setPeriodAvgTimeStep(this._computePerAvgFlows.isSelected());
            RssRunOptionPanel rssRunOptionPanel = this;
            rssRunOptionPanel.saveWqOptions(rssRunOptionPanel._run.getAlternative());
        }
        return true;
    }

    public void fillPanel(RssAlt rssAlt) {
        this._alt = rssAlt;
        if (this._alt == null) {
            return;
        }
        EventQueue.invokeLater(new RssRunOptionPanel$2(this, rssAlt));
        RssRunOptionPanel rssRunOptionPanel = this;
        rssRunOptionPanel.fillWqOptions(rssRunOptionPanel._alt);
    }

    protected void fillWqOptions(RssAlt cloneable) {
        cloneable = ((RssAlt)cloneable).getWaterQualityOptions();
        this._computeWq.setSelected(((AltWaterQualityOptions)cloneable).shouldRunWq());
        EventQueue.invokeLater(() -> this.computeWqSelected());
    }

    protected void saveWqOptions(RssAlt cloneable) {
        cloneable = ((RssAlt)cloneable).getWaterQualityOptions();
        if (this._editor.hasWatershedWq()) {
            ((AltWaterQualityOptions)cloneable).setRunWq(this._computeWq.isSelected());
        }
    }

    public void fillPanel(RssRun manager) {
        this._run = manager;
        if (manager == null) {
            return;
        }
        this._computeUnreg.setSelected(this._run.getComputeUnReg());
        this._computeHoldouts.setSelected(this._run.getComputeHoldout());
        this._logLevel.setSelectedIndex(this._run.getLogLevel() - 1);
        manager = this._run.getAlternative();
        if (manager != null) {
            if (manager.isDefaultFlowCompute()) {
                this._computeDefaultFlows.doClick(0);
            } else if (manager.isPerAvgFlow()) {
                this._computePerAvgFlows.doClick(0);
            } else {
                this._computeInstFlows.doClick(0);
            }
            this._useHotstartCheck.setSelected(manager.getHotstartOptions().isEnabled());
            this.setHotstartTabState();
            this.fillWqOptions((RssAlt)manager);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._computeUnreg.setEnabled(bl);
        this._computeHoldouts.setEnabled(bl);
        this._logLevel.setEnabled(bl);
        this._useHotstartCheck.setEnabled(bl);
        if (bl) {
            this._computeWq.setEnabled(!(ClientApp.frame().getCurrentMode() instanceof RSimSimulationMode));
        }
    }

    public RmaJRadioButton getDefaultFCMRadio() {
        return this._computeDefaultFlows;
    }

    public void setIgnoreModifiedEvents(boolean bl) {
        this._ignoreModifiedEvents = bl;
    }

    public boolean isIgnoreModifiedEvents() {
        return this._ignoreModifiedEvents;
    }

    public boolean isModified() {
        return this._modified;
    }

    public void setModified(boolean bl) {
        if (this._ignoreModifiedEvents) {
            return;
        }
        this._modified = bl;
        if (!bl) {
            RMAUtil.setChildrenUnmodified((Container)this);
            return;
        }
        RMAUtil.setParentModified((Component)this);
    }

    public void setWqVisible(boolean bl) {
        this._computeWq.setVisible(bl);
        this._editor.setWqPanelEnabled(this._computeWq.isSelected());
    }

    public void setWqAllowed(boolean bl) {
        if (bl) {
            if (this.isEnabled()) {
                ClientMode clientMode = ClientApp.frame().getCurrentMode();
                if (this._computeWq.isVisible() && !(clientMode instanceof RSimSimulationMode)) {
                    this._computeWq.setEnabled(true);
                }
                return;
            }
        } else {
            this._computeWq.setSelected(false);
            this._computeWq.setEnabled(false);
        }
    }

    public boolean isWqSelected() {
        return this._computeWq.isSelected();
    }
}

