/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientMode;
import hec.clientapp.client.ClientWorkspace;
import hec.clientapp.model.AbstractSimulation;
import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.clientapp.model.ManagerProxyListManager;
import hec.clientapp.model.SimulationRun;
import hec.io.FileLock;
import hec.io.Identifier;
import hec.lang.UserId;
import hec.model.DataList;
import hec.rss.client.AbstractAlternativeEditor;
import hec.rss.client.AlternativeEditor;
import hec.rss.client.RSimNetworkMode;
import hec.rss.client.RSimSimulationMode;
import hec.rss.client.ReservoirJFrame;
import hec.rss.client.RssSimEditDialog$1;
import hec.rss.client.RssSimEditDialog$2;
import hec.rss.client.RssSimEditDialog$3;
import hec.rss.model.ComputeStatus;
import hec.rss.model.OpSet;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirOp;
import hec.rss.model.RssAlt;
import hec.rss.model.RssRun;
import hec.rss.model.RssSimRun;
import hec.rss.model.RssSystem;
import hec.rss.server.DiversionEditorDlg;
import hec.rss.server.JunctionDialog;
import hec.rss.server.ReachDlg;
import hec.watershed.model.Condition;
import hec.watershed.model.ModelAlt;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import mil.army.usace.hec.rmi.client.FileLockInfoJDialog;
import mil.army.usace.hec.rmi.csinterface.CallBackInterface;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.rmi.io.HecFileImpl;
import mil.army.usace.hec.rmi.server.RmiFileCallBackImpl;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJDescriptionField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTextField;
import rma.swing.event.ReflectMultiListener;
import rma.util.RMAIO;

public class RssSimEditDialog
extends RmaJDialog
implements CallBackInterface {
    private RmaJTextField _idTxt;
    private JLabel _idLabel;
    private RmaJTextField _configurationTxt;
    private JLabel _configurationLabel;
    private RmaJTextField _modelAltTxt;
    private RmaJDescriptionField _descriptionTxt;
    private ReflectMultiListener _listener;
    private ButtonCmdPanel _cmdPanel;
    private JButton _resButton;
    private JButton _juncButton;
    private JButton _reachButton;
    private JButton _divButton;
    private JButton _altButton;
    private JButton _overrideButton;
    private JButton _sysOpButton;
    private JButton _stateVarButton;
    private JButton _gvButton;
    private RssSystem _system;
    private ReservoirJFrame _resDlg = null;
    private ReachDlg _reachDlg = null;
    private DiversionEditorDlg _divDlg = null;
    private JunctionDialog _juncDlg = null;
    protected ModelAlt _modelAlt;
    protected RssSimRun _simRun;
    protected RssRun _rssRun;
    protected String _rssAltName;
    protected RssAlt _rssAlt;
    private boolean _canceled;
    private RmiFileCallBackImpl[] _runCallback;

    public RssSimEditDialog(JDialog jDialog, boolean bl) {
        super((Dialog)jDialog, bl);
        this.buildControls();
        this.addListeners();
    }

    public RssSimEditDialog(JFrame jFrame, boolean bl) {
        super((Frame)jFrame, bl);
        this.buildControls();
        this.addListeners();
    }

    public void setRssAlternative(RssAlt rssAlt) {
        this._rssAlt = rssAlt;
    }

    public void fillForm(RssAlt rssAlt, RssRun rssRun) {
        try {
            this._rssAlt = rssAlt;
            this._rssRun = rssRun;
            this._system = null;
            this._idTxt.setVisible(false);
            this._idLabel.setVisible(false);
            this._modelAltTxt.setText("");
            this._descriptionTxt.setText("");
            this._configurationTxt.setVisible(false);
            this._configurationLabel.setVisible(false);
            if (rssAlt == null) {
                this._resButton.setEnabled(false);
                this._juncButton.setEnabled(false);
                this._reachButton.setEnabled(false);
                this._divButton.setEnabled(false);
                this._altButton.setEnabled(false);
                this._sysOpButton.setEnabled(false);
                this._overrideButton.setEnabled(false);
                this._gvButton.setEnabled(false);
                return;
            }
            this._modelAltTxt.setText(this._rssAlt.toString());
            this._descriptionTxt.setText(this._rssAlt.getDescription());
            this._rssAltName = this._rssAlt.getName();
            this._overrideButton.setEnabled(this._rssRun != null);
            if (this._rssRun != null) {
                RssSimEditDialog rssSimEditDialog = this;
                if (!rssSimEditDialog.lockManager(rssSimEditDialog._rssRun, "Failed to lock RssRun ", this._runCallback)) {
                    this._overrideButton.setEnabled(false);
                }
            }
            this._system = this._rssAlt.getSystem();
            boolean bl = this._system != null;
            this._resButton.setEnabled(bl);
            this._juncButton.setEnabled(bl);
            this._reachButton.setEnabled(bl);
            this._divButton.setEnabled(bl);
            this._sysOpButton.setEnabled(bl);
            this._overrideButton.setEnabled(bl);
            this._gvButton.setEnabled(bl);
            if (this._system == null) {
                System.out.println("editRss: failed to find RssSystem in RssAlt " + String.valueOf(this._rssAlt));
            }
            return;
        }
        finally {
            this.pack();
            RssSimEditDialog rssSimEditDialog = this;
            rssSimEditDialog.setLocationRelativeTo(rssSimEditDialog.getParent());
            this.setModified(false);
        }
    }

    public void fillForm(ModelAlt modelAlt, SimulationRun object) {
        try {
            boolean bl;
            this._modelAlt = modelAlt;
            if (object instanceof RssSimRun) {
                this._simRun = (RssSimRun)object;
            }
            this._system = null;
            this._idTxt.setText("");
            this._modelAltTxt.setText("");
            this._descriptionTxt.setText("");
            this._configurationTxt.setText("");
            if (modelAlt == null) {
                this._resButton.setEnabled(false);
                this._juncButton.setEnabled(false);
                this._reachButton.setEnabled(false);
                this._divButton.setEnabled(false);
                this._altButton.setEnabled(false);
                this._sysOpButton.setEnabled(false);
                this._overrideButton.setEnabled(false);
                this._gvButton.setEnabled(false);
                return;
            }
            modelAlt.getProxyList().getContainer();
            if (object != null) {
                this._modelAltTxt.setText(object.toString());
            } else if (modelAlt != null) {
                this._modelAltTxt.setText(modelAlt.toString());
            }
            this._idTxt.setText(modelAlt.getAltId());
            this._descriptionTxt.setText(modelAlt.getDescription());
            Object object2 = modelAlt.getConfigurationIds();
            DataList dataList = ClientApp.Workspace().getDataListContainer().getDataList(Condition.class.getName());
            if (dataList != null && object2.size() > 0) {
                if ((object2 = dataList.getObject(object2.get(0))) != null) {
                    this._configurationTxt.setText(object2.toString());
                }
            } else if (object2.size() == 0) {
                this._configurationTxt.setText("None");
            } else {
                this._configurationTxt.setText("");
            }
            object2 = null;
            if (this._rssAlt != null) {
                object2 = this._rssAlt;
            } else if (modelAlt != null) {
                object2 = (RssAlt)modelAlt.getManager();
                this._rssAlt = object2;
            }
            if (object2 == null) {
                System.out.println("editRss: failed to find RssAlt index=" + String.valueOf(modelAlt.getModelRef()));
                this._resButton.setEnabled(false);
                this._juncButton.setEnabled(false);
                this._reachButton.setEnabled(false);
                this._divButton.setEnabled(false);
                this._altButton.setEnabled(false);
                this._sysOpButton.setEnabled(false);
                this._overrideButton.setEnabled(false);
                this._gvButton.setEnabled(false);
                return;
            }
            this._rssAltName = object2.getName();
            this._rssRun = this.getRssRun((SimulationRun)object, (RssAlt)object2);
            boolean bl2 = bl = this._rssRun != null;
            if (this._rssRun != null) {
                object = this._rssRun.getLastComputeStatus();
                boolean bl3 = bl = object != ComputeStatus.NOT_COMPUTED;
                if (object == ComputeStatus.NOT_COMPUTED) {
                    this._overrideButton.setToolTipText("<html>Alternative has not been computed.<br>Overrides are not available until a compute has been run</html>");
                } else {
                    this._overrideButton.setToolTipText(null);
                }
            }
            this._overrideButton.setEnabled(bl);
            if (this._rssRun != null) {
                RssSimEditDialog rssSimEditDialog = this;
                if (!rssSimEditDialog.lockManager(rssSimEditDialog._rssRun, "Failed to lock RssRun ", this._runCallback)) {
                    this._overrideButton.setEnabled(false);
                }
            }
            this._system = ((RssAlt)object2).getSystem();
            boolean bl4 = this._system != null;
            this._resButton.setEnabled(bl4);
            this._juncButton.setEnabled(bl4);
            this._reachButton.setEnabled(bl4);
            this._divButton.setEnabled(bl4);
            this._sysOpButton.setEnabled(bl4);
            if (!bl4) {
                this._overrideButton.setEnabled(bl4);
            }
            this._gvButton.setEnabled(bl4);
            if (this._system == null) {
                System.out.println("editRss: failed to find RssSystem in RssAlt " + String.valueOf(object2));
            }
            return;
        }
        finally {
            this.pack();
            this.setLocation();
            this.setModified(false);
        }
    }

    protected RssRun getRssRun(SimulationRun simulationRun, RssAlt rssAlt) {
        String string;
        if (simulationRun == null) {
            return null;
        }
        ManagerProxyListContainer managerProxyListContainer = simulationRun.getProxyList().getContainer();
        System.out.println("simRun's workspace = " + managerProxyListContainer.getClass().getName());
        Object object = simulationRun.getModelNames("rss");
        if (object == null || ((Vector)object).isEmpty()) {
            System.out.println("getRssRun: failed to find RssRun in " + simulationRun.getName());
            return null;
        }
        object = (String)((Vector)object).get(0);
        String string2 = managerProxyListContainer instanceof ClientWorkspace ? ((ClientWorkspace)managerProxyListContainer).getWorkspacePath() : ((AbstractSimulation)managerProxyListContainer).getSimulationPath();
        string2 = new Identifier(string2 + "/rss/" + RMAIO.userNameToFileName((String)object) + ".rssrun");
        string2.setName((String)object);
        RssRun rssRun = (RssRun)managerProxyListContainer.openManager("rss", (Identifier)string2);
        if (rssRun == null) {
            rssRun = (RssRun)managerProxyListContainer.newManager("rss", RssRun.class.getName());
            rssRun.getIdentifier().setPath(string2.getPath());
            string = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
            try {
                string = string.openFile(ClientApp.app().getUser(), (Identifier)string2);
                if (string != null) {
                    rssRun.readFile((Identifier)string);
                }
            }
            catch (Exception exception) {
                System.out.println("getRssRun: error reading Run file " + string2.getPath() + " Error:" + String.valueOf(exception));
            }
            if (!managerProxyListContainer.saveManager("rss", (Manager)rssRun)) {
                if (managerProxyListContainer instanceof ManagerProxyListManager) {
                    ((ManagerProxyListManager)managerProxyListContainer).saveManagerAs("rss", (Manager)rssRun, (Identifier)string2);
                } else {
                    ((ClientWorkspace)managerProxyListContainer).saveManagerAs("rss", (Manager)rssRun, (Identifier)string2);
                }
            }
            System.out.println("rssRun's path is now " + rssRun.getIdentifier().getPath());
        }
        if (rssRun != null) {
            string = rssRun.getTimeWindowString();
            if (string == null || string.length() <= 1 || string.equals(((AbstractSimulation)simulationRun.getSimulation()).getTimeWindowString())) {
                rssRun.setTimeWindow(((AbstractSimulation)simulationRun.getSimulation()).getRunTimeWindow());
            }
            if (rssRun.getName().equals(object)) {
                rssRun.setName((String)object);
            }
            if (rssRun.getAlternative() == null) {
                rssRun.setAltPath(rssAlt.getIdentifier().getPath());
            }
        }
        return rssRun;
    }

    public void editReservoirs() {
        if (this._system == null) {
            return;
        }
        Object object = this._system.getReservoirNames();
        if (object == null || ((String[])object).length == 0) {
            RssSimEditDialog rssSimEditDialog = this;
            JOptionPane.showMessageDialog((Component)((Object)rssSimEditDialog), "No Reservoirs in RES System " + rssSimEditDialog._system.getName());
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            Object object2;
            Object object3;
            boolean bl = false;
            if (this._resDlg == null) {
                object3 = this.getParent();
                object2 = object3 instanceof JFrame ? (JFrame)object3 : ClientApp.frame();
                this._resDlg = new ReservoirJFrame((Frame)object2, this.isModal());
                bl = true;
            }
            this._resDlg.setEditable(this.isEditable());
            this._resDlg.setSystem(this._system);
            if (!this._resDlg.initDlg()) {
                return;
            }
            this._resDlg.selectReservoir(object[0]);
            object3 = null;
            if (this._simRun != null) {
                object3 = this._simRun.getRssAlt();
            } else if (this._rssAlt != null) {
                object3 = this._rssAlt;
            }
            if (this._system != null && object3 != null && (object = (object2 = this._system.findReservoir(object[0])) != null ? ((ReservoirElement)object2).getReservoirOp() : null) != null) {
                ((ReservoirOp)object).getOperationSets();
                int n = ((RssAlt)object3).getResOpSetSelection(object2.getIndex());
                object = ((ReservoirOp)object).getOperationSet(n);
                this._resDlg.setSelectedOpSet((OpSet)object);
            }
            this._resDlg.setVisible(true);
            if (bl) {
                object2 = this._resDlg.getSize();
                this._resDlg.setMinimumSize((Dimension)object2);
                this._resDlg.setSize((Dimension)object2);
            }
            return;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
            this.repaint();
        }
    }

    public void editReaches() {
        if (this._system == null) {
            return;
        }
        String[] stringArray = this._system.getReachNames();
        if (stringArray == null || stringArray.length == 0) {
            RssSimEditDialog rssSimEditDialog = this;
            JOptionPane.showMessageDialog((Component)((Object)rssSimEditDialog), "No Reaches in RES System " + rssSimEditDialog._system.getName());
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (this._reachDlg == null) {
                this._reachDlg = new ReachDlg((Frame)ClientApp.frame(), this.isModal());
            }
            this._reachDlg.setEditable(this.isEditable());
            this._reachDlg.setSystem(this._system);
            this._reachDlg.initForm();
            this._reachDlg.selectReach(stringArray[0]);
            this._reachDlg.setVisible(true);
            this._reachDlg.isCanceled();
            return;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void editJunctions() {
        if (this._system == null) {
            return;
        }
        Object object = this._system.getJunctionNames();
        if (object == null || ((String[])object).length == 0) {
            RssSimEditDialog rssSimEditDialog = this;
            JOptionPane.showMessageDialog((Component)((Object)rssSimEditDialog), "No Junctions in RES System " + rssSimEditDialog._system.getName());
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (this._juncDlg == null) {
                this._juncDlg = new JunctionDialog((Frame)ClientApp.frame(), this.isModal());
            }
            this._juncDlg.setEditable(this.isEditable());
            this._juncDlg.setRssSystem(this._system);
            this._juncDlg.setAllowJunctionMovement(false);
            this._juncDlg.selectJunction(object[0]);
            this._juncDlg.setVisible(true);
            object = new Dimension(650, 700);
            this._juncDlg.setSize((Dimension)object);
            this._juncDlg.setPreferredSize((Dimension)object);
            this._juncDlg.setMinimumSize((Dimension)object);
            this._juncDlg.setLocationRelativeTo(this._juncDlg.getParent());
            this._juncDlg.setAlwaysOnTop(false);
            return;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void editDiversions() {
        if (this._system == null) {
            return;
        }
        String[] stringArray = this._system.getDiversionNames();
        if (stringArray == null || stringArray.length == 0) {
            RssSimEditDialog rssSimEditDialog = this;
            JOptionPane.showMessageDialog((Component)((Object)rssSimEditDialog), "No Diversions in RES System " + rssSimEditDialog._system.getName());
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (this._divDlg == null) {
                this._divDlg = new DiversionEditorDlg((Frame)ClientApp.frame(), this.isModal());
            }
            this._divDlg.setEditable(this.isEditable());
            this._divDlg.setRssSystem(this._system);
            this._divDlg.selectDiversion(stringArray[0]);
            if (!this._divDlg.isVisible()) {
                this._divDlg.setVisible(true);
            }
            return;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void closeDialog() {
        int n;
        if (this._resDlg != null && this._resDlg.isVisible()) {
            if (this._resDlg.isModified() && this._resDlg.isEditable()) {
                n = RMAIO.postYesNoCancelWarning((Component)((Object)this), (String)"Reservoir Data Has Changed! Save before continuing?");
                if (n == 2) {
                    return;
                }
                if (n == 0) {
                    this._resDlg.saveForm();
                }
            }
            this._resDlg.setVisible(false);
        }
        if (this._reachDlg != null && this._reachDlg.isVisible()) {
            if (this._reachDlg.isModified() && this._reachDlg.isEditable()) {
                n = RMAIO.postYesNoCancelWarning((Component)((Object)this), (String)"Reach Data Has Changed! Save before continuing?");
                if (n == 2) {
                    return;
                }
                if (n == 0) {
                    this._reachDlg.saveForm();
                }
            }
            this._reachDlg.setVisible(false);
        }
        if (this._divDlg != null && this._divDlg.isVisible()) {
            if (this._divDlg.isModified() && this._divDlg.isEditable()) {
                n = RMAIO.postYesNoCancelWarning((Component)((Object)this), (String)"Diversion Data Has Changed! Save before continuing?");
                if (n == 2) {
                    return;
                }
                if (n == 0) {
                    this._divDlg.saveForm();
                }
            }
            this._divDlg.setVisible(false);
        }
        if (this._juncDlg != null && this._juncDlg.isVisible()) {
            if (this._juncDlg.isModified() && this._juncDlg.isEditable()) {
                n = RMAIO.postYesNoCancelWarning((Component)((Object)this), (String)"Junction Data Has Changed! Save before continuing?");
                if (n == 2) {
                    return;
                }
                if (n == 0) {
                    this._juncDlg.storeForm();
                }
            }
            this._juncDlg.setVisible(false);
        }
        this.setVisible(false);
    }

    private void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("ResSim Editor");
        this._runCallback = new RmiFileCallBackImpl[1];
        JComponent jComponent = new JLabel("Alternative:", 4);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.getContentPane().add((Component)jComponent, gridBagConstraints);
        this._modelAltTxt = new RmaJTextField();
        this._modelAltTxt.setEditable(false);
        this._modelAltTxt.setModifiable(false);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.getContentPane().add((Component)this._modelAltTxt, gridBagConstraints);
        this._idLabel = new JLabel("ID:", 4);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.getContentPane().add((Component)this._idLabel, gridBagConstraints);
        this._idTxt = new RmaJTextField();
        this._idTxt.setEditable(false);
        this._idTxt.setModifiable(false);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this._idTxt, gridBagConstraints);
        this._configurationLabel = new JLabel("Configuration:", 4);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.getContentPane().add((Component)this._configurationLabel, gridBagConstraints);
        this._configurationTxt = new RmaJTextField();
        this._configurationTxt.setEditable(false);
        this._configurationTxt.setModifiable(false);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.getContentPane().add((Component)this._configurationTxt, gridBagConstraints);
        jComponent = new JLabel("Description:", 4);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.getContentPane().add((Component)jComponent, gridBagConstraints);
        this._descriptionTxt = new RmaJDescriptionField();
        this._descriptionTxt.setEditable(false);
        this._descriptionTxt.setModifiable(false);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this._descriptionTxt, gridBagConstraints);
        jComponent = new JPanel(new GridBagLayout());
        jComponent.setBorder(BorderFactory.createTitledBorder("Editors"));
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)5, (int)5, (int)5);
        this.getContentPane().add((Component)jComponent, gridBagConstraints);
        this._resButton = new JButton("Reservoirs...");
        this._resButton.setMnemonic('R');
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)0);
        jComponent.add((Component)this._resButton, gridBagConstraints);
        this._listener = new ReflectMultiListener();
        RssSimEditDialog rssSimEditDialog = this;
        this._resButton.addActionListener((ActionListener)this._listener.add((Object)rssSimEditDialog, (Object)rssSimEditDialog._resButton, "editReservoirs"));
        this._juncButton = new JButton("Junctions...");
        this._juncButton.setMnemonic('J');
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)0);
        jComponent.add((Component)this._juncButton, gridBagConstraints);
        RssSimEditDialog rssSimEditDialog2 = this;
        this._juncButton.addActionListener((ActionListener)this._listener.add((Object)rssSimEditDialog2, (Object)rssSimEditDialog2._juncButton, "editJunctions"));
        this._reachButton = new JButton("Reaches...");
        this._reachButton.setMnemonic('E');
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)0);
        jComponent.add((Component)this._reachButton, gridBagConstraints);
        RssSimEditDialog rssSimEditDialog3 = this;
        this._reachButton.addActionListener((ActionListener)this._listener.add((Object)rssSimEditDialog3, (Object)rssSimEditDialog3._reachButton, "editReaches"));
        this._divButton = new JButton("Diversions...");
        this._divButton.setMnemonic('D');
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)5);
        jComponent.add((Component)this._divButton, gridBagConstraints);
        RssSimEditDialog rssSimEditDialog4 = this;
        this._divButton.addActionListener((ActionListener)this._listener.add((Object)rssSimEditDialog4, (Object)rssSimEditDialog4._divButton, "editDiversions"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)5);
        jComponent.add((Component)jPanel, gridBagConstraints);
        this._stateVarButton = new JButton("State Variables...");
        this._stateVarButton.setMnemonic('V');
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        jPanel.add((Component)this._stateVarButton, gridBagConstraints);
        this._sysOpButton = new JButton("Reservoir Systems...");
        this._sysOpButton.setMnemonic('S');
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        jPanel.add((Component)this._sysOpButton, gridBagConstraints);
        jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)5);
        jComponent.add((Component)jPanel, gridBagConstraints);
        this._altButton = new JButton("Alternative Editor...");
        this._altButton.setMnemonic('E');
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        jPanel.add((Component)this._altButton, gridBagConstraints);
        this._gvButton = new JButton("Global Variables...");
        this._gvButton.setMnemonic('E');
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        jPanel.add((Component)this._gvButton, gridBagConstraints);
        this._overrideButton = new JButton("Overrides...");
        this._overrideButton.setMnemonic('O');
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        jPanel.add((Component)this._overrideButton, gridBagConstraints);
        this._cmdPanel = new ButtonCmdPanel(12);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        this.getContentPane().add((Component)this._cmdPanel, gridBagConstraints);
        this.pack();
        this.setLocation();
    }

    protected void addListeners() {
        RssSimEditDialog rssSimEditDialog = this;
        this._overrideButton.addActionListener((ActionListener)this._listener.add((Object)rssSimEditDialog, (Object)rssSimEditDialog._overrideButton, "releaseOverride"));
        RssSimEditDialog rssSimEditDialog2 = this;
        this._altButton.addActionListener((ActionListener)this._listener.add((Object)rssSimEditDialog2, (Object)rssSimEditDialog2._altButton, "altEditor"));
        RssSimEditDialog rssSimEditDialog3 = this;
        this._sysOpButton.addActionListener((ActionListener)this._listener.add((Object)rssSimEditDialog3, (Object)rssSimEditDialog3._sysOpButton, "sysOpEditor"));
        RssSimEditDialog rssSimEditDialog4 = this;
        this._stateVarButton.addActionListener((ActionListener)this._listener.add((Object)rssSimEditDialog4, (Object)rssSimEditDialog4._stateVarButton, "stateVariableEditor"));
        RssSimEditDialog rssSimEditDialog5 = this;
        this._gvButton.addActionListener((ActionListener)this._listener.add((Object)rssSimEditDialog5, (Object)rssSimEditDialog5._gvButton, "globalVariableEditor"));
        this._cmdPanel.addCmdPanelListener((ButtonCmdPanelListener)new RssSimEditDialog$1(this));
        this.addWindowListener(new RssSimEditDialog$2(this));
    }

    protected void releaseOverride() {
        ClientMode clientMode = ClientApp.frame().getCurrentMode();
        if (clientMode instanceof RSimSimulationMode && this._rssRun != null) {
            ((RSimSimulationMode)clientMode).releaseOverride(this._rssRun);
        }
    }

    protected void globalVariableEditor() {
        ClientMode clientMode = ClientApp.frame().getCurrentMode();
        if (clientMode instanceof RSimSimulationMode) {
            ((RSimSimulationMode)clientMode).editGlobalVariables();
            return;
        }
        if (clientMode instanceof RSimNetworkMode) {
            ((RSimNetworkMode)clientMode).editGlobalVariables();
        }
    }

    protected void stateVariableEditor() {
        ClientMode clientMode = ClientApp.frame().getCurrentMode();
        if (clientMode instanceof RSimSimulationMode) {
            ((RSimSimulationMode)clientMode).editStateVariables();
            return;
        }
        if (clientMode instanceof RSimNetworkMode) {
            ((RSimNetworkMode)clientMode).editStateVariables();
        }
    }

    protected void altEditor() {
        ClientMode clientMode = ClientApp.frame().getCurrentMode();
        if (clientMode instanceof RSimSimulationMode) {
            String string = null;
            if (this._modelAlt != null) {
                string = this._modelAlt.getName();
            }
            ((RSimSimulationMode)clientMode).displaySingleAlternativeEditor(string);
            return;
        }
        if (clientMode instanceof RSimNetworkMode) {
            AlternativeEditor alternativeEditor = ((RSimNetworkMode)clientMode).displayAlternativeEditor();
            ((AbstractAlternativeEditor)alternativeEditor).setSelectedAlternative(this._rssAlt.getName());
        }
    }

    protected void sysOpEditor() {
        ClientMode clientMode = ClientApp.frame().getCurrentMode();
        if (clientMode instanceof RSimSimulationMode) {
            ((RSimSimulationMode)clientMode).editReservoirSysOps();
            return;
        }
        if (clientMode instanceof RSimNetworkMode) {
            ((RSimNetworkMode)clientMode).editReservoirSysOps(this._rssAlt.getSystem());
        }
    }

    public boolean saveForm() {
        if (this._rssRun != null) {
            this._rssRun.getProxyList().saveManager(UserId.getUserId(), (Manager)this._rssRun);
        }
        return true;
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!bl) {
            this._modelAlt = null;
            this._simRun = null;
            this._system = null;
            if (this._rssRun != null) {
                this._rssRun.getProxyList().getContainer().unloadManager("rss", this._rssRun.getIdentifier());
                RssSimEditDialog rssSimEditDialog = this;
                rssSimEditDialog.unlockManager(rssSimEditDialog._rssRun, "Failed to unlock RssRun ", this._runCallback[0]);
            }
            this._rssRun = null;
        }
    }

    public boolean lockManager(Manager manager, String string, RmiFileCallBackImpl[] rmiFileCallBackImplArray) {
        block8: {
            RmiFileManager rmiFileManager = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
            if (manager == null) {
                return false;
            }
            try {
                Identifier identifier = manager.getIdentifier();
                FileLock fileLock = new FileLock(ClientApp.app().getUser(), 6);
                boolean bl = rmiFileManager.lockFile(identifier, fileLock);
                System.out.println("lockManager: lockRequest for " + identifier.getPath() + " " + String.valueOf(fileLock) + " was " + (bl ? "successful" : "denied"));
                if (bl) break block8;
                System.out.println(string + manager.getName());
                int n = JOptionPane.showOptionDialog((Component)((Object)this), string + manager.getName(), "Lock Failed", 0, 2, null, new Object[]{"OK", "More Info"}, "OK");
                if (n == 0) {
                    return false;
                }
                FileLockInfoJDialog fileLockInfoJDialog = new FileLockInfoJDialog((Dialog)((Object)this));
                fileLockInfoJDialog.setModal(true);
                fileLockInfoJDialog.setFileManager((RmiFileManager)ClientApp.app().getFileManager().getRemote());
                fileLockInfoJDialog.setUserId(ClientApp.app().getUser());
                Vector vector = null;
                try {
                    vector = rmiFileManager.getLockers(identifier);
                }
                catch (RemoteException remoteException) {
                    System.out.println("Failed to get Lock info for Manager " + String.valueOf(remoteException));
                }
                fileLockInfoJDialog.fillForm(identifier, vector);
                fileLockInfoJDialog.pack();
                fileLockInfoJDialog.setVisible(true);
                if (fileLockInfoJDialog.wasUnlocked()) {
                    return this.lockManager(manager, string, rmiFileCallBackImplArray);
                }
                return false;
            }
            catch (RemoteException remoteException) {
                System.out.println("RMI Error with FileManager locking manager " + manager.getName() + " error " + String.valueOf(remoteException));
                return false;
            }
        }
        rmiFileCallBackImplArray[0] = this.setCallback(manager);
        return true;
    }

    public boolean unlockManager(Manager manager, String string, RmiFileCallBackImpl rmiFileCallBackImpl) {
        if (manager == null) {
            return false;
        }
        RmiFileManager rmiFileManager = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        FileLock fileLock = new FileLock(ClientApp.app().getUser(), 7);
        try {
            Identifier identifier = manager.getIdentifier();
            if (!rmiFileManager.unlockFile(identifier, fileLock)) {
                System.out.println(string + manager.getName());
                return false;
            }
            this.removeCallback(rmiFileCallBackImpl, identifier);
            return true;
        }
        catch (RemoteException remoteException) {
            System.out.println("RMI Error with FileManager unlocking " + manager.getName() + " " + String.valueOf(remoteException));
            return false;
        }
    }

    protected RmiFileCallBackImpl setCallback(Manager manager) {
        if ((manager = manager.getIdentifier()) == null || manager.getFile() == null) {
            return null;
        }
        if ((manager = manager.getFile()) instanceof HecFileImpl) {
            RmiFileCallBackImpl rmiFileCallBackImpl;
            try {
                rmiFileCallBackImpl = new RmiFileCallBackImpl((CallBackInterface)this);
            }
            catch (RemoteException remoteException) {
                System.out.println("Error creating callback exception: " + String.valueOf(remoteException));
                remoteException.printStackTrace(System.out);
                return null;
            }
            ((HecFileImpl)manager).setCallBack(rmiFileCallBackImpl.getRemoteReference());
            return rmiFileCallBackImpl;
        }
        return null;
    }

    protected void removeCallback(RmiFileCallBackImpl rmiFileCallBackImpl, Identifier identifier) {
        if (identifier == null || identifier.getFile() == null || rmiFileCallBackImpl == null) {
            return;
        }
        if ((identifier = identifier.getFile()) instanceof HecFileImpl) {
            ((HecFileImpl)identifier).removeCallBack(rmiFileCallBackImpl.getRemoteReference());
        }
    }

    public void notify(String object) {
        System.out.println((String)object);
        object = new StringTokenizer((String)object, "|");
        if (((StringTokenizer)object).countTokens() < 3) {
            return;
        }
        String string = ((StringTokenizer)object).nextToken();
        String string2 = ((StringTokenizer)object).nextToken();
        object = ((StringTokenizer)object).nextToken();
        if (!string2.equalsIgnoreCase("unlocked") || ((String)object).equals(ClientApp.app().getUser())) {
            return;
        }
        object = new RssSimEditDialog$3(this, string, (String)object);
        SwingUtilities.invokeLater((Runnable)object);
    }
}

