/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.model.SimulationRun;
import hec.data.Parameter;
import hec.data.ParameterString;
import hec.data.Units;
import hec.data.UnitsConversionException;
import hec.map.LayerSelectionFactory;
import hec.map.MapGlyphFactory;
import hec.map.MapObjectInterface;
import hec.map.MapPanel;
import hec.map.WorldPt;
import hec.model.AltItem;
import hec.rss.client.RSimSimulationMode;
import hec.rss.client.RssSystemGlyph;
import hec.rss.client.SimulationRunGlyph;
import hec.rss.client.SimulationRunGlyphSelection;
import hec.rss.model.RssOutput;
import hec.rss.model.RssRun;
import hec.rss.model.RssSimulationRun;
import hec.rss.model.RssSystem;
import java.awt.event.MouseEvent;
import java.util.Vector;
import rma.util.RMAIO;

public class RssSimRunGlyph
extends SimulationRunGlyph {
    RssSystem _rssSystem = null;
    RssSystemGlyph _rssGlyph = null;

    public RssSimRunGlyph(MapPanel mapPanel, RssSimulationRun rssSimulationRun) {
        super(mapPanel, (SimulationRun)rssSimulationRun);
        this.initializeGlyph(mapPanel, rssSimulationRun);
    }

    @Override
    public String getToolTipText(WorldPt object, MouseEvent serializable) {
        if ((object = super.getToolTipText((WorldPt)object, (MouseEvent)serializable)) != null && ((String)object).contains("Reservoir:") && (serializable = ClientApp.frame().getCurrentMode()) instanceof RSimSimulationMode) {
            serializable = (RSimSimulationMode)((Object)serializable);
            if ((serializable = ((RSimSimulationMode)((Object)serializable)).getActiveRssRuns(false)) != null && ((Vector)serializable).size() > 0) {
                serializable = ((Vector)serializable).get(0);
                RssOutput rssOutput = ((RssRun)serializable).getOutput();
                String string = this.getElementName((String)object);
                if (rssOutput != null) {
                    Object object2;
                    Object object3;
                    int n = ((String)object).indexOf("</html>");
                    if (n > 0) {
                        object = ((String)object).substring(0, n);
                    }
                    object = ((String)object).concat("<hr>");
                    Object object4 = rssOutput.getStorageForReservoir(this._rssSystem, string, ((RssRun)serializable).getOutputFPart());
                    int n2 = ClientApp.frame().getDisplayUnitSystem();
                    int n3 = this._rssSystem.getUnitSystem();
                    if (object4 != null) {
                        object = ((String)object).concat("<b>Storage Max ");
                        ParameterString parameterString = new ParameterString("(%S)", Parameter.PARAMID_STOR);
                        object3 = parameterString;
                        object2 = parameterString.renderString(ClientApp.frame().getDisplayUnitSystem());
                        object = ((String)object).concat((String)object2);
                        object = ((String)object).concat(": </b>");
                        double d = object4[2];
                        try {
                            d = Units.convertUnits((double)d, (int)Parameter.PARAMID_STOR, (int)n3, (int)n2);
                        }
                        catch (UnitsConversionException unitsConversionException) {
                            UnitsConversionException unitsConversionException2 = unitsConversionException;
                            unitsConversionException.printStackTrace();
                        }
                        object = ((String)object).concat(RMAIO.setPrecision((double)d, (int)2));
                        object = ((String)object).concat("<br>");
                    }
                    if ((object3 = rssOutput.getElevForReservoir(this._rssSystem, string, ((RssRun)serializable).getOutputFPart())) != null) {
                        object = ((String)object).concat("<b>Elevation Max ");
                        object2 = new ParameterString("(%S)", Parameter.PARAMID_ELEV);
                        String string2 = object2.renderString(ClientApp.frame().getDisplayUnitSystem());
                        object = ((String)object).concat(string2);
                        object = ((String)object).concat(": </b>");
                        double d = object3[2];
                        try {
                            d = Units.convertUnits((double)d, (int)Parameter.PARAMID_ELEV, (int)n3, (int)n2);
                        }
                        catch (UnitsConversionException unitsConversionException) {
                            UnitsConversionException unitsConversionException3 = unitsConversionException;
                            unitsConversionException.printStackTrace();
                        }
                        object = ((String)object).concat(RMAIO.setPrecision2((double)d, (int)2));
                        object = ((String)object).concat("<br>");
                    }
                    double[] dArray = rssOutput.getControlReleaseForReservoir(this._rssSystem, string, ((RssRun)serializable).getOutputFPart());
                    object2 = dArray;
                    if (dArray != null) {
                        object = ((String)object).concat("<b>Controlled Release Max ");
                        ParameterString parameterString = new ParameterString("(%S)", Parameter.PARAMID_FLOW);
                        String string3 = parameterString.renderString(ClientApp.frame().getDisplayUnitSystem());
                        object = ((String)object).concat(string3);
                        object = ((String)object).concat(": </b>");
                        Object object5 = object2[2];
                        try {
                            object5 = Units.convertUnits((double)object5, (int)Parameter.PARAMID_FLOW, (int)n3, (int)n2);
                        }
                        catch (UnitsConversionException unitsConversionException) {
                            object4 = (Object)unitsConversionException;
                            unitsConversionException.printStackTrace();
                        }
                        object = ((String)object).concat(RMAIO.setPrecision((double)object5, (int)2));
                        object = ((String)object).concat("<br>");
                    }
                    double[] dArray2 = rssOutput.getUncontrolReleaseForReservoir(this._rssSystem, string, ((RssRun)serializable).getOutputFPart());
                    object2 = dArray2;
                    if (dArray2 != null) {
                        object = ((String)object).concat("<b>Uncontrolled Release Max ");
                        ParameterString parameterString = new ParameterString("(%S)", Parameter.PARAMID_FLOW);
                        String string4 = parameterString.renderString(ClientApp.frame().getDisplayUnitSystem());
                        object = ((String)object).concat(string4);
                        object = ((String)object).concat(": </b>");
                        Object object6 = object2[2];
                        try {
                            Units.convertUnits((double)object6, (int)Parameter.PARAMID_FLOW, (int)n3, (int)n2);
                        }
                        catch (UnitsConversionException unitsConversionException) {
                            object4 = (Object)unitsConversionException;
                            unitsConversionException.printStackTrace();
                        }
                        object = ((String)object).concat(RMAIO.setPrecision((double)object2[0], (int)2));
                        object = ((String)object).concat("<br>");
                    }
                    object = ((String)object).concat("</html>");
                }
            }
        }
        return object;
    }

    private String getUnitsFromParameterString(ParameterString object) {
        int n;
        int n2 = ((String)(object = object.renderString(ClientApp.frame().getDisplayUnitSystem()))).indexOf(40);
        if (n2 >= 0 && (n = ((String)object).indexOf(41, n2)) > 0) {
            object = ((String)object).substring(n2);
        }
        return object;
    }

    private String getElementName(String string) {
        int n = string.indexOf(": </b>");
        if (n == -1) {
            return null;
        }
        int n2 = string.indexOf("<br>");
        if (n2 == -1) {
            return null;
        }
        string = string.substring(n + 6, n2);
        return string;
    }

    protected void initializeGlyph(MapPanel mapPanel, RssSimulationRun object) {
        this._rssSystem = object.getRssSystem();
        if (this._rssSystem != null) {
            System.out.println("RssSimRunGlyph: using ResSim Network:" + this._rssSystem.getIdentifier().getPath());
            this._rssGlyph = (RssSystemGlyph)MapGlyphFactory.newMapGlyph((MapPanel)mapPanel, (MapObjectInterface)this._rssSystem);
            this._modelGlyphs.addElement(this._rssGlyph);
        }
        if (object instanceof SimulationRun) {
            mapPanel = (SimulationRun)object;
            object = mapPanel.getAltList();
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                AltItem altItem = (AltItem)((Vector)object).get(i);
                if ("rss".equals(altItem.getProgram()) || (altItem = mapPanel.getModelAlt(altItem)) == null || !((altItem = altItem.getManager()) instanceof MapObjectInterface) || (altItem = MapGlyphFactory.newMapGlyph((MapPanel)this._mapPanel, (MapObjectInterface)((MapObjectInterface)altItem))) == null) continue;
                this._modelGlyphs.add(altItem);
            }
        }
    }

    static {
        LayerSelectionFactory.addMapping((String)RssSimRunGlyph.class.getName(), (String)SimulationRunGlyphSelection.class.getName());
    }
}

