/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.AbstractSimulationMode;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientMode;
import hec.clientapp.client.CopySimulationRunDataDialog;
import hec.clientapp.client.SimTrialRunTreeNode;
import hec.clientapp.client.SimulationRunTreeNode;
import hec.clientapp.client.SimulationTreeNode;
import hec.clientapp.model.Manager;
import hec.clientapp.model.Simulation;
import hec.clientapp.model.SimulationPeriod;
import hec.clientapp.model.SimulationRun;
import hec.clientapp.model.SimulationTrialRun;
import hec.rss.client.CopySimulationDataDialog;
import hec.rss.client.RSimSimulationMode;
import hec.rss.client.RssSimEditDialog;
import hec.rss.client.RssSimulationRunTreeNode$1;
import hec.watershed.model.ModelAlt;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;

public class RssSimulationRunTreeNode
extends SimulationRunTreeNode {
    protected RssSimEditDialog _rssDialog;

    public RssSimulationRunTreeNode(SimulationRun simulationRun, JTree jTree) {
        super(simulationRun, jTree);
    }

    protected void editRss(int n, String string) {
        System.out.println("editRss " + n);
        SimulationPeriod simulationPeriod = null;
        try {
            SimulationTreeNode simulationTreeNode;
            ClientApp.frame().setWaitCursor();
            if (this._tree != null) {
                simulationTreeNode = (SimulationTreeNode)this._tree.getModel().getRoot();
                simulationPeriod = simulationTreeNode.getSimulation();
            }
            if (simulationPeriod == null) {
                return;
            }
            simulationTreeNode = (ModelAlt)simulationPeriod.openManager(ClientApp.app().getAppType(), ModelAlt.class.getName(), n);
            if (simulationTreeNode == null) {
                System.out.println("editRss: failed to find Model Alternative with index " + n);
                return;
            }
            if (this._rssDialog == null) {
                this._rssDialog = new RssSimEditDialog((JFrame)ClientApp.frame(), false);
            }
            this._rssDialog.fillForm((ModelAlt)simulationTreeNode, this.m_simulationRun);
            simulationPeriod.unloadManager(ClientApp.app().getAppType(), simulationTreeNode.getIdentifier());
            this._rssDialog.setEditable(string.equals("editModel"));
            this._rssDialog.setVisible(true);
            return;
        }
        finally {
            ClientApp.frame().setDefaultCursor();
        }
    }

    public void onSaveToBaseMenuItem() {
        this.saveSimulation();
        CopySimulationRunDataDialog copySimulationRunDataDialog = new CopySimulationRunDataDialog((Frame)ClientApp.frame(), true);
        if (this._tree != null) {
            SimulationTreeNode simulationTreeNode = (SimulationTreeNode)this._tree.getModel().getRoot();
            copySimulationRunDataDialog.setSimulation(simulationTreeNode.getSimulation());
        }
        copySimulationRunDataDialog.setSimulationRun(this.getSimulationRun());
        copySimulationRunDataDialog.fillForm();
        copySimulationRunDataDialog.setVisible(true);
        if (copySimulationRunDataDialog.isCanceled()) {
            return;
        }
    }

    protected void replaceFromSimRunFromBase(SimulationRun object) {
        SimulationTreeNode simulationTreeNode;
        this.saveSimulation();
        CopySimulationDataDialog copySimulationDataDialog = new CopySimulationDataDialog((Frame)ClientApp.frame(), true);
        copySimulationDataDialog.setRefreshData();
        if (this._tree != null) {
            simulationTreeNode = (SimulationTreeNode)this._tree.getModel().getRoot();
            copySimulationDataDialog.setSimulation(simulationTreeNode.getSimulation());
        }
        copySimulationDataDialog.setSimulationRun((SimulationRun)object);
        copySimulationDataDialog.setVisible(true);
        if (copySimulationDataDialog.isCanceled()) {
            return;
        }
        simulationTreeNode = ClientApp.frame().getCurrentMode();
        if (simulationTreeNode instanceof RSimSimulationMode) {
            object = (RSimSimulationMode)simulationTreeNode;
            object.updateAfterReplaceFromBase();
        }
    }

    private void saveSimulation() {
        if (this._tree != null) {
            boolean bl;
            SimulationTreeNode simulationTreeNode = (SimulationTreeNode)this._tree.getModel().getRoot();
            if ((simulationTreeNode = simulationTreeNode.getSimulation()) != null && simulationTreeNode.isModified() && !(bl = ClientApp.Workspace().saveManager("rss", (Manager)simulationTreeNode))) {
                ClientApp.app().postWarning("Failed to save Simulation " + simulationTreeNode.getName(), "Save Failed");
            }
        }
    }

    public void onNewTrialMenuItem() {
        RssSimulationRunTreeNode$1 rssSimulationRunTreeNode$1 = new RssSimulationRunTreeNode$1(this, (Frame)ClientApp.frame(), true);
        ClientMode clientMode = ClientApp.frame().getCurrentMode();
        if (!(clientMode instanceof AbstractSimulationMode)) {
            System.out.println("onNewTrialMenuItem: Not in a Simulation Module.");
            return;
        }
        clientMode = (AbstractSimulationMode)clientMode;
        SimulationTreeNode simulationTreeNode = null;
        if (this._tree != null) {
            simulationTreeNode = (SimulationTreeNode)this._tree.getModel().getRoot();
            simulationTreeNode = simulationTreeNode.getSimulation();
            rssSimulationRunTreeNode$1.setSimulation((Simulation)simulationTreeNode);
        }
        if (simulationTreeNode == null) {
            if (Boolean.getBoolean("DEBUG")) {
                System.out.println("ERROR <SimulationRunTreeNode.onNewTrialMenuItem()> : Retrieved a NULL Simulation Period from the ROOT");
            }
            return;
        }
        rssSimulationRunTreeNode$1.setSimulationRun(this.getSimulationRun());
        rssSimulationRunTreeNode$1.fillForm();
        if (rssSimulationRunTreeNode$1.getNewTrialName(false) == null) {
            JOptionPane.showMessageDialog((Component)ClientApp.frame(), "The maximum number of trials for " + this.getSimulationRun().getUserName() + " has been reached.\nYou will need to delete a trial in order to create another one for this Run.");
            return;
        }
        rssSimulationRunTreeNode$1.setVisible(true);
        if (rssSimulationRunTreeNode$1.isCanceled()) {
            return;
        }
        simulationTreeNode = (SimulationTrialRun)rssSimulationRunTreeNode$1.getNewTrialRun();
        if (simulationTreeNode == null) {
            return;
        }
        rssSimulationRunTreeNode$1 = clientMode.newSimulationRunTreeNode((SimulationRun)simulationTreeNode, this._tree);
        this.add((MutableTreeNode)((Object)rssSimulationRunTreeNode$1));
        this.orderNodeNumbers();
        ((DefaultTreeModel)this._tree.getModel()).nodeStructureChanged(this.getParent());
        ((SimTrialRunTreeNode)rssSimulationRunTreeNode$1).setActiveTrial(true);
        rssSimulationRunTreeNode$1.setSelected(true);
        this.expand();
    }
}

