/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.model.Manager;
import hec.rss.client.AbstractElementOverridesPanel;
import hec.rss.client.DiversionOverridesPanel;
import hec.rss.client.ReservoirOverridesPanel;
import hec.rss.client.RssSpecifyOverridesDialog$1;
import hec.rss.client.RssSpecifyOverridesDialog$2;
import hec.rss.client.RssSpecifyOverridesDialog$3;
import hec.rss.model.RssAlt;
import hec.rss.model.RssRun;
import hec.rss.plugins.factories.AltPluginDataFactory;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemListener;
import java.util.Collection;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import mil.army.usace.hec.rmi.server.RmiFileCallBackImpl;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaNavigationPanel;
import rma.swing.event.ReflectMultiListener;
import rma.swing.list.RmaListModel;

public class RssSpecifyOverridesDialog
extends RmaJDialog {
    public static final String DEF_TITLE = "Overrides ";
    Frame _parent;
    RssRun _rssRun;
    boolean _first = true;
    ReflectMultiListener _listener;
    ButtonCmdPanel cmdButtonPanel;
    int _wkspUnitSys;
    RmiFileCallBackImpl _lockCallback;
    protected JTabbedPane _tabbedPane;
    private JPanel _ensemblePanel;
    private RmaNavigationPanel _ensembleNavPanel;
    private RmaJComboBox _ensembleCombo;
    private RssAlt _alt;
    private JPanel _topPanel;
    private JLabel _ensembleLabel;
    private JLabel _ensembleInfoLabel;
    private ReservoirOverridesPanel _reservoirOverridesPanel;
    private DiversionOverridesPanel _diversionOverridesPanel;
    protected static final Insets a = new Insets(0, 0, 0, 0);
    protected static final Insets b = new Insets(5, 5, 5, 5);
    protected static final Insets c = new Insets(5, 5, 0, 0);
    protected static final Insets d = new Insets(5, 5, 5, 0);
    protected static final Insets e = new Insets(5, 5, 0, 5);
    private String _title;

    public RssSpecifyOverridesDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this._parent = frame;
        this.buildControls();
        this.addListeners();
    }

    private void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setSize(765, 700);
        RssSpecifyOverridesDialog rssSpecifyOverridesDialog = this;
        rssSpecifyOverridesDialog.setLocationRelativeTo(rssSpecifyOverridesDialog.getParent());
        this._title = DEF_TITLE;
        RssSpecifyOverridesDialog rssSpecifyOverridesDialog2 = this;
        rssSpecifyOverridesDialog2.setTitle(rssSpecifyOverridesDialog2._title);
        this._listener = new ReflectMultiListener();
        this._ensemblePanel = new JPanel(new GridBagLayout());
        this.getContentPane().add((Component)this._ensemblePanel, new RmaGridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 2, a, 0, 0));
        this._ensembleLabel = new JLabel("Ensemble Member:");
        this._ensembleLabel.setDisplayedMnemonic('E');
        this._ensemblePanel.add((Component)this._ensembleLabel, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, c, 0, 0));
        this._ensembleCombo = new RmaJComboBox();
        this._ensembleLabel.setLabelFor((Component)this._ensembleCombo);
        this._ensemblePanel.add((Component)this._ensembleCombo, new RmaGridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 18, 2, c, 0, 0));
        this._ensembleNavPanel = new RmaNavigationPanel();
        this._ensemblePanel.add((Component)this._ensembleNavPanel, new RmaGridBagConstraints(2, 0, 1, 1, 0.5, 0.0, 18, 2, c, 0, 0));
        this._ensembleInfoLabel = new JLabel("Overrides entered apply to all members");
        this._ensembleInfoLabel.setToolTipText("Overrides entered will be applied to all ensemble members");
        this._ensemblePanel.add((Component)this._ensembleInfoLabel, new RmaGridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 18, 0, c, 0, 0));
        this._reservoirOverridesPanel = new ReservoirOverridesPanel(this);
        this._diversionOverridesPanel = new DiversionOverridesPanel(this);
        this._tabbedPane = new JTabbedPane();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._tabbedPane, gridBagConstraints);
        this._tabbedPane.add("Reservoirs", (Component)((Object)this._reservoirOverridesPanel));
        this._tabbedPane.add("Diversions", (Component)((Object)this._diversionOverridesPanel));
        this.cmdButtonPanel = new ButtonCmdPanel(14);
        this.getContentPane().add((Component)this.cmdButtonPanel, new RmaGridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 0), 0, 0));
        this._ensembleNavPanel.fillForm((JComboBox)this._ensembleCombo);
    }

    protected void addListeners() {
        this.addWindowListener(new RssSpecifyOverridesDialog$1(this));
        this.cmdButtonPanel.addCmdPanelListener((ButtonCmdPanelListener)new RssSpecifyOverridesDialog$2(this));
        this._ensembleCombo.addItemListener((ItemListener)new RssSpecifyOverridesDialog$3(this));
    }

    public RssSpecifyOverridesDialog(Frame frame, boolean bl, String string) {
        this(frame, bl);
        this.setTitle(string);
        this._title = string;
    }

    public void setLockCallback(RmiFileCallBackImpl rmiFileCallBackImpl) {
        this._lockCallback = rmiFileCallBackImpl;
    }

    public void setVisible(boolean bl) {
        if (!bl && this._lockCallback != null) {
            ClientApp.app();
            ClientApp.frame().getCurrentMode().unlockManager((Manager)this._rssRun, "Failed to unlock ResSim Run " + this._rssRun.getName(), this._lockCallback, null);
        }
        super.setVisible(bl);
    }

    void checkSaveChanges() {
        int n;
        if (this.isModified() && (n = JOptionPane.showConfirmDialog((Component)((Object)this), "Overrides have changed. Save Changes?", "Save Changes", 0)) == 0) {
            this.apply_Action();
        }
    }

    public void setRun(RssRun rssRun) {
        this._rssRun = rssRun;
        if (this._rssRun != null && this._rssRun.getAlternative() != null) {
            this.initDlg();
        }
    }

    public void initDlg() {
        if (this._rssRun == null) {
            return;
        }
        Object object = this._rssRun.getAlternative();
        if (object != null) {
            object = object.getName();
            int n = ((String)object).lastIndexOf(58);
            object = ((String)object).substring(n + 1);
            this._title = "Overrides - " + (String)object;
            RssSpecifyOverridesDialog rssSpecifyOverridesDialog = this;
            rssSpecifyOverridesDialog.setTitle(rssSpecifyOverridesDialog._title);
        }
        this._rssRun.updateReleaseOverrides();
        this._reservoirOverridesPanel.initPanel(this._rssRun);
        this._diversionOverridesPanel.initPanel(this._rssRun);
        this.ensembleInit();
        if (this._ensembleCombo.isVisible() && this._ensembleCombo.getItemCount() > 0) {
            this._ensembleCombo.setSelectedIndex(0);
        }
        this._reservoirOverridesPanel.fillPanel();
        this._diversionOverridesPanel.fillPanel();
    }

    private void ensembleInit() {
        boolean bl;
        block2: {
            this._alt = this._rssRun.getAlternative();
            bl = false;
            try {
                Object object = this._alt.getAltPluginData(AltPluginDataFactory.ENSEMBLE);
                if (object == null || !object.useCompute() || (object = object.getCollectionNumbers(this._alt, this._rssRun.getRunTimeWindow().getStartTime())) == null || object.isEmpty()) break block2;
                RmaListModel rmaListModel = new RmaListModel(false, (Collection)object);
                this._ensembleCombo.setModel((ComboBoxModel)rmaListModel);
                bl = true;
            }
            catch (Throwable throwable) {
                this._ensembleLabel.setVisible(false);
                this._ensembleCombo.setVisible(false);
                this._ensembleNavPanel.setVisible(false);
                this._ensembleInfoLabel.setVisible(false);
                this._reservoirOverridesPanel.setUseAltResultsPanelVisible(false);
                this._diversionOverridesPanel.setUseAltResultsPanelVisible(false);
                throw throwable;
            }
        }
        this._ensembleLabel.setVisible(bl);
        this._ensembleCombo.setVisible(bl);
        this._ensembleNavPanel.setVisible(bl);
        this._ensembleInfoLabel.setVisible(bl);
        this._reservoirOverridesPanel.setUseAltResultsPanelVisible(bl);
        this._diversionOverridesPanel.setUseAltResultsPanelVisible(bl);
    }

    private void ok_Action() {
        this.apply_Action();
        this.closeDialog();
    }

    public void apply_Action() {
        ((AbstractElementOverridesPanel)this._reservoirOverridesPanel).savePanel();
        ((AbstractElementOverridesPanel)this._diversionOverridesPanel).savePanel();
        if (this._rssRun.isModified()) {
            this._rssRun.writeFile(this._rssRun.getIdentifier());
        }
        this.setModified(false);
    }

    private void cancel_Action() {
        this.closeDialog();
    }

    public void closeDialog() {
        this.checkSaveChanges();
        this._reservoirOverridesPanel.closing();
        this._diversionOverridesPanel.closing();
        this.setVisible(false);
    }

    public void importOverridesAction() {
        Component component = this._tabbedPane.getSelectedComponent();
        if (component instanceof AbstractElementOverridesPanel) {
            ((AbstractElementOverridesPanel)((Object)component)).importOverridesAction();
        }
    }

    public void editingCanceled(ChangeEvent changeEvent) {
    }

    protected void ensembleComboChangedAction() {
        if (!this._ensemblePanel.isVisible()) {
            return;
        }
        this.checkSaveChanges();
        String string = (String)this._ensembleCombo.getSelectedItem();
        string = "C:".concat(string).concat("|");
        int n = this._tabbedPane.getTabCount();
        for (int i = 0; i < n; ++i) {
            Object object = this._tabbedPane.getComponentAt(i);
            if (!(object instanceof AbstractElementOverridesPanel)) continue;
            object = (AbstractElementOverridesPanel)object;
            ((AbstractElementOverridesPanel)object).setEnsemblePrefix(string);
        }
        this._reservoirOverridesPanel.fillPanelWithSelectedElement();
        this._diversionOverridesPanel.fillPanelWithSelectedElement();
    }

    public void setModified(boolean bl) {
        super.setModified(bl);
        if (bl) {
            RssSpecifyOverridesDialog rssSpecifyOverridesDialog = this;
            rssSpecifyOverridesDialog.setTitle(rssSpecifyOverridesDialog._title + "*");
            return;
        }
        RssSpecifyOverridesDialog rssSpecifyOverridesDialog = this;
        rssSpecifyOverridesDialog.setTitle(rssSpecifyOverridesDialog._title);
    }
}

