/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.model.AbstractSimulation;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.clientapp.model.SimulationRun;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.heclib.util.HecTime;
import hec.model.RunInfo;
import hec.rss.client.RssReportsJFrame;
import hec.rss.client.RssReportsJPanel;
import hec.rss.client.RssSummaryJFrame$1;
import hec.rss.client.RssSummaryJFrame$2;
import hec.rss.client.RssSummaryJPanel;
import hec.rss.client.SpecifyTimeDialog;
import hec.rss.client.SummaryReportCollectionOptionsEditor;
import hec.rss.model.RssRun;
import hec.rss.plugins.model.AltPluginData;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import rma.swing.RmaJFrame;
import rma.swing.RmaJTable;

public class RssSummaryJFrame
extends RssReportsJFrame {
    private RssSummaryJPanel _rsp;
    private int _reportType = -1;
    private String _reportTime = null;
    private String _lookbackDateStr;
    private String _startTimeDateStr;
    private String _endTimeDateStr;
    private String[] _titleHeader;
    private List<List<String>> _collectionLists = new ArrayList<List<String>>();
    private String _forecastPath = null;
    private Vector _runNames;
    private List<SimulationRun> _simRuns;
    private String _simulationPath;
    private AbstractSimulation _sim;
    private ManagerProxyListContainer _wksp;
    public static final int REPORT_RESERVOIR = 0;
    public static final int REPORT_FLOW = 1;
    public static final int REPORT_STAGE = 2;
    public static final int REPORT_DECISION = 0;
    public static final int REPORT_POWER = 4;
    public static final int REPORT_GATES = 7;
    public static final int SPECIFIED_TIME_REPORT_RESERVOIR = 8;
    public static final int SPECIFIED_TIME_REPORT_FLOW = 9;
    public static final int SPECIFIED_TIME_REPORT_STAGE = 10;
    public static final int SPECIFIED_TIME_REPORT_POWER = 11;
    public static final int SPECIFIED_TIME_REPORT_GATES = 12;
    private static String[] a = RssSummaryJPanel.a;

    public RssSummaryJFrame(Vector vector, String string, int n, ManagerProxyListContainer managerProxyListContainer, String[] stringArray) {
        super(vector, string, n, managerProxyListContainer);
        this._reportType = n;
        System.out.println("This is the report type " + n);
        this.setTitle(a[n]);
        this._rsp = new RssSummaryJPanel(vector, string, n, managerProxyListContainer, stringArray);
        this._rsp.rTbl_table.setDisplayUnitsSystem(ClientApp.frame().getDisplayUnitSystem());
        RssSummaryJFrame rssSummaryJFrame = this;
        rssSummaryJFrame.checkRuns(rssSummaryJFrame._rsp.getFailedRunNames());
        RssSummaryJFrame rssSummaryJFrame2 = this;
        rssSummaryJFrame2.makeForm(rssSummaryJFrame2._rsp);
    }

    public RssSummaryJFrame(Vector vector, String string, int n, ManagerProxyListContainer managerProxyListContainer) {
        super(vector, string, n, managerProxyListContainer);
        this._reportType = n;
        this._forecastPath = string;
        this._runNames = vector;
        this._wksp = managerProxyListContainer;
        this.setTitle(a[n]);
        this._rsp = new RssSummaryJPanel(vector, string, n, managerProxyListContainer);
        this._rsp.rTbl_table.setDisplayUnitsSystem(ClientApp.frame().getDisplayUnitSystem());
        RssSummaryJFrame rssSummaryJFrame = this;
        rssSummaryJFrame.checkRuns(rssSummaryJFrame._rsp.getFailedRunNames());
        RssSummaryJFrame rssSummaryJFrame2 = this;
        rssSummaryJFrame2.makeForm(rssSummaryJFrame2._rsp);
    }

    public RssSummaryJFrame(List<SimulationRun> list, String string, AbstractSimulation abstractSimulation, int n) {
        this._reportType = n;
        this._simRuns = list;
        this._sim = abstractSimulation;
        this._simulationPath = string;
        this.setTitle(a[n]);
        this._rsp = new RssSummaryJPanel(list, abstractSimulation, string, n);
        this._rsp.rTbl_table.setDisplayUnitsSystem(ClientApp.frame().getDisplayUnitSystem());
        RssSummaryJFrame rssSummaryJFrame = this;
        rssSummaryJFrame.checkRuns(rssSummaryJFrame._rsp.getFailedRunNames());
        RssSummaryJFrame rssSummaryJFrame2 = this;
        rssSummaryJFrame2.makeForm(rssSummaryJFrame2._rsp);
    }

    public RssSummaryJFrame(Vector vector, String string, int n, ManagerProxyListContainer managerProxyListContainer, String string2) {
        super(vector, string, n, managerProxyListContainer);
        this._runNames = vector;
        this._reportType = n;
        this._reportTime = string2;
        this.setTitle(a[n]);
        this._rsp = new RssSummaryJPanel(vector, string, n, managerProxyListContainer, string2);
        this._rsp.rTbl_table.setDisplayUnitsSystem(ClientApp.frame().getDisplayUnitSystem());
        RssSummaryJFrame rssSummaryJFrame = this;
        rssSummaryJFrame.checkRuns(rssSummaryJFrame._rsp.getFailedRunNames());
        RssSummaryJFrame rssSummaryJFrame2 = this;
        rssSummaryJFrame2.makeForm(rssSummaryJFrame2._rsp);
    }

    public RssSummaryJFrame(Vector vector, int n) {
        super(vector, n);
        this._runNames = vector;
        this._reportType = n;
        this.setTitle(a[n]);
        this._rsp = new RssSummaryJPanel(vector, n);
        this._rsp.rTbl_table.setDisplayUnitsSystem(ClientApp.frame().getDisplayUnitSystem());
        RssSummaryJFrame rssSummaryJFrame = this;
        rssSummaryJFrame.checkRuns(rssSummaryJFrame._rsp.getFailedRunNames());
        RssSummaryJFrame rssSummaryJFrame2 = this;
        rssSummaryJFrame2.makeForm(rssSummaryJFrame2._rsp);
    }

    public RssSummaryJFrame(String[] stringArray, String[] stringArray2, Object[][] objectArray, String[] stringArray3, int[] nArray, boolean bl) {
        super(stringArray, stringArray2, bl);
        this._rsp = new RssSummaryJPanel(stringArray, stringArray2, objectArray, stringArray3, nArray, bl);
        this._rsp.rTbl_table.setDisplayUnitsSystem(ClientApp.frame().getDisplayUnitSystem());
        this._titleHeader = stringArray;
        RssSummaryJFrame rssSummaryJFrame = this;
        rssSummaryJFrame.makeForm(rssSummaryJFrame._rsp);
    }

    public void updateReport(String[] stringArray, String[] stringArray2, Object[][] objectArray, String[] stringArray3, int[] nArray, boolean bl) {
        this.updateReport(stringArray, stringArray2, bl);
        this._rsp.removeAll();
        this._rsp = new RssSummaryJPanel(stringArray, stringArray2, objectArray, stringArray3, nArray, bl);
        this._rsp.rTbl_table.setDisplayUnitsSystem(ClientApp.frame().getDisplayUnitSystem());
        this._titleHeader = stringArray;
        RssSummaryJFrame rssSummaryJFrame = this;
        rssSummaryJFrame.makeForm(rssSummaryJFrame._rsp);
    }

    public void addTargetFootNotes(double d) {
        RmaJTable rmaJTable = super.getTable();
        rmaJTable.appendRow();
        Vector<String> vector = new Vector<String>(2);
        String string = "Target Power /nGeneration: ";
        vector.add(string);
        vector.add((String)new ParamDouble(d, Parameter.PARAMID_POWER, super.getUnitDisplaySystem()));
        rmaJTable.appendRow(vector);
    }

    public void listLocations() {
        this._rsp.listLocations();
    }

    private boolean checkRuns(List list) {
        int n = list.size();
        if (n == 0) {
            return true;
        }
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string.concat("<br>").concat((String)list.get(i));
        }
        JOptionPane.showMessageDialog((Component)ClientApp.frame(), "<html>Failed to open ResSim Run file" + (n > 1 ? "s" : "") + " for:<br>" + string + "<br><br><hr>Alternative" + (n > 1 ? "s" : "") + " probably " + (n > 1 ? "haven't" : "hasn't") + " been computed.</html>", "Missing Run File", 2);
        return false;
    }

    @Override
    protected void makeForm(RssReportsJPanel object) {
        Object object2;
        super.makeForm((RssReportsJPanel)object);
        object = null;
        if (this._rsp._runvec != null) {
            for (int i = 0; i < this._rsp._runvec.size(); ++i) {
                List<AltPluginData> list;
                object2 = (RunInfo)this._rsp._runvec.get(i);
                object2 = (RssRun)((RunInfo)object2).run;
                if (object2 == null || (list = ((RssRun)object2).getAlternative().getPluginDataList()) == null || list.isEmpty()) continue;
                for (int j = 0; j < list.size(); ++j) {
                    AltPluginData altPluginData = list.get(j);
                    if (!altPluginData.useCompute()) continue;
                    object = altPluginData.getCollectionNumbers(((RssRun)object2).getAlternative(), ((RssRun)object2).getRunTimeWindow().getStartTime());
                    this._collectionLists.add((List<String>)object);
                }
            }
        }
        if (this._reportType != -1 && this._reportType <= 7 || object != null && object.size() > 0) {
            if (this._reportType != -1 && this._reportType <= 7) {
                JMenuItem jMenuItem = new JMenuItem("Specify Time", 83);
                jMenuItem.addActionListener(new RssSummaryJFrame$1(this));
            }
            if (this._collectionLists != null && this._collectionLists.size() > 0) {
                JMenu jMenu = new JMenu("Options");
                jMenu.setMnemonic('O');
                object2 = new JMenuItem("Set Collection Run", 67);
                jMenu.add((JMenuItem)object2);
                ((AbstractButton)object2).addActionListener(new RssSummaryJFrame$2(this));
                this.getJMenuBar().add(jMenu);
            }
        }
    }

    void specifyReportTime() {
        Object object;
        SpecifyTimeDialog specifyTimeDialog = new SpecifyTimeDialog((Frame)((Object)this), true);
        TimeZone timeZone = ClientApp.Workspace().getWatershedTimeZone();
        if (this._rsp._runvec != null && this._rsp._runvec.size() > 0) {
            object = (RunInfo)this._rsp._runvec.get(0);
            object = (RssRun)((RunInfo)object).run;
            if (object != null) {
                specifyTimeDialog.setDateTime(((RssRun)object).getRunTimeWindow().getStartTime(), timeZone);
            }
        } else {
            specifyTimeDialog.setDateTime(new HecTime(), timeZone);
        }
        specifyTimeDialog.setTitle("Specify Report Time");
        specifyTimeDialog.setVisible(true);
        if (specifyTimeDialog.isCanceled()) {
            return;
        }
        object = specifyTimeDialog.getTimeArray();
        object = new RssSummaryJFrame(this._rsp.getRunNames(), this._rsp.getWkspPath(), this._reportType + 6, this._rsp.getWorkspace(), object.element(0).dateAndTime(104));
        object.setLocationRelativeTo((Component)ClientApp.frame());
        object.setVisible(true);
    }

    public void selectCollectionRun() {
        RssSummaryJFrame rssSummaryJFrame = this;
        SummaryReportCollectionOptionsEditor summaryReportCollectionOptionsEditor = new SummaryReportCollectionOptionsEditor((JFrame)((Object)rssSummaryJFrame), rssSummaryJFrame._rsp._runvec, this._collectionLists);
        summaryReportCollectionOptionsEditor.setVisible(true);
        this._rsp.removeAll();
        if (this._runNames != null) {
            this._rsp = new RssSummaryJPanel(this._runNames, this._forecastPath, this._reportType, this._wksp, "");
        } else if (this._simRuns != null) {
            this._rsp = new RssSummaryJPanel(this._simRuns, this._sim, this._simulationPath, this._reportType);
        }
        this._rsp.rTbl_table.setDisplayUnitsSystem(ClientApp.frame().getDisplayUnitSystem());
        RssSummaryJFrame rssSummaryJFrame2 = this;
        rssSummaryJFrame2.makeForm(rssSummaryJFrame2._rsp);
        this.setVisible(true);
    }

    public boolean updateTimeZone(Container object) {
        boolean bl = super.updateTimeZone((Container)object);
        if (object == this) {
            if (this._reportType > 7 && this._reportTime != null) {
                object = ClientApp.Workspace().getWatershedTimeZone();
                Object object2 = new HecTime(this._reportTime);
                object = object2.getJavaDate(((TimeZone)object).getRawOffset() / 60000);
                object2 = new SimpleDateFormat("dd MMM yyyy kk:mm");
                ((DateFormat)object2).setTimeZone(RmaJFrame.getTimeZone());
                object = ((DateFormat)object2).format((Date)object);
                this._rsp.getTable().getColumnModel().getColumn(1).setHeaderValue(object);
            }
            if (this._reportType == 0 && this._titleHeader != null && this._titleHeader.length >= 3 && this._lookbackDateStr != null && this._startTimeDateStr != null) {
            }
        }
        return bl;
    }

    public void setDateStrings(String string, String string2, String string3) {
        this._lookbackDateStr = string;
        this._startTimeDateStr = string2;
        this._endTimeDateStr = string3;
    }
}

