/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.model.AbstractSimulation;
import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.clientapp.model.SimulationRun;
import hec.model.RunInfo;
import hec.rss.client.RssReportsJPanel;
import hec.rss.model.RssAlt;
import hec.rss.model.RssOutput;
import hec.rss.model.RssRun;
import hec.rss.model.RssSystem;
import java.awt.Color;
import java.util.List;
import java.util.Vector;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import rma.swing.table.ColumnGroup;
import rma.swing.table.GroupableTableHeader;
import rma.swing.table.ParameterStringCellRenderer;
import rma.swing.table.RmaTableModel;

public class RssSummaryJPanel
extends RssReportsJPanel {
    public static final int REPORT_RESERVOIR = 0;
    public static final int REPORT_FLOW = 1;
    public static final int REPORT_STAGE = 2;
    public static final int REPORT_DECISION = 3;
    public static final int REPORT_POWER = 4;
    public static final int REPORT_GATES = 7;
    public static final int SPECIFIED_TIME_REPORT_RESERVOIR = 8;
    public static final int SPECIFIED_TIME_REPORT_FLOW = 9;
    public static final int SPECIFIED_TIME_REPORT_STAGE = 10;
    public static final int SPECIFIED_TIME_REPORT_POWER = 11;
    public static final int SPECIFIED_TIME_REPORT_GATES = 12;
    static final String[] a = new String[]{"Reservoir Summary Report", "Flow Summary Report", "Stage Summary Report", "Release Decision Report", "Power Summary Report", "Gate Summary Report", "Reservoir Specified Time Report", "Gate Summary Report", "Stage Specified Time Report", "Hey this isn't a valid report type Report", "Power Specified Time Report", "Gate Specified Time Report"};
    private RssOutput output;
    private boolean[] _grayRows = new boolean[]{true};
    private Object[][] _data = new Object[][]{{"No Data", null, null, null}};
    private int _numRuns = 1;
    private int _numCols = 4;
    private String[] _colNames;
    private int[] _colWidths;
    private Vector _locations = new Vector();
    private int _rowsPerGroup = 1;
    private int _colsPerGroup = 3;
    private Object[][] _tableData;
    private String[] _varList;
    int _reportType;

    public RssSummaryJPanel(Vector vector, String string, int n, ManagerProxyListContainer managerProxyListContainer) {
        super(vector, string, n, managerProxyListContainer);
        this._reportType = n;
        this._runvec = this.getRunVec(vector, string, managerProxyListContainer);
        RssSummaryJPanel rssSummaryJPanel = this;
        rssSummaryJPanel.init(rssSummaryJPanel._runvec, n);
        this.closeRuns();
    }

    public RssSummaryJPanel(List<SimulationRun> list, AbstractSimulation abstractSimulation, String string, int n) {
        super(list, n, abstractSimulation, string);
        this._reportType = n;
        this._runvec = this.getRunVec(list, string, abstractSimulation);
        RssSummaryJPanel rssSummaryJPanel = this;
        rssSummaryJPanel.init(rssSummaryJPanel._runvec, n);
        this.closeRuns();
    }

    public RssSummaryJPanel(Vector vector, String string, int n, ManagerProxyListContainer managerProxyListContainer, String[] stringArray) {
        super(vector, string, n, managerProxyListContainer);
        this._reportType = n;
        System.out.println("This is the type again " + n);
        this._runvec = this.getRunVec(vector, string, managerProxyListContainer);
        this._varList = stringArray;
        RssSummaryJPanel rssSummaryJPanel = this;
        rssSummaryJPanel.init(rssSummaryJPanel._runvec, n);
        this.closeRuns();
    }

    public RssSummaryJPanel(Vector vector, String string, int n, ManagerProxyListContainer managerProxyListContainer, String string2) {
        super(vector, string, n, managerProxyListContainer);
        this._reportType = n;
        this._runvec = this.getRunVec(vector, string, managerProxyListContainer);
        RssSummaryJPanel rssSummaryJPanel = this;
        rssSummaryJPanel.init(rssSummaryJPanel._runvec, n, string2);
        this.closeRuns();
    }

    public RssSummaryJPanel(Vector vector, int n) {
        super(vector, n);
        this._reportType = n;
        this._runvec = vector;
        this.init(vector, n);
    }

    public RssSummaryJPanel(String[] stringArray, String[] stringArray2, Object[][] objectArray, String[] stringArray3, int[] nArray, boolean bl) {
        super(stringArray, stringArray2, bl);
        this._colNames = stringArray3;
        this._colWidths = nArray;
        this._numCols = nArray.length;
        this._data = objectArray;
        this.setTableData(objectArray);
    }

    private void init(List list, int n) {
        this.init(list, n, null);
    }

    private void init(List list, int n, String string) {
        this._numRuns = list.size();
        if (this._numRuns <= 0) {
            return;
        }
        this.setColumnHeads(n, string);
        System.out.println("-- Runs...: " + this._numRuns);
        System.out.println("-- Cols...: " + this._numCols);
        RssRun rssRun = null;
        if (this._numRuns > 1) {
            for (int i = 0; i < this._numRuns; ++i) {
                Object e = list.get(i);
                if (e instanceof RunInfo) {
                    rssRun = (RssRun)((RunInfo)e).run;
                } else if (e instanceof RssRun) {
                    rssRun = (RssRun)e;
                } else if (e instanceof List) {
                    List list2 = (List)e;
                    for (int j = 0; j < list2.size(); ++j) {
                        e = list2.get(j);
                        if (e instanceof RunInfo) {
                            rssRun = (RssRun)((RunInfo)e).run;
                        } else {
                            if (!(e instanceof RssRun)) continue;
                            rssRun = (RssRun)e;
                        }
                        this.prepareRunData(rssRun, n, string);
                    }
                    rssRun = null;
                }
                if (rssRun == null) continue;
                this.prepareRunData(rssRun, n, string);
            }
            this.prepareTableData(list, n, string);
            RssSummaryJPanel rssSummaryJPanel = this;
            rssSummaryJPanel.setTableData(rssSummaryJPanel._tableData);
            this.setColumnGroups(list, n);
            return;
        }
        Object e = list.get(0);
        if (e instanceof RunInfo) {
            rssRun = (RssRun)((RunInfo)e).run;
        } else if (e instanceof RssRun) {
            rssRun = (RssRun)e;
        } else if (e instanceof List) {
            List list3 = (List)e;
            for (int i = 0; i < list3.size(); ++i) {
                e = list3.get(i);
                if (e instanceof RunInfo) {
                    rssRun = (RssRun)((RunInfo)e).run;
                } else {
                    if (!(e instanceof RssRun)) continue;
                    rssRun = (RssRun)e;
                }
                this.prepareRunData(rssRun, n, string);
            }
            this.prepareTableData(list3, n, string);
            RssSummaryJPanel rssSummaryJPanel = this;
            rssSummaryJPanel.setTableData(rssSummaryJPanel._data);
            return;
        }
        this.prepareRunData(rssRun, n, string);
        RssSummaryJPanel rssSummaryJPanel = this;
        rssSummaryJPanel.setTableData(rssSummaryJPanel._data);
    }

    void prepareTableData(List list, int n, String string) {
        this._tableData = new Object[this._rowsPerGroup * this._locations.size()][this._numCols];
        for (int i = 0; i < this._numRuns; ++i) {
            Object object = list.get(i);
            object = object instanceof RunInfo ? (RssRun)((RunInfo)object).run : (RssRun)list.get(i);
            this.output = ((RssRun)object).getOutput();
            if (this.output == null) continue;
            this._data = this.getReportData(n, (RssRun)object, string, ((RssRun)object).getReportKey());
            if (this._data == null) continue;
            for (int j = 0; j < this._locations.size(); ++j) {
                RssSummaryJPanel rssSummaryJPanel = this;
                int n2 = rssSummaryJPanel.getIndex(rssSummaryJPanel._data, (String)this._locations.elementAt(j));
                if (n2 < 0) continue;
                for (int k = 0; k < this._rowsPerGroup; ++k) {
                    int n3 = k + n2;
                    int n4 = k + j * this._rowsPerGroup;
                    this._tableData[n4][0] = this._data[n3][0];
                    for (int i2 = 1; i2 <= this._colsPerGroup; ++i2) {
                        this._tableData[n4][i * this._colsPerGroup + i2] = this._data[n3][i2];
                    }
                }
            }
        }
    }

    private int getIndex(Object[][] objectArray, String string) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (!string.equals(objectArray[i][0])) continue;
            return i;
        }
        return -1;
    }

    public void listLocations() {
        for (int i = 0; i < this._locations.size(); ++i) {
            System.out.println("i= " + i + " - " + String.valueOf(this._locations.elementAt(i)));
        }
    }

    void setColumnHeads(int n, String string) {
        if (n < 8) {
            this._numCols = this._numRuns * 3 + 1;
        } else {
            this._numCols = this._numRuns + 1;
            this._colsPerGroup = 1;
        }
        this._colNames = new String[this._numCols];
        this._colWidths = new int[this._numCols];
        this._colNames[0] = "Location/Parameter";
        if (this._numRuns > 1) {
            this._colNames[0] = " \n Location/Parameter";
        }
        this._colWidths[0] = 200;
        if (n < 8) {
            for (n = 0; n < this._numRuns; ++n) {
                this._colNames[n * 3 + 1] = "Average";
                this._colNames[n * 3 + 2] = "Maximum";
                this._colNames[n * 3 + 3] = "Minimum";
                this._colWidths[n * 3 + 1] = 80;
                this._colWidths[n * 3 + 2] = 80;
                this._colWidths[n * 3 + 3] = 80;
            }
            return;
        }
        for (n = 0; n < this._numRuns; ++n) {
            this._colNames[n + 1] = string;
            this._colWidths[n + 1] = 80;
        }
    }

    void setColumnGroups(List list, int n) {
        if (this._numRuns > 1) {
            Object object = super.getTable();
            object.setMlHeaderRenderer();
            TableColumnModel tableColumnModel = object.getColumnModel();
            GroupableTableHeader groupableTableHeader = (GroupableTableHeader)object.getTableHeader();
            for (int i = 0; i < this._numRuns; ++i) {
                object = list.get(i);
                if (object instanceof RunInfo) {
                    RunInfo runInfo = (RunInfo)object;
                    object = new ColumnGroup("Alternative: " + runInfo.simRunName + "-" + ((RssRun)runInfo.run).getReportKey());
                    RssRun cfr_ignored_0 = (RssRun)runInfo.run;
                } else {
                    object = (RssRun)object;
                    object = new ColumnGroup("Run: " + object.getName());
                }
                if (n < 8) {
                    object.add((Object)tableColumnModel.getColumn(i * 3 + 1));
                    object.add((Object)tableColumnModel.getColumn(i * 3 + 2));
                    object.add((Object)tableColumnModel.getColumn(i * 3 + 3));
                } else {
                    object.add((Object)tableColumnModel.getColumn(i + 1));
                }
                groupableTableHeader.addColumnGroup((ColumnGroup)object);
            }
        }
    }

    void setTableData(Object[][] objectArray) {
        int n;
        boolean[] blArray = new boolean[this._numCols];
        for (n = 0; n < blArray.length; ++n) {
            blArray[n] = false;
        }
        if (objectArray == null) {
            this.rTbl_table.setModel((TableModel)new RmaTableModel(this._colNames, new Object[0][0], blArray));
        } else {
            this.rTbl_table.setModel((TableModel)new RmaTableModel(this._colNames, objectArray, blArray));
        }
        this.rTbl_table.setUnitsHeaderRenderer();
        if (this._colWidths != null && this._colWidths.length != 0) {
            this.rTbl_table.setColumnWidths(this._colWidths);
        }
        this.rTbl_table.setHorizontalAlignment(4);
        this.rTbl_table.setCellSelectionEnabled(false);
        this.rTbl_table.setColumnSelectionAllowed(false);
        this.rTbl_table.setRowSelectionAllowed(true);
        this.rTbl_table.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)new ParameterStringCellRenderer());
        if (this._grayRows != null) {
            for (n = 0; n < this._grayRows.length; ++n) {
                if (!this._grayRows[n]) continue;
                this.rTbl_table.setRowBackground(n, Color.lightGray);
            }
        }
    }

    void prepareRunData(RssRun rssRun, int n, String string) {
        if (rssRun == null) {
            return;
        }
        this.output = rssRun.getOutput();
        if (this.output != null) {
            RssAlt rssAlt = rssRun.getAlternative();
            if (rssAlt == null) {
                return;
            }
            this._data = this.getReportData(n, rssRun, string, rssRun.getReportKey());
            if (this._data != null) {
                this._grayRows = new boolean[this._data.length];
                for (int i = 0; i < this._grayRows.length; ++i) {
                    if (this._data[i][this._data[i].length - 1] == null) continue;
                    this._grayRows[i] = true;
                    if (this._locations.contains(this._data[i][0])) continue;
                    this._locations.add(this._data[i][0]);
                }
                this._rowsPerGroup = 1;
                if (this._locations.size() > 0) {
                    this._rowsPerGroup = this._data.length / this._locations.size();
                }
            }
        }
    }

    Object[][] getReportData(int n, RssRun rssRun, String string, String string2) {
        if (rssRun == null) {
            return null;
        }
        Manager manager = rssRun.getAlternative();
        if (manager == null) {
            return null;
        }
        manager = manager.getSystem();
        RssOutput rssOutput = rssRun.getOutput();
        if (rssOutput == null || manager == null) {
            return null;
        }
        if (string2 == null) {
            string2 = rssRun.getOutputFPart();
        }
        switch (n) {
            case 0: {
                this._data = rssOutput.getReservoirSummaryStrArray((RssSystem)manager, string2);
                break;
            }
            case 1: {
                this._data = rssOutput.getFlowSummaryStrArray((RssSystem)manager, string2);
                break;
            }
            case 2: {
                this._data = rssOutput.getStageSummaryStrArray((RssSystem)manager, string2);
                break;
            }
            case 4: {
                this._data = rssOutput.getPowerSummaryStrArray((RssSystem)manager, string2);
                break;
            }
            case 7: {
                this._data = rssOutput.getGatesSummaryStrArray((RssSystem)manager, string2);
                break;
            }
            case 3: {
                this._data = null;
                break;
            }
            case 8: {
                this._data = null;
                this._data = rssOutput.getReservoirSummaryStrArray((RssSystem)manager, string, rssRun, string2);
                break;
            }
            case 9: {
                this._data = rssOutput.getFlowSummaryStrArray((RssSystem)manager, string, rssRun, string2);
                break;
            }
            case 10: {
                this._data = rssOutput.getStageSummaryStrArray((RssSystem)manager, string, rssRun, string2);
                break;
            }
            case 11: {
                this._data = rssOutput.getPowerSummaryStrArray((RssSystem)manager, string, rssRun, string2);
                break;
            }
            case 12: {
                this._data = rssOutput.getGatesSummaryStrArray((RssSystem)manager, string, rssRun, string2);
            }
        }
        return this._data;
    }
}

