/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.HecClientFrame;
import hec.gui.NameDialog;
import hec.rss.client.HecRssDrawProperties;
import hec.rss.client.RssGlyph;
import hec.rss.client.RssSystemDPData;
import hec.rss.client.RssSystemDPDiversionData;
import hec.rss.client.RssSystemDPJunctionData;
import hec.rss.client.RssSystemDPReachData;
import hec.rss.client.RssSystemDPReservoirData;
import hec.rss.client.RssSystemDrawPropDlg$1;
import hec.rss.client.RssSystemDrawPropDlg$SymWindow;
import hec.rss.client.RssSystemDrawPropDlg$TabPanel;
import hec.rss.client.RssSystemGlyph;
import hec.rss.client.SimulationRunGlyph;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTabbedPane;
import rma.swing.RmaJTextField;
import rma.swing.event.ReflectMultiListener;
import rma.swing.text.IntegerDocument;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class RssSystemDrawPropDlg
extends RmaJDialog
implements Observer,
ChangeListener {
    boolean _isOK = false;
    RssGlyph _glyph = null;
    private RmaJTextField _currentScaleTxt;
    private RmaJTabbedPane _scaleTabbedPanel;
    private JMenuItem _deleteMenuItem;
    private ButtonCmdPanel _buttonPanel;
    private ReflectMultiListener _listener;
    private boolean _needToRebuildPanels = false;

    public RssSystemDrawPropDlg(Frame frame, String string, boolean bl) {
        this(frame, bl);
        this.setTitle(string);
        this.buildControls();
    }

    public RssSystemDrawPropDlg(Frame frame, boolean bl) {
        super(frame, bl);
        this.setTitle("ResSim System Draw Properties");
        this.buildControls();
    }

    protected void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setSize(430, 400);
        this._currentScaleTxt = new RmaJTextField("Current Scale 1:");
        this._currentScaleTxt.setEditable(false);
        this._currentScaleTxt.setBorder(null);
        Object object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).gridheight = 1;
        ((GridBagConstraints)object).gridwidth = 1;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this._currentScaleTxt, object);
        this._scaleTabbedPanel = new RmaJTabbedPane();
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridy = 1;
        ((GridBagConstraints)object).gridheight = 1;
        ((GridBagConstraints)object).gridwidth = 1;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 1;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 1.0;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this._scaleTabbedPanel, object);
        this._buttonPanel = new ButtonCmdPanel(14);
        this._buttonPanel.setApplyAlwaysOn(true);
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridy = 2;
        ((GridBagConstraints)object).gridheight = 1;
        ((GridBagConstraints)object).gridwidth = 1;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 0.0;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this._buttonPanel, object);
        this.buildMenus();
        object = new RssSystemDrawPropDlg$SymWindow(this);
        this.addWindowListener((WindowListener)object);
        this.registerEnterKey(true);
        this.registerEscapeKey(true);
        this._scaleTabbedPanel.addChangeListener((ChangeListener)this);
        this._buttonPanel.addCmdPanelListener((ButtonCmdPanelListener)new RssSystemDrawPropDlg$1(this));
        this.updateCurrentScale();
        this.buildPanels();
        this.pack();
    }

    protected void buildMenus() {
        this._listener = new ReflectMultiListener();
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Scale");
        jMenu.setMnemonic('S');
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("New", 78);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "addTabAction"));
        jMenu.add(jMenuItem);
        this._deleteMenuItem = new JMenuItem("Delete", 68);
        this._deleteMenuItem.setEnabled(false);
        RssSystemDrawPropDlg rssSystemDrawPropDlg = this;
        this._deleteMenuItem.addActionListener((ActionListener)this._listener.add((Object)rssSystemDrawPropDlg, (Object)rssSystemDrawPropDlg._deleteMenuItem, "deleteTabAction"));
        jMenu.add(this._deleteMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Set to Defaults", 83);
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "setToDefaultsAction"));
        jMenu.add(jMenuItem);
        this.setJMenuBar(jMenuBar);
    }

    protected void buildPanels() {
        int[] nArray = RssSystemDPReservoirData.d();
        this._scaleTabbedPanel.removeAll();
        for (int i = 0; i < nArray.length; ++i) {
            String string;
            int n = nArray[i];
            if (n == 0) {
                string = "Default";
                this._scaleTabbedPanel.insertTab(string, null, (Component)new RssSystemDrawPropDlg$TabPanel(this, n), null, 0);
                continue;
            }
            string = String.valueOf(n);
            this._scaleTabbedPanel.addTab(string, (Component)new RssSystemDrawPropDlg$TabPanel(this, n));
        }
    }

    public void setToDefaultsAction() {
        RssSystemDrawPropDlg$TabPanel rssSystemDrawPropDlg$TabPanel = (RssSystemDrawPropDlg$TabPanel)this._scaleTabbedPanel.getSelectedComponent();
        rssSystemDrawPropDlg$TabPanel.setToDefaults();
    }

    public void addTabAction() {
        NameDialog nameDialog = new NameDialog((Dialog)((Object)this), "Create new Scale", true);
        nameDialog.setNameLabel("Scale:");
        Object object = new IntegerDocument();
        object.setMin(1);
        nameDialog.setNameFieldDocument((Document)object);
        nameDialog.setDescriptionVisible(false);
        nameDialog.setVisible(true);
        if (nameDialog.isCanceled()) {
            return;
        }
        int n = RMAIO.parseInt((String)nameDialog.getName());
        if (RMAConst.isUndefinedValue((int)n)) {
            return;
        }
        RssSystemDPData.a(n);
        object = (RssSystemDrawPropDlg$TabPanel)this._scaleTabbedPanel.getSelectedComponent();
        RssSystemDrawPropDlg$TabPanel rssSystemDrawPropDlg$TabPanel = new RssSystemDrawPropDlg$TabPanel(this, n);
        rssSystemDrawPropDlg$TabPanel.fillFormFrom((RssSystemDrawPropDlg$TabPanel)object);
        for (int i = 1; i < this._scaleTabbedPanel.getTabCount(); ++i) {
            object = (RssSystemDrawPropDlg$TabPanel)this._scaleTabbedPanel.getComponentAt(i);
            if (n <= ((RssSystemDrawPropDlg$TabPanel)object).getMapScale()) continue;
            this._scaleTabbedPanel.insertTab(String.valueOf(n), null, (Component)rssSystemDrawPropDlg$TabPanel, null, i);
            return;
        }
        this._scaleTabbedPanel.addTab(String.valueOf(n), (Component)rssSystemDrawPropDlg$TabPanel);
    }

    public void deleteTabAction() {
        RssSystemDrawPropDlg$TabPanel rssSystemDrawPropDlg$TabPanel = (RssSystemDrawPropDlg$TabPanel)this._scaleTabbedPanel.getSelectedComponent();
        int n = rssSystemDrawPropDlg$TabPanel.getMapScale();
        int n2 = JOptionPane.showConfirmDialog((Component)((Object)this), "<html>OK to delete ResSim Properties for scale <b>1:" + n + "</b></html>", "Confirm Deletion", 0);
        if (n2 != 0) {
            return;
        }
        RssSystemDPData.b(n);
        ClientApp.frame().getMapPanel().paintMap();
        this.buildPanels();
    }

    public void setVisible(boolean bl) {
        HecClientFrame hecClientFrame = ClientApp.frame();
        if (bl && this._glyph == null) {
            Object object = hecClientFrame.getMapPanel();
            this._glyph = (RssGlyph)object.findGlyphOfClass(RssSystemGlyph.class.getName());
            if (this._glyph == null) {
                this._glyph = (RssGlyph)hecClientFrame.getMapPanel().findGlyphOfClass("wcds.cavi.client.ForecastAltGlyph");
            }
            if (this._glyph == null && (object = (SimulationRunGlyph)hecClientFrame.getMapPanel().findGlyphOfClass(SimulationRunGlyph.class.getName())) != null) {
                this._glyph = (RssGlyph)((SimulationRunGlyph)((Object)object)).findGlyphOfClass(RssSystemGlyph.class.getName());
            }
            RssSystemDrawPropDlg rssSystemDrawPropDlg = this;
            rssSystemDrawPropDlg.setGlyph(rssSystemDrawPropDlg._glyph);
        }
        if (bl) {
            this.setLocation();
            this._isOK = false;
            ClientApp.frame().getMapPanel().addObserver((Observer)this);
        } else {
            if (this._isOK) {
                hecClientFrame.getMapPanel().paintMap();
            }
            ClientApp.frame().getMapPanel().deleteObserver((Observer)this);
        }
        super.setVisible(bl);
    }

    void Dialog1_WindowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
    }

    void okButtonAction(ActionEvent actionEvent) {
        this._isOK = true;
        this.setVisible(false);
        this.applyButtonAction(actionEvent);
    }

    void applyButtonAction(ActionEvent actionEvent) {
        int n = this._scaleTabbedPanel.getTabCount();
        this._needToRebuildPanels = false;
        for (int i = 0; i < n; ++i) {
            RssSystemDrawPropDlg$TabPanel rssSystemDrawPropDlg$TabPanel = (RssSystemDrawPropDlg$TabPanel)this._scaleTabbedPanel.getComponentAt(i);
            rssSystemDrawPropDlg$TabPanel.saveForm();
        }
        HecRssDrawProperties hecRssDrawProperties = new HecRssDrawProperties();
        hecRssDrawProperties.clearProperties();
        hecRssDrawProperties.addProperties(RssSystemDPReservoirData.b().getProperties());
        hecRssDrawProperties.addProperties(RssSystemDPDiversionData.b().getProperties());
        hecRssDrawProperties.addProperties(RssSystemDPReachData.b().getProperties());
        hecRssDrawProperties.addProperties(RssSystemDPJunctionData.b().getProperties());
        hecRssDrawProperties.saveProperties(0);
        ClientApp.frame().getMapPanel().paintMap();
        if (this._needToRebuildPanels) {
            this.buildPanels();
        }
    }

    void cancelButtonAction(ActionEvent actionEvent) {
        this.setVisible(false);
        this._isOK = false;
    }

    public boolean isOK() {
        return this._isOK;
    }

    public void setGlyph(RssGlyph rssGlyph) {
        this._glyph = rssGlyph;
    }

    @Override
    public void update(Observable observable, Object object) {
        if ("zoomIn".equals(object) || "zoomByFactor".equals(object) || "showAll".equals(object)) {
            this.updateCurrentScale();
        }
    }

    private void updateCurrentScale() {
        double d = ClientApp.frame().getMapPanel().viewport().computeMapScale();
        this._currentScaleTxt.setText("Current Scale 1:" + (int)d);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        int n = this._scaleTabbedPanel.getSelectedIndex();
        this._deleteMenuItem.setEnabled(n != 0);
    }
}

