/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.appInterface.AppDaddy;
import hec.clientapp.client.ClientApp;
import hec.clientapp.model.StreamAlignment;
import hec.gui.NameDialog;
import hec.lang.NamedType;
import hec.map.LayerSymbol;
import hec.map.LocalPt;
import hec.map.MapGlyph;
import hec.map.MapLabelItem;
import hec.map.MapObjectInterface;
import hec.map.MapPanel;
import hec.map.MapScale;
import hec.map.ModeDrawingAttributeSet;
import hec.map.ModelDrawingAttributeSet;
import hec.map.WorldLine;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.WorldRegion;
import hec.map.appInterface.MapApplicationModule;
import hec.map.selection.GraphicElementSelection;
import hec.map.selection.GraphicElementSelectionEvent;
import hec.map.selection.GraphicElementSelectionEventListener;
import hec.map.selection.GraphicElementSelectionEventNotifier;
import hec.map.selection.GraphicElementSelectionEventSupport;
import hec.map.selection.GraphicElementSelector;
import hec.map.streamAlignment.StreamAlignmentGlyph;
import hec.model.StreamElement;
import hec.model.StreamJunction;
import hec.model.StreamNode;
import hec.model.StreamPolyLine;
import hec.model.StreamSegment;
import hec.model.TSLocation;
import hec.rss.client.RSimNetworkMode;
import hec.rss.client.ResSimElementMapSelector;
import hec.rss.client.RssDrawingAttributeSet;
import hec.rss.client.RssGlyph;
import hec.rss.client.RssSystemDPDiversionData;
import hec.rss.client.RssSystemDPJunctionData;
import hec.rss.client.RssSystemDPReachData;
import hec.rss.client.RssSystemDPReservoirData;
import hec.rss.client.RssSystemGlyph$1;
import hec.rss.client.RssSystemGlyph$JunctionDrawDataProvider;
import hec.rss.client.RssSystemGlyph$NewJunctionContainer;
import hec.rss.client.RssSystemGlyph$ReachDrawDataProvider;
import hec.rss.client.RssSystemGlyph$ResDiversionSymbol;
import hec.rss.client.RssSystemGlyph$ResJunctionSymbol;
import hec.rss.client.RssSystemGlyph$ResReachSymbol;
import hec.rss.client.RssSystemGlyph$ResReservoirSymbol;
import hec.rss.client.RssSystemGlyph$ReservoirDrawDataProvider;
import hec.rss.client.RssSystemGlyph$SimpleDrawDataProvider;
import hec.rss.model.DiversionElement;
import hec.rss.model.DivertedOutletElement;
import hec.rss.model.DownstreamCntrlOpRule;
import hec.rss.model.Element;
import hec.rss.model.JunctionElement;
import hec.rss.model.OpRule;
import hec.rss.model.OpSet;
import hec.rss.model.ReachElement;
import hec.rss.model.ReservoirDamElement;
import hec.rss.model.ReservoirElement;
import hec.rss.model.Routing;
import hec.rss.model.RssAlt;
import hec.rss.model.RssNode;
import hec.rss.model.RssSystem;
import hec.rss.model.StreamNameMapper;
import hec.rss.model.TimeStepRoutingElement;
import hec.rss.model.TimeStepUtil;
import hec.rss.server.RoutingPanel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.text.Document;
import rma.lang.RmaMath;
import rma.swing.FindDialog;
import rma.swing.FindListener;
import rma.swing.RmaColor;
import rma.swing.RmaImage;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;
import rma.swing.text.DssPathnamePartDocument;
import rma.util.RMAConst;

public class RssSystemGlyph
extends MapGlyph
implements GraphicElementSelectionEventListener,
GraphicElementSelectionEventNotifier,
RssGlyph,
ActionListener,
FindListener {
    RssSystem _sysmap = null;
    RssSystemGlyph$ReachDrawDataProvider _reachDrawDataProvider;
    RssSystemGlyph$ReservoirDrawDataProvider _reservoirDrawDataProvider;
    RssSystemGlyph$JunctionDrawDataProvider _junctionDrawDataProvider;
    RssSystemDPDiversionData _diversionData;
    List<MapGlyph.Selection> _selectionList = new ArrayList<MapGlyph.Selection>();
    static Image _impactImage;
    static Image _reachImage;
    static Image _tsImage;
    RssDrawingAttributeSet _rssDas = null;
    private AbstractAction _findAction;
    private JPanel _findTypePanel;
    private RmaJComboBox _findTypeCombo;
    private Element _lastElement;
    private boolean _highlightElements;
    private GraphicElementSelectionEventSupport _geSupport = new GraphicElementSelectionEventSupport();
    static int[] _xpt;
    static int[] _ypt;

    public RssSystemGlyph(MapPanel mapPanel, RssSystem rssSystem) {
        super(mapPanel, (MapObjectInterface)rssSystem);
        this._reservoirDrawDataProvider = new RssSystemGlyph$SimpleDrawDataProvider(this);
        this._reachDrawDataProvider = new RssSystemGlyph$SimpleDrawDataProvider(this);
        this._junctionDrawDataProvider = new RssSystemGlyph$SimpleDrawDataProvider(this);
        this._sysmap = rssSystem;
        this._highlightElements = Boolean.getBoolean("NetworkGlyph.HighlightElements");
        if (_impactImage == null) {
            _impactImage = RmaImage.loadURLImage((Component)mapPanel, (String)"Images/fia3.gif");
        }
        if (_reachImage == null) {
            _reachImage = RmaImage.loadURLImage((Component)mapPanel, (String)"Images/fia3.gif");
        }
        if (_tsImage == null) {
            _tsImage = RmaImage.loadURLImage((Component)mapPanel, (String)"Images/modelup.gif");
        }
        if ((mapPanel = ModeDrawingAttributeSet.getModeAttributeSet((String)AppDaddy.getFrame().getCurrentModule().toString())) == null) {
            return;
        }
        this._rssDas = (RssDrawingAttributeSet)mapPanel.getModelAttributeSet("ResSim");
        if (this._rssDas != null) {
            this._rssDas = (RssDrawingAttributeSet)((Object)this._rssDas.clone());
        }
        this._geSupport.addListener((GraphicElementSelectionEventListener)GraphicElementSelector.getInstance());
    }

    public void setDrawingAttributeSet(RssDrawingAttributeSet rssDrawingAttributeSet) {
        this._rssDas = rssDrawingAttributeSet;
    }

    public void abort() {
        if (this._sysmap != null) {
            this._sysmap.setLocked(1);
        }
        this._mapPanel.getInputMap(1).remove(KeyStroke.getKeyStroke(70, 128));
        this._mapPanel.getActionMap().remove("findElement");
    }

    public void init() {
        super.init();
        Object object = (RssSystem)this.getMap();
        Object object2 = this.getStreamAlignmentGlyph();
        if (object2 != null && object != null) {
            RssSystem rssSystem = object;
            StreamNameMapper.a(rssSystem, rssSystem.getAlignment());
            if (!Boolean.getBoolean("ResSim.NoFixUpNodeLocations")) {
                this.fixJunctionLocationsAtConfluences((RssSystem)object);
                object = ((RssSystem)object).getElementVectorByClass(JunctionElement.class);
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    object2 = (JunctionElement)((Vector)object).get(i);
                    StreamElement streamElement = ((JunctionElement)object2).getStream();
                    if (streamElement == null) continue;
                    Object object3 = ((Element)object2).getReferencePt();
                    double d = streamElement.getStationByLocation((WorldPt)object3);
                    double d2 = streamElement.getCoordByStation(d);
                    object3 = ((Element)object2).getNodeVector();
                    for (int j = 0; j < ((Vector)object3).size(); ++j) {
                        object2 = (RssNode)((Vector)object3).get(j);
                        if (((RssNode)object2).getStreamCoord() == d2 || object2.getStreamIndex() != streamElement.getIndex()) continue;
                        object2.setStreamCoord(d2);
                        ((RssNode)object2).setStreamStation(d);
                    }
                }
            }
        }
        this._findAction = new RssSystemGlyph$1(this);
        this._mapPanel.getInputMap(1).put(KeyStroke.getKeyStroke(70, 128), "findElement");
        this._mapPanel.getActionMap().put("findElement", this._findAction);
    }

    protected void findAction() {
        GridBagConstraints gridBagConstraints;
        Object object;
        if (this._findTypePanel == null) {
            this._findTypePanel = new JPanel(new GridBagLayout());
            object = new JLabel("Element Type");
            gridBagConstraints = new GridBagConstraints();
            new GridBagConstraints().gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = RmaInsets.INSETS5005;
            this._findTypePanel.add((Component)object, gridBagConstraints);
            object = new Vector<String>();
            ((Vector)object).add("Reservoir");
            ((Vector)object).add("Reach");
            ((Vector)object).add("Junction");
            ((Vector)object).add("Diversion");
            this._findTypeCombo = new RmaJComboBox((Vector)object);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = RmaInsets.INSETS5505;
            this._findTypePanel.add((Component)this._findTypeCombo, gridBagConstraints);
        }
        object = new FindDialog((Frame)ClientApp.frame(), false, (FindListener)this);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        object.getContentPane().add((Component)this._findTypePanel, gridBagConstraints);
        object.setShowOptions(false);
        object.setTitle("Find Element");
        object.pack();
        object.setLocationRelativeTo((Component)this.getMapPanel());
        object.setVisible(true);
    }

    public void close() {
        this.abort();
    }

    public NamedType findObject(LocalPt localPt) {
        if (this._sysmap == null || localPt == null) {
            return null;
        }
        localPt = this._mapPanel.scale().lp2wp(localPt);
        return this.findObject((WorldPt)localPt);
    }

    public NamedType findObject(WorldPt worldPt) {
        if (this._sysmap == null || worldPt == null) {
            return null;
        }
        double d = this._mapPanel.scale().x2e(5) - this._mapPanel.scale().x2e(0);
        Element element = null;
        if (this._rssDas.isAttributeShown("Junctions")) {
            element = this._sysmap.findJunction(worldPt, d);
        }
        if (element == null && this._rssDas.isAttributeShown("Reaches")) {
            element = this.findReach(worldPt, d);
        }
        if (element == null && this._rssDas.isAttributeShown("Reservoirs")) {
            element = this.findReservoir(worldPt);
        }
        if (element == null && this._rssDas.isAttributeShown("Reservoirs")) {
            element = this.findDivertedOutlet(worldPt, d);
        }
        if (element == null && this._rssDas.isAttributeShown("Diversions")) {
            element = this.findDiversion(worldPt, d);
        }
        return element;
    }

    public boolean objectPopupMenu(LocalPt localPt, int n) {
        NamedType[] namedTypeArray = this.findObject(localPt);
        if (namedTypeArray != null) {
            MapGlyph.Selection selection = new MapGlyph.Selection((MapGlyph)this, (Object)namedTypeArray, false);
            if (!this._selectionList.contains(selection)) {
                this.clearSelection();
                this._selectionList.add(selection);
            }
            RssSystemGlyph rssSystemGlyph = this;
            rssSystemGlyph.drawSelectedElement(rssSystemGlyph._mapPanel.viewport().getGraphics(), this._mapPanel.scale(), (Element)namedTypeArray);
            RssSystemGlyph rssSystemGlyph2 = this;
            rssSystemGlyph2.drawSelectedElement(rssSystemGlyph2._mapPanel.viewport().getBufferedGraphics(), this._mapPanel.scale(), (Element)namedTypeArray);
            selection = AppDaddy.getFrame();
            selection = (MapApplicationModule)selection.getCurrentModule();
            if (this._selectionList.size() == 1) {
                return selection.objectPopupMenu((NamedType)namedTypeArray, localPt);
            }
            namedTypeArray = this.getSelections();
            return selection.objectPopupMenu(namedTypeArray, localPt);
        }
        return false;
    }

    public NamedType objectSelect(LocalPt localPt, int n) {
        if ((localPt = this.findObject(localPt)) != null) {
            MapGlyph.Selection selection = new MapGlyph.Selection((MapGlyph)this, (Object)localPt, false);
            boolean bl = this._selectionList.contains(selection);
            if (!bl) {
                this._selectionList.add(selection);
                RssSystemGlyph rssSystemGlyph = this;
                rssSystemGlyph.drawSelectedElement(rssSystemGlyph._mapPanel.viewport().getGraphics(), this._mapPanel.scale(), (Element)localPt);
                RssSystemGlyph rssSystemGlyph2 = this;
                rssSystemGlyph2.drawSelectedElement(rssSystemGlyph2._mapPanel.viewport().getBufferedGraphics(), this._mapPanel.scale(), (Element)localPt);
                this._geSupport.addToSelection((Object)this._geSupport, this.buildEvent((NamedType)localPt));
            } else if (bl && RssSystemGlyph.isShiftDown((int)n) && (n & 4) == 0) {
                this._selectionList.remove(selection);
                this._mapPanel.paintMap();
            }
        } else {
            this.clearSelection();
            this._geSupport.clearSelection((Object)this._geSupport, null);
        }
        return localPt;
    }

    public void setReservoirDataProvider(RssSystemGlyph$ReservoirDrawDataProvider rssSystemGlyph$ReservoirDrawDataProvider) {
        Objects.nonNull(rssSystemGlyph$ReservoirDrawDataProvider);
        this._reservoirDrawDataProvider = rssSystemGlyph$ReservoirDrawDataProvider;
    }

    public void setReachDataProvider(RssSystemGlyph$ReachDrawDataProvider rssSystemGlyph$ReachDrawDataProvider) {
        Objects.nonNull(rssSystemGlyph$ReachDrawDataProvider);
        this._reachDrawDataProvider = rssSystemGlyph$ReachDrawDataProvider;
    }

    public void setJunctionDataProvider(RssSystemGlyph$JunctionDrawDataProvider rssSystemGlyph$JunctionDrawDataProvider) {
        this._junctionDrawDataProvider = rssSystemGlyph$JunctionDrawDataProvider;
    }

    protected GraphicElementSelectionEvent buildEvent(NamedType namedType) {
        namedType = this.buildSelection(namedType);
        GraphicElementSelectionEvent graphicElementSelectionEvent = new GraphicElementSelectionEvent();
        graphicElementSelectionEvent.setSelection((GraphicElementSelection)namedType);
        return graphicElementSelectionEvent;
    }

    protected GraphicElementSelection buildSelection(NamedType object) {
        GraphicElementSelection graphicElementSelection = new GraphicElementSelection();
        graphicElementSelection.setName(object.getName());
        graphicElementSelection.setSrc("ResSim");
        if (object instanceof Element) {
            object = (Element)object;
            graphicElementSelection.setType(object.getElementType());
            object = object.getSystem();
            object = object.getAlternative();
            if (object != null) {
                graphicElementSelection.setAltName(object.getName());
            }
        }
        return graphicElementSelection;
    }

    public boolean objectDoubleClick(LocalPt localPt, int n) {
        NamedType namedType = this.findObject(localPt);
        if (namedType != null) {
            this._selectionList.clear();
            MapGlyph.Selection selection = new MapGlyph.Selection((MapGlyph)this, (Object)namedType, false);
            this._selectionList.add(selection);
            RssSystemGlyph rssSystemGlyph = this;
            rssSystemGlyph.drawSelectedElement(rssSystemGlyph._mapPanel.viewport().getGraphics(), this._mapPanel.scale(), (Element)namedType);
            RssSystemGlyph rssSystemGlyph2 = this;
            rssSystemGlyph2.drawSelectedElement(rssSystemGlyph2._mapPanel.viewport().getBufferedGraphics(), this._mapPanel.scale(), (Element)namedType);
            selection = AppDaddy.getFrame();
            selection = (MapApplicationModule)selection.getCurrentModule();
            selection.objectDoubleClick(namedType, localPt);
            return true;
        }
        return false;
    }

    public boolean junctionPopupMenu(LocalPt localPt) {
        if (this._sysmap == null || localPt == null) {
            return false;
        }
        double d = this._mapPanel.scale().x2e(localPt.x + 5) - this._mapPanel.scale().x2e(localPt.x);
        WorldPt worldPt = this._mapPanel.scale().lp2wp(localPt);
        JunctionElement junctionElement = this._sysmap.findJunction(worldPt, d);
        if (junctionElement != null) {
            this._selectionList.clear();
            MapGlyph.Selection selection = new MapGlyph.Selection((MapGlyph)this, (Object)junctionElement, false);
            this._selectionList.add(selection);
            RssSystemGlyph rssSystemGlyph = this;
            rssSystemGlyph.drawSelectedJunction(rssSystemGlyph._mapPanel.viewport().getGraphics(), this._mapPanel.scale(), junctionElement, false, false);
            RssSystemGlyph rssSystemGlyph2 = this;
            rssSystemGlyph2.drawSelectedJunction(rssSystemGlyph2._mapPanel.viewport().getBufferedGraphics(), this._mapPanel.scale(), junctionElement, false, false);
            selection = AppDaddy.getFrame();
            selection = (MapApplicationModule)selection.getCurrentModule();
            selection.objectPopupMenu((NamedType)junctionElement, localPt);
            return true;
        }
        return false;
    }

    public boolean reachPopupMenu(LocalPt localPt) {
        if (this._sysmap == null || localPt == null) {
            return false;
        }
        double d = this._mapPanel.scale().x2e(localPt.x + 5) - this._mapPanel.scale().x2e(localPt.x);
        WorldPt worldPt = this._mapPanel.scale().lp2wp(localPt);
        ReachElement reachElement = this.findReach(worldPt, d);
        if (reachElement != null) {
            this._selectionList.clear();
            MapGlyph.Selection selection = new MapGlyph.Selection((MapGlyph)this, (Object)reachElement, false);
            this._selectionList.add(selection);
            RssSystemGlyph rssSystemGlyph = this;
            rssSystemGlyph.drawSelectedReach(rssSystemGlyph._mapPanel.viewport().getGraphics(), this._mapPanel.scale(), reachElement, false, false);
            RssSystemGlyph rssSystemGlyph2 = this;
            rssSystemGlyph2.drawSelectedReach(rssSystemGlyph2._mapPanel.viewport().getBufferedGraphics(), this._mapPanel.scale(), reachElement, false, false);
            selection = AppDaddy.getFrame();
            selection = (MapApplicationModule)selection.getCurrentModule();
            selection.objectPopupMenu((NamedType)reachElement, localPt);
            return true;
        }
        return false;
    }

    public boolean reservoirPopupMenu(LocalPt localPt) {
        if (this._sysmap == null || localPt == null) {
            return false;
        }
        Object object = this._mapPanel.scale().lp2wp(localPt);
        if ((object = this.findReservoir((WorldPt)object)) != null) {
            this._selectionList.clear();
            MapGlyph.Selection selection = new MapGlyph.Selection((MapGlyph)this, object, false);
            this._selectionList.add(selection);
            RssSystemGlyph rssSystemGlyph = this;
            rssSystemGlyph.drawSelectedReservoir(rssSystemGlyph._mapPanel.viewport().getGraphics(), this._mapPanel.scale(), (ReservoirElement)object, false, false);
            RssSystemGlyph rssSystemGlyph2 = this;
            rssSystemGlyph2.drawSelectedReservoir(rssSystemGlyph2._mapPanel.viewport().getBufferedGraphics(), this._mapPanel.scale(), (ReservoirElement)object, false, false);
            selection = AppDaddy.getFrame();
            selection = (MapApplicationModule)selection.getCurrentModule();
            selection.objectPopupMenu((NamedType)object, localPt);
            return true;
        }
        return false;
    }

    public boolean divertedOutletPopupMenu(LocalPt localPt) {
        if (this._sysmap == null || localPt == null) {
            return false;
        }
        double d = this._mapPanel.scale().x2e(localPt.x + 5) - this._mapPanel.scale().x2e(localPt.x);
        WorldPt worldPt = this._mapPanel.scale().lp2wp(localPt);
        DivertedOutletElement divertedOutletElement = this.findDivertedOutlet(worldPt, d);
        if (divertedOutletElement != null) {
            this._selectionList.clear();
            MapGlyph.Selection selection = new MapGlyph.Selection((MapGlyph)this, (Object)divertedOutletElement, false);
            this._selectionList.add(selection);
            RssSystemGlyph rssSystemGlyph = this;
            rssSystemGlyph.drawSelectedDivertedOutlet(rssSystemGlyph._mapPanel.viewport().getGraphics(), this._mapPanel.scale(), divertedOutletElement, false, false);
            RssSystemGlyph rssSystemGlyph2 = this;
            rssSystemGlyph2.drawSelectedDivertedOutlet(rssSystemGlyph2._mapPanel.viewport().getBufferedGraphics(), this._mapPanel.scale(), divertedOutletElement, false, false);
            selection = AppDaddy.getFrame();
            selection = (MapApplicationModule)selection.getCurrentModule();
            selection.objectPopupMenu((NamedType)divertedOutletElement, localPt);
            return true;
        }
        return false;
    }

    public boolean diversionPopupMenu(LocalPt localPt) {
        if (this._sysmap == null || localPt == null) {
            return false;
        }
        double d = this._mapPanel.scale().x2e(localPt.x + 5) - this._mapPanel.scale().x2e(localPt.x);
        WorldPt worldPt = this._mapPanel.scale().lp2wp(localPt);
        DiversionElement diversionElement = this.findDiversion(worldPt, d);
        if (diversionElement != null) {
            this._selectionList.clear();
            MapGlyph.Selection selection = new MapGlyph.Selection((MapGlyph)this, (Object)diversionElement, false);
            this._selectionList.add(selection);
            RssSystemGlyph rssSystemGlyph = this;
            rssSystemGlyph.drawSelectedDiversion(rssSystemGlyph._mapPanel.viewport().getGraphics(), this._mapPanel.scale(), diversionElement, false, false);
            RssSystemGlyph rssSystemGlyph2 = this;
            rssSystemGlyph2.drawSelectedDiversion(rssSystemGlyph2._mapPanel.viewport().getBufferedGraphics(), this._mapPanel.scale(), diversionElement, false, false);
            selection = AppDaddy.getFrame();
            selection = (MapApplicationModule)selection.getCurrentModule();
            selection.objectPopupMenu((NamedType)diversionElement, localPt);
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        actionEvent.getSource();
    }

    public boolean isShown() {
        if (this._rssDas == null) {
            return false;
        }
        return this._rssDas.isShown();
    }

    public void setShown(boolean bl) {
        if (this._rssDas == null) {
            return;
        }
        this._rssDas.setShown(bl);
    }

    public void clearSelection() {
        boolean bl;
        int n = this._selectionList.size();
        boolean bl2 = bl = n > 0;
        if (n > 0) {
            Graphics graphics = this._mapPanel.viewport().getGraphics();
            for (int i = 0; i < n; ++i) {
                MapGlyph.Selection selection = this._selectionList.get(i);
                this.drawElement(graphics, this._mapPanel.scale(), (Element)selection.object);
            }
        }
        this._selectionList.clear();
        this._geSupport.clearSelection((Object)this._geSupport, null);
        if (bl) {
            this._mapPanel.paintMap();
        }
    }

    public void clearSelection(Object object) {
        boolean bl = false;
        for (int i = 0; i < this._selectionList.size(); ++i) {
            MapGlyph.Selection selection = this._selectionList.get(i);
            if (selection == null || selection.object != object) continue;
            this._selectionList.remove(selection);
            bl = true;
            break;
        }
        if (bl) {
            this._mapPanel.paintMap();
        }
    }

    public void clearSelection(String string) {
        boolean bl = false;
        for (int i = 0; i < this._selectionList.size(); ++i) {
            NamedType namedType;
            MapGlyph.Selection selection = this._selectionList.get(i);
            if (selection == null || !string.equals((namedType = (NamedType)selection.object).getName())) continue;
            this._selectionList.remove(selection);
            bl = true;
            break;
        }
        if (bl) {
            this._mapPanel.paintMap();
        }
    }

    public JunctionElement findJunction(WorldPt worldPt) {
        double d = this._mapPanel.scale().x2e(5) - this._mapPanel.scale().x2e(0);
        return this._sysmap.findJunction(worldPt, d);
    }

    public JunctionElement findJunction(WorldPt worldPt, double d) {
        return this._sysmap.findJunction(worldPt, d);
    }

    public ReservoirElement findReservoir(LocalPt localPt) {
        localPt = this._mapPanel.scale().lp2wp(localPt);
        return this.findReservoir((WorldPt)localPt);
    }

    public ReservoirElement findReservoir(WorldPt worldPt) {
        double d;
        StreamAlignmentGlyph streamAlignmentGlyph = this.getStreamAlignmentGlyph();
        if (streamAlignmentGlyph != null && (streamAlignmentGlyph = streamAlignmentGlyph.findReach(worldPt)) != null && (d = streamAlignmentGlyph.getLine().getCoordAtLocation(worldPt)) != Double.NEGATIVE_INFINITY) {
            return this._sysmap.findReservoir(streamAlignmentGlyph.getIndex(), d);
        }
        return this._sysmap.findReservoir(worldPt);
    }

    public ReservoirElement findReservoir(String string) {
        if (string == null) {
            return null;
        }
        return this._sysmap.findReservoir(string);
    }

    public void setSelection(Object object, boolean bl) {
        object = new MapGlyph.Selection((MapGlyph)this, object, bl);
        this._selectionList.clear();
        this._selectionList.add((MapGlyph.Selection)object);
        this._mapPanel.paintMap();
    }

    public void addSelection(Object object, boolean bl) {
        if (!this._selectionList.contains(object = new MapGlyph.Selection((MapGlyph)this, object, bl))) {
            this._selectionList.add((MapGlyph.Selection)object);
        }
        this._mapPanel.paintMap();
    }

    public void addSelections(List<Element> list, boolean n) {
        if (n != 0) {
            this._selectionList.clear();
        }
        if (list == null) {
            this._mapPanel.paintMap();
            return;
        }
        for (n = 0; n < list.size(); ++n) {
            MapGlyph.Selection selection = new MapGlyph.Selection((MapGlyph)this, (Object)list.get(n), false);
            this._selectionList.add(selection);
        }
        this._mapPanel.paintMap();
    }

    public NamedType[] getSelections() {
        int n = this._selectionList.size();
        if (n == 0) {
            return new NamedType[0];
        }
        NamedType[] namedTypeArray = new NamedType[this._selectionList.size()];
        for (int i = 0; i < n; ++i) {
            MapGlyph.Selection selection = this._selectionList.get(i);
            namedTypeArray[i] = (NamedType)selection.object;
        }
        return namedTypeArray;
    }

    public ReservoirElement selectReservoir(LocalPt object, boolean bl, boolean bl2) {
        if (!bl) {
            this._selectionList.clear();
        }
        if (this._sysmap == null || object == null) {
            return null;
        }
        object = this._mapPanel.scale().lp2wp(object);
        if ((object = this.findReservoir((WorldPt)object)) != null) {
            MapGlyph.Selection selection = new MapGlyph.Selection((MapGlyph)this, object, bl2);
            if (!this._selectionList.contains(selection)) {
                this._selectionList.add(selection);
            }
            if (bl) {
                Graphics graphics = this._mapPanel.viewport().getGraphics();
                this.drawSelectedReservoir(graphics, this._mapPanel.scale(), (ReservoirElement)object, false, bl2);
                graphics.dispose();
            } else {
                this._mapPanel.paintMap();
            }
        } else if (!bl) {
            this._mapPanel.paintMap();
        }
        return object;
    }

    public ReservoirElement selectReservoir(String object, boolean bl, boolean bl2) {
        if (!bl) {
            this._selectionList.clear();
        }
        if (this._sysmap == null || object == null) {
            return null;
        }
        if ((object = this.findReservoir((String)object)) != null) {
            MapGlyph.Selection selection = new MapGlyph.Selection((MapGlyph)this, object, bl2);
            if (!this._selectionList.contains(selection)) {
                this._selectionList.add(selection);
            }
            if (bl) {
                Graphics graphics = this._mapPanel.viewport().getGraphics();
                this.drawSelectedReservoir(graphics, this._mapPanel.scale(), (ReservoirElement)object, false, bl2);
                graphics.dispose();
            } else {
                this._mapPanel.paintMap();
            }
        } else if (!bl) {
            this._mapPanel.paintMap();
        }
        return object;
    }

    public JunctionElement selectJunction(LocalPt object, boolean bl, boolean bl2) {
        if (!bl) {
            this._selectionList.clear();
        }
        if (this._sysmap == null || object == null) {
            return null;
        }
        double d = this._mapPanel.scale().x2e(object.x + 5) - this._mapPanel.scale().x2e(object.x);
        object = this._mapPanel.scale().lp2wp(object);
        if ((object = this._sysmap.findJunction((WorldPt)object, d)) != null) {
            MapGlyph.Selection selection = new MapGlyph.Selection((MapGlyph)this, object, bl2);
            if (!this._selectionList.contains(selection)) {
                this._selectionList.add(selection);
            }
            if (bl) {
                Graphics graphics = this._mapPanel.viewport().getGraphics();
                this.drawSelectedJunction(graphics, this._mapPanel.scale(), (JunctionElement)object, false, bl2);
                graphics.dispose();
            } else {
                this._mapPanel.paintMap();
            }
        } else if (!bl) {
            this._mapPanel.paintMap();
        }
        return object;
    }

    public void createReservoir(Vector object, Vector vector, Vector vector2, Vector<StreamSegment> vector3) {
        if (this._sysmap == null || object == null) {
            return;
        }
        if (((Vector)object).size() <= 0) {
            return;
        }
        WorldRegion worldRegion = new WorldRegion();
        object = (LocalPt)((Vector)object).elementAt(0);
        double d = this._mapPanel.scale().x2e(((LocalPt)object).x + 5) - this._mapPanel.scale().x2e(((LocalPt)object).x);
        ReservoirElement reservoirElement = null;
        object = new NameDialog((Frame)((JFrame)AppDaddy.getFrame()), true);
        object.setNameFieldDocument((Document)new DssPathnamePartDocument());
        object.setName(this._sysmap.getNextDefaultName(1));
        object.setDescription("");
        object.setTitle("Name New Reservoir");
        object.setExistingNames((List)this._sysmap.getElementVector());
        object.setVisible(true);
        if (!object.isCanceled()) {
            String string = object.getName();
            object = object.getDescription();
            reservoirElement = this._sysmap.createReservoir(worldRegion, vector, vector2, d, string, (String)object);
            reservoirElement.setStreamSegmentVector(vector3);
            object = reservoirElement.getDownstreamNode().getLocation();
            object = this._mapPanel.scale().wp2lp((WorldPt)object);
            double d2 = this._mapPanel.scale().x2e(((LocalPt)object).x + 15);
            double d3 = this._mapPanel.scale().y2n(((LocalPt)object).y);
            worldRegion.pts.addElement(new WorldPt(d2, d3));
            d2 = this._mapPanel.scale().x2e(((LocalPt)object).x);
            d3 = this._mapPanel.scale().y2n(((LocalPt)object).y - 20);
            worldRegion.pts.addElement(new WorldPt(d2, d3));
            d2 = this._mapPanel.scale().x2e(((LocalPt)object).x - 15);
            d3 = this._mapPanel.scale().y2n(((LocalPt)object).y);
            worldRegion.pts.addElement(new WorldPt(d2, d3));
            reservoirElement.setRegion(worldRegion);
        }
        this._mapPanel.paintMap();
    }

    public void drawReservoir(Graphics graphics, MapScale mapScale, ReservoirElement reservoirElement) {
        Vector vector;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n;
        Object object5 = this.getStreamAlignmentGlyph();
        if (object5 == null) {
            return;
        }
        if (reservoirElement == null) {
            return;
        }
        Object object6 = this._reservoirDrawDataProvider.getReservoirDrawData(reservoirElement);
        Object object7 = reservoirElement.getRegion();
        int[] nArray = new int[((WorldRegion)object7).pts.size() + 1];
        int[] nArray2 = new int[((WorldRegion)object7).pts.size() + 1];
        for (n = 0; n < ((WorldRegion)object7).pts.size() && (object5 = (WorldPt)((WorldRegion)object7).pts.elementAt(n)) != null; ++n) {
            nArray[n] = mapScale.e2x(((WorldPt)object5).e);
            nArray2[n] = mapScale.n2y(((WorldPt)object5).n);
        }
        object5 = reservoirElement.getDownstreamNode();
        if (object5 != null) {
            object5 = ((RssNode)object5).getLocation();
            nArray[n] = mapScale.e2x(((WorldPt)object5).e);
            nArray2[n] = mapScale.n2y(((WorldPt)object5).n);
            ++n;
        }
        if (n > 0 && ((RssSystemDPReservoirData)object6).drawRPolygon) {
            if (graphics instanceof Graphics2D) {
                object4 = (Graphics2D)graphics;
                object5 = ((Graphics2D)object4).getComposite();
                object3 = AlphaComposite.getInstance(3, 0.6f);
                graphics.setColor(((RssSystemDPReservoirData)object6).fillColor);
                ((Graphics2D)object4).setComposite((Composite)object3);
                ((Graphics)object4).fillPolygon(nArray, nArray2, n);
                if (object5 != null) {
                    ((Graphics2D)object4).setComposite((Composite)object5);
                }
            } else {
                graphics.setPaintMode();
                graphics.setColor(((RssSystemDPReservoirData)object6).fillColor);
                graphics.fillPolygon(nArray, nArray2, n);
            }
            graphics.setColor(((RssSystemDPReservoirData)object6).outlineColor);
            graphics.drawPolygon(nArray, nArray2, n);
        }
        object4 = reservoirElement.getNodeVector();
        reservoirElement.getNodeDirVector();
        int n2 = object4.size();
        double d = (double)((RssSystemDPReservoirData)object6).reachWidth / 1.5;
        object3 = reservoirElement.getStreamSegmentVector();
        if (object3 != null) {
            n2 = object3.size();
            for (n = 0; n < n2; ++n) {
                var20_27 = (StreamSegment)object3.get(n);
                if (var20_27 == null || (object2 = var20_27.stream) != null) continue;
                StreamNameMapper.a(this._sysmap, this._sysmap.getAlignment());
                break;
            }
            for (n = 0; n < n2; ++n) {
                int n3;
                var20_27 = (StreamSegment)object3.get(n);
                if (var20_27 == null || (object2 = var20_27.stream) == null || (var21_30 = var20_27.downstreamStation != Double.NEGATIVE_INFINITY ? object2.getCoordByStation(var20_27.downstreamStation) : var20_27.downstreamCoord) == (var23_32 = var20_27.upstreamStation != Double.NEGATIVE_INFINITY ? object2.getCoordByStation(var20_27.upstreamStation) : var20_27.upstreamCoord)) continue;
                object5 = object2.getLineSegment(var21_30, var23_32);
                if (nArray.length < ((WorldLine)object5).pts.size() << 1) {
                    nArray = new int[((WorldLine)object5).pts.size() << 1];
                    nArray2 = new int[((WorldLine)object5).pts.size() << 1];
                }
                if ((n3 = object5.getLocalRegionArrays(mapScale, nArray, nArray2, d)) <= 0) continue;
                graphics.setPaintMode();
                graphics.setColor(((RssSystemDPReservoirData)object6).fillColor.darker());
                graphics.fillPolygon(nArray, nArray2, n3);
                graphics.setColor(((RssSystemDPReservoirData)object6).outlineColor.darker());
                graphics.drawPolygon(nArray, nArray2, n3);
            }
        } else {
            for (n = 0; n < n2; ++n) {
                int n4;
                object5 = (RssNode)object4.get(n);
                if (object5 == null || (var20_27 = ((RssNode)object5).getStream()) == null) continue;
                var21_30 = ((RssNode)object5).getStreamCoord();
                var23_32 = Double.NEGATIVE_INFINITY;
                for (n4 = 0; n4 < n2; ++n4) {
                    if (n == n4 || (object3 = (RssNode)object4.get(n4)) == null || object3.getStreamIndex() != object5.getStreamIndex()) continue;
                    var23_32 = ((RssNode)object3).getStreamCoord();
                    break;
                }
                if (var23_32 == Double.NEGATIVE_INFINITY) {
                    n4 = reservoirElement.getNodeDir(n);
                    if (n4 == 1) {
                        var23_32 = 0.0;
                    } else {
                        var23_32 = var21_30;
                        var21_30 = 1.0;
                    }
                } else if (var23_32 >= var21_30) continue;
                object5 = var20_27.getLineSegment(var23_32, var21_30);
                if (nArray.length < ((WorldLine)object5).pts.size() << 1) {
                    nArray = new int[((WorldLine)object5).pts.size() << 1];
                    nArray2 = new int[((WorldLine)object5).pts.size() << 1];
                }
                if ((n4 = object5.getLocalRegionArrays(mapScale, nArray, nArray2, d)) <= 0) continue;
                graphics.setPaintMode();
                graphics.setColor(((RssSystemDPReservoirData)object6).fillColor.darker());
                graphics.fillPolygon(nArray, nArray2, n4);
                graphics.setColor(((RssSystemDPReservoirData)object6).outlineColor.darker());
                graphics.drawPolygon(nArray, nArray2, n4);
            }
        }
        if (((RssSystemDPReservoirData)object6).minDrawWidth > 0) {
            double d2 = (double)((RssSystemDPReservoirData)object6).minDrawWidth / 1.5;
            WorldPt worldPt = new WorldPt();
            object = new WorldPt();
            object2 = reservoirElement.getElementsByClass(ReservoirDamElement.class, null);
            for (n = 0; n < object2.size(); ++n) {
                object4 = (Element)object2.get(n);
                object5 = ((Element)object4).getDownstreamNode();
                if (object5 == null) continue;
                vector = this._mapPanel.scale().wp2lp(((RssNode)object5).getLocation());
                object3 = ((RssNode)object5).getStream();
                if (object3 == null) continue;
                object3.getLine().getSlopeAtCoord(((RssNode)object5).getStreamCoord(), worldPt, (WorldPt)object);
                Color color = graphics.getColor();
                graphics.setColor(((RssSystemDPReservoirData)object6).drawColor);
                nArray[0] = (int)((double)((LocalPt)vector).x - ((WorldPt)object).n * d2 * 2.0 + ((WorldPt)object).e * d2 / 2.0 + 0.5);
                nArray[1] = (int)((double)((LocalPt)vector).x - ((WorldPt)object).n * d2 * 2.0 - ((WorldPt)object).e * d2 / 2.0 + 0.5);
                nArray[2] = (int)((double)((LocalPt)vector).x + ((WorldPt)object).n * d2 * 2.0 - ((WorldPt)object).e * d2 / 2.0 + 0.5);
                nArray[3] = (int)((double)((LocalPt)vector).x + ((WorldPt)object).n * d2 * 2.0 + ((WorldPt)object).e * d2 / 2.0 + 0.5);
                nArray2[0] = (int)((double)((LocalPt)vector).y - ((WorldPt)object).e * d2 * 2.0 - ((WorldPt)object).n * d2 / 2.0 + 0.5);
                nArray2[1] = (int)((double)((LocalPt)vector).y - ((WorldPt)object).e * d2 * 2.0 + ((WorldPt)object).n * d2 / 2.0 + 0.5);
                nArray2[2] = (int)((double)((LocalPt)vector).y + ((WorldPt)object).e * d2 * 2.0 + ((WorldPt)object).n * d2 / 2.0 + 0.5);
                nArray2[3] = (int)((double)((LocalPt)vector).y + ((WorldPt)object).e * d2 * 2.0 - ((WorldPt)object).n * d2 / 2.0 + 0.5);
                graphics.fillPolygon(nArray, nArray2, 4);
                graphics.setColor(color);
            }
        }
        if (!((object5 = ((Element)reservoirElement).getReferencePt()) != null && object5.isValid() || ((WorldRegion)object7).pts.size() <= 1)) {
            object5 = (WorldPt)((WorldRegion)object7).pts.get(1);
            reservoirElement.setReferencePt(new WorldPt((WorldPt)object5));
        }
        int n5 = mapScale.e2x(((WorldPt)object5).e);
        int n6 = mapScale.n2y(((WorldPt)object5).n);
        if (_impactImage == null) {
            graphics.setColor(Color.red);
            graphics.fillOval(n5 - 2, n6 - 2, 4, 4);
            graphics.setColor(Color.blue);
            graphics.drawOval(n5 - 2, n6 - 2, 4, 4);
        }
        if (((RssSystemDPReservoirData)object6).drawName) {
            this._mapPanel.viewport().addMapLabelItem(new MapLabelItem(reservoirElement.getName(), n5 + 10, n6 + 4, reservoirElement.getLabelPosition(), 5, this._glyphLevel + 0.1f, ((RssSystemDPReservoirData)object6).nameFont, ((RssSystemDPReservoirData)object6).outlineColor, null, graphics));
        }
        vector = reservoirElement.getDivertedOutlets();
        int n7 = vector.size();
        for (n = 0; n < n7; ++n) {
            object = (DivertedOutletElement)vector.get(n);
            this.drawDivertedOutlet(graphics, mapScale, (DivertedOutletElement)object);
        }
        object = this._sysmap.getAlternative();
        if (object != null) {
            int n8 = ((RssAlt)object).getResOpSetSelection(reservoirElement.getIndex());
            object4 = new Vector();
            reservoirElement.getDownstreamRules(n8, (List)object4);
            n2 = ((Vector)object4).size();
            for (int i = 0; i < n2; ++i) {
                object5 = (OpRule)((Vector)object4).elementAt(i);
                if (!(object5 instanceof DownstreamCntrlOpRule)) continue;
                DownstreamCntrlOpRule downstreamCntrlOpRule = (DownstreamCntrlOpRule)object5;
                int n9 = downstreamCntrlOpRule.getDownstreamControlLocationID();
                object6 = this._sysmap.getNode(n9);
                object7 = null;
                if (object6 == null) {
                    System.out.println("Error -  Reservoir: " + reservoirElement.getName() + ", Rule: " + object5.getName() + ", stream node ID: " + n9 + "  is not valid.");
                    continue;
                }
                if (((RssNode)object6).getUpstreamElement() instanceof JunctionElement) {
                    object7 = (JunctionElement)((RssNode)object6).getUpstreamElement();
                } else if (((RssNode)object6).getDownstreamElement() instanceof JunctionElement) {
                    object7 = (JunctionElement)((RssNode)object6).getDownstreamElement();
                }
                if (object7 == null) continue;
                RssSystemDPJunctionData rssSystemDPJunctionData = this._junctionDrawDataProvider.getJunctionDrawData((JunctionElement)object7);
                int n10 = rssSystemDPJunctionData.junctionWidth;
                d = (int)((double)n10 / 2.0);
                WorldPt worldPt = ((Element)object7).getReferencePt();
                if (worldPt == null || !worldPt.isValid()) continue;
                n5 = mapScale.e2x(worldPt.e);
                n6 = mapScale.n2y(worldPt.n);
                int n11 = (int)(d * 1.8);
                int n12 = n11 << 1;
                graphics.setColor(Color.LIGHT_GRAY);
                int n13 = n12;
                graphics.fillRect(n5 - n11, n6 - n11, n13, n13);
                graphics.setColor(rssSystemDPJunctionData.outlineColor);
                int n14 = n12;
                graphics.drawRect(n5 - n11, n6 - n11, n14, n14);
            }
        }
    }

    public void drawSelectedReservoir(Graphics graphics, MapScale mapScale, ReservoirElement reservoirElement, boolean bl, boolean bl2) {
        this.drawSelectedReservoir(graphics, mapScale, reservoirElement, bl, bl2, true);
    }

    public void drawSelectedReservoir(Graphics graphics, MapScale mapScale, ReservoirElement reservoirElement, boolean bl, boolean bl2, boolean n) {
        int n2;
        int n3;
        Object object;
        int n4 = 0;
        Object object2 = new LocalPt();
        RssSystemDPReservoirData rssSystemDPReservoirData = this._reservoirDrawDataProvider.getReservoirDrawData(reservoirElement);
        int n5 = Math.min(reservoirElement.getRegion().pts.size(), 4000);
        int[] nArray = new int[n5 + 1];
        int[] nArray2 = new int[n5 + 1];
        for (int i = 0; i < n5; ++i) {
            object = (WorldPt)reservoirElement.getRegion().pts.elementAt(i);
            if (object == null) continue;
            mapScale.wp2lp((WorldPt)object, (LocalPt)object2);
            nArray[n4] = ((LocalPt)object2).x;
            nArray2[n4] = ((LocalPt)object2).y;
            ++n4;
        }
        RssNode rssNode = reservoirElement.getDownstreamNode();
        if (rssNode != null) {
            object = rssNode.getLocation();
            nArray[n4] = mapScale.e2x(((WorldPt)object).e);
            nArray2[n4] = mapScale.n2y(((WorldPt)object).n);
            ++n4;
        }
        if (n != 0) {
            if (graphics instanceof Graphics2D) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                object2 = graphics2D.getComposite();
                object = AlphaComposite.getInstance(3, 0.6f);
                graphics.setColor(Color.yellow);
                graphics2D.setComposite((Composite)object);
                graphics2D.fillPolygon(nArray, nArray2, n4);
                if (object2 != null) {
                    graphics2D.setComposite((Composite)object2);
                }
            } else {
                if (bl) {
                    graphics.setXORMode(XOR_COLOR);
                }
                graphics.setColor(Color.yellow);
                graphics.fillPolygon(nArray, nArray2, n4);
                graphics.setPaintMode();
            }
        }
        if (bl) {
            graphics.setXORMode(XOR_COLOR);
        }
        graphics.setColor(rssSystemDPReservoirData.outlineColor);
        graphics.drawPolygon(nArray, nArray2, n4);
        if (bl2) {
            for (n = 0; n < n4; ++n) {
                RssSystemGlyph._xpt[0] = nArray[n] - 3;
                RssSystemGlyph._ypt[0] = nArray2[n];
                RssSystemGlyph._xpt[1] = nArray[n];
                RssSystemGlyph._ypt[1] = nArray2[n] + 3;
                RssSystemGlyph._xpt[2] = nArray[n] + 3;
                RssSystemGlyph._ypt[2] = nArray2[n];
                RssSystemGlyph._xpt[3] = nArray[n];
                RssSystemGlyph._ypt[3] = nArray2[n] - 3;
                graphics.fillPolygon(_xpt, _ypt, 4);
            }
        }
        ReservoirElement reservoirElement2 = reservoirElement;
        object2 = reservoirElement2.getNodeVector();
        reservoirElement2.getNodeDirVector();
        ((Vector)object2).size();
        double d = (double)rssSystemDPReservoirData.reachWidth / 1.5;
        this.getStreamAlignmentGlyph();
        object = reservoirElement2.getStreamSegmentVector();
        if (object != null) {
            n4 = ((Vector)object).size();
            for (n3 = 0; n3 < n4; ++n3) {
                int n6;
                double d2;
                double d3;
                StreamSegment streamSegment = (StreamSegment)((Vector)object).elementAt(n3);
                if (streamSegment == null || (rssNode = streamSegment.stream) == null || (d3 = streamSegment.downstreamStation != Double.NEGATIVE_INFINITY ? rssNode.getCoordByStation(streamSegment.downstreamStation) : streamSegment.downstreamCoord) == (d2 = streamSegment.upstreamStation != Double.NEGATIVE_INFINITY ? rssNode.getCoordByStation(streamSegment.upstreamStation) : streamSegment.upstreamCoord)) continue;
                rssNode = rssNode.getLineSegment(d3, d2);
                if (nArray.length < ((WorldLine)rssNode).pts.size() << 1) {
                    nArray = new int[((WorldLine)rssNode).pts.size() << 1];
                    nArray2 = new int[((WorldLine)rssNode).pts.size() << 1];
                }
                if ((n6 = rssNode.getLocalRegionArrays(mapScale, nArray, nArray2, d)) <= 0) continue;
                graphics.setColor(Color.yellow);
                graphics.fillPolygon(nArray, nArray2, n6);
                graphics.setColor(rssSystemDPReservoirData.outlineColor.darker());
                graphics.drawPolygon(nArray, nArray2, n6);
            }
        } else {
            for (n5 = 0; n5 < ((Vector)object2).size(); ++n5) {
                int n7;
                StreamElement streamElement;
                object = (RssNode)((Vector)object2).elementAt(n5);
                if (object == null || (streamElement = ((RssNode)object).getStream()) == null) continue;
                double d4 = ((RssNode)object).getStreamCoord();
                double d5 = Double.NEGATIVE_INFINITY;
                for (int i = 0; i < ((Vector)object2).size(); ++i) {
                    RssNode rssNode2;
                    if (n5 == i || (rssNode2 = (RssNode)((Vector)object2).elementAt(i)) == null || rssNode2.getStreamIndex() != object.getStreamIndex()) continue;
                    d5 = rssNode2.getStreamCoord();
                    break;
                }
                if (d5 == Double.NEGATIVE_INFINITY) {
                    d5 = 0.0;
                }
                if (d5 >= d4) continue;
                StreamPolyLine streamPolyLine = streamElement.getLineSegment(d5, d4);
                if (nArray.length < streamPolyLine.pts.size() << 1) {
                    nArray = new int[streamPolyLine.pts.size() << 1];
                    nArray2 = new int[streamPolyLine.pts.size() << 1];
                }
                if ((n7 = streamPolyLine.getLocalRegionArrays(mapScale, nArray, nArray2, d)) <= 0) continue;
                graphics.setColor(Color.yellow);
                graphics.fillPolygon(nArray, nArray2, n7);
                graphics.setColor(rssSystemDPReservoirData.outlineColor.darker());
                graphics.drawPolygon(nArray, nArray2, n7);
            }
        }
        WorldPt worldPt = new WorldPt();
        WorldPt worldPt2 = new WorldPt();
        Vector vector = reservoirElement2.getElementsByClass(ReservoirDamElement.class, null);
        for (n2 = 0; n2 < vector.size(); ++n2) {
            Element element = (Element)vector.elementAt(n2);
            object = element.getDownstreamNode();
            if (object == null) continue;
            LocalPt localPt = this._mapPanel.scale().wp2lp(((RssNode)object).getLocation());
            Object object3 = ((RssNode)object).getStream();
            if (object3 == null) continue;
            object3.getLine().getSlopeAtCoord(((RssNode)object).getStreamCoord(), worldPt, worldPt2);
            object3 = graphics.getColor();
            graphics.setColor(Color.yellow);
            nArray[0] = (int)((double)localPt.x - worldPt2.n * d * 2.0 + worldPt2.e * d / 2.0 + 0.5);
            nArray[1] = (int)((double)localPt.x - worldPt2.n * d * 2.0 - worldPt2.e * d / 2.0 + 0.5);
            nArray[2] = (int)((double)localPt.x + worldPt2.n * d * 2.0 - worldPt2.e * d / 2.0 + 0.5);
            nArray[3] = (int)((double)localPt.x + worldPt2.n * d * 2.0 + worldPt2.e * d / 2.0 + 0.5);
            nArray2[0] = (int)((double)localPt.y - worldPt2.e * d * 2.0 - worldPt2.n * d / 2.0 + 0.5);
            nArray2[1] = (int)((double)localPt.y - worldPt2.e * d * 2.0 + worldPt2.n * d / 2.0 + 0.5);
            nArray2[2] = (int)((double)localPt.y + worldPt2.e * d * 2.0 + worldPt2.n * d / 2.0 + 0.5);
            nArray2[3] = (int)((double)localPt.y + worldPt2.e * d * 2.0 - worldPt2.n * d / 2.0 + 0.5);
            graphics.fillPolygon(nArray, nArray2, 4);
            graphics.setColor(Color.blue);
            graphics.drawPolygon(nArray, nArray2, 4);
            graphics.setColor((Color)object3);
        }
        object = ((Element)reservoirElement).getReferencePt();
        n2 = mapScale.e2x(((WorldPt)object).e);
        n3 = mapScale.n2y(((WorldPt)object).n);
        if (bl2) {
            graphics.setColor(Color.yellow);
            graphics.fillOval(n2 - 3, n3 - 3, 6, 6);
            graphics.setColor(Color.blue);
            graphics.drawOval(n2 - 3, n3 - 3, 6, 6);
        }
        if (bl) {
            graphics.setPaintMode();
        }
    }

    public float getGlyphLevel() {
        if (this._parentGlyph == null) {
            return this._mapPanel.getGlyphLevel((MapGlyph)this);
        }
        return this._glyphLevel;
    }

    public void draw(Graphics graphics, MapScale mapScale) {
        Element element;
        int n;
        if (this._sysmap == null) {
            return;
        }
        this._glyphLevel = this.getGlyphLevel();
        Cloneable cloneable = this._sysmap.getElementVector();
        this._diversionData = this.getDiversionDataForCurrentScale();
        for (n = 0; _paintOk && n < cloneable.size(); ++n) {
            element = (Element)cloneable.elementAt(n);
            if (element == null) continue;
            if (element instanceof ReservoirElement) {
                if (!this._rssDas.isAttributeShown("Reservoirs")) continue;
                this.drawReservoir(graphics, mapScale, (ReservoirElement)element);
                continue;
            }
            if (!(element instanceof ReachElement) || !this._rssDas.isAttributeShown("Reaches")) continue;
            this.drawReach(graphics, mapScale, (ReachElement)element);
        }
        for (n = 0; _paintOk && n < cloneable.size(); ++n) {
            element = (Element)cloneable.elementAt(n);
            if (element == null || !(element instanceof JunctionElement) || !this._rssDas.isAttributeShown("Junctions")) continue;
            this.drawJunction(graphics, mapScale, (JunctionElement)element);
        }
        for (n = 0; _paintOk && n < cloneable.size(); ++n) {
            element = (Element)cloneable.elementAt(n);
            if (element == null || !(element instanceof DiversionElement) || !this._rssDas.isAttributeShown("Diversions")) continue;
            this.drawDiversion(graphics, mapScale, (DiversionElement)element);
        }
        for (n = 0; _paintOk && n < this._selectionList.size(); ++n) {
            element = this._selectionList.get(n);
            if (((MapGlyph.Selection)element).object == null) continue;
            if (((MapGlyph.Selection)element).object instanceof ReservoirElement) {
                cloneable = (ReservoirElement)((MapGlyph.Selection)element).object;
                if (!this._rssDas.isAttributeShown("Reservoirs")) continue;
                this.drawSelectedReservoir(graphics, mapScale, (ReservoirElement)cloneable, false, ((MapGlyph.Selection)element).editing);
                continue;
            }
            if (((MapGlyph.Selection)element).object instanceof ReachElement) {
                if (!this._rssDas.isAttributeShown("Reaches")) continue;
                this.drawSelectedReach(graphics, mapScale, (ReachElement)((MapGlyph.Selection)element).object, false, ((MapGlyph.Selection)element).editing);
                continue;
            }
            if (((MapGlyph.Selection)element).object instanceof JunctionElement) {
                if (!this._rssDas.isAttributeShown("Junctions")) continue;
                this.drawSelectedJunction(graphics, mapScale, (JunctionElement)((MapGlyph.Selection)element).object, false, ((MapGlyph.Selection)element).editing);
                continue;
            }
            if (((MapGlyph.Selection)element).object instanceof DiversionElement) {
                if (!this._rssDas.isAttributeShown("Diversions")) continue;
                this.drawSelectedDiversion(graphics, mapScale, (DiversionElement)((MapGlyph.Selection)element).object, false, ((MapGlyph.Selection)element).editing);
                continue;
            }
            if (!(((MapGlyph.Selection)element).object instanceof DivertedOutletElement) || !this._rssDas.isAttributeShown("Reservoirs")) continue;
            this.drawSelectedDivertedOutlet(graphics, mapScale, (DivertedOutletElement)((MapGlyph.Selection)element).object, false, ((MapGlyph.Selection)element).editing);
        }
    }

    protected void drawSelectedElement(Graphics graphics, MapScale mapScale, Element element) {
        this.drawSelectedElement(graphics, mapScale, element, false, false);
    }

    protected void drawSelectedElement(Graphics graphics, MapScale mapScale, Element element, boolean bl, boolean bl2) {
        if (element instanceof ReservoirElement) {
            this.drawSelectedReservoir(graphics, mapScale, (ReservoirElement)element, bl, bl2);
            return;
        }
        if (element instanceof ReachElement) {
            this.drawSelectedReach(graphics, mapScale, (ReachElement)element, bl, bl2);
            return;
        }
        if (element instanceof DiversionElement) {
            this.drawSelectedDiversion(graphics, mapScale, (DiversionElement)element, bl, bl2);
            return;
        }
        if (element instanceof JunctionElement) {
            this.drawSelectedJunction(graphics, mapScale, (JunctionElement)element, bl, bl2);
            return;
        }
        if (element instanceof DivertedOutletElement) {
            this.drawDivertedOutlet(graphics, mapScale, (DivertedOutletElement)element);
        }
    }

    protected void drawElement(Graphics graphics, MapScale mapScale, Element element) {
        if (element instanceof ReservoirElement) {
            this.drawReservoir(graphics, mapScale, (ReservoirElement)element);
            return;
        }
        if (element instanceof ReachElement) {
            this.drawReach(graphics, mapScale, (ReachElement)element);
            return;
        }
        if (element instanceof DiversionElement) {
            this.drawDiversion(graphics, mapScale, (DiversionElement)element);
            return;
        }
        if (element instanceof JunctionElement) {
            this.drawJunction(graphics, mapScale, (JunctionElement)element);
            return;
        }
        if (element instanceof DivertedOutletElement) {
            this.drawDivertedOutlet(graphics, mapScale, (DivertedOutletElement)element);
        }
    }

    private void fixJunctionLocationsAtConfluences(RssSystem object) {
        if (object == null) {
            return;
        }
        object = ((RssSystem)object).getElementVectorByClass(JunctionElement.class);
        StreamAlignmentGlyph streamAlignmentGlyph = this.getStreamAlignmentGlyph();
        MapScale mapScale = this.getMapPanel().scale((MapGlyph)this);
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            double d;
            int n;
            Object object2;
            Vector vector;
            JunctionElement junctionElement = (JunctionElement)((Vector)object).get(i);
            if (!this.atStreamJunction(junctionElement) || (vector = junctionElement.getNodeVector()).size() <= 0) continue;
            int n2 = -1;
            Vector vector2 = junctionElement.getNodeDirVector();
            WorldPt worldPt = null;
            if (junctionElement.getStreamJunctionId() >= 0 && streamAlignmentGlyph != null && (object2 = streamAlignmentGlyph.findStreamJunction(junctionElement.getStreamJunctionId())) != null) {
                worldPt = object2.getLocation();
            }
            for (n = 0; n < vector2.size(); ++n) {
                object2 = (RssNode)vector.get(n);
                if ((!vector2.get(n).equals(1) || !RmaMath.equals((double)0.0, (double)((RssNode)object2).getStreamCoord(), (double)1.0E-6)) && (!vector2.get(n).equals(0) || !RmaMath.equals((double)1.0, (double)((RssNode)object2).getStreamCoord(), (double)1.0E-6))) continue;
                n2 = n;
                break;
            }
            if (n2 < 0 && worldPt == null) continue;
            if (worldPt == null) {
                object2 = (RssNode)vector.get(n2);
                d = ((RssNode)object2).getStreamCoord();
                worldPt = ((RssNode)object2).getStream().getLocationByCoord(d);
            }
            LocalPt localPt = mapScale.wp2lp(worldPt);
            for (n = 0; n < vector.size(); ++n) {
                object2 = (RssNode)vector.get(n);
                if (((RssNode)object2).getLocation().equals(worldPt)) continue;
                object2.setLocation((WorldPt)worldPt.clone());
                vector2 = ((RssNode)object2).getStream();
                double d2 = vector2.getStationByLocation(worldPt);
                ((RssNode)object2).setStreamStation(d2);
                d = vector2.getCoordByLocation(worldPt);
                object2.setStreamCoord(d);
                if (junctionElement.getStreamJunctionId() != -1 || (object2 = streamAlignmentGlyph.findStreamJunction((StreamElement)vector2, localPt)) == null) continue;
                junctionElement.setStreamJunctionId(object2.getIndex());
            }
        }
    }

    private boolean atStreamJunction(JunctionElement object) {
        StreamElement streamElement;
        RssNode rssNode;
        if (((JunctionElement)object).getStreamJunctionId() >= 0) {
            return true;
        }
        object = ((Element)object).getNodeVector();
        StreamAlignmentGlyph streamAlignmentGlyph = this.getStreamAlignmentGlyph();
        if (streamAlignmentGlyph != null) {
            MapScale mapScale = this.getMapPanel().scale((MapGlyph)this);
            for (int i = 0; i < object.size(); ++i) {
                rssNode = (RssNode)object.get(i);
                double d = rssNode.getStreamCoord();
                if (d != 1.0 && d != 0.0) continue;
                streamElement = rssNode.getStream();
                rssNode = streamElement.getLocationByCoord(d);
                rssNode = mapScale.wp2lp((WorldPt)rssNode);
                if ((rssNode = streamAlignmentGlyph.findStreamJunction(streamElement, (LocalPt)rssNode)) == null) continue;
                return true;
            }
        }
        streamElement = ((RssNode)object.get(0)).getStream();
        for (int i = 1; i < object.size(); ++i) {
            rssNode = (RssNode)object.get(i);
            if (rssNode.getStream() == streamElement) continue;
            return true;
        }
        return false;
    }

    public void drawJunction(Graphics graphics, MapScale mapScale, JunctionElement junctionElement) {
        int n;
        RssSystemDPJunctionData rssSystemDPJunctionData = this._junctionDrawDataProvider.getJunctionDrawData(junctionElement);
        if (junctionElement == null) {
            return;
        }
        if (rssSystemDPJunctionData == null) {
            this.getJunctionData();
        }
        if (rssSystemDPJunctionData.junctionWidth < 0) {
            return;
        }
        int n2 = rssSystemDPJunctionData.junctionWidth;
        int n3 = (int)((double)rssSystemDPJunctionData.junctionWidth / 2.0);
        Object object = junctionElement.getReferencePt();
        if (object == null || !object.isValid()) {
            return;
        }
        int n4 = mapScale.e2x(object.e);
        int n5 = mapScale.n2y(object.n);
        if (this._sysmap.getAlternative() == null && junctionElement.isDownstreamControlLocation()) {
            int n6 = (int)((double)n3 * 1.8);
            n = n6 << 1;
            graphics.setColor(Color.LIGHT_GRAY);
            int n7 = n;
            graphics.fillRect(n4 - n6, n5 - n6, n7, n7);
            graphics.setColor(rssSystemDPJunctionData.outlineColor);
            int n8 = n;
            graphics.drawRect(n4 - n6, n5 - n6, n8, n8);
        }
        if (junctionElement.getLocalFlowVector().size() > 0) {
            int n9 = (int)((double)n3 * 1.5);
            n = n9 << 1;
            graphics.setColor(Color.white);
            int n10 = n;
            graphics.fillOval(n4 - n9, n5 - n9, n10, n10);
            graphics.setColor(rssSystemDPJunctionData.outlineColor);
            int n11 = n;
            graphics.drawOval(n4 - n9, n5 - n9, n11, n11);
        }
        object = rssSystemDPJunctionData.fillColor;
        String string = junctionElement.getFillColorName();
        if (string != null && (object = RmaColor.parseColorString((String)string)) == null) {
            object = rssSystemDPJunctionData.fillColor;
        }
        graphics.setColor((Color)object);
        int n12 = n2;
        graphics.fillOval(n4 - n3, n5 - n3, n12, n12);
        graphics.setColor(rssSystemDPJunctionData.outlineColor);
        int n13 = n2;
        graphics.drawOval(n4 - n3, n5 - n3, n13, n13);
        if (rssSystemDPJunctionData.drawName) {
            this._mapPanel.viewport().addMapLabelItem(new MapLabelItem(junctionElement.getName(), n4, n5, junctionElement.getLabelPosition(), (int)((double)n3 * 1.5 + 3.0), this._glyphLevel + 0.3f, rssSystemDPJunctionData.nameFont, rssSystemDPJunctionData.fillColor, null, graphics));
        }
    }

    public void drawSelectedJunction(Graphics graphics, MapScale mapScale, JunctionElement junctionElement, boolean bl, boolean bl2) {
        if (junctionElement == null) {
            return;
        }
        RssSystemDPJunctionData rssSystemDPJunctionData = this.getJunctionDataForCurrentScale();
        if (rssSystemDPJunctionData.junctionWidth == 0) {
            return;
        }
        int n = rssSystemDPJunctionData.junctionWidth;
        int n2 = (int)((double)rssSystemDPJunctionData.junctionWidth / 2.0);
        if ((junctionElement = junctionElement.getReferencePt()) == null || !junctionElement.isValid()) {
            return;
        }
        int n3 = mapScale.e2x(((WorldPt)junctionElement).e);
        int n4 = mapScale.n2y(((WorldPt)junctionElement).n);
        graphics.setColor(Color.yellow);
        int n5 = n;
        graphics.fillOval(n3 - n2, n4 - n2, n5, n5);
        graphics.setColor(rssSystemDPJunctionData.outlineColor);
        int n6 = n;
        graphics.drawOval(n3 - n2, n4 - n2, n6, n6);
        if (bl) {
            graphics.setXORMode(XOR_COLOR);
        }
        if (bl2) {
            graphics.setColor(Color.black);
            graphics.fillRect(n3 - n2 - 5, n4 - n2 - 5, 5, 5);
            graphics.fillRect(n3 - n2 - 5, n4 + n2, 5, 5);
            graphics.fillRect(n3 + n2, n4 - n2 - 5, 5, 5);
            graphics.fillRect(n3 + n2, n4 + n2, 5, 5);
        }
        if (bl) {
            graphics.setPaintMode();
        }
    }

    public ReachElement selectReach(LocalPt object, boolean bl, boolean bl2) {
        double d = this._mapPanel.scale().x2e(object.x + 5) - this._mapPanel.scale().x2e(object.x);
        if (!bl) {
            this._selectionList.clear();
        }
        if (this._sysmap == null || object == null) {
            return null;
        }
        object = this._mapPanel.scale().lp2wp(object);
        object = this.findReach((WorldPt)object, d);
        this.selectElement(bl, bl2, (Element)object);
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void selectElement(boolean bl, boolean bl2, Element element) {
        if (element == null) {
            if (bl) return;
            this._mapPanel.paintMap();
            return;
        }
        MapGlyph.Selection selection = new MapGlyph.Selection((MapGlyph)this, (Object)element, bl2);
        if (!this._selectionList.contains(selection)) {
            this._selectionList.add(selection);
        }
        if (bl) {
            Graphics graphics = this._mapPanel.viewport().getGraphics();
            this.drawSelectedElement(graphics, this._mapPanel.scale(), element, false, bl2);
            graphics.dispose();
            return;
        }
        this._mapPanel.paintMap();
    }

    public ReachElement findReach(LocalPt localPt) {
        double d = this._mapPanel.scale().x2e(localPt.x + 5) - this._mapPanel.scale().x2e(localPt.x);
        localPt = this._mapPanel.scale().lp2wp(localPt);
        return this._sysmap.findReach((WorldPt)localPt, d);
    }

    public ReachElement findReach(WorldPt worldPt) {
        double d = this._mapPanel.scale().x2e(5) - this._mapPanel.scale().x2e(0);
        return this._sysmap.findReach(worldPt, d);
    }

    public ReachElement findReach(WorldPt worldPt, double d) {
        return this._sysmap.findReach(worldPt, d);
    }

    public void drawReach(Graphics graphics, MapScale mapScale, ReachElement reachElement) {
        WorldPt worldPt;
        double d;
        StreamAlignmentGlyph streamAlignmentGlyph = this.getStreamAlignmentGlyph();
        if (streamAlignmentGlyph == null) {
            return;
        }
        if (reachElement == null) {
            return;
        }
        RssNode rssNode = ((Element)reachElement).getUpstreamNode();
        RssNode rssNode2 = ((Element)reachElement).getDownstreamNode();
        if (rssNode == null || rssNode2 == null) {
            System.out.println("\nWarning, error in reach " + reachElement.getName() + " connectivity!\n");
            return;
        }
        StreamElement streamElement = null;
        if (streamAlignmentGlyph != null) {
            streamElement = rssNode.getStream();
        }
        RssSystemDPReachData rssSystemDPReachData = this._reachDrawDataProvider.getReachDrawData(reachElement);
        if (streamElement != null) {
            if (rssNode.getStreamStation() == rssNode2.getStreamStation()) {
                System.out.println("RssSystemGlyph.drawReach: Warning, reach" + reachElement.getName() + " has zero length!");
                return;
            }
            d = rssNode.getStreamCoord();
            double d2 = rssNode2.getStreamCoord();
            streamAlignmentGlyph = streamElement.getLineSegment(d2, d);
        } else {
            streamAlignmentGlyph = new WorldLine();
            streamAlignmentGlyph.pts.addElement(rssNode.getLocation());
            streamAlignmentGlyph.pts.addElement(rssNode2.getLocation());
        }
        d = (double)rssSystemDPReachData.reachWidth / 2.0;
        Color color = rssSystemDPReachData.fillColor;
        String string = reachElement.getFillColorName();
        if (string != null && (color = RmaColor.parseColorString((String)string)) == null) {
            color = rssSystemDPReachData.fillColor;
        }
        this.drawLine(graphics, (WorldLine)streamAlignmentGlyph, mapScale, d, color, null);
        if (rssSystemDPReachData.drawReachArrow) {
            graphics.setColor(rssSystemDPReachData.fillColor);
            worldPt = new WorldPt();
            color = new WorldPt();
            streamAlignmentGlyph.getSlopeAtCoord(0.5, worldPt, (WorldPt)color);
            this.drawArrow(graphics, mapScale, worldPt, (WorldPt)color);
        }
        worldPt = rssNode.getLocation();
        color = rssNode2.getLocation();
        int n = mapScale.e2x(worldPt.e);
        int n2 = mapScale.n2y(worldPt.n);
        graphics.setColor(Color.red);
        graphics.fillOval(n - 2, n2 - 2, 4, 4);
        graphics.setColor(rssSystemDPReachData.outlineColor);
        graphics.drawOval(n - 2, n2 - 2, 4, 4);
        n = mapScale.e2x(((WorldPt)color).e);
        n2 = mapScale.n2y(((WorldPt)color).n);
        graphics.setColor(Color.red);
        graphics.fillOval(n - 2, n2 - 2, 4, 4);
        graphics.setColor(rssSystemDPReachData.outlineColor);
        graphics.drawOval(n - 2, n2 - 2, 4, 4);
        if (rssSystemDPReachData.drawReachName && streamElement != null) {
            double d3 = (rssNode.getStreamCoord() + rssNode2.getStreamCoord()) / 2.0;
            graphics.setColor(rssSystemDPReachData.fillColor);
            Font font = graphics.getFont();
            graphics.setFont(rssSystemDPReachData.nameFont);
            this.drawConformingString(graphics, mapScale, streamElement.getLine(), reachElement.getName(), d3, (int)d, graphics.getFont(), rssSystemDPReachData.outlineColor, 1, this._glyphLevel + 0.4f);
            graphics.setFont(font);
        }
    }

    public void drawSelectedReach(Graphics graphics, MapScale mapScale, ReachElement reachElement, boolean bl, boolean bl2) {
        double d;
        StreamAlignmentGlyph streamAlignmentGlyph = this.getStreamAlignmentGlyph();
        if (reachElement == null) {
            return;
        }
        RssNode rssNode = ((Element)reachElement).getUpstreamNode();
        RssNode rssNode2 = ((Element)reachElement).getDownstreamNode();
        if (rssNode == null || rssNode2 == null) {
            System.out.println("\nWarning, error in reach " + reachElement.getName() + " connectivity!\n");
            return;
        }
        RssSystemDPReachData rssSystemDPReachData = this._reachDrawDataProvider.getReachDrawData(reachElement);
        StreamElement streamElement = null;
        if (streamAlignmentGlyph != null) {
            streamElement = rssNode.getStream();
        }
        if (streamElement != null) {
            if (rssNode.getStreamStation() == rssNode2.getStreamStation()) {
                System.out.println("RssSystemGlyph.drawReach: Warning, reach" + reachElement.getName() + " has zero length!");
                return;
            }
            d = rssNode.getStreamCoord();
            double d2 = rssNode2.getStreamCoord();
            reachElement = streamElement.getLineSegment(d2, d);
        } else {
            reachElement = new WorldLine();
            ((WorldLine)reachElement).pts.addElement(rssNode.getLocation());
            ((WorldLine)reachElement).pts.addElement(rssNode2.getLocation());
        }
        d = (double)rssSystemDPReachData.reachWidth / 2.0;
        this.drawLine(graphics, (WorldLine)reachElement, mapScale, d, Color.yellow, Color.blue, bl2, Color.black, 3, bl);
        if (bl) {
            graphics.setPaintMode();
        }
    }

    public void getDeleteNode(RssNode rssNode) {
        this._sysmap.deleteNode(rssNode);
    }

    public RssNode createReachNode(LocalPt object, StreamElement streamElement, RssNode rssReturnStatusConstants) {
        if (object == null) {
            return null;
        }
        StreamAlignmentGlyph streamAlignmentGlyph = this.getStreamAlignmentGlyph();
        if (streamAlignmentGlyph == null) {
            return null;
        }
        if ((streamAlignmentGlyph = streamAlignmentGlyph.findReach((LocalPt)object, streamElement)) == null) {
            return null;
        }
        if (streamElement != null && streamAlignmentGlyph != streamElement) {
            return null;
        }
        streamElement = this._mapPanel.scale().lp2wp((LocalPt)object);
        double d = streamAlignmentGlyph.getLine().getCoordAtLocation((WorldPt)streamElement);
        if (d == Double.NEGATIVE_INFINITY) {
            return null;
        }
        if (rssReturnStatusConstants != null && rssReturnStatusConstants.getStreamCoord() <= d) {
            return null;
        }
        RssSystemDPJunctionData rssSystemDPJunctionData = this._junctionDrawDataProvider.getJunctionDrawData(null);
        double d2 = this._mapPanel.scale().x2e(((LocalPt)object).x + (int)((double)rssSystemDPJunctionData.junctionWidth / 2.0)) - this._mapPanel.scale().x2e(((LocalPt)object).x);
        object = this._sysmap.findJunction((WorldPt)streamElement, d2);
        if (object != null) {
            if (rssReturnStatusConstants == null && (rssReturnStatusConstants = ((Element)object).getDownstreamNode()) != null) {
                if (rssReturnStatusConstants.getDownstreamElement() != null) {
                    return null;
                }
                return rssReturnStatusConstants;
            }
            streamElement = ((Element)object).getReferencePt();
            d = streamAlignmentGlyph.getLine().getCoordAtLocation((WorldPt)streamElement);
        }
        rssReturnStatusConstants = null;
        if (object == null && (rssReturnStatusConstants = this.findReservoir((WorldPt)streamElement)) != null) {
            return null;
        }
        if (object == null && rssReturnStatusConstants == null && (object = this._sysmap.findReach(streamAlignmentGlyph.getIndex(), d)) != null) {
            return null;
        }
        object = this._sysmap.createNode(streamAlignmentGlyph.getLocationByCoord(d));
        object.setStreamIndex(streamAlignmentGlyph.getIndex());
        object.setStreamName(streamAlignmentGlyph.getName());
        object.setStreamCoord(d);
        ((RssNode)object).setStreamStation(streamAlignmentGlyph.getStationByCoord(d));
        return object;
    }

    private JunctionElement closestJunction(RssNode rssNode, JunctionElement junctionElement, JunctionElement junctionElement2) {
        WorldPt worldPt;
        if (junctionElement2 == null) {
            return junctionElement;
        }
        rssNode = rssNode.getLocation();
        if (worldPt.distToPoint(junctionElement.getReferencePt()) < rssNode.distToPoint(junctionElement2.getReferencePt())) {
            return junctionElement;
        }
        return junctionElement2;
    }

    RssSystemGlyph$NewJunctionContainer findOrCreateJunctions(RssNode rssNode, RssNode rssNode2) {
        RssSystemGlyph$NewJunctionContainer rssSystemGlyph$NewJunctionContainer = new RssSystemGlyph$NewJunctionContainer();
        LocalPt localPt = this._mapPanel.scale().wp2lp(rssNode.getLocation());
        double d = this._mapPanel.scale().x2e(localPt.x + (int)((double)this.getJunctionData().junctionWidth / 2.0)) - this._mapPanel.scale().x2e(localPt.x);
        localPt = new WorldRect(rssNode.getLocation(), d);
        WorldRect worldRect = new WorldRect(rssNode2.getLocation(), d);
        Vector<JunctionElement> vector = this._sysmap.getElementVectorByClass(JunctionElement.class);
        for (int i = 0; i < vector.size(); ++i) {
            JunctionElement junctionElement = (JunctionElement)vector.get(i);
            if (junctionElement != rssSystemGlyph$NewJunctionContainer.c && localPt.contains(junctionElement.getReferencePt())) {
                rssSystemGlyph$NewJunctionContainer.a = this.closestJunction(rssNode, junctionElement, rssSystemGlyph$NewJunctionContainer.a);
                continue;
            }
            if (junctionElement == rssSystemGlyph$NewJunctionContainer.a || !worldRect.contains(junctionElement.getReferencePt())) continue;
            rssSystemGlyph$NewJunctionContainer.c = this.closestJunction(rssNode2, junctionElement, rssSystemGlyph$NewJunctionContainer.c);
        }
        if (rssSystemGlyph$NewJunctionContainer.a != null && rssSystemGlyph$NewJunctionContainer.c != null) {
            System.out.println("findOrCreateJunctions:found " + String.valueOf(rssSystemGlyph$NewJunctionContainer.a) + " and " + String.valueOf(rssSystemGlyph$NewJunctionContainer.c));
            rssSystemGlyph$NewJunctionContainer.a.addNode(rssNode, 0);
            rssSystemGlyph$NewJunctionContainer.c.addNode(rssNode2, 1);
            RssNode rssNode3 = rssSystemGlyph$NewJunctionContainer.c.getDownstreamNode();
            if (rssNode3 != null && rssNode3.getStreamIndex() != rssNode2.getStreamIndex() && rssNode3.getStreamCoord() < 0.01) {
                rssNode3.setStream(rssNode2.getStream());
                rssNode3.setStreamIndex(rssNode2.getStreamIndex());
                rssNode3.setStreamName(rssNode2.getStreamName());
                rssNode3.setStreamStation(rssNode2.getStreamStation());
                rssNode3.setStreamCoord(rssNode2.getStreamCoord());
            }
        }
        if (rssSystemGlyph$NewJunctionContainer.a == null) {
            WorldPt worldPt = rssNode.getLocation();
            rssSystemGlyph$NewJunctionContainer.a = this.createJunctionElement(worldPt);
            if (rssSystemGlyph$NewJunctionContainer.a == null) {
                rssSystemGlyph$NewJunctionContainer.b = true;
                if (rssSystemGlyph$NewJunctionContainer.c == null) {
                    rssSystemGlyph$NewJunctionContainer.d = true;
                }
                return rssSystemGlyph$NewJunctionContainer;
            }
            double d2 = rssNode2.getStream().getStationByLocation(worldPt);
            rssNode.setStreamStation(d2);
            rssSystemGlyph$NewJunctionContainer.a.addNode(rssNode, 0);
            rssSystemGlyph$NewJunctionContainer.b = true;
        }
        if (rssSystemGlyph$NewJunctionContainer.c == null) {
            WorldPt worldPt = rssNode2.getLocation();
            rssSystemGlyph$NewJunctionContainer.c = this.createJunctionElement(worldPt);
            if (rssSystemGlyph$NewJunctionContainer.c == null) {
                rssSystemGlyph$NewJunctionContainer.d = true;
                return rssSystemGlyph$NewJunctionContainer;
            }
            double d3 = rssNode2.getStream().getStationByLocation(worldPt);
            rssNode2.setStreamStation(d3);
            rssSystemGlyph$NewJunctionContainer.c.addNode(rssNode2, 1);
            rssSystemGlyph$NewJunctionContainer.d = true;
            rssNode = this._sysmap.createNode(rssNode2.getLocation());
            rssNode.setStreamIndex(rssNode2.getStreamIndex());
            rssNode.setStreamName(rssNode2.getStreamName());
            rssNode.setStreamCoord(rssNode2.getStreamCoord());
            rssNode.setStreamStation(rssNode2.getStreamStation());
            rssSystemGlyph$NewJunctionContainer.c.addNode(rssNode, 0);
        }
        return rssSystemGlyph$NewJunctionContainer;
    }

    JunctionElement createJunctionElement(WorldPt worldPt) {
        Object object;
        Object object2;
        StringBuilder stringBuilder;
        int n;
        NameDialog nameDialog;
        Object object3;
        Object object4 = this.getStreamAlignmentGlyph();
        StreamJunction streamJunction = null;
        StreamElement streamElement = null;
        Object object5 = null;
        if (object4 != null) {
            object3 = this._mapPanel.scale((MapGlyph)this).wp2lp(worldPt);
            streamElement = object4.findReach(worldPt);
            nameDialog = this._mapPanel.scale((MapGlyph)this);
            double d = Math.abs(nameDialog.lp2wp((LocalPt)new LocalPt((int)(((LocalPt)object3).x + 5), (int)((LocalPt)object3).y)).e - nameDialog.lp2wp((LocalPt)new LocalPt((int)((LocalPt)object3).x, (int)((LocalPt)object3).y)).e);
            streamJunction = ((StreamAlignment)object4.getMap()).findStreamJunction(streamElement, worldPt, d);
            if (streamJunction != null) {
                object4 = streamJunction.getNodeVector();
                object5 = (StreamNode)((Vector)object4).get(0);
                for (n = 1; n < ((Vector)object4).size(); ++n) {
                    StreamNode streamNode;
                    stringBuilder = (StreamNode)((Vector)object4).get(n);
                    if (!(streamNode.getStreamCoord() > object5.getStreamCoord())) continue;
                    object5 = stringBuilder;
                }
                streamElement = object5.getStream();
            }
        }
        object3 = null;
        nameDialog = new NameDialog((Frame)((JFrame)AppDaddy.getFrame()), true);
        RmaJCheckBox rmaJCheckBox = null;
        if (streamJunction != null) {
            object2 = new JPanel(new GridBagLayout());
            rmaJCheckBox = new RmaJCheckBox("Snap To Stream Junction");
            object4 = streamJunction.getNodeVector();
            stringBuilder = new StringBuilder();
            stringBuilder.append("<html>New Junction will be placed on <b>" + streamElement.getName());
            stringBuilder.append("</b>");
            stringBuilder.append("<br>At the Stream Junction with the following Streams:");
            for (n = 0; n < ((Vector)object4).size(); ++n) {
                object = (StreamNode)((Vector)object4).get(n);
                if ((object = object.getStream()) == null) continue;
                stringBuilder.append("<br>");
                stringBuilder.append(object.getName());
            }
            stringBuilder.append("</html>");
            rmaJCheckBox.setToolTipText(stringBuilder.toString());
            rmaJCheckBox.setSelected(true);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            new GridBagConstraints().gridx = -1;
            gridBagConstraints.gridy = -1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = RmaInsets.INSETS5505;
            ((Container)object2).add((Component)rmaJCheckBox, gridBagConstraints);
            nameDialog.addAuxilaryPanel((JPanel)object2);
        }
        nameDialog.setNameFieldDocument((Document)new DssPathnamePartDocument());
        nameDialog.setName(this._sysmap.getNextDefaultName(2));
        nameDialog.setDescription("");
        nameDialog.setTitle("Name New Junction");
        nameDialog.setExistingNames((List)this._sysmap.getElementVector());
        nameDialog.setVisible(true);
        if (!nameDialog.isCanceled()) {
            object2 = nameDialog.getName();
            object4 = nameDialog.getDescription();
            object3 = this._sysmap.newJunctionElement((String)object2);
            if (object3 != null) {
                object3.setDescription((String)object4);
            }
            if (object5 != null) {
                streamElement.getStationByLocation(object5.getLocation());
                object = this._sysmap.createNode(object5.getLocation());
                object.setStream(streamElement);
                ((Element)object3).addNode((RssNode)object, 0);
            }
            if (rmaJCheckBox != null && rmaJCheckBox.isSelected()) {
                worldPt.init(streamJunction.getLocation());
                ((JunctionElement)object3).setStreamJunctionId(streamJunction.getIndex());
            }
            if (streamElement != null) {
                double d = streamElement.getStationByLocation(worldPt);
                ((JunctionElement)object3).setStreamStation(streamElement, d);
            }
        }
        return object3;
    }

    public void createReach(RssNode rssReturnStatusConstants, RssNode rssNode, LocalPt object) {
        if (this._sysmap == null || rssReturnStatusConstants == null || rssNode == null) {
            return;
        }
        object = this.findOrCreateJunctions((RssNode)rssReturnStatusConstants, rssNode);
        if (object.a == null || object.c == null) {
            if (object.b) {
                this._sysmap.deleteNode((RssNode)rssReturnStatusConstants);
                if (object.a != null) {
                    this._sysmap.deleteJunction(object.a.getName());
                }
            }
            if (object.d) {
                this._sysmap.deleteNode(rssNode);
                if (object.c != null) {
                    this._sysmap.deleteJunction(object.c.getName());
                }
            }
            return;
        }
        NameDialog nameDialog = new NameDialog((Frame)((JFrame)AppDaddy.getFrame()), true);
        nameDialog.setNameFieldDocument((Document)new DssPathnamePartDocument());
        nameDialog.setName(object.a.getName() + " to " + object.c.getName());
        nameDialog.setDescription("");
        nameDialog.setTitle("Name New Reach");
        nameDialog.setExistingNames((List)this._sysmap.getElementVector());
        nameDialog.setVisible(true);
        if (nameDialog.isCanceled()) {
            if (object.b) {
                this._sysmap.deleteNode((RssNode)rssReturnStatusConstants);
                this._sysmap.deleteJunction(object.a.getName());
            }
            if (object.d) {
                this._sysmap.deleteNode(rssNode);
                this._sysmap.deleteJunction(object.c.getName());
            }
            return;
        }
        String string = nameDialog.getName();
        if ((rssReturnStatusConstants = this._sysmap.createReach(object.a, object.c, (RssNode)rssReturnStatusConstants, rssNode, string)) == null) {
            return;
        }
        rssReturnStatusConstants.setDescription(nameDialog.getDescription());
        RssSystemGlyph rssSystemGlyph = this;
        rssSystemGlyph.drawReach(rssSystemGlyph._mapPanel.viewport().getBufferedGraphics(), this._mapPanel.scale(), (ReachElement)rssReturnStatusConstants);
        RssSystemGlyph rssSystemGlyph2 = this;
        rssSystemGlyph2.drawJunction(rssSystemGlyph2._mapPanel.viewport().getBufferedGraphics(), this._mapPanel.scale(), object.a);
        RssSystemGlyph rssSystemGlyph3 = this;
        rssSystemGlyph3.drawJunction(rssSystemGlyph3._mapPanel.viewport().getBufferedGraphics(), this._mapPanel.scale(), object.c);
        this._mapPanel.paintImage();
    }

    public RssNode findDownstreamNode(StreamElement streamElement, double d) {
        return this._sysmap.findDownstreamNode(streamElement.getIndex(), d);
    }

    public RssNode findUpstreamNode(StreamElement streamElement, double d) {
        return this._sysmap.findUpstreamNode(streamElement.getIndex(), d);
    }

    public void drawArrow(Graphics graphics, MapScale mapScale, WorldPt worldPt, WorldPt worldPt2) {
        worldPt2 = new WorldPt(worldPt2);
        worldPt2.n = -worldPt2.n;
        int n = mapScale.e2x(worldPt.e);
        int n2 = mapScale.n2y(worldPt.n);
        int n3 = n + (int)(-1.0 * worldPt2.n * 10.0 - worldPt2.e * 20.0 / 2.0);
        int n4 = n2 + (int)(1.0 * worldPt2.e * 10.0 - worldPt2.n * 20.0 / 2.0);
        graphics.drawLine(n3, n4, n += (int)(-1.0 * worldPt2.n * 10.0 + worldPt2.e * 20.0 / 2.0), n2 += (int)(1.0 * worldPt2.e * 10.0 + worldPt2.n * 20.0 / 2.0));
        n = n3 - (int)(-worldPt2.n * 3.0 - worldPt2.e * 5.0);
        n2 = n4 - (int)(worldPt2.e * 3.0 - worldPt2.n * 5.0);
        graphics.drawLine(n3, n4, n, n2);
        n = n3 - (int)(worldPt2.n * 3.0 - worldPt2.e * 5.0);
        n2 = n4 - (int)(-worldPt2.e * 3.0 - worldPt2.n * 5.0);
        graphics.drawLine(n3, n4, n, n2);
    }

    public void drawEndArrow(Graphics graphics, MapScale mapScale, WorldPt worldPt, WorldPt worldPt2, boolean bl, boolean bl2) {
        double d = (double)this._diversionData.diversionWidth * 2.5;
        double d2 = this._diversionData.diversionWidth;
        worldPt2 = new WorldPt(worldPt2);
        worldPt2.n = -worldPt2.n;
        int n = mapScale.e2x(worldPt.e);
        int n2 = mapScale.n2y(worldPt.n);
        Polygon polygon = new Polygon();
        if (bl2) {
            graphics.setColor(this._diversionData.conColor);
        } else if (bl) {
            graphics.setColor(Color.yellow);
        }
        int n3 = n + (int)(-worldPt2.n * d2 - worldPt2.e * d);
        int n4 = n2 + (int)(worldPt2.e * d2 - worldPt2.n * d);
        polygon.addPoint(n3, n4);
        polygon.addPoint(n, n2);
        n3 = n + (int)(worldPt2.n * d2 - worldPt2.e * d);
        n4 = n2 + (int)(-worldPt2.e * d2 - worldPt2.n * d);
        polygon.addPoint(n3, n4);
        graphics.fillPolygon(polygon);
        if (bl2 && bl) {
            graphics.setColor(this._diversionData.outlineColor);
        } else if (bl2) {
            graphics.setColor(this._diversionData.outlineColor);
        } else {
            graphics.setColor(this._diversionData.disConColor);
        }
        graphics.drawPolygon(polygon);
    }

    @Deprecated
    public RssNode createReservoirNode(LocalPt object, StreamElement streamElement, Vector object2) {
        if (object == null) {
            return null;
        }
        streamElement = this.getStreamAlignmentGlyph();
        if (streamElement == null) {
            return null;
        }
        if ((streamElement = streamElement.findReach((LocalPt)object, null)) == null) {
            return null;
        }
        if (object2 != null) {
            for (int i = 0; i < ((Vector)object2).size(); ++i) {
                RssNode cfr_ignored_0 = (RssNode)((Vector)object2).elementAt(i);
            }
        }
        WorldPt worldPt = this._mapPanel.scale().lp2wp((LocalPt)object);
        double d = streamElement.getLine().getCoordAtLocation(worldPt);
        if (d == Double.NEGATIVE_INFINITY) {
            return null;
        }
        RssSystemDPJunctionData rssSystemDPJunctionData = this.getJunctionData();
        double d2 = this._mapPanel.scale().x2e(((LocalPt)object).x + (int)((double)rssSystemDPJunctionData.junctionWidth / 2.0)) - this._mapPanel.scale().x2e(((LocalPt)object).x);
        object = this._sysmap.findJunction(worldPt, d2);
        if (object != null) {
            if (object2 != null && (object2 = ((Element)object).getDownstreamNode()) != null) {
                if (((RssNode)object2).getDownstreamElement() != null) {
                    return null;
                }
                return object2;
            }
            worldPt = ((Element)object).getReferencePt();
            d = streamElement.getLine().getCoordAtLocation(worldPt);
        }
        object2 = null;
        if (object == null && (object2 = this.findReservoir(worldPt)) != null) {
            return null;
        }
        if (object == null && object2 == null && (object = this._sysmap.findReach(streamElement.getIndex(), d)) != null) {
            return null;
        }
        object = this._sysmap.createNode(streamElement.getLocationByCoord(d));
        object.setStreamIndex(streamElement.getIndex());
        object.setStreamName(streamElement.getName());
        object.setStreamCoord(d);
        ((RssNode)object).setStreamStation(streamElement.getStationByCoord(d));
        return object;
    }

    public void drawConformingString(Graphics graphics, MapScale mapScale, WorldLine worldLine, String string, double d) {
        int n;
        double d2;
        double d3;
        double d4;
        double d5;
        WorldPt worldPt;
        double d6;
        if (d < 0.0 || d > 1.0) {
            return;
        }
        double d7 = worldLine.getLength();
        Object object = (WorldPt)worldLine.pts.elementAt(0);
        double d8 = mapScale.e2x(object.e + d7) - mapScale.e2x(object.e);
        double d9 = d8 / d7;
        double d10 = 1.0 / d8;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = fontMetrics.getHeight();
        int n3 = fontMetrics.getAscent();
        fontMetrics.getMaxAdvance();
        int n4 = string.length();
        double d11 = (double)(n4 * n2) * d10;
        double d12 = (double)n2 / d9 / 2.0;
        double d13 = (double)n2 * d10 / 2.0;
        double d14 = d12 * 2.0;
        WorldLine worldLine2 = new WorldLine();
        double d15 = d - d11 / 2.0;
        double d16 = d + d11 / 2.0;
        object = new WorldPt();
        WorldPt worldPt2 = new WorldPt();
        worldLine.getSlopeAtCoord(d, object, worldPt2);
        object = new WorldPt(object.e - d14 * 1.0 * worldPt2.n, object.n + d14 * 1.0 * worldPt2.e);
        worldLine2.pts.addElement(object);
        WorldPt worldPt3 = object;
        WorldPt worldPt4 = worldPt2;
        WorldPt worldPt5 = new WorldPt();
        for (d6 = d - d13; d6 >= d15; d6 -= d13) {
            worldPt = worldPt3;
            worldPt3 = worldPt4;
            worldPt3 = new WorldPt(worldPt.e - worldPt3.e * d12, worldPt.n - worldPt3.n * d12);
            d5 = worldLine.getNearestLocation(worldPt3, worldPt5);
            d4 = worldPt3.e - worldPt5.e;
            d3 = worldPt3.n - worldPt5.n;
            worldPt3.init(worldPt5.e + d4 * d14 / d5, worldPt5.n + d3 * d14 / d5);
            worldLine2.pts.insertElementAt(worldPt3, 0);
            d2 = worldLine.getCoordAtLocation(worldPt5);
            worldPt4 = new WorldPt();
            worldLine.getSlopeAtCoord(d2, worldPt5, worldPt4);
        }
        worldPt3 = object;
        worldPt4 = worldPt2;
        for (d6 = d + d13; d6 <= d16; d6 += d13) {
            worldPt = worldPt3;
            worldPt3 = worldPt4;
            worldPt3 = new WorldPt(worldPt.e + worldPt3.e * d12, worldPt.n + worldPt3.n * d12);
            d5 = worldLine.getNearestLocation(worldPt3, worldPt5);
            d4 = worldPt3.e - worldPt5.e;
            d3 = worldPt3.n - worldPt5.n;
            worldPt3.init(worldPt5.e + d4 * d14 / d5, worldPt5.n + d3 * d14 / d5);
            worldLine2.pts.addElement(worldPt3);
            d2 = worldLine.getCoordAtLocation(worldPt5);
            worldPt4 = new WorldPt();
            worldLine.getSlopeAtCoord(d2, worldPt5, worldPt4);
        }
        Color color = this._mapPanel.viewport().getBackground();
        Color color2 = graphics.getColor();
        object = new char[n4 + 1];
        string.getChars(0, n4, (char[])object, 0);
        double cfr_ignored_0 = 1.0 / (double)n4;
        int n5 = 1;
        if (worldLine2.getFirstPt().e > worldLine2.getLastPt().e) {
            n5 = -1;
        }
        worldPt3 = new WorldPt();
        worldPt4 = new WorldPt();
        double d17 = 1.0 / (worldLine2.getLength() * d9);
        d6 = 0.0;
        if (n5 < 0) {
            d6 = 1.0;
        }
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n4];
        for (n = 0; n < n4; ++n) {
            worldLine2.getSlopeAtCoord(d6, worldPt3, worldPt4);
            nArray[n] = mapScale.e2x(worldPt3.e);
            nArray2[n] = mapScale.n2y(worldPt3.n);
            int n6 = fontMetrics.charWidth((char)object[n]) + 1;
            if (Math.abs(worldPt4.n) / Math.abs(worldPt4.e) >= (double)n2 / (double)n6) {
                d6 += (double)(n5 * n3) * d17;
                continue;
            }
            d6 += (double)n5 * (double)n6 / Math.abs(worldPt4.e) * d17;
        }
        d6 = 0.5;
        worldLine2.getSlopeAtCoord(0.5, worldPt3, worldPt4);
        for (n = n4 / 2 - 1; n >= 0; --n) {
            int n7 = fontMetrics.charWidth((char)object[n]) + 1;
            d6 = Math.abs(worldPt4.n) / Math.abs(worldPt4.e) >= (double)n2 / (double)n7 ? (d6 -= (double)(n5 * n3) * d17) : (d6 -= (double)n5 * (double)n7 / Math.abs(worldPt4.e) * d17);
            worldLine2.getSlopeAtCoord(d6, worldPt3, worldPt4);
            nArray[n] = mapScale.e2x(worldPt3.e);
            nArray2[n] = mapScale.n2y(worldPt3.n);
        }
        d6 = 0.5;
        for (n = n4 / 2; n < n4; ++n) {
            worldLine2.getSlopeAtCoord(d6, worldPt3, worldPt4);
            nArray[n] = mapScale.e2x(worldPt3.e);
            nArray2[n] = mapScale.n2y(worldPt3.n);
            int n8 = fontMetrics.charWidth((char)object[n]);
            if (Math.abs(worldPt4.n) / Math.abs(worldPt4.e) >= (double)n2 / (double)n8) {
                d6 += (double)(n5 * n3) * d17;
                continue;
            }
            d6 += (double)n5 * (double)n8 / Math.abs(worldPt4.e) * d17;
        }
        graphics.setColor(color);
        for (n = 0; n < n4; ++n) {
            int n9 = fontMetrics.charWidth((char)object[n]) + 1;
            graphics.fillRect(nArray[n], nArray2[n] - n3, n9, n2);
        }
        graphics.setColor(color2);
        for (n = 0; n < n4; ++n) {
            graphics.drawChars((char[])object, n, 1, nArray[n], nArray2[n]);
        }
    }

    @Override
    public void setDiversionData(RssSystemDPDiversionData rssSystemDPDiversionData) {
        this._diversionData = rssSystemDPDiversionData;
    }

    private RssSystemDPReachData getReachDataForCurrentScale() {
        int n = (int)this._mapPanel.viewport().computeMapScale();
        return RssSystemDPReachData.d(n);
    }

    private RssSystemDPJunctionData getJunctionDataForCurrentScale() {
        int n = (int)this._mapPanel.viewport().computeMapScale();
        return RssSystemDPJunctionData.d(n);
    }

    @Override
    public RssSystemDPJunctionData getJunctionData() {
        return this._junctionDrawDataProvider.getJunctionDrawData(null);
    }

    public RssSystemDPReservoirData getReservoirData() {
        return this._reservoirDrawDataProvider.getReservoirDrawData(null);
    }

    private RssSystemDPReservoirData getReservoirDataForCurrentScale() {
        int n = (int)this._mapPanel.viewport().computeMapScale();
        return RssSystemDPReservoirData.d(n);
    }

    @Override
    public RssSystemDPDiversionData getDiversionData() {
        if (this._diversionData == null) {
            this._diversionData = this.getDiversionDataForCurrentScale();
        }
        return this._diversionData;
    }

    private RssSystemDPDiversionData getDiversionDataForCurrentScale() {
        int n = (int)this._mapPanel.viewport().computeMapScale();
        return RssSystemDPDiversionData.d(n);
    }

    public JunctionElement moveJunction(JunctionElement object, WorldPt object2, StreamElement object3, double d, double d2) {
        Object object4;
        if (this._sysmap == null || object == null) {
            return object;
        }
        LocalPt localPt = this._mapPanel.scale((MapGlyph)this).wp2lp((WorldPt)object2);
        double d3 = this._mapPanel.scale((MapGlyph)this).x2e(localPt.x + 8) - this._mapPanel.scale((MapGlyph)this).x2e(localPt.x);
        if ((object2 = this._sysmap.findJunction((WorldPt)object2, d3)) == null || object2 == object) {
            int n;
            object4 = this.getStreamAlignmentGlyph();
            localPt = object4.findStreamJunction(object3, localPt);
            if (localPt != null && (n = JOptionPane.showConfirmDialog((Component)ClientApp.frame(), "Snap Junction " + object.getName() + " to Stream Junction?", "Snap Junction", 0)) == 0) {
                d2 = object3.getStationByLocation(localPt.getLocation());
                ((JunctionElement)object).setStreamJunctionId(localPt.getIndex());
            }
            ((JunctionElement)object).setStreamStation((StreamElement)object3, d2);
            this._sysmap.setModified(true);
        } else {
            int n = JOptionPane.showConfirmDialog((Component)this._mapPanel, "Connect Junctions " + object.getName() + " and " + object2.getName() + "?", "Connect?", 0, 3);
            if (n == 0) {
                this._selectionList.clear();
                localPt = new MapGlyph.Selection((MapGlyph)this, object2, true);
                this._selectionList.add((MapGlyph.Selection)localPt);
                ((JunctionElement)object).setStreamStation((StreamElement)object3, d2);
                ((JunctionElement)object2).addJunction((JunctionElement)object);
                ((JunctionElement)object2).setStreamStation((StreamElement)object3, d2);
                object = object2;
                this._sysmap.setModified(true);
            }
        }
        object4 = ((JunctionElement)object).getConnectedElements();
        int n = ((Vector)object4).size();
        for (int i = 0; i < n; ++i) {
            object3 = (Element)((Vector)object4).elementAt(i);
            if (!(object3 instanceof ReservoirElement)) continue;
            ((ReservoirElement)object3).updateSegments();
        }
        return object;
    }

    public void createDivertedOutlet(RssNode rssReturnStatusConstants, RssNode rssNode, Vector vector, int n, ReservoirElement reservoirElement) {
        if (this._sysmap == null || vector == null) {
            return;
        }
        if (vector.size() <= 0) {
            return;
        }
        String string = reservoirElement.getNextDivertedOutletName();
        if ((rssReturnStatusConstants = reservoirElement.createDivertedOutlet((RssNode)rssReturnStatusConstants, rssNode, vector, 0.0)) != null) {
            ((Element)rssReturnStatusConstants).setName(string);
            RssSystemGlyph rssSystemGlyph = this;
            rssSystemGlyph.drawDivertedOutlet(rssSystemGlyph._mapPanel.viewport().getBufferedGraphics(), this._mapPanel.scale(), (DivertedOutletElement)rssReturnStatusConstants);
            this._mapPanel.paintImage();
            return;
        }
        this._mapPanel.paintMap();
    }

    public void createDiversion(RssNode rssNode, RssNode rssNode2, Vector vector, int n) {
        if (this._sysmap == null || vector == null) {
            return;
        }
        if (vector.size() <= 0) {
            return;
        }
        DiversionElement diversionElement = null;
        Object object = new NameDialog((Frame)((JFrame)AppDaddy.getFrame()), true);
        object.setNameFieldDocument((Document)new DssPathnamePartDocument());
        object.setName(this._sysmap.getNextDefaultName(3));
        object.setDescription("");
        object.setTitle("Name New Diversion");
        object.setExistingNames((List)this._sysmap.getElementVector());
        object.setVisible(true);
        if (object.isCanceled()) {
            this._sysmap.deleteNode(rssNode);
            if (rssNode2 != null) {
                this._sysmap.deleteNode(rssNode2);
            }
        } else {
            String string = object.getName();
            object = object.getDescription();
            diversionElement = this._sysmap.createDiversion(rssNode, rssNode2, vector, 0.0);
            diversionElement.setInflowType(n);
            diversionElement.setName(string);
            diversionElement.setDescription((String)object);
        }
        if (diversionElement != null) {
            RssSystemGlyph rssSystemGlyph = this;
            rssSystemGlyph.drawDiversion(rssSystemGlyph._mapPanel.viewport().getBufferedGraphics(), this._mapPanel.scale(), diversionElement);
            this._mapPanel.paintImage();
            return;
        }
        this._mapPanel.paintMap();
    }

    public void connectDivertedOutletElement(DivertedOutletElement divertedOutletElement, LocalPt localPt) {
    }

    public void connectDiversionElement(DiversionElement diversionElement, LocalPt localPt) {
    }

    public DivertedOutletElement findDivertedOutlet(WorldPt object, double d) {
        object = this._sysmap.findDivertedOutlet((WorldPt)object, d);
        return object;
    }

    public DiversionElement findDiversion(WorldPt object, double d) {
        object = this._sysmap.findDiversion((WorldPt)object, d);
        return object;
    }

    public DivertedOutletElement selectDivertedOutlet(LocalPt object, boolean bl, boolean bl2) {
        double d;
        if (!bl) {
            this._selectionList.clear();
        }
        if (this._sysmap == null || object == null) {
            return null;
        }
        WorldPt worldPt = this._mapPanel.scale().lp2wp(object);
        object = this.findDivertedOutlet(worldPt, d = this._mapPanel.scale().x2e(object.x + 5) - this._mapPanel.scale().x2e(object.x));
        if (object != null) {
            worldPt = new MapGlyph.Selection((MapGlyph)this, object, bl2);
            if (!this._selectionList.contains(worldPt)) {
                this._selectionList.add((MapGlyph.Selection)worldPt);
            }
            if (bl) {
                Graphics graphics = this._mapPanel.viewport().getGraphics();
                this.drawSelectedDivertedOutlet(graphics, this._mapPanel.scale(), (DivertedOutletElement)object, false, bl2);
                graphics.dispose();
            } else {
                this._mapPanel.paintMap();
            }
        } else if (!bl) {
            this._mapPanel.paintMap();
        }
        return object;
    }

    public void drawSelectedDivertedOutlet(Graphics graphics, MapScale mapScale, DivertedOutletElement divertedOutletElement, boolean bl, boolean bl2) {
        if (divertedOutletElement == null) {
            return;
        }
        WorldLine worldLine = divertedOutletElement.getLine();
        Object object = divertedOutletElement.getTailNode();
        RssNode rssNode = ((Element)divertedOutletElement).getDownstreamNode();
        if (object == null) {
            return;
        }
        if (this._diversionData == null) {
            this.getDiversionData();
        }
        if (worldLine != null) {
            double worldPt = (double)this._diversionData.diversionWidth / 1.5;
            if (object != null) {
                worldLine.getFirstPt().init(((RssNode)object).getLocation());
            }
            if (rssNode != null && rssNode.getStream() != null) {
                worldLine.getLastPt().init(rssNode.getLocation());
            }
            object = new int[worldLine.pts.size() << 1];
            int[] nArray = new int[worldLine.pts.size() << 1];
            int n = worldLine.getLocalRegionArrays(mapScale, (int[])object, nArray, worldPt);
            if (bl) {
                graphics.setXORMode(XOR_COLOR);
            } else {
                graphics.setColor(Color.yellow);
            }
            if (n > 0) {
                graphics.setColor(Color.yellow);
                graphics.fillPolygon((int[])object, nArray, n);
                graphics.setColor(Color.yellow);
                graphics.drawPolygon((int[])object, nArray, n);
                if (this._diversionData.drawName) {
                    this.drawConformingString(graphics, mapScale, divertedOutletElement.getLine(), divertedOutletElement.getName(), 0.5, (int)worldPt, this._diversionData.nameFont, this._diversionData.fillColor, 1, this._glyphLevel + 0.35f);
                }
            }
            object = new int[4];
            nArray = new int[4];
            if (bl2) {
                graphics.setColor(Color.black);
                int n2 = (int)((double)this._diversionData.diversionWidth / 1.5);
                for (n = 0; n < worldLine.pts.size(); ++n) {
                    divertedOutletElement = (WorldPt)worldLine.pts.elementAt(n);
                    divertedOutletElement = this._mapPanel.scale().wp2lp((WorldPt)divertedOutletElement);
                    object[0] = ((LocalPt)divertedOutletElement).x - n2;
                    nArray[0] = ((LocalPt)divertedOutletElement).y;
                    object[1] = ((LocalPt)divertedOutletElement).x;
                    nArray[1] = ((LocalPt)divertedOutletElement).y + n2;
                    object[2] = ((LocalPt)divertedOutletElement).x + n2;
                    nArray[2] = ((LocalPt)divertedOutletElement).y;
                    object[3] = ((LocalPt)divertedOutletElement).x;
                    nArray[3] = ((LocalPt)divertedOutletElement).y - n2;
                    graphics.fillPolygon((int[])object, nArray, 4);
                }
            }
        }
        WorldPt worldPt = new WorldPt();
        WorldPt worldPt2 = new WorldPt();
        worldLine.getSlopeAtCoord(1.0, worldPt, worldPt2);
        if (rssNode != null && rssNode.getStream() != null) {
            this.drawEndArrow(graphics, mapScale, worldLine.getLastPt(), worldPt2, true, true);
        } else {
            this.drawEndArrow(graphics, mapScale, worldLine.getLastPt(), worldPt2, true, false);
        }
        if (bl) {
            graphics.setPaintMode();
        }
    }

    public NamedType getSelectedObject() {
        if (this._selectionList == null || this._selectionList.isEmpty()) {
            return null;
        }
        MapGlyph.Selection selection = this._selectionList.get(0);
        return (NamedType)selection.object;
    }

    public DiversionElement selectDiversion(LocalPt object, boolean bl, boolean bl2) {
        double d;
        if (!bl) {
            this._selectionList.clear();
        }
        if (this._sysmap == null || object == null) {
            return null;
        }
        WorldPt worldPt = this._mapPanel.scale().lp2wp(object);
        object = this.findDiversion(worldPt, d = this._mapPanel.scale().x2e(object.x + 5) - this._mapPanel.scale().x2e(object.x));
        if (object != null) {
            worldPt = new MapGlyph.Selection((MapGlyph)this, object, bl2);
            if (!this._selectionList.contains(worldPt)) {
                this._selectionList.add((MapGlyph.Selection)worldPt);
            }
            if (bl) {
                Graphics graphics = this._mapPanel.viewport().getGraphics();
                this.drawSelectedDiversion(graphics, this._mapPanel.scale(), (DiversionElement)object, false, bl2);
                graphics.dispose();
            } else {
                this._mapPanel.paintMap();
            }
        } else if (!bl) {
            this._mapPanel.paintMap();
        }
        return object;
    }

    public void drawSelectedDiversion(Graphics graphics, MapScale mapScale, DiversionElement diversionElement, boolean bl, boolean bl2) {
        if (diversionElement == null) {
            return;
        }
        if (this._diversionData == null) {
            this.getDiversionData();
        }
        if (this._diversionData.diversionWidth <= 0) {
            return;
        }
        WorldLine worldLine = diversionElement.getLine();
        Object object = ((Element)diversionElement).getUpstreamNode();
        RssNode rssNode = ((Element)diversionElement).getDownstreamNode();
        if (object == null) {
            return;
        }
        if (worldLine != null) {
            double worldPt = (double)this._diversionData.diversionWidth / 1.5;
            if (object != null) {
                worldLine.getFirstPt().init(((RssNode)object).getLocation());
            }
            if (rssNode != null) {
                worldLine.getLastPt().init(rssNode.getLocation());
            }
            object = new int[worldLine.pts.size() << 1];
            int[] nArray = new int[worldLine.pts.size() << 1];
            int n = worldLine.getLocalRegionArrays(mapScale, (int[])object, nArray, worldPt);
            if (bl) {
                graphics.setXORMode(XOR_COLOR);
            } else {
                graphics.setColor(diversionElement.getLineColor());
            }
            if (n > 0) {
                graphics.setColor(Color.yellow);
                graphics.fillPolygon((int[])object, nArray, n);
                graphics.setColor(Color.yellow);
                graphics.drawPolygon((int[])object, nArray, n);
                if (this._diversionData.drawName) {
                    this.drawConformingString(graphics, mapScale, diversionElement.getLine(), diversionElement.getName(), 0.5, (int)worldPt, this._diversionData.nameFont, this._diversionData.fillColor, 1, this._glyphLevel + 0.35f);
                }
            }
            object = new int[4];
            nArray = new int[4];
            if (bl2) {
                graphics.setColor(Color.black);
                int n2 = (int)((double)this._diversionData.diversionWidth / 1.5);
                for (n = 0; n < worldLine.pts.size(); ++n) {
                    diversionElement = (WorldPt)worldLine.pts.elementAt(n);
                    diversionElement = this._mapPanel.scale().wp2lp((WorldPt)diversionElement);
                    object[0] = ((LocalPt)diversionElement).x - n2;
                    nArray[0] = ((LocalPt)diversionElement).y;
                    object[1] = ((LocalPt)diversionElement).x;
                    nArray[1] = ((LocalPt)diversionElement).y + n2;
                    object[2] = ((LocalPt)diversionElement).x + n2;
                    nArray[2] = ((LocalPt)diversionElement).y;
                    object[3] = ((LocalPt)diversionElement).x;
                    nArray[3] = ((LocalPt)diversionElement).y - n2;
                    graphics.fillPolygon((int[])object, nArray, 4);
                }
            }
        }
        WorldPt worldPt = new WorldPt();
        WorldPt worldPt2 = new WorldPt();
        worldLine.getSlopeAtCoord(1.0, worldPt, worldPt2);
        this.drawEndArrow(graphics, mapScale, worldLine.getLastPt(), worldPt2, true, rssNode != null);
        if (bl) {
            graphics.setPaintMode();
        }
    }

    public void drawDivertedOutlet(Graphics graphics, MapScale mapScale, DivertedOutletElement divertedOutletElement) {
        int[] nArray;
        int n;
        Object object = divertedOutletElement.getTailNode();
        RssNode rssNode = ((Element)divertedOutletElement).getDownstreamNode();
        if (this._diversionData == null) {
            this.getDiversionData();
        }
        WorldLine worldLine = divertedOutletElement.getLine();
        double d = (double)this._diversionData.diversionWidth / 1.5;
        if (object != null) {
            worldLine.getFirstPt().init(((RssNode)object).getLocation());
        }
        if (rssNode != null && rssNode.getStream() != null) {
            worldLine.getLastPt().init(rssNode.getLocation());
        }
        if ((n = worldLine.getLocalRegionArrays(mapScale, (int[])(object = (Object)new int[worldLine.pts.size() << 1]), nArray = new int[worldLine.pts.size() << 1], d)) > 0) {
            graphics.setPaintMode();
            graphics.setColor(Color.blue.darker());
            graphics.fillPolygon((int[])object, nArray, n);
            if (this._diversionData.drawName) {
                this.drawConformingString(graphics, mapScale, divertedOutletElement.getLine(), divertedOutletElement.getName(), 0.5, (int)d, this._diversionData.nameFont, this._diversionData.fillColor, 1, this._glyphLevel + 0.35f);
            }
        }
        divertedOutletElement = new WorldPt();
        object = new WorldPt();
        worldLine.getSlopeAtCoord(1.0, (WorldPt)divertedOutletElement, (WorldPt)object);
        if (rssNode != null && rssNode.getStream() != null) {
            graphics.setColor(this._diversionData.conColor);
        } else {
            graphics.setColor(this._diversionData.disConColor);
        }
        this.drawEndArrow(graphics, mapScale, worldLine.getLastPt(), (WorldPt)object, false, rssNode != null);
    }

    public void drawDiversion(Graphics graphics, MapScale mapScale, DiversionElement diversionElement) {
        String string;
        Color color;
        int[] nArray;
        int[] nArray2;
        int n;
        RssNode rssNode = ((Element)diversionElement).getUpstreamNode();
        RssNode rssNode2 = ((Element)diversionElement).getDownstreamNode();
        if (this._diversionData == null) {
            this.getDiversionData();
        }
        if (this._diversionData.diversionWidth <= 0) {
            return;
        }
        WorldLine worldLine = diversionElement.getLine();
        double d = (double)this._diversionData.diversionWidth / 1.5;
        if (rssNode != null) {
            worldLine.getFirstPt().init(rssNode.getLocation());
        }
        if (rssNode2 != null) {
            worldLine.getLastPt().init(rssNode2.getLocation());
        }
        if ((n = worldLine.getLocalRegionArrays(mapScale, nArray2 = new int[worldLine.pts.size() << 1], nArray = new int[worldLine.pts.size() << 1], d)) > 0) {
            graphics.setPaintMode();
            color = this._diversionData.fillColor;
            string = diversionElement.getFillColorName();
            if (string != null && (color = RmaColor.parseColorString((String)string)) == null) {
                color = this._diversionData.fillColor;
            }
            graphics.setColor(color);
            graphics.fillPolygon(nArray2, nArray, n);
            if (this._diversionData.drawName) {
                this.drawConformingString(graphics, mapScale, diversionElement.getLine(), diversionElement.getName(), 0.5, (int)d, this._diversionData.nameFont, this._diversionData.fillColor, 1, this._glyphLevel + 0.35f);
            }
        }
        rssNode.getLocation();
        color = new WorldPt();
        string = new WorldPt();
        worldLine.getSlopeAtCoord(1.0, (WorldPt)color, (WorldPt)string);
        if (rssNode2 != null) {
            graphics.setColor(this._diversionData.conColor);
        } else {
            graphics.setColor(this._diversionData.disConColor);
        }
        this.drawEndArrow(graphics, mapScale, worldLine.getLastPt(), (WorldPt)string, false, rssNode2 != null);
    }

    public RssNode createDiversionNode(LocalPt object, RssNode rssNode) {
        rssNode = this._mapPanel.scale().lp2wp((LocalPt)object);
        StreamAlignmentGlyph streamAlignmentGlyph = this.getStreamAlignmentGlyph();
        if (streamAlignmentGlyph == null) {
            return null;
        }
        if ((streamAlignmentGlyph = streamAlignmentGlyph.findReach((LocalPt)object, null)) == null) {
            return null;
        }
        double d = streamAlignmentGlyph.getLine().getCoordAtLocation((WorldPt)rssNode);
        if (d == Double.NEGATIVE_INFINITY) {
            return null;
        }
        Object object2 = this.getJunctionData();
        double d2 = this._mapPanel.scale().x2e(((LocalPt)object).x + (int)((double)((RssSystemDPJunctionData)object2).junctionWidth / 2.0)) - this._mapPanel.scale().x2e(((LocalPt)object).x);
        object2 = this._sysmap.findJunction((WorldPt)rssNode, d2);
        if (object2 != null) {
            RssNode rssNode2 = ((Element)object2).getDownstreamNode();
            if (rssNode2 != null) {
                object = this._sysmap.createNode((WorldPt)rssNode);
                object.setLocation(rssNode2.getLocation());
                ((RssNode)object).setStreamStation(rssNode2.getStreamStation());
                object.setStream(rssNode2.getStream());
                object.setStreamCoord(rssNode2.getStreamCoord());
                ((Element)object2).addNode((RssNode)object, 1);
                return object;
            }
            rssNode = ((Element)object2).getReferencePt();
            streamAlignmentGlyph.getLine().getCoordAtLocation((WorldPt)rssNode);
        }
        return null;
    }

    public RssNode createDivOutletNode(LocalPt object, RssNode rssReturnStatusConstants) {
        WorldPt worldPt = this._mapPanel.scale().lp2wp((LocalPt)object);
        ReservoirElement reservoirElement = null;
        StreamAlignmentGlyph streamAlignmentGlyph = this.getStreamAlignmentGlyph();
        if (streamAlignmentGlyph == null) {
            return null;
        }
        if ((streamAlignmentGlyph = streamAlignmentGlyph.findReach((LocalPt)object, null)) == null) {
            return null;
        }
        double d = streamAlignmentGlyph.getLine().getCoordAtLocation(worldPt);
        if (d == Double.NEGATIVE_INFINITY) {
            return null;
        }
        double d2 = this._mapPanel.scale().x2e(((LocalPt)object).x + (int)((double)this.getJunctionData().junctionWidth / 2.0)) - this._mapPanel.scale().x2e(((LocalPt)object).x);
        if (rssReturnStatusConstants != null) {
            rssReturnStatusConstants = this._sysmap.findJunction(worldPt, d2);
            if (rssReturnStatusConstants != null) {
                RssNode rssNode = ((Element)rssReturnStatusConstants).getDownstreamNode();
                if (rssNode != null) {
                    object = this._sysmap.createNode(worldPt);
                    object.setLocation(rssNode.getLocation());
                    ((RssNode)object).setStreamStation(rssNode.getStreamStation());
                    object.setStream(rssNode.getStream());
                    object.setStreamCoord(rssNode.getStreamCoord());
                    ((Element)rssReturnStatusConstants).addNode((RssNode)object, 1);
                    return object;
                }
                worldPt = ((Element)rssReturnStatusConstants).getReferencePt();
                streamAlignmentGlyph.getLine().getCoordAtLocation(worldPt);
            }
        } else {
            reservoirElement = this.findReservoir(worldPt);
        }
        if (reservoirElement != null) {
            object = this._sysmap.createNode(worldPt);
            object.setStreamIndex(streamAlignmentGlyph.getIndex());
            object.setStreamName(streamAlignmentGlyph.getName());
            object.setStreamCoord(d);
            ((RssNode)object).setStreamStation(streamAlignmentGlyph.getStationByCoord(d));
            return object;
        }
        return null;
    }

    public ModelDrawingAttributeSet getAttributeSet() {
        return this._rssDas;
    }

    public String getToolTipText(WorldPt worldPt, MouseEvent mouseEvent) {
        if (this._sysmap == null || worldPt == null) {
            return null;
        }
        worldPt = this.findObject(worldPt);
        if (this._highlightElements && this._lastElement != null) {
            RssSystemGlyph rssSystemGlyph = this;
            rssSystemGlyph.drawElement(rssSystemGlyph._mapPanel.viewport().getGraphics(), this._mapPanel.scale(), this._lastElement);
            RssSystemGlyph rssSystemGlyph2 = this;
            rssSystemGlyph2.drawElement(rssSystemGlyph2._mapPanel.viewport().getBufferedGraphics(), this._mapPanel.scale(), this._lastElement);
        }
        if (worldPt == null) {
            this._lastElement = null;
            return null;
        }
        if (this._highlightElements) {
            RssSystemGlyph rssSystemGlyph = this;
            rssSystemGlyph.drawSelectedElement(rssSystemGlyph._mapPanel.viewport().getGraphics(), this._mapPanel.scale(), (Element)worldPt);
            RssSystemGlyph rssSystemGlyph3 = this;
            rssSystemGlyph3.drawSelectedElement(rssSystemGlyph3._mapPanel.viewport().getBufferedGraphics(), this._mapPanel.scale(), (Element)worldPt);
        }
        this._lastElement = (Element)worldPt;
        int n = mouseEvent.isAltDown() & mouseEvent.isControlDown() & mouseEvent.isShiftDown();
        if (worldPt instanceof ReservoirElement) {
            ReservoirElement reservoirElement = (ReservoirElement)worldPt;
            RssAlt rssAlt = reservoirElement.getSystem().getAlternative();
            Object object = "";
            if (rssAlt != null) {
                int n2 = rssAlt.getResOpSetSelection(reservoirElement.getIndex());
                OpSet opSet = reservoirElement.getReservoirOp().getOperationSet(n2);
                if (opSet != null) {
                    object = "<br><b>Operations Set: </b>" + opSet.getName();
                }
            }
            return "<html><b>Reservoir: </b>" + worldPt.getName() + (String)(object != null ? object : "") + "</html>";
        }
        if (worldPt instanceof ReachElement) {
            TSLocation tSLocation = (ReachElement)worldPt;
            boolean[] blArray = new boolean[]{false};
            Routing routing = this.getRouting((TimeStepRoutingElement)tSLocation, blArray);
            int n3 = tSLocation.getSeepageType();
            Object object = "None";
            if (n3 == 0) {
                double d = tSLocation.getConstSeepage();
                if (RMAConst.isValidValue((double)d)) {
                    object = "Constant-" + d;
                }
            } else if (n3 == 1) {
                object = "Function of Flow";
            }
            String string = "";
            if (routing != null) {
                string = routing.toString();
            } else if (blArray[0]) {
                string = "Routing Method and/or Parameters vary by Timestep";
            }
            if (n != 0) {
                ReachElement reachElement = (ReachElement)worldPt;
                RssNode rssNode = ((Element)reachElement).getDownstreamNode();
                tSLocation = ((Element)reachElement).getUpstreamNode();
                return "<html><b>Reach: </b>" + worldPt.getName() + "<br><b>Routing: </b>" + string + "<br><b>Losses: </b>" + (String)object + this.addNodeInfo("UpstreamNode: ", (RssNode)tSLocation) + this.addNodeInfo("DownStreamNode: ", rssNode);
            }
            return "<html><b>Reach:</b> " + worldPt.getName() + "<br><b>Routing:</b> " + string + "<br><b>Losses:</b> " + (String)object + "</html>";
        }
        if (worldPt instanceof JunctionElement) {
            String[] stringArray;
            JunctionElement junctionElement = (JunctionElement)worldPt;
            Vector vector = junctionElement.getLocalFlowVector();
            Object object = "<b>Local Flows: </b>";
            if (vector == null || vector.size() == 0) {
                object = (String)object + "None";
            } else {
                for (int i = 0; i < vector.size(); ++i) {
                    stringArray = (String[])vector.get(i);
                    object = (String)object + "<br>" + stringArray[0] + " [x" + stringArray[1] + "]";
                }
            }
            if (n != 0) {
                stringArray = junctionElement.getDownstreamNode();
                String string = "<html><b>Junction:</b>" + worldPt.getName() + "<br>" + (String)object + this.addNodeInfo("DownstreamNode:", (RssNode)stringArray);
                Vector vector2 = junctionElement.getNodeVector();
                for (n = 0; n < vector2.size(); ++n) {
                    RssNode rssNode = (RssNode)vector2.get(n);
                    if (rssNode == stringArray) continue;
                    string = string + this.addNodeInfo("Node:", rssNode);
                }
                return string;
            }
            return "<html><b>Junction: </b>" + worldPt.getName() + "<br>" + (String)object;
        }
        if (worldPt instanceof DiversionElement) {
            DiversionElement diversionElement = (DiversionElement)worldPt;
            boolean[] blArray = new boolean[]{false};
            Routing routing = this.getRouting((TimeStepRoutingElement)diversionElement.getReachElement(), blArray);
            diversionElement.getController();
            Object object = "";
            if (routing != null) {
                object = "<b>Routing:</b>" + routing.toString();
            } else if (blArray[0]) {
                object = "<b>Routing:</b>Routing Method and/or Parameters vary by Timestep";
            }
            if (n != 0) {
                RssNode rssNode = ((Element)diversionElement).getUpstreamNode();
                String string = "<html><b>Diversion:</b>" + diversionElement.getName() + "<br>" + (String)object + this.addNodeInfo("InflowNode:", rssNode);
                RssNode rssNode2 = ((Element)diversionElement).getDownstreamNode();
                if (rssNode2 != null) {
                    String cfr_ignored_0 = string + this.addNodeInfo("OutflowNode:", rssNode2);
                }
            }
            return "<html><b>Diversion: </b> " + worldPt.getName() + "<br>" + (String)object + "</html>";
        }
        return null;
    }

    private Routing getRouting(TimeStepRoutingElement timeStepRoutingElement, boolean[] blArray) {
        if (timeStepRoutingElement == null) {
            return null;
        }
        Routing routing = null;
        RssAlt rssAlt = timeStepRoutingElement.getSystem().getAlternative();
        if (ClientApp.frame().getCurrentMode() instanceof RSimNetworkMode) {
            rssAlt = null;
        }
        if (rssAlt == null) {
            routing = this.getDefaultRouting(timeStepRoutingElement, blArray);
        } else {
            int n;
            int n2 = rssAlt.getTimestep();
            String string = RoutingPanel.a(n2, n = rssAlt.getTimestepIncrement());
            if (string != null) {
                Object object = timeStepRoutingElement.getDefinedTimeStepDurations();
                object = new ArrayList<Duration>(Arrays.asList(object));
                Routing routing2 = (Routing)timeStepRoutingElement.getFunction();
                object = object.iterator();
                while (object.hasNext()) {
                    Duration duration = (Duration)object.next();
                    TimeStepUtil timeStepUtil = TimeStepUtil.a(duration);
                    if (!string.equalsIgnoreCase(timeStepUtil.toString())) continue;
                    routing = (Routing)timeStepRoutingElement.getFunction(duration, routing2);
                    break;
                }
            }
            if (routing == null) {
                routing = this.getDefaultRouting(timeStepRoutingElement, blArray);
            }
        }
        if (routing == null) {
            routing = (Routing)timeStepRoutingElement.getFunction();
        }
        return routing;
    }

    private Routing getDefaultRouting(TimeStepRoutingElement timeStepRoutingElement, boolean[] blArray) {
        Duration[] durationArray;
        Routing routing = null;
        Duration[] durationArray2 = durationArray = timeStepRoutingElement.getDefinedTimeStepDurations();
        int n = durationArray.length;
        for (int i = 0; i < n; ++i) {
            Object object = durationArray2[i];
            if (!((object = timeStepRoutingElement.getFunction((Duration)object, null)) instanceof Routing)) continue;
            routing = (Routing)object;
            break;
        }
        blArray[0] = durationArray.length > 1;
        return routing;
    }

    private String addNodeInfo(String string, RssNode rssNode) {
        if (rssNode == null) {
            return "<br><br><b>" + string + "</b>none";
        }
        return "<br><br><b>" + string + "</b>" + String.valueOf(rssNode) + "<br><b>id:</b>" + rssNode.getIndex() + "<br><b>Station:</b>" + rssNode.getStreamStation() + "<br><b>Coord:</b>" + rssNode.getStreamCoord();
    }

    protected StreamAlignmentGlyph getStreamAlignmentGlyph() {
        return (StreamAlignmentGlyph)this._mapPanel.findGlyphOfClass(StreamAlignmentGlyph.class.getName());
    }

    public boolean containsSelection(Object object) {
        if (!(object instanceof Element)) {
            return false;
        }
        object = new MapGlyph.Selection((MapGlyph)this, object, false);
        boolean bl = this._selectionList.contains(object);
        return bl;
    }

    public boolean selectFirstRecord(String string, boolean bl, boolean bl2, boolean bl3) {
        String string2 = (String)this._findTypeCombo.getSelectedItem();
        return this.findAndSelectElement(string2, string);
    }

    private boolean findAndSelectElement(String object, String string) {
        if ((object = this.findElement((String)object, string)) != null) {
            ResSimElementMapSelector.a((Element)object, this);
        }
        return object != null;
    }

    protected Element findElement(String string, String string2) {
        Element element = null;
        if ("Reservoir".equals(string)) {
            element = this._sysmap.findReservoir(string2);
        } else if ("Reach".equals(string)) {
            element = this._sysmap.findReach(string2);
        } else if ("Diversion".equals(string)) {
            element = this._sysmap.findDiversion(string2);
        } else if ("Junction".equals(string)) {
            element = this._sysmap.findJunction(string2);
        }
        return element;
    }

    public boolean selectLastRecord(String string, boolean bl, boolean bl2) {
        String string2 = (String)this._findTypeCombo.getSelectedItem();
        return this.findAndSelectElement(string2, string);
    }

    public void selectionChange(Object object, GraphicElementSelectionEvent object2) {
        object = object2.getSelection();
        if ("Point".equals(object2 = object.getType())) {
            object2 = "Junction";
        }
        object = this.findElement((String)object2, object.getName());
        this.selectElement(true, false, (Element)object);
    }

    public void addToSelection(Object object, GraphicElementSelectionEvent object2) {
        object = object2.getSelection();
        object2 = object.getType();
        "Point".equals(object2);
        object = this.findElement(object.getType(), object.getName());
        this.selectElement(true, false, (Element)object);
    }

    public void clearSelection(Object object, GraphicElementSelectionEvent graphicElementSelectionEvent) {
        this.clearSelection();
    }

    public void addListener(GraphicElementSelectionEventListener graphicElementSelectionEventListener) {
        this._geSupport.addListener(graphicElementSelectionEventListener);
    }

    public void removeListener(GraphicElementSelectionEventListener graphicElementSelectionEventListener) {
        this._geSupport.removeListener(graphicElementSelectionEventListener);
    }

    public static void initIcons() {
    }

    static {
        LayerSymbol.addLayerSymbol((int)3, (LayerSymbol.LayerSymbolShape)new RssSystemGlyph$ResJunctionSymbol());
        LayerSymbol.addLayerSymbol((int)4, (LayerSymbol.LayerSymbolShape)new RssSystemGlyph$ResReachSymbol());
        LayerSymbol.addLayerSymbol((int)5, (LayerSymbol.LayerSymbolShape)new RssSystemGlyph$ResReservoirSymbol());
        LayerSymbol.addLayerSymbol((int)6, (LayerSymbol.LayerSymbolShape)new RssSystemGlyph$ResDiversionSymbol());
        _impactImage = null;
        _reachImage = null;
        _tsImage = null;
        _xpt = new int[4];
        _ypt = new int[4];
    }
}

