/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.rss.client.RuleDlg$1;
import hec.rss.client.RuleDlg$2;
import hec.rss.client.RuleDlg$3;
import hec.rss.client.RuleDlg$4;
import hec.rss.client.RuleDlg$OpControllerWrapper;
import hec.rss.client.RuleDlg$SymWindow;
import hec.rss.model.AdjustableFlow;
import hec.rss.model.DiversionElement;
import hec.rss.model.DivertedOutletElement;
import hec.rss.model.Element;
import hec.rss.model.ElementOp;
import hec.rss.model.OpController;
import hec.rss.model.OpRule;
import hec.rss.model.OutletGroupElement;
import hec.rss.model.PowerPlantFlow;
import hec.rss.model.PumpFlow;
import hec.rss.model.ReservoirDamElement;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReversiblePumpFlow;
import hec.rss.model.RssNode;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.SystemOpRuleFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.text.Document;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJLabel;
import rma.swing.RmaJTextField;
import rma.swing.list.RmaListModel;
import rma.swing.text.DssPathnamePartDocument;

public class RuleDlg
extends RmaJDialog
implements ActionListener,
FocusListener,
ItemListener {
    ComboBoxModel<RssNode> _waterQualityDownstreamLocations = new DefaultComboBoxModel<RssNode>();
    ComboBoxModel<RssNode> _reservoirDownstreamLocations = new DefaultComboBoxModel<RssNode>();
    RmaJComboBox<String> _ruleChoice;
    RmaJComboBox<RuleDlg$OpControllerWrapper> _controllerChoice;
    RmaJComboBox _locationChoice;
    RmaJLabel _nameLbl;
    RmaJLabel _ruleLbl;
    RmaJLabel _controllerLbl;
    RmaJLabel _locationLbl;
    RmaJTextField _nameTxt;
    JButton _cmdOk;
    JButton _cmdCancel;
    private boolean _canceled = false;
    List<String> _resRuleVec = new ArrayList<String>();
    List<String> _resRuleWithPowerVec;
    List<String> _damRuleVec;
    List<String> _damRuleWithPowerVec;
    List<String> _divRuleVec;
    List<String> _divOutletRuleVec;
    List<String> _divOutletRuleWithPowerVec;
    List<String> _grpRuleVec;
    List<String> _grpRuleWithPowerVec;
    List<String> _outRuleVec;
    List<String> _powerRuleVec;
    ElementOp _reservoirOp;
    private JPanel _buttonPanel;

    public RuleDlg(Dialog dialog, boolean bl) {
        super(dialog, bl);
        this._resRuleVec.add("Release Function");
        this._resRuleVec.add("Downstream Control Function");
        this._resRuleVec.add("Induced Surcharge");
        this._resRuleVec.add("Tandem Operation");
        this._resRuleVec.add("Flow Rate of Change Limit");
        this._resRuleVec.add("Elev Rate of Change Limit");
        this._resRuleVec.add("Script");
        this._resRuleVec.add("Prescribed Release");
        this._resRuleVec.add("Re-Reg Operation");
        this._resRuleVec.add("Water Quality Rule");
        this._resRuleWithPowerVec = new ArrayList<String>();
        this._resRuleWithPowerVec.add("Release Function");
        this._resRuleWithPowerVec.add("Downstream Control Function");
        this._resRuleWithPowerVec.add("Induced Surcharge");
        this._resRuleWithPowerVec.add("Tandem Operation");
        this._resRuleWithPowerVec.add("Flow Rate of Change Limit");
        this._resRuleWithPowerVec.add("Elev Rate of Change Limit");
        this._resRuleWithPowerVec.add("Hydropower - Power Guide Curve");
        this._resRuleWithPowerVec.add("Hydropower - Schedule");
        this._resRuleWithPowerVec.add("Hydropower - System Schedule");
        this._resRuleWithPowerVec.add("Hydropower - Time Series Requirement");
        this._resRuleWithPowerVec.add("Script");
        this._resRuleWithPowerVec.add("Prescribed Release");
        this._resRuleWithPowerVec.add("Water Quality Rule");
        this._damRuleVec = new ArrayList<String>();
        this._damRuleVec.add("Release Function");
        this._damRuleVec.add("Flow Rate of Change Limit");
        this._damRuleVec.add("Script");
        this._damRuleVec.add("Prescribed Release");
        this._damRuleWithPowerVec = new ArrayList<String>();
        this._damRuleWithPowerVec.add("Release Function");
        this._damRuleWithPowerVec.add("Flow Rate of Change Limit");
        this._damRuleWithPowerVec.add("Hydropower - Power Guide Curve");
        this._damRuleWithPowerVec.add("Hydropower - Schedule");
        this._damRuleWithPowerVec.add("Hydropower - System Schedule");
        this._damRuleWithPowerVec.add("Hydropower - Time Series Requirement");
        this._damRuleWithPowerVec.add("Script");
        this._damRuleWithPowerVec.add("Prescribed Release");
        this._divRuleVec = new ArrayList<String>();
        this._divRuleVec.add("Flow Rate of Change Limit");
        this._divRuleVec.add("Script");
        this._divRuleVec.add("Flow Function");
        this._divOutletRuleVec = new ArrayList<String>();
        this._divOutletRuleVec.add("Release Function");
        this._divOutletRuleVec.add("Flow Rate of Change Limit");
        this._divOutletRuleVec.add("Script");
        this._divOutletRuleVec.add("Flow Function");
        this._divOutletRuleWithPowerVec = new ArrayList<String>();
        this._divOutletRuleWithPowerVec.add("Release Function");
        this._divOutletRuleWithPowerVec.add("Flow Rate of Change Limit");
        this._divOutletRuleWithPowerVec.add("Hydropower - Power Guide Curve");
        this._divOutletRuleWithPowerVec.add("Hydropower - Schedule");
        this._divOutletRuleWithPowerVec.add("Hydropower - System Schedule");
        this._divOutletRuleWithPowerVec.add("Hydropower - Time Series Requirement");
        this._divOutletRuleWithPowerVec.add("Script");
        this._divOutletRuleWithPowerVec.add("Prescribed Release");
        this._grpRuleVec = new ArrayList<String>();
        this._grpRuleVec.add("Release Function");
        this._grpRuleVec.add("Flow Rate of Change Limit");
        this._grpRuleVec.add("Script");
        this._grpRuleVec.add("Prescribed Release");
        this._grpRuleWithPowerVec = new ArrayList<String>();
        this._grpRuleWithPowerVec.add("Release Function");
        this._grpRuleWithPowerVec.add("Flow Rate of Change Limit");
        this._grpRuleWithPowerVec.add("Hydropower - Power Guide Curve");
        this._grpRuleWithPowerVec.add("Hydropower - Schedule");
        this._grpRuleWithPowerVec.add("Hydropower - System Schedule");
        this._grpRuleWithPowerVec.add("Hydropower - Time Series Requirement");
        this._grpRuleWithPowerVec.add("Script");
        this._grpRuleWithPowerVec.add("Prescribed Release");
        this._outRuleVec = new ArrayList<String>();
        this._outRuleVec.add("Release Function");
        this._outRuleVec.add("Flow Rate of Change Limit");
        this._outRuleVec.add("Script");
        this._outRuleVec.add("Prescribed Release");
        this._powerRuleVec = new ArrayList<String>();
        this._powerRuleVec.add("Release Function");
        this._powerRuleVec.add("Flow Rate of Change Limit");
        this._powerRuleVec.add("Hydropower - Power Guide Curve");
        this._powerRuleVec.add("Hydropower - Schedule");
        this._powerRuleVec.add("Hydropower - System Schedule");
        this._powerRuleVec.add("Hydropower - Time Series Requirement");
        this._powerRuleVec.add("Script");
        this._powerRuleVec.add("Prescribed Release");
        this.createComponents();
        this.addListeners();
    }

    public RuleDlg(Dialog dialog, String string, boolean bl) {
        this(dialog, bl);
        this.setTitle(string);
    }

    public RuleDlg(Frame frame, boolean bl) {
        super(frame, bl);
        this._resRuleVec.add("Release Function");
        this._resRuleVec.add("Downstream Control Function");
        this._resRuleVec.add("Induced Surcharge");
        this._resRuleVec.add("Tandem Operation");
        this._resRuleVec.add("Flow Rate of Change Limit");
        this._resRuleVec.add("Elev Rate of Change Limit");
        this._resRuleVec.add("Script");
        this._resRuleVec.add("Prescribed Release");
        this._resRuleVec.add("Re-Reg Operation");
        this._resRuleVec.add("Water Quality Rule");
        this._resRuleWithPowerVec = new ArrayList<String>();
        this._resRuleWithPowerVec.add("Release Function");
        this._resRuleWithPowerVec.add("Downstream Control Function");
        this._resRuleWithPowerVec.add("Induced Surcharge");
        this._resRuleWithPowerVec.add("Tandem Operation");
        this._resRuleWithPowerVec.add("Flow Rate of Change Limit");
        this._resRuleWithPowerVec.add("Elev Rate of Change Limit");
        this._resRuleWithPowerVec.add("Hydropower - Power Guide Curve");
        this._resRuleWithPowerVec.add("Hydropower - Schedule");
        this._resRuleWithPowerVec.add("Hydropower - System Schedule");
        this._resRuleWithPowerVec.add("Hydropower - Time Series Requirement");
        this._resRuleWithPowerVec.add("Script");
        this._resRuleWithPowerVec.add("Prescribed Release");
        this._resRuleWithPowerVec.add("Water Quality Rule");
        this._damRuleVec = new ArrayList<String>();
        this._damRuleVec.add("Release Function");
        this._damRuleVec.add("Flow Rate of Change Limit");
        this._damRuleVec.add("Script");
        this._damRuleVec.add("Prescribed Release");
        this._damRuleWithPowerVec = new ArrayList<String>();
        this._damRuleWithPowerVec.add("Release Function");
        this._damRuleWithPowerVec.add("Flow Rate of Change Limit");
        this._damRuleWithPowerVec.add("Hydropower - Power Guide Curve");
        this._damRuleWithPowerVec.add("Hydropower - Schedule");
        this._damRuleWithPowerVec.add("Hydropower - System Schedule");
        this._damRuleWithPowerVec.add("Hydropower - Time Series Requirement");
        this._damRuleWithPowerVec.add("Script");
        this._damRuleWithPowerVec.add("Prescribed Release");
        this._divRuleVec = new ArrayList<String>();
        this._divRuleVec.add("Flow Rate of Change Limit");
        this._divRuleVec.add("Script");
        this._divRuleVec.add("Flow Function");
        this._divOutletRuleVec = new ArrayList<String>();
        this._divOutletRuleVec.add("Release Function");
        this._divOutletRuleVec.add("Flow Rate of Change Limit");
        this._divOutletRuleVec.add("Script");
        this._divOutletRuleVec.add("Flow Function");
        this._divOutletRuleWithPowerVec = new ArrayList<String>();
        this._divOutletRuleWithPowerVec.add("Release Function");
        this._divOutletRuleWithPowerVec.add("Flow Rate of Change Limit");
        this._divOutletRuleWithPowerVec.add("Hydropower - Power Guide Curve");
        this._divOutletRuleWithPowerVec.add("Hydropower - Schedule");
        this._divOutletRuleWithPowerVec.add("Hydropower - System Schedule");
        this._divOutletRuleWithPowerVec.add("Hydropower - Time Series Requirement");
        this._divOutletRuleWithPowerVec.add("Script");
        this._divOutletRuleWithPowerVec.add("Prescribed Release");
        this._grpRuleVec = new ArrayList<String>();
        this._grpRuleVec.add("Release Function");
        this._grpRuleVec.add("Flow Rate of Change Limit");
        this._grpRuleVec.add("Script");
        this._grpRuleVec.add("Prescribed Release");
        this._grpRuleWithPowerVec = new ArrayList<String>();
        this._grpRuleWithPowerVec.add("Release Function");
        this._grpRuleWithPowerVec.add("Flow Rate of Change Limit");
        this._grpRuleWithPowerVec.add("Hydropower - Power Guide Curve");
        this._grpRuleWithPowerVec.add("Hydropower - Schedule");
        this._grpRuleWithPowerVec.add("Hydropower - System Schedule");
        this._grpRuleWithPowerVec.add("Hydropower - Time Series Requirement");
        this._grpRuleWithPowerVec.add("Script");
        this._grpRuleWithPowerVec.add("Prescribed Release");
        this._outRuleVec = new ArrayList<String>();
        this._outRuleVec.add("Release Function");
        this._outRuleVec.add("Flow Rate of Change Limit");
        this._outRuleVec.add("Script");
        this._outRuleVec.add("Prescribed Release");
        this._powerRuleVec = new ArrayList<String>();
        this._powerRuleVec.add("Release Function");
        this._powerRuleVec.add("Flow Rate of Change Limit");
        this._powerRuleVec.add("Hydropower - Power Guide Curve");
        this._powerRuleVec.add("Hydropower - Schedule");
        this._powerRuleVec.add("Hydropower - System Schedule");
        this._powerRuleVec.add("Hydropower - Time Series Requirement");
        this._powerRuleVec.add("Script");
        this._powerRuleVec.add("Prescribed Release");
        this.createComponents();
        this.addListeners();
    }

    public RuleDlg(Frame frame, String string, boolean bl) {
        this(frame, bl);
        this.setTitle(string);
    }

    public RuleDlg(Dialog dialog, boolean bl, ElementOp elementOp) {
        super(dialog, bl);
        this._resRuleVec.add("Release Function");
        this._resRuleVec.add("Downstream Control Function");
        this._resRuleVec.add("Induced Surcharge");
        this._resRuleVec.add("Tandem Operation");
        this._resRuleVec.add("Flow Rate of Change Limit");
        this._resRuleVec.add("Elev Rate of Change Limit");
        this._resRuleVec.add("Script");
        this._resRuleVec.add("Prescribed Release");
        this._resRuleVec.add("Re-Reg Operation");
        this._resRuleVec.add("Water Quality Rule");
        this._resRuleWithPowerVec = new ArrayList<String>();
        this._resRuleWithPowerVec.add("Release Function");
        this._resRuleWithPowerVec.add("Downstream Control Function");
        this._resRuleWithPowerVec.add("Induced Surcharge");
        this._resRuleWithPowerVec.add("Tandem Operation");
        this._resRuleWithPowerVec.add("Flow Rate of Change Limit");
        this._resRuleWithPowerVec.add("Elev Rate of Change Limit");
        this._resRuleWithPowerVec.add("Hydropower - Power Guide Curve");
        this._resRuleWithPowerVec.add("Hydropower - Schedule");
        this._resRuleWithPowerVec.add("Hydropower - System Schedule");
        this._resRuleWithPowerVec.add("Hydropower - Time Series Requirement");
        this._resRuleWithPowerVec.add("Script");
        this._resRuleWithPowerVec.add("Prescribed Release");
        this._resRuleWithPowerVec.add("Water Quality Rule");
        this._damRuleVec = new ArrayList<String>();
        this._damRuleVec.add("Release Function");
        this._damRuleVec.add("Flow Rate of Change Limit");
        this._damRuleVec.add("Script");
        this._damRuleVec.add("Prescribed Release");
        this._damRuleWithPowerVec = new ArrayList<String>();
        this._damRuleWithPowerVec.add("Release Function");
        this._damRuleWithPowerVec.add("Flow Rate of Change Limit");
        this._damRuleWithPowerVec.add("Hydropower - Power Guide Curve");
        this._damRuleWithPowerVec.add("Hydropower - Schedule");
        this._damRuleWithPowerVec.add("Hydropower - System Schedule");
        this._damRuleWithPowerVec.add("Hydropower - Time Series Requirement");
        this._damRuleWithPowerVec.add("Script");
        this._damRuleWithPowerVec.add("Prescribed Release");
        this._divRuleVec = new ArrayList<String>();
        this._divRuleVec.add("Flow Rate of Change Limit");
        this._divRuleVec.add("Script");
        this._divRuleVec.add("Flow Function");
        this._divOutletRuleVec = new ArrayList<String>();
        this._divOutletRuleVec.add("Release Function");
        this._divOutletRuleVec.add("Flow Rate of Change Limit");
        this._divOutletRuleVec.add("Script");
        this._divOutletRuleVec.add("Flow Function");
        this._divOutletRuleWithPowerVec = new ArrayList<String>();
        this._divOutletRuleWithPowerVec.add("Release Function");
        this._divOutletRuleWithPowerVec.add("Flow Rate of Change Limit");
        this._divOutletRuleWithPowerVec.add("Hydropower - Power Guide Curve");
        this._divOutletRuleWithPowerVec.add("Hydropower - Schedule");
        this._divOutletRuleWithPowerVec.add("Hydropower - System Schedule");
        this._divOutletRuleWithPowerVec.add("Hydropower - Time Series Requirement");
        this._divOutletRuleWithPowerVec.add("Script");
        this._divOutletRuleWithPowerVec.add("Prescribed Release");
        this._grpRuleVec = new ArrayList<String>();
        this._grpRuleVec.add("Release Function");
        this._grpRuleVec.add("Flow Rate of Change Limit");
        this._grpRuleVec.add("Script");
        this._grpRuleVec.add("Prescribed Release");
        this._grpRuleWithPowerVec = new ArrayList<String>();
        this._grpRuleWithPowerVec.add("Release Function");
        this._grpRuleWithPowerVec.add("Flow Rate of Change Limit");
        this._grpRuleWithPowerVec.add("Hydropower - Power Guide Curve");
        this._grpRuleWithPowerVec.add("Hydropower - Schedule");
        this._grpRuleWithPowerVec.add("Hydropower - System Schedule");
        this._grpRuleWithPowerVec.add("Hydropower - Time Series Requirement");
        this._grpRuleWithPowerVec.add("Script");
        this._grpRuleWithPowerVec.add("Prescribed Release");
        this._outRuleVec = new ArrayList<String>();
        this._outRuleVec.add("Release Function");
        this._outRuleVec.add("Flow Rate of Change Limit");
        this._outRuleVec.add("Script");
        this._outRuleVec.add("Prescribed Release");
        this._powerRuleVec = new ArrayList<String>();
        this._powerRuleVec.add("Release Function");
        this._powerRuleVec.add("Flow Rate of Change Limit");
        this._powerRuleVec.add("Hydropower - Power Guide Curve");
        this._powerRuleVec.add("Hydropower - Schedule");
        this._powerRuleVec.add("Hydropower - System Schedule");
        this._powerRuleVec.add("Hydropower - Time Series Requirement");
        this._powerRuleVec.add("Script");
        this._powerRuleVec.add("Prescribed Release");
        this._reservoirOp = elementOp;
        this.createComponents();
        this.addListeners();
    }

    public int getDnstrmNodeIndex() {
        Object object = (String)this._ruleChoice.getSelectedItem();
        if (((String)object).equals("Downstream Control Function") || ((String)object).equals("Water Quality Rule")) {
            object = this._locationChoice.getSelectedItem();
            if (object == null || !(object instanceof RssNode)) {
                return -1;
            }
            return ((RssNode)object).getIndex();
        }
        return -1;
    }

    public void setDownstreamLocationVec(List<RssNode> list) {
        this._reservoirDownstreamLocations = new DefaultComboBoxModel<RssNode>(new Vector<RssNode>(list));
    }

    public void setDownstreamWQLocations(List<RssNode> list) {
        this._waterQualityDownstreamLocations = new DefaultComboBoxModel<RssNode>(new Vector<RssNode>(list));
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 1) {
            return;
        }
        if (itemEvent.getSource() == this._controllerChoice) {
            this.fillRuleCombo();
            return;
        }
        if (itemEvent.getSource() == this._ruleChoice) {
            if (((String)this._ruleChoice.getSelectedItem()).equals("Downstream Control Function")) {
                this._locationLbl.setVisible(true);
                this._locationChoice.setVisible(true);
                this._locationChoice.setModel(this._reservoirDownstreamLocations);
                this._locationChoice.setSelectedIndex(-1);
                return;
            }
            if (((String)this._ruleChoice.getSelectedItem()).equals("Water Quality Rule")) {
                this._locationLbl.setVisible(false);
                this._locationChoice.setVisible(false);
                this._locationChoice.setModel(this._waterQualityDownstreamLocations);
                this._locationChoice.setSelectedIndex(-1);
                return;
            }
            this._locationLbl.setVisible(false);
            this._locationChoice.setVisible(false);
        }
    }

    void fillRuleCombo() {
        Object object;
        this._controllerChoice.removeItemListener((ItemListener)this);
        this._ruleChoice.removeItemListener((ItemListener)this);
        if (this._ruleChoice.getItemCount() > 0) {
            this._ruleChoice.removeAllItems();
        }
        List<String> list = null;
        OpController opController = this.getSelectedController();
        if (opController != null) {
            if (opController.getReleaseElement() instanceof ReservoirElement) {
                list = ((ReservoirElement)opController.getReleaseElement()).hasPowerPlant() ? this._resRuleWithPowerVec : this._resRuleVec;
            } else if (opController.getReleaseElement() instanceof ReservoirDamElement) {
                list = ((ReservoirDamElement)opController.getReleaseElement()).hasPowerPlant() ? this._damRuleWithPowerVec : this._damRuleVec;
            } else if (opController.getReleaseElement() instanceof DivertedOutletElement) {
                list = ((DivertedOutletElement)opController.getReleaseElement()).hasPowerPlant() ? this._divOutletRuleWithPowerVec : this._divOutletRuleVec;
            } else if (opController.getReleaseElement() instanceof OutletGroupElement) {
                list = ((OutletGroupElement)opController.getReleaseElement()).hasPowerPlant() ? this._grpRuleWithPowerVec : this._grpRuleVec;
            } else if (opController.getReleaseElement() instanceof DiversionElement) {
                list = this._divRuleVec;
            } else {
                object = opController.getReleaseElement().getFunction();
                list = new Vector<String>();
                if (object instanceof PumpFlow) {
                    list.add("Pump Schedule");
                } else if (object instanceof ReversiblePumpFlow) {
                    list.addAll(this._outRuleVec);
                    list.add("Pump Schedule");
                } else if (object instanceof PowerPlantFlow) {
                    list.addAll(this._powerRuleVec);
                } else if (object instanceof AdjustableFlow) {
                    list.addAll(this._outRuleVec);
                }
            }
            object = opController.getReleaseElement();
            if (object != null) {
                if (((Element)object).hasWaterControlDevice()) {
                    if (!list.contains("Water Quality Rule")) {
                        list.add("Water Quality Rule");
                    }
                } else {
                    list.remove("Water Quality Rule");
                }
            }
        }
        if (list != null) {
            object = new RmaListModel(false, list);
            this._ruleChoice.setModel((ComboBoxModel)object);
        }
        this._locationLbl.setVisible(false);
        this._locationChoice.setVisible(false);
        this._controllerChoice.addItemListener((ItemListener)this);
        this._ruleChoice.addItemListener((ItemListener)this);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this._nameTxt.setText("");
            EventQueue.invokeLater(() -> this._nameTxt.requestFocusInWindow());
        }
        super.setVisible(bl);
    }

    public OpController getSelectedController() {
        RuleDlg$OpControllerWrapper ruleDlg$OpControllerWrapper;
        if (this._controllerChoice.getItemCount() > 0 && (ruleDlg$OpControllerWrapper = (RuleDlg$OpControllerWrapper)this._controllerChoice.getSelectedItem()) != null) {
            return ruleDlg$OpControllerWrapper.a();
        }
        return null;
    }

    public void setResOpsRules() {
        if (this._controllerChoice.getItemCount() > 0) {
            this._controllerChoice.removeAllItems();
        }
        if (this._ruleChoice.getItemCount() > 0) {
            this._ruleChoice.removeAllItems();
        }
    }

    public void setResOpSetRules(ElementOp object) {
        this._reservoirOp = object;
        this._controllerLbl.setVisible(true);
        this._controllerChoice.setVisible(true);
        if (this._controllerChoice.getItemCount() > 0) {
            this._controllerChoice.removeAllItems();
        }
        object.getController().updateControllerTree((Element)((Object)object.getOperationsElement()));
        object = object.getControllers();
        Vector<RuleDlg$OpControllerWrapper> vector = new Vector<RuleDlg$OpControllerWrapper>();
        for (int i = 0; i < object.size(); ++i) {
            OpController opController = (OpController)object.get(i);
            if (opController == null || opController.isUncontrolled()) continue;
            vector.add(new RuleDlg$OpControllerWrapper(this, opController));
        }
        RmaListModel rmaListModel = new RmaListModel(false, vector);
        this._controllerChoice.setModel((ComboBoxModel)rmaListModel);
        int n = rmaListModel.size();
        if (n == 1) {
            this._controllerChoice.setSelectedIndex(0);
        } else {
            this._controllerChoice.setSelectedIndex(-1);
        }
        this.fillRuleCombo();
    }

    public void setSystemOpSetRules() {
        this._controllerLbl.setVisible(true);
        this._controllerChoice.setVisible(true);
        if (this._controllerChoice.getItemCount() > 0) {
            this._controllerChoice.removeAllItems();
        }
        if (this._ruleChoice.getItemCount() > 0) {
            this._ruleChoice.removeAllItems();
        }
        for (int i = 0; i < SystemOpRuleFactory.RULESTRARRAY.length; ++i) {
            this._ruleChoice.addItem((Object)SystemOpRuleFactory.RULESTRARRAY[i]);
        }
    }

    public void setDiversionRules() {
        this._controllerLbl.setVisible(false);
        this._controllerChoice.setVisible(false);
        if (this._ruleChoice.getItemCount() > 0) {
            this._ruleChoice.removeAllItems();
        }
        this._ruleChoice.addItem((Object)"Constant");
        this._ruleChoice.addItem((Object)"Monthly Varying");
        this._ruleChoice.addItem((Object)"Seasonal");
        this._ruleChoice.addItem((Object)"Function of Flow");
        this._ruleChoice.addItem((Object)"Function of Pool Elevation");
        this._ruleChoice.addItem((Object)"Time-Series");
        this._ruleChoice.addItem((Object)"Min Max");
    }

    public void setDiversionRules(String string) {
        if (this._ruleChoice.getItemCount() > 0) {
            this._ruleChoice.removeAllItems();
        }
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public String getRuleType() {
        return (String)this._ruleChoice.getSelectedItem();
    }

    public String getName() {
        return this._nameTxt.getText();
    }

    @Override
    public void actionPerformed(ActionEvent object) {
        if ((object = ((EventObject)object).getSource()) == this._cmdOk) {
            this.ButtonOk_Action();
            return;
        }
        if (object == this._cmdCancel) {
            this.ButtonCancel_Action();
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this._nameTxt.requestFocus();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    public void enterPressed() {
        JButton jButton = this.getRootPane().getDefaultButton();
        if (jButton != null) {
            jButton.doClick();
        }
    }

    void JDialog1_WindowClosing(WindowEvent windowEvent) {
        this._canceled = true;
        this.dispose();
    }

    void ButtonOk_Action() {
        if (this._nameTxt.getText().length() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "A blank rule name is not allowed. Please enter a new name.", "Cannot Create New Rule", 1);
            return;
        }
        OpController opController = this.getSelectedController();
        if (opController == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No Release Location selected for Rule.", "Cannot Create New Rule", 1);
            return;
        }
        if (this._ruleChoice.getSelectedItem() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No Rule Type selected for Rule.", "Cannot Create New Rule", 1);
            return;
        }
        String string = this.getName().trim();
        Object object = opController.getRule(string);
        if (object != null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "The rule name has to be unique among the rules defined for this reservoir and all downstream rules.\nPlease enter a new name.", "Cannot Create New Rule", 1);
            return;
        }
        object = this._reservoirOp.getRules();
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            String string2 = ((OpRule)((Vector)object).get(i)).toString();
            if (!string2.equals(string)) continue;
            JOptionPane.showMessageDialog((Component)((Object)this), "The rule name has to be unique among the rules defined for this reservoir and all downstream rules.\nPlease enter a new name.", "Cannot Create New Rule", 1);
            return;
        }
        if (((String)this._ruleChoice.getSelectedItem()).equals("Downstream Control Function")) {
            RssSystem rssSystem = ((RssTSLocationObject)opController).getSystem();
            if (rssSystem != null && (object = rssSystem.getDownstreamOpRule(string)) != null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "The rule name has to be unique among the rules defined for this reservoir and all downstream rules.\nPlease enter a new name.", "Cannot Create New Rule", 1);
                return;
            }
            if (this.getDnstrmNodeIndex() < 0) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Downstream Rules must have a Downstream Location selected.", "Cannot Create New Rule", 1);
                return;
            }
        }
        if (this._ruleChoice.getSelectedItem().equals("Water Quality Rule")) {
            this.getDnstrmNodeIndex();
        }
        this._canceled = false;
        this.setVisible(false);
    }

    void ButtonCancel_Action() {
        this._canceled = true;
        this.setVisible(false);
        this.dispose();
    }

    private void createComponents() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setSize(450, 200);
        this.setLocation();
        this._nameLbl = new RmaJLabel("Rule Name:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        this.getContentPane().add((Component)this._nameLbl, gridBagConstraints);
        this._nameTxt = new RmaJTextField("");
        this._nameTxt.setDocument((Document)new DssPathnamePartDocument());
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        this.getContentPane().add((Component)this._nameTxt, gridBagConstraints);
        this._controllerLbl = new RmaJLabel("Operates Release From:");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        this.getContentPane().add((Component)this._controllerLbl, gridBagConstraints);
        this._controllerChoice = new RmaJComboBox();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 10, 0, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        this.getContentPane().add((Component)this._controllerChoice, gridBagConstraints);
        this._ruleLbl = new RmaJLabel("Rule Type:");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        this.getContentPane().add((Component)this._ruleLbl, gridBagConstraints);
        this._ruleChoice = new RmaJComboBox();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 10, 0, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        this.getContentPane().add((Component)this._ruleChoice, gridBagConstraints);
        this._locationLbl = new RmaJLabel("Downstream Location:");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        this.getContentPane().add((Component)this._locationLbl, gridBagConstraints);
        this._locationChoice = new RmaJComboBox();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 10, 0, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        this.getContentPane().add((Component)this._locationChoice, gridBagConstraints);
        this._buttonPanel = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 2;
        this.getContentPane().add((Component)this._buttonPanel, gridBagConstraints);
        this._cmdOk = new JButton("OK");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        this._buttonPanel.add((Component)this._cmdOk, gridBagConstraints);
        this._cmdCancel = new JButton("Cancel");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        this._buttonPanel.add((Component)this._cmdCancel, gridBagConstraints);
    }

    protected void addListeners() {
        RuleDlg$SymWindow ruleDlg$SymWindow = new RuleDlg$SymWindow(this);
        this.addWindowListener(ruleDlg$SymWindow);
        this._cmdCancel.addActionListener(this);
        this._cmdOk.addActionListener(this);
        RuleDlg ruleDlg = this;
        ruleDlg.addFocusListener(ruleDlg);
        this.getRootPane().setDefaultButton(this._cmdOk);
        this._buttonPanel.registerKeyboardAction(new RuleDlg$1(this), KeyStroke.getKeyStroke(10, 0, true), 1);
        this._buttonPanel.registerKeyboardAction(new RuleDlg$2(this), KeyStroke.getKeyStroke(10, 0, true), 1);
        this._buttonPanel.registerKeyboardAction(new RuleDlg$3(this), KeyStroke.getKeyStroke(27, 0, true), 1);
        this._buttonPanel.registerKeyboardAction(new RuleDlg$4(this), KeyStroke.getKeyStroke(27, 0, true), 1);
        this.setTitle("New Operating Rule");
        this._controllerChoice.addItemListener((ItemListener)this);
        this._ruleChoice.addItemListener((ItemListener)this);
        this.registerEnterKey(true);
        this.registerEscapeKey(true);
    }
}

