/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientWorkspace;
import hec.data.DataSetIllegalArgumentException;
import hec.data.Parameter;
import hec.gfx2d.G2dData;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dPlotProp;
import hec.gfx2d.HotPlotDefaults;
import hec.gfx2d.PlotDefaults;
import hec.gfx2d.PlotDefaultsManager;
import hec.gui.NameDescriptionPanel;
import hec.model.ModelVariable;
import hec.model.PairedValues;
import hec.model.SeasonalPairedValues;
import hec.model.SeasonalRecord;
import hec.rss.RssRmiWorkspace;
import hec.rss.client.DayOfWeekMultiplierJDialog;
import hec.rss.client.FlowContingencyDialog;
import hec.rss.client.IndependentVariableDialog;
import hec.rss.client.PeriodAverageLimitDialog;
import hec.rss.client.RisingFallingCondDialog;
import hec.rss.client.RssCheckBoxEditPanel;
import hec.rss.client.RulePanel$1;
import hec.rss.client.RulePanel$2;
import hec.rss.client.RulePanel$3;
import hec.rss.client.RulePanel$4;
import hec.rss.client.RulePanel$5;
import hec.rss.client.RulePanel$DateTablePanel;
import hec.rss.client.RulePanel$DateTimeTablePanel;
import hec.rss.client.RulePanel$DayOfWeekMultiplerAction;
import hec.rss.client.RulePanel$DayOfWeekMultiplerItemStateChanged;
import hec.rss.client.RulePanel$FlowContingencyAction;
import hec.rss.client.RulePanel$FlowContingencyItemStateChanged;
import hec.rss.client.RulePanel$HourOfDayMultiplierAction;
import hec.rss.client.RulePanel$HourOfDayMultiplierItemStateChanged;
import hec.rss.client.RulePanel$MyG2dPanel;
import hec.rss.client.RulePanel$PairedValuesPanel;
import hec.rss.client.RulePanel$PeriodAverageLimitAction;
import hec.rss.client.RulePanel$PeriodAverageLimitItemStateChanged;
import hec.rss.client.RulePanel$RisingFallingAction;
import hec.rss.client.RulePanel$RisingFallingItemStateChanged;
import hec.rss.client.RulePanel$RuleTablePanel;
import hec.rss.client.RulePanel$SeasonalPairedValuesPanel;
import hec.rss.client.RulePanel$SeasonalVariationAction;
import hec.rss.client.RulePanel$SeasonalVariationItemStateChanged;
import hec.rss.client.SeasonalVariationJDialog;
import hec.rss.client.TimeOfDayMultiplierJDialog;
import hec.rss.model.DayOfWeekMultiplier;
import hec.rss.model.DownstreamOpRule;
import hec.rss.model.Element;
import hec.rss.model.IndependentVariable;
import hec.rss.model.OpRule;
import hec.rss.model.OpRuleRef;
import hec.rss.model.PowerGenerationPatternContainer;
import hec.rss.model.ReleaseFuncOpRule;
import hec.rss.model.StateVariable;
import hec.rss.model.TimeOfDayMultiplier;
import hec.rss.model.globalvariable.GlobalVariable;
import hec.rss.model.globalvariable.TimeSeriesGlobalVariable;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import rma.swing.DefaultJPanel;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJFrame;
import rma.swing.RmaJTextField;
import rma.swing.event.ReflectMultiListener;
import rma.swing.text.DssPathnamePartDocument;
import rma.util.RMAIO;

public class RulePanel
extends DefaultJPanel {
    public static final String LIMIT_TYPE_DEMAND = "Demand";
    public static final String LIMIT_TYPE_MIN = "Minimum";
    public static final String LIMIT_TYPE_MAX = "Maximum";
    public static final String LIMIT_TYPE_SPECIFIED = "Specified";
    OpRuleRef _currentRuleRef = null;
    DefaultJPanel _parent = null;
    ItemListener _limitTypeComboListener;
    ItemListener _interpComboListener;
    String _oldRuleName = "";
    int _currentFunctionType = -1;
    RulePanel$RuleTablePanel _currentPanel;
    int _xParamId = -1;
    int _yParamId = Parameter.PARAMID_FLOW;
    String _xParamString = "undef x";
    String _yParamString = "Release";
    protected String[] _colLabels = new String[]{"Date", "Release (%S)"};
    IndependentVariable _independentVariable;
    public static final String[] INTERPOLATION_TYPES = new String[]{"Linear", "Cubic", "Step"};
    public static final String[] LIMIT_TYPES = new String[]{"Minimum", "Maximum", "Specified"};
    protected String[] _limitTypes = LIMIT_TYPES;
    protected JLabel _releaseLocationLabel;
    protected NameDescriptionPanel _nameDescPanel;
    protected RmaJComboBox _limitTypeCombo;
    protected RmaJComboBox _interpolationCombo;
    protected RmaJTextField _functionOfTxt;
    protected JButton _defineFunctionBtn;
    protected IndependentVariableDialog _independentVariableDialog;
    protected PeriodAverageLimitDialog _periodAverageLimitDialog;
    protected ReflectMultiListener _listener;
    protected RssCheckBoxEditPanel _periodAverageLimitCB;
    protected RssCheckBoxEditPanel _hourOfDayMultiplyerCB;
    protected RssCheckBoxEditPanel _dayOfWeekMultiplerCB;
    protected RssCheckBoxEditPanel _risingFallingConditionCB;
    protected RssCheckBoxEditPanel _seasonalVariationCB;
    protected RssCheckBoxEditPanel _flowContingencyCB;
    protected JPanel _panel1;
    protected JPanel _rightPanel;
    private RulePanel$RuleTablePanel _blankPanel;
    private RulePanel$DateTablePanel _datePanel;
    private RulePanel$DateTimeTablePanel _dateTimePanel;
    private RulePanel$PairedValuesPanel _modelVariablePanel;
    private RulePanel$SeasonalPairedValuesPanel _seasonalVariablePanel;
    private JPanel _cardPanel;
    RulePanel$MyG2dPanel _plotPanel = new RulePanel$5(this);
    protected static final String[] a = new String[]{"Date", "Date and Time", "Model Variable", "External Time-Series", "Blank Panel"};

    public RulePanel() {
        this.setLayout(new GridBagLayout());
        this.buildControls();
    }

    protected void buildControls() {
        this._listener = new ReflectMultiListener();
        new GridBagConstraints();
        new JLabel("Operates Release From:");
        this._nameDescPanel = new NameDescriptionPanel(8L);
        this._nameDescPanel.setNameEditable(false);
        this._nameDescPanel.setNameDocument((Document)new DssPathnamePartDocument());
        this._nameDescPanel.setNameLabel("Rule Name:");
        Serializable serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        serializable.gridy = 1;
        serializable.gridwidth = 2;
        serializable.weightx = 1.0;
        serializable.anchor = 17;
        serializable.fill = 2;
        serializable.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)5);
        RulePanel rulePanel = this;
        rulePanel.add((Component)rulePanel._nameDescPanel, serializable);
        JPanel jPanel = new JPanel(new GridBagLayout());
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        serializable.gridy = 2;
        serializable.gridwidth = 2;
        serializable.weightx = 1.0;
        serializable.anchor = 17;
        serializable.fill = 2;
        serializable.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        this.add(jPanel, serializable);
        JComponent jComponent = new JLabel("Function of: ");
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        serializable.gridy = 0;
        serializable.gridwidth = 1;
        serializable.anchor = 17;
        serializable.fill = 0;
        serializable.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        jPanel.add((Component)jComponent, serializable);
        this._functionOfTxt = new RmaJTextField();
        this._functionOfTxt.setEditable(false);
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        serializable.gridy = 0;
        serializable.gridwidth = 1;
        serializable.weightx = 1.0;
        serializable.anchor = 17;
        serializable.fill = 2;
        serializable.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._functionOfTxt, serializable);
        this._defineFunctionBtn = new JButton("Define...");
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        serializable.gridy = 0;
        serializable.gridwidth = 1;
        serializable.anchor = 17;
        serializable.fill = 0;
        serializable.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._defineFunctionBtn, serializable);
        this._panel1 = new JPanel(new GridBagLayout());
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        serializable.gridy = 3;
        serializable.gridwidth = 1;
        serializable.weightx = 1.0;
        serializable.anchor = 18;
        serializable.fill = 2;
        serializable.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        RulePanel rulePanel2 = this;
        rulePanel2.add(rulePanel2._panel1, serializable);
        jComponent = new JLabel("Limit Type:  ");
        ((JLabel)jComponent).setDisplayedMnemonic('L');
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        serializable.gridy = 0;
        serializable.gridwidth = 1;
        serializable.anchor = 17;
        serializable.fill = 0;
        serializable.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this._panel1.add((Component)jComponent, serializable);
        this._limitTypeCombo = new RmaJComboBox((Object[])this._limitTypes);
        this._limitTypeCombo.setModifiable(true);
        ((JLabel)jComponent).setLabelFor((Component)this._limitTypeCombo);
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        serializable.gridy = 0;
        serializable.gridwidth = 1;
        serializable.weightx = 1.0;
        serializable.anchor = 17;
        serializable.fill = 2;
        serializable.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this._panel1.add((Component)this._limitTypeCombo, serializable);
        jComponent = new JLabel("Interp.:");
        ((JLabel)jComponent).setDisplayedMnemonic('I');
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        serializable.gridy = 0;
        serializable.gridwidth = 1;
        serializable.anchor = 17;
        serializable.fill = 0;
        serializable.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this._panel1.add((Component)jComponent, serializable);
        this._interpolationCombo = new RmaJComboBox((Object[])INTERPOLATION_TYPES);
        ((JLabel)jComponent).setLabelFor((Component)this._interpolationCombo);
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 3;
        serializable.gridy = 0;
        serializable.gridwidth = 1;
        serializable.weightx = 1.0;
        serializable.anchor = 17;
        serializable.fill = 2;
        serializable.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this._panel1.add((Component)this._interpolationCombo, serializable);
        RulePanel rulePanel3 = this;
        this._defineFunctionBtn.addActionListener((ActionListener)this._listener.add((Object)rulePanel3, (Object)rulePanel3._defineFunctionBtn, "displayDefineFunctionDialog"));
        this.buildRightPanel();
        jComponent = new JPanel(new GridBagLayout());
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        serializable.gridy = 1;
        serializable.gridwidth = 1;
        serializable.weighty = 0.0;
        serializable.anchor = 18;
        serializable.fill = 0;
        serializable.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        this._rightPanel.add((Component)jComponent, serializable);
        this._periodAverageLimitCB = new RssCheckBoxEditPanel("Period Average Limit");
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        serializable.gridy = 0;
        serializable.gridwidth = 1;
        serializable.anchor = 18;
        serializable.fill = 2;
        serializable.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        jComponent.add((Component)((Object)this._periodAverageLimitCB), serializable);
        this._hourOfDayMultiplyerCB = new RssCheckBoxEditPanel("Hour of Day Multiplier");
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        serializable.gridy = 1;
        serializable.gridwidth = 1;
        serializable.anchor = 18;
        serializable.fill = 2;
        serializable.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        jComponent.add((Component)((Object)this._hourOfDayMultiplyerCB), serializable);
        this._dayOfWeekMultiplerCB = new RssCheckBoxEditPanel("Day of Week Multiplier");
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        serializable.gridy = 2;
        serializable.gridwidth = 1;
        serializable.anchor = 18;
        serializable.fill = 2;
        serializable.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        jComponent.add((Component)((Object)this._dayOfWeekMultiplerCB), serializable);
        this._risingFallingConditionCB = new RssCheckBoxEditPanel("Rising/Falling Condition");
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        serializable.gridy = 3;
        serializable.gridwidth = 1;
        serializable.anchor = 18;
        serializable.fill = 2;
        serializable.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        jComponent.add((Component)((Object)this._risingFallingConditionCB), serializable);
        this._seasonalVariationCB = new RssCheckBoxEditPanel("Seasonal Variation");
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        serializable.gridy = 4;
        serializable.gridwidth = 1;
        serializable.anchor = 18;
        serializable.fill = 2;
        serializable.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        jComponent.add((Component)((Object)this._seasonalVariationCB), serializable);
        this._flowContingencyCB = new RulePanel$1(this, "Flow Contingency");
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        serializable.gridy = 5;
        serializable.gridwidth = 1;
        serializable.anchor = 18;
        serializable.fill = 2;
        serializable.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        jComponent.add((Component)((Object)this._flowContingencyCB), serializable);
        this._periodAverageLimitCB.addActionListener(new RulePanel$PeriodAverageLimitAction(this));
        this._periodAverageLimitCB.addItemListener(new RulePanel$PeriodAverageLimitItemStateChanged(this));
        this._hourOfDayMultiplyerCB.addActionListener(new RulePanel$HourOfDayMultiplierAction(this));
        this._hourOfDayMultiplyerCB.addItemListener(new RulePanel$HourOfDayMultiplierItemStateChanged(this));
        this._dayOfWeekMultiplerCB.addActionListener(new RulePanel$DayOfWeekMultiplerAction(this));
        this._dayOfWeekMultiplerCB.addItemListener(new RulePanel$DayOfWeekMultiplerItemStateChanged(this));
        this._risingFallingConditionCB.addActionListener(new RulePanel$RisingFallingAction(this));
        this._risingFallingConditionCB.addItemListener(new RulePanel$RisingFallingItemStateChanged(this));
        this._seasonalVariationCB.addActionListener(new RulePanel$SeasonalVariationAction(this));
        this._seasonalVariationCB.addItemListener(new RulePanel$SeasonalVariationItemStateChanged(this));
        this._flowContingencyCB.addActionListener(new RulePanel$FlowContingencyAction(this));
        this._flowContingencyCB.addItemListener(new RulePanel$FlowContingencyItemStateChanged(this));
        this._cardPanel = new JPanel(new CardLayout());
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        serializable.gridy = 5;
        serializable.gridwidth = 1;
        serializable.gridheight = 1;
        serializable.weightx = 1.0;
        serializable.weighty = 1.0;
        serializable.anchor = 18;
        serializable.fill = 1;
        serializable.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        RulePanel rulePanel4 = this;
        rulePanel4.add(rulePanel4._cardPanel, serializable);
        this._blankPanel = this.createRuleTablePanel();
        serializable = new JLabel("Rule Function Not Defined");
        this._blankPanel.add((Component)serializable, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._datePanel = this.createDateTablePanel();
        this._dateTimePanel = this.createDateTimeTablePanel();
        this._modelVariablePanel = this.createPairedValuesPanel();
        this._seasonalVariablePanel = this.createSeasonalPairedValuesPanel();
        this._cardPanel.add(a[0], this._datePanel);
        this._cardPanel.add(a[1], this._dateTimePanel);
        this._cardPanel.add(a[2], this._seasonalVariablePanel);
        this._cardPanel.add(a[3], this._modelVariablePanel);
        this._cardPanel.add(a[4], this._blankPanel);
        ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, a[2]);
        this._rightPanel.add((Component)((Object)this._plotPanel), new RmaGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 12, 1, new Insets(0, 0, 5, 5), 0, 0));
        RulePanel rulePanel5 = this;
        rulePanel5.configurePairedValuesPlot(rulePanel5._plotPanel);
        serializable = new Vector();
        this._plotPanel.setPlotObjects((List)((Object)serializable));
        this._limitTypeComboListener = new RulePanel$2(this);
        this._interpComboListener = new RulePanel$3(this);
        this._nameDescPanel.addNameFocusListener((FocusListener)new RulePanel$4(this));
    }

    protected void buildRightPanel() {
        this._rightPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        RulePanel rulePanel = this;
        rulePanel.add(rulePanel._rightPanel, gridBagConstraints);
    }

    protected RulePanel$PairedValuesPanel createPairedValuesPanel() {
        return new RulePanel$PairedValuesPanel(this);
    }

    protected RulePanel$SeasonalPairedValuesPanel createSeasonalPairedValuesPanel() {
        return new RulePanel$SeasonalPairedValuesPanel(this);
    }

    protected RulePanel$DateTimeTablePanel createDateTimeTablePanel() {
        return new RulePanel$DateTimeTablePanel(this);
    }

    protected RulePanel$DateTablePanel createDateTablePanel() {
        return new RulePanel$DateTablePanel(this);
    }

    protected RulePanel$RuleTablePanel createRuleTablePanel() {
        return new RulePanel$RuleTablePanel(this, new GridBagLayout());
    }

    protected void displayDefineFunctionDialog() {
        Cloneable cloneable = (ReleaseFuncOpRule)this._currentRuleRef.getRule();
        if (cloneable == null) {
            return;
        }
        if (this._independentVariableDialog == null) {
            this._independentVariableDialog = new IndependentVariableDialog((Dialog)SwingUtilities.windowForComponent((Component)((Object)this)), true);
        }
        this._independentVariableDialog.setNetwork(((OpRule)((Object)cloneable)).getRssSystem());
        this._independentVariableDialog.setElement((Element)((Object)((OpRule)((Object)cloneable)).getOperationsElement()));
        if (this._independentVariable != null) {
            this._independentVariableDialog.setIndependentVariable(this._independentVariable);
        }
        this._independentVariableDialog.setVisible(true);
        if (!this._independentVariableDialog.isCanceled()) {
            cloneable = this._independentVariable;
            this._independentVariable = this._independentVariableDialog.getIndependentVariable();
            int n = this._independentVariable.getType();
            RulePanel rulePanel = this;
            Object object = rulePanel.buildFunctionOfString(rulePanel._independentVariable);
            this._functionOfTxt.setText((String)object);
            object = null;
            if (cloneable != null) {
                int n2 = ((IndependentVariable)cloneable).getType();
                if (!(n2 != 0 && n2 != 1 || n != 0 && n != 1)) {
                    if (!this._currentPanel.isEmpty()) {
                        object = this._currentPanel.saveTable();
                    }
                } else if (n == 3 && n == n2) {
                    if (!this._currentPanel.isEmpty()) {
                        object = this._currentPanel.saveTable();
                    }
                } else if (this._independentVariable.areTheSame((IndependentVariable)cloneable)) {
                    this.setModified(true);
                    return;
                }
            }
            this.setFunctionType(n, object);
            this.setModified(true);
        }
    }

    public void setRuleRef(OpRuleRef opRuleRef) {
        if (opRuleRef == null) {
            return;
        }
        if (this.isModified()) {
            this.savePanel();
        }
        this._currentRuleRef = opRuleRef;
        this.fillPanel();
    }

    public void setParent(JPanel jPanel) {
        this._parent = (DefaultJPanel)jPanel;
    }

    public void fillPanel() {
        this.clearPanel();
        ReleaseFuncOpRule releaseFuncOpRule = (ReleaseFuncOpRule)this._currentRuleRef.getRule();
        this.fillPanel(releaseFuncOpRule);
    }

    public void clearPanel() {
        this._currentFunctionType = -1;
        this._currentPanel = null;
        this._independentVariable = null;
        this._datePanel.clearPanel();
        this._dateTimePanel.clearPanel();
        this._seasonalVariablePanel.clearPanel();
        this._modelVariablePanel.clearPanel();
    }

    public void fillPanel(ReleaseFuncOpRule releaseFuncOpRule) {
        SeasonalPairedValues seasonalPairedValues;
        IndependentVariable independentVariable;
        if (releaseFuncOpRule == null) {
            return;
        }
        int n = -1;
        this._independentVariable = independentVariable = releaseFuncOpRule.getIndependentVariable();
        if (independentVariable != null) {
            n = independentVariable.getType();
        }
        if (n == 2 || n == 3 || n == 4 || 6 == n) {
            seasonalPairedValues = releaseFuncOpRule.getFunctionRelease();
            boolean bl = seasonalPairedValues.hasSeasonalVariation();
            this._seasonalVariationCB.setEnabled(true);
            this._seasonalVariationCB.setSelected(bl);
        } else {
            this._seasonalVariationCB.setSelected(false);
            this._seasonalVariationCB.setEnabled(false);
            seasonalPairedValues = releaseFuncOpRule.getSeasonalRecord();
        }
        TimeOfDayMultiplier cloneable = releaseFuncOpRule.getTimeOfDayMultiplier();
        this._hourOfDayMultiplyerCB.setSelected(cloneable != null && releaseFuncOpRule.useTimeOfDayMultiplier());
        DayOfWeekMultiplier bl = releaseFuncOpRule.getMultiplier();
        this._dayOfWeekMultiplerCB.setSelected(bl != null && releaseFuncOpRule.useDayOfWeekMultiplier());
        this._risingFallingConditionCB.setSelected(releaseFuncOpRule.getEnableRiseFallCondition() && releaseFuncOpRule.riseFallConditionIsValid());
        int n2 = releaseFuncOpRule.getPeriod();
        boolean bl2 = n2 != 0;
        this._periodAverageLimitCB.setSelected(bl2);
        this._hourOfDayMultiplyerCB.setEnabled(!bl2);
        this._dayOfWeekMultiplerCB.setEnabled(!bl2);
        if (((OpRule)releaseFuncOpRule).isDnstrmRule()) {
            this._flowContingencyCB.setVisible(true);
            this._flowContingencyCB.setSelected(((DownstreamOpRule)releaseFuncOpRule).usesContingency());
        } else {
            this._flowContingencyCB.setVisible(false);
        }
        this._oldRuleName = releaseFuncOpRule.getName();
        this._nameDescPanel.setName(releaseFuncOpRule.getName());
        this._nameDescPanel.setDescription(releaseFuncOpRule.getDescription());
        this._limitTypeCombo.removeItemListener(this._limitTypeComboListener);
        if (releaseFuncOpRule.getLimitType() == -1) {
            this._limitTypeCombo.setSelectedItem((Object)LIMIT_TYPE_MIN);
        } else if (releaseFuncOpRule.getLimitType() == 1) {
            this._limitTypeCombo.setSelectedItem((Object)LIMIT_TYPE_MAX);
        } else if (releaseFuncOpRule.getLimitType() == 0) {
            this._limitTypeCombo.setSelectedItem((Object)LIMIT_TYPE_SPECIFIED);
        } else if (releaseFuncOpRule.getLimitType() == 2) {
            this._limitTypeCombo.setSelectedItem((Object)LIMIT_TYPE_DEMAND);
        } else {
            this._limitTypeCombo.setSelectedIndex(-1);
        }
        this._limitTypeCombo.addItemListener(this._limitTypeComboListener);
        this.setFunctionType(n, seasonalPairedValues);
        this.setModified(false);
    }

    public void setFunctionType(int n, Object object) {
        boolean bl = this._seasonalVariationCB.isSelected();
        this._currentFunctionType = n;
        ReleaseFuncOpRule releaseFuncOpRule = (ReleaseFuncOpRule)this._currentRuleRef.getRule();
        RulePanel rulePanel = this;
        String string = rulePanel.buildFunctionOfString(rulePanel._independentVariable);
        this._functionOfTxt.setText(string);
        this._seasonalVariationCB.setEnabled(false);
        if (releaseFuncOpRule == null) {
            return;
        }
        int n2 = 0;
        this._functionOfTxt.setToolTipText(null);
        if (n == 2 || n == 3 || n == 4 || 6 == n) {
            this._xParamId = -1;
            if (n == 2) {
                ModelVariable modelVariable = this._independentVariable.getModelVariable();
                if (modelVariable != null) {
                    this._xParamId = modelVariable.getParamId();
                    this._xParamString = Parameter.getParamString((int)this._xParamId);
                }
            } else if (n == 4) {
                StateVariable stateVariable = releaseFuncOpRule.getOperationsElement().getSystem().getStateVariable(this._independentVariable.getStateVariableId());
                if (stateVariable != null) {
                    this._xParamString = stateVariable.getParamName();
                    try {
                        stateVariable = new Parameter(stateVariable.getParamType());
                        this._xParamId = stateVariable.getParameterId();
                    }
                    catch (DataSetIllegalArgumentException dataSetIllegalArgumentException) {
                        System.out.println("setFunctionType:Illegal Parameter " + String.valueOf((Object)dataSetIllegalArgumentException));
                        this._xParamId = -1;
                    }
                    this._functionOfTxt.setToolTipText("State Variable");
                }
            } else if (n == 6) {
                GlobalVariable globalVariable = releaseFuncOpRule.getOperationsElement().getSystem().getGlobalVariable(this._independentVariable.getGlobalVariableId());
                if (globalVariable instanceof TimeSeriesGlobalVariable) {
                    globalVariable = (TimeSeriesGlobalVariable)globalVariable;
                    this._xParamString = ((TimeSeriesGlobalVariable)globalVariable).getParameterType();
                    try {
                        globalVariable = new Parameter(this._xParamString);
                        this._xParamId = globalVariable.getParameterId();
                    }
                    catch (DataSetIllegalArgumentException dataSetIllegalArgumentException) {
                        System.out.println("setFunctionType:Illegal Parameter " + String.valueOf((Object)dataSetIllegalArgumentException));
                        this._xParamId = -1;
                    }
                    this._functionOfTxt.setToolTipText("Global Variable");
                }
            } else {
                this._xParamString = this._independentVariable.getTimeSeriesName();
                this._xParamId = -1;
                this._functionOfTxt.setToolTipText("External Variable");
            }
            if (bl) {
                if (!(object instanceof SeasonalPairedValues) && !(object instanceof PairedValues)) {
                    object = new SeasonalPairedValues();
                }
                ((SeasonalPairedValues)object).setParamXId(this._xParamId);
                ((SeasonalPairedValues)object).setParamYId(this._yParamId);
                ((SeasonalPairedValues)object).setUnitSystem(releaseFuncOpRule.getUnitSystem());
                this._seasonalVariablePanel.setData(object);
                ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, a[2]);
                this._currentPanel = this._seasonalVariablePanel;
                n2 = ((SeasonalPairedValues)object).getInterpolationType();
            } else {
                if (object instanceof SeasonalPairedValues) {
                    object = ((SeasonalPairedValues)object).getPairedValues();
                    object.setParamXId(this._xParamId);
                    ((PairedValues)object).setParamYId(this._yParamId);
                }
                if (!(object instanceof PairedValues)) {
                    object = new PairedValues();
                    object.setParamXId(this._xParamId);
                    ((PairedValues)object).setParamYId(this._yParamId);
                    ((PairedValues)object).setUnitSystem(releaseFuncOpRule.getUnitSystem());
                }
                this._modelVariablePanel.setData(object);
                ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, a[3]);
                this._currentPanel = this._modelVariablePanel;
                n2 = ((PairedValues)object).getInterpolationType();
            }
            this._seasonalVariationCB.setEnabled(true);
        } else if (n == 0) {
            SeasonalRecord seasonalRecord;
            if (object instanceof SeasonalRecord) {
                seasonalRecord = (SeasonalRecord)object;
            } else if (!this._datePanel.isEmpty()) {
                seasonalRecord = (SeasonalRecord)this._datePanel.saveTable();
            } else {
                seasonalRecord = new SeasonalRecord();
                seasonalRecord.setParameterId(this._yParamId);
                seasonalRecord.setUnitSystem(releaseFuncOpRule.getUnitSystem());
                seasonalRecord.setGmtOffset(releaseFuncOpRule.getGmtOffset());
            }
            this._datePanel.setData(seasonalRecord);
            ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, a[0]);
            this._currentPanel = this._datePanel;
            n2 = seasonalRecord.getInterpolationType();
            this._seasonalVariationCB.setSelected(false);
        } else if (n == 1) {
            SeasonalRecord seasonalRecord;
            if (object instanceof SeasonalRecord) {
                seasonalRecord = (SeasonalRecord)object;
            } else if (!this._dateTimePanel.isEmpty()) {
                seasonalRecord = (SeasonalRecord)this._dateTimePanel.saveTable();
            } else {
                seasonalRecord = new SeasonalRecord();
                seasonalRecord.setParameterId(this._yParamId);
                seasonalRecord.setUnitSystem(releaseFuncOpRule.getUnitSystem());
                seasonalRecord.setGmtOffset(releaseFuncOpRule.getGmtOffset());
            }
            this._dateTimePanel.setData(seasonalRecord);
            ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, a[1]);
            this._currentPanel = this._dateTimePanel;
            n2 = seasonalRecord.getInterpolationType();
            this._seasonalVariationCB.setSelected(false);
        } else {
            ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, a[4]);
            this._currentPanel = this._blankPanel;
        }
        this._interpolationCombo.removeItemListener(this._interpComboListener);
        if (n2 == 1) {
            this._interpolationCombo.setSelectedItem((Object)"Cubic");
        } else if (n2 == 2) {
            this._interpolationCombo.setSelectedItem((Object)"Step");
        } else {
            this._interpolationCombo.setSelectedItem((Object)"Linear");
        }
        this._interpolationCombo.addItemListener(this._interpComboListener);
        this._currentPanel.rebuildTableColumnLabels();
        this.plotTable();
        Window window = SwingUtilities.windowForComponent((Component)((Object)this));
        if (window instanceof RmaJDialog) {
            ((RmaJDialog)window).updateUnitSystem((Container)((Object)this));
            ((RmaJDialog)window).updateTimeZone((Container)((Object)this));
            return;
        }
        if (window instanceof RmaJFrame) {
            ((RmaJFrame)window).updateUnitSystem((Container)((Object)this));
            ((RmaJFrame)window).updateTimeZone((Container)((Object)this));
        }
    }

    protected void setYParamId(int n) {
        this._yParamId = n;
        this._yParamString = Parameter.getParamString((int)this._yParamId);
    }

    public String buildFunctionOfString(IndependentVariable independentVariable) {
        if (independentVariable == null) {
            return "Function Not Defined";
        }
        return independentVariable.buildFunctionOfString((ReleaseFuncOpRule)this._currentRuleRef.getRule());
    }

    public void plotTable() {
        Vector<G2dData> vector = new Vector<G2dData>();
        if (this._currentFunctionType != -1 && this._currentPanel != null && this._currentPanel.getPlotObjects() != null) {
            G2dData g2dData = this._currentPanel.getPlotObjects();
            this._currentPanel.getPlotObjects().name = "Function of: " + this._functionOfTxt.getText();
            g2dData.lineStyleName = "Flow";
            if (g2dData != null) {
                vector.add(g2dData);
            }
        }
        this._plotPanel.clearPanel();
        if (this._currentFunctionType == 0 || this._currentFunctionType == 1) {
            RulePanel rulePanel = this;
            rulePanel.configureSeasonalRecordPlot(rulePanel._plotPanel);
        } else {
            RulePanel rulePanel = this;
            rulePanel.configurePairedValuesPlot(rulePanel._plotPanel);
        }
        int n = ClientApp.app().getClientUnitSystem();
        this._plotPanel.setPlotObjects(vector);
        this._plotPanel.setDisplayUnitsSystem(n);
        this._plotPanel.paintGfx();
        this._plotPanel.revalidate();
    }

    protected void configureSeasonalRecordPlot(G2dPanel g2dPanel) {
        int n;
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        g2dPlotProp.x1AxisProp.name = "Minutes";
        g2dPlotProp.x1AxisProp.type = 2;
        g2dPlotProp.y1AxisProp.name = this._yParamString + this.getAdditionalYParamString() + " (%S" + this.getAdditionalYUnitsString() + ")";
        g2dPlotProp.x1AxisProp.numTicLabelLayers = 1;
        g2dPlotProp.hasX1Label = false;
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPlotProp.x1AxisProp.isDefaultLimits = false;
        g2dPlotProp.x1TicsProp.majorTicFontSize = n = new JLabel().getFont().getSize();
        g2dPlotProp.x1TicsProp.majorTicMinFontSize = n;
        g2dPlotProp.x1TicsProp.majorTicMaxFontSize = n;
        g2dPlotProp.x1TicsProp.majorTicTinyFontSize = n;
        g2dPlotProp.y1TicsProp.majorTicFontSize = n;
        g2dPlotProp.y1TicsProp.majorTicMinFontSize = n;
        g2dPlotProp.y1TicsProp.majorTicMaxFontSize = n;
        g2dPlotProp.y1TicsProp.majorTicTinyFontSize = n;
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPlotProp.y1LabelProp.fontSize = n;
        g2dPlotProp.y1LabelProp.minFontSize = n;
        g2dPlotProp.y1LabelProp.maxFontSize = n;
        g2dPlotProp.y1LabelProp.tinyFontSize = n;
        g2dPlotProp.y1LabelProp.useFontScaling = false;
        g2dPlotProp.x1LabelProp.fontSize = n;
        g2dPlotProp.x1LabelProp.minFontSize = n;
        g2dPlotProp.x1LabelProp.maxFontSize = n;
        g2dPlotProp.x1LabelProp.tinyFontSize = n;
        g2dPlotProp.x1LabelProp.useFontScaling = false;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }

    protected void configurePairedValuesPlot(G2dPanel g2dPanel) {
        int n;
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        g2dPlotProp.x1AxisProp.name = this._xParamId == -1 ? this._xParamString : this._xParamString + " (%S)";
        g2dPlotProp.y1AxisProp.name = this._yParamString + this.getAdditionalYParamString() + " (%S" + this.getAdditionalYUnitsString() + ")";
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPlotProp.x1TicsProp.majorTicFontSize = n = new JLabel().getFont().getSize();
        g2dPlotProp.x1TicsProp.majorTicMinFontSize = n;
        g2dPlotProp.x1TicsProp.majorTicMaxFontSize = n;
        g2dPlotProp.x1TicsProp.majorTicTinyFontSize = n;
        g2dPlotProp.y1TicsProp.majorTicFontSize = n;
        g2dPlotProp.y1TicsProp.majorTicMinFontSize = n;
        g2dPlotProp.y1TicsProp.majorTicMaxFontSize = n;
        g2dPlotProp.y1TicsProp.majorTicTinyFontSize = n;
        g2dPlotProp.y1LabelProp.fontSize = n;
        g2dPlotProp.y1LabelProp.minFontSize = n;
        g2dPlotProp.y1LabelProp.maxFontSize = n;
        g2dPlotProp.y1LabelProp.tinyFontSize = n;
        g2dPlotProp.y1LabelProp.useFontScaling = false;
        g2dPlotProp.x1LabelProp.fontSize = n;
        g2dPlotProp.x1LabelProp.minFontSize = n;
        g2dPlotProp.x1LabelProp.maxFontSize = n;
        g2dPlotProp.x1LabelProp.tinyFontSize = n;
        g2dPlotProp.x1LabelProp.useFontScaling = false;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }

    public boolean savePanel() {
        if (this._currentRuleRef == null) {
            return false;
        }
        ReleaseFuncOpRule releaseFuncOpRule = (ReleaseFuncOpRule)this._currentRuleRef.getRule();
        if (releaseFuncOpRule == null) {
            return false;
        }
        if (this._nameDescPanel.getName().equals("") && this.isVisible()) {
            RMAIO.postError((Component)((Object)this), (String)"Cannot have an empty rule name!");
            return false;
        }
        releaseFuncOpRule.setName(this._nameDescPanel.getName());
        this._currentRuleRef.setName(this._nameDescPanel.getName());
        this._oldRuleName = this._nameDescPanel.getName();
        releaseFuncOpRule.setDescription(this._nameDescPanel.getDescription());
        String string = (String)this._limitTypeCombo.getSelectedItem();
        if (LIMIT_TYPE_MIN.equals(string)) {
            releaseFuncOpRule.setLimitType(-1);
        } else if (LIMIT_TYPE_MAX.equals(string)) {
            releaseFuncOpRule.setLimitType(1);
        } else if (LIMIT_TYPE_SPECIFIED.equals(string)) {
            releaseFuncOpRule.setLimitType(0);
        } else if (LIMIT_TYPE_DEMAND.equals(string)) {
            releaseFuncOpRule.setLimitType(2);
        } else {
            RMAIO.postError((Component)((Object)this), (String)("Rule, " + releaseFuncOpRule.getName() + ", cannot have an empty Limit Type!"));
        }
        string = this._interpolationCombo.getSelectedItem().toString();
        int n = 0;
        if (string.equals("Cubic")) {
            n = 1;
        }
        if (string.equals("Step")) {
            n = 2;
        }
        if (this._currentFunctionType == -1) {
            return true;
        }
        releaseFuncOpRule.setIndependentVariable(this._independentVariable);
        if (this._currentPanel instanceof RulePanel$DateTablePanel || this._currentPanel instanceof RulePanel$DateTimeTablePanel) {
            string = (SeasonalRecord)this._currentPanel.saveTable();
            string.setInterpolationType(n);
            releaseFuncOpRule.setSeasonalRecord((SeasonalRecord)string);
        } else if (this._currentPanel instanceof RulePanel$PairedValuesPanel) {
            string = (PairedValues)this._currentPanel.saveTable();
            string.setInterpolationType(n);
            SeasonalPairedValues seasonalPairedValues = new SeasonalPairedValues();
            seasonalPairedValues.setData((PairedValues)string, "01Jan");
            seasonalPairedValues.setHasSeasonalVariation(false);
            releaseFuncOpRule.setFunctionRelease(seasonalPairedValues);
        } else if (this._currentPanel instanceof RulePanel$SeasonalPairedValuesPanel) {
            string = (SeasonalPairedValues)this._currentPanel.saveTable();
            string.setInterpolationType(n);
            string.setHasSeasonalVariation(true);
            releaseFuncOpRule.setFunctionRelease((SeasonalPairedValues)string);
        }
        releaseFuncOpRule.setUseTimeOfDayMultiplier(this._hourOfDayMultiplyerCB.isSelected());
        releaseFuncOpRule.setUseDayOfWeekMultiplier(this._dayOfWeekMultiplerCB.isSelected());
        releaseFuncOpRule.setEnableRiseFallCondition(this._risingFallingConditionCB.isSelected());
        releaseFuncOpRule.setPeriodAverageLimit(this._periodAverageLimitCB.isSelected());
        if (((OpRule)releaseFuncOpRule).isDnstrmRule()) {
            ((DownstreamOpRule)releaseFuncOpRule).setUsesContingency(this._flowContingencyCB.isSelected());
        }
        this.setModified(false);
        return true;
    }

    public void editPeriodAverageLimit() {
        ReleaseFuncOpRule releaseFuncOpRule = (ReleaseFuncOpRule)this._currentRuleRef.getRule();
        if (releaseFuncOpRule == null) {
            return;
        }
        Object object = SwingUtilities.windowForComponent((Component)((Object)this));
        if (this._periodAverageLimitDialog == null) {
            this._periodAverageLimitDialog = new PeriodAverageLimitDialog((Dialog)object, true);
            this._periodAverageLimitDialog.setLocationRelativeTo((Component)object);
        }
        this._periodAverageLimitDialog.setPeriod(releaseFuncOpRule.getPeriod());
        this._periodAverageLimitDialog.setStartingDay(releaseFuncOpRule.getStartingDay());
        object = (PowerGenerationPatternContainer)releaseFuncOpRule.getPatternContainer().clone();
        this._periodAverageLimitDialog.setPatternContainer((PowerGenerationPatternContainer)object);
        this._periodAverageLimitDialog.fillForm();
        this._periodAverageLimitDialog.setVisible(true);
        if (!this._periodAverageLimitDialog.isCanceled()) {
            int n = this._periodAverageLimitDialog.getPeriod();
            releaseFuncOpRule.setPeriod(n);
            releaseFuncOpRule.setStartingDay(this._periodAverageLimitDialog.getStartingDay());
            releaseFuncOpRule.setPatternContainer((PowerGenerationPatternContainer)object);
            this.setModified(true);
            if (n != 0) {
                this._periodAverageLimitCB.setSelected(true);
                this._hourOfDayMultiplyerCB.setEnabled(false);
                this._dayOfWeekMultiplerCB.setEnabled(false);
                return;
            }
            this._periodAverageLimitCB.setSelected(false);
            this._hourOfDayMultiplyerCB.setEnabled(true);
            this._dayOfWeekMultiplerCB.setEnabled(true);
        }
    }

    public void editHourOfDayMultiplier() {
        boolean bl;
        Window window = SwingUtilities.windowForComponent((Component)((Object)this));
        Object object = "Hour of Day Multiplier";
        object = new TimeOfDayMultiplierJDialog((Dialog)window, (String)object, true);
        OpRule opRule = this._currentRuleRef.getRule();
        TimeOfDayMultiplier timeOfDayMultiplier = opRule.getTimeOfDayMultiplier();
        boolean bl2 = bl = timeOfDayMultiplier == null || timeOfDayMultiplier.isDefaults();
        if (timeOfDayMultiplier == null) {
            timeOfDayMultiplier = new TimeOfDayMultiplier();
        }
        ((TimeOfDayMultiplierJDialog)object).setData(timeOfDayMultiplier);
        ((TimeOfDayMultiplierJDialog)object).setColumnLabels(new String[]{"Time of Day", "Multiplier"});
        object.setLocationRelativeTo((Component)window);
        ((TimeOfDayMultiplierJDialog)object).setVisible(true);
        if (!((TimeOfDayMultiplierJDialog)object).isCanceled()) {
            timeOfDayMultiplier = ((TimeOfDayMultiplierJDialog)object).getData();
            if (!bl || !timeOfDayMultiplier.isDefaults()) {
                this.setModified(true);
            }
            if (timeOfDayMultiplier.isDefaults()) {
                timeOfDayMultiplier = null;
            }
            opRule.setTimeOfDayMultiplier(timeOfDayMultiplier);
            if (timeOfDayMultiplier != null && bl) {
                this._hourOfDayMultiplyerCB.setSelected(true);
            }
        }
        if ((timeOfDayMultiplier = opRule.getTimeOfDayMultiplier()) == null || timeOfDayMultiplier.isDefaults()) {
            this._hourOfDayMultiplyerCB.setSelected(false);
        }
    }

    void editDayOfWeekMultiplier() {
        Object object = SwingUtilities.windowForComponent((Component)((Object)this));
        if (object instanceof Dialog) {
            boolean bl;
            Object object2 = "Day of Week Multiplier";
            object = new DayOfWeekMultiplierJDialog((Dialog)object, (String)object2, true);
            object2 = this._currentRuleRef.getRule();
            if (object2 == null) {
                return;
            }
            DayOfWeekMultiplier dayOfWeekMultiplier = ((OpRule)object2).getMultiplier();
            boolean bl2 = bl = dayOfWeekMultiplier == null || dayOfWeekMultiplier.isDefaults();
            if (dayOfWeekMultiplier == null) {
                dayOfWeekMultiplier = new DayOfWeekMultiplier();
            }
            ((DayOfWeekMultiplierJDialog)((Object)object)).setData(dayOfWeekMultiplier);
            ((DayOfWeekMultiplierJDialog)((Object)object)).setVisible(true);
            if (!((DayOfWeekMultiplierJDialog)((Object)object)).isCanceled()) {
                dayOfWeekMultiplier = ((DayOfWeekMultiplierJDialog)((Object)object)).getData();
                if (!bl || !dayOfWeekMultiplier.isDefaults()) {
                    this.setModified(true);
                }
                if (dayOfWeekMultiplier.isDefaults()) {
                    dayOfWeekMultiplier = null;
                }
                ((OpRule)object2).setMultiplier(dayOfWeekMultiplier);
                if (dayOfWeekMultiplier != null && bl) {
                    this._dayOfWeekMultiplerCB.setSelected(true);
                }
            }
            if ((dayOfWeekMultiplier = ((OpRule)object2).getMultiplier()) == null || dayOfWeekMultiplier.isDefaults()) {
                this._dayOfWeekMultiplerCB.setSelected(false);
            }
        }
    }

    void editRisingFallingCondition() {
        Window window = SwingUtilities.windowForComponent((Component)((Object)this));
        if (this._currentRuleRef == null) {
            return;
        }
        OpRule opRule = this._currentRuleRef.getRule();
        if (opRule == null) {
            return;
        }
        RisingFallingCondDialog risingFallingCondDialog = new RisingFallingCondDialog((Dialog)window, true);
        risingFallingCondDialog.fillForm(this._currentRuleRef.getRule());
        risingFallingCondDialog.setLocationRelativeTo(window);
        risingFallingCondDialog.setVisible(true);
        if (risingFallingCondDialog.isOk()) {
            this.setModified(true);
        }
        if (!opRule.riseFallConditionIsValid()) {
            this._risingFallingConditionCB.setSelected(false);
        }
    }

    void editSeasonalVariation() {
        if (!(this._currentPanel instanceof RulePanel$SeasonalPairedValuesPanel) && !(this._currentPanel instanceof RulePanel$PairedValuesPanel)) {
            return;
        }
        int[] nArray = this._seasonalVariablePanel.getTimes();
        if (nArray == null || nArray.length == 0 || this._currentPanel instanceof RulePanel$PairedValuesPanel) {
            nArray = new int[]{1440};
        }
        Window window = SwingUtilities.windowForComponent(this._cardPanel);
        SeasonalVariationJDialog seasonalVariationJDialog = new SeasonalVariationJDialog((Dialog)window, true);
        int n = this._seasonalVariablePanel.getTimeInterpolation();
        seasonalVariationJDialog.setLocationRelativeTo(window);
        seasonalVariationJDialog.fillForm(nArray, n);
        seasonalVariationJDialog.setVisible(true);
        if (seasonalVariationJDialog.isCanceled()) {
            if (this._currentPanel instanceof RulePanel$PairedValuesPanel) {
                this.selectSeasonalVariation(false);
            }
            return;
        }
        nArray = seasonalVariationJDialog.getDateTimes();
        if (nArray.length > 1) {
            this.selectSeasonalVariation(true);
            this._seasonalVariablePanel.resetTimes(seasonalVariationJDialog.getDateTimes(), seasonalVariationJDialog.getIndices());
            this._seasonalVariablePanel.setTimeInterpolation(seasonalVariationJDialog.getInterpolationType());
        } else if (nArray.length <= 1) {
            this.selectSeasonalVariation(false);
        }
        this.setModified(true);
        this.plotTable();
    }

    void selectSeasonalVariation(boolean bl) {
        this._seasonalVariationCB.setSelected(bl);
        if (bl) {
            if (this._currentPanel instanceof RulePanel$PairedValuesPanel) {
                Object object = null;
                if (this._seasonalVariablePanel.isEmpty()) {
                    PairedValues pairedValues = (PairedValues)((RulePanel$PairedValuesPanel)this._currentPanel).saveTable();
                    if (pairedValues != null && pairedValues.size() > 0) {
                        object = new SeasonalPairedValues();
                        object.setData(pairedValues, "01Jan");
                    }
                } else {
                    object = this._seasonalVariablePanel.saveTable();
                }
                RulePanel rulePanel = this;
                rulePanel.setFunctionType(rulePanel._independentVariable.getType(), object);
                return;
            }
        } else if (this._currentPanel instanceof RulePanel$SeasonalPairedValuesPanel) {
            Object object = null;
            if (this._modelVariablePanel.isEmpty()) {
                if (!this._seasonalVariablePanel.isEmpty()) {
                    SeasonalPairedValues seasonalPairedValues = (SeasonalPairedValues)((RulePanel$SeasonalPairedValuesPanel)this._currentPanel).saveTable();
                    object = seasonalPairedValues.getPairedValues();
                }
            } else {
                object = this._modelVariablePanel.saveTable();
            }
            RulePanel rulePanel = this;
            rulePanel.setFunctionType(rulePanel._independentVariable.getType(), object);
        }
    }

    void editFlowContingency() {
        Window window = SwingUtilities.windowForComponent((Component)((Object)this));
        if (window instanceof Dialog && this._currentRuleRef.getRule().isDnstrmRule()) {
            FlowContingencyDialog flowContingencyDialog = new FlowContingencyDialog((Dialog)window, (JPanel)((Object)this), true);
            flowContingencyDialog.fillForm();
            flowContingencyDialog.setLocationRelativeTo(window);
            flowContingencyDialog.setVisible(true);
            if (!flowContingencyDialog.isCancelled()) {
                window = flowContingencyDialog.getContingencyPV();
                if (window.size() > 0 || flowContingencyDialog.getContingencyConstant() != 0.0) {
                    this._flowContingencyCB.setSelected(true);
                } else if (window.size() <= 0 && flowContingencyDialog.getContingencyConstant() == 0.0) {
                    this._flowContingencyCB.setSelected(false);
                }
                this.setModified(true);
            }
        }
    }

    private String getDefaultTime() {
        Object object = "";
        try {
            ClientWorkspace clientWorkspace = ClientApp.Workspace();
            clientWorkspace = ((RssRmiWorkspace)clientWorkspace.getChildWorkspace("rss")).getStartOfWaterYear();
            object = clientWorkspace.date(104);
            object = ((String)object).substring(0, 5);
            object = (String)object + " 0000";
        }
        catch (RemoteException remoteException) {
            System.out.println("Error Setting water year start - " + remoteException.getMessage());
            System.out.println("Resuming as normal");
        }
        return object;
    }

    protected String getAdditionalYParamString() {
        return "";
    }

    protected String getAdditionalYUnitsString() {
        return "";
    }

    protected void limitTypeComboChanged() {
    }
}

