/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.model.SimulationRun;
import hec.model.AltItem;
import hec.model.RunInfo;
import hec.rss.client.RSimSimulationMode;
import hec.rss.model.ComputeStatus;
import hec.rss.model.RssRun;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Vector;
import java.util.logging.Logger;

public class RunDetailsUtilities {
    private static final DateTimeFormatter a = DateTimeFormatter.ofPattern("dd MMM yyyy, HH:mm");

    public static String a(long l) {
        if (l == 0L) {
            return " ";
        }
        Comparable<Instant> comparable = Instant.ofEpochMilli(l);
        comparable = LocalDateTime.ofInstant(comparable, ZoneId.systemDefault());
        return ((LocalDateTime)comparable).format(a);
    }

    public static String a(SimulationRun simulationRun, long l, long l2, long l3) {
        String string;
        RssRun rssRun = RunDetailsUtilities.b(simulationRun);
        if (rssRun != null) {
            ComputeStatus computeStatus = rssRun.getLastComputeStatus();
            switch (computeStatus) {
                case FAILED: {
                    if (l2 < rssRun.getLastModifiedTime()) {
                        computeStatus = ComputeStatus.CHANGED;
                    }
                }
                case NOT_COMPUTED: {
                    break;
                }
                case CANCELED: {
                    if (l3 >= rssRun.getLastModifiedTime()) break;
                    computeStatus = ComputeStatus.CHANGED;
                    break;
                }
                default: {
                    if (l >= rssRun.getLastModifiedTime()) break;
                    computeStatus = ComputeStatus.CHANGED;
                }
            }
            string = RunDetailsUtilities.a(computeStatus);
        } else {
            string = RunDetailsUtilities.a(ComputeStatus.NOT_COMPUTED);
        }
        Logger.getLogger(RunDetailsUtilities.class.getName()).fine("Compute Status text for " + String.valueOf(simulationRun) + "=" + string);
        return string;
    }

    public static AltItem a(SimulationRun object) {
        Vector vector = object.getAltList();
        object = object.getUserName();
        AltItem altItem = null;
        for (int i = 0; i < vector.size(); ++i) {
            AltItem altItem2 = (AltItem)vector.get(i);
            if (!altItem2.getAltName().equals(object)) continue;
            altItem = altItem2;
            break;
        }
        if (altItem == null && !vector.isEmpty()) {
            altItem = (AltItem)vector.get(0);
        }
        return altItem;
    }

    public static RssRun b(SimulationRun object) {
        if (ClientApp.frame().getCurrentModule() instanceof RSimSimulationMode && (object = ((RSimSimulationMode)ClientApp.frame().getCurrentModule()).getRunInfo((SimulationRun)object)).get(0) != null) {
            object = (RunInfo)object.get(0);
            return ((RSimSimulationMode)ClientApp.frame().getCurrentModule()).getRssRun(((RunInfo)object).runName);
        }
        return null;
    }

    private static String a(ComputeStatus computeStatus) {
        if (computeStatus == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<font color=\"");
        switch (computeStatus) {
            case CANCELED: {
                stringBuilder.append("red");
                break;
            }
            case SUCCESSFUL: {
                stringBuilder.append("green");
                break;
            }
            case FAILED: {
                stringBuilder.append("red");
                break;
            }
            case CHANGED: {
                stringBuilder.append("blue");
                break;
            }
            case NOT_COMPUTED: {
                stringBuilder.append("black");
                break;
            }
            case SKIPPED: {
                stringBuilder.append("green");
                break;
            }
            case UNKNOWN: {
                stringBuilder.append("orange");
            }
        }
        stringBuilder.append("\">");
        stringBuilder.append(computeStatus.getUIName());
        stringBuilder.append("</font>");
        return stringBuilder.toString();
    }
}

