/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import com.google.common.flogger.FluentLogger;
import hec.rss.client.AbstractScriptBuilderPanel;
import hec.rss.client.ScriptBuilderPanel$1;
import hec.rss.client.ScriptPanel;
import hec.rss.model.RssSystem;
import hec.rss.model.StateVariable;
import hec.script.gui.ScriptTreeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.text.BadLocationException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import mil.army.usace.hec.script.gui.AbstractScriptBuilderPanel;
import org.fife.ui.rtextarea.RecordableTextAction;
import rma.swing.RmaInsets;
import rma.swing.RmaJTextField;
import rma.swing.event.ReflectMultiListener;

public class ScriptBuilderPanel
extends AbstractScriptBuilderPanel {
    private ScriptPanel _parentPanel;
    private transient ReflectMultiListener c = new ReflectMultiListener();

    ScriptBuilderPanel(ScriptPanel object) {
        this._parentPanel = object;
        object = this.getTree();
        ((JTree)object).addTreeSelectionListener(arg_0 -> this.lambda$new$0((JTree)object, arg_0));
        this._functionText.setVisible(false);
        this._scriptText.addCaretListener(caretEvent -> this.updateLineColTxt());
        this._scriptText.getDocument().addDocumentListener(new ScriptBuilderPanel$1(this));
    }

    public void updateLengthField() {
        int n = this._scriptText.getDocument().getLength();
        this._parentPanel.getCharLengthText().setText(String.valueOf(n));
        if (n > ScriptBuilderPanel.a()) {
            this._parentPanel.getCharLengthText().setForeground(Color.RED);
            return;
        }
        this._parentPanel.getCharLengthText().setForeground(UIManager.getColor("TextField.foreground"));
    }

    public static int a() {
        return StateVariable.a();
    }

    private void updateLineColTxt() {
        try {
            int n = this._scriptText.getCaretPosition();
            int n2 = this._scriptText.getLineOfOffset(n);
            this._parentPanel.getLineColTxt().setText(n2 + 1 + ":" + ((n -= this._scriptText.getLineStartOffset(n2)) + 1));
            return;
        }
        catch (Exception exception) {
            System.out.println(exception);
            this._parentPanel.getLineColTxt().setText("");
            return;
        }
    }

    private void updateFunctionSyntaxTxt(JTree object) {
        RmaJTextField rmaJTextField = this._parentPanel.getFunctionSyntaxTxt();
        rmaJTextField.setText("");
        object = this.getSelectionFunctionString((JTree)object);
        if (object != null && !((String)object).isEmpty()) {
            rmaJTextField.setText((String)object);
        }
    }

    private String getSelectionFunctionString(JTree object) {
        String string = null;
        if ((object = ((JTree)object).getSelectionPath()) != null && (object = ((TreePath)object).getLastPathComponent()) instanceof ScriptTreeNode) {
            object = (ScriptTreeNode)object;
            string = object.getFunctionString();
        }
        return string;
    }

    protected void buildControls() {
        this.c = new ReflectMultiListener();
        super.buildControls();
    }

    protected JPanel buildButtons() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this._compileScriptBtn = new JButton("Compile Script");
        this._compileScriptBtn.setMnemonic('C');
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._compileScriptBtn, gridBagConstraints);
        this._externalEditorBtn = new JButton("Launch Editor");
        this._externalEditorBtn.setMnemonic('E');
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        if (System.getProperty("ScriptEditorExe") != null) {
            jPanel.add((Component)this._externalEditorBtn, gridBagConstraints);
        }
        this._runScriptBtn = new JButton("Run Script");
        this._runScriptBtn.setMnemonic('R');
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        if (System.getProperty("RunScriptBtn") != null) {
            jPanel.add((Component)this._runScriptBtn, gridBagConstraints);
        }
        return jPanel;
    }

    public void fillPanel(RssSystem rssSystem) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        if (rssSystem == null) {
            ((DefaultTreeModel)this.getTree().getModel()).setRoot(defaultMutableTreeNode);
            return;
        }
        this.setNetwork(rssSystem);
        this.loadTree("hec/rss/client/StateVariableTree.xml");
        this.updateMenus();
    }

    public void updateMenus() {
        RecordableTextAction recordableTextAction = AbstractScriptBuilderPanel.ScriptTextArea.getAction((int)6);
        JMenuItem jMenuItem = this.getUndoMenu();
        if (jMenuItem != null) {
            jMenuItem.setAction((Action)recordableTextAction);
            jMenuItem.setEnabled(true);
        }
    }

    private JMenuItem getUndoMenu() {
        JMenu jMenu = null;
        if (this._parentPanel != null) {
            jMenu = ScriptBuilderPanel.a(this._parentPanel.getRootPane().getJMenuBar(), "Edit");
            String string = "Undo";
            JMenuItem jMenuItem = null;
            if (jMenu != null) {
                int n = jMenu.getItemCount();
                for (int i = 0; i < n; ++i) {
                    JMenuItem jMenuItem2 = jMenu.getItem(i);
                    if (jMenuItem2 == null || !string.equals(jMenuItem2.getName()) && !string.equals(jMenuItem2.getText())) continue;
                    jMenuItem = jMenuItem2;
                    break;
                }
            }
            jMenu = jMenuItem;
        }
        return jMenu;
    }

    public static JMenu a(JMenuBar jMenuBar, String string) {
        JMenu jMenu = null;
        if (jMenuBar != null) {
            int n = jMenuBar.getMenuCount();
            for (int i = 0; i < n; ++i) {
                JMenu jMenu2 = jMenuBar.getMenu(i);
                if (jMenu2 == null || !string.equals(jMenu2.getName()) && !string.equals(jMenu2.getText())) continue;
                jMenu = jMenu2;
                break;
            }
        }
        return jMenu;
    }

    public void gotoLine(int n) {
        try {
            this._scriptText.scrollRectToVisible(this._scriptText.modelToView(this._scriptText.getLineStartOffset(n)));
            this._scriptText.setCaretPosition(this._scriptText.getLineStartOffset(n));
            return;
        }
        catch (BadLocationException badLocationException) {
            ((FluentLogger.Api)((FluentLogger.Api)FluentLogger.forEnclosingClass().atInfo()).withCause((Throwable)badLocationException)).log("gotoLine:error trying to go to line " + n);
            return;
        }
    }

    private /* synthetic */ void lambda$new$0(JTree jTree, TreeSelectionEvent treeSelectionEvent) {
        this.updateFunctionSyntaxTxt(jTree);
    }
}

