/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.rss.RssRmiWorkspace;
import hec.rss.client.AbstractScriptBuilderPanel;
import hec.rss.client.ScriptOpRulePanel$ScriptPanel;
import hec.rss.model.OpRuleRef;
import hec.rss.model.ScriptOpRule;
import hec.rss.model.StateVariable;
import hec.rss.server.RssAdvancedOptions;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.rmi.RemoteException;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import mil.army.usace.hec.rmi.model.PreferencesManager;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJDescriptionField;
import rma.swing.RmaJDssPathPartField;
import rma.swing.RmaJTextField;
import rma.util.RMAIO;

public class ScriptOpRulePanel
extends DefaultJPanel {
    public static final String XML_FILE_NAME = "hec/rss/client/ScriptRuleTree.xml";
    public static final String TEMPLATE_FILE_NAME = "ScriptOpRule.template";
    public static final String JAR_TEMPLATE_FILE = "hec/rss/client/ScriptOpRule.template";
    private OpRuleRef _currentRuleRef;
    private String _oldRuleName = "";
    private DefaultJPanel _parent = null;
    private JLabel _ruleNameLabel;
    private RmaJTextField _ruleNameTxt;
    private RmaJTextField _funcDescTxt;
    private JLabel _descriptionLabel;
    private RmaJDescriptionField _descriptionTxt;
    private ScriptOpRulePanel$ScriptPanel _scriptPanel;
    private RmaJCheckBox _useJavaClass;
    private RmaJTextField _javaClassPathField;
    private RssAdvancedOptions _opt = null;

    public ScriptOpRulePanel() {
        this.buildControls();
    }

    protected void buildControls() {
        this.setLayout(new GridBagLayout());
        this._ruleNameLabel = new JLabel("Script Operation Rule");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        ScriptOpRulePanel scriptOpRulePanel = this;
        scriptOpRulePanel.add(scriptOpRulePanel._ruleNameLabel, gridBagConstraints);
        this._ruleNameTxt = new RmaJDssPathPartField();
        this._ruleNameTxt.setModifiable(false);
        this._ruleNameTxt.setEditable(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        ScriptOpRulePanel scriptOpRulePanel2 = this;
        scriptOpRulePanel2.add((Component)scriptOpRulePanel2._ruleNameTxt, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.add(new JLabel(), gridBagConstraints);
        this._descriptionLabel = new JLabel("Description");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        ScriptOpRulePanel scriptOpRulePanel3 = this;
        scriptOpRulePanel3.add(scriptOpRulePanel3._descriptionLabel, gridBagConstraints);
        this._descriptionTxt = new RmaJDescriptionField();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        ScriptOpRulePanel scriptOpRulePanel4 = this;
        scriptOpRulePanel4.add((Component)scriptOpRulePanel4._descriptionTxt, gridBagConstraints);
        this._useJavaClass = new RmaJCheckBox("Use Java Class");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        ScriptOpRulePanel scriptOpRulePanel5 = this;
        scriptOpRulePanel5.add((Component)scriptOpRulePanel5._useJavaClass, gridBagConstraints);
        this._useJavaClass.addItemListener(itemEvent -> this.useJavaClassAction());
        this._javaClassPathField = new RmaJTextField();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        ScriptOpRulePanel scriptOpRulePanel6 = this;
        scriptOpRulePanel6.add((Component)scriptOpRulePanel6._javaClassPathField, gridBagConstraints);
        this._scriptPanel = new ScriptOpRulePanel$ScriptPanel(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        ScriptOpRulePanel scriptOpRulePanel7 = this;
        scriptOpRulePanel7.add((Component)((Object)scriptOpRulePanel7._scriptPanel), gridBagConstraints);
        this._funcDescTxt = new RmaJTextField();
        this._funcDescTxt.setEditable(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        ScriptOpRulePanel scriptOpRulePanel8 = this;
        scriptOpRulePanel8.add((Component)scriptOpRulePanel8._funcDescTxt, gridBagConstraints);
    }

    private void useJavaClassAction() {
        if (this._useJavaClass.isSelected()) {
            this._javaClassPathField.setEnabled(true);
            this._scriptPanel.setEnabled(false);
            return;
        }
        this._javaClassPathField.setEnabled(false);
        this._scriptPanel.setEnabled(true);
    }

    public boolean savePanel() {
        if (this._currentRuleRef == null) {
            return false;
        }
        if (this._ruleNameTxt.getText().length() == 0) {
            RMAIO.postError((Component)((Object)this), (String)"Cannot have an empty rule name!");
            return false;
        }
        this.checkScriptLength();
        ScriptOpRule scriptOpRule = (ScriptOpRule)this._currentRuleRef.getRule();
        this._currentRuleRef.getRule().setName(this._ruleNameTxt.getText());
        this._currentRuleRef.setName(this._ruleNameTxt.getText());
        this._oldRuleName = this._ruleNameTxt.getText();
        scriptOpRule.setDescription(this._descriptionTxt.getText());
        scriptOpRule.setUseJavaClass(this._useJavaClass.isSelected());
        scriptOpRule.setJavaClassPath(this._javaClassPathField.getText());
        scriptOpRule.setScriptText(this._scriptPanel.getScriptText());
        this.setModified(false);
        return true;
    }

    private void checkScriptLength() {
        int n = StateVariable.a();
        if (this._scriptPanel.getScriptText().length() > n) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html>The script for " + this._currentRuleRef.getName() + " has more characters than Jython may be able to parse (");
            stringBuilder.append(n);
            stringBuilder.append(")<br>Please reduce the number of characters.");
            JOptionPane.showMessageDialog((Component)((Object)this), stringBuilder, "Warning", -1);
        }
    }

    private static int a() {
        return StateVariable.a();
    }

    public void setParent(JPanel jPanel) {
        this._parent = (DefaultJPanel)jPanel;
    }

    public void clearPanel() {
        this._ruleNameTxt.setText("");
        this._descriptionTxt.setText("");
        this._scriptPanel.setScriptText("");
        this._useJavaClass.setSelected(false);
        this._javaClassPathField.setText("");
    }

    public void setRuleRef(OpRuleRef opRuleRef) {
        if (opRuleRef == null) {
            return;
        }
        if (this.isModified()) {
            this.savePanel();
        }
        this._currentRuleRef = opRuleRef;
        this.fillPanel();
    }

    public void fillPanel() {
        if (this._currentRuleRef == null) {
            return;
        }
        ScriptOpRule scriptOpRule = (ScriptOpRule)this._currentRuleRef.getRule();
        this.clearPanel();
        Object object = ClientApp.Workspace();
        if (object != null && (object = (RssRmiWorkspace)object.getChildWorkspace("rss")) != null) {
            try {
                this._opt = object.getRssAdvancedOptions();
            }
            catch (RemoteException remoteException) {}
        }
        if (this._opt != null && this._opt._allowScriptedRuleAsJavaClass) {
            this._useJavaClass.setVisible(true);
            this._javaClassPathField.setVisible(true);
            this._useJavaClass.setSelected(scriptOpRule.useJavaClass());
            this._javaClassPathField.setText(scriptOpRule.getJavaClassPath());
        } else {
            this._useJavaClass.setVisible(false);
            this._javaClassPathField.setVisible(false);
        }
        this._ruleNameTxt.setText(scriptOpRule.getName());
        this._descriptionTxt.setText(scriptOpRule.getDescription());
        this._oldRuleName = scriptOpRule.getName();
        object = scriptOpRule.getScriptText();
        if (object == null || ((String)object).length() == 0) {
            object = PreferencesManager.getBufferedReader((String)"rss/ScriptOpRule.template");
            if (object == null) {
                String string = JAR_TEMPLATE_FILE;
                InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(string);
                if (inputStream == null) {
                    inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(string);
                }
                if (inputStream == null) {
                    System.out.println("fillPanel: failed to find file " + string);
                } else {
                    object = new BufferedReader(new InputStreamReader(inputStream));
                    this._scriptPanel.setScriptTextReader((Reader)object);
                }
            } else {
                this._scriptPanel.setScriptTextReader((Reader)object);
            }
            this._scriptPanel.updateLineColTxt();
            if (object != null) {
                try {
                    ((BufferedReader)object).close();
                }
                catch (IOException iOException) {}
            }
        } else {
            this._scriptPanel.setScriptText((String)object);
        }
        this._funcDescTxt.setEditable(false);
        ((AbstractScriptBuilderPanel)this._scriptPanel).setNetwork(scriptOpRule.getRssSystem());
        this._scriptPanel.loadTree(XML_FILE_NAME);
        this.setModified(false);
    }
}

