/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.rss.client.ScriptBuilderPanel;
import hec.rss.model.RssSystem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import rma.swing.EnabledJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJTextField;

public class ScriptPanel
extends EnabledJPanel {
    protected ScriptBuilderPanel _scriptPanel;
    protected RmaJTextField _functionSyntaxTxt;
    protected RmaJTextField _lineColTxt;
    private String _initialScript;
    private RmaJIntegerField _charCntFld;

    public ScriptPanel() {
        super((LayoutManager)new GridBagLayout());
        this.buildControls();
        this.addListeners();
    }

    protected void buildControls() {
        this._scriptPanel = new ScriptBuilderPanel(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        ScriptPanel scriptPanel = this;
        scriptPanel.add((Component)((Object)scriptPanel._scriptPanel), gridBagConstraints);
        this._functionSyntaxTxt = new RmaJTextField();
        this._functionSyntaxTxt.setToolTipText("This is the method signature for the selected leaf node in the tree");
        this._functionSyntaxTxt.setEditable(false);
        this._functionSyntaxTxt.setModifiable(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        ScriptPanel scriptPanel2 = this;
        scriptPanel2.add((Component)scriptPanel2._functionSyntaxTxt, gridBagConstraints);
        this._charCntFld = new RmaJIntegerField();
        this._charCntFld.setColumns(10);
        this._charCntFld.setHorizontalAlignment(0);
        this._charCntFld.setToolTipText("The character count in the script");
        this._charCntFld.setEditable(false);
        this._charCntFld.setModifiable(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.0;
        ScriptPanel scriptPanel3 = this;
        scriptPanel3.add((Component)scriptPanel3._charCntFld, gridBagConstraints);
        this._lineColTxt = new RmaJTextField(10);
        this._lineColTxt.setHorizontalAlignment(0);
        this._lineColTxt.setToolTipText("The row,column at the cursor");
        this._lineColTxt.setEditable(false);
        this._lineColTxt.setModifiable(false);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 0.0;
        ScriptPanel scriptPanel4 = this;
        scriptPanel4.add((Component)scriptPanel4._lineColTxt, gridBagConstraints);
    }

    public ScriptBuilderPanel getScriptPanel() {
        return this._scriptPanel;
    }

    public RmaJTextField getLineColTxt() {
        return this._lineColTxt;
    }

    public RmaJTextField getCharLengthText() {
        return this._charCntFld;
    }

    public RmaJTextField getFunctionSyntaxTxt() {
        return this._functionSyntaxTxt;
    }

    public void fillPanel(RssSystem rssSystem) {
        this._scriptPanel.fillPanel(rssSystem);
    }

    public void clearPanel() {
        this._scriptPanel.clearScriptText();
    }

    protected void addListeners() {
    }

    public void setInitialScript(String string) {
        this._initialScript = string;
    }

    public boolean shouldSaveScript() {
        String string = this._scriptPanel.getScriptText();
        if (string.length() == 0) {
            return false;
        }
        return !string.equalsIgnoreCase(this._initialScript);
    }
}

