/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.geometry.WorldPt;
import hec.geometry.WorldRect;
import hec.gfx2d.G2dData;
import hec.gfx2d.G2dObject;
import hec.model.Interpolate;
import hec.model.SeasonalPairedValues;
import hec.rss.model.RunTime;
import rma.util.RMAConst;

public class SeasonalPairedValuesData
extends G2dData
implements G2dObject {
    public int[] tdata;
    public double[][] ydata;
    public int[] tdataOrg;
    public double[][] ydataOrg;
    public int numberCurves = 0;
    public String xtype;
    public String ytype;
    protected SeasonalPairedValues _sr;
    protected String _interpolationType = "linear";
    protected String _timeInterpolationType = "linear";
    protected int _nyears = 1;
    boolean _loaded = false;
    private transient int a = -2;
    boolean _successfullCalculation = true;

    public SeasonalPairedValuesData() {
        this(true);
    }

    public SeasonalPairedValuesData(boolean bl) {
        this.name = "Seasonal Data";
        this.xunits = "Minutes";
        this.yunits = "yunits";
        if (bl) {
            this.createDefaultData();
        }
    }

    protected void createDefaultData() {
        this.name = "Simple Table Seasonal Data";
        this.xunits = "xunits";
        this.yunits = "yunits";
        this.tdata = new int[100];
        this.ydata = new double[1][100];
        this.numberCurves = 1;
        for (int i = 0; i < 100; ++i) {
            int n = i;
            this.tdata[n] = n;
            this.ydata[0][i] = 5.0 * Math.sin(this.tdata[i]);
        }
    }

    public String getXAxisName() {
        return "Minutes";
    }

    public String getYAxisName() {
        return this.yunits;
    }

    public int getXAxisType() {
        return 2;
    }

    public int getYAxisType() {
        return 0;
    }

    public void setData(int[] nArray, double[][] dArray) {
        if (nArray == null || dArray == null) {
            return;
        }
        this.tdata = nArray;
        this.ydata = dArray;
        this.bounds = null;
        this.calcPlotArrays();
        this.setChanged();
        this.notifyObservers("reset data");
        this.clearChanged();
    }

    public void setData(SeasonalPairedValues object) {
        this._sr = object;
        if (this._sr == null || this._sr.getTimeArray() == null || this._sr.getTimeArray().length < 2) {
            return;
        }
        if (this._sr.getXArray() == null || this._sr.getXArray().length <= 0) {
            return;
        }
        int[] nArray = this._sr.getTimeArray();
        object = nArray;
        int n = nArray.length;
        this.tdataOrg = new int[++n];
        System.arraycopy(object, 0, this.tdataOrg, 0, n - 1);
        this.tdataOrg[n - 1] = this.tdataOrg[0] + 525600;
        object = this._sr.getXArray();
        this.numberCurves = ((SeasonalPairedValues)object).length;
        object = this._sr.getYData();
        this.ydataOrg = new double[this.numberCurves][n];
        for (int i = 0; i < this.numberCurves; ++i) {
            for (int j = 0; j < n - 1; ++j) {
                this.ydataOrg[i][j] = (double)object[j][i];
            }
            this.ydataOrg[i][n - 1] = this.ydataOrg[i][0];
        }
        SeasonalPairedValuesData seasonalPairedValuesData = this;
        seasonalPairedValuesData.setUnitSystem(seasonalPairedValuesData._sr.getUnitSystem());
        SeasonalPairedValuesData seasonalPairedValuesData2 = this;
        seasonalPairedValuesData2.setGmtOffset(seasonalPairedValuesData2._sr.getGmtOffset());
        SeasonalPairedValuesData seasonalPairedValuesData3 = this;
        seasonalPairedValuesData3.setYParameterId(seasonalPairedValuesData3._sr.getParamYId());
        this.calcPlotArrays();
        this.bounds = null;
        this.setChanged();
        this.notifyObservers("reset data");
    }

    public void setInterpolationType(String string) {
        if (string.equalsIgnoreCase("linear") || string.equalsIgnoreCase("step") || string.equalsIgnoreCase("cubic")) {
            this._interpolationType = string;
        }
    }

    public void setTimeInterpolationType(String string) {
        if (string.equalsIgnoreCase("linear") || string.equalsIgnoreCase("step") || string.equalsIgnoreCase("cubic")) {
            this._timeInterpolationType = string;
        }
    }

    public void setTimeInterpolationType(int n) {
        this._timeInterpolationType = "linear";
        if (n == 1) {
            this._timeInterpolationType = "cubic";
        }
        if (n == 2) {
            this._timeInterpolationType = "step";
        }
    }

    public void setPlotYears(int n) {
        this._nyears = n;
    }

    public boolean calcPlotArrays() {
        double[][] dArray;
        int[] nArray;
        int n;
        int n2;
        if (this._sr == null) {
            return false;
        }
        int[] nArray2 = this.tdataOrg;
        double[][] dArray2 = this.ydataOrg;
        if (nArray2 == null || nArray2.length < 2 || dArray2 == null) {
            this._successfullCalculation = false;
            return false;
        }
        int n3 = nArray2.length;
        int n4 = this._sr.getYears();
        if (n4 <= 0) {
            this._successfullCalculation = false;
            return false;
        }
        if (this._nyears <= 0) {
            this._nyears = 1;
        }
        if (this._nyears < n4) {
            this._nyears = n4;
        }
        this._nyears = 1;
        int n5 = 0;
        int n6 = nArray2[0] + this._nyears * 365 * 1440;
        for (n2 = 0; n2 < n6; n2 += n4 * 1440 * 365) {
            for (n = 0; n < n3 - 1 && nArray2[n] + n2 <= n6; ++n) {
                ++n5;
            }
        }
        if (this._timeInterpolationType.equalsIgnoreCase("linear")) {
            nArray = new int[n5];
            dArray = new double[this.numberCurves][n5];
            n = 0;
            n2 = 0;
            while (n2 < n6) {
                for (int i = 0; i < n3 && n + i <= n5 - 1; ++i) {
                    nArray[n + i] = nArray2[i] + n2;
                    for (int j = 0; j < this.numberCurves; ++j) {
                        dArray[j][n + i] = dArray2[j][i];
                    }
                }
                n2 += n4 * 1440 * 365;
                n += n3 - 1;
            }
        } else if (this._timeInterpolationType.equalsIgnoreCase("step")) {
            nArray = new int[n5 <<= 1];
            dArray = new double[this.numberCurves][n5];
            n = 0;
            n2 = 0;
            while (n2 < n6) {
                for (int i = 0; i < n3 - 1 && n + 2 * i <= n5 - 2; ++i) {
                    nArray[n + 2 * i] = nArray2[i] + n2;
                    nArray[n + 2 * i + 1] = nArray2[i + 1] + n2;
                    for (int j = 0; j < this.numberCurves; ++j) {
                        dArray[j][n + 2 * i] = dArray2[j][i];
                        dArray[j][n + 2 * i + 1] = dArray2[j][i];
                    }
                }
                n2 += n4 * 1440 * 365;
                n += 2 * (n3 - 1);
            }
        } else if (this._timeInterpolationType.equalsIgnoreCase("cubic")) {
            nArray = new int[101];
            dArray = new double[this.numberCurves][101];
            RunTime runTime = new RunTime();
            for (int i = 0; i < 101; ++i) {
                nArray[i] = n = nArray2[0] + i * (n6 - nArray2[0]) / 100;
                runTime.hecMin = nArray[i];
            }
        } else {
            this._successfullCalculation = false;
            return false;
        }
        this.tdata = nArray;
        this.ydata = dArray;
        this._successfullCalculation = true;
        return true;
    }

    public boolean calculationsSuccessful() {
        return this._successfullCalculation;
    }

    public void load() {
    }

    public void unload() {
    }

    public WorldRect getBounds() {
        if (this.tdata == null || this.ydata == null) {
            return null;
        }
        if (this.tdata.length == 0 || this.ydata.length == 0) {
            return null;
        }
        if (this.bounds == null) {
            int n;
            int n2;
            for (int i = 0; i < this.tdata.length; ++i) {
                if (!RMAConst.isValidValue((int)this.tdata[i])) continue;
                n2 = 0;
                for (n = 0; n < this.numberCurves; ++n) {
                    if (!RMAConst.isValidValue((double)this.ydata[n][i])) continue;
                    n2 = 1;
                    break;
                }
                if (n2 == 0) continue;
                this.bounds = new WorldRect((double)this.tdata[i], this.ydata[n][i], (double)this.tdata[i], this.ydata[n][i]);
                break;
            }
            for (n2 = 0; n2 < this.tdata.length; ++n2) {
                double d = this.tdata[n2];
                if (!RMAConst.isValidValue((double)d)) continue;
                for (n = 0; n < this.numberCurves; ++n) {
                    double d2 = this.ydata[n][n2];
                    if (!RMAConst.isValidValue((double)d2)) continue;
                    if (this.bounds.w > d) {
                        this.bounds.w = d;
                    } else if (this.bounds.e < d) {
                        this.bounds.e = d;
                    }
                    if (this.bounds.s > d2) {
                        this.bounds.s = d2;
                        continue;
                    }
                    if (!(this.bounds.n < d2)) continue;
                    this.bounds.n = d2;
                }
            }
        }
        return this.bounds;
    }

    public double interpolateValue(int n, int n2) {
        if (this.tdata == null || this.tdata.length < 2) {
            return Double.NEGATIVE_INFINITY;
        }
        int n3 = this.findInterval(n);
        if (n3 < 0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (n3 >= this.tdata.length - 1) {
            return this.ydata[n2][this.tdata.length - 1];
        }
        double d = (double)(n - this.tdata[n3]) / (double)(this.tdata[n3 + 1] - this.tdata[n3]);
        double d2 = d * (this.ydata[n2][n3 + 1] - this.ydata[n2][n3]) + this.ydata[n2][n3];
        return d2;
    }

    public void resetData() {
        this.tdata = null;
        this.ydata = null;
        this.bounds = null;
        this.setChanged();
        this.notifyObservers("reset data");
        this.clearChanged();
    }

    private int findInterval(int n) {
        if (this.tdata.length < 2) {
            return -1;
        }
        int n2 = this.tdata.length - 1;
        if (this.a == n2 && n > this.tdata[n2]) {
            return n2;
        }
        if (this.a < 0 || this.a >= n2 || n < this.tdata[this.a] || n > this.tdata[this.a + 1]) {
            this.a = Interpolate.bisearch((int[])this.tdata, (int)n, (int)this.tdata.length);
        }
        if (this.a < 0 && this.a > n2) {
            System.out.println(" SeasonalRecord linear interpolation outside interval ");
            System.out.println(" rundate = " + n + "  interpInterval = " + this.a);
            return -1;
        }
        return this.a;
    }

    public WorldPt getNearestDataPt(WorldPt worldPt) {
        if (this.tdata == null || this.tdata.length == 0) {
            return null;
        }
        double d = Double.POSITIVE_INFINITY;
        WorldPt worldPt2 = null;
        for (int i = 0; i < this.tdata.length; ++i) {
            for (int j = 0; j < this.numberCurves; ++j) {
                double d2;
                if (worldPt2 == null) {
                    worldPt2 = new WorldPt((double)this.tdata[0], this.ydata[j][0]);
                }
                double d3 = this.tdata[i];
                double d4 = this.ydata[j][i];
                double d5 = worldPt.e - d3;
                double d6 = worldPt.n - d4;
                if (d5 == 0.0 && d6 == 0.0) {
                    return worldPt;
                }
                double d7 = d5;
                double d8 = d6;
                double d9 = d7 * d7 + d8 * d8;
                if (!(d2 < d)) continue;
                d = d9;
                worldPt2.init(d3, d4);
            }
        }
        return worldPt2;
    }
}

