/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.data.DataSetException;
import hec.data.Units;
import hec.geometry.LocalPt;
import hec.geometry.Scale;
import hec.geometry.WorldPt;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dLine;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dObject;
import hec.gfx2d.Viewport;
import hec.heclib.util.HecTime;
import hec.rss.client.SeasonalPairedValuesData;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class SeasonalPairedValuesGlyph
extends G2dGlyph {
    SeasonalPairedValuesData _obj;
    G2dLine[] _lineArray = null;

    public SeasonalPairedValuesGlyph(Viewport viewport, SeasonalPairedValuesData seasonalPairedValuesData, Scale scale) {
        super(viewport, (G2dObject)seasonalPairedValuesData, scale);
        this._obj = seasonalPairedValuesData;
        viewport = this._line.getProperties();
        this._line.getProperties()._drawPoints = true;
        viewport._symbolSize = 3.0f;
        this._line.setProperties((G2dLineProperties)viewport);
        this._lineArray = new G2dLine[this._obj.numberCurves];
    }

    public void draw(Graphics graphics) {
        int n;
        if (this._obj.tdata == null || this._obj.ydata == null) {
            return;
        }
        Rectangle rectangle = this.getVisibleRect();
        this._line.clearLineData();
        double[] dArray = new double[10000];
        double[] dArray2 = new double[10000];
        for (n = 0; n < this._obj.numberCurves; ++n) {
            int n2 = 0;
            for (int i = 0; i < this._obj.tdata.length; ++i) {
                double d = this._obj.tdata[i];
                double d2 = this._obj.ydata[n][i];
                if (!RMAConst.isValidValue((double)d) || !RMAConst.isValidValue((double)d2)) {
                    if (n2 > 0) {
                        this._line.addLineData(dArray, dArray2, n2);
                        n2 = 0;
                    }
                } else {
                    dArray[n2] = d;
                    dArray2[n2] = d2;
                    ++n2;
                }
                if (n2 < 10000) continue;
                this._line.addLineData(dArray, dArray2, n2);
                n2 = 0;
            }
            if (n2 > 0) {
                dArray[n2] = dArray[n2 - 1];
                dArray2[n2] = Double.NEGATIVE_INFINITY;
                ++n2;
            }
            if (n2 > 0) {
                this._line.addLineData(dArray, dArray2, n2);
            }
            this._lineArray[n] = this._line;
        }
        for (n = 0; n < this._lineArray.length; ++n) {
            this._lineArray[n].drawLine(graphics, rectangle);
        }
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            return null;
        }
        mouseEvent = new LocalPt(mouseEvent.getX(), mouseEvent.getY());
        for (int i = 0; i < this._lineArray.length; ++i) {
            this._line = this._lineArray[i];
            if (!this._line.contains((LocalPt)mouseEvent)) continue;
            LocalPt localPt = this._line.getNearestDataPt((LocalPt)mouseEvent);
            WorldPt worldPt = new WorldPt();
            double d = this._line.getNearestDataPt((LocalPt)mouseEvent, worldPt);
            if (d == Double.NEGATIVE_INFINITY) continue;
            int n = (int)this._scale.getAxis(0).l2w(localPt.x) / 1440;
            String string = HecTime.juldat((int)n, (int)4);
            string = string.substring(0, string.length() - 4);
            try {
                double d2 = Units.convertUnits((double)worldPt.n, (int)this._obj.getYParameterId(), (int)this._obj.getUnitSystem(), (int)this._scale.getDisplayUnitSystem());
                return new String("[" + string + " ," + RMAIO.setPrecision2((double)d2, (int)0) + "]");
            }
            catch (DataSetException dataSetException) {
                return new String("[" + string + " ," + RMAIO.setPrecision2((double)worldPt.n, (int)0) + "]");
            }
        }
        return null;
    }
}

