/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.gfx2d.G2dGlyphFactory;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dPlotProp;
import hec.gfx2d.HotPlotDefaults;
import hec.gfx2d.PairedValuesExtData;
import hec.gfx2d.PlotDefaults;
import hec.gfx2d.PlotDefaultsManager;
import hec.gfx2d.SimplePairedValuesData;
import hec.gfx2d.SimpleSeasonalData;
import hec.model.PairedValues;
import hec.model.PairedValuesExt;
import hec.model.SeasonalPairedValues;
import hec.model.SeasonalRecord;
import hec.rss.client.EditTableHeadersJDialog;
import hec.rss.client.OperationsTab;
import hec.rss.client.RssCheckBoxEditPanel;
import hec.rss.client.SeasonalPairedValuesData;
import hec.rss.client.SeasonalPairedValuesGlyph;
import hec.rss.client.SeasonalVariationJDialog;
import hec.rss.client.SelectGCPanel$1;
import hec.rss.client.SelectGCPanel$2;
import hec.rss.client.SelectGCPanel$G2dPanelCredit;
import hec.rss.client.SelectGCPanel$G2dPanelStorage;
import hec.rss.client.SelectGCPanel$PairedValuesPanel;
import hec.rss.client.SelectGCPanel$RuleTablePanel;
import hec.rss.client.SelectGCPanel$SeasonalPairedValuesPanel;
import hec.rss.client.SelectGCPanel$SeasonalVariationAction;
import hec.rss.client.SelectGCPanel$SeasonalVariationItemStateChanged;
import hec.rss.model.CreditReservoirRef;
import hec.rss.model.OpSet;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirOp;
import hec.rss.model.RssSystem;
import hec.rss.model.Storage;
import hec.rss.model.StorageZone;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.TableModel;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJList;
import rma.swing.RmaJTable;
import rma.util.RMAIO;

public class SelectGCPanel
extends DefaultJPanel
implements OperationsTab {
    private Vector _reservoirVector = new Vector();
    private RssSystem currentSystem = null;
    private OpSet _currentOpSet = null;
    private Vector _model = new Vector();
    private RmaJList _resList;
    private RmaJTable _creditPoolTable;
    private String[] _creditPoolTabelLabels = new String[]{"Reservoir", "Max Credit Pool\n Storage(%S)", "Max Credit (%S)", "Allow Neg Credit"};
    private CreditReservoirRef _creditReservoirRef;
    private Vector _comboLabelVector = null;
    private RmaJList _comboLabelList = null;
    private StorageZone _selectedZone = null;
    private ReservoirElement _currentReservoir = null;
    private Vector _newItems2 = null;
    private DefaultJPanel _parentPanel = null;
    private Vector _creditReservoirRefVec;
    private SelectGCPanel$G2dPanelStorage jPlotPanelStorage;
    private SelectGCPanel$G2dPanelCredit jPlotPanelCredit;
    protected RssCheckBoxEditPanel _seasonalVariationCB;
    private SelectGCPanel$RuleTablePanel _currentPanel;
    private SelectGCPanel$SeasonalPairedValuesPanel _seasonalVariablePanel;
    private SelectGCPanel$PairedValuesPanel _pairedValuesPanel;
    private JPanel _cardPanel;
    private boolean _controlsCreated;
    protected static final String[] a;
    private int _timeInterp = 0;
    Frame _frame;

    public void setParentPanel(DefaultJPanel defaultJPanel) {
        this._parentPanel = defaultJPanel;
    }

    @Override
    public void setReservoirOp(ReservoirOp reservoirOp) {
    }

    public boolean areControlsCreated() {
        return this._controlsCreated;
    }

    public void setReservoir(ReservoirElement reservoirElement, OpSet opSet) {
        if (reservoirElement == null) {
            System.out.println("null ReservoirElement in SelectGCPanel.setReservoir");
            return;
        }
        this._currentReservoir = reservoirElement;
        if (opSet == null) {
            System.out.println("null OpSet in SelectGCPanel.setReservoir");
            return;
        }
        this.currentSystem = reservoirElement.getSystem();
        this._reservoirVector.clear();
        Vector<?> vector = this.currentSystem.getElementVectorByClass(reservoirElement.getClass());
        this._reservoirVector.ensureCapacity(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            ReservoirElement reservoirElement2 = (ReservoirElement)vector.get(i);
            if (reservoirElement2.getIndex() == reservoirElement.getIndex()) continue;
            this._reservoirVector.add(reservoirElement2);
        }
        this._currentOpSet = opSet;
    }

    public void fillForm(Vector vector) {
        SeasonalPairedValues seasonalPairedValues;
        if (vector == null) {
            return;
        }
        this._newItems2 = (Vector)vector.clone();
        this._newItems2.add("None");
        this._creditPoolTable.deleteCells();
        if (this._currentOpSet.getCreditResRefVec() != null) {
            seasonalPairedValues = new Vector(this._currentOpSet.getCreditResRefVec());
            vector = new Vector(seasonalPairedValues.size());
            for (int i = 0; i < seasonalPairedValues.size(); ++i) {
                this._creditReservoirRef = (CreditReservoirRef)seasonalPairedValues.get(i);
                String.valueOf(this._creditReservoirRef.getReservoirIndex());
                for (int j = 0; j < this._reservoirVector.size(); ++j) {
                    ReservoirElement reservoirElement = (ReservoirElement)this._reservoirVector.get(j);
                    if (reservoirElement.getIndex() != this._creditReservoirRef.getReservoirIndex()) continue;
                    this._creditPoolTable.setValueAt(this._reservoirVector.get(j), i, 0);
                }
                ParamDouble paramDouble = new ParamDouble(this._creditReservoirRef.getMaxCreditPool(), Parameter.PARAMID_STOR, this._currentOpSet.getUnitSystem());
                this._creditPoolTable.setValueAt((Object)paramDouble, i, 1);
                this._creditPoolTable.setValueAt((Object)new ParamDouble(this._creditReservoirRef.getMaxCredit(), Parameter.PARAMID_STOR, this._currentOpSet.getUnitSystem()), i, 2);
                this._creditPoolTable.setValueAt((Object)this._creditReservoirRef.getAllowNegCredit(), i, 3);
            }
            this._model.clear();
            this._model.addAll(vector);
        }
        this._selectedZone = this._currentOpSet.getGuideCurveZone();
        seasonalPairedValues = this._currentOpSet.getStorageCredit();
        this._timeInterp = seasonalPairedValues != null ? seasonalPairedValues.getTimeInterpolationType() : 0;
        this.fillStorageCreditTable(seasonalPairedValues);
        this.setModified(false);
    }

    private void fillStorageCreditTable(SeasonalPairedValues seasonalPairedValues) {
        if (seasonalPairedValues == null) {
            seasonalPairedValues = new SeasonalPairedValues();
            seasonalPairedValues.setHasSeasonalVariation(false);
            seasonalPairedValues.setParamXId(Parameter.PARAMID_STOR);
            seasonalPairedValues.setParamYId(Parameter.PARAMID_STOR);
            seasonalPairedValues.setUnitSystem(this._currentOpSet.getUnitSystem());
        }
        this._seasonalVariationCB.setSelected(seasonalPairedValues.hasSeasonalVariation());
        this._seasonalVariablePanel.setData(seasonalPairedValues);
        this._pairedValuesPanel.setData(seasonalPairedValues);
        if (seasonalPairedValues.hasSeasonalVariation()) {
            this._currentPanel = this._seasonalVariablePanel;
            ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, a[0]);
        } else {
            this._currentPanel = this._pairedValuesPanel;
            ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, a[1]);
        }
        this.plotTable();
    }

    private SeasonalRecord getGuideCurveStorage() {
        if (this._selectedZone == null || this._selectedZone.getSeasonalRecord() == null) {
            return null;
        }
        SeasonalRecord seasonalRecord = this._selectedZone.getSeasonalRecord();
        if (seasonalRecord == null || seasonalRecord.getTimeArray() == null) {
            return null;
        }
        Storage storage = this._currentReservoir.getStorageFunction();
        double[] dArray = seasonalRecord.getDataArray();
        int[] nArray = (int[])seasonalRecord.getTimeArray().clone();
        double[] dArray2 = new double[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            dArray2[i] = storage.elevationToStorage(dArray[i]);
        }
        SeasonalRecord seasonalRecord2 = new SeasonalRecord();
        seasonalRecord2.setParameterId(Parameter.PARAMID_STOR);
        seasonalRecord2.setUnitSystem(seasonalRecord.getUnitSystem());
        seasonalRecord2.setArrays(nArray, dArray2);
        return seasonalRecord2;
    }

    private SeasonalPairedValues getStorageCreditCurves() {
        int[] nArray;
        Object object;
        if (this._selectedZone == null || this._selectedZone.getSeasonalRecord() == null) {
            return null;
        }
        SeasonalPairedValues seasonalPairedValues = null;
        if (this._currentPanel instanceof SelectGCPanel$PairedValuesPanel) {
            if (!this._pairedValuesPanel.isEmpty()) {
                seasonalPairedValues = new SeasonalPairedValues();
                object = (PairedValues)this._pairedValuesPanel.saveTable();
                seasonalPairedValues.setData((PairedValues)object, "01JAN");
                seasonalPairedValues.setHasSeasonalVariation(false);
                seasonalPairedValues.setTimeInterpolationType(0);
            }
        } else {
            seasonalPairedValues = (SeasonalPairedValues)this._seasonalVariablePanel.saveTable();
        }
        if (seasonalPairedValues == null || seasonalPairedValues.getXArray() == null || seasonalPairedValues.getXArray().length <= 0 || seasonalPairedValues.getTimeArray() == null || seasonalPairedValues.getTimeArray().length <= 0) {
            return null;
        }
        object = this._currentReservoir.getStorageFunction();
        SeasonalRecord seasonalRecord = this._selectedZone.getSeasonalRecord();
        if (seasonalRecord == null || seasonalRecord.getTimeArray() == null) {
            return null;
        }
        int[] nArray2 = seasonalRecord.getTimeArray();
        int[] nArray3 = seasonalPairedValues.getTimeArray();
        Object[] objectArray = new int[nArray2.length + nArray3.length];
        System.arraycopy(nArray2, 0, objectArray, 0, nArray2.length);
        System.arraycopy(nArray3, 0, objectArray, nArray2.length, nArray3.length);
        Arrays.sort(objectArray);
        int n = 1;
        for (int i = 1; i < objectArray.length; ++i) {
            if (objectArray[i] <= objectArray[i - 1]) continue;
            ++n;
        }
        if (this._timeInterp != 1) {
            int[] nArray4 = new int[(n << 1) - 1];
            nArray = nArray4;
            nArray4[0] = objectArray[0];
            n = 1;
            for (int i = 1; i < objectArray.length; ++i) {
                if (objectArray[i] <= objectArray[i - 1]) continue;
                nArray[n] = objectArray[i];
                nArray[++n] = objectArray[i] + 1;
                ++n;
            }
        } else {
            nArray = new int[101];
            int n2 = (objectArray[objectArray.length - 1] - objectArray[0]) / 100;
            nArray[0] = objectArray[0];
            int n3 = 1;
            while (n3 < 101) {
                int n4 = n3++;
                nArray[n4] = n4 * n2;
            }
            nArray[100] = objectArray[objectArray.length - 1];
        }
        SeasonalPairedValues seasonalPairedValues2 = new SeasonalPairedValues();
        seasonalPairedValues2.setParamXId(Parameter.PARAMID_STOR);
        seasonalPairedValues2.setParamYId(Parameter.PARAMID_STOR);
        seasonalPairedValues2.setUnitSystem(seasonalPairedValues.getUnitSystem());
        seasonalPairedValues2.setHasSeasonalVariation(seasonalPairedValues.hasSeasonalVariation());
        n = nArray.length;
        objectArray = seasonalPairedValues.getXArray();
        double[][] dArray = new double[n][objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            for (int j = 0; j < n; ++j) {
                double d = seasonalRecord.interpolateValue(nArray[j]);
                double d2 = ((Storage)object).elevationToStorage(d);
                dArray[j][i] = d2 + seasonalPairedValues.interpolate(nArray[j], (double)objectArray[i]);
            }
        }
        seasonalPairedValues2.setArrays((double[])objectArray, dArray, nArray);
        return seasonalPairedValues2;
    }

    @Override
    public void clearForm() {
        if (!this._controlsCreated) {
            return;
        }
        this._currentOpSet = null;
        this._currentReservoir = null;
        this.currentSystem = null;
        this._creditPoolTable.deleteCells();
    }

    public boolean savePanel() {
        if (!this._controlsCreated) {
            return true;
        }
        if (this._currentReservoir == null || this._currentOpSet == null || !this.isModified()) {
            return true;
        }
        new Vector(this._creditPoolTable.getRowCount());
        Vector<CreditReservoirRef> vector = new Vector<CreditReservoirRef>();
        if (this._creditPoolTable.getRowCount() != 0) {
            this._creditPoolTable.commitEdit(true);
            for (int i = 0; i < this._creditPoolTable.getRowCount(); ++i) {
                if (!(this._creditPoolTable.getValueAt(i, 0) instanceof ReservoirElement)) continue;
                this._creditReservoirRef = new CreditReservoirRef();
                ReservoirElement reservoirElement = (ReservoirElement)this._creditPoolTable.getValueAt(i, 0);
                int pairedValues = reservoirElement.getIndex();
                this._creditReservoirRef.setReservoirIndex(pairedValues);
                double d = RMAIO.parseDouble((Object)this._creditPoolTable.getValueAt(i, 1));
                this._creditReservoirRef.setMaxCreditPool(d);
                double d2 = RMAIO.parseDouble((Object)this._creditPoolTable.getValueAt(i, 2));
                this._creditReservoirRef.setMaxCredit(d2);
                boolean bl = (Boolean)this._creditPoolTable.getValueAt(i, 3);
                this._creditReservoirRef.setAllowNegCredit(bl);
                vector.add(this._creditReservoirRef);
            }
        }
        this._currentOpSet.setCreditResRefVec(vector);
        SeasonalPairedValues seasonalPairedValues = null;
        if (this._currentPanel instanceof SelectGCPanel$PairedValuesPanel) {
            if (!this._pairedValuesPanel.isEmpty()) {
                seasonalPairedValues = new SeasonalPairedValues();
                PairedValues pairedValues = (PairedValues)this._pairedValuesPanel.saveTable();
                seasonalPairedValues.setData(pairedValues, "01JAN");
                seasonalPairedValues.setTimeInterpolationType(0);
            }
        } else {
            seasonalPairedValues = (SeasonalPairedValues)this._seasonalVariablePanel.saveTable();
        }
        if (seasonalPairedValues != null) {
            seasonalPairedValues.setHasSeasonalVariation(this._seasonalVariationCB.isSelected());
        }
        this._currentOpSet.setStorageCredit(seasonalPairedValues);
        this._currentOpSet.setModified(true);
        if (this._parentPanel != null) {
            this._parentPanel.setModified(true);
        }
        this.setModified(false);
        return true;
    }

    public boolean checkSaveBeforeClose() {
        int n;
        this._creditPoolTable.commitEdit(true);
        this._currentPanel.commitEdit();
        if (this.isModified() && (n = RMAIO.postYesNoWarning((Component)((Object)this), (String)"Guide Curve Data Has Changed! \nSave Guide Curve Data before closing?")) == 0) {
            this.savePanel();
            return true;
        }
        return false;
    }

    public void edit_Action() {
        int[] nArray = this._seasonalVariablePanel.getTimes();
        Object object = SwingUtilities.windowForComponent(this._cardPanel);
        object = new SeasonalVariationJDialog((Dialog)object, true);
        ((SeasonalVariationJDialog)((Object)object)).fillForm(nArray, this._timeInterp);
        object.setVisible(true);
        if (((EditTableHeadersJDialog)((Object)object)).isCanceled()) {
            return;
        }
        nArray = ((SeasonalVariationJDialog)((Object)object)).getDateTimes();
        boolean bl = nArray.length > 1;
        this._seasonalVariablePanel.resetTimes(nArray, ((EditTableHeadersJDialog)((Object)object)).getIndices());
        this._timeInterp = ((EditTableHeadersJDialog)((Object)object)).getInterpolationType();
        if (this._seasonalVariationCB.isSelected() != bl) {
            this._seasonalVariationCB.doClick(0);
        }
        this.plotTable();
        int n = ClientApp.app().getClientUnitSystem();
        this.jPlotPanelStorage.setDisplayUnitsSystem(n);
        this.jPlotPanelCredit.setDisplayUnitsSystem(n);
    }

    private void configureStoragePlot(G2dPanel g2dPanel, String string) {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        g2dPlotProp.x1AxisProp.name = "Minutes";
        g2dPlotProp.x1AxisProp.type = 2;
        g2dPlotProp.y1AxisProp.name = string;
        g2dPlotProp.x1AxisProp.numTicLabelLayers = 1;
        g2dPlotProp.hasX1Label = false;
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPlotProp.x1AxisProp.isDefaultLimits = false;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }

    private void configureCreditPlot(G2dPanel g2dPanel, String string, String string2) {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        g2dPlotProp.x1AxisProp.name = string;
        g2dPlotProp.y1AxisProp.name = string2;
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }

    void plotTable() {
        this.plotCreditTable();
        this.plotStorage();
    }

    void plotCreditTable() {
        SimplePairedValuesData simplePairedValuesData;
        Object object;
        if (this._currentPanel instanceof SelectGCPanel$PairedValuesPanel) {
            object = (PairedValues)this._pairedValuesPanel.saveTable();
            simplePairedValuesData = new SimplePairedValuesData(false);
            simplePairedValuesData.setData(object);
        } else {
            object = (SeasonalPairedValues)this._seasonalVariablePanel.saveTable();
            simplePairedValuesData = new PairedValuesExtData(false);
            simplePairedValuesData.setData((PairedValuesExt)object);
        }
        simplePairedValuesData.xunits = "Available Credit (%S)";
        simplePairedValuesData.yunits = "Credit (%S)";
        simplePairedValuesData.name = "Storage Credit";
        this.jPlotPanelCredit.clearPanel();
        SelectGCPanel selectGCPanel = this;
        selectGCPanel.configureCreditPlot(selectGCPanel.jPlotPanelCredit, simplePairedValuesData.xunits, simplePairedValuesData.yunits);
        object = new Vector<SimplePairedValuesData>();
        object.addElement(simplePairedValuesData);
        this.jPlotPanelCredit.setPlotObjects((List)object);
    }

    void plotStorage() {
        Vector<SeasonalPairedValuesData> vector = new Vector<SeasonalPairedValuesData>();
        SeasonalRecord seasonalRecord = this.getGuideCurveStorage();
        SimpleSeasonalData simpleSeasonalData = new SimpleSeasonalData();
        simpleSeasonalData.setData(seasonalRecord);
        simpleSeasonalData.xunits = "Minutes";
        simpleSeasonalData.yunits = "Storage (%S)";
        simpleSeasonalData.name = "Regular Guide Curve";
        seasonalRecord = this.getStorageCreditCurves();
        if (seasonalRecord != null) {
            SeasonalPairedValuesData seasonalPairedValuesData = new SeasonalPairedValuesData(false);
            seasonalPairedValuesData.setData((SeasonalPairedValues)seasonalRecord);
            seasonalPairedValuesData.xunits = simpleSeasonalData.xunits;
            seasonalPairedValuesData.yunits = simpleSeasonalData.yunits;
            seasonalPairedValuesData.name = "Guide Curve with Storage Credit";
            vector.addElement(seasonalPairedValuesData);
        }
        vector.addElement((SeasonalPairedValuesData)simpleSeasonalData);
        this.jPlotPanelStorage.clearPanel();
        SelectGCPanel selectGCPanel = this;
        selectGCPanel.configureStoragePlot(selectGCPanel.jPlotPanelStorage, simpleSeasonalData.yunits);
        this.jPlotPanelStorage.setPlotObjects(vector);
    }

    public void createControls() {
        if (this._controlsCreated) {
            return;
        }
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        Object object = new SelectGCPanel$1(this);
        object.setColumnNames(this._creditPoolTabelLabels);
        this._creditPoolTable = new RmaJTable();
        this._creditPoolTable.setModel((TableModel)object);
        this._creditPoolTable.setMlHeaderRenderer();
        this._creditPoolTable.setUnitsHeaderRenderer();
        this._creditPoolTable.setDoubleCellEditor(1, true);
        this._creditPoolTable.setDoubleCellEditor(2, true);
        this._creditPoolTable.setDisplayUnitsSystem(RmaJDialog.getUnitSystem());
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object).gridy = 3;
        ((GridBagConstraints)object).weighty = 1.0;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).anchor = 11;
        ((GridBagConstraints)object).fill = 1;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)3, (int)5, (int)0, (int)5);
        SelectGCPanel selectGCPanel = this;
        selectGCPanel.add(selectGCPanel._creditPoolTable.getScrollPane(), object);
        this._creditPoolTable.getScrollPane().setPreferredSize(new Dimension(400, 150));
        this._creditPoolTable.setCheckBoxCellEditor(3);
        this._seasonalVariablePanel = new SelectGCPanel$SeasonalPairedValuesPanel(this);
        this._pairedValuesPanel = new SelectGCPanel$PairedValuesPanel(this);
        this._cardPanel = new JPanel(new CardLayout());
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object).gridy = 4;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 1.0;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 1;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)3, (int)5, (int)0, (int)5);
        this._cardPanel.setPreferredSize(new Dimension(400, 150));
        SelectGCPanel selectGCPanel2 = this;
        selectGCPanel2.add(selectGCPanel2._cardPanel, object);
        CardLayout cfr_ignored_0 = (CardLayout)this._cardPanel.getLayout();
        this._cardPanel.add(a[0], this._seasonalVariablePanel);
        this._cardPanel.add(a[1], this._pairedValuesPanel);
        ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, a[0]);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JButton jButton = new JButton("Edit Reservoir Set");
        jButton.setMnemonic('E');
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)3, (int)5, (int)0, (int)5);
        jPanel2.add((Component)jButton, object);
        jButton.addActionListener(new SelectGCPanel$2(this));
        this.jPlotPanelCredit = new SelectGCPanel$G2dPanelCredit(this);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object).gridy = 1;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 2.0;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 1;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)5);
        jPanel2.add((Component)((Object)this.jPlotPanelCredit), object);
        SelectGCPanel selectGCPanel3 = this;
        selectGCPanel3.configureCreditPlot(selectGCPanel3.jPlotPanelCredit, "Available Credit", "Credit");
        object = new Vector();
        this.jPlotPanelCredit.setPlotObjects((List)object);
        this.jPlotPanelStorage = new SelectGCPanel$G2dPanelStorage(this);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object).gridy = 2;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 2.0;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 1;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)5);
        jPanel2.add((Component)((Object)this.jPlotPanelStorage), object);
        SelectGCPanel selectGCPanel4 = this;
        selectGCPanel4.configureStoragePlot(selectGCPanel4.jPlotPanelStorage, "Storage");
        object = new Vector();
        this.jPlotPanelStorage.setPlotObjects((List)object);
        new JPanel(new GridBagLayout());
        this._seasonalVariationCB = new RssCheckBoxEditPanel("Seasonal Variation");
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object).gridy = 3;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 1.0;
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)0, (int)5, (int)3, (int)5);
        ((GridBagConstraints)object).anchor = 18;
        jPanel2.add((Component)((Object)this._seasonalVariationCB), object);
        this._seasonalVariationCB.addActionListener(new SelectGCPanel$SeasonalVariationAction(this));
        this._seasonalVariationCB.addItemListener(new SelectGCPanel$SeasonalVariationItemStateChanged(this));
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).anchor = 18;
        this.add(jPanel, object);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        ((GridBagConstraints)object).gridy = 3;
        ((GridBagConstraints)object).gridheight = 2;
        ((GridBagConstraints)object).weighty = 1.0;
        ((GridBagConstraints)object).fill = 3;
        ((GridBagConstraints)object).anchor = 12;
        this.add(jPanel2, object);
        this._controlsCreated = true;
    }

    static {
        G2dGlyphFactory.addMapping((String)SeasonalPairedValuesData.class.getName(), (String)SeasonalPairedValuesGlyph.class.getName());
        UIManager.getColor("TextField.disabledBackground");
        a = new String[]{"Seasonal Variation", "Paired Values"};
    }
}

