/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.data.Parameter;
import hec.geometry.Axis;
import hec.geometry.AxisFactory;
import hec.geometry.Scale;
import hec.gfx2d.AxisTics;
import hec.gfx2d.DataTypeFactory;
import hec.gfx2d.G2dComponent;
import hec.gfx2d.G2dObject;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dToolbarListener;
import hec.gfx2d.LegendPanel;
import hec.gfx2d.ObjectSelectionListener;
import hec.gfx2d.TimeWindowPlotData;
import hec.gfx2d.Viewport;
import hec.gfx2d.ViewportToolbar;
import hec.gfx2d.dss.G2dDssObject;
import hec.model.ModelVariable;
import hec.rss.client.PlotDialog;
import hec.rss.client.SelectPlotVariablesJDialog$1;
import hec.rss.client.SelectPlotVariablesJDialog$2;
import hec.rss.client.SelectPlotVariablesJDialog$3;
import hec.rss.client.SelectPlotVariablesJDialog$4;
import hec.rss.client.SelectPlotVariablesJDialog$5;
import hec.rss.client.SelectPlotVariablesJDialog$6;
import hec.rss.client.SelectPlotVariablesJDialog$AxisNode;
import hec.rss.client.SelectPlotVariablesJDialog$ObjectTypeNode;
import hec.rss.client.SelectPlotVariablesJDialog$PlotTreeCellRenderer;
import hec.rss.client.SelectPlotVariablesJDialog$VariableNode;
import hec.rss.client.SelectPlotVariablesJDialog$ViewportNode;
import hec.rss.client.SelectPlotVariablesJDialog$ViewportWeightsDialog;
import hec.rss.model.DiversionElement;
import hec.rss.model.Element;
import hec.rss.model.JunctionElement;
import hec.rss.model.ReservoirElement;
import hec.watershed.res.model.PlottableObject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import mil.army.usace.hec.rmi.gfx2d.SimpleDSSData;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaImage;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.event.ReflectMultiListener;
import rma.swing.tree.PopupNodeListener;

public class SelectPlotVariablesJDialog
extends RmaJDialog {
    private JPopupMenu _axisPopup;
    PlotDialog _plotDialog;
    ReflectMultiListener _listener = new ReflectMultiListener();
    boolean _canceled = false;
    JMenuItem _addViewportMenuItem;
    JMenuItem _removeViewportMenuItem;
    JMenuItem _addAxisMenuItem;
    JMenuItem _removeAxisMenuItem;
    JMenuItem _weightsMenuItem;
    JPanel _spinPanel;
    JTree _availableTree;
    JTree _selectedTree;
    JButton _addButton;
    JButton _removeButton;
    JButton _spinUpButton;
    JButton _spinDownButton;
    JPopupMenu _viewportPopup;
    ButtonCmdPanel _cmdPanel;
    DefaultMutableTreeNode _availRoot;
    DefaultMutableTreeNode _selectedRoot;
    int[] intarray = new int[1];

    public SelectPlotVariablesJDialog(Frame frame) {
        super(frame, true);
        if (frame instanceof PlotDialog) {
            this._plotDialog = (PlotDialog)((Object)frame);
        }
        this.buildControls();
    }

    private void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Select Plot Variables");
        this.buildMenus();
        Serializable serializable = new JLabel("Available Variables", 0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)serializable, gridBagConstraints);
        this._availRoot = new DefaultMutableTreeNode();
        this._selectedRoot = new DefaultMutableTreeNode();
        SelectPlotVariablesJDialog selectPlotVariablesJDialog = this;
        this._availableTree = new SelectPlotVariablesJDialog$1(selectPlotVariablesJDialog, selectPlotVariablesJDialog._availRoot);
        this._availableTree.setCellRenderer(new SelectPlotVariablesJDialog$PlotTreeCellRenderer(this));
        this._availableTree.setRootVisible(false);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)new JScrollPane(this._availableTree), gridBagConstraints);
        serializable = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)65, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)serializable, gridBagConstraints);
        this._addButton = new JButton("Add");
        SelectPlotVariablesJDialog selectPlotVariablesJDialog2 = this;
        this._addButton.addActionListener((ActionListener)this._listener.add((Object)selectPlotVariablesJDialog2, (Object)selectPlotVariablesJDialog2._addButton, "addModelVariable"));
        this._addButton.setHorizontalTextPosition(2);
        this._addButton.setIcon(RmaImage.getImageIcon((String)"Images/forwardbutton.gif"));
        this._addButton.setMnemonic('A');
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        serializable.add(this._addButton, gridBagConstraints);
        this._removeButton = new JButton("Remove");
        SelectPlotVariablesJDialog selectPlotVariablesJDialog3 = this;
        this._removeButton.addActionListener((ActionListener)this._listener.add((Object)selectPlotVariablesJDialog3, (Object)selectPlotVariablesJDialog3._removeButton, "removeModelVariable"));
        this._removeButton.setIcon(RmaImage.getImageIcon((String)"Images/backbutton.gif"));
        this._removeButton.setMnemonic('R');
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)0, (int)0, (int)0);
        serializable.add(this._removeButton, gridBagConstraints);
        serializable = new JLabel("Selected", 0);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)serializable, gridBagConstraints);
        SelectPlotVariablesJDialog selectPlotVariablesJDialog4 = this;
        this._selectedTree = new SelectPlotVariablesJDialog$2(selectPlotVariablesJDialog4, selectPlotVariablesJDialog4._selectedRoot);
        this._selectedTree.addMouseListener((MouseListener)new PopupNodeListener(this._selectedTree));
        this._selectedTree.setCellRenderer(new SelectPlotVariablesJDialog$PlotTreeCellRenderer(this));
        serializable = new SelectPlotVariablesJDialog$ViewportNode(this, new Viewport());
        this._selectedRoot.add((MutableTreeNode)((Object)serializable));
        ((DefaultTreeModel)this._selectedTree.getModel()).nodeStructureChanged(this._selectedRoot);
        this._selectedTree.setRootVisible(false);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)new JScrollPane(this._selectedTree), gridBagConstraints);
        this._spinPanel = new SelectPlotVariablesJDialog$3(this, new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)65, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this._spinPanel, gridBagConstraints);
        serializable = new Insets(0, 0, 0, 0);
        this._spinUpButton = new JButton(RmaImage.getImageIcon((String)"Images/spinUp.gif"));
        SelectPlotVariablesJDialog selectPlotVariablesJDialog5 = this;
        this._spinUpButton.addActionListener((ActionListener)this._listener.add((Object)selectPlotVariablesJDialog5, (Object)selectPlotVariablesJDialog5._spinUpButton, "spinUp"));
        this._spinUpButton.setToolTipText("Move Up");
        this._spinUpButton.setMnemonic('U');
        this._spinUpButton.setMargin((Insets)serializable);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        this._spinPanel.add((Component)this._spinUpButton, gridBagConstraints);
        this._spinDownButton = new JButton(RmaImage.getImageIcon((String)"Images/spinDown.gif"));
        SelectPlotVariablesJDialog selectPlotVariablesJDialog6 = this;
        this._spinDownButton.addActionListener((ActionListener)this._listener.add((Object)selectPlotVariablesJDialog6, (Object)selectPlotVariablesJDialog6._spinDownButton, "spinDown"));
        this._spinDownButton.setToolTipText("Move Down");
        this._spinDownButton.setMnemonic('D');
        this._spinDownButton.setMargin((Insets)serializable);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)0, (int)0, (int)0);
        this._spinPanel.add((Component)this._spinDownButton, gridBagConstraints);
        this._cmdPanel = new ButtonCmdPanel(14);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this._cmdPanel, gridBagConstraints);
        this._cmdPanel.addCmdPanelListener((ButtonCmdPanelListener)new SelectPlotVariablesJDialog$4(this));
        this.pack();
        this.setLocation();
        this._selectedTree.addMouseListener((MouseListener)new PopupNodeListener(this._selectedTree));
        this._selectedTree.getSelectionModel().setSelectionMode(1);
        this._selectedTree.addTreeSelectionListener(new SelectPlotVariablesJDialog$5(this));
        this._selectedTree.setSelectionRow(0);
        this._availableTree.addTreeSelectionListener(new SelectPlotVariablesJDialog$6(this));
        this._addButton.setEnabled(false);
        SelectPlotVariablesJDialog selectPlotVariablesJDialog7 = this;
        selectPlotVariablesJDialog7.expandAllTreeNodes(selectPlotVariablesJDialog7._selectedTree);
    }

    private void buildMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Plot");
        jMenu.setMnemonic('P');
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Close", 67);
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "closeDialog"));
        jMenu.add(jMenuItem);
        jMenu = new JMenu("Edit");
        jMenu.setMnemonic('E');
        jMenuBar.add(jMenu);
        this._addViewportMenuItem = new JMenuItem("Add Plot Region", 65);
        SelectPlotVariablesJDialog selectPlotVariablesJDialog = this;
        this._addViewportMenuItem.addActionListener((ActionListener)this._listener.add((Object)selectPlotVariablesJDialog, (Object)selectPlotVariablesJDialog._addViewportMenuItem, "addViewport"));
        jMenu.add(this._addViewportMenuItem);
        this._removeViewportMenuItem = new JMenuItem("Remove Plot Region", 82);
        SelectPlotVariablesJDialog selectPlotVariablesJDialog2 = this;
        this._removeViewportMenuItem.addActionListener((ActionListener)this._listener.add((Object)selectPlotVariablesJDialog2, (Object)selectPlotVariablesJDialog2._removeViewportMenuItem, "removeViewport"));
        jMenu.add(this._removeViewportMenuItem);
        jMenu.addSeparator();
        this._addAxisMenuItem = new JMenuItem("Add Y Axis", 89);
        SelectPlotVariablesJDialog selectPlotVariablesJDialog3 = this;
        this._addAxisMenuItem.addActionListener((ActionListener)this._listener.add((Object)selectPlotVariablesJDialog3, (Object)selectPlotVariablesJDialog3._addAxisMenuItem, "addAxis"));
        jMenu.add(this._addAxisMenuItem);
        this._removeAxisMenuItem = new JMenuItem("Remove Y Axis", 69);
        SelectPlotVariablesJDialog selectPlotVariablesJDialog4 = this;
        this._removeAxisMenuItem.addActionListener((ActionListener)this._listener.add((Object)selectPlotVariablesJDialog4, (Object)selectPlotVariablesJDialog4._removeAxisMenuItem, "removeAxis"));
        jMenu.add(this._removeAxisMenuItem);
        jMenu.addSeparator();
        this._weightsMenuItem = new JMenuItem("Set Plot Region Weights", 83);
        SelectPlotVariablesJDialog selectPlotVariablesJDialog5 = this;
        this._weightsMenuItem.addActionListener((ActionListener)this._listener.add((Object)selectPlotVariablesJDialog5, (Object)selectPlotVariablesJDialog5._weightsMenuItem, "setViewportWeights"));
        jMenu.add(this._weightsMenuItem);
        this.setJMenuBar(jMenuBar);
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public void expandAllTreeNodes(JTree jTree) {
        for (int i = 0; i < jTree.getRowCount(); ++i) {
            jTree.expandRow(i);
        }
    }

    public void setSelectedViewports(Vector vector) {
        this._selectedRoot.removeAllChildren();
        ((DefaultTreeModel)this._selectedTree.getModel()).nodeStructureChanged(this._selectedRoot);
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Object object = vector.get(i);
            if (!(object instanceof Viewport)) continue;
            object = (Viewport)object;
            this.addViewport((Viewport)object);
        }
    }

    public void setAvailablePlotObjects(Vector vector) {
        this._availRoot.removeAllChildren();
        ((DefaultTreeModel)this._availableTree.getModel()).nodeStructureChanged(this._availRoot);
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Object object = vector.get(i);
            if (!(object instanceof PlottableObject)) continue;
            object = (PlottableObject)object;
            object = object.getModelVariables(null);
            this.addModelVariables((Vector)object);
        }
        SelectPlotVariablesJDialog selectPlotVariablesJDialog = this;
        selectPlotVariablesJDialog.expandAllTreeNodes(selectPlotVariablesJDialog._availableTree);
    }

    protected void addModelVariables(Vector vector) {
        if (vector == null || vector.size() == 0) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            int n;
            Object object = vector.get(i);
            if (!(object instanceof ModelVariable)) continue;
            ModelVariable modelVariable = (ModelVariable)object;
            object = modelVariable.getObjectType();
            int n2 = this._availRoot.getChildCount();
            boolean bl2 = false;
            for (n = 0; n < n2; ++n) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)this._availRoot.getChildAt(n);
                if (!defaultMutableTreeNode.toString().equals(object)) continue;
                bl2 = true;
                break;
            }
            if (bl2) {
                n2 = defaultMutableTreeNode.getChildCount();
                bl2 = false;
                for (n = 0; n < n2; ++n) {
                    object = (SelectPlotVariablesJDialog$VariableNode)defaultMutableTreeNode.getChildAt(n);
                    if (!(object = ((SelectPlotVariablesJDialog$VariableNode)object).getModelVariable()).getName().equals(modelVariable.getName())) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                defaultMutableTreeNode.add(new SelectPlotVariablesJDialog$VariableNode(this, modelVariable));
                bl = true;
                continue;
            }
            defaultMutableTreeNode = new DefaultMutableTreeNode(modelVariable.getObjectType());
            this._availRoot.add(defaultMutableTreeNode);
            defaultMutableTreeNode.add(new SelectPlotVariablesJDialog$VariableNode(this, modelVariable));
            bl = true;
        }
        if (bl) {
            ((DefaultTreeModel)this._availableTree.getModel()).nodeStructureChanged(this._availRoot);
        }
    }

    boolean saveForm() {
        if (this._plotDialog == null) {
            System.out.println("saveForm() WARNING: Calling dialog not a PlotDialog");
            return false;
        }
        SelectPlotVariablesJDialog selectPlotVariablesJDialog = this;
        return selectPlotVariablesJDialog.buildPlot(selectPlotVariablesJDialog._plotDialog, this._selectedRoot);
    }

    boolean buildPlot(PlotDialog plotDialog, DefaultMutableTreeNode defaultMutableTreeNode) {
        int n;
        Object object;
        int n2 = defaultMutableTreeNode.getChildCount();
        Vector vector = this._plotDialog.getPlotpanel().getPlotObjects();
        TimeWindowPlotData timeWindowPlotData = null;
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                object = vector.get(i);
                if (!(object instanceof TimeWindowPlotData)) continue;
                timeWindowPlotData = (TimeWindowPlotData)object;
                vector.remove(timeWindowPlotData);
                break;
            }
        }
        G2dPanel g2dPanel = plotDialog.getG2dPanel();
        g2dPanel.setVisible(false);
        G2dPanelProp g2dPanelProp = g2dPanel.getProperties();
        g2dPanel.clearPanel();
        boolean[] blArray = new boolean[]{false, false};
        boolean[] blArray2 = new boolean[]{false, false};
        GridBagLayout gridBagLayout = new GridBagLayout();
        g2dPanel.setLayout((LayoutManager)gridBagLayout);
        ViewportToolbar viewportToolbar = new ViewportToolbar(g2dPanel);
        g2dPanel.createDefaultMapTools(viewportToolbar);
        viewportToolbar.addToolbarListener((G2dToolbarListener)g2dPanel);
        g2dPanel.setLegendPanel(new LegendPanel(g2dPanel));
        g2dPanel.getLegendPanel().setBorder(BorderFactory.createLoweredBevelBorder());
        g2dPanel.moveLegendToPosition(g2dPanelProp.legendProp.layoutPosition);
        vector = g2dPanel.getTitlePanel();
        Object object2 = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        ((GridBagConstraints)object2).gridy = 0;
        ((GridBagConstraints)object2).gridwidth = 0;
        ((GridBagConstraints)object2).anchor = 10;
        ((GridBagConstraints)object2).fill = 2;
        ((GridBagConstraints)object2).weightx = 1.0;
        ((GridBagConstraints)object2).weighty = 0.0;
        ((GridBagConstraints)object2).insets = new Insets(0, 0, 0, 0);
        g2dPanel.add((Component)((Object)vector), object2);
        Vector vector2 = new Vector();
        Vector<Color> vector3 = new Vector<Color>();
        double d = 100.0 / (double)n2;
        int n3 = 0;
        Axis[] axisArray = new Axis[2];
        Axis[] axisArray2 = axisArray;
        axisArray[0] = AxisFactory.createAxis((int)1, (String)"minutes");
        DataTypeFactory.getFactory().reset();
        for (n = 0; n < n2; ++n) {
            int n4;
            if (n == n2 - 1) {
                blArray[0] = true;
            }
            object2 = (SelectPlotVariablesJDialog$ViewportNode)defaultMutableTreeNode.getChildAt(n);
            vector = ((SelectPlotVariablesJDialog$ViewportNode)object2).getViewport();
            if (((SelectPlotVariablesJDialog$ViewportNode)object2).getWeight() == -1) {
                ((SelectPlotVariablesJDialog$ViewportNode)object2).setWeight((int)d);
            }
            vector.getScaleVector().clear();
            int n5 = ((DefaultMutableTreeNode)object2).getChildCount();
            Axis[] axisArray3 = new Axis[n5];
            Scale[] scaleArray = new Scale[n5];
            boolean[] blArray3 = new boolean[n5];
            boolean[] blArray4 = new boolean[n5];
            vector2.clear();
            for (n4 = 0; n4 < n5; ++n4) {
                Vector vector4 = new Vector();
                object = (SelectPlotVariablesJDialog$AxisNode)((DefaultMutableTreeNode)object2).getChildAt(n4);
                Vector vector5 = ((SelectPlotVariablesJDialog$AxisNode)object).getModelVariables();
                ((SelectPlotVariablesJDialog$AxisNode)object).getParamId();
                this.getG2dObjects((SelectPlotVariablesJDialog$AxisNode)object, vector4);
                vector2.addAll(vector4);
                blArray3[n4] = true;
                blArray4[n4] = true;
                vector = ((SelectPlotVariablesJDialog$AxisNode)object).getAxis();
                object = Parameter.getParamString((int)((SelectPlotVariablesJDialog$AxisNode)object).getParamId());
                vector.setLabel((String)object + " (%S)");
                if (vector4.size() > 0) {
                    object = (G2dObject)vector4.get(0);
                    object = object.getYAxisName();
                }
                Vector vector6 = vector;
                vector6.setName(vector6.getLabel());
                axisArray3[n4] = vector;
                scaleArray[n4] = new Scale(((String)object).toLowerCase().concat(" vs minutes"));
                scaleArray[n4].setAxis(axisArray2[0], 0);
                scaleArray[n4].setAxis(axisArray3[n4], 1);
                if (vector5 != null) {
                    scaleArray[n4].getModelVariables().clear();
                    for (int i = 0; i < vector5.size(); ++i) {
                        ((ModelVariable)vector5.get(i)).setScaleIndex(n4);
                    }
                    scaleArray[n4].getModelVariables().addAll(vector5);
                }
                g2dPanel.addScaleToTable(scaleArray[n4].getName(), scaleArray[n4]);
            }
            vector = g2dPanel.buildPlotComponents(0, n, 1.0, (double)((SelectPlotVariablesJDialog$ViewportNode)object2).getWeight() / 100.0, axisArray2, axisArray3, scaleArray, blArray, blArray2, blArray[0], blArray3, blArray4, true);
            if (vector3.size() < vector2.size() + n3) {
                for (int i = n4 = vector3.size(); i < vector2.size() + n3; ++i) {
                    vector3.addElement(G2dPanel.getLineColors()[i % G2dPanel.getLineColors().length]);
                }
            }
            for (int i = 0; i < vector2.size(); ++i) {
                int n6 = -1;
                G2dObject g2dObject = (G2dObject)vector2.get(i);
                if (g2dObject instanceof SimpleDSSData) {
                    object2 = (SimpleDSSData)g2dObject;
                    object = object2.getModelVariable();
                    object2 = object != null ? this._plotDialog.getParamFromModelVariable((ModelVariable)object) : null;
                    if (n5 > 0 && scaleArray[0].getModelVariables().contains(object)) {
                        n6 = 0;
                    } else if (n5 > 1 && scaleArray[1].getModelVariables().contains(object)) {
                        n6 = 1;
                    }
                } else {
                    object2 = null;
                }
                if (n6 == 0) {
                    vector.addG2dObject(g2dObject, DataTypeFactory.getFactory().getLineProperties((G2dDssObject)((SimpleDSSData)g2dObject), (String)object2, true), scaleArray[0]);
                    continue;
                }
                if (n6 == 1) {
                    vector.addG2dObject(g2dObject, DataTypeFactory.getFactory().getLineProperties((G2dDssObject)((SimpleDSSData)g2dObject), (String)object2, true), scaleArray[1]);
                    continue;
                }
                vector.addG2dObject(g2dObject, DataTypeFactory.getFactory().getLineProperties((G2dDssObject)((SimpleDSSData)g2dObject), (String)object2, true));
            }
            n3 += vector2.size();
            viewportToolbar.addViewport((Viewport)vector);
            viewportToolbar.addToolbarListener((G2dToolbarListener)vector);
            if (g2dPanel.getLegendPanel() != null) {
                g2dPanel.getLegendPanel().addViewport((Viewport)vector);
            }
            vector.addObjectSelectionListener((ObjectSelectionListener)g2dPanel);
            g2dPanel.getViewportVector().add(vector);
        }
        if (timeWindowPlotData != null) {
            this._plotDialog.getG2dPanel().plotTimeWindow(timeWindowPlotData);
        }
        Insets insets = new Insets(3, 3, 3, 3);
        object2 = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object2).gridy = 0;
        ((GridBagConstraints)object2).gridheight = 0;
        ((GridBagConstraints)object2).fill = 3;
        ((GridBagConstraints)object2).weightx = 0.0;
        ((GridBagConstraints)object2).weighty = 1.0;
        ((GridBagConstraints)object2).insets = insets;
        gridBagLayout.setConstraints((Component)viewportToolbar, (GridBagConstraints)object2);
        g2dPanel.add((Component)viewportToolbar);
        g2dPanel.addLegendContainers();
        g2dPanel.moveLegendToPosition(g2dPanelProp.legendProp.layoutPosition);
        if (g2dPanel.getLegendPanel() != null) {
            g2dPanel.getLegendPanel().fillGlyphVector();
        }
        viewportToolbar.addToolbarListener((G2dToolbarListener)g2dPanel);
        object = g2dPanel.getComponents();
        if (object != null) {
            for (int i = 0; i < ((Object)object).length; ++i) {
                if (!(object[i] instanceof AxisTics) && !(object[i] instanceof Viewport)) continue;
                viewportToolbar.addToolbarListener((G2dToolbarListener)((G2dComponent)object[i]));
            }
        }
        PlotDialog plotDialog2 = plotDialog;
        plotDialog2.updateUnitSystem((Container)((Object)plotDialog2));
        g2dPanel.revalidate();
        g2dPanel.paintGfx();
        for (n = 0; n < this._selectedRoot.getChildCount(); ++n) {
            ((SelectPlotVariablesJDialog$ViewportNode)this._selectedRoot.getChildAt(n)).setName(null);
        }
        g2dPanel.setVisible(true);
        return true;
    }

    public void closeDialog() {
        this.isModified();
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] object) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {}
        object = new SelectPlotVariablesJDialog(new Frame());
        Vector<Element> vector = new Vector<Element>(1);
        vector.add(new JunctionElement());
        vector.add(new DiversionElement());
        vector.add(new ReservoirElement());
        ((SelectPlotVariablesJDialog)((Object)object)).setAvailablePlotObjects(vector);
        object.setVisible(true);
    }

    void addViewport() {
        this.addViewport(new Viewport());
    }

    void addViewport(Viewport viewport) {
        SelectPlotVariablesJDialog$ViewportNode selectPlotVariablesJDialog$ViewportNode = new SelectPlotVariablesJDialog$ViewportNode(this, viewport);
        this._selectedRoot.add(selectPlotVariablesJDialog$ViewportNode);
        int n = this._selectedRoot.getIndex(selectPlotVariablesJDialog$ViewportNode);
        if (n != -1) {
            this.intarray[0] = n;
            ((DefaultTreeModel)this._selectedTree.getModel()).nodesWereInserted(this._selectedRoot, this.intarray);
            this._selectedTree.expandPath(new TreePath(selectPlotVariablesJDialog$ViewportNode.getPath()));
        }
        for (n = 0; n < viewport.getScaleVector().size(); ++n) {
            Scale scale = (Scale)viewport.getScaleVector().get(n);
            if (scale == null) continue;
            SelectPlotVariablesJDialog$AxisNode selectPlotVariablesJDialog$AxisNode = (SelectPlotVariablesJDialog$AxisNode)selectPlotVariablesJDialog$ViewportNode.getChildAt(n);
            this.addToAxis(selectPlotVariablesJDialog$AxisNode, scale.getModelVariables());
        }
        this._weightsMenuItem.setEnabled(this._selectedRoot.getChildCount() > 1);
        this.setModified(true);
    }

    void removeViewport() {
        Object object = this._selectedTree.getSelectionPath();
        if (object == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please selected the Plot Region to remove");
            return;
        }
        if (!((object = ((TreePath)object).getLastPathComponent()) instanceof SelectPlotVariablesJDialog$ViewportNode)) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please selected the Plot Region to remove");
            return;
        }
        int n = this._selectedTree.getModel().getChildCount(this._selectedRoot);
        if (n == 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Can not remove the last Plot Region");
            return;
        }
        SelectPlotVariablesJDialog$ViewportNode selectPlotVariablesJDialog$ViewportNode = (SelectPlotVariablesJDialog$ViewportNode)object;
        int n2 = this._selectedRoot.getIndex(selectPlotVariablesJDialog$ViewportNode);
        this._selectedRoot.remove(selectPlotVariablesJDialog$ViewportNode);
        this.intarray[0] = n2;
        ((DefaultTreeModel)this._selectedTree.getModel()).nodesWereRemoved(this._selectedRoot, this.intarray, new Object[]{object});
        this._weightsMenuItem.setEnabled(this._selectedRoot.getChildCount() > 1);
        this.setModified(true);
    }

    void addAxis() {
        Object object = this._selectedTree.getSelectionPath();
        if (object == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please selected the Plot Region to add the Axis to");
            return;
        }
        if (!((object = ((TreePath)object).getLastPathComponent()) instanceof SelectPlotVariablesJDialog$ViewportNode)) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please selected the Plot Region to add the Axis to");
            return;
        }
        object = (SelectPlotVariablesJDialog$ViewportNode)object;
        SelectPlotVariablesJDialog$AxisNode selectPlotVariablesJDialog$AxisNode = new SelectPlotVariablesJDialog$AxisNode(this, AxisFactory.createAxis((int)0, (String)""));
        selectPlotVariablesJDialog$AxisNode.setReversed(true);
        ((SelectPlotVariablesJDialog$ViewportNode)object).add(selectPlotVariablesJDialog$AxisNode);
        int n = ((DefaultMutableTreeNode)object).getIndex(selectPlotVariablesJDialog$AxisNode);
        if (n != -1) {
            this.intarray[0] = n;
            ((DefaultTreeModel)this._selectedTree.getModel()).nodesWereInserted((TreeNode)object, this.intarray);
        }
        this.setModified(true);
    }

    void removeAxis() {
        Object object = this._selectedTree.getSelectionPath();
        if (object == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please selected the Axis to remove");
            return;
        }
        if (!((object = ((TreePath)object).getLastPathComponent()) instanceof SelectPlotVariablesJDialog$AxisNode)) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please selected an Axis to remove");
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)((SelectPlotVariablesJDialog$AxisNode)object).getParent();
        int n = this._selectedTree.getModel().getChildCount(defaultMutableTreeNode);
        if (n == 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Can't remove the last Axis from the Plot Region");
            return;
        }
        this.intarray[0] = n = defaultMutableTreeNode.getIndex((SelectPlotVariablesJDialog$AxisNode)object);
        defaultMutableTreeNode.remove((SelectPlotVariablesJDialog$AxisNode)object);
        ((DefaultTreeModel)this._selectedTree.getModel()).nodesWereRemoved(defaultMutableTreeNode, this.intarray, new Object[]{object});
        this.setModified(true);
    }

    void spinUp() {
        TreePath treePath = this._selectedTree.getSelectionPath();
        if (treePath == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please select a Plot Region or Axis to move");
            return;
        }
        Object object = treePath.getLastPathComponent();
        if (!(object instanceof SelectPlotVariablesJDialog$ViewportNode) && !(object instanceof SelectPlotVariablesJDialog$AxisNode)) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please select a Plot Region or Axis to move");
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)((DefaultMutableTreeNode)(object = (DefaultMutableTreeNode)object)).getParent();
        int n = defaultMutableTreeNode.getIndex((TreeNode)object);
        if (n == 0) {
            return;
        }
        int n2 = this._selectedTree.getModel().getChildCount(this._selectedRoot);
        if (n2 == 1) {
            return;
        }
        n2 = this._selectedTree.isExpanded(treePath) ? 1 : 0;
        defaultMutableTreeNode.remove((MutableTreeNode)object);
        this.intarray[0] = n;
        ((DefaultTreeModel)this._selectedTree.getModel()).nodesWereRemoved(defaultMutableTreeNode, this.intarray, new Object[]{object});
        defaultMutableTreeNode.insert((MutableTreeNode)object, n - 1);
        this.intarray[0] = n - 1;
        ((DefaultTreeModel)this._selectedTree.getModel()).nodesWereInserted(defaultMutableTreeNode, this.intarray);
        if (n2 != 0) {
            treePath = new TreePath(((DefaultMutableTreeNode)object).getPath());
            this._selectedTree.expandPath(treePath);
        }
        this._selectedTree.setSelectionPath(treePath);
        this.setModified(true);
    }

    void spinDown() {
        TreePath treePath = this._selectedTree.getSelectionPath();
        if (treePath == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please selected a Plot Region or Axis to move");
            return;
        }
        Object object = treePath.getLastPathComponent();
        if (!(object instanceof SelectPlotVariablesJDialog$ViewportNode) && !(object instanceof SelectPlotVariablesJDialog$AxisNode)) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please selected a Plot Region or Axis to move");
            return;
        }
        object = (DefaultMutableTreeNode)object;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)((DefaultMutableTreeNode)object).getParent();
        int n = defaultMutableTreeNode.getIndex((TreeNode)object);
        int n2 = this._selectedTree.getModel().getChildCount(defaultMutableTreeNode);
        if (n2 == 1) {
            return;
        }
        if (n + 1 == n2) {
            return;
        }
        n2 = this._selectedTree.isExpanded(treePath) ? 1 : 0;
        defaultMutableTreeNode.remove((MutableTreeNode)object);
        this.intarray[0] = n;
        ((DefaultTreeModel)this._selectedTree.getModel()).nodesWereRemoved(defaultMutableTreeNode, this.intarray, new Object[]{object});
        defaultMutableTreeNode.insert((MutableTreeNode)object, n + 1);
        this.intarray[0] = n + 1;
        ((DefaultTreeModel)this._selectedTree.getModel()).nodesWereInserted(defaultMutableTreeNode, this.intarray);
        if (n2 != 0) {
            treePath = new TreePath(((DefaultMutableTreeNode)object).getPath());
            this._selectedTree.expandPath(treePath);
        }
        this._selectedTree.setSelectionPath(treePath);
        this.setModified(true);
    }

    void removeModelVariable() {
        Object object = this._selectedTree.getSelectionPath();
        if (object == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please select the Variable to remove");
            return;
        }
        if (!((object = ((TreePath)object).getLastPathComponent()) instanceof SelectPlotVariablesJDialog$VariableNode)) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please select the Variable to remove");
            return;
        }
        object = (SelectPlotVariablesJDialog$VariableNode)object;
        SelectPlotVariablesJDialog$ObjectTypeNode selectPlotVariablesJDialog$ObjectTypeNode = (SelectPlotVariablesJDialog$ObjectTypeNode)((DefaultMutableTreeNode)object).getParent();
        int n = selectPlotVariablesJDialog$ObjectTypeNode.getIndex((TreeNode)object);
        SelectPlotVariablesJDialog$AxisNode selectPlotVariablesJDialog$AxisNode = (SelectPlotVariablesJDialog$AxisNode)selectPlotVariablesJDialog$ObjectTypeNode.getParent();
        int n2 = selectPlotVariablesJDialog$AxisNode.getIndex(selectPlotVariablesJDialog$ObjectTypeNode);
        selectPlotVariablesJDialog$ObjectTypeNode.remove((MutableTreeNode)object);
        if (selectPlotVariablesJDialog$AxisNode.getIndex(selectPlotVariablesJDialog$ObjectTypeNode) == -1) {
            this.intarray[0] = n2;
            ((DefaultTreeModel)this._selectedTree.getModel()).nodesWereRemoved(selectPlotVariablesJDialog$AxisNode, this.intarray, new Object[]{selectPlotVariablesJDialog$ObjectTypeNode});
            return;
        }
        this.intarray[0] = n;
        ((DefaultTreeModel)this._selectedTree.getModel()).nodesWereRemoved(selectPlotVariablesJDialog$ObjectTypeNode, this.intarray, new Object[]{object});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void addModelVariable() {
        int n;
        Object object = this._availableTree.getSelectionPath();
        if (object == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please select the Variable to add");
            return;
        }
        if (!((object = ((TreePath)object).getLastPathComponent()) instanceof SelectPlotVariablesJDialog$VariableNode)) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please select the Variable to add");
            return;
        }
        object = (SelectPlotVariablesJDialog$VariableNode)object;
        Serializable serializable = this._selectedTree.getSelectionPath();
        SelectPlotVariablesJDialog$ViewportNode selectPlotVariablesJDialog$ViewportNode = null;
        SelectPlotVariablesJDialog$AxisNode selectPlotVariablesJDialog$AxisNode = null;
        boolean bl = false;
        if (serializable != null) {
            if ((serializable = (DefaultMutableTreeNode)((TreePath)serializable).getLastPathComponent()) instanceof SelectPlotVariablesJDialog$ViewportNode) {
                selectPlotVariablesJDialog$ViewportNode = (SelectPlotVariablesJDialog$ViewportNode)serializable;
            } else if (serializable instanceof SelectPlotVariablesJDialog$AxisNode) {
                selectPlotVariablesJDialog$ViewportNode = (SelectPlotVariablesJDialog$ViewportNode)((DefaultMutableTreeNode)serializable).getParent();
                selectPlotVariablesJDialog$AxisNode = (SelectPlotVariablesJDialog$AxisNode)serializable;
            } else if (serializable instanceof SelectPlotVariablesJDialog$VariableNode) {
                selectPlotVariablesJDialog$AxisNode = (SelectPlotVariablesJDialog$AxisNode)((DefaultMutableTreeNode)serializable).getParent().getParent();
                selectPlotVariablesJDialog$ViewportNode = (SelectPlotVariablesJDialog$ViewportNode)selectPlotVariablesJDialog$AxisNode.getParent();
            }
        }
        serializable = (ModelVariable)((SelectPlotVariablesJDialog$VariableNode)object).getModelVariable().clone();
        int n2 = serializable.getParamId();
        serializable.getObjectType();
        int n3 = SelectPlotVariablesJDialog.getUnitSystem();
        String string = Parameter.getUnitsStringForSystem((int)n2, (int)n3);
        if (string == null) {
            System.out.println("unable to determine units for " + serializable.getObjectType() + ":" + serializable.getName());
            return;
        }
        if (selectPlotVariablesJDialog$AxisNode != null) {
            if (selectPlotVariablesJDialog$AxisNode.getParamId() == -1 || selectPlotVariablesJDialog$AxisNode.getUnits().equals(string)) {
                this.addToAxis(selectPlotVariablesJDialog$AxisNode, (ModelVariable)serializable);
                return;
            }
            if (selectPlotVariablesJDialog$ViewportNode.getChildCount() < 2) {
                SelectPlotVariablesJDialog$AxisNode selectPlotVariablesJDialog$AxisNode2 = new SelectPlotVariablesJDialog$AxisNode(this, AxisFactory.createAxis((int)0, (String)""));
                selectPlotVariablesJDialog$AxisNode2.setReversed(true);
                selectPlotVariablesJDialog$ViewportNode.add(selectPlotVariablesJDialog$AxisNode2);
                int n4 = selectPlotVariablesJDialog$ViewportNode.getIndex(selectPlotVariablesJDialog$AxisNode2);
                object = new SelectPlotVariablesJDialog$ObjectTypeNode(this);
                selectPlotVariablesJDialog$AxisNode2.add((MutableTreeNode)object);
                ((SelectPlotVariablesJDialog$ObjectTypeNode)object).add(new SelectPlotVariablesJDialog$VariableNode(this, (ModelVariable)serializable));
                this.intarray[0] = n4;
                ((DefaultTreeModel)this._selectedTree.getModel()).nodesWereInserted(selectPlotVariablesJDialog$ViewportNode, this.intarray);
                this._selectedTree.expandPath(new TreePath(((DefaultMutableTreeNode)object).getPath()));
                return;
            }
            JOptionPane.showMessageDialog((Component)((Object)this), "Unable to add " + String.valueOf(object) + ", parameter types don't match Axis selected.\nPlot Region selected already has 2 Axis.", "Warning", 2);
            return;
        }
        if (selectPlotVariablesJDialog$ViewportNode != null) {
            int n5;
            n3 = selectPlotVariablesJDialog$ViewportNode.getChildCount();
            bl = false;
            for (n5 = 0; n5 < n3; ++n5) {
                selectPlotVariablesJDialog$AxisNode = (SelectPlotVariablesJDialog$AxisNode)selectPlotVariablesJDialog$ViewportNode.getChildAt(n5);
                if (!selectPlotVariablesJDialog$AxisNode.getUnits().equals(string)) continue;
                this.addToAxis(selectPlotVariablesJDialog$AxisNode, (ModelVariable)serializable);
                return;
            }
            if (!bl) {
                for (n5 = 0; n5 < n3; ++n5) {
                    selectPlotVariablesJDialog$AxisNode = (SelectPlotVariablesJDialog$AxisNode)selectPlotVariablesJDialog$ViewportNode.getChildAt(n5);
                    if (selectPlotVariablesJDialog$AxisNode.getParamId() != -1) continue;
                    this.addToAxis(selectPlotVariablesJDialog$AxisNode, (ModelVariable)serializable);
                    return;
                }
            }
            if (bl || n3 >= 2) {
                if (bl) return;
                if (n3 != 2) return;
                JOptionPane.showMessageDialog((Component)((Object)this), "Unable to add " + String.valueOf(object) + ", parameter types don't match existing axis.", "Warning", 2);
                return;
            }
        } else {
            int n6;
            int n7;
            int n8;
            n3 = this._selectedRoot.getChildCount();
            for (n8 = 0; n8 < n3; ++n8) {
                selectPlotVariablesJDialog$ViewportNode = (SelectPlotVariablesJDialog$ViewportNode)this._selectedRoot.getChildAt(n8);
                n7 = selectPlotVariablesJDialog$ViewportNode.getChildCount();
                for (n6 = 0; n6 < n7; ++n6) {
                    selectPlotVariablesJDialog$AxisNode = (SelectPlotVariablesJDialog$AxisNode)selectPlotVariablesJDialog$ViewportNode.getChildAt(n6);
                    if (!selectPlotVariablesJDialog$AxisNode.getUnits().equals(string)) continue;
                    this.addToAxis(selectPlotVariablesJDialog$AxisNode, (ModelVariable)serializable);
                    bl = true;
                    break;
                }
                if (bl) break;
            }
            n8 = 0;
            while (n8 < n3) {
                selectPlotVariablesJDialog$ViewportNode = (SelectPlotVariablesJDialog$ViewportNode)this._selectedRoot.getChildAt(n8);
                n7 = selectPlotVariablesJDialog$ViewportNode.getChildCount();
                for (n6 = 0; n6 < n7; ++n6) {
                    selectPlotVariablesJDialog$AxisNode = (SelectPlotVariablesJDialog$AxisNode)selectPlotVariablesJDialog$ViewportNode.getChildAt(n6);
                    if (selectPlotVariablesJDialog$AxisNode.getParamId() != -1) continue;
                    this.addToAxis(selectPlotVariablesJDialog$AxisNode, (ModelVariable)serializable);
                    return;
                }
                if (bl) return;
                ++n8;
            }
            return;
        }
        SelectPlotVariablesJDialog$AxisNode selectPlotVariablesJDialog$AxisNode3 = new SelectPlotVariablesJDialog$AxisNode(this, AxisFactory.createAxis((int)0, (String)""));
        selectPlotVariablesJDialog$AxisNode3.setReversed(true);
        selectPlotVariablesJDialog$ViewportNode.add(selectPlotVariablesJDialog$AxisNode3);
        this.intarray[0] = n = selectPlotVariablesJDialog$ViewportNode.getIndex(selectPlotVariablesJDialog$AxisNode3);
        ((DefaultTreeModel)this._selectedTree.getModel()).nodesWereInserted(selectPlotVariablesJDialog$ViewportNode, this.intarray);
        this.addToAxis(selectPlotVariablesJDialog$AxisNode3, (ModelVariable)serializable);
    }

    private void addToAxis(SelectPlotVariablesJDialog$AxisNode selectPlotVariablesJDialog$AxisNode, Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            this.addToAxis(selectPlotVariablesJDialog$AxisNode, (ModelVariable)vector.get(i));
        }
    }

    private void addToAxis(SelectPlotVariablesJDialog$AxisNode selectPlotVariablesJDialog$AxisNode, ModelVariable object) {
        SelectPlotVariablesJDialog$ObjectTypeNode selectPlotVariablesJDialog$ObjectTypeNode;
        int n;
        SelectPlotVariablesJDialog$VariableNode selectPlotVariablesJDialog$VariableNode = new SelectPlotVariablesJDialog$VariableNode(this, (ModelVariable)object);
        int n2 = selectPlotVariablesJDialog$AxisNode.getChildCount();
        object = object.getObjectType();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            selectPlotVariablesJDialog$ObjectTypeNode = (SelectPlotVariablesJDialog$ObjectTypeNode)selectPlotVariablesJDialog$AxisNode.getChildAt(n);
            if (!selectPlotVariablesJDialog$ObjectTypeNode.getObjectType().equals(object)) continue;
            selectPlotVariablesJDialog$ObjectTypeNode.add(selectPlotVariablesJDialog$VariableNode);
            n3 = selectPlotVariablesJDialog$ObjectTypeNode.getIndex(selectPlotVariablesJDialog$VariableNode);
            if (n3 != -1) {
                this.intarray[0] = n3;
                ((DefaultTreeModel)this._selectedTree.getModel()).nodesWereInserted(selectPlotVariablesJDialog$ObjectTypeNode, this.intarray);
                this._selectedTree.expandPath(new TreePath(selectPlotVariablesJDialog$AxisNode.getPath()));
            }
            n3 = 1;
            this.setModified(true);
        }
        if (n3 == 0) {
            selectPlotVariablesJDialog$ObjectTypeNode = new SelectPlotVariablesJDialog$ObjectTypeNode(this);
            selectPlotVariablesJDialog$ObjectTypeNode.add(selectPlotVariablesJDialog$VariableNode);
            selectPlotVariablesJDialog$AxisNode.add(selectPlotVariablesJDialog$ObjectTypeNode);
            this.intarray[0] = n = selectPlotVariablesJDialog$AxisNode.getIndex(selectPlotVariablesJDialog$ObjectTypeNode);
            ((DefaultTreeModel)this._selectedTree.getModel()).nodesWereInserted(selectPlotVariablesJDialog$AxisNode, this.intarray);
            this._selectedTree.expandPath(new TreePath(selectPlotVariablesJDialog$ObjectTypeNode.getPath()));
            this.setModified(true);
        }
    }

    void setViewportWeights() {
        SelectPlotVariablesJDialog selectPlotVariablesJDialog = this;
        SelectPlotVariablesJDialog$ViewportWeightsDialog selectPlotVariablesJDialog$ViewportWeightsDialog = new SelectPlotVariablesJDialog$ViewportWeightsDialog(selectPlotVariablesJDialog, (Dialog)((Object)selectPlotVariablesJDialog), true);
        selectPlotVariablesJDialog$ViewportWeightsDialog.fillForm(this._selectedRoot);
        selectPlotVariablesJDialog$ViewportWeightsDialog.setVisible(true);
    }

    public Vector getG2dObjects(SelectPlotVariablesJDialog$AxisNode selectPlotVariablesJDialog$AxisNode, Vector vector) {
        if (vector == null) {
            vector = new Vector();
        }
        if (selectPlotVariablesJDialog$AxisNode == null) {
            return vector;
        }
        if (this._plotDialog == null) {
            return vector;
        }
        new Vector();
        for (int i = 0; i < selectPlotVariablesJDialog$AxisNode.getChildCount(); ++i) {
            SelectPlotVariablesJDialog$ObjectTypeNode selectPlotVariablesJDialog$ObjectTypeNode = (SelectPlotVariablesJDialog$ObjectTypeNode)selectPlotVariablesJDialog$AxisNode.getChildAt(i);
            for (int j = 0; j < selectPlotVariablesJDialog$ObjectTypeNode.getChildCount(); ++j) {
                Cloneable cloneable = (SelectPlotVariablesJDialog$VariableNode)selectPlotVariablesJDialog$ObjectTypeNode.getChildAt(j);
                if ((cloneable = ((SelectPlotVariablesJDialog$VariableNode)cloneable).getModelVariable()) == null || (cloneable = this._plotDialog.getG2dObjects((ModelVariable)cloneable)) == null || ((Vector)cloneable).size() == 0) continue;
                vector.addAll(cloneable);
            }
        }
        System.out.println("getG2dObjects: returning " + vector.size());
        return vector;
    }

    public void reverseAxis() {
        Object object = this._selectedTree.getSelectionPath();
        if (object == null) {
            System.out.println("reverseAxis: no path selected");
            return;
        }
        if ((object = (TreeNode)((TreePath)object).getLastPathComponent()) == null) {
            System.out.println("reverseAxis: no last Path component found");
            return;
        }
        if (!(object instanceof SelectPlotVariablesJDialog$AxisNode)) {
            System.out.println("reverseAxis: selected node is not an Axis");
            return;
        }
        ((SelectPlotVariablesJDialog$AxisNode)object).setReversed(!((SelectPlotVariablesJDialog$AxisNode)(object = (SelectPlotVariablesJDialog$AxisNode)object)).isReversed());
        this.setModified(true);
    }
}

