/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientWorkspace;
import hec.clientapp.rmi.csinterface.RmiApp;
import hec.clientapp.rmi.csinterface.RmiWorkspace;
import hec.gui.WizardPanel;
import hec.io.Identifier;
import hec.model.WatershedLocation;
import hec.rss.client.SelectWatershedWizardPanel$1;
import hec.rss.client.SelectWatershedWizardPanel$2;
import hec.rss.client.SelectWatershedWizardPanel$3;
import hec.watershed.model.Study;
import hec.watershed.model.StudyDataList;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import mil.army.usace.hec.rmi.client.RmiFileChooserField;
import rma.swing.RmaInsets;
import rma.swing.RmaJTable;
import rma.swing.table.ColumnGroup;
import rma.swing.table.GroupableTableHeader;

public class SelectWatershedWizardPanel
extends WizardPanel {
    public static final String PANEL_NAME = "SelectWatershed";
    private JPanel _locationPanel;
    private RmaJTable _locationsList;
    private JPanel _workspacePanel;
    private RmaJTable _workspaceTable;
    private JLabel _panelTitle;
    protected RmiApp _rmiApp;
    protected ClientWorkspace _wksp;
    private RmiFileChooserField _wkspChooserFld;

    public SelectWatershedWizardPanel() {
        super((LayoutManager)new GridBagLayout());
        this.buildControls();
    }

    protected void buildControls() {
        ColumnGroup columnGroup;
        JLabel jLabel;
        Object object;
        this._panelTitle = new JLabel("Select the Watershed");
        Serializable serializable = this._panelTitle.getFont();
        this._panelTitle.setFont(new Font(serializable.getName(), 1, serializable.getSize()));
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridwidth = 0;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)4, (int)4, (int)4, (int)4);
        SelectWatershedWizardPanel selectWatershedWizardPanel = this;
        selectWatershedWizardPanel.add(selectWatershedWizardPanel._panelTitle, serializable);
        if (Boolean.getBoolean("NO_PREDEFINED_WKSP")) {
            object = new JPanel(new GridBagLayout());
            ((GridBagConstraints)serializable).gridx = -1;
            ((GridBagConstraints)serializable).gridy = -1;
            ((GridBagConstraints)serializable).gridwidth = 0;
            ((GridBagConstraints)serializable).weightx = 1.0;
            ((GridBagConstraints)serializable).weighty = 0.0;
            ((GridBagConstraints)serializable).anchor = 17;
            ((GridBagConstraints)serializable).fill = 2;
            ((GridBagConstraints)serializable).insets = RmaInsets.INSETS0000;
            this.add((Component)object, serializable);
            jLabel = new JLabel("Watershed File:");
            ((GridBagConstraints)serializable).gridx = -1;
            ((GridBagConstraints)serializable).gridy = -1;
            ((GridBagConstraints)serializable).gridwidth = 1;
            ((GridBagConstraints)serializable).weightx = 0.0;
            ((GridBagConstraints)serializable).weighty = 0.0;
            ((GridBagConstraints)serializable).anchor = 17;
            ((GridBagConstraints)serializable).fill = 0;
            ((GridBagConstraints)serializable).insets = RmaInsets.INSETS5505;
            ((Container)object).add((Component)jLabel, serializable);
            this._wkspChooserFld = new RmiFileChooserField();
            this._wkspChooserFld.setDefaultPath(ClientApp.Workspace().getWorkspacePath());
            columnGroup = new ArrayList();
            columnGroup.add("*.wksp");
            this._wkspChooserFld.setFilters(columnGroup);
            ((GridBagConstraints)serializable).gridx = -1;
            ((GridBagConstraints)serializable).gridy = -1;
            ((GridBagConstraints)serializable).gridwidth = 0;
            ((GridBagConstraints)serializable).weightx = 1.0;
            ((GridBagConstraints)serializable).weighty = 0.0;
            ((GridBagConstraints)serializable).anchor = 17;
            ((GridBagConstraints)serializable).fill = 2;
            ((GridBagConstraints)serializable).insets = RmaInsets.INSETS5505;
            ((Container)object).add((Component)this._wkspChooserFld, serializable);
            ((GridBagConstraints)serializable).gridx = -1;
            ((GridBagConstraints)serializable).gridy = -1;
            ((GridBagConstraints)serializable).gridwidth = 0;
            ((GridBagConstraints)serializable).weightx = 1.0;
            ((GridBagConstraints)serializable).weighty = 0.0;
            ((GridBagConstraints)serializable).anchor = 17;
            ((GridBagConstraints)serializable).fill = 2;
            ((GridBagConstraints)serializable).insets = RmaInsets.INSETS5505;
            this.add(new JSeparator(), serializable);
        }
        this._locationPanel = new JPanel(new GridBagLayout());
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        ((GridBagConstraints)serializable).gridy = -1;
        ((GridBagConstraints)serializable).gridwidth = 1;
        ((GridBagConstraints)serializable).weightx = 0.5;
        ((GridBagConstraints)serializable).weighty = 1.0;
        ((GridBagConstraints)serializable).anchor = 17;
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)4, (int)4, (int)4, (int)4);
        SelectWatershedWizardPanel selectWatershedWizardPanel2 = this;
        selectWatershedWizardPanel2.add(selectWatershedWizardPanel2._locationPanel, serializable);
        SelectWatershedWizardPanel selectWatershedWizardPanel3 = this;
        this._locationsList = new SelectWatershedWizardPanel$1(selectWatershedWizardPanel3, (Component)((Object)selectWatershedWizardPanel3), new String[]{"Watershed Locations"});
        object = this._locationsList.getColumnModel();
        jLabel = new GroupableTableHeader((TableColumnModel)object);
        this._locationsList.setTableHeader((JTableHeader)((Object)jLabel));
        this._locationsList.setToolTipText("");
        this._locationsList.setSelectionMode(0);
        ((GridBagConstraints)serializable).gridx = -1;
        ((GridBagConstraints)serializable).gridy = -1;
        ((GridBagConstraints)serializable).gridwidth = 1;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 1.0;
        ((GridBagConstraints)serializable).anchor = 17;
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)4, (int)4, (int)4, (int)4);
        this._locationPanel.add((Component)new JScrollPane((Component)this._locationsList), serializable);
        this._workspacePanel = new JPanel(new GridBagLayout());
        ((GridBagConstraints)serializable).gridx = -1;
        ((GridBagConstraints)serializable).gridy = -1;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).weightx = 1.5;
        ((GridBagConstraints)serializable).weighty = 1.0;
        ((GridBagConstraints)serializable).anchor = 13;
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)4, (int)4, (int)4, (int)4);
        SelectWatershedWizardPanel selectWatershedWizardPanel4 = this;
        selectWatershedWizardPanel4.add(selectWatershedWizardPanel4._workspacePanel, serializable);
        SelectWatershedWizardPanel selectWatershedWizardPanel5 = this;
        this._workspaceTable = new SelectWatershedWizardPanel$2(selectWatershedWizardPanel5, (Component)((Object)selectWatershedWizardPanel5), new String[]{"Name", "Description"});
        object = this._workspaceTable.getColumnModel();
        jLabel = new GroupableTableHeader((TableColumnModel)object);
        this._workspaceTable.setTableHeader((JTableHeader)((Object)jLabel));
        columnGroup = new ColumnGroup("Watersheds");
        columnGroup.add((Object)object.getColumn(0));
        columnGroup.add((Object)object.getColumn(1));
        jLabel.addColumnGroup(columnGroup);
        this._workspaceTable.setToolTipText("");
        this._workspaceTable.setCellSelectionEnabled(false);
        this._workspaceTable.setColumnSelectionAllowed(false);
        this._workspaceTable.setRowSelectionAllowed(true);
        this._workspaceTable.setSelectionMode(0);
        this._workspaceTable.setShowGrid(false);
        this._workspaceTable.setEditable(false);
        this._workspaceTable.setPopupMenuEnabled(false);
        this._workspaceTable.setColumnWidths(new int[]{100, 150});
        this._workspaceTable.getCellRenderer(0, 0);
        ((GridBagConstraints)serializable).gridx = -1;
        ((GridBagConstraints)serializable).gridy = -1;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).weightx = 2.0;
        ((GridBagConstraints)serializable).weighty = 1.0;
        ((GridBagConstraints)serializable).anchor = 13;
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)4, (int)4, (int)4, (int)4);
        this._workspacePanel.add((Component)this._workspaceTable.getScrollPane(), serializable);
        this._locationsList.getSelectionModel().addListSelectionListener(new SelectWatershedWizardPanel$3(this));
    }

    protected void setAvailableWorkspaces(List list) {
        this._workspaceTable.deleteCells();
        if (list == null) {
            return;
        }
        Collections.sort(list);
        for (int i = 0; i < list.size(); ++i) {
            Vector vector = new Vector(2);
            Object e = list.get(i);
            vector.add(e);
            if (e instanceof Identifier) {
                vector.add(((Identifier)e).getDescription());
            }
            this._workspaceTable.appendRow(vector);
        }
        if (list.size() > 0) {
            this._workspaceTable.updateSelection(0, 0, false, false);
            this._workspaceTable.requestDefaultFocus();
            this._workspaceTable.grabFocus();
        }
    }

    public void setAppServer(RmiApp object) {
        this._rmiApp = object;
        this._locationsList.deleteCells();
        if (this._rmiApp != null) {
            try {
                object = ClientApp.app().getWatershedLocations(true);
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    Vector vector = new Vector(1);
                    vector.add(((Vector)object).get(i));
                    this._locationsList.appendRow(vector);
                }
                if (this._locationsList.getRowCount() > 0) {
                    this._locationsList.updateSelection(0, 0, false, false);
                }
                return;
            }
            catch (Exception exception) {
                System.out.println("setAppServer: Error retrieving available workspace locations from app " + String.valueOf(exception));
            }
        }
    }

    public String getPanelName() {
        return PANEL_NAME;
    }

    public boolean isValidPanel() {
        boolean bl = this.getSelectedWatershedIdentifier() != null;
        if (!bl) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please select a Watershed", "No Watershed Selected", 0);
        }
        return bl;
    }

    public Identifier getSelectedWatershedIdentifier() {
        String string = this._wkspChooserFld.getPath();
        if (string != null && !string.isEmpty()) {
            return new Identifier(string);
        }
        int n = this._workspaceTable.getSelectedRow();
        if (n >= 0) {
            return (Identifier)this._workspaceTable.getCell(n, 0);
        }
        return null;
    }

    public ClientWorkspace openSelectedWorkspace() {
        Identifier identifier = this.getSelectedWatershedIdentifier();
        if (identifier == null) {
            return this._wksp;
        }
        if (identifier.getPath().equals(ClientApp.Workspace().getWorkspaceConfigFile("main"))) {
            this._wksp = ClientApp.Workspace();
        } else if (this._wksp == null || !identifier.getPath().equals(this._wksp.getWorkspacePath())) {
            this.closeSelectedWorkspace();
            try {
                String[] stringArray = ClientApp.app().getAppServer().getBindingSites();
                String string = null;
                if (ClientApp.app().isNetworked() && stringArray != null && stringArray.length > 0) {
                    string = stringArray[0];
                }
                identifier = ClientApp.Workspace().getData().openWorkspace(identifier, string);
                this._wksp = new ClientWorkspace(ClientApp.app(), (RmiWorkspace)identifier);
                identifier = this._wksp.getDataListContainer();
                if (identifier != null && (identifier = (StudyDataList)identifier.getDataList(Study.class.getName())) != null) {
                    identifier.getOpenStudy();
                }
            }
            catch (RemoteException remoteException) {
                System.out.println("openWorkspace: RMI Error opening workspace " + String.valueOf(remoteException));
            }
        }
        return this._wksp;
    }

    public void closeSelectedWorkspace() {
        if (this._wksp != null && ClientApp.Workspace() != this._wksp) {
            this._wksp.close();
            this._wksp = null;
        }
    }

    public void setSelectedWatershedLocation(WatershedLocation watershedLocation) {
        if (watershedLocation == null) {
            this._locationsList.clearSelection();
            return;
        }
        for (int i = 0; i < this._locationsList.getRowCount(); ++i) {
            Object object = this._locationsList.getValueAt(i, 0);
            if (!watershedLocation.equals(object)) continue;
            int n = i;
            this._locationsList.updateSelection(n, n, false, false);
            return;
        }
    }

    public void setSelectedWorkspace(Identifier identifier) {
        if (identifier == null) {
            return;
        }
        int n = this._workspaceTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object object = this._workspaceTable.getValueAt(i, 0);
            if (!(object instanceof Identifier) || !(object = (Identifier)object).equals((Object)identifier)) continue;
            this._workspaceTable.updateSelection(i, 0, false, false);
            return;
        }
    }
}

