/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.model.SimRunInfo;
import hec.clientapp.model.SimulationPeriod;
import hec.io.Identifier;
import hec.rss.client.SimulationListReport$1;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;
import rma.util.RMAIO;

public class SimulationListReport
extends RmaJDialog {
    private RmaJTable _simTable;
    private ButtonCmdPanel _cmdPanel;

    public SimulationListReport(Frame frame) {
        super(frame, false);
        this.buildControls();
        this.addListeners();
        this.fillForm();
        this.pack();
        this.setSize(800, 300);
        SimulationListReport simulationListReport = this;
        simulationListReport.setLocationRelativeTo(simulationListReport.getParent());
    }

    protected void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        Object object = new String[]{"Simulation", "Description", "Lookback Time", "Start Time", "End Time", "Alternative", "Last Computed"};
        this._simTable = new RmaJTable((Component)((Object)this), object);
        this._simTable.setEditable(false);
        this._simTable.setColumnWidths(new int[]{115, 173, 107, 107, 107, 85, 107});
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 0;
        object.weightx = 1.0;
        object.weighty = 1.0;
        object.anchor = 18;
        object.fill = 1;
        object.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._simTable.getScrollPane(), object);
        this._cmdPanel = new ButtonCmdPanel(256);
        object.gridx = 0;
        object.gridy = 1;
        object.weightx = 1.0;
        object.weighty = 0.0;
        object.anchor = 16;
        object.fill = 2;
        object.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._cmdPanel, object);
    }

    public void addListeners() {
        this._cmdPanel.addCmdPanelListener((ButtonCmdPanelListener)new SimulationListReport$1(this));
    }

    public void fillForm() {
        this.setTitle("Simulation List for " + ClientApp.Workspace().getTitleName());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("ddMMMyyyy HHmm");
        this._simTable.deleteCells();
        this._simTable.clearColors();
        Color color = new Color(245, 245, 245);
        String string = ClientApp.app().getAppType();
        Vector vector = ClientApp.Workspace().getManagerIDList(string, SimulationPeriod.class.getName());
        int n = vector.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Date date;
            long l;
            Identifier identifier = (Identifier)vector.get(i);
            identifier = (SimulationPeriod)ClientApp.Workspace().loadManager(string, SimulationPeriod.class.getName(), identifier);
            if (identifier == null) continue;
            SimRunInfo[] simRunInfoArray = identifier.getRunTimeWindow();
            Vector<String> vector2 = new Vector<String>();
            vector2.add(identifier.getName());
            vector2.add(identifier.getDescription());
            vector2.add(simRunInfoArray.getLookbackTimeString());
            vector2.add(simRunInfoArray.getStartTimeString());
            vector2.add(simRunInfoArray.getEndTimeString());
            simRunInfoArray = identifier.getAlternativeInfo();
            if (simRunInfoArray != null && simRunInfoArray.length > 0) {
                vector2.add(RMAIO.removeTrailingChars((String)simRunInfoArray[0].getName(), (char)'-'));
                l = identifier.getLastComputeTime(simRunInfoArray[0].getIndex());
                if (l > 0L) {
                    date = new Date(l);
                    vector2.add(simpleDateFormat.format(date));
                } else {
                    vector2.add("N/A");
                }
            }
            this._simTable.appendRow(vector2);
            this._simTable.setRowBackground(n2, color);
            ++n2;
            if (simRunInfoArray == null || simRunInfoArray.length <= 1) continue;
            for (int j = 1; j < simRunInfoArray.length; ++j) {
                vector2 = new Vector<String>();
                vector2.add("");
                vector2.add("");
                vector2.add("");
                vector2.add("");
                vector2.add("");
                vector2.add(RMAIO.removeTrailingChars((String)simRunInfoArray[j].getName(), (char)'-'));
                l = identifier.getLastComputeTime(simRunInfoArray[j].getIndex());
                if (l != 0L) {
                    date = new Date(l);
                    vector2.add(simpleDateFormat.format(date));
                } else {
                    vector2.add("N/A");
                }
                this._simTable.appendRow(vector2);
                ++n2;
            }
        }
    }
}

