/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientMode;
import hec.clientapp.client.HecClientFrame;
import hec.clientapp.model.SimulationRun;
import hec.lang.NamedType;
import hec.map.LayerSelectionFactory;
import hec.map.LocalPt;
import hec.map.MapGlyph;
import hec.map.MapObjectInterface;
import hec.map.MapPanel;
import hec.map.MapScale;
import hec.map.ModelDrawingAttributeSet;
import hec.map.WorldPt;
import hec.rss.client.SimulationRunGlyphSelection;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class SimulationRunGlyph
extends MapGlyph {
    SimulationRun _simulationRun;
    protected Vector _modelGlyphs = new Vector();
    List _selectionList = new ArrayList();
    boolean _shown = true;

    public SimulationRunGlyph(MapPanel mapPanel, SimulationRun simulationRun) {
        super(mapPanel, (MapObjectInterface)simulationRun);
        this.initializeGlyph(mapPanel, simulationRun);
    }

    public void setShown(boolean bl) {
        for (int i = 0; i < this._modelGlyphs.size(); ++i) {
            MapGlyph mapGlyph = (MapGlyph)this._modelGlyphs.elementAt(i);
            if (mapGlyph == null) continue;
            mapGlyph.setShown(bl);
        }
    }

    public boolean isShown() {
        if (!this._shown) {
            return false;
        }
        for (int i = 0; i < this._modelGlyphs.size(); ++i) {
            MapGlyph mapGlyph = (MapGlyph)this._modelGlyphs.elementAt(i);
            if (mapGlyph == null || !mapGlyph.isShown()) continue;
            return true;
        }
        return false;
    }

    public boolean isAttributeAvailable(String string) {
        if (string == null) {
            return true;
        }
        for (int i = 0; i < this._modelGlyphs.size(); ++i) {
            MapGlyph mapGlyph = (MapGlyph)this._modelGlyphs.elementAt(i);
            if (mapGlyph == null || !mapGlyph.getAttributeSet().getName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public String getToolTipText(WorldPt worldPt, MouseEvent mouseEvent) {
        MapGlyph mapGlyph;
        if (worldPt == null) {
            return null;
        }
        String string = null;
        for (int i = this._modelGlyphs.size() - 1; !(i < 0 || (mapGlyph = (MapGlyph)this._modelGlyphs.elementAt(i)) != null && mapGlyph.isShown() && (string = mapGlyph.getToolTipText(worldPt, mouseEvent)) != null); --i) {
        }
        return string;
    }

    public NamedType[] findObjects(LocalPt localPt) {
        if (this._simulationRun == null || localPt == null) {
            return null;
        }
        Vector<MapGlyph> vector = new Vector<MapGlyph>();
        for (int i = 0; i < this._modelGlyphs.size(); ++i) {
            MapGlyph mapGlyph = (MapGlyph)this._modelGlyphs.elementAt(i);
            if (mapGlyph == null || !mapGlyph.isShown() || (mapGlyph = mapGlyph.findObject(localPt)) == null) continue;
            vector.addElement(mapGlyph);
        }
        Object[] objectArray = new NamedType[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public NamedType[] getSelections() {
        for (int i = 0; i < this._modelGlyphs.size(); ++i) {
            NamedType[] namedTypeArray = (NamedType[])this._modelGlyphs.get(i);
            if ((namedTypeArray = namedTypeArray.getSelections()) == null) continue;
            return namedTypeArray;
        }
        return new NamedType[0];
    }

    public NamedType getSelectedObject() {
        for (int i = 0; i < this.glyphVector().size(); ++i) {
            MapGlyph mapGlyph = (MapGlyph)this.glyphVector().get(i);
            if (mapGlyph == null || (mapGlyph = mapGlyph.getSelectedObject()) == null) continue;
            return mapGlyph;
        }
        return null;
    }

    public boolean objectPopupMenu(LocalPt localPt, int n) {
        Object[] objectArray = this.findObjects(localPt);
        if (objectArray != null && objectArray.length > 0) {
            boolean bl = !SimulationRunGlyph.isShiftDown((int)n) && !this.containsSelection(objectArray);
            this.objectSelect(localPt, n, bl);
            NamedType[] namedTypeArray = this.getSelections();
            for (int i = 0; i < namedTypeArray.length; ++i) {
                MapGlyph.Selection selection = new MapGlyph.Selection((MapGlyph)this, (Object)namedTypeArray[i], false);
                this._selectionList.add(selection);
            }
            HecClientFrame hecClientFrame = ClientApp.frame();
            ClientMode clientMode = hecClientFrame.getCurrentMode();
            return clientMode.objectPopupMenu(namedTypeArray, localPt);
        }
        return false;
    }

    public boolean containsSelection(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            for (int j = 0; j < this._modelGlyphs.size(); ++j) {
                MapGlyph mapGlyph = (MapGlyph)this._modelGlyphs.get(j);
                if (mapGlyph == null || !mapGlyph.isShown() || !mapGlyph.containsSelection(objectArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    public NamedType objectSelect(LocalPt localPt, int n) {
        int n2 = n;
        return this.objectSelect(localPt, n2, !SimulationRunGlyph.isShiftDown((int)n2));
    }

    protected NamedType objectSelect(LocalPt localPt, int n, boolean n2) {
        NamedType[] namedTypeArray = this.findObjects(localPt);
        if (n2 != 0) {
            this.clearSelection();
        }
        if (namedTypeArray != null && namedTypeArray.length > 0) {
            for (n2 = 0; n2 < this._modelGlyphs.size(); ++n2) {
                MapGlyph mapGlyph = (MapGlyph)this._modelGlyphs.elementAt(n2);
                if (mapGlyph == null) continue;
                mapGlyph.objectSelect(localPt, n);
            }
            return namedTypeArray[0];
        }
        this.clearSelection();
        return null;
    }

    public boolean objectDoubleClick(LocalPt localPt, int n) {
        NamedType[] namedTypeArray = this.findObjects(localPt);
        if (namedTypeArray != null && namedTypeArray.length > 0) {
            ClientMode clientMode;
            this._selectionList.clear();
            for (int i = 0; i < namedTypeArray.length; ++i) {
                clientMode = new MapGlyph.Selection((MapGlyph)this, (Object)namedTypeArray[i], false);
                this._selectionList.add(clientMode);
            }
            HecClientFrame hecClientFrame = ClientApp.frame();
            clientMode = hecClientFrame.getCurrentMode();
            clientMode.objectDoubleClick(namedTypeArray[0], localPt);
            return true;
        }
        return false;
    }

    public void clearSelection() {
        this._selectionList.clear();
        boolean bl = false;
        for (int i = 0; i < this._modelGlyphs.size(); ++i) {
            MapGlyph mapGlyph = (MapGlyph)this._modelGlyphs.elementAt(i);
            if (mapGlyph == null) continue;
            if (mapGlyph.getSelectedObject() != null) {
                bl = true;
            }
            mapGlyph.clearSelection();
        }
        if (bl) {
            this._mapPanel.paintMap();
            this._mapPanel.waitforPaintComplete();
        }
    }

    public void clearSelection(String string) {
        for (int i = 0; i < this._modelGlyphs.size(); ++i) {
            MapGlyph mapGlyph = (MapGlyph)this._modelGlyphs.elementAt(i);
            if (mapGlyph == null) continue;
            mapGlyph.clearSelection(string);
        }
    }

    public void draw(Graphics graphics, MapScale mapScale) {
        int n = this._mapPanel.getGlyphLevel((MapGlyph)this);
        for (int i = 0; i < this._modelGlyphs.size(); ++i) {
            MapGlyph mapGlyph = (MapGlyph)this._modelGlyphs.elementAt(i);
            if (mapGlyph == null || !mapGlyph.isShown()) continue;
            mapGlyph.setGlyphLevel((float)n);
            mapGlyph.draw(graphics, mapScale);
        }
    }

    public void showMapElement(String string, String string2, boolean bl) {
        if (string.equalsIgnoreCase("Model Schematic") && string2.equalsIgnoreCase("shown")) {
            this._shown = bl;
        }
        for (int i = 0; i < this._modelGlyphs.size(); ++i) {
            MapGlyph mapGlyph = (MapGlyph)this._modelGlyphs.elementAt(i);
            if (mapGlyph == null || !mapGlyph.getAttributeSet().getName().equalsIgnoreCase(string) || !string2.equalsIgnoreCase("shown")) continue;
            mapGlyph.setShown(bl);
        }
        for (int i = 0; i < this._modelGlyphs.size(); ++i) {
            ModelDrawingAttributeSet modelDrawingAttributeSet;
            string = (MapGlyph)this._modelGlyphs.elementAt(i);
            if (string == null || (modelDrawingAttributeSet = string.getAttributeSet()) == null || !modelDrawingAttributeSet.isValidAttribute(string2)) continue;
            modelDrawingAttributeSet.setAttribute(string2, bl);
            return;
        }
    }

    public boolean hasChildGlyphs() {
        return true;
    }

    public Vector glyphVector() {
        return (Vector)this._modelGlyphs.clone();
    }

    public MapGlyph findGlyphOfClass(String string) {
        if (string == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(string);
            for (int i = 0; i < this._modelGlyphs.size(); ++i) {
                MapGlyph mapGlyph = (MapGlyph)this._modelGlyphs.elementAt(i);
                if (!clazz.isInstance(mapGlyph)) continue;
                return mapGlyph;
            }
        }
        catch (Exception exception) {
            System.out.println("Class " + string + " not found.");
        }
        return null;
    }

    private void initializeGlyph(MapPanel mapPanel, SimulationRun simulationRun) {
        this._simulationRun = simulationRun;
        try {
            ClientApp.frame().setWaitCursor();
            return;
        }
        finally {
            ClientApp.frame().setDefaultCursor();
        }
    }

    protected void init() {
        super.init();
    }

    static {
        LayerSelectionFactory.addMapping((String)SimulationRunGlyph.class.getName(), (String)SimulationRunGlyphSelection.class.getName());
    }
}

