/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import com.google.common.flogger.FluentLogger;
import hec.clientapp.client.ClientApp;
import hec.data.Parameter;
import hec.gui.NameDialog;
import hec.gui.SelectorPanel;
import hec.rss.RssRmiWorkspace;
import hec.rss.client.DependenciesPanel;
import hec.rss.client.ScriptBuilderPanel;
import hec.rss.client.ScriptPanel;
import hec.rss.client.StateVariableDialog$1;
import hec.rss.client.StateVariableDialog$2;
import hec.rss.client.StateVariableDialog$3;
import hec.rss.client.StateVariableDialog$4;
import hec.rss.client.StateVariableDialog$5;
import hec.rss.client.scriptsSearch.ScriptSearchOptions;
import hec.rss.client.scriptsSearch.ScriptsSearchListener;
import hec.rss.client.scriptsSearch.StateVariableScriptSearchOptions;
import hec.rss.client.scriptsSearch.StateVariableScriptSearchResult;
import hec.rss.client.scriptsSearch.StateVariableScriptSearchResultsDlg;
import hec.rss.client.scriptsSearch.StateVariableScriptType;
import hec.rss.client.scriptsSearch.StateVariableSearchScriptsDialog;
import hec.rss.model.RssSystem;
import hec.rss.model.StateVariable;
import hec.rss.model.dependencies.DependencyFinder;
import hec.rss.server.RssAdvancedOptions;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.Document;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import mil.army.usace.hec.rmi.model.PreferencesManager;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RecordableTextAction;
import rma.swing.EnabledJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaJTextField;
import rma.swing.event.ReflectMultiListener;
import rma.swing.text.JythonNameDocument;

public class StateVariableDialog
extends RmaJDialog
implements ScriptsSearchListener {
    private static final FluentLogger a = FluentLogger.forEnclosingClass();
    public static final String TEMPLATE_FILE_NAME = "StateVariable.template";
    public static final String INIT_TEMPLATE_FILE_NAME = "StateVariableInit.template";
    public static final String CLEANUP_TEMPLATE_FILE_NAME = "StateVariableCleanup.template";
    public static final String JAR_TEMPLATE_FILE = "hec/rss/client/StateVariable.template";
    private SelectorPanel _selectorPanel;
    private JPanel _paramPanel;
    private RmaJTextField _paramNameTxt;
    private RmaJComboBox<String> _paramTypeCombo;
    private RmaJCheckBox _alwaysComputeCheck;
    private RmaJRadioButton _useScriptRadio;
    private RmaJRadioButton _useJavaClassRadio;
    private RmaJRadioButton _slaveSVRadio;
    private RmaJTextField _javaClassField;
    private JMenuItem _newMenuItem;
    private JMenuItem _saveMenuItem;
    private JMenuItem _renameMenuItem;
    private JMenuItem _deleteMenuItem;
    private JMenuItem _undoMenuItem;
    private JMenuItem _cutMenuItem;
    private JMenuItem _copyMenuItem;
    private JMenuItem _pasteMenuItem;
    private JMenuItem _importMenuItem;
    private JMenuItem _exportMenuItem;
    private boolean _controlsBuilt = false;
    private ReflectMultiListener _listener;
    private RssSystem _network;
    private StateVariable _stateVariable;
    private boolean _createdStateVariable;
    private JTabbedPane _tabbedPane;
    private ScriptPanel _initScriptPanel;
    private ScriptPanel _mainScriptPanel;
    private ScriptPanel _cleanupScriptPanel;
    private String _externalFileName = null;
    private RssAdvancedOptions _opt = this.getAdvancedOptions();
    private String _title;
    private JMenuItem _findMenu;
    private JMenuItem _searchAllScriptsMenu;
    private JMenuItem _replaceMenu;
    private StateVariableSearchScriptsDialog _svSearchDlg;
    private JMenuItem _gotoLineMenu;
    protected Point _lastResultsPos;
    private StateVariableScriptSearchResultsDlg _resultsDlg;
    private DependenciesPanel _dependenciesTabPane;

    public StateVariableDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.buildControls();
        this.addListeners();
    }

    public StateVariableDialog(Dialog dialog, boolean bl) {
        super(dialog, bl);
        this.buildControls();
        this.addListeners();
    }

    private RssAdvancedOptions getAdvancedOptions() {
        Object object = ClientApp.Workspace();
        if (object != null && (object = (RssRmiWorkspace)object.getChildWorkspace("rss")) != null) {
            try {
                this._opt = object.getRssAdvancedOptions();
                return this._opt;
            }
            catch (RemoteException remoteException) {}
        }
        return null;
    }

    protected void buildControls() {
        if (this._controlsBuilt) {
            return;
        }
        this.setDefaultCloseOperation(0);
        this._listener = new ReflectMultiListener();
        this._title = "State Variable Editor - Network: ";
        StateVariableDialog stateVariableDialog = this;
        stateVariableDialog.setTitle(stateVariableDialog._title);
        this.getContentPane().setLayout(new GridBagLayout());
        this._selectorPanel = new SelectorPanel(1);
        this._selectorPanel.setNameLabel("Name:");
        this._selectorPanel.setNameLabelMnemonic('N');
        Object object = this._selectorPanel.getComboBox().getPreferredSize();
        this._selectorPanel.getComboBox().getPreferredSize().width = 200;
        this._selectorPanel.getComboBox().setPreferredSize((Dimension)object);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).gridwidth = 2;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        ((GridBagConstraints)object).weightx = 1.0;
        this.getContentPane().add((Component)this._selectorPanel, object);
        Serializable serializable = new JSeparator();
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridy = 1;
        ((GridBagConstraints)object).gridwidth = 2;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        ((GridBagConstraints)object).weightx = 1.0;
        this.getContentPane().add((Component)serializable, object);
        this._paramPanel = new EnabledJPanel((LayoutManager)new GridBagLayout());
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridy = 2;
        ((GridBagConstraints)object).gridwidth = 2;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        ((GridBagConstraints)object).weightx = 1.0;
        this.getContentPane().add((Component)this._paramPanel, object);
        serializable = new JLabel("Parameter Name:");
        ((JLabel)serializable).setDisplayedMnemonic('P');
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).gridwidth = 1;
        ((GridBagConstraints)object).anchor = 17;
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        ((GridBagConstraints)object).weightx = 0.0;
        this._paramPanel.add((Component)serializable, object);
        this._paramNameTxt = new RmaJTextField();
        ((JLabel)serializable).setLabelFor((Component)this._paramNameTxt);
        this._paramNameTxt.setToolTipText("This becomes the DSS C Part when the Time Series is written to disk");
        ((JLabel)serializable).setLabelFor((Component)this._paramNameTxt);
        ((GridBagConstraints)object).gridx = 1;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).gridwidth = 1;
        ((GridBagConstraints)object).anchor = 17;
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        ((GridBagConstraints)object).weightx = 1.0;
        this._paramPanel.add((Component)this._paramNameTxt, object);
        serializable = new JLabel("Parameter Type:");
        ((JLabel)serializable).setDisplayedMnemonic('T');
        ((GridBagConstraints)object).gridx = 2;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).gridwidth = 1;
        ((GridBagConstraints)object).anchor = 17;
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        ((GridBagConstraints)object).weightx = 0.0;
        this._paramPanel.add((Component)serializable, object);
        this._paramTypeCombo = new RmaJComboBox((Object[])Parameter.getAvailableParameters());
        this._paramTypeCombo.setModifiable(true);
        ((JLabel)serializable).setLabelFor((Component)this._paramNameTxt);
        this._paramTypeCombo.setToolTipText("This is the units used for this State Variable");
        ((GridBagConstraints)object).gridx = 3;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).gridwidth = 1;
        ((GridBagConstraints)object).anchor = 17;
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        ((GridBagConstraints)object).weightx = 1.0;
        this._paramPanel.add((Component)this._paramTypeCombo, object);
        this._alwaysComputeCheck = new RmaJCheckBox("Compute As Post Process");
        this._alwaysComputeCheck.setToolTipText("<html>The State Variable will be computed even if<br>it is not referenced by an active rule</html>");
        ((GridBagConstraints)object).gridx = 4;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).anchor = 17;
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        ((GridBagConstraints)object).weightx = 0.0;
        this._paramPanel.add((Component)this._alwaysComputeCheck, object);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(""));
        serializable = new JLabel("State Variable Type:");
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).gridwidth = 1;
        ((GridBagConstraints)object).weightx = 0.0;
        ((GridBagConstraints)object).weighty = 0.0;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).insets = RmaInsets.INSETS5505;
        jPanel.add((Component)serializable, object);
        this._useScriptRadio = new RmaJRadioButton("Jython Script");
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).anchor = 17;
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)5);
        ((GridBagConstraints)object).weightx = 0.0;
        jPanel.add((Component)this._useScriptRadio, object);
        this._useScriptRadio.setSelected(true);
        this._slaveSVRadio = new RmaJRadioButton("Scriptless");
        object = "<html>For compute-time efficiency, use a scriptless state variable when another state<br>variable or scripted rule calculates the values stored to this state variable's time series. <br>NOTE: This state variable type will be deprecated in, and eventually removed from, future <br> versions of ResSim. Consider replacing this state variable with a Global Time Series Variable.</html>";
        this._slaveSVRadio.setToolTipText((String)object);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).anchor = 17;
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)0);
        jPanel.add((Component)this._slaveSVRadio, object);
        this._useJavaClassRadio = new RmaJRadioButton("Java Class");
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 3;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).anchor = 17;
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)5);
        ((GridBagConstraints)object).weightx = 0.0;
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add((AbstractButton)this._useScriptRadio);
        ((ButtonGroup)serializable).add((AbstractButton)this._slaveSVRadio);
        jPanel.add((Component)this._useJavaClassRadio, object);
        ((ButtonGroup)serializable).add((AbstractButton)this._useJavaClassRadio);
        if (this._opt != null) {
            this._useJavaClassRadio.setVisible(this._opt._allowStateVarAsJavaClass);
        }
        this._javaClassField = new RmaJTextField(10);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 4;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).anchor = 17;
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        ((GridBagConstraints)object).weightx = 0.5;
        jPanel.add((Component)this._javaClassField, object);
        ((GridBagConstraints)object).gridwidth = 4;
        if (this._opt != null) {
            this._javaClassField.setVisible(this._opt._allowStateVarAsJavaClass);
        }
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridy = 1;
        ((GridBagConstraints)object).gridwidth = 0;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 0.0;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).insets = RmaInsets.INSETS5505;
        this._paramPanel.add((Component)jPanel, object);
        this._tabbedPane = new JTabbedPane();
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridy = 3;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 1.0;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 1;
        ((GridBagConstraints)object).insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._tabbedPane, object);
        this._initScriptPanel = new ScriptPanel();
        this._tabbedPane.addTab("Initialization", (Component)((Object)this._initScriptPanel));
        this._mainScriptPanel = new ScriptPanel();
        this._tabbedPane.addTab("Main", (Component)((Object)this._mainScriptPanel));
        this._cleanupScriptPanel = new ScriptPanel();
        this._tabbedPane.addTab("CleanUp", (Component)((Object)this._cleanupScriptPanel));
        this._tabbedPane.setToolTipTextAt(0, "The script that is run during compute initialzation.");
        this._tabbedPane.setToolTipTextAt(1, "The script that is run during compute.");
        this._tabbedPane.setToolTipTextAt(2, "The script that is run during compute cleanup.");
        this._dependenciesTabPane = new DependenciesPanel();
        this._tabbedPane.addTab("Dependencies", (Component)((Object)this._dependenciesTabPane));
        this._tabbedPane.addChangeListener(changeEvent -> this.refreshDependencyTab());
        this.buildMenus();
        this.pack();
        this._controlsBuilt = true;
        StateVariableDialog stateVariableDialog2 = this;
        stateVariableDialog2.setLocationRelativeTo(stateVariableDialog2.getParent());
        this._tabbedPane.setSelectedIndex(1);
    }

    public void refreshDependencyTab() {
        Component component = this._tabbedPane.getSelectedComponent();
        boolean bl = Objects.equals(component, (Object)this._dependenciesTabPane);
        if (bl) {
            this._dependenciesTabPane.fillScriptText(this._initScriptPanel.getScriptPanel().getScriptText(), this._mainScriptPanel.getScriptPanel().getScriptText(), this._cleanupScriptPanel.getScriptPanel().getScriptText());
            return;
        }
        if (((ScriptPanel)this._dependenciesTabPane).shouldSaveScript()) {
            String string = this._mainScriptPanel.getScriptPanel().getScriptText();
            string = this._dependenciesTabPane.saveScriptText(string);
            this._mainScriptPanel.getScriptPanel().setScriptText(string);
        }
    }

    protected void addListeners() {
        this._selectorPanel.addItemListener((ItemListener)new StateVariableDialog$1(this));
        this.addWindowListener(new StateVariableDialog$2(this));
        this._tabbedPane.addChangeListener(new StateVariableDialog$3(this));
        this._useScriptRadio.addActionListener(actionEvent -> this.useScriptRadioAction());
        this._useJavaClassRadio.addActionListener(actionEvent -> this.useScriptRadioAction());
        this._slaveSVRadio.addActionListener(actionEvent -> this.useScriptRadioAction());
        this._searchAllScriptsMenu.addActionListener(actionEvent -> this.searchAllScriptsAction());
        this._findMenu.addActionListener(actionEvent -> this._searchAction());
        this._replaceMenu.addActionListener(actionEvent -> this.replaceAction());
        this._gotoLineMenu.addActionListener(actionEvent -> this.gotoLineAction());
        this._alwaysComputeCheck.addActionListener(actionEvent -> this.alwaysComputeCheckAction());
    }

    private void alwaysComputeCheckAction() {
        if (this._alwaysComputeCheck.isSelected()) {
            if (this._slaveSVRadio.isSelected()) {
                this._useScriptRadio.doClick(0);
            }
            this._slaveSVRadio.setEnabled(false);
            return;
        }
        this._slaveSVRadio.setEnabled(true);
    }

    private void gotoLineAction() {
        ScriptPanel scriptPanel = (ScriptPanel)((Object)this._tabbedPane.getSelectedComponent());
        scriptPanel.getScriptPanel().gotoLineAction();
    }

    private void replaceAction() {
        ScriptPanel scriptPanel = (ScriptPanel)((Object)this._tabbedPane.getSelectedComponent());
        scriptPanel.getScriptPanel().replaceAction();
    }

    public void _searchAction() {
        ScriptPanel scriptPanel = (ScriptPanel)((Object)this._tabbedPane.getSelectedComponent());
        scriptPanel.getScriptPanel().findAction();
    }

    private void searchAllScriptsAction() {
        if (this._svSearchDlg == null) {
            this._svSearchDlg = new StateVariableSearchScriptsDialog((Window)((Object)this));
            this._svSearchDlg.setTitle("Search All State Variables");
            this._svSearchDlg.addSearchListener(this);
        }
        this._svSearchDlg.setVisible(true);
    }

    @Override
    public void search(ScriptSearchOptions object) {
        if (object instanceof StateVariableScriptSearchOptions) {
            StateVariableScriptSearchOptions stateVariableScriptSearchOptions = (StateVariableScriptSearchOptions)object;
            int n = this._selectorPanel.getComboBox().getItemCount();
            ArrayList<StateVariableScriptSearchResult> arrayList = new ArrayList<StateVariableScriptSearchResult>();
            boolean bl = stateVariableScriptSearchOptions.b();
            String string = ((ScriptSearchOptions)object).a();
            for (int i = 0; i < n; ++i) {
                Object object2;
                object = (StateVariable)this._selectorPanel.getComboBox().getItemAt(i);
                if (stateVariableScriptSearchOptions.c()) {
                    object2 = object == this._stateVariable ? this._initScriptPanel.getScriptPanel().getScriptText() : ((StateVariable)object).getInitScript();
                    object2 = StateVariableDialog.a((StateVariable)object, StateVariableScriptType.Init, (String)object2, string, bl);
                    arrayList.addAll((Collection<StateVariableScriptSearchResult>)object2);
                    ((FluentLogger.Api)a.atFine()).log("searchAllScriptsAction:found [" + string + "] in " + object.getName() + " init script on lines " + String.valueOf(object2));
                }
                if (stateVariableScriptSearchOptions.d()) {
                    object2 = object == this._stateVariable ? this._mainScriptPanel.getScriptPanel().getScriptText() : ((StateVariable)object).getScript();
                    object2 = StateVariableDialog.a((StateVariable)object, StateVariableScriptType.Main, (String)object2, string, bl);
                    arrayList.addAll((Collection<StateVariableScriptSearchResult>)object2);
                    ((FluentLogger.Api)a.atFine()).log("searchAllScriptsAction:found [" + string + "] in " + object.getName() + " main script on lines " + String.valueOf(object2));
                }
                if (!stateVariableScriptSearchOptions.e()) continue;
                object2 = object == this._stateVariable ? this._cleanupScriptPanel.getScriptPanel().getScriptText() : ((StateVariable)object).getCleanupScript();
                object2 = StateVariableDialog.a((StateVariable)object, StateVariableScriptType.Cleanup, object2, string, bl);
                arrayList.addAll((Collection<StateVariableScriptSearchResult>)object2);
                ((FluentLogger.Api)a.atFine()).log("searchAllScriptsAction:found [" + string + "] in " + object.getName() + " cleanup script on lines " + String.valueOf(object2));
            }
            if ((this._resultsDlg == null || !this._resultsDlg.isVisible()) && arrayList.isEmpty()) {
                JOptionPane.showMessageDialog((Component)((Object)this), "<html>String <b>" + string + "</b> not found", "No Matches", 1);
                return;
            }
            if (this._resultsDlg == null) {
                StateVariableDialog stateVariableDialog = this;
                this._resultsDlg = new StateVariableDialog$4(stateVariableDialog, stateVariableDialog, arrayList, string);
                if (this._lastResultsPos != null) {
                    this._resultsDlg.setLocation(this._lastResultsPos);
                }
            } else {
                this._resultsDlg.fillForm(arrayList, string);
            }
            this._resultsDlg.setVisible(true);
        }
    }

    private static List<StateVariableScriptSearchResult> a(StateVariable stateVariable, StateVariableScriptType stateVariableScriptType, String object, String string, boolean bl) {
        ArrayList<StateVariableScriptSearchResult> arrayList = new ArrayList<StateVariableScriptSearchResult>();
        object = new LineNumberReader(new StringReader((String)object));
        if (!bl) {
            string = string.toLowerCase();
        }
        try {
            Object object2;
            while ((object2 = ((LineNumberReader)object).readLine()) != null) {
                if (!bl) {
                    object2 = ((String)object2).toLowerCase();
                }
                if (((String)object2).indexOf(string) < 0) continue;
                object2 = new StateVariableScriptSearchResult(stateVariable, stateVariableScriptType, (String)object2, ((LineNumberReader)object).getLineNumber());
                arrayList.add((StateVariableScriptSearchResult)object2);
            }
        }
        catch (IOException iOException) {
            ((FluentLogger.Api)((FluentLogger.Api)a.atInfo()).withCause((Throwable)iOException)).log("Error reading script during search");
        }
        return arrayList;
    }

    private void useScriptRadioAction() {
        if (this._useScriptRadio.isSelected()) {
            this._javaClassField.setEnabled(false);
            this._tabbedPane.setEnabledAt(0, true);
            this._tabbedPane.setEnabledAt(1, true);
            this._tabbedPane.setEnabledAt(2, true);
            this._initScriptPanel.getScriptPanel().setEnabled(true);
            this._mainScriptPanel.getScriptPanel().setEnabled(true);
            this._cleanupScriptPanel.getScriptPanel().setEnabled(true);
            this._alwaysComputeCheck.setEnabled(true);
            return;
        }
        if (this._useJavaClassRadio.isSelected()) {
            this._javaClassField.setEnabled(true);
            this._javaClassField.setEditable(true);
            this._tabbedPane.setEnabledAt(0, false);
            this._tabbedPane.setEnabledAt(1, false);
            this._tabbedPane.setEnabledAt(2, false);
            this._initScriptPanel.getScriptPanel().setEnabled(false);
            this._mainScriptPanel.getScriptPanel().setEnabled(false);
            this._cleanupScriptPanel.getScriptPanel().setEnabled(false);
            this._alwaysComputeCheck.setEnabled(true);
            return;
        }
        this._javaClassField.setEnabled(false);
        this._tabbedPane.setEnabledAt(0, true);
        this._tabbedPane.setEnabledAt(1, false);
        if (this._tabbedPane.getSelectedComponent() == this._mainScriptPanel) {
            this._tabbedPane.setSelectedIndex(0);
        }
        this._tabbedPane.setEnabledAt(2, true);
        this._initScriptPanel.getScriptPanel().setEnabled(true);
        this._mainScriptPanel.getScriptPanel().setEnabled(false);
        this._cleanupScriptPanel.getScriptPanel().setEnabled(true);
        this._alwaysComputeCheck.setSelected(false);
        this._alwaysComputeCheck.setEnabled(false);
    }

    protected void tabChangedAction() {
        this.updateEditMenu();
    }

    protected void buildMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("StateVariable");
        jMenu.setMnemonic('S');
        jMenuBar.add(jMenu);
        this._newMenuItem = new JMenuItem("New", 78);
        this._newMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        StateVariableDialog stateVariableDialog = this;
        this._newMenuItem.addActionListener((ActionListener)this._listener.add((Object)stateVariableDialog, (Object)stateVariableDialog._newMenuItem, "newStateVariable"));
        jMenu.add(this._newMenuItem);
        this._saveMenuItem = new JMenuItem("Save", 83);
        this._saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        StateVariableDialog stateVariableDialog2 = this;
        this._saveMenuItem.addActionListener((ActionListener)this._listener.add((Object)stateVariableDialog2, (Object)stateVariableDialog2._saveMenuItem, "saveStateVariable"));
        jMenu.add(this._saveMenuItem);
        this._renameMenuItem = new JMenuItem("Rename", 82);
        StateVariableDialog stateVariableDialog3 = this;
        this._renameMenuItem.addActionListener((ActionListener)this._listener.add((Object)stateVariableDialog3, (Object)stateVariableDialog3._renameMenuItem, "renameStateVariable"));
        jMenu.add(this._renameMenuItem);
        this._deleteMenuItem = new JMenuItem("Delete", 68);
        StateVariableDialog stateVariableDialog4 = this;
        this._deleteMenuItem.addActionListener((ActionListener)this._listener.add((Object)stateVariableDialog4, (Object)stateVariableDialog4._deleteMenuItem, "deleteStateVariable"));
        jMenu.add(this._deleteMenuItem);
        jMenu.addSeparator();
        this._importMenuItem = new JMenuItem("Import", 77);
        this._importMenuItem.setAccelerator(KeyStroke.getKeyStroke(77, 2));
        StateVariableDialog stateVariableDialog5 = this;
        this._importMenuItem.addActionListener((ActionListener)this._listener.add((Object)stateVariableDialog5, (Object)stateVariableDialog5._importMenuItem, "importStateVariable"));
        jMenu.add(this._importMenuItem);
        this._exportMenuItem = new JMenuItem("Export", 69);
        this._exportMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        StateVariableDialog stateVariableDialog6 = this;
        this._exportMenuItem.addActionListener((ActionListener)this._listener.add((Object)stateVariableDialog6, (Object)stateVariableDialog6._exportMenuItem, "exportStateVariable"));
        jMenu.add(this._exportMenuItem);
        jMenu.addSeparator();
        JMenuItem jMenuItem = new JMenuItem("Close", 67);
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "closeEditor"));
        jMenu.add(jMenuItem);
        jMenu = new JMenu("Edit");
        jMenu.setMnemonic('E');
        jMenuBar.add(jMenu);
        jMenu.addMenuListener(new StateVariableDialog$5(this));
        this._undoMenuItem = new JMenuItem("Undo", 85);
        this._undoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        StateVariableDialog stateVariableDialog7 = this;
        this._undoMenuItem.addActionListener((ActionListener)this._listener.add((Object)stateVariableDialog7, (Object)stateVariableDialog7._undoMenuItem, "undoStateVariable"));
        jMenu.add(this._undoMenuItem);
        jMenu.addSeparator();
        this._cutMenuItem = new JMenuItem("Cut", 116);
        this._cutMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        StateVariableDialog stateVariableDialog8 = this;
        this._cutMenuItem.addActionListener((ActionListener)this._listener.add((Object)stateVariableDialog8, (Object)stateVariableDialog8._cutMenuItem, "cutText"));
        jMenu.add(this._cutMenuItem);
        this._copyMenuItem = new JMenuItem("Copy", 67);
        this._copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        StateVariableDialog stateVariableDialog9 = this;
        this._copyMenuItem.addActionListener((ActionListener)this._listener.add((Object)stateVariableDialog9, (Object)stateVariableDialog9._copyMenuItem, "copyText"));
        jMenu.add(this._copyMenuItem);
        this._pasteMenuItem = new JMenuItem("Paste", 80);
        this._pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        StateVariableDialog stateVariableDialog10 = this;
        this._pasteMenuItem.addActionListener((ActionListener)this._listener.add((Object)stateVariableDialog10, (Object)stateVariableDialog10._pasteMenuItem, "pasteText"));
        jMenu.add(this._pasteMenuItem);
        jMenu = new JMenu("Search");
        jMenu.setMnemonic('S');
        jMenuBar.add(jMenu);
        this._findMenu = new JMenuItem("Find...", 70);
        this._findMenu.setAccelerator(KeyStroke.getKeyStroke("control F"));
        jMenu.add(this._findMenu);
        this._replaceMenu = new JMenuItem("Replace...", 82);
        this._replaceMenu.setAccelerator(KeyStroke.getKeyStroke("control R"));
        jMenu.add(this._replaceMenu);
        this._gotoLineMenu = new JMenuItem("Go to Line...", 71);
        this._gotoLineMenu.setAccelerator(KeyStroke.getKeyStroke("control L"));
        jMenu.add(this._gotoLineMenu);
        this._searchAllScriptsMenu = new JMenuItem("Search All State Variables...", 83);
        jMenu.add(this._searchAllScriptsMenu);
        this.setJMenuBar(jMenuBar);
        this._mainScriptPanel.getScriptPanel().updateMenus();
    }

    protected void updateEditMenu() {
        Object object = this._tabbedPane.getSelectedComponent();
        if (object instanceof ScriptPanel) {
            object = (ScriptPanel)((Object)object);
            object = ((ScriptPanel)((Object)object)).getScriptPanel();
            RecordableTextAction recordableTextAction = null;
            if (object != null) {
                object.getScriptTextArea();
                recordableTextAction = RSyntaxTextArea.getAction((int)6);
            }
            this._undoMenuItem.setAction((Action)recordableTextAction);
            boolean bl = false;
            if (object != null) {
                bl = object.getScriptTextArea().getSelectedText() != null;
            }
            this._cutMenuItem.setEnabled(bl);
            this._copyMenuItem.setEnabled(bl);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            boolean bl2 = clipboard.getContents(null) != null;
            this._pasteMenuItem.setEnabled(bl2);
            if (object != null) {
                ((ScriptBuilderPanel)((Object)object)).updateMenus();
            }
        }
    }

    public void cutText() {
        Object object = this._tabbedPane.getSelectedComponent();
        if (object instanceof ScriptPanel) {
            object = (ScriptPanel)((Object)object);
            ((ScriptPanel)((Object)object)).getScriptPanel().cut();
        }
    }

    public void copyText() {
        Object object = this._tabbedPane.getSelectedComponent();
        if (object instanceof ScriptPanel) {
            object = (ScriptPanel)((Object)object);
            ((ScriptPanel)((Object)object)).getScriptPanel().copy();
        }
    }

    public void pasteText() {
        Object object = this._tabbedPane.getSelectedComponent();
        if (object instanceof ScriptPanel) {
            object = (ScriptPanel)((Object)object);
            ((ScriptPanel)((Object)object)).getScriptPanel().paste();
        }
    }

    public boolean saveStateVariable() {
        StateVariableDialog stateVariableDialog = this;
        return stateVariableDialog.saveForm(stateVariableDialog._stateVariable);
    }

    public boolean importStateVariable() {
        StateVariableDialog stateVariableDialog = this;
        return stateVariableDialog.importForm(stateVariableDialog._stateVariable);
    }

    public boolean exportStateVariable() {
        StateVariableDialog stateVariableDialog = this;
        return stateVariableDialog.exportForm(stateVariableDialog._stateVariable);
    }

    public void renameStateVariable() {
        if (this._stateVariable == null) {
            return;
        }
        NameDialog nameDialog = new NameDialog((Dialog)((Object)this), "Rename State Variable", true);
        nameDialog.setNameFieldDocument((Document)new JythonNameDocument());
        String string = this._stateVariable.getName();
        nameDialog.setName(this._stateVariable.getName());
        nameDialog.setDescription(this._stateVariable.getDescription());
        List list = this._selectorPanel.getSelectorItems();
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(((StateVariable)list.get(i)).getName());
        }
        nameDialog.setExistingNames(arrayList);
        nameDialog.setVisible(true);
        if (nameDialog.isCanceled()) {
            return;
        }
        String string2 = nameDialog.getName();
        StateVariableDialog.a(this._initScriptPanel, string, string2);
        StateVariableDialog.a(this._mainScriptPanel, string, string2);
        StateVariableDialog.a(this._cleanupScriptPanel, string, string2);
        StateVariableDialog.a(this._dependenciesTabPane, string, string2);
        this._stateVariable.setName(nameDialog.getName());
        this._stateVariable.setDescription(nameDialog.getDescription());
        this._selectorPanel.setSelectionList((Collection)this._selectorPanel.getSelectorItems());
    }

    private static void a(ScriptPanel scriptPanel, String string, String string2) {
        DefaultMutableTreeNode defaultMutableTreeNode = scriptPanel.getScriptPanel().findNode("State Variables");
        if (defaultMutableTreeNode != null) {
            int n = defaultMutableTreeNode.getChildCount();
            for (int i = 0; i < n; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                if (!string.equals(defaultMutableTreeNode2.getUserObject())) continue;
                defaultMutableTreeNode2.setUserObject(string2);
                scriptPanel.getScriptPanel().nodeChanged(defaultMutableTreeNode2);
                return;
            }
        }
    }

    public void deleteStateVariable() {
        if (this._stateVariable == null) {
            return;
        }
        StateVariableDialog stateVariableDialog = this;
        int n = JOptionPane.showConfirmDialog((Component)((Object)stateVariableDialog), "<html>Ok to delete State Variable <b>" + stateVariableDialog._stateVariable.getName() + "</b><br>from Network " + this._network.getName() + "?", "Confirm Delete", 0);
        if (n == 0) {
            if (this._network.deleteStateVariable(this._stateVariable)) {
                Object object = this._stateVariable;
                this._stateVariable = null;
                this._selectorPanel.removeSelectionItem(object);
                object = object.getName();
                StateVariableDialog.a(this._initScriptPanel, (String)object);
                StateVariableDialog.a(this._mainScriptPanel, (String)object);
                StateVariableDialog.a(this._cleanupScriptPanel, (String)object);
                if (this._network.getStateVariableList().isEmpty()) {
                    this.setFormEnabled(false);
                    this.clearForm();
                }
                return;
            }
            StateVariableDialog stateVariableDialog2 = this;
            JOptionPane.showMessageDialog((Component)((Object)stateVariableDialog2), "Failed to delete " + stateVariableDialog2._stateVariable.getName() + " from Network", "Delete Error", 0);
        }
    }

    private static void a(ScriptPanel scriptPanel, String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = scriptPanel.getScriptPanel().findNode("State Variables");
        if (defaultMutableTreeNode != null) {
            int n = defaultMutableTreeNode.getChildCount();
            for (int i = 0; i < n; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                if (!string.equals(defaultMutableTreeNode2.getUserObject())) continue;
                scriptPanel.getScriptPanel().nodeRemoved(defaultMutableTreeNode, defaultMutableTreeNode2);
                defaultMutableTreeNode.remove(defaultMutableTreeNode2);
                return;
            }
        }
    }

    public void newStateVariable() {
        if (!this.askToSave()) {
            return;
        }
        NameDialog nameDialog = new NameDialog((Dialog)((Object)this), "New State Variable", true);
        nameDialog.setNameFieldDocument((Document)new JythonNameDocument());
        List list = this._selectorPanel.getSelectorItems();
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(((StateVariable)list.get(i)).getName());
        }
        nameDialog.setExistingNames(arrayList);
        nameDialog.setVisible(true);
        if (nameDialog.isCanceled()) {
            return;
        }
        StateVariable stateVariable = this._network.newStateVariable(nameDialog.getName());
        stateVariable.setDescription(nameDialog.getDescription());
        this._selectorPanel.addSelectionItem((Object)stateVariable, true);
        this._createdStateVariable = true;
        StateVariableDialog.a(this._initScriptPanel, stateVariable);
        StateVariableDialog.a(this._mainScriptPanel, stateVariable);
        StateVariableDialog.a(this._cleanupScriptPanel, stateVariable);
        StateVariableDialog.a((ScriptPanel)this._dependenciesTabPane, stateVariable);
        this.setModified(true);
    }

    private static void a(ScriptPanel scriptPanel, StateVariable objectArray) {
        DefaultMutableTreeNode defaultMutableTreeNode = scriptPanel.getScriptPanel().findNode("State Variables");
        if (defaultMutableTreeNode != null) {
            JTree jTree = scriptPanel.getScriptPanel().getTree();
            scriptPanel.getScriptPanel().addStateVariableNode((StateVariable)objectArray, defaultMutableTreeNode, true);
            objectArray = ((DefaultTreeModel)jTree.getModel()).getPathToRoot(defaultMutableTreeNode);
            if (objectArray != null) {
                jTree.expandPath(new TreePath(objectArray));
            }
        }
        scriptPanel.getScriptPanel().discardAllEdits();
    }

    protected boolean askToSave() {
        if (this.isModified() && this._stateVariable != null) {
            StateVariableDialog stateVariableDialog = this;
            int n = JOptionPane.showConfirmDialog((Component)((Object)stateVariableDialog), stateVariableDialog._stateVariable.getName() + " has changed. Save Changes?", "Save", 1);
            if (n == 0) {
                StateVariableDialog stateVariableDialog2 = this;
                return stateVariableDialog2.saveForm(stateVariableDialog2._stateVariable);
            }
            return n == 1;
        }
        return true;
    }

    public void closeEditor() {
        if (this.isModified()) {
            int n = JOptionPane.showConfirmDialog((Component)((Object)this), "Save Changes?", "Save Changes", 1);
            if (n == 2) {
                return;
            }
            if (n == 0) {
                if (!this.saveStateVariable()) {
                    return;
                }
            } else if (n == 1) {
                if (this._createdStateVariable) {
                    this._network.deleteStateVariable(this._stateVariable);
                    StateVariable stateVariable = this._stateVariable;
                    this._stateVariable = null;
                    this._selectorPanel.removeSelectionItem((Object)stateVariable);
                }
                this.setModified(false);
            }
        }
        this.setVisible(false);
    }

    public void setModified(boolean bl) {
        if (bl) {
            StateVariableDialog stateVariableDialog = this;
            stateVariableDialog.setTitle(stateVariableDialog._title + "*");
        } else {
            StateVariableDialog stateVariableDialog = this;
            stateVariableDialog.setTitle(stateVariableDialog._title);
        }
        super.setModified(bl);
    }

    public void fillForm(RssSystem rssSystem) {
        this._opt = this.getAdvancedOptions();
        if (this._opt != null) {
            this._javaClassField.setVisible(this._opt._allowStateVarAsJavaClass);
            this._useJavaClassRadio.setVisible(this._opt._allowStateVarAsJavaClass);
        }
        Object object = null;
        if (rssSystem == this._network) {
            object = this._selectorPanel.getSelectedItem();
        }
        this.clearForm();
        this._initScriptPanel.clearPanel();
        this._mainScriptPanel.clearPanel();
        this._cleanupScriptPanel.clearPanel();
        this._dependenciesTabPane.clearPanel();
        this._network = rssSystem;
        this._initScriptPanel.fillPanel(rssSystem);
        this._mainScriptPanel.fillPanel(rssSystem);
        this._cleanupScriptPanel.fillPanel(rssSystem);
        ((ScriptPanel)this._dependenciesTabPane).fillPanel(rssSystem);
        List<StateVariable> list = rssSystem.getStateVariableList();
        this._selectorPanel.setSelectionList(list);
        if (list.isEmpty()) {
            EventQueue.invokeLater(() -> this.setFormEnabled(false));
        } else if (object != null && list.contains(object)) {
            this._selectorPanel.setSelectedItem(object);
            this.fillForm((StateVariable)object);
        } else {
            this._selectorPanel.setSelectedIndex(0);
        }
        this._title = "State Variable Editor - Network: " + rssSystem.getName();
        StateVariableDialog stateVariableDialog = this;
        stateVariableDialog.setTitle(stateVariableDialog._title);
    }

    protected void fillForm(StateVariable stateVariable) {
        this._createdStateVariable = false;
        this._initScriptPanel.clearPanel();
        this._mainScriptPanel.clearPanel();
        this._cleanupScriptPanel.clearPanel();
        this._dependenciesTabPane.clearPanel();
        this._javaClassField.setText("");
        this._stateVariable = stateVariable;
        if (stateVariable == null) {
            this._initScriptPanel.getScriptPanel().discardAllEdits();
            this._mainScriptPanel.getScriptPanel().discardAllEdits();
            this._cleanupScriptPanel.getScriptPanel().discardAllEdits();
            this._dependenciesTabPane.getScriptPanel().discardAllEdits();
            this.setFormEnabled(false);
            return;
        }
        this.setFormEnabled(true);
        Object object = stateVariable.getScript();
        String string = stateVariable.getInitScript();
        String string2 = stateVariable.getCleanupScript();
        StateVariableDialog stateVariableDialog = this;
        stateVariableDialog.fillScriptText(stateVariableDialog._initScriptPanel, string, "hec/rss/client/StateVariableInit.template");
        StateVariableDialog stateVariableDialog2 = this;
        stateVariableDialog2.fillScriptText(stateVariableDialog2._mainScriptPanel, (String)object, JAR_TEMPLATE_FILE);
        StateVariableDialog stateVariableDialog3 = this;
        stateVariableDialog3.fillScriptText(stateVariableDialog3._cleanupScriptPanel, string2, "hec/rss/client/StateVariableCleanup.template");
        object = this._dependenciesTabPane.getDependencyFinder();
        ((DependencyFinder)object).a("currentVariable", stateVariable);
        this._dependenciesTabPane.fillScriptText(stateVariable.getInitScript(), stateVariable.getScript(), stateVariable.getCleanupScript());
        this._paramNameTxt.setText(stateVariable.getParamName());
        this._paramTypeCombo.setSelectedItem((Object)stateVariable.getParamType());
        this._alwaysComputeCheck.setSelected(stateVariable.getAlwaysCompute());
        this._useScriptRadio.setSelected(!stateVariable.useJavaClass());
        this._slaveSVRadio.setSelected(stateVariable.isSlave());
        if (stateVariable.isSlave()) {
            this._javaClassField.setEnabled(false);
            this._useJavaClassRadio.setEnabled(false);
            this._alwaysComputeCheck.setEnabled(false);
        }
        if (this._opt != null) {
            if (this._opt.allowStateVarsAsJavaClasses() && stateVariable.useJavaClass()) {
                this._useJavaClassRadio.setSelected(stateVariable.useJavaClass());
                this._javaClassField.setText(stateVariable.getJavaClasspath());
            } else if (!this._opt.allowStateVarsAsJavaClasses() && stateVariable.useJavaClass()) {
                this._useScriptRadio.setSelected(true);
            }
        } else if (this._opt == null && stateVariable.useJavaClass()) {
            this._useScriptRadio.setSelected(true);
        }
        this.useScriptRadioAction();
        EventQueue.invokeLater(() -> this.alwaysComputeCheckAction());
        this.setModified(false);
    }

    private void fillScriptText(ScriptPanel scriptPanel, String object, String string) {
        if (object == null || ((String)object).length() == 0) {
            object = PreferencesManager.getBufferedReader((String)"rss/StateVariable.template");
            if (object == null) {
                InputStream inputStream = this.getClass().getResourceAsStream(string);
                if (inputStream == null) {
                    inputStream = this.getClass().getClassLoader().getResourceAsStream(string);
                }
                if (inputStream == null) {
                    ((FluentLogger.Api)a.atInfo()).log("fillScriptText: failed to find file " + string);
                } else {
                    object = new BufferedReader(new InputStreamReader(inputStream));
                    scriptPanel.getScriptPanel().setScriptTextReader((Reader)object);
                    ScriptPanel scriptPanel2 = scriptPanel;
                    scriptPanel2.setInitialScript(scriptPanel2.getScriptPanel().getScriptText());
                    scriptPanel.getScriptPanel().updateLengthField();
                }
            } else {
                scriptPanel.getScriptPanel().setScriptTextReader((Reader)object);
            }
            if (object != null) {
                try {
                    ((BufferedReader)object).close();
                }
                catch (IOException iOException) {}
            }
        } else {
            scriptPanel.getScriptPanel().setScriptText((String)object);
        }
        scriptPanel.getScriptPanel().discardAllEdits();
    }

    public void setEditable(boolean bl) {
        super.setEditable(bl);
        if (!bl) {
            this._newMenuItem.setEnabled(bl);
            this._saveMenuItem.setEnabled(bl);
            this._renameMenuItem.setEnabled(bl);
            this._deleteMenuItem.setEnabled(bl);
        }
        if (bl) {
            if (this._useJavaClassRadio.isSelected()) {
                this._javaClassField.setEditable(true);
                this._mainScriptPanel.getScriptPanel().setEnabled(false);
                this._cleanupScriptPanel.getScriptPanel().setEnabled(false);
                this._dependenciesTabPane.getScriptPanel().setEnabled(false);
                this._initScriptPanel.getScriptPanel().setEnabled(false);
                return;
            }
            if (this._useScriptRadio.isSelected()) {
                this._javaClassField.setEditable(false);
                this._mainScriptPanel.getScriptPanel().setEnabled(true);
                this._cleanupScriptPanel.getScriptPanel().setEnabled(true);
                this._dependenciesTabPane.getScriptPanel().setEnabled(true);
                this._initScriptPanel.getScriptPanel().setEnabled(true);
            }
        }
    }

    protected void setFormEnabled(boolean bl) {
        this._selectorPanel.setEnabled(bl);
        this._paramPanel.setEnabled(bl);
        this._saveMenuItem.setEnabled(bl);
        this._renameMenuItem.setEnabled(bl);
        this._deleteMenuItem.setEnabled(bl);
        this._tabbedPane.getComponent(0).setEnabled(bl);
        this._tabbedPane.getComponent(1).setEnabled(bl);
        this._tabbedPane.getComponent(2).setEnabled(bl);
        if (this._stateVariable != null && bl) {
            if (this._stateVariable.useJavaClass()) {
                this._javaClassField.setEditable(true);
                this._mainScriptPanel.getScriptPanel().setEnabled(false);
                this._cleanupScriptPanel.getScriptPanel().setEnabled(false);
                this._dependenciesTabPane.getScriptPanel().setEnabled(false);
                this._initScriptPanel.getScriptPanel().setEnabled(false);
                return;
            }
            this._javaClassField.setEditable(false);
            this._mainScriptPanel.getScriptPanel().setEnabled(true);
            this._cleanupScriptPanel.getScriptPanel().setEnabled(true);
            this._dependenciesTabPane.getScriptPanel().setEnabled(true);
            this._initScriptPanel.getScriptPanel().setEnabled(true);
        }
    }

    protected boolean saveForm(StateVariable stateVariable) {
        if (stateVariable == null) {
            return true;
        }
        this.checkScriptLength();
        if (this._paramNameTxt.getText().length() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please enter a Parameter Name for StateVariable " + stateVariable.getName(), "Incomplete Form", 2);
            return false;
        }
        if (this._paramTypeCombo.getSelectedItem() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please select a Parameter Type for StateVariable " + stateVariable.getName(), "Incomplete Form", 2);
            return false;
        }
        if (this._mainScriptPanel.shouldSaveScript()) {
            stateVariable.setScript(this._mainScriptPanel.getScriptPanel().getScriptText());
        } else {
            stateVariable.setScript("");
        }
        if (this._initScriptPanel.shouldSaveScript()) {
            stateVariable.setInitScript(this._initScriptPanel.getScriptPanel().getScriptText());
        } else {
            stateVariable.setInitScript("");
        }
        if (this._cleanupScriptPanel.shouldSaveScript()) {
            stateVariable.setCleanupScript(this._cleanupScriptPanel.getScriptPanel().getScriptText());
        } else {
            stateVariable.setCleanupScript("");
        }
        if (((ScriptPanel)this._dependenciesTabPane).shouldSaveScript()) {
            String string = stateVariable.getScript();
            string = this._dependenciesTabPane.saveScriptText(string);
            stateVariable.setScript(string);
            this._mainScriptPanel.getScriptPanel().setScriptText(string);
        }
        stateVariable.setDescription(this._selectorPanel.getDescription());
        stateVariable.setParamName(this._paramNameTxt.getText());
        stateVariable.setParamType((String)this._paramTypeCombo.getSelectedItem());
        stateVariable.setAlwaysCompute(this._alwaysComputeCheck.isSelected());
        stateVariable.setUseJavaClass(this._useJavaClassRadio.isSelected());
        stateVariable.setAsSlave(this._slaveSVRadio.isSelected());
        stateVariable.setJavaClasspath(this._javaClassField.getText());
        this.setModified(false);
        this._network.setModified(true);
        this._createdStateVariable = false;
        return true;
    }

    private void checkScriptLength() {
        ArrayList<String> arrayList = new ArrayList<String>(3);
        int n = StateVariable.a();
        if (this._initScriptPanel.getScriptPanel().getScriptText().length() > n) {
            arrayList.add("<li>Initialization</li>");
        }
        if (this._mainScriptPanel.getScriptPanel().getScriptText().length() > n) {
            arrayList.add("<li>Main</li>");
        }
        if (this._cleanupScriptPanel.getScriptPanel().getScriptText().length() > n) {
            arrayList.add("<li>CleanUp</li>");
        }
        if (arrayList.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>The following scripts have more characters than Jython may be able to parse (");
        stringBuilder.append(n);
        stringBuilder.append("):<ul>");
        for (n = 0; n < arrayList.size(); ++n) {
            stringBuilder.append((String)arrayList.get(n));
        }
        stringBuilder.append("</ul>Please reduce the number of characters.");
        JOptionPane.showMessageDialog((Component)((Object)this), stringBuilder, "Warning", -1);
    }

    protected boolean importForm(StateVariable object) {
        String[] stringArray;
        if (object == null) {
            return true;
        }
        if (this._paramNameTxt.getText().length() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please enter a Parameter Name for StateVariable " + object.getName(), "Incomplete Form", 2);
            return false;
        }
        if (this._paramTypeCombo.getSelectedItem() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please select a Parameter Type for StateVariable " + object.getName(), "Incomplete Form", 2);
            return false;
        }
        object = new JFileChooser();
        ((JFileChooser)object).setFileSelectionMode(0);
        ((JFileChooser)object).addChoosableFileFilter(new FileNameExtensionFilter("Python Scripts", "py"));
        ((JFileChooser)object).addChoosableFileFilter(new FileNameExtensionFilter("Text Files", "txt"));
        ((JFileChooser)object).setAcceptAllFileFilterUsed(true);
        ((JFileChooser)object).setDialogTitle("Import State Variable Script");
        if (this._externalFileName != null) {
            ((JFileChooser)object).setSelectedFile(new File(this._externalFileName));
        }
        if (((JFileChooser)object).showDialog((Component)((Object)this), "Import") != 0) {
            return false;
        }
        try {
            this._externalFileName = ((JFileChooser)object).getSelectedFile().getCanonicalPath();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog((Component)((Object)this), iOException.getMessage(), "Error Importing Script", 0);
            return false;
        }
        object = new StringBuilder();
        try {
            stringArray = new BufferedReader(new FileReader(this._externalFileName));
            try {
                String string = stringArray.readLine();
                while (string != null) {
                    ((StringBuilder)object).append(string).append("\n");
                    string = stringArray.readLine();
                }
            }
            finally {
                stringArray.close();
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog((Component)((Object)this), iOException.getMessage(), "Error Importing Script", 0);
            return false;
        }
        stringArray = ((StringBuilder)object).toString().split("#####\n##### STATE VARIABLE SCRIPT INITIALIZATION SECTION\n#####\n\n", 2);
        int n = stringArray[stringArray.length - 1].indexOf("\n\n#####\n##### STATE VARIABLE SCRIPT COMPUTATION SECTION\n#####\n\n");
        if (n == -1) {
            n = stringArray[stringArray.length - 1].length();
        }
        StateVariableDialog stateVariableDialog = this;
        stateVariableDialog.fillScriptText(stateVariableDialog._initScriptPanel, stringArray.length == 1 ? null : stringArray[1].substring(0, n), "hec/rss/client/StateVariableInit.template");
        stringArray = stringArray[stringArray.length - 1].split("\n\n#####\n##### STATE VARIABLE SCRIPT COMPUTATION SECTION\n#####\n\n", 2);
        n = stringArray[stringArray.length - 1].indexOf("\n\n#####\n##### STATE VARIABLE SCRIPT CLEANUP SECTION\n#####\n\n");
        if (n == -1) {
            n = stringArray[stringArray.length - 1].length();
        }
        StateVariableDialog stateVariableDialog2 = this;
        stateVariableDialog2.fillScriptText(stateVariableDialog2._mainScriptPanel, stringArray.length == 1 ? stringArray[0] : stringArray[1].substring(0, n), JAR_TEMPLATE_FILE);
        stringArray = stringArray[stringArray.length - 1].split("\n\n#####\n##### STATE VARIABLE SCRIPT CLEANUP SECTION\n#####\n\n", 2);
        StateVariableDialog stateVariableDialog3 = this;
        stateVariableDialog3.fillScriptText(stateVariableDialog3._cleanupScriptPanel, stringArray.length == 1 ? null : stringArray[1], CLEANUP_TEMPLATE_FILE_NAME);
        this._dependenciesTabPane.fillScriptText(this._initScriptPanel.getScriptPanel().getScriptText(), this._mainScriptPanel.getScriptPanel().getScriptText(), this._cleanupScriptPanel.getScriptPanel().getScriptText());
        this.setModified(true);
        return true;
    }

    protected boolean exportForm(StateVariable object) {
        if (object == null) {
            return true;
        }
        if (this._paramNameTxt.getText().length() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please enter a Parameter Name for StateVariable " + object.getName(), "Incomplete Form", 2);
            return false;
        }
        if (this._paramTypeCombo.getSelectedItem() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please select a Parameter Type for StateVariable " + object.getName(), "Incomplete Form", 2);
            return false;
        }
        object = new JFileChooser();
        ((JFileChooser)object).setFileSelectionMode(0);
        ((JFileChooser)object).addChoosableFileFilter(new FileNameExtensionFilter("Python Scripts", "py"));
        ((JFileChooser)object).addChoosableFileFilter(new FileNameExtensionFilter("Text Files", "txt"));
        ((JFileChooser)object).setAcceptAllFileFilterUsed(true);
        ((JFileChooser)object).setDialogTitle("Export State Variable Script");
        if (this._externalFileName != null) {
            ((JFileChooser)object).setSelectedFile(new File(this._externalFileName));
        }
        if (((JFileChooser)object).showDialog((Component)((Object)this), "Export") != 0) {
            return false;
        }
        try {
            this._externalFileName = ((JFileChooser)object).getSelectedFile().getCanonicalPath();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog((Component)((Object)this), iOException.getMessage(), "Error Exporting Script", 0);
            return false;
        }
        if (new File(this._externalFileName).exists()) {
            StateVariableDialog stateVariableDialog = this;
            if (JOptionPane.showConfirmDialog((Component)((Object)stateVariableDialog), "Do you wish to overwrite the existing file?\n" + stateVariableDialog._externalFileName, "File Exists", 0, 3) != 0) {
                return false;
            }
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("#####\n##### STATE VARIABLE SCRIPT INITIALIZATION SECTION\n#####\n\n").append(this._initScriptPanel.getScriptPanel().getScriptText()).append("\n\n#####\n##### STATE VARIABLE SCRIPT COMPUTATION SECTION\n#####\n\n").append(this._mainScriptPanel.getScriptPanel().getScriptText()).append("\n\n#####\n##### STATE VARIABLE SCRIPT CLEANUP SECTION\n#####\n\n").append(this._cleanupScriptPanel.getScriptPanel().getScriptText());
        try (FileWriter fileWriter = new FileWriter(this._externalFileName);){
            fileWriter.write(((StringBuilder)object).toString());
            fileWriter.flush();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog((Component)((Object)this), iOException.getMessage(), "Error Exporting Script", 0);
            return false;
        }
        return true;
    }

    public void undoStateVariable() {
        Object object = this._tabbedPane.getSelectedComponent();
        if (object instanceof ScriptPanel) {
            object = (ScriptPanel)((Object)object);
            ((ScriptPanel)((Object)object)).getScriptPanel().undo();
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this._tabbedPane.setSelectedIndex(1);
        }
    }

    public void setSelectedStateVariable(StateVariable stateVariable) {
        if (stateVariable != null) {
            this._selectorPanel.setSelectedItem((Object)stateVariable);
        }
    }

    public void selectInitTab() {
        this._tabbedPane.setSelectedIndex(0);
    }

    public void selectMainTab() {
        this._tabbedPane.setSelectedIndex(1);
    }

    public void selectCleanupTab() {
        this._tabbedPane.setSelectedIndex(2);
    }

    public void gotoLineNumber(int n) {
        ScriptPanel scriptPanel = (ScriptPanel)((Object)this._tabbedPane.getSelectedComponent());
        scriptPanel.getScriptPanel().gotoLine(n);
    }
}

