/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.rss.client.AbstractElementOverridesPanel;
import hec.rss.client.OverridesPanel;
import hec.rss.client.StorElevOverridesPanel$1;
import hec.rss.model.ReleaseOverrides;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssSystem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import mil.army.usace.hec.rmi.gfx2d.SimpleDSSTimeSeries;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaInsets;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaJTable;
import rma.swing.event.TableChangeListener;
import rma.swing.event.TableUpdateEvent;
import rma.swing.table.RmaDateTimeRenderer;

public class StorElevOverridesPanel
extends OverridesPanel {
    private RmaJRadioButton _storageRadio;
    private RmaJRadioButton _elevRadio;
    private ReleaseOverrides _storReleaseOverride;
    private ReleaseOverrides _elevStorageOverride;
    private ReservoirElement _resElem;
    private RmaJTable _storageTable;
    private RmaJTable _elevationTable;
    private SimpleDSSTimeSeries _storageTsData;
    private SimpleDSSTimeSeries _elevStorageTsData;

    public StorElevOverridesPanel(AbstractElementOverridesPanel abstractElementOverridesPanel) {
        super(abstractElementOverridesPanel);
        this.addListeners();
    }

    @Override
    protected void buildControls() {
        super.buildControls();
        this._overridesType = 5;
        this._outletCombo.setVisible(false);
        this._outletLbl.setVisible(false);
        Object object = new String[]{"Date", "Time", "Storage (%S)"};
        this._storageTable = new RmaJTable((Component)((Object)this), (Object[])object);
        this._storageTable.setColumnEnabled(false, 0);
        this._storageTable.setColumnEnabled(false, 1);
        this._storageTable.setColumnBackground(0, Color.lightGray);
        this._storageTable.setColumnBackground(1, Color.lightGray);
        this._storageTable.setColumnWidth(1, 50);
        this._storageTable.setColumnWidth(2, 50);
        this._storageTable.setAddRemoveEnabled(false);
        this._storageTable.setPasteForeground(NEW_EDIT_COLOR);
        this._storageTable.setPrecision(2);
        this._valuesEditor = this._storageTable.setDoubleCellEditor(2, true);
        this._storageTable.setUnitsHeaderRenderer();
        this._storageTable.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)new RmaDateTimeRenderer(0, "ddMMMyyyy"));
        this._storageTable.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)new RmaDateTimeRenderer(1));
        this.tablePanel.add((Component)this._storageTable.getScrollPane(), new RmaGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, b, 100, 120));
        this._storageTable.getScrollPane().setVisible(false);
        Object object2 = new int[((Object[])object).length];
        for (int i = 0; i < ((Object[])object).length; ++i) {
            object2[i] = -1;
        }
        object2[2] = ReleaseOverrides.STORAGE_PARAMID;
        this._storageTable.setColumnParameters(object2);
        String string = "WARNING: Overriding reservoir storage can disrupt mass balance computations.";
        object = new JLabel(string);
        ((JComponent)object).setForeground(Color.RED);
        object2 = ((Component)object).getFont();
        object2 = new Font(object2.getFontName(), 1, object2.getSize());
        ((JComponent)object).setFont((Font)object2);
        object2 = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object2.gridy = 2;
        object2.weightx = 0.0;
        object2.weighty = 0.0;
        object2.anchor = 18;
        object2.fill = 1;
        object2.insets = RmaInsets.INSETS5555;
        this.add((Component)object, object2);
        object = new JPanel(new GridBagLayout());
        ((JComponent)object).setBorder(BorderFactory.createTitledBorder("Override Parameter"));
        object2.gridx = 2;
        object2.gridy = 2;
        object2.gridheight = 2;
        object2.weightx = 0.0;
        object2.weighty = 0.0;
        object2.anchor = 18;
        object2.fill = 2;
        object2.insets = RmaInsets.INSETS5505;
        this.add((Component)object, object2);
        this._storageRadio = new RmaJRadioButton("Storage", true);
        object2.gridx = 0;
        object2.gridy = 0;
        object2.gridheight = 1;
        object2.weightx = 0.01;
        object2.weighty = 0.0;
        object2.anchor = 18;
        object2.fill = 0;
        object2.insets = RmaInsets.INSETS5505;
        ((Container)object).add((Component)this._storageRadio, object2);
        this._elevRadio = new RmaJRadioButton("Elevation");
        object2.gridx = 0;
        object2.gridy = 1;
        object2.weightx = 0.01;
        object2.weighty = 0.01;
        object2.anchor = 18;
        object2.fill = 0;
        object2.insets = RmaInsets.INSETS5505;
        ((Container)object).add((Component)this._elevRadio, object2);
        object = new ButtonGroup();
        ((ButtonGroup)object).add((AbstractButton)this._storageRadio);
        ((ButtonGroup)object).add((AbstractButton)this._elevRadio);
        this._elevationTable = this.releaseTable;
        object = new String[]{"Date", "Time", "Elevation (%S)"};
        this._elevationTable.setColumnLabels((String[])object);
        object2 = new int[((Object)object).length];
        for (int i = 0; i < ((Object)object).length; ++i) {
            object2[i] = -1;
        }
        object2[2] = ReleaseOverrides.ELEV_STORAGE_PARAMID;
        this._elevationTable.setColumnParameters(object2);
        this._storageTable.addCellEditorListener((CellEditorListener)this);
        this._storageTable.addTableChangeListener((TableChangeListener)this);
    }

    @Override
    protected void setColumnHeader(RmaJTable rmaJTable, int n, int n2) {
    }

    private void addListeners() {
        StorElevOverridesPanel$1 storElevOverridesPanel$1 = new StorElevOverridesPanel$1(this);
        this._elevRadio.addActionListener((ActionListener)storElevOverridesPanel$1);
        this._storageRadio.addActionListener((ActionListener)storElevOverridesPanel$1);
    }

    protected void radioChangedAction() {
        if (this._elevRadio.isSelected()) {
            this._elevationTable.getScrollPane().setVisible(true);
            this._storageTable.getScrollPane().setVisible(false);
            this._overridesType = this._elevStorageOverride.getOverridesType();
            this._currentTSData = this.getCurrentTSData();
            StorElevOverridesPanel storElevOverridesPanel = this;
            storElevOverridesPanel.plot(storElevOverridesPanel._elevationTable);
        } else {
            this._storageTable.getScrollPane().setVisible(true);
            this._elevationTable.getScrollPane().setVisible(false);
            this._overridesType = this._storReleaseOverride.getOverridesType();
            this._currentTSData = this.getCurrentTSData();
            StorElevOverridesPanel storElevOverridesPanel = this;
            storElevOverridesPanel.plot(storElevOverridesPanel._storageTable);
        }
        this.revalidate();
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        if (this._elevRadio.isSelected()) {
            this.updateTableCellColor(changeEvent, this._elevationTable);
            return;
        }
        this.updateTableCellColor(changeEvent, this._storageTable);
    }

    @Override
    public void tableDataChanged(TableUpdateEvent tableUpdateEvent) {
        if (this._elevRadio.isSelected()) {
            StorElevOverridesPanel storElevOverridesPanel = this;
            storElevOverridesPanel.plot(storElevOverridesPanel._elevationTable);
            return;
        }
        StorElevOverridesPanel storElevOverridesPanel = this;
        storElevOverridesPanel.plot(storElevOverridesPanel._storageTable);
    }

    @Override
    protected void unspecify_Action() {
        if (this._elevRadio.isSelected()) {
            StorElevOverridesPanel storElevOverridesPanel = this;
            storElevOverridesPanel.unspecifyAction(storElevOverridesPanel._elevationTable);
            return;
        }
        StorElevOverridesPanel storElevOverridesPanel = this;
        storElevOverridesPanel.unspecifyAction(storElevOverridesPanel._storageTable);
    }

    @Override
    protected void unspecifyAll_Action() {
        if (this._elevRadio.isSelected()) {
            StorElevOverridesPanel storElevOverridesPanel = this;
            storElevOverridesPanel.unspecifyAllAction(storElevOverridesPanel._elevationTable);
            return;
        }
        StorElevOverridesPanel storElevOverridesPanel = this;
        storElevOverridesPanel.unspecifyAllAction(storElevOverridesPanel._storageTable);
    }

    @Override
    protected void setDSSPathname(SimpleDSSTimeSeries simpleDSSTimeSeries, RmaJTable rmaJTable, Component component) {
        if (this._elevRadio.isSelected()) {
            super.setDSSPathname(simpleDSSTimeSeries, this._elevationTable, component);
            return;
        }
        super.setDSSPathname(simpleDSSTimeSeries, this._storageTable, component);
    }

    @Override
    protected void fillFormForStorage(ReservoirElement reservoirElement) {
        RssSystem rssSystem;
        this._resElem = reservoirElement;
        this._releaseOverrides = this._elevStorageOverride;
        int n = this._rssRun.getStorageOverrideType();
        Object object = reservoirElement.getStorageFunction().getTSRecordProxy(10);
        if (object != null) {
            rssSystem = reservoirElement.getSystem();
            object = rssSystem.getNameForKeyString(object.getName());
            this._overridesType = this._elevStorageOverride.getOverridesType();
            StorElevOverridesPanel storElevOverridesPanel = this;
            storElevOverridesPanel.fillForm(storElevOverridesPanel._elevationTable, (String)object);
        }
        this._tableInitialized = false;
        this._releaseOverrides = this._storReleaseOverride;
        object = reservoirElement.getStorageFunction().getTSRecordProxy(11);
        if (object != null) {
            rssSystem = reservoirElement.getSystem();
            object = rssSystem.getNameForKeyString(object.getName());
            this._overridesType = this._storReleaseOverride.getOverridesType();
            StorElevOverridesPanel storElevOverridesPanel = this;
            storElevOverridesPanel.fillForm(storElevOverridesPanel._storageTable, (String)object);
        }
        if (n == 5) {
            this._storageRadio.doClick(0);
        } else {
            this._elevRadio.doClick(0);
        }
        this.radioChangedAction();
    }

    @Override
    protected void setCurrentTSData(SimpleDSSTimeSeries simpleDSSTimeSeries) {
        if (this._overridesType == 5) {
            this._storageTsData = simpleDSSTimeSeries;
            this._currentTSData = simpleDSSTimeSeries;
            return;
        }
        this._elevStorageTsData = simpleDSSTimeSeries;
        this._currentTSData = simpleDSSTimeSeries;
    }

    @Override
    protected SimpleDSSTimeSeries getCurrentTSData() {
        if (this._elevRadio != null && this._elevRadio.isSelected()) {
            return this._elevStorageTsData;
        }
        return this._storageTsData;
    }

    @Override
    protected Vector[] plot(RmaJTable rmaJTable) {
        if (this._elevRadio.isSelected()) {
            StorElevOverridesPanel storElevOverridesPanel = this;
            return super.plot(storElevOverridesPanel._elevationTable);
        }
        StorElevOverridesPanel storElevOverridesPanel = this;
        return super.plot(storElevOverridesPanel._storageTable);
    }

    public void setReleaseOverrides(ReleaseOverrides releaseOverrides, ReleaseOverrides releaseOverrides2) {
        this._storReleaseOverride = releaseOverrides;
        this._elevStorageOverride = releaseOverrides2;
        if (this._elevRadio.isSelected()) {
            super.setReleaseOverrides(releaseOverrides2);
            return;
        }
        super.setReleaseOverrides(releaseOverrides);
    }

    @Override
    protected void saveTable(String string) {
        if (string == null || string.length() <= 0) {
            return;
        }
        TableColumn tableColumn = this._elevationTable.getColumnModel().getColumn(2);
        if (tableColumn != null) {
            StorElevOverridesPanel storElevOverridesPanel = this;
            storElevOverridesPanel.saveTable(storElevOverridesPanel._elevStorageOverride, string, this._elevationTable);
        }
        if ((tableColumn = this._storageTable.getColumnModel().getColumn(2)) != null) {
            StorElevOverridesPanel storElevOverridesPanel = this;
            storElevOverridesPanel.saveTable(storElevOverridesPanel._storReleaseOverride, string, this._storageTable);
        }
        this._rssRun.setModified(true);
        int n = this._elevRadio.isSelected() ? 6 : 5;
        this._rssRun.setStorageOverrideType(n);
    }
}

