/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.data.Parameter;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dMarkerProperties;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.HotPlotDefaults;
import hec.gfx2d.PlotDefaults;
import hec.gfx2d.PlotDefaultsManager;
import hec.gfx2d.PlotLayout;
import hec.gfx2d.SimpleArray;
import hec.gfx2d.Viewport;
import hec.heclib.util.HecTime;
import hec.rss.client.StorageBalancePlotPanel$1;
import hec.rss.client.StorageBalancePlotPanel$2;
import hec.rss.model.ResSystemOpSet;
import hec.rss.model.ReservoirElement;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJCalendarField;
import rma.swing.RmaJTextField;

public class StorageBalancePlotPanel
extends JPanel {
    private G2dPanel _plot;
    private RmaJTextField _dateField;
    private String _date = "01Jan";
    private PlotLayout _plotLayout;
    private ResSystemOpSet _resSysOp;

    public StorageBalancePlotPanel() {
        this.buildPanel();
    }

    private void buildPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel("Display Date:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5500;
        this.add((Component)jLabel, gridBagConstraints);
        this._dateField = new RmaJCalendarField("DDMMM", "");
        jLabel.setLabelFor((Component)this._dateField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        StorageBalancePlotPanel storageBalancePlotPanel = this;
        storageBalancePlotPanel.add((Component)storageBalancePlotPanel._dateField, gridBagConstraints);
        this._dateField.addActionListener((ActionListener)new StorageBalancePlotPanel$1(this));
        this._plot = new StorageBalancePlotPanel$2(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        StorageBalancePlotPanel storageBalancePlotPanel2 = this;
        storageBalancePlotPanel2.add((Component)storageBalancePlotPanel2._plot, gridBagConstraints);
    }

    private void fillPlots() {
        StorageBalancePlotPanel storageBalancePlotPanel = this;
        storageBalancePlotPanel.fillPlots(storageBalancePlotPanel._resSysOp);
    }

    public void fillPlots(ResSystemOpSet resSystemOpSet) {
        this._plotLayout = new PlotLayout();
        this._dateField.setText(this._date);
        this._resSysOp = resSystemOpSet;
        if (this._resSysOp != null) {
            int[] nArray = this._resSysOp.getReservoirSystemOp().getReservoirIDs();
            resSystemOpSet = new HecTime();
            resSystemOpSet.setDate(this._dateField.getText() + "1900");
            double[][] dArray = this._resSysOp.getResStoragePattern((HecTime)resSystemOpSet);
            for (int i = 0; i < nArray.length; ++i) {
                ReservoirElement reservoirElement = (ReservoirElement)this._resSysOp.getReservoirSystemOp().getSystem().getElement(nArray[i]);
                if (reservoirElement == null) continue;
                double[] dArray2 = new double[dArray.length];
                double[] dArray3 = new double[dArray.length];
                for (int j = 0; j < dArray.length; ++j) {
                    dArray2[j] = dArray[j][nArray.length];
                    dArray3[j] = dArray[j][i];
                }
                resSystemOpSet = this._plotLayout.addViewport();
                resSystemOpSet.setAxisLabel("X1", "Storage (%S)");
                resSystemOpSet.addCurve("Y1", this.getReservoirCurve(dArray2, dArray3, reservoirElement));
                resSystemOpSet.setAxisLabel("Y1", reservoirElement.getName());
            }
            this._plotLayout.setHasLegendOff();
            this._plotLayout.setHasToolbar(false);
            PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
            PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
            this._plot.buildComponents(this._plotLayout);
            this._plot.setDisplayUnitsSystem(ClientApp.Workspace().getUnitSystem());
            this.computeZones(false, this._plot);
            this._plot.setHorizontalViewportSpacing(0);
            PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
        }
    }

    private SimpleArray getReservoirCurve(double[] dArray, double[] dArray2, ReservoirElement reservoirElement) {
        SimpleArray simpleArray = new SimpleArray();
        simpleArray.setYAxisName(reservoirElement.getName());
        simpleArray.setUnitSystem(ClientApp.Workspace().getUnitSystem());
        simpleArray.setData(dArray, dArray2);
        simpleArray.setXParameterId(Parameter.PARAMID_STOR);
        return simpleArray;
    }

    private void dateChangeAction() {
        this._plot.clearPanel();
        this.fillPlots();
        this._plot.repaint();
    }

    private void computeZones(boolean bl, G2dPanel object) {
        if (bl) {
            object.setTitle("System Storage Plot - " + this._resSysOp.getName());
        }
        Viewport[] viewportArray = object.getViewports();
        HecTime hecTime = new HecTime();
        hecTime.setDate(this._dateField.getText() + "1900");
        if (this._resSysOp != null) {
            int[] nArray = this._resSysOp.getReservoirSystemOp().getReservoirIDs();
            int[] nArray2 = this._resSysOp.getStorageZoneIDs();
            for (int i = 0; i < nArray2.length; ++i) {
                object = this._resSysOp.getStorageZone(nArray2[i]);
                String string = object.getName();
                object = new G2dMarkerProperties();
                object.setMarkerValue(this._resSysOp.getSysZoneStorage(hecTime, nArray2[i]));
                if (bl) {
                    object.setMarkerLabel(string);
                }
                object.setLinePattern(G2dLineProperties.DASH_STYLE_PATTERN);
                object.setDrawOnAxis(0);
                for (int j = 0; j < viewportArray.length; ++j) {
                    Viewport viewport = viewportArray[j];
                    if (j >= nArray.length) continue;
                    string = viewport.getAxisLabel("y1");
                    string.setFontSize(30 / viewportArray.length);
                    viewport.addAxisMarker((G2dMarkerProperties)object);
                    string = new G2dMarkerProperties();
                    string.setMarkerValue(this._resSysOp.getResZoneStorage(hecTime, nArray2[i], nArray[j]));
                    if (bl) {
                        string.setMarkerLabel(this._resSysOp.getStorageZone(nArray2[i]).toString());
                    }
                    string.setLinePattern(G2dLineProperties.DASH_STYLE_PATTERN);
                    string.setDrawOnAxis(1);
                    viewport.addAxisMarker((G2dMarkerProperties)string);
                    viewport.setMajorGridYVisible(false);
                    viewport.setMajorGridXVisible(false);
                    if (bl) continue;
                    viewport.getAxisTics("y1").setVisible(false);
                    if (j != viewportArray.length - 1) continue;
                    viewport.getAxisTics("x1").setVisible(false);
                }
            }
        }
    }
}

