/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.model.RunInfo;
import hec.rss.client.SummaryReportCollectionOptionsEditor$1;
import hec.rss.model.RssAlt;
import hec.rss.model.RssRun;
import hec.rss.plugins.model.AltPluginData;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;

public class SummaryReportCollectionOptionsEditor
extends RmaJDialog {
    private JPanel _collectionPanel;
    private RmaJComboBox[] _collectionCombos;
    private ButtonCmdPanel _cmdPanel;
    private List<RunInfo> _runs;
    private List<List<String>> _collections;
    JLabel[] _labels;
    private boolean _canceled = false;

    public SummaryReportCollectionOptionsEditor(JFrame jFrame, List<RunInfo> list, List<List<String>> list2) {
        super((Frame)jFrame, true);
        this._runs = list;
        this._collections = list2;
        this._labels = new JLabel[list2.size()];
        this._collectionCombos = new RmaJComboBox[list2.size()];
        this.buildControls();
        this.fill();
        this.pack();
        SummaryReportCollectionOptionsEditor summaryReportCollectionOptionsEditor = this;
        summaryReportCollectionOptionsEditor.setLocationRelativeTo(summaryReportCollectionOptionsEditor.getParent());
    }

    private void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Collection Run Options");
        this._collectionPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        this.getContentPane().add((Component)this._collectionPanel, gridBagConstraints);
        int n = 1;
        for (int i = 0; i < this._runs.size(); ++i) {
            Object object = ((RssRun)this._runs.get((int)i).run).getAlternative();
            if (object == null || (object = ((RssAlt)object).getPluginDataList()) == null || object.isEmpty()) continue;
            for (int j = 0; j < object.size(); ++j) {
                AltPluginData altPluginData = (AltPluginData)object.get(j);
                if (!altPluginData.useCompute()) continue;
                this._labels[n - 1] = new JLabel(((RssRun)this._runs.get((int)i).run).getDisplayName() + ":");
                gridBagConstraints = new GridBagConstraints();
                new GridBagConstraints().gridx = 0;
                gridBagConstraints.gridy = n;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.fill = 1;
                gridBagConstraints.insets = RmaInsets.INSETS5505;
                this._collectionPanel.add((Component)this._labels[n - 1], gridBagConstraints);
                this._collectionCombos[n - 1] = new RmaJComboBox(this._collections.get(n - 1).toArray());
                gridBagConstraints = new GridBagConstraints();
                new GridBagConstraints().gridx = 1;
                gridBagConstraints.gridy = n;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.fill = 2;
                gridBagConstraints.insets = RmaInsets.INSETS5505;
                this._collectionPanel.add((Component)this._collectionCombos[n - 1], gridBagConstraints);
                ++n;
            }
        }
        this._cmdPanel = new ButtonCmdPanel(12);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2 + this._runs.size();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        this.getContentPane().add((Component)this._cmdPanel, gridBagConstraints);
        this._cmdPanel.addCmdPanelListener((ButtonCmdPanelListener)new SummaryReportCollectionOptionsEditor$1(this));
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    private void fill() {
        int n = 1;
        for (int i = 0; i < this._runs.size(); ++i) {
            Object object = ((RssRun)this._runs.get((int)i).run).getAlternative();
            if (object == null || (object = ((RssAlt)object).getPluginDataList()) == null || object.isEmpty()) continue;
            for (int j = 0; j < object.size(); ++j) {
                AltPluginData altPluginData = (AltPluginData)object.get(j);
                if (!altPluginData.useCompute()) continue;
                if (((RssRun)this._runs.get((int)i).run).getSelectedSummaryReportCollectionRun() != null) {
                    this._collectionCombos[n - 1].setSelectedItem((Object)((RssRun)this._runs.get((int)i).run).getSelectedSummaryReportCollectionRun());
                    ++n;
                    continue;
                }
                if (this._collectionCombos[n - 1] == null) continue;
                this._collectionCombos[n - 1].setSelectedIndex(0);
                ++n;
            }
        }
    }

    public void save() {
        int n = 1;
        for (int i = 0; i < this._runs.size(); ++i) {
            Object object = ((RssRun)this._runs.get((int)i).run).getAlternative();
            if (object == null || (object = ((RssAlt)object).getPluginDataList()) == null || object.isEmpty()) continue;
            for (int j = 0; j < object.size(); ++j) {
                AltPluginData altPluginData = (AltPluginData)object.get(j);
                if (!altPluginData.useCompute()) continue;
                ((RssRun)this._runs.get((int)i).run).setSelectedSummaryReportCollectionRun((String)this._collectionCombos[n - 1].getSelectedItem());
                ++n;
            }
        }
    }
}

