/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.PlotLayout;
import hec.gfx2d.SimpleJTableStepData;
import hec.gfx2d.SimpleSeasonalData;
import hec.gui.MoverDialog;
import hec.heclib.util.HecTime;
import hec.model.SeasonalRecord;
import hec.model.SeasonalRecordTableModel;
import hec.rss.client.JOperationsPanel;
import hec.rss.client.OperatingReservoirEditor;
import hec.rss.client.PowerGenerationDialog;
import hec.rss.client.PowerGenerationReqDlg;
import hec.rss.client.SystemHydropowerRulePanel$1;
import hec.rss.client.SystemHydropowerRulePanel$10;
import hec.rss.client.SystemHydropowerRulePanel$2;
import hec.rss.client.SystemHydropowerRulePanel$3;
import hec.rss.client.SystemHydropowerRulePanel$4;
import hec.rss.client.SystemHydropowerRulePanel$5;
import hec.rss.client.SystemHydropowerRulePanel$6;
import hec.rss.client.SystemHydropowerRulePanel$7;
import hec.rss.client.SystemHydropowerRulePanel$8;
import hec.rss.client.SystemHydropowerRulePanel$9;
import hec.rss.model.Element;
import hec.rss.model.OpRuleRef;
import hec.rss.model.OperationsElement;
import hec.rss.model.PowerGenerationOptions;
import hec.rss.model.PowerGenerationPatternContainer;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssReturnStatusConstants;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.SystemHydropowerOpRule;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableModel;
import rma.swing.DefaultJPanel;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaInsets;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.swing.event.TableChangeListener;
import rma.swing.event.TableUpdateEvent;
import rma.swing.table.RmaTableModel;
import rma.swing.table.RowHeaderRenderer;
import rma.util.RMAIO;

public class SystemHydropowerRulePanel
extends DefaultJPanel
implements FocusListener,
CellEditorListener,
TableChangeListener {
    JOperationsPanel m_parent = null;
    OpRuleRef m_currentRuleRef = null;
    String m_oldRuleName = "";
    private JCheckBox _useEnergyRequiredTimeSeries;
    private JCheckBox _useContributeStorageOnly;
    private JCheckBox _usePassThruOnly;
    MessageFormat m_labelFormat = new MessageFormat("{0} Requirement\n(MWh)");
    double[] PLOT_TIME_DATA = new double[12];
    Object[][] MONTHLY_DATA = new Object[][]{{"Jan", ""}, {"Feb", ""}, {"Mar", ""}, {"Apr", ""}, {"May", ""}, {"Jun", ""}, {"Jul", ""}, {"Aug", ""}, {"Sep", ""}, {"Oct", ""}, {"Nov", ""}, {"Dec", ""}};
    RmaJTextField jRuleTxt = new RmaJTextField();
    RmaJTextField jRuleDescTxt = new RmaJTextField();
    JLabel jRuleLabel = new JLabel("Hydropower - System Schedule Rule:");
    JLabel jDescriptionLabel = new JLabel("Description:");
    JPanel jNameDescPanel = new JPanel();
    RmaJTable m_monthlyTable;
    RmaJTable m_seasonalTable;
    SeasonalRecordTableModel m_seasonalTableModel;
    JPanel m_cardPanel;
    G2dPanel m_plot;
    SimpleJTableStepData m_monthlyPlotData;
    SimpleSeasonalData m_seasonalPlotData;
    RmaJRadioButton m_useLocalGenPattern;
    RmaJRadioButton m_specifyGenPattern;
    String m_currentCard;

    public SystemHydropowerRulePanel() {
        SystemHydropowerRulePanel systemHydropowerRulePanel = this;
        this.m_monthlyTable = new SystemHydropowerRulePanel$1(systemHydropowerRulePanel, (Component)((Object)systemHydropowerRulePanel), this.MONTHLY_DATA, new String[]{" \nMonth", this.m_labelFormat.format(new String[]{"Weekly"})});
        SystemHydropowerRulePanel systemHydropowerRulePanel2 = this;
        this.m_seasonalTable = new SystemHydropowerRulePanel$2(systemHydropowerRulePanel2, (Component)((Object)systemHydropowerRulePanel2));
        this.m_seasonalTableModel = new SeasonalRecordTableModel(new String[]{" \nDate", this.m_labelFormat.format(new String[]{"Weekly"})}, new boolean[]{true, true});
        this.m_cardPanel = new JPanel(new CardLayout());
        this.m_plot = new SystemHydropowerRulePanel$3(this);
        this.m_monthlyPlotData = new SimpleJTableStepData();
        this.m_seasonalPlotData = new SimpleSeasonalData();
        this.m_useLocalGenPattern = new RmaJRadioButton("Specify Local Generation Pattern");
        this.m_specifyGenPattern = new RmaJRadioButton("Specify System Generation Pattern");
        this.createControls();
    }

    public void createControls() {
        this.setLayout(new GridBagLayout());
        Object object = new int[1];
        for (int i = 0; i < this.PLOT_TIME_DATA.length; ++i) {
            HecTime.datjul((String)((String)this.MONTHLY_DATA[i][0]), (int[])object);
            this.PLOT_TIME_DATA[i] = object[0] * 1440;
        }
        RmaGridBagConstraints rmaGridBagConstraints = new RmaGridBagConstraints();
        this.jNameDescPanel.setLayout(new GridBagLayout());
        this.jNameDescPanel.add((Component)this.jRuleLabel, new RmaGridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, INSETS5500, 0, 0));
        this.jNameDescPanel.add((Component)this.jDescriptionLabel, new RmaGridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 0, INSETS5500, 0, 0));
        this.jNameDescPanel.add((Component)this.jRuleTxt, new RmaGridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 2, INSETS5500, 0, 0));
        this.jNameDescPanel.add((Component)new JLabel(), new RmaGridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 18, 2, INSETS5505, 0, 0));
        this.jNameDescPanel.add((Component)this.jRuleDescTxt, new RmaGridBagConstraints(1, 1, 4, 1, 1.0, 1.0, 18, 2, INSETS5555, 0, 0));
        rmaGridBagConstraints.set(0, 0, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.INSETS5505, 0, 0);
        SystemHydropowerRulePanel systemHydropowerRulePanel = this;
        systemHydropowerRulePanel.add(systemHydropowerRulePanel.jNameDescPanel, rmaGridBagConstraints);
        object = new JPanel(new GridBagLayout());
        rmaGridBagConstraints.set(0, 1, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.INSETS0000, 0, 0);
        this.add((Component)object, rmaGridBagConstraints);
        JComponent jComponent = new JLabel("System Generation Requirement");
        rmaGridBagConstraints.set(0, 0, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.INSETS5500, 0, 0);
        ((Container)object).add((Component)jComponent, rmaGridBagConstraints);
        jComponent = new JButton("Options...");
        rmaGridBagConstraints.set(1, 0, 1, 1, 1.0, 0.0, 18, 0, RmaInsets.INSETS5505, 0, 0);
        ((Container)object).add((Component)jComponent, rmaGridBagConstraints);
        ((AbstractButton)jComponent).addActionListener(new SystemHydropowerRulePanel$4(this));
        object = new JPanel(new GridBagLayout());
        rmaGridBagConstraints.set(0, 2, 1, 1, 1.0, 1.0, 18, 1, RmaInsets.INSETS0000, 0, 0);
        this.add((Component)object, rmaGridBagConstraints);
        rmaGridBagConstraints.set(0, 0, 1, 2, 1.0, 1.0, 18, 1, RmaInsets.INSETS5500, 0, 0);
        ((Container)object).add((Component)this.m_cardPanel, rmaGridBagConstraints);
        this.m_monthlyTable.setMlHeaderRenderer();
        jComponent = new RowHeaderRenderer();
        jComponent.setHorizontalAlignment(0);
        this.m_monthlyTable.setHorizontalAlignment(0, 0);
        this.m_monthlyTable.setColumnEnabled(false, 0);
        this.m_monthlyTable.setDoubleCellEditor(1);
        this.m_monthlyTable.setAddRemoveEnabled(false);
        this.m_monthlyTable.addCellEditorListener((CellEditorListener)this);
        this.m_monthlyTable.addTableChangeListener((TableChangeListener)this);
        this.m_cardPanel.add((Component)new JScrollPane((Component)this.m_monthlyTable), "MONTHLY TABLE");
        jComponent = new SeasonalRecord();
        jComponent.setUnitSystem(ClientApp.Workspace().getUnitSystem());
        this.m_seasonalTableModel.setSeasonalRecord((SeasonalRecord)jComponent, "01JAN");
        this.m_seasonalTable.setModel((TableModel)this.m_seasonalTableModel);
        this.m_seasonalTable.setMlHeaderRenderer();
        this.m_seasonalTable.setDoubleCellEditor(1);
        this.m_seasonalTable.setDateCellEditor(0, "DDMMM");
        this.m_seasonalTable.setCellEnabled(false, 0, 0);
        this.m_seasonalTable.setAddRemoveEnabled(false);
        this.m_seasonalTable.addCellEditorListener((CellEditorListener)this);
        this.m_seasonalTable.addTableChangeListener((TableChangeListener)this);
        this.m_cardPanel.add((Component)new JScrollPane((Component)this.m_seasonalTable), "SEASONAL TABLE");
        ((CardLayout)this.m_cardPanel.getLayout()).show(this.m_cardPanel, "MONTHLY TABLE");
        this.m_currentCard = "MONTHLY TABLE";
        jComponent = new PlotLayout();
        jComponent.setHasLegend(false);
        jComponent.setHasToolbar(false);
        Object object2 = jComponent.addViewport();
        object2.addCurve("Y1", (Object)this.m_monthlyPlotData);
        this.m_monthlyPlotData.setYAxisType(0);
        this.m_monthlyPlotData.setXAxisType(1);
        this.m_monthlyPlotData.xunits = "minutes";
        this.m_monthlyPlotData.yunits = "MWH";
        this.m_seasonalPlotData.xunits = "minutes";
        this.m_seasonalPlotData.yunits = "MWH";
        this.m_plot.buildComponents((PlotLayout)jComponent);
        this.m_plot.getAxisTics(0).getAxis().setNumTicLabelLevels(1);
        rmaGridBagConstraints.set(1, 0, 1, 1, 0.0, 1.0, 12, 1, RmaInsets.INSETS5505, 0, 0);
        ((Container)object).add((Component)this.m_plot, rmaGridBagConstraints);
        jComponent = new JPanel(new GridBagLayout());
        jComponent.setBorder(BorderFactory.createTitledBorder("Power Generation Pattern"));
        rmaGridBagConstraints.set(1, 1, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.INSETS5505, 0, 0);
        ((Container)object).add((Component)jComponent, rmaGridBagConstraints);
        rmaGridBagConstraints.set(0, 0, 2, 1, 1.0, 0.0, 18, 0, RmaInsets.INSETS5505, 0, 0);
        this.m_useLocalGenPattern.setMargin(RmaInsets.INSETS0000);
        jComponent.add((Component)this.m_useLocalGenPattern, rmaGridBagConstraints);
        rmaGridBagConstraints.set(0, 1, 1, 1, 0.0, 1.0, 18, 0, RmaInsets.INSETS5500, 0, 0);
        this.m_specifyGenPattern.setMargin(RmaInsets.INSETS0000);
        jComponent.add((Component)this.m_specifyGenPattern, rmaGridBagConstraints);
        object2 = new JSeparator();
        rmaGridBagConstraints.set(0, 2, 1, 1, 1.0, 1.0, 11, 2, RmaInsets.INSETS5555, 0, 0);
        jComponent.add((Component)object2, rmaGridBagConstraints);
        object2 = new JButton("Edit Pattern...");
        rmaGridBagConstraints.set(0, 3, 1, 1, 1.0, 1.0, 11, 0, RmaInsets.INSETS5555, 0, 0);
        jComponent.add((Component)object2, rmaGridBagConstraints);
        ((AbstractButton)object2).addActionListener(new SystemHydropowerRulePanel$5(this));
        jComponent = new JPanel(new GridBagLayout());
        rmaGridBagConstraints.set(0, 2, 2, 1, 1.0, 0.0, 16, 2, RmaInsets.INSETS0000, 0, 0);
        ((Container)object).add((Component)jComponent, rmaGridBagConstraints);
        this._useEnergyRequiredTimeSeries = new JCheckBox("Specify Energy Requirement with External Time Series");
        rmaGridBagConstraints.set(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0);
        jComponent.add((Component)this._useEnergyRequiredTimeSeries, rmaGridBagConstraints);
        this._useEnergyRequiredTimeSeries.addActionListener(new SystemHydropowerRulePanel$6(this));
        this._useContributeStorageOnly = new JCheckBox("This reservoir contributes storage only");
        rmaGridBagConstraints.set(0, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0);
        jComponent.add((Component)this._useContributeStorageOnly, rmaGridBagConstraints);
        this._useContributeStorageOnly.addActionListener(new SystemHydropowerRulePanel$7(this));
        this._usePassThruOnly = new JCheckBox("This reservoir does not operate storage for power");
        rmaGridBagConstraints.set(0, 2, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0);
        jComponent.add((Component)this._usePassThruOnly, rmaGridBagConstraints);
        this._usePassThruOnly.addActionListener(new SystemHydropowerRulePanel$8(this));
        object = new JButton("Operating Reservoirs...");
        rmaGridBagConstraints.set(1, 0, 1, 1, 1.0, 0.0, 18, 0, RmaInsets.INSETS0500, 0, 0);
        jComponent.add((Component)object, rmaGridBagConstraints);
        ((AbstractButton)object).addActionListener(new SystemHydropowerRulePanel$9(this));
        object = new JButton("Contributing Reservoirs...");
        rmaGridBagConstraints.set(1, 1, 1, 1, 1.0, 0.0, 18, 0, RmaInsets.INSETS0500, 0, 0);
        jComponent.add((Component)object, rmaGridBagConstraints);
        ((AbstractButton)object).addActionListener(new SystemHydropowerRulePanel$10(this));
        object = new ButtonGroup();
        ((ButtonGroup)object).add((AbstractButton)this.m_specifyGenPattern);
        ((ButtonGroup)object).add((AbstractButton)this.m_useLocalGenPattern);
    }

    protected void showSystemGenerationReqDialog() {
        Object object = SwingUtilities.windowForComponent((Component)((Object)this));
        PowerGenerationReqDlg powerGenerationReqDlg = object instanceof JFrame ? new PowerGenerationReqDlg((JFrame)object, "Power Generation Requirement", true) : new PowerGenerationReqDlg((JDialog)object, "Power Generation Requirement", true);
        powerGenerationReqDlg.pack();
        powerGenerationReqDlg.setLocationRelativeTo((Component)object);
        object = (SystemHydropowerOpRule)this.m_currentRuleRef.getRule();
        powerGenerationReqDlg.setHydropowerRule((PowerGenerationOptions)object);
        powerGenerationReqDlg.fillPanel();
        powerGenerationReqDlg.setVisible(true);
        if (powerGenerationReqDlg.isCanceled()) {
            return;
        }
        if (((SystemHydropowerOpRule)object).getRequirementVariation() == 0) {
            ((CardLayout)this.m_cardPanel.getLayout()).show(this.m_cardPanel, "MONTHLY TABLE");
            this.m_currentCard = "MONTHLY TABLE";
        } else {
            ((CardLayout)this.m_cardPanel.getLayout()).show(this.m_cardPanel, "SEASONAL TABLE");
            this.m_currentCard = "SEASONAL TABLE";
        }
        int n = ((SystemHydropowerOpRule)object).getPowerReqSpecification();
        this.setTableColumnLabel(n);
        this.plotData();
        this.setModified(true);
    }

    protected void setTableColumnLabel(int n) {
        String string = null;
        if (n == 10) {
            string = " \nPlant Factor";
        } else if (n == 11) {
            string = this.m_labelFormat.format(new String[]{"Daily"});
        } else if (n == 13) {
            string = this.m_labelFormat.format(new String[]{"Monthly"});
        } else if (n == 12) {
            string = this.m_labelFormat.format(new String[]{"Weekly"});
        } else if (n == 14) {
            string = this.m_labelFormat.format(new String[]{"Seasonal"});
        }
        ((RmaTableModel)this.m_monthlyTable.getModel()).setColumnName(1, string);
        this.m_seasonalTableModel.setColumnName(1, string);
        this.m_monthlyTable.getColumnModel().getColumn(1).setHeaderValue(string);
        this.m_seasonalTable.getColumnModel().getColumn(1).setHeaderValue(string);
        this.m_monthlyTable.getTableHeader().revalidate();
        this.m_seasonalTable.getTableHeader().revalidate();
        this.m_monthlyTable.getTableHeader().repaint();
        this.m_seasonalTable.getTableHeader().repaint();
    }

    protected void showGenerationPatternDlg() {
        Object object = SwingUtilities.windowForComponent((Component)((Object)this));
        PowerGenerationDialog powerGenerationDialog = object instanceof JFrame ? new PowerGenerationDialog((JFrame)object, "Generation Pattern", true) : new PowerGenerationDialog((JDialog)object, "Generation Pattern", true);
        powerGenerationDialog.pack();
        powerGenerationDialog.setLocationRelativeTo((Component)object);
        boolean bl = this.m_useLocalGenPattern.isSelected();
        SystemHydropowerOpRule systemHydropowerOpRule = (SystemHydropowerOpRule)this.m_currentRuleRef.getRule();
        OperationsElement operationsElement = systemHydropowerOpRule.getOperationsElement();
        if (bl) {
            powerGenerationDialog.setTitle("Local Generation Pattern for " + operationsElement.getName());
            object = systemHydropowerOpRule.getResPowerPatternContainer(operationsElement.getIndex());
        } else {
            powerGenerationDialog.setTitle("System Generation Pattern");
            object = systemHydropowerOpRule.getPowerPatternContainer();
        }
        object = (PowerGenerationPatternContainer)((PowerGenerationPatternContainer)object).clone();
        powerGenerationDialog.fillPanel((PowerGenerationPatternContainer)object);
        powerGenerationDialog.setVisible(true);
        if (powerGenerationDialog.isCanceled()) {
            return;
        }
        if (bl) {
            systemHydropowerOpRule.setResPowerPatternContainer(operationsElement.getIndex(), (PowerGenerationPatternContainer)object);
        } else {
            systemHydropowerOpRule.setPowerPatternContainer((PowerGenerationPatternContainer)object);
        }
        this.setModified(powerGenerationDialog.isModified());
    }

    private void useEnergyRequiredTimeSeriesAction() {
        if (this._useEnergyRequiredTimeSeries.isSelected()) {
            this.m_monthlyTable.setColumnEnabled(false, 1);
            this.m_seasonalTable.setAllColumnsEnabled(false);
        } else {
            this.m_monthlyTable.setColumnEnabled(true, 1);
            this.m_seasonalTable.setAllColumnsEnabled(true);
            this.m_seasonalTable.setCellEnabled(false, 0, 0);
        }
        this.setModified(true);
        this.repaint();
    }

    private void useContributeStorageOnlyAction() {
        if (this._useContributeStorageOnly.isSelected()) {
            this._usePassThruOnly.setSelected(false);
        }
        this.setModified(true);
    }

    private void usePassThruOnlyAction() {
        if (this._usePassThruOnly.isSelected()) {
            this._useContributeStorageOnly.setSelected(false);
        }
        this.setModified(true);
    }

    protected void showReservoirSelectionDlg() {
        SystemHydropowerOpRule systemHydropowerOpRule = (SystemHydropowerOpRule)this.m_currentRuleRef.getRule();
        RssReturnStatusConstants rssReturnStatusConstants = ((RssTSLocationObject)systemHydropowerOpRule).getSystem();
        if (rssReturnStatusConstants == null) {
            return;
        }
        Vector<ReservoirElement> vector = rssReturnStatusConstants.getElementVectorByClass(ReservoirElement.class);
        Vector<RssSystem> vector2 = new Vector<RssSystem>();
        systemHydropowerOpRule.getOperationsElement();
        for (int i = 0; i < vector.size(); ++i) {
            rssReturnStatusConstants = vector.get(i);
            if (!(rssReturnStatusConstants instanceof ReservoirElement)) continue;
            rssReturnStatusConstants = (ReservoirElement)rssReturnStatusConstants;
            Vector vector3 = ((ReservoirElement)rssReturnStatusConstants).getReservoirOp().getRules();
            for (int j = 0; j < vector3.size(); ++j) {
                if (!vector3.get(j).toString().equalsIgnoreCase(systemHydropowerOpRule.toString())) continue;
                vector2.add((RssSystem)rssReturnStatusConstants);
            }
        }
        if (vector2.size() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "The current System Hydropower rule has no other reservoirs using it.");
            return;
        }
        OperatingReservoirEditor operatingReservoirEditor = new OperatingReservoirEditor(this.m_parent._parent);
        operatingReservoirEditor.fill(vector2, systemHydropowerOpRule);
        operatingReservoirEditor.setVisible(true);
    }

    protected void showContributingReservoirDlg() {
        int n;
        Object object;
        int n2;
        Window window = SwingUtilities.windowForComponent((Component)((Object)this));
        window = window instanceof JFrame ? new MoverDialog((Frame)window, true, "Hydropower-System Rule: Reservoir List") : new MoverDialog((JDialog)window, true, "Hydropower-System Rule: Reservoir List");
        SystemHydropowerOpRule systemHydropowerOpRule = (SystemHydropowerOpRule)this.m_currentRuleRef.getRule();
        Object object2 = ((RssTSLocationObject)systemHydropowerOpRule).getSystem();
        if (object2 == null) {
            return;
        }
        object2 = ((RssSystem)object2).getElementVectorByClass(ReservoirElement.class);
        String string = "Reservoirs that Contribute to System Power.";
        String string2 = "* = Reservoir operates for System Hydropower in at least one Operating Set.";
        Vector<String> vector = new Vector<String>((Collection<String>)object2);
        Vector<Object> vector2 = new Vector<Object>();
        OperationsElement operationsElement = systemHydropowerOpRule.getOperationsElement();
        int[] nArray = systemHydropowerOpRule.getReservoirIndexArray();
        block0: for (n2 = 0; n2 < ((Vector)object2).size(); ++n2) {
            object = (ReservoirElement)((Vector)object2).get(n2);
            if (operationsElement.getIndex() == object.getIndex()) {
                vector.remove(object);
                if (vector2.contains(object)) continue;
                vector2.add(object);
                continue;
            }
            Vector vector3 = ((ReservoirElement)object).getReservoirOp().getRules();
            for (n = 0; n < vector3.size(); ++n) {
                if (!vector3.get(n).toString().equalsIgnoreCase(systemHydropowerOpRule.toString())) continue;
                vector.remove(object);
                if (vector2.contains(object)) continue;
                vector2.add(object);
            }
            if (!((ReservoirElement)object).hasPowerPlant()) {
                vector.remove(object);
                continue;
            }
            for (n = 0; n < nArray.length; ++n) {
                if (object.getIndex() != nArray[n]) continue;
                vector.remove(object);
                if (vector2.contains(object)) continue block0;
                vector2.add(object);
                continue block0;
            }
        }
        for (n2 = 0; n2 < vector.size(); ++n2) {
            vector.set(n2, this.reservoirUseRuleString((ReservoirElement)vector.get(n2), systemHydropowerOpRule));
        }
        for (n2 = 0; n2 < vector2.size(); ++n2) {
            vector2.set(n2, this.reservoirUseRuleString((ReservoirElement)vector2.get(n2), systemHydropowerOpRule));
        }
        window.setDesc(string);
        window.setData(vector, vector2);
        window.setNote(string2);
        window.setNoteVisible(true);
        window.setVisible(true);
        if (window.isCanceled()) {
            return;
        }
        Object[] objectArray = window.getSelectedObjects();
        if (objectArray == null) {
            systemHydropowerOpRule.setReservoirIndexArray(null);
            return;
        }
        nArray = new int[objectArray.length];
        block5: for (int i = 0; i < objectArray.length; ++i) {
            object = objectArray[i].toString();
            if (((String)object).indexOf("*") > 0) {
                object = ((String)object).substring(0, ((String)object).indexOf("*"));
            }
            for (n = 0; n < ((Vector)object2).size(); ++n) {
                if (!((Vector)object2).get(n).toString().equalsIgnoreCase((String)object)) continue;
                nArray[i] = ((ReservoirElement)((Vector)object2).get(n)).getIndex();
                continue block5;
            }
        }
        systemHydropowerOpRule.setReservoirIndexArray(nArray);
        this.setModified(true);
    }

    private String reservoirUseRuleString(ReservoirElement reservoirElement, SystemHydropowerOpRule systemHydropowerOpRule) {
        Vector vector = reservoirElement.getReservoirOp().getRules();
        if (vector.size() != 0) {
            for (int i = 0; i < vector.size(); ++i) {
                if (!vector.get(i).toString().equalsIgnoreCase(systemHydropowerOpRule.toString())) continue;
                return reservoirElement.getName() + "*";
            }
        }
        return ((Element)reservoirElement).toString();
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        this.plotData();
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
    }

    public void tableDataChanged(TableUpdateEvent tableUpdateEvent) {
        if (tableUpdateEvent.getChangeReason() == TableUpdateEvent.PASTE || tableUpdateEvent.getChangeReason() == TableUpdateEvent.CUT) {
            this.plotData();
        }
    }

    public void fillPanel() {
        if (this.m_currentRuleRef == null) {
            return;
        }
        SystemHydropowerOpRule systemHydropowerOpRule = (SystemHydropowerOpRule)this.m_currentRuleRef.getRule();
        this.jRuleTxt.setText(systemHydropowerOpRule.getName());
        this.jRuleDescTxt.setText(systemHydropowerOpRule.getDescription());
        this.m_oldRuleName = systemHydropowerOpRule.getName();
        if (systemHydropowerOpRule.getRequirementVariation() == 0) {
            ((CardLayout)this.m_cardPanel.getLayout()).show(this.m_cardPanel, "MONTHLY TABLE");
            this.m_currentCard = "MONTHLY TABLE";
        } else {
            ((CardLayout)this.m_cardPanel.getLayout()).show(this.m_cardPanel, "SEASONAL TABLE");
            this.m_currentCard = "SEASONAL TABLE";
        }
        int n = systemHydropowerOpRule.getDailyGenerationPattern();
        switch (n) {
            case 0: {
                this.m_useLocalGenPattern.setSelected(true);
                break;
            }
            case 1: {
                this.m_specifyGenPattern.setSelected(true);
            }
        }
        Object object = systemHydropowerOpRule.getMonthlyPowerRequirement();
        for (int i = 0; i < ((double[])object).length; ++i) {
            this.m_monthlyTable.setValueAt(this.MONTHLY_DATA[i][0], i, 0);
            this.m_monthlyTable.setValueAt((Object)RMAIO.toTable((double)object[i]), i, 1);
        }
        SeasonalRecord seasonalRecord = systemHydropowerOpRule.getSeasonalPowerRequirement();
        ((SeasonalRecordTableModel)this.m_seasonalTable.getModel()).setSeasonalRecord(seasonalRecord, "01JAN");
        this.setTableColumnLabel(systemHydropowerOpRule.getPowerReqSpecification());
        this._useEnergyRequiredTimeSeries.setSelected(systemHydropowerOpRule.useEnergyRequiredTimeSeries());
        this.useEnergyRequiredTimeSeriesAction();
        ReservoirElement reservoirElement = (ReservoirElement)systemHydropowerOpRule.getOperationsElement();
        object = reservoirElement;
        if (reservoirElement.getPowerPlants().length <= 0) {
            this._useContributeStorageOnly.setSelected(true);
            this._useContributeStorageOnly.setEnabled(false);
            this._usePassThruOnly.setSelected(false);
            this._usePassThruOnly.setEnabled(false);
        } else {
            this._useContributeStorageOnly.setSelected(systemHydropowerOpRule.getContributeStorageOnly());
            this._useContributeStorageOnly.setEnabled(true);
            this._usePassThruOnly.setSelected(systemHydropowerOpRule.getPassThruOnly());
            this._usePassThruOnly.setEnabled(true);
        }
        this.plotData();
        this.setModified(false);
    }

    public boolean savePanel() {
        if (this.m_currentRuleRef == null) {
            return true;
        }
        this.m_seasonalTable.commitEdit(true);
        this.m_monthlyTable.commitEdit(true);
        SystemHydropowerOpRule systemHydropowerOpRule = (SystemHydropowerOpRule)this.m_currentRuleRef.getRule();
        this.m_oldRuleName = this.jRuleTxt.getText();
        systemHydropowerOpRule.setName(this.m_oldRuleName);
        systemHydropowerOpRule.setDescription(this.jRuleDescTxt.getText());
        if (this.m_useLocalGenPattern.isSelected()) {
            systemHydropowerOpRule.setDailyGenerationPattern(0);
        } else {
            systemHydropowerOpRule.setDailyGenerationPattern(1);
        }
        Object object = this.getMonthlyPowerReqFromTable();
        systemHydropowerOpRule.setMonthlyPowerRequirement((double[])object);
        systemHydropowerOpRule.setUseEnergyRequiredTimeSeries(this._useEnergyRequiredTimeSeries.isSelected());
        systemHydropowerOpRule.setContributeStorageOnly(this._useContributeStorageOnly.isSelected());
        systemHydropowerOpRule.setPassThruOnly(this._usePassThruOnly.isSelected());
        object = new SeasonalRecord();
        ((SeasonalRecordTableModel)this.m_seasonalTable.getModel()).storeData((SeasonalRecord)object);
        systemHydropowerOpRule.setSeasonalPowerRequirement((SeasonalRecord)object);
        systemHydropowerOpRule.setModified(true);
        return true;
    }

    private double[] getMonthlyPowerReqFromTable() {
        this.m_monthlyTable.commitEdit(true);
        double[] dArray = new double[this.m_monthlyTable.getModel().getRowCount()];
        for (int i = 0; i < dArray.length; ++i) {
            Object object = this.m_monthlyTable.getModel().getValueAt(i, 1);
            dArray[i] = RMAIO.parseDouble((Object)object);
        }
        return dArray;
    }

    public void plotData() {
        this.m_plot.setVisible(false);
        Vector<Object> vector = new Vector<Object>();
        if (this.m_currentCard == "MONTHLY TABLE") {
            this.m_monthlyPlotData.setData(this.m_monthlyTable, 0, 1);
            vector.add(this.m_monthlyPlotData);
        } else {
            SeasonalRecord seasonalRecord = new SeasonalRecord();
            ((SeasonalRecordTableModel)this.m_seasonalTable.getModel()).storeData(seasonalRecord);
            this.m_seasonalPlotData.setPlotYears(1);
            this.m_seasonalPlotData.setData(seasonalRecord);
            vector.add(this.m_seasonalPlotData);
        }
        this.m_plot.setPlotObjects(vector);
        this.m_plot.setVisible(true);
    }

    public void setRuleRef(OpRuleRef opRuleRef) {
        if (opRuleRef == null) {
            return;
        }
        if (this.isModified()) {
            this.savePanel();
        }
        this.m_currentRuleRef = opRuleRef;
        this.fillPanel();
    }

    public void setParent(JPanel jPanel) {
        this.m_parent = (JOperationsPanel)((Object)jPanel);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.jRuleTxt.getText().equals("")) {
            this.jRuleTxt.setText(this.m_currentRuleRef.getRule().getName());
            RMAIO.postError((Component)((Object)this), (String)"Cannot have a blank Rule Name!");
            return;
        }
        this.m_currentRuleRef.getRule().setName(this.jRuleTxt.getText());
        this.m_currentRuleRef.setName(this.jRuleTxt.getText());
        this.m_parent.treeDataChanged(0, this.m_oldRuleName, this.jRuleTxt.getText());
    }

    public static void a(String[] object) {
        object = new JFrame();
        ((JFrame)object).getContentPane().add((Component)((Object)new SystemHydropowerRulePanel()), "Center");
        ((Window)object).setLocation(500, 500);
        ((Window)object).pack();
        ((Window)object).setVisible(true);
    }
}

