/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.gui.NameDescriptionPanel;
import hec.rss.client.JOperationsPanel;
import hec.rss.model.OpRuleRef;
import hec.rss.model.ReservoirElement;
import hec.rss.model.TandemOpRule;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.Document;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.text.DssPathnamePartDocument;
import rma.util.RMAIO;

public class TandemOpRulePanel
extends DefaultJPanel {
    private OpRuleRef _currentRuleRef;
    private String _oldRuleName = "";
    private DefaultJPanel _parent = null;
    private NameDescriptionPanel jNameDescPanel = new NameDescriptionPanel(8L);
    private JLabel jRuleLabel = new JLabel("Tandem Operation Rule:");
    private JLabel jReservoirLabel = new JLabel("Downstream Reservoir:");
    private RmaJComboBox jReservoirCombo = new RmaJComboBox();

    public TandemOpRulePanel() {
        this.setLayout(new GridBagLayout());
        this.jNameDescPanel.setNameEditable(false);
        this.jNameDescPanel.setNameDocument((Document)new DssPathnamePartDocument());
        this.jNameDescPanel.setNameLabel(this.jRuleLabel.getText());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)0, (int)0, (int)0);
        TandemOpRulePanel tandemOpRulePanel = this;
        tandemOpRulePanel.add((Component)tandemOpRulePanel.jNameDescPanel, gridBagConstraints);
        this.jReservoirLabel = new JLabel("Downstream Reservoir:");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        TandemOpRulePanel tandemOpRulePanel2 = this;
        tandemOpRulePanel2.add(tandemOpRulePanel2.jReservoirLabel, gridBagConstraints);
        this.jReservoirCombo = new RmaJComboBox();
        this.jReservoirCombo.setModifiable(true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        TandemOpRulePanel tandemOpRulePanel3 = this;
        tandemOpRulePanel3.add((Component)tandemOpRulePanel3.jReservoirCombo, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        this.add(jPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)new JLabel("Limit Type:"), gridBagConstraints);
        RmaJComboBox rmaJComboBox = new RmaJComboBox((Object[])new String[]{"Specified"});
        rmaJComboBox.setModifiable(true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)rmaJComboBox, gridBagConstraints);
        rmaJComboBox.setEnabled(false);
    }

    public void setDownstreamReservoirComboModel(Vector vector) {
        Vector vector2 = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.get(i);
            if (!(e instanceof ReservoirElement)) continue;
            vector2.add(e);
        }
        this.jReservoirCombo.removeItemListener((ItemListener)((Object)this));
        this.jReservoirCombo.setModel(new DefaultComboBoxModel(vector2));
        this.jReservoirCombo.addItemListener((ItemListener)((Object)this));
    }

    public void setRuleRef(OpRuleRef opRuleRef) {
        if (opRuleRef == null) {
            return;
        }
        if (this.isModified()) {
            this.savePanel();
        }
        this._currentRuleRef = opRuleRef;
        this.fillPanel();
    }

    public void fillPanel() {
        if (this._currentRuleRef == null) {
            return;
        }
        TandemOpRule tandemOpRule = (TandemOpRule)this._currentRuleRef.getRule();
        this.clearPanel();
        this.jNameDescPanel.setName(tandemOpRule.getName());
        this.jNameDescPanel.setDescription(tandemOpRule.getDescription());
        this._oldRuleName = tandemOpRule.getName();
        int n = tandemOpRule.getReservoirIndex();
        if (n < 0) {
            this.jReservoirCombo.setSelectedIndex(-1);
        } else {
            int n2;
            int n3 = this.jReservoirCombo.getItemCount();
            for (n2 = 1; n2 < n3; ++n2) {
                ReservoirElement reservoirElement = (ReservoirElement)this.jReservoirCombo.getItemAt(n2);
                if (reservoirElement.getIndex() != n) continue;
                this.jReservoirCombo.setSelectedIndex(n2);
                break;
            }
            if (n2 == n3) {
                this.jReservoirCombo.setSelectedIndex(0);
            }
        }
        this.setModified(false);
    }

    public void refresh() {
    }

    public boolean savePanel() {
        if (this._currentRuleRef == null) {
            return false;
        }
        if (this.jNameDescPanel.getName().equals("")) {
            RMAIO.postError((Component)((Object)this), (String)"Cannot have an empty rule name!");
            return false;
        }
        TandemOpRule tandemOpRule = (TandemOpRule)this._currentRuleRef.getRule();
        this._currentRuleRef.getRule().setName(this.jNameDescPanel.getName());
        this._currentRuleRef.setName(this.jNameDescPanel.getName());
        this._oldRuleName = this.jNameDescPanel.getName();
        tandemOpRule.setDescription(this.jNameDescPanel.getDescription());
        Object object = this.jReservoirCombo.getSelectedItem();
        if (object instanceof ReservoirElement) {
            tandemOpRule.setReservoirIndex(((ReservoirElement)object).getIndex());
        } else {
            tandemOpRule.setReservoirIndex(-1);
        }
        this.setModified(false);
        return true;
    }

    public void clearPanel() {
        this.jNameDescPanel.setName("");
        this.jNameDescPanel.setDescription("");
        this.jReservoirCombo.setSelectedIndex(-1);
    }

    public void setParent(JPanel jPanel) {
        this._parent = (JOperationsPanel)((Object)jPanel);
    }
}

