/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.rss.client.JOperationsPanel;
import hec.rss.model.OpRuleRef;
import hec.rss.model.ReservoirElement;
import hec.rss.model.TandemSysOpRule;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDescriptionField;
import rma.swing.RmaJDssPathPartField;
import rma.swing.RmaJTextField;
import rma.util.RMAIO;

public class TandemSysOpRulePanel
extends DefaultJPanel {
    private OpRuleRef _currentRuleRef;
    private String _oldRuleName = "";
    private DefaultJPanel _parent = null;
    private JLabel jRuleNameLabel;
    private RmaJTextField jRuleNameTxt;
    private JLabel jDescriptionLabel;
    private RmaJDescriptionField jDescriptionTxt;
    private JLabel jReservoirLabel = new JLabel("Downstream Reservoir:");
    private RmaJComboBox jReservoirCombo = new RmaJComboBox();

    public TandemSysOpRulePanel() {
        this.setLayout(new GridBagLayout());
        this.jRuleNameLabel = new JLabel("Tandem System Rule");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        TandemSysOpRulePanel tandemSysOpRulePanel = this;
        tandemSysOpRulePanel.add(tandemSysOpRulePanel.jRuleNameLabel, gridBagConstraints);
        this.jRuleNameTxt = new RmaJDssPathPartField();
        this.jRuleNameTxt.setModifiable(false);
        this.jRuleNameTxt.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        TandemSysOpRulePanel tandemSysOpRulePanel2 = this;
        tandemSysOpRulePanel2.add((Component)tandemSysOpRulePanel2.jRuleNameTxt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.add(new JLabel(), gridBagConstraints);
        this.jDescriptionLabel = new JLabel("Description");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        TandemSysOpRulePanel tandemSysOpRulePanel3 = this;
        tandemSysOpRulePanel3.add(tandemSysOpRulePanel3.jDescriptionLabel, gridBagConstraints);
        this.jDescriptionTxt = new RmaJDescriptionField();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        TandemSysOpRulePanel tandemSysOpRulePanel4 = this;
        tandemSysOpRulePanel4.add((Component)tandemSysOpRulePanel4.jDescriptionTxt, gridBagConstraints);
        this.jReservoirLabel = new JLabel("Downstream Reservoir:");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        TandemSysOpRulePanel tandemSysOpRulePanel5 = this;
        tandemSysOpRulePanel5.add(tandemSysOpRulePanel5.jReservoirLabel, gridBagConstraints);
        this.jReservoirCombo = new RmaJComboBox();
        this.jReservoirCombo.setModifiable(true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        TandemSysOpRulePanel tandemSysOpRulePanel6 = this;
        tandemSysOpRulePanel6.add((Component)tandemSysOpRulePanel6.jReservoirCombo, gridBagConstraints);
    }

    public void setDownstreamReservoirComboModel(Vector vector) {
        Vector vector2 = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.get(i);
            if (!(e instanceof ReservoirElement)) continue;
            vector2.add(e);
        }
        this.jReservoirCombo.removeItemListener((ItemListener)((Object)this));
        this.jReservoirCombo.setModel(new DefaultComboBoxModel(vector2));
        this.jReservoirCombo.addItemListener((ItemListener)((Object)this));
    }

    public void setRuleRef(OpRuleRef opRuleRef) {
        if (opRuleRef == null) {
            return;
        }
        if (this.isModified()) {
            this.savePanel();
        }
        this._currentRuleRef = opRuleRef;
        this.fillPanel();
    }

    public void fillPanel() {
        if (this._currentRuleRef == null) {
            return;
        }
        TandemSysOpRule tandemSysOpRule = (TandemSysOpRule)this._currentRuleRef.getRule();
        this.clearPanel();
        this.jRuleNameTxt.setText(tandemSysOpRule.getName());
        this.jDescriptionTxt.setText(tandemSysOpRule.getDescription());
        this._oldRuleName = tandemSysOpRule.getName();
        this.jReservoirCombo.setSelectedIndex(0);
        this.setModified(false);
    }

    public void refresh() {
    }

    public boolean savePanel() {
        if (this._currentRuleRef == null) {
            return false;
        }
        if (this.jRuleNameTxt.getText().length() == 0) {
            RMAIO.postError((Component)((Object)this), (String)"Cannot have an empty rule name!");
            return false;
        }
        TandemSysOpRule tandemSysOpRule = (TandemSysOpRule)this._currentRuleRef.getRule();
        this._currentRuleRef.getRule().setName(this.jRuleNameTxt.getText());
        this._currentRuleRef.setName(this.jRuleNameTxt.getText());
        this._oldRuleName = this.jRuleNameTxt.getText();
        tandemSysOpRule.setDescription(this.jDescriptionTxt.getText());
        this.jReservoirCombo.getSelectedItem();
        this.setModified(false);
        return true;
    }

    public void clearPanel() {
        this.jRuleNameTxt.setText("");
        this.jDescriptionTxt.setText("");
        this.jReservoirCombo.setSelectedIndex(-1);
    }

    public void setParent(JPanel jPanel) {
        this._parent = (JOperationsPanel)((Object)jPanel);
    }
}

