/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.rss.client.TimeOfDayMultiplierJDialog$SymWindow;
import hec.rss.model.TimeOfDayMultiplier;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.NumberFormat;
import java.util.EventObject;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;
import rma.util.RMAIO;

public class TimeOfDayMultiplierJDialog
extends RmaJDialog
implements ItemListener,
ButtonCmdPanelListener {
    boolean _canceled = true;
    TimeOfDayMultiplier _multiplier = null;
    int _currentInterval;
    String[] colLabels = new String[]{"Time of Day", "Multiplier"};
    RmaJTable multiplierTable;
    JLabel jTimeIntervalLabel;
    ButtonCmdPanel cmdPanel;
    int[] intervals;
    String[] intervalStrings;
    RmaJComboBox jTimeIntervalCombo;
    boolean fComponentsAdjusted;
    NumberFormat nf;

    public TimeOfDayMultiplierJDialog(Frame frame, boolean bl) {
        super(frame, bl);
        TimeOfDayMultiplierJDialog timeOfDayMultiplierJDialog = this;
        this.multiplierTable = new RmaJTable((Component)((Object)timeOfDayMultiplierJDialog), (Object[])timeOfDayMultiplierJDialog.colLabels);
        this.jTimeIntervalLabel = new JLabel("Time Interval");
        this.cmdPanel = new ButtonCmdPanel(12);
        this.intervals = new int[]{1, 2, 3, 4, 6, 12};
        this.intervalStrings = new String[]{"1 hour", "2 hours", "3 hours", "4 hours", "6 hours", "12 hours"};
        this.jTimeIntervalCombo = new RmaJComboBox((Object[])this.intervalStrings);
        this.fComponentsAdjusted = false;
        this.createControls();
    }

    public TimeOfDayMultiplierJDialog(Dialog dialog, boolean bl) {
        super(dialog, bl);
        TimeOfDayMultiplierJDialog timeOfDayMultiplierJDialog = this;
        this.multiplierTable = new RmaJTable((Component)((Object)timeOfDayMultiplierJDialog), (Object[])timeOfDayMultiplierJDialog.colLabels);
        this.jTimeIntervalLabel = new JLabel("Time Interval");
        this.cmdPanel = new ButtonCmdPanel(12);
        this.intervals = new int[]{1, 2, 3, 4, 6, 12};
        this.intervalStrings = new String[]{"1 hour", "2 hours", "3 hours", "4 hours", "6 hours", "12 hours"};
        this.jTimeIntervalCombo = new RmaJComboBox((Object[])this.intervalStrings);
        this.fComponentsAdjusted = false;
        this.createControls();
    }

    public TimeOfDayMultiplierJDialog(Frame frame, String string, boolean bl) {
        this(frame, bl);
        this.setTitle(string);
    }

    public TimeOfDayMultiplierJDialog(Dialog dialog, String string, boolean bl) {
        this(dialog, bl);
        this.setTitle(string);
    }

    private void createControls() {
        this.setSize(240, 280);
        this.getContentPane().setLayout(new GridBagLayout());
        Object object = new JPanel();
        ((Container)object).add((Component)this.jTimeIntervalLabel, new RmaGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        ((Container)object).add((Component)this.jTimeIntervalCombo, new RmaGridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)object, new RmaGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 16, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.multiplierTable.setDoubleCellEditor(1);
        this.multiplierTable.setHorizontalAlignment(0, 0);
        this.multiplierTable.setHorizontalAlignment(4, 1);
        this.multiplierTable.setNumRows(10);
        this.multiplierTable.setColumnEnabled(false, 0);
        this.multiplierTable.getScrollPane().setVerticalScrollBarPolicy(22);
        this.multiplierTable.getScrollPane().setHorizontalScrollBarPolicy(30);
        this.getContentPane().add((Component)this.multiplierTable.getScrollPane(), new RmaGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.getContentPane().add((Component)this.cmdPanel, new RmaGridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 16, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.setPrintLocations(true);
        this.cmdPanel.addCmdPanelListener((ButtonCmdPanelListener)this);
        this.jTimeIntervalCombo.addItemListener((ItemListener)this);
        object = new TimeOfDayMultiplierJDialog$SymWindow(this);
        this.addWindowListener((WindowListener)object);
        this.registerEnterKey(true);
        this.registerEscapeKey(true);
    }

    public void addNotify() {
        Component[] componentArray = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Insets insets = this.getInsets();
        this.setSize(insets.left + insets.right + componentArray.width, insets.top + insets.bottom + componentArray.height);
        componentArray = this.getContentPane().getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Point point = componentArray[i].getLocation();
            point.translate(insets.left, insets.top);
            componentArray[i].setLocation(point);
        }
        this.fComponentsAdjusted = true;
    }

    public TimeOfDayMultiplierJDialog(String string) {
        this();
        this.setTitle(string);
    }

    public TimeOfDayMultiplierJDialog() {
        this((Frame)null, false);
    }

    public void setColumnLabels(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            this.multiplierTable.setColumnLabels(stringArray);
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            Dimension dimension = this.getSize();
            Dimension dimension2 = this.getParent().getSize();
            this.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
            this.fillForm();
        }
        super.setVisible(bl);
    }

    void TimeOfDayMultiplierJDialog_WindowClosing(WindowEvent windowEvent) {
        this.dispose();
        this._canceled = true;
    }

    public void buttonCmdActionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getID() == 8) {
            this.cmdOK_Action();
            return;
        }
        if (actionEvent.getID() == 4) {
            this.cmdCancel_Action();
        }
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public void cmdOK_Action() {
        if (!this.saveForm()) {
            return;
        }
        this._canceled = false;
        this.setVisible(false);
        this.dispose();
    }

    public void cmdCancel_Action() {
        this._canceled = true;
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void itemStateChanged(ItemEvent object) {
        if (((ItemEvent)object).getStateChange() == 2) {
            return;
        }
        if ((object = ((EventObject)object).getSource()) == this.jTimeIntervalCombo) {
            this.intervalChanged();
        }
    }

    private void intervalChanged() {
        int n = this.jTimeIntervalCombo.getSelectedIndex();
        if (n < 0) {
            return;
        }
        n = this.intervals[n];
        TimeOfDayMultiplier timeOfDayMultiplier = this.saveTable();
        timeOfDayMultiplier.setInterval(n);
        this._multiplier = timeOfDayMultiplier;
        this.fillForm();
    }

    private TimeOfDayMultiplier saveTable() {
        this.multiplierTable.commitEdit(true);
        if (!TimeOfDayMultiplier.a(this._currentInterval)) {
            return null;
        }
        TimeOfDayMultiplier timeOfDayMultiplier = new TimeOfDayMultiplier();
        timeOfDayMultiplier.setInterval(this._currentInterval);
        int n = 24 / this._currentInterval;
        int n2 = this.multiplierTable.getNumRows();
        if (n2 > n) {
            n2 = n;
        }
        for (n = 0; n < n2; ++n) {
            Object object = this.multiplierTable.getCell(n, 1);
            double d = RMAIO.parseDouble((Object)object);
            timeOfDayMultiplier.setMultiplier(n, d);
        }
        return timeOfDayMultiplier;
    }

    public void setData(TimeOfDayMultiplier timeOfDayMultiplier) {
        if (timeOfDayMultiplier == null) {
            return;
        }
        try {
            this._multiplier = (TimeOfDayMultiplier)timeOfDayMultiplier.clone();
            return;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("TimeOfDayMultiplierJDialog.setData: CloneNotSupportedException ");
            return;
        }
    }

    private void fillForm() {
        int n;
        double[] dArray;
        block8: {
            block7: {
                if (this._multiplier == null || this._multiplier.getMultipliers() == null) {
                    this._multiplier = new TimeOfDayMultiplier();
                }
                if ((dArray = this._multiplier.getMultipliers()) == null || dArray.length <= 0) break block7;
                if (TimeOfDayMultiplier.a(this._multiplier.getInterval())) break block8;
            }
            return;
        }
        int n2 = dArray.length;
        int n3 = this._multiplier.getInterval();
        if (n2 != 24 / n3) {
            return;
        }
        this.multiplierTable.setNumRows(n2);
        for (n = 0; n < n2; ++n) {
            int n4 = n * n3;
            String string = this.translateIntToHour(n4) + "-" + this.translateIntToHour(n4 + n3);
            this.multiplierTable.setValueAt((Object)string, n, 0);
            this.multiplierTable.setCell((Object)RMAIO.toTable((double)dArray[n]), n, 1);
        }
        this._currentInterval = n3;
        this.jTimeIntervalCombo.removeItemListener((ItemListener)this);
        this.jTimeIntervalCombo.setSelectedIndex(0);
        for (n = 0; n < this.intervals.length; ++n) {
            if (this.intervals[n] != this._currentInterval) continue;
            this.jTimeIntervalCombo.setSelectedIndex(n);
            break;
        }
        this.jTimeIntervalCombo.addItemListener((ItemListener)this);
    }

    public String translateIntToHour(int n) {
        if (this.nf == null) {
            this.nf = NumberFormat.getInstance();
            this.nf.setMinimumIntegerDigits(4);
            this.nf.setGroupingUsed(false);
        }
        return this.nf.format(n * 100);
    }

    private boolean saveForm() {
        this._multiplier = this.saveTable();
        return true;
    }

    public TimeOfDayMultiplier getData() {
        return this._multiplier;
    }

    public static void a(String[] object) {
        object = new TimeOfDayMultiplierJDialog();
        TimeOfDayMultiplier timeOfDayMultiplier = new TimeOfDayMultiplier();
        ((TimeOfDayMultiplierJDialog)object).setData(timeOfDayMultiplier);
        ((TimeOfDayMultiplierJDialog)object).setVisible(true);
    }
}

