/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.rss.client.TimeSeriesOptionsPanel$1;
import hec.rss.client.TimeSeriesOptionsPanel$ToolTipRenderer;
import hec.rss.model.IndependentVariable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;

public class TimeSeriesOptionsPanel
extends JPanel {
    private String[] FUNCTION_VALUES = IndependentVariable.TS_FUNCTION_STRINGS;
    private String[] FUNCTION_TOOLTIPS = new String[]{"Uses value at current time step", "Uses value at end of last time step", "Uses value offest number of hours relative to the current time step", "<html>Averages the value of the given number of hours prior<br>to <b>offset</b> hours relative to current time step</html>", "<html>Maximum value over the given number of hours prior<br>tp <b>offset</b> hours relative to the current time step</html>", "<html>Minimum value over the given number of hours prior<br>to <b>offset</b> hours relative to the current time step</html>"};
    private boolean[][] ENABLED_STATES = new boolean[][]{{false, false}, {false, false}, {true, false}, {true, true}, {true, true}, {true, true}};
    private RmaJComboBox _functionCombo;
    private RmaJDecimalField _lagFld;
    private RmaJDecimalField _periodFld;
    private JLabel _periodLabel;

    TimeSeriesOptionsPanel() {
        super(new GridBagLayout());
        this.buildControls();
    }

    protected void buildControls() {
        this.setBorder(BorderFactory.createTitledBorder("Time Series Options"));
        JLabel jLabel = new JLabel("Function:");
        jLabel.setDisplayedMnemonic('u');
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.add((Component)jLabel, gridBagConstraints);
        this._functionCombo = new RmaJComboBox((Object[])this.FUNCTION_VALUES);
        this._functionCombo.setRenderer((ListCellRenderer)new TimeSeriesOptionsPanel$ToolTipRenderer(this));
        this._functionCombo.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        TimeSeriesOptionsPanel timeSeriesOptionsPanel = this;
        timeSeriesOptionsPanel.add((Component)timeSeriesOptionsPanel._functionCombo, gridBagConstraints);
        jLabel = new JLabel("Offset (hours):");
        jLabel.setToolTipText("Number of hours forward (+) or back (-) from current timestep (0)");
        jLabel.setDisplayedMnemonic('L');
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.add((Component)jLabel, gridBagConstraints);
        this._lagFld = new RmaJDecimalField();
        this._lagFld.setToolTipText("Number of hours forward (+) or back (-) from current timestep (0)");
        jLabel.setLabelFor((Component)this._lagFld);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        TimeSeriesOptionsPanel timeSeriesOptionsPanel2 = this;
        timeSeriesOptionsPanel2.add((Component)timeSeriesOptionsPanel2._lagFld, gridBagConstraints);
        this._periodLabel = new JLabel("Period (hours):");
        this._periodLabel.setDisplayedMnemonic('P');
        this._periodLabel.setToolTipText("Number of hours back from the Offset");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        TimeSeriesOptionsPanel timeSeriesOptionsPanel3 = this;
        timeSeriesOptionsPanel3.add((Component)timeSeriesOptionsPanel3._periodLabel, gridBagConstraints);
        this._periodFld = new RmaJDecimalField();
        this._periodFld.setMinValue(0.0);
        this._periodLabel.setLabelFor((Component)this._periodFld);
        this._periodFld.setToolTipText("Number of hours back from the Offset");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        TimeSeriesOptionsPanel timeSeriesOptionsPanel4 = this;
        timeSeriesOptionsPanel4.add((Component)timeSeriesOptionsPanel4._periodFld, gridBagConstraints);
        this._functionCombo.addItemListener((ItemListener)new TimeSeriesOptionsPanel$1(this));
        this.functionComboSelected();
    }

    protected void functionComboSelected() {
        int n = this._functionCombo.getSelectedIndex();
        if (n == -1) {
            this._lagFld.setEnabled(false);
            this._periodFld.setEnabled(false);
            return;
        }
        boolean[] blArray = this.ENABLED_STATES[n];
        this._lagFld.setEnabled(blArray[0]);
        this._periodFld.setEnabled(blArray[1]);
    }

    protected void disableAllFields() {
        this._functionCombo.setSelectedIndex(0);
        this._functionCombo.setEnabled(false);
        this._functionCombo.setEditable(false);
        this._lagFld.setEnabled(false);
        this._periodFld.setEnabled(false);
    }

    protected void enableDefineZoneFields() {
        this._functionCombo.setEnabled(true);
        this._functionCombo.setSelectedIndex(1);
        this.functionComboSelected();
    }

    protected void enableAllFields() {
        this._functionCombo.setEnabled(true);
        this._functionCombo.setSelectedIndex(1);
        this.functionComboSelected();
    }

    int getFunctionType() {
        return this._functionCombo.getSelectedIndex();
    }

    double getLag() {
        return -1.0 * this._lagFld.getValue();
    }

    double getPeriod() {
        return this._periodFld.getValue();
    }

    boolean isValidForm() {
        String string = null;
        if (this._lagFld.isEnabled() && this._lagFld.getText().length() == 0) {
            string = "Please enter an Offest amount";
        } else if (this._periodFld.isEnabled() && this._periodFld.getText().length() == 0) {
            string = "Please enter a Period amount";
        }
        if (string != null) {
            JOptionPane.showMessageDialog(this, string, "Incomplete Form", 1);
        }
        return string == null;
    }

    public void setTimeSeriesOptions(String string, double d, double d2) {
        this._functionCombo.setSelectedItem((Object)string);
        if (this._lagFld.isEnabled()) {
            this._lagFld.setValue(-d);
        }
        if (this._periodFld.isEnabled()) {
            this._periodFld.setValue(d2);
        }
    }

    public void clearPanel() {
        this._lagFld.setText("");
        this._periodFld.setText("");
        this._functionCombo.setSelectedIndex(1);
    }
}

