/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.rss.server.JunctionDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;
import rma.swing.table.RmaCellEditor;
import rma.swing.table.RmaTableModel;

public class TwoVariableDialog<T>
extends RmaJDialog
implements ButtonCmdPanelListener {
    ArrayList<T> _values = new ArrayList(0);
    private final Comparator<? super T> comparator;
    RmaJTable _valuesTable;
    Dialog _parent = null;
    ButtonCmdPanel _buttonCmdPanel = new ButtonCmdPanel(12);
    private String _secondColumnLabel = "Elevation\n(%S)";
    boolean _isOk = false;
    private RmaCellEditor editor;
    private TableCellRenderer renderer;

    public TwoVariableDialog(Frame frame, boolean bl) {
        this(frame, bl, "");
    }

    public TwoVariableDialog(Frame frame, boolean bl, String string) {
        this(frame, bl, string, null, null, null);
    }

    public TwoVariableDialog(Frame frame, boolean bl, String string, Comparator<? super T> comparator, TableCellRenderer tableCellRenderer, RmaCellEditor rmaCellEditor) {
        super(frame, bl);
        if (this._secondColumnLabel != "") {
            this._secondColumnLabel = string;
        }
        this.comparator = comparator;
        this.renderer = tableCellRenderer;
        this.editor = rmaCellEditor;
        this.buildControls();
    }

    public TwoVariableDialog(Dialog dialog, boolean bl) {
        this(dialog, bl, "");
    }

    public TwoVariableDialog(Dialog dialog, boolean bl, String string) {
        this(dialog, bl, string, null, null, null);
    }

    public TwoVariableDialog(Dialog dialog, boolean bl, String string, Comparator<? super T> comparator, TableCellRenderer tableCellRenderer, RmaCellEditor rmaCellEditor) {
        super(dialog, bl);
        if (this._secondColumnLabel != "") {
            this._secondColumnLabel = string;
        }
        this.comparator = comparator;
        this.renderer = tableCellRenderer;
        this.editor = rmaCellEditor;
        this.buildControls();
        this._parent = dialog;
    }

    private void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Specify Two Variable Column Values");
        this.setSize(220, 350);
        Object object = new Vector(Arrays.asList(" ", "Value\n(%S)"));
        Vector<Boolean> vector = new Vector<Boolean>(Arrays.asList(Boolean.FALSE, Boolean.TRUE));
        object = new RmaTableModel(object, new Vector(), vector);
        this._valuesTable = new RmaJTable((Component)((Object)this));
        this._valuesTable.setModel((TableModel)object);
        this._valuesTable.setUnitsHeaderRenderer();
        this._valuesTable.getScrollPane().setVerticalScrollBarPolicy(20);
        this._valuesTable.getScrollPane().setHorizontalScrollBarPolicy(30);
        this._valuesTable.setDoubleCellEditor(1);
        this._valuesTable.setNumRows(8);
        this._valuesTable.setRowHeaderEnabled(true);
        this._valuesTable.setAutoRowHeaders(true, 1);
        this._valuesTable.setColumnWidth(0, 10);
        this.getContentPane().add((Component)this._valuesTable.getScrollPane(), new RmaGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 0, 5), 0, 0));
        object = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this._buttonCmdPanel, new RmaGridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 14, 0, (Insets)object, 0, 0));
        this._buttonCmdPanel.addCmdPanelListener((ButtonCmdPanelListener)this);
        this.setLocation();
    }

    public void fillForm(Collection<T> object, double d) {
        int n;
        this._valuesTable.getModel();
        if (this.editor != null) {
            if (this.renderer != null) {
                this._valuesTable.setColumnEditor(1, this.editor, this.renderer);
            } else {
                this._valuesTable.setColumnEditor(1, this.editor);
            }
        } else {
            RmaJDecimalField rmaJDecimalField = this._valuesTable.setDoubleCellEditor(1);
            rmaJDecimalField.setMinValue(d);
        }
        this._valuesTable.setColumnLabel(1, this._secondColumnLabel);
        this._valuesTable.setColumnParameters(new int[]{-1, Parameter.PARAMID_ELEV});
        int n2 = this._valuesTable.getModel().getRowCount();
        for (n = 0; n < n2; ++n) {
            this._valuesTable.setCell((Object)"", n, 1);
        }
        if (object != null) {
            n = 0;
            object = object.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                this._valuesTable.setValueAt(e, n++, 1);
            }
        }
    }

    public boolean saveForm() {
        Object object;
        int n;
        this._valuesTable.commitEdit(true);
        RmaTableModel rmaTableModel = (RmaTableModel)this._valuesTable.getModel();
        Vector vector = new Vector(rmaTableModel.getDataVector());
        int n2 = 0;
        for (n = 0; n < vector.size(); ++n) {
            object = (Vector)vector.elementAt(n);
            if ((object = ((Vector)object).elementAt(1)) == null || object.toString().equals("")) {
                if (vector.size() - n <= 4) continue;
                rmaTableModel.deleteRow(n);
                continue;
            }
            ++n2;
        }
        this._values.clear();
        this._values.ensureCapacity(n2);
        for (n = 0; n < n2; ++n) {
            object = rmaTableModel.getValueAt(n, 1);
            if (object instanceof ParamDouble) {
                ParamDouble cfr_ignored_0 = (ParamDouble)object;
                System.out.println("how'd this get here?");
            }
            this._values.add(object);
        }
        if (this.comparator != null ? !this.okComparator() : !this.okComparable()) {
            return false;
        }
        if (this._parent != null && this._parent instanceof JunctionDialog) {
            ((JunctionDialog)((Object)this._parent)).setModified(true);
        }
        return true;
    }

    public Collection<T> getTableValues() {
        return this._values;
    }

    public void clearForm() {
    }

    public void setOk(boolean bl) {
        this._isOk = bl;
    }

    public boolean isOk() {
        return this._isOk;
    }

    public void buttonCmdActionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getID() == 8) {
            this.cmdOK_Action();
            return;
        }
        if (actionEvent.getID() == 4) {
            this.cmdCancel_Action();
        }
    }

    public void cmdOK_Action() {
        if (!this.saveForm()) {
            return;
        }
        this.setOk(true);
        this.setVisible(false);
    }

    public void cmdCancel_Action() {
        this._valuesTable.commitEdit(true);
        this.setOk(false);
        this.setVisible(false);
    }

    private boolean okComparator() {
        for (int i = 0; i < this._values.size() - 1; ++i) {
            if (this.comparator.compare(this._values.get(i), this._values.get(i + 1)) < 0) continue;
            String string = this._valuesTable.getColumnLabel(1);
            int n = string.indexOf("\n");
            if (n >= 0) {
                string = string.substring(0, n);
            }
            JOptionPane.showMessageDialog((Component)((Object)this), "The " + string + " values of your function must be a continuously increasing sequence.", "Error", 0);
            return false;
        }
        return true;
    }

    private boolean okComparable() {
        for (int i = 0; i < this._values.size() - 1; ++i) {
            Comparable comparable = (Comparable)this._values.get(i);
            if (comparable.compareTo(this._values.get(i + 1)) < 0) continue;
            String string = this._valuesTable.getColumnLabel(1);
            int n = string.indexOf("\n");
            if (n >= 0) {
                string = string.substring(0, n);
            }
            JOptionPane.showMessageDialog((Component)((Object)this), "The " + string + " values of your function must be a continuously increasing sequence.", "Error", 0);
            return false;
        }
        return true;
    }

    static {
        new Insets(5, 5, 5, 5);
        new Insets(5, 5, 0, 0);
        new Insets(5, 5, 5, 0);
        new Insets(5, 5, 0, 5);
    }
}

