/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.gfx2d.TimeSeriesDataSet;
import hec.io.TimeSeriesContainer;
import hec.rss.client.WaterAccountCurveBase;
import hec.rss.client.WaterAccountCurveCheckbox;
import hec.rss.client.WaterAccountCurveSystemActualStorage;
import hec.rss.client.WaterAccountCurveSystemGuideCurve;
import hec.rss.client.WaterAccountPlotBase;
import hec.rss.client.WaterAccountPlotCache;
import hec.rss.model.RssRun;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import rma.swing.CollapsableJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJPanel;

class WaterAccountMultipleReservoirsPlotDialog
extends WaterAccountPlotBase {
    private final WaterAccountCurveCheckbox _topOfSystemGuideCurveCheckbox = new WaterAccountCurveCheckbox(null, "Top of System Guide Curve", true);
    private final WaterAccountCurveCheckbox _actualSystemStorageCheckbox = new WaterAccountCurveCheckbox(null, "Actual System Storage", true);

    WaterAccountMultipleReservoirsPlotDialog() {
        this.setSize(1000, 800);
        this.setMinimumSize(new Dimension(875, 600));
        this.buildControls();
    }

    @Override
    public void fillDialog(RssRun rssRun) {
        super.fillDialog(rssRun);
        this.addWAComboActionListener();
        this.waterAccountChanged();
    }

    @Override
    CollapsableJPanel createCheckboxPanel() {
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        this.addCheckbox(rmaJPanel, this._topOfGuideCurveCheckbox, 1);
        this.addCheckbox(rmaJPanel, this._topOfSystemGuideCurveCheckbox, 1);
        this.addCheckbox(rmaJPanel, this._poolActualStorageCheckbox, 0);
        this.addCheckbox(rmaJPanel, this._actualSystemStorageCheckbox, 1);
        this.addCheckbox(rmaJPanel, this._wAActualStorageCheckbox, 0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)5);
        rmaJPanel.add((Component)new JSeparator(), (Object)gridBagConstraints);
        this.addCheckbox(rmaJPanel, this._poolFlowInCheckbox, 1);
        this.addCheckbox(rmaJPanel, this._poolFlowOutCheckbox, 1);
        this.addCheckbox(rmaJPanel, this._wAFlowInCheckbox, 0);
        this.addCheckbox(rmaJPanel, this._ruleDemandCheckbox, 1);
        this.addCheckbox(rmaJPanel, this._demandCheckbox, 0);
        return new CollapsableJPanel("Selected Plots", (JPanel)rmaJPanel);
    }

    @Override
    void loadAdditionalTimeSeriesDataFromDSS(WaterAccountPlotCache waterAccountPlotCache) {
        WaterAccountMultipleReservoirsPlotDialog waterAccountMultipleReservoirsPlotDialog = this;
        WaterAccountCurveBase waterAccountCurveBase = new WaterAccountCurveSystemGuideCurve(waterAccountMultipleReservoirsPlotDialog, waterAccountMultipleReservoirsPlotDialog.getSystemGuideCurveTSDS());
        this._topOfSystemGuideCurveCheckbox.setCurve(waterAccountCurveBase);
        waterAccountPlotCache.a((WaterAccountCurveSystemGuideCurve)waterAccountCurveBase);
        WaterAccountMultipleReservoirsPlotDialog waterAccountMultipleReservoirsPlotDialog2 = this;
        waterAccountCurveBase = new WaterAccountCurveSystemActualStorage(waterAccountMultipleReservoirsPlotDialog2, waterAccountMultipleReservoirsPlotDialog2.getSystemActualStorageTSC());
        this._actualSystemStorageCheckbox.setCurve(waterAccountCurveBase);
        waterAccountPlotCache.a((WaterAccountCurveSystemActualStorage)waterAccountCurveBase);
    }

    private List<TimeSeriesDataSet> getAllGuideCurves() {
        ArrayList<TimeSeriesDataSet> arrayList = new ArrayList<TimeSeriesDataSet>();
        for (int n : this._activeReservoirs) {
            arrayList.add(this._dataReader.b(n));
        }
        return arrayList;
    }

    private List<TimeSeriesDataSet> getAllActualStorages() {
        ArrayList<TimeSeriesDataSet> arrayList = new ArrayList<TimeSeriesDataSet>();
        for (int n : this._activeReservoirs) {
            arrayList.add(this._dataReader.c(n));
        }
        return arrayList;
    }

    private TimeSeriesDataSet getSystemGuideCurveTSDS() {
        List<TimeSeriesDataSet> list = this.getAllGuideCurves();
        return this.sumTimeSeriesValues(list, "System Guide Curve");
    }

    private TimeSeriesDataSet getSystemActualStorageTSC() {
        List<TimeSeriesDataSet> list = this.getAllActualStorages();
        return this.sumTimeSeriesValues(list, "System Actual Storage");
    }

    private TimeSeriesDataSet sumTimeSeriesValues(List<TimeSeriesDataSet> list, String string) {
        if (list.isEmpty()) {
            return new TimeSeriesDataSet(new TimeSeriesContainer());
        }
        TimeSeriesContainer timeSeriesContainer = (TimeSeriesContainer)list.get((int)0)._timeSeries.clone();
        int n = timeSeriesContainer.times.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            double d = 0.0;
            for (TimeSeriesDataSet timeSeriesDataSet : list) {
                timeSeriesDataSet = timeSeriesDataSet._timeSeries;
                d += timeSeriesDataSet.values[i];
            }
            dArray[i] = d;
        }
        timeSeriesContainer.setValues(dArray);
        TimeSeriesDataSet timeSeriesDataSet = new TimeSeriesDataSet(timeSeriesContainer);
        timeSeriesDataSet.setName(string);
        return timeSeriesDataSet;
    }

    @Override
    List<WaterAccountCurveBase> addAdditionalStorageCurves() {
        ArrayList<WaterAccountCurveBase> arrayList = new ArrayList<WaterAccountCurveBase>();
        this.addCurveToListIfValid(arrayList, this._topOfSystemGuideCurveCheckbox);
        this.addCurveToListIfValid(arrayList, this._actualSystemStorageCheckbox);
        return arrayList;
    }

    @Override
    void loadAdditionalCachedData(WaterAccountPlotCache waterAccountPlotCache) {
        this._topOfSystemGuideCurveCheckbox.setCurve(waterAccountPlotCache.a());
        this._actualSystemStorageCheckbox.setCurve(waterAccountPlotCache.b());
    }
}

