/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.rss.client.WaterAccountPanel$1;
import hec.rss.client.WaterAccountPanel$2;
import hec.rss.client.WaterAccountPanel$3;
import hec.rss.client.WaterAccountPanel$4;
import hec.rss.client.WaterAccountPanel$5;
import hec.rss.client.WaterAccountPanel$6;
import hec.rss.client.WaterAccountPanel$7;
import hec.rss.client.WaterAccountSetEditor;
import hec.rss.client.WaterAccountSetRootNode;
import hec.rss.client.WaterAccountTableModel;
import hec.rss.client.WaterAccountTree;
import hec.rss.model.OpSet;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssSystem;
import hec.rss.model.SystemHydropowerRule;
import hec.rss.model.WaterAccount;
import hec.rss.model.WaterAccountSet;
import hec.rss.model.YieldAnalysisRuleRef;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import rma.swing.DefaultJPanel;
import rma.swing.EnabledJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJLabel;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.swing.table.RmaTableModelInterface;

public class WaterAccountPanel
extends DefaultJPanel
implements TreeSelectionListener {
    public WaterAccountTree _tree;
    private JSplitPane _splitter;
    private EnabledJPanel _rightPanel;
    private RmaJTextField _nameField;
    private RmaJTextField _descField;
    private RmaJRadioButton _percentConRadio;
    private RmaJDecimalField _percentConField;
    private RmaJRadioButton _specifyTotalRadio;
    private RmaJLabel _maxStorlabel;
    private RmaJDecimalField _maxStorageField;
    private RmaJTable _ruleTable;
    public WaterAccountTableModel _waTableModel;
    private JButton _selectButton;
    private JButton _deselectButton;
    private RmaJTextField _selectedValueTxt;
    private WaterAccountSetRootNode _root;
    private WaterAccountSet _currentWaterSet;
    private WaterAccount _currentWaterAccount;
    private WaterAccountSetEditor _editor;
    private RssSystem _system;

    public WaterAccountPanel(WaterAccountSetEditor waterAccountSetEditor, RssSystem rssSystem) {
        super((LayoutManager)new GridBagLayout());
        this._editor = waterAccountSetEditor;
        this._system = rssSystem;
        this.buildPanel();
    }

    public WaterAccount getCurrentWaterAccount() {
        return this._currentWaterAccount;
    }

    private void buildPanel() {
        this._splitter = new JSplitPane(1);
        Serializable serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 1.0;
        WaterAccountPanel waterAccountPanel = this;
        waterAccountPanel.add(waterAccountPanel._splitter, serializable);
        Object object = new EnabledJPanel((LayoutManager)new GridBagLayout());
        this._tree = new WaterAccountTree(this._editor);
        this._tree.setRootVisible(false);
        this._tree.getSelectionModel().setSelectionMode(1);
        ((JComponent)object).setMinimumSize(new Dimension(150, 50));
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 1.0;
        ((Container)object).add((Component)new JScrollPane(this._tree), serializable);
        this._splitter.setLeftComponent((Component)object);
        this._tree.addTreeSelectionListener(this);
        this._rightPanel = new EnabledJPanel((LayoutManager)new GridBagLayout());
        object = new JPanel(new GridBagLayout());
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        this._rightPanel.add((Component)object, (Object)serializable);
        JLabel jLabel = new JLabel("Account:");
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 0;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        ((Container)object).add((Component)jLabel, serializable);
        this._nameField = new WaterAccountPanel$1(this);
        this._nameField.setEditable(false);
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((Container)object).add((Component)this._nameField, serializable);
        jLabel = new JLabel("Description:");
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 0;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        ((Container)object).add((Component)jLabel, serializable);
        this._descField = new RmaJTextField();
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 3;
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((Container)object).add((Component)this._descField, serializable);
        this._waTableModel = new WaterAccountTableModel();
        this._ruleTable = new RmaJTable((RmaTableModelInterface)this._waTableModel);
        this._ruleTable.setIsEditable(false);
        this._ruleTable.setAddRemoveEnabled(false);
        this._ruleTable.setSelectionMode(0);
        this._ruleTable.setColumnSelectionAllowed(false);
        this._ruleTable.setCellSelectionEnabled(false);
        this._ruleTable.setRowSelectionAllowed(true);
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)serializable).gridy = 1;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 1.0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this._rightPanel.add((Component)this._ruleTable.getScrollPane(), (Object)serializable);
        this._ruleTable.getSelectionModel().addListSelectionListener(new WaterAccountPanel$2(this));
        object = new JPanel(new GridBagLayout());
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)serializable).gridy = 2;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        this._rightPanel.add((Component)object, (Object)serializable);
        this._deselectButton = new JButton("Deselect");
        this._deselectButton.setMnemonic('D');
        this._deselectButton.setEnabled(false);
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).anchor = 13;
        ((GridBagConstraints)serializable).fill = 0;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        ((Container)object).add((Component)this._deselectButton, serializable);
        this._deselectButton.addActionListener(new WaterAccountPanel$3(this));
        this._selectButton = new JButton("Select");
        this._selectButton.setMnemonic('S');
        this._selectButton.setEnabled(false);
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).anchor = 13;
        ((GridBagConstraints)serializable).fill = 0;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        ((Container)object).add((Component)this._selectButton, serializable);
        this._selectButton.addActionListener(new WaterAccountPanel$4(this));
        object = new JPanel(new GridBagLayout());
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)serializable).gridy = 3;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)0);
        this._rightPanel.add((Component)object, (Object)serializable);
        jLabel = new JLabel("Selected Rule:");
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 0;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        ((Container)object).add((Component)jLabel, serializable);
        this._selectedValueTxt = new WaterAccountPanel$5(this);
        this._selectedValueTxt.setEditable(false);
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        ((Container)object).add((Component)this._selectedValueTxt, serializable);
        object = new JPanel(new GridBagLayout());
        ((JComponent)object).setBorder(new TitledBorder("Determine Storage By"));
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)serializable).gridy = 4;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        this._rightPanel.add((Component)object, (Object)serializable);
        this._percentConRadio = new RmaJRadioButton("Percent of Conservation Storage");
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 0;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        ((Container)object).add((Component)this._percentConRadio, serializable);
        this._percentConRadio.setSelected(true);
        jLabel = new JLabel("% of Conservation:");
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 0;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        ((Container)object).add((Component)jLabel, serializable);
        this._percentConField = new RmaJDecimalField();
        this._percentConField.setMaxValue(100.0);
        this._percentConField.setMinValue(0.0);
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        ((Container)object).add((Component)this._percentConField, serializable);
        this._specifyTotalRadio = new RmaJRadioButton("Specify Total Storage");
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)serializable).gridy = 1;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 0;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        ((Container)object).add((Component)this._specifyTotalRadio, serializable);
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add((AbstractButton)this._specifyTotalRadio);
        ((ButtonGroup)serializable).add((AbstractButton)this._percentConRadio);
        this._specifyTotalRadio.addItemListener((ItemListener)new WaterAccountPanel$6(this));
        this._percentConRadio.addItemListener((ItemListener)new WaterAccountPanel$7(this));
        this._maxStorlabel = new RmaJLabel("Maximum Storage (%S):");
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        ((GridBagConstraints)serializable).gridy = 1;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 0;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        ((Container)object).add((Component)this._maxStorlabel, serializable);
        this._maxStorageField = new RmaJDecimalField();
        this._maxStorlabel.setLabelFor((Component)this._maxStorageField);
        this._maxStorageField.setEnabled(false);
        this._maxStorageField.setDisplayUnitsSystem(ClientApp.app().getClientUnitSystem());
        this._maxStorageField.setValue(new ParamDouble(0.0, Parameter.PARAMID_STOR, this._system.getUnitSystem()));
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        ((GridBagConstraints)serializable).gridy = 1;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 1.0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        ((Container)object).add((Component)this._maxStorageField, serializable);
        this._splitter.setRightComponent((Component)this._rightPanel);
        this._root = new WaterAccountSetRootNode(null);
        ((DefaultTreeModel)this._tree.getModel()).setRoot(this._root);
        ((DefaultTreeModel)this._tree.getModel()).nodeStructureChanged(this._root);
    }

    protected void updateSelectButtonStateAction() {
        int n = this._ruleTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        if (this._currentWaterAccount == null && this._currentWaterSet != null && this.isShowing()) {
            this._selectButton.setEnabled(false);
            JOptionPane.showMessageDialog((Component)((Object)this._editor), "Please create a Water Account.", "No Water Account Available", 1);
            return;
        }
        this._selectButton.setEnabled(n >= 0);
    }

    protected void updateDeselectButtonStateAction() {
        if (this._waTableModel.getActiveRule() != null) {
            this._deselectButton.setEnabled(true);
            return;
        }
        this._deselectButton.setEnabled(false);
    }

    public String getTabname() {
        return "Water Accounts";
    }

    private void radioAction() {
        if (this._percentConRadio.isSelected()) {
            this._percentConField.setEnabled(true);
            this._maxStorageField.setEnabled(false);
            return;
        }
        this._percentConField.setEnabled(false);
        this._maxStorageField.setEnabled(true);
    }

    protected void selectLocationAction() {
        YieldAnalysisRuleRef yieldAnalysisRuleRef;
        int n = this._ruleTable.getSelectedRow();
        if (n >= 0 && this._ruleTable.isCellEditable(n, 0) && (yieldAnalysisRuleRef = (YieldAnalysisRuleRef)this._waTableModel.getValueAt(n, 0)) != null) {
            if (yieldAnalysisRuleRef.getRule() instanceof SystemHydropowerRule) {
                JOptionPane.showMessageDialog((Component)((Object)this), "System Hydropower rules cannot be used in a Water Account at this time.  Please select another rule type.", "Unsupported Rule", 0);
                return;
            }
            boolean bl = this.checkSelectedRuleInUse(yieldAnalysisRuleRef);
            if (bl) {
                JOptionPane.showMessageDialog((Component)((Object)this), yieldAnalysisRuleRef.getRuleName() + " is already associated with another Water Account in this set.  Please select another rule.", "Duplicate Rule", 0);
                return;
            }
            this._selectedValueTxt.setText(yieldAnalysisRuleRef.getRuleName());
            this._waTableModel.activateRuleRow(yieldAnalysisRuleRef);
            this.updateDeselectButtonStateAction();
            this.setModified(true);
        }
    }

    private boolean checkSelectedRuleInUse(YieldAnalysisRuleRef yieldAnalysisRuleRef) {
        boolean bl = false;
        this._currentWaterSet = this._editor._currentWaterSet;
        if (this._currentWaterSet == null) {
            return false;
        }
        Object object = this._currentWaterSet.getWaterAccounts();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (WaterAccount)object.next();
            if (object2.equals(this._currentWaterAccount)) continue;
            object2 = ((WaterAccount)object2).getRuleRefs();
            object2 = object2.iterator();
            while (object2.hasNext()) {
                YieldAnalysisRuleRef yieldAnalysisRuleRef2 = object2.next();
                if (!yieldAnalysisRuleRef2.getRule().equals(yieldAnalysisRuleRef.getRule())) continue;
                bl = true;
            }
        }
        return bl;
    }

    protected void deselectLocationAction() {
        this._selectedValueTxt.setText("");
        this._waTableModel.activateRuleRow(null);
        this.setModified(true);
    }

    public void clearTable() {
        this._waTableModel.clearAll();
    }

    public void updateZoneRulesTable(ReservoirElement reservoirElement, OpSet opSet) {
        this._waTableModel.updateZoneRules(reservoirElement, opSet, this._currentWaterAccount);
    }

    public void removeZoneRulesTable(ReservoirElement reservoirElement, OpSet opSet) {
        if (this._waTableModel.removeZoneRulesTable(reservoirElement, opSet, this._currentWaterAccount)) {
            this._selectedValueTxt.setText("");
        }
    }

    public boolean saveWaterAccount() {
        if (this._currentWaterAccount == null) {
            return false;
        }
        this._currentWaterAccount.setDescription(this._descField.getText());
        ArrayList<YieldAnalysisRuleRef> arrayList = new ArrayList<YieldAnalysisRuleRef>();
        if (this._waTableModel.getActiveRule() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "A Rule must be selected for the Water Account.", "Select Rule", 2);
            return false;
        }
        arrayList.add(this._waTableModel.getActiveRule());
        this._currentWaterAccount.setRuleRefs(arrayList);
        this._currentWaterAccount.setUsePercentOfCon(this._percentConRadio.isSelected());
        this._currentWaterAccount.setPercentOfCon(this._percentConField.getValue());
        this._currentWaterAccount.setMaxStorage(this._maxStorageField.getValue());
        return true;
    }

    public void clearPanel() {
        this._currentWaterAccount = null;
        this._nameField.setText("");
        this._descField.setText("");
        this._percentConRadio.setSelected(true);
        this._percentConField.setValue(0);
        this._rightPanel.setEnabled(false);
        this._percentConRadio.setEnabled(false);
        this._specifyTotalRadio.setEnabled(false);
        this._selectedValueTxt.setText("");
        this._maxStorageField.setValue(new ParamDouble(0.0, Parameter.PARAMID_STOR, this._system.getUnitSystem()));
        this._waTableModel.clearAll();
    }

    public void fillWaterSetPanel(WaterAccountSet waterAccountSet) {
        this._root = new WaterAccountSetRootNode(waterAccountSet);
        ((DefaultTreeModel)this._tree.getModel()).setRoot(this._root);
        ((DefaultTreeModel)this._tree.getModel()).nodeStructureChanged(this._root);
        if (waterAccountSet != null && waterAccountSet.getWaterAccounts().size() > 0) {
            this._tree.setSelectionRow(0);
        }
    }

    public void setDescription(String string) {
        this._descField.setText(string);
    }

    public void fillPanel(WaterAccount object) {
        this._currentWaterAccount = object;
        if (this._currentWaterAccount == null) {
            this.clearPanel();
            this._maxStorageField.setValue(new ParamDouble(0.0, Parameter.PARAMID_STOR, this._system.getUnitSystem()));
            this.radioAction();
            return;
        }
        this._rightPanel.setEnabled(true);
        this._percentConRadio.setEnabled(true);
        this._specifyTotalRadio.setEnabled(true);
        this._nameField.setText(this._currentWaterAccount.getName());
        this._descField.setText(this._currentWaterAccount.getDescription());
        if (this._currentWaterAccount.usePercentOfCon()) {
            this._percentConRadio.setSelected(true);
            this._percentConField.setEditable(true);
            this._maxStorageField.setEnabled(false);
        } else {
            this._specifyTotalRadio.setSelected(true);
            this._percentConField.setEditable(false);
            this._maxStorageField.setEnabled(true);
        }
        this._percentConField.setValue(this._currentWaterAccount.getPercentOfCon());
        this._maxStorageField.setValue(new ParamDouble(this._currentWaterAccount.getMaxStorage(), Parameter.PARAMID_STOR, this._system.getUnitSystem()));
        object = this._currentWaterAccount.getRuleRefs();
        this._waTableModel.setWaterAccount(this._currentWaterAccount);
        if (object != null && object.size() > 0 && object.get(0) != null) {
            YieldAnalysisRuleRef yieldAnalysisRuleRef = (YieldAnalysisRuleRef)object.get(0);
            this._waTableModel.activateRuleRow(yieldAnalysisRuleRef);
            this._selectedValueTxt.setText(((YieldAnalysisRuleRef)object.get(0)).getRuleName());
        } else {
            this._waTableModel.activateRuleRow(null);
            this._selectedValueTxt.setText("");
        }
        this.updateDeselectButtonStateAction();
    }

    @Override
    public void valueChanged(TreeSelectionEvent object) {
        if (((TreeSelectionEvent)object).getNewLeadSelectionPath() == null) {
            return;
        }
        object = ((TreeSelectionEvent)object).getNewLeadSelectionPath();
        if ((object = (DefaultMutableTreeNode)((TreePath)object).getLastPathComponent()) != null && ((DefaultMutableTreeNode)object).getLevel() == 1) {
            object = (WaterAccount)((DefaultMutableTreeNode)object).getUserObject();
            if (this._currentWaterAccount != null) {
                this.saveWaterAccount();
            }
            this._currentWaterAccount = object;
            WaterAccountPanel waterAccountPanel = this;
            waterAccountPanel.fillPanel(waterAccountPanel._currentWaterAccount);
        }
    }
}

