/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.model.TSDataSet;
import hec.gfx2d.G2dDialog;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dObject;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.PlotLayout;
import hec.gfx2d.TimeSeriesDataSet;
import hec.gfx2d.Viewport;
import hec.gfx2d.ViewportLayout;
import hec.io.TimeSeriesContainer;
import hec.rss.client.WaterAccountCheckboxPanel;
import hec.rss.client.WaterAccountCurveActualStorage;
import hec.rss.client.WaterAccountCurveBase;
import hec.rss.client.WaterAccountCurveCheckbox;
import hec.rss.client.WaterAccountCurveDemand;
import hec.rss.client.WaterAccountCurveGuideCurve;
import hec.rss.client.WaterAccountCurveInflow;
import hec.rss.client.WaterAccountCurvePoolActualStorage;
import hec.rss.client.WaterAccountCurvePoolInflow;
import hec.rss.client.WaterAccountCurvePoolOutflow;
import hec.rss.client.WaterAccountCurveRuleDemand;
import hec.rss.client.WaterAccountMultipleCurveCheckbox;
import hec.rss.client.WaterAccountPlotCache;
import hec.rss.client.WaterAccountPlotRowItem;
import hec.rss.model.RssRun;
import hec.rss.model.StorageZoneRef;
import hec.rss.model.WaterAccount;
import hec.rss.model.WaterAccountCurveDataReader;
import hec.rss.model.WaterAccountSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JOptionPane;
import rma.services.ServiceLookup;
import rma.swing.CollapsableJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJLabel;
import rma.swing.RmaJPanel;

abstract class WaterAccountPlotBase
extends G2dDialog
implements WaterAccountCheckboxPanel {
    private final Map<WaterAccountPlotRowItem, WaterAccountPlotCache> _waterAccountCache = new HashMap<WaterAccountPlotRowItem, WaterAccountPlotCache>();
    WaterAccountMultipleCurveCheckbox _topOfGuideCurveCheckbox = new WaterAccountMultipleCurveCheckbox(null, "Top of Guide Curve", true);
    WaterAccountMultipleCurveCheckbox _poolActualStorageCheckbox = new WaterAccountMultipleCurveCheckbox(null, "Pool Actual Storage", true);
    WaterAccountCurveCheckbox _wAActualStorageCheckbox = new WaterAccountCurveCheckbox(null, "Water Account Actual Storage", true);
    WaterAccountMultipleCurveCheckbox _poolFlowInCheckbox = new WaterAccountMultipleCurveCheckbox(null, "Pool Inflow", true);
    WaterAccountMultipleCurveCheckbox _poolFlowOutCheckbox = new WaterAccountMultipleCurveCheckbox(null, "Pool Outflow", true);
    WaterAccountCurveCheckbox _wAFlowInCheckbox = new WaterAccountCurveCheckbox(null, "Water Account Inflow", true);
    WaterAccountCurveCheckbox _ruleDemandCheckbox = new WaterAccountCurveCheckbox(null, "Flow Rule Demand", true);
    WaterAccountCurveCheckbox _demandCheckbox = new WaterAccountCurveCheckbox(null, "Flow Demand", true);
    List<String> _failedToFindDataCurves = new ArrayList<String>();
    private RssRun _rssRun;
    private WaterAccountSet _waterAccountSet;
    private PlotLayout _plotLayout = new PlotLayout();
    private RmaJComboBox<WaterAccountPlotRowItem> _waterAccountCombo;
    List<Integer> _activeReservoirs;
    WaterAccountCurveDataReader _dataReader;
    private JCheckBoxMenuItem mRefreshMenuItem;

    WaterAccountPlotBase() {
    }

    public void fillDialog(RssRun rssRun) {
        this._waterAccountCache.clear();
        this._rssRun = rssRun;
        this._waterAccountSet = rssRun.getAlternative().getWaterAccountSet();
        this.loadActiveReservoirs();
        this._dataReader = new WaterAccountCurveDataReader(this._rssRun);
        this.initOutputTimeSeriesData();
        this.loadTheWACombobox();
    }

    public void makeMenus() {
        super.makeMenus();
        this._viewMenu.addSeparator();
        this.mRefreshMenuItem = new JCheckBoxMenuItem("Live Display...");
        this._viewMenu.add(this.mRefreshMenuItem);
    }

    private void loadActiveReservoirs() {
        this._activeReservoirs = new ArrayList<Integer>();
        List<StorageZoneRef> list = this._waterAccountSet.getResZoneRefs();
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).isActive()) continue;
            this._activeReservoirs.add(i);
        }
    }

    void buildControls() {
        WaterAccountPlotBase waterAccountPlotBase = this;
        waterAccountPlotBase.add((Component)waterAccountPlotBase.createTopPanel(), "North");
    }

    private RmaJPanel createTopPanel() {
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        rmaJPanel.add((Component)this.createWaterAccountPanel(), (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        rmaJPanel.add((Component)this.createCheckboxPanel(), (Object)gridBagConstraints);
        gridBagConstraints = new RmaJPanel((LayoutManager)new BorderLayout());
        gridBagConstraints.add((Component)rmaJPanel, "North");
        return gridBagConstraints;
    }

    private RmaJPanel createWaterAccountPanel() {
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)10, (int)5, (int)5);
        rmaJPanel.add((Component)new RmaJLabel("Water Account:"), (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        this._waterAccountCombo = new RmaJComboBox();
        rmaJPanel.add(this._waterAccountCombo, (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        rmaJPanel.add((Component)new RmaJPanel((LayoutManager)new GridBagLayout()), (Object)gridBagConstraints);
        return rmaJPanel;
    }

    abstract CollapsableJPanel createCheckboxPanel();

    void addCheckbox(RmaJPanel rmaJPanel, RmaJCheckBox rmaJCheckBox, int n) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = n;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)5);
        rmaJPanel.add((Component)rmaJCheckBox, (Object)gridBagConstraints);
    }

    void waterAccountChanged() {
        this.getPlotpanel().clearPanel();
        WaterAccountPlotRowItem waterAccountPlotRowItem = this.getSelectedWaterAccount();
        if (this._waterAccountCache.containsKey(waterAccountPlotRowItem)) {
            WaterAccountPlotBase waterAccountPlotBase = this;
            waterAccountPlotBase.loadCachedData(waterAccountPlotBase._waterAccountCache.get(waterAccountPlotRowItem));
        } else {
            this.loadTimeSeriesDataFromDSS();
        }
        this.plotNewWaterAccount();
    }

    private void storeLineProperties() {
        HashMap<G2dObject, G2dLineProperties> hashMap = new HashMap<G2dObject, G2dLineProperties>();
        Viewport[] viewportArray = this.getPlotpanel();
        if (viewportArray != null && (viewportArray = viewportArray.getViewports()) != null && viewportArray.length > 0) {
            for (Viewport viewport : viewportArray) {
                Vector vector = viewport.getGlyphVector();
                if (vector.isEmpty()) continue;
                for (Object object : vector) {
                    G2dLineProperties g2dLineProperties = ((G2dGlyph)object).getLine().getProperties();
                    object = ((G2dGlyph)object).getG2dObject();
                    hashMap.put((G2dObject)object, g2dLineProperties);
                }
            }
        }
        this.setLineProperties(hashMap);
    }

    private void setLineProperties(Map<G2dObject, G2dLineProperties> map) {
        block0: for (WaterAccountCurveBase waterAccountCurveBase : this.getAllCurves()) {
            G2dLineProperties g2dLineProperties = map.entrySet().iterator();
            while (g2dLineProperties.hasNext()) {
                Map.Entry<G2dObject, G2dLineProperties> entry = g2dLineProperties.next();
                G2dObject g2dObject = entry.getKey();
                if (!waterAccountCurveBase.c().equals((Object)g2dObject)) continue;
                v0.a = g2dLineProperties = entry.getValue();
                continue block0;
            }
        }
    }

    void plotNewWaterAccount() {
        this._failedToFindDataCurves.clear();
        this.storeLineProperties();
        this.checkboxSelectionChanged();
    }

    private void displayCurvesNotFoundDialog() {
        if (!this._failedToFindDataCurves.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder("No data found for:\n");
            for (String string : this._failedToFindDataCurves) {
                stringBuilder.append(string).append("\n");
            }
            JOptionPane.showMessageDialog((Component)((Object)this), stringBuilder.toString(), "No Data", 0);
        }
    }

    private List<WaterAccountCurveBase> getSelectedFlowsCurves() {
        ArrayList<WaterAccountCurveBase> arrayList = new ArrayList<WaterAccountCurveBase>();
        if (this._poolFlowInCheckbox.isSelected()) {
            this.addCurveToListIfValid(arrayList, this._poolFlowInCheckbox);
        }
        if (this._poolFlowOutCheckbox.isSelected()) {
            this.addCurveToListIfValid(arrayList, this._poolFlowOutCheckbox);
        }
        if (this._wAFlowInCheckbox.isSelected()) {
            this.addCurveToListIfValid(arrayList, this._wAFlowInCheckbox);
        }
        if (this._ruleDemandCheckbox.isSelected()) {
            this.addCurveToListIfValid(arrayList, this._ruleDemandCheckbox);
        }
        if (this._demandCheckbox.isSelected()) {
            this.addCurveToListIfValid(arrayList, this._demandCheckbox);
        }
        arrayList.addAll(this.addAdditionalFLowCurves());
        return arrayList;
    }

    private List<WaterAccountCurveBase> getAllFlowsCurves() {
        ArrayList<WaterAccountCurveBase> arrayList = new ArrayList<WaterAccountCurveBase>();
        this.addCurveToListIfValid(arrayList, this._poolFlowInCheckbox);
        this.addCurveToListIfValid(arrayList, this._poolFlowOutCheckbox);
        this.addCurveToListIfValid(arrayList, this._wAFlowInCheckbox);
        this.addCurveToListIfValid(arrayList, this._ruleDemandCheckbox);
        this.addCurveToListIfValid(arrayList, this._demandCheckbox);
        arrayList.addAll(this.addAdditionalFLowCurves());
        return arrayList;
    }

    List<WaterAccountCurveBase> addAdditionalFLowCurves() {
        return new ArrayList<WaterAccountCurveBase>();
    }

    private List<WaterAccountCurveBase> getSelectedStorageCurves() {
        ArrayList<WaterAccountCurveBase> arrayList = new ArrayList<WaterAccountCurveBase>();
        if (this._topOfGuideCurveCheckbox.isSelected()) {
            this.addCurveToListIfValid(arrayList, this._topOfGuideCurveCheckbox);
        }
        if (this._poolActualStorageCheckbox.isSelected()) {
            this.addCurveToListIfValid(arrayList, this._poolActualStorageCheckbox);
        }
        if (this._wAActualStorageCheckbox.isSelected()) {
            this.addCurveToListIfValid(arrayList, this._wAActualStorageCheckbox);
        }
        arrayList.addAll(this.addAdditionalStorageCurves());
        return arrayList;
    }

    private List<WaterAccountCurveBase> getAllStorageCurves() {
        ArrayList<WaterAccountCurveBase> arrayList = new ArrayList<WaterAccountCurveBase>();
        this.addCurveToListIfValid(arrayList, this._topOfGuideCurveCheckbox);
        this.addCurveToListIfValid(arrayList, this._poolActualStorageCheckbox);
        this.addCurveToListIfValid(arrayList, this._wAActualStorageCheckbox);
        arrayList.addAll(this.addAdditionalStorageCurves());
        return arrayList;
    }

    List<WaterAccountCurveBase> addAdditionalStorageCurves() {
        return new ArrayList<WaterAccountCurveBase>();
    }

    private void loadCachedData(WaterAccountPlotCache waterAccountPlotCache) {
        this._topOfGuideCurveCheckbox.setCurves(waterAccountPlotCache.c());
        this._poolActualStorageCheckbox.setCurves(waterAccountPlotCache.d());
        this._poolFlowInCheckbox.setCurves(waterAccountPlotCache.e());
        this._poolFlowOutCheckbox.setCurves(waterAccountPlotCache.f());
        this._wAActualStorageCheckbox.setCurve(waterAccountPlotCache.g());
        this._wAFlowInCheckbox.setCurve(waterAccountPlotCache.h());
        this._ruleDemandCheckbox.setCurve(waterAccountPlotCache.i());
        this._demandCheckbox.setCurve(waterAccountPlotCache.j());
        this.loadAdditionalCachedData(waterAccountPlotCache);
    }

    void loadAdditionalCachedData(WaterAccountPlotCache waterAccountPlotCache) {
    }

    private void loadTimeSeriesDataFromDSS() {
        WaterAccountCurveBase waterAccountCurveBase;
        WaterAccountCurveBase waterAccountCurveBase2;
        WaterAccountPlotCache waterAccountPlotCache = new WaterAccountPlotCache();
        WaterAccountPlotRowItem waterAccountPlotRowItem = this.getSelectedWaterAccount();
        Object object = new ArrayList();
        ArrayList<WaterAccountCurveBase> arrayList = new ArrayList<WaterAccountCurveBase>();
        ArrayList<WaterAccountCurveBase> arrayList2 = new ArrayList<WaterAccountCurveBase>();
        ArrayList<WaterAccountCurveBase> arrayList3 = new ArrayList<WaterAccountCurveBase>();
        if (waterAccountPlotRowItem.b()) {
            int n = waterAccountPlotRowItem.a();
            WaterAccountPlotBase waterAccountPlotBase = this;
            waterAccountCurveBase2 = new WaterAccountCurveGuideCurve(waterAccountPlotBase, waterAccountPlotBase._dataReader.b(n));
            object.add((WaterAccountCurveBase)waterAccountCurveBase2);
            WaterAccountPlotBase waterAccountPlotBase2 = this;
            waterAccountCurveBase = new WaterAccountCurvePoolActualStorage(waterAccountPlotBase2, waterAccountPlotBase2._dataReader.c(n));
            arrayList.add(waterAccountCurveBase);
            WaterAccountPlotBase waterAccountPlotBase3 = this;
            waterAccountCurveBase = new WaterAccountCurvePoolInflow(waterAccountPlotBase3, waterAccountPlotBase3._dataReader.a(n, 12));
            arrayList2.add(waterAccountCurveBase);
            WaterAccountPlotBase waterAccountPlotBase4 = this;
            waterAccountCurveBase = new WaterAccountCurvePoolOutflow(waterAccountPlotBase4, waterAccountPlotBase4._dataReader.a(n, 21));
            arrayList3.add(waterAccountCurveBase);
        } else {
            for (int n : this._activeReservoirs) {
                WaterAccountPlotBase waterAccountPlotBase = this;
                waterAccountCurveBase = new WaterAccountCurveGuideCurve(waterAccountPlotBase, waterAccountPlotBase._dataReader.b(n));
                object.add((WaterAccountCurveBase)waterAccountCurveBase);
                WaterAccountPlotBase waterAccountPlotBase5 = this;
                waterAccountCurveBase = new WaterAccountCurvePoolActualStorage(waterAccountPlotBase5, waterAccountPlotBase5._dataReader.c(n));
                arrayList.add(waterAccountCurveBase);
                WaterAccountPlotBase waterAccountPlotBase6 = this;
                waterAccountCurveBase = new WaterAccountCurvePoolInflow(waterAccountPlotBase6, waterAccountPlotBase6._dataReader.a(n, 12));
                arrayList2.add(waterAccountCurveBase);
                WaterAccountPlotBase waterAccountPlotBase7 = this;
                waterAccountCurveBase2 = new WaterAccountCurvePoolOutflow(waterAccountPlotBase7, waterAccountPlotBase7._dataReader.a(n, 21));
                arrayList3.add(waterAccountCurveBase2);
            }
        }
        this._topOfGuideCurveCheckbox.setCurves((List<WaterAccountCurveBase>)object);
        waterAccountPlotCache.a((List<WaterAccountCurveBase>)object);
        this._poolActualStorageCheckbox.setCurves(arrayList);
        waterAccountPlotCache.b(arrayList);
        this._poolFlowInCheckbox.setCurves(arrayList2);
        waterAccountPlotCache.c(arrayList2);
        this._poolFlowOutCheckbox.setCurves(arrayList3);
        waterAccountPlotCache.d(arrayList3);
        TimeSeriesDataSet timeSeriesDataSet = this._dataReader.a(waterAccountPlotRowItem, 190);
        waterAccountCurveBase2 = new WaterAccountCurveActualStorage(this, timeSeriesDataSet);
        waterAccountPlotCache.a((WaterAccountCurveActualStorage)waterAccountCurveBase2);
        this._wAActualStorageCheckbox.setCurve(waterAccountCurveBase2);
        waterAccountCurveBase = this._dataReader.a(waterAccountPlotRowItem, 192);
        waterAccountCurveBase = new WaterAccountCurveInflow(this, (TimeSeriesDataSet)waterAccountCurveBase);
        waterAccountPlotCache.a((WaterAccountCurveInflow)waterAccountCurveBase);
        this._wAFlowInCheckbox.setCurve(waterAccountCurveBase);
        waterAccountCurveBase = this._dataReader.a(waterAccountPlotRowItem, 194);
        waterAccountCurveBase2 = new WaterAccountCurveRuleDemand(this, (TimeSeriesDataSet)waterAccountCurveBase);
        waterAccountPlotCache.a((WaterAccountCurveRuleDemand)waterAccountCurveBase2);
        this._ruleDemandCheckbox.setCurve(waterAccountCurveBase2);
        object = this._dataReader.a(waterAccountPlotRowItem, 193);
        object = new WaterAccountCurveDemand(this, (TimeSeriesDataSet)object);
        waterAccountPlotCache.a((WaterAccountCurveDemand)object);
        this._demandCheckbox.setCurve((WaterAccountCurveBase)object);
        this.loadAdditionalTimeSeriesDataFromDSS(waterAccountPlotCache);
        this._waterAccountCache.put(waterAccountPlotRowItem, waterAccountPlotCache);
    }

    void loadAdditionalTimeSeriesDataFromDSS(WaterAccountPlotCache waterAccountPlotCache) {
    }

    private void loadTheWACombobox() {
        Object object;
        for (WaterAccount object2 : this._waterAccountSet.getWaterAccounts()) {
            object = this._dataReader.a(object2.getName(), false);
            object = new WaterAccountPlotRowItem(object2.getName(), (String)object);
            this._waterAccountCombo.addItem(object);
        }
        Iterator<Object> iterator = this._activeReservoirs.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            object = this._dataReader.a(n);
            object = object.getName();
            String string = this._dataReader.a((String)object, true);
            WaterAccountPlotRowItem waterAccountPlotRowItem = new WaterAccountPlotRowItem((String)object + " - Default", string, true, n);
            this._waterAccountCombo.addItem((Object)waterAccountPlotRowItem);
        }
    }

    void addWAComboActionListener() {
        this._waterAccountCombo.addActionListener(actionEvent -> this.waterAccountChanged());
        this._waterAccountCombo.addItemListener(itemEvent -> {
            if (itemEvent.getStateChange() == 2) {
                this.storeLineProperties();
            }
        });
    }

    private void initOutputTimeSeriesData() {
        TSDataSet tSDataSet = this._rssRun.getRegOutputTSData();
        tSDataSet.initialize(this._rssRun.getRunTimeWindow());
        tSDataSet.loadTSRecords();
    }

    private void createViewport(List<WaterAccountCurveBase> object, String object2) {
        ViewportLayout viewportLayout = this._plotLayout.addViewport();
        viewportLayout.setAxisLabel("Y1", (String)object2);
        viewportLayout.setAxisLabel("X1", "");
        object = object.iterator();
        while (object.hasNext()) {
            object2 = (WaterAccountCurveBase)object.next();
            TimeSeriesDataSet timeSeriesDataSet = ((WaterAccountCurveBase)object2).c();
            TimeSeriesContainer timeSeriesContainer = timeSeriesDataSet.getData();
            if (timeSeriesContainer == null || timeSeriesContainer.getValues() == null || timeSeriesContainer.getTimes() == null) continue;
            viewportLayout.addCurve("Y1", (Object)timeSeriesDataSet, ((WaterAccountCurveBase)object2).e());
        }
    }

    WaterAccountPlotRowItem getSelectedWaterAccount() {
        return (WaterAccountPlotRowItem)this._waterAccountCombo.getSelectedItem();
    }

    void addCurveToListIfValid(List<WaterAccountCurveBase> list, WaterAccountCurveCheckbox waterAccountCurveCheckbox) {
        if (waterAccountCurveCheckbox.shouldCurveBePlotting()) {
            list.add(waterAccountCurveCheckbox.getCurve());
            return;
        }
        waterAccountCurveCheckbox.setSelected(false);
        this._failedToFindDataCurves.add(waterAccountCurveCheckbox.getText());
    }

    void addCurveToListIfValid(List<WaterAccountCurveBase> list, WaterAccountMultipleCurveCheckbox waterAccountMultipleCurveCheckbox) {
        if (waterAccountMultipleCurveCheckbox.areCurvesValid()) {
            list.addAll(waterAccountMultipleCurveCheckbox.getCurves());
            return;
        }
        waterAccountMultipleCurveCheckbox.setSelected(false);
        this._failedToFindDataCurves.add(waterAccountMultipleCurveCheckbox.getText());
    }

    private List<WaterAccountCurveBase> getAllCurves() {
        ArrayList<WaterAccountCurveBase> arrayList = new ArrayList<WaterAccountCurveBase>(this.getAllFlowsCurves());
        arrayList.addAll(this.getAllStorageCurves());
        return arrayList;
    }

    @Override
    public void checkboxSelectionChanged() {
        this.getPlotpanel().clearPanel();
        this._plotLayout = new PlotLayout();
        G2dPanel g2dPanel = this.getSelectedStorageCurves();
        if (!g2dPanel.isEmpty()) {
            this.createViewport((List<WaterAccountCurveBase>)g2dPanel, "Stor (%S)");
        }
        if (!(g2dPanel = this.getSelectedFlowsCurves()).isEmpty()) {
            this.createViewport((List<WaterAccountCurveBase>)g2dPanel, "Flow (%S)");
        }
        g2dPanel = this.getPlotpanel();
        g2dPanel.setVisible(false);
        g2dPanel.buildComponents(this._plotLayout);
        ServiceLookup.getUnitsDisplayService().updateUnitSystem((Container)((Object)this));
        g2dPanel.setVisible(true);
    }

    public void refreshData() {
        if (this.mRefreshMenuItem.isSelected()) {
            this._waterAccountCache.clear();
            this.waterAccountChanged();
        }
    }
}

