/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.gfx2d.TimeSeriesDataSet;
import hec.rss.client.WaterAccountCurveBase;
import hec.rss.client.WaterAccountCurveCheckbox;
import hec.rss.client.WaterAccountCurveFlowCharges;
import hec.rss.client.WaterAccountCurveFlowCredits;
import hec.rss.client.WaterAccountCurveFlowLosses;
import hec.rss.client.WaterAccountCurveFlowPumpback;
import hec.rss.client.WaterAccountCurveFlowSurplus;
import hec.rss.client.WaterAccountCurveFlowTransfers;
import hec.rss.client.WaterAccountCurveMaxStorage;
import hec.rss.client.WaterAccountPlotBase;
import hec.rss.client.WaterAccountPlotCache;
import hec.rss.model.RssRun;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import rma.swing.CollapsableJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJPanel;

class WaterAccountPlotDialog
extends WaterAccountPlotBase {
    private final WaterAccountCurveCheckbox _maxStorageCheckbox = new WaterAccountCurveCheckbox(null, "Water Account Max Storage", true);
    private final WaterAccountCurveCheckbox _flowLossesCheckbox = new WaterAccountCurveCheckbox(null, "Flow-Losses", false);
    private final WaterAccountCurveCheckbox _flowCreditsCheckbox = new WaterAccountCurveCheckbox(null, "Flow-Credits", false);
    private final WaterAccountCurveCheckbox _flowChargesCheckbox = new WaterAccountCurveCheckbox(null, "Flow-Charges", false);
    private final WaterAccountCurveCheckbox _flowPumpbackCheckbox = new WaterAccountCurveCheckbox(null, "Flow-Pumpback", false);
    private final WaterAccountCurveCheckbox _flowSurplusCheckbox = new WaterAccountCurveCheckbox(null, "Flow-Surplus", false);
    private final WaterAccountCurveCheckbox _flowTransfersCheckbox = new WaterAccountCurveCheckbox(null, "Flow-Transfers", false);

    WaterAccountPlotDialog() {
        this.setSize(1000, 800);
        this.setMinimumSize(new Dimension(1000, 600));
        this.buildControls();
    }

    @Override
    public void fillDialog(RssRun rssRun) {
        super.fillDialog(rssRun);
        this.addWAComboActionListener();
        this.waterAccountChanged();
    }

    @Override
    CollapsableJPanel createCheckboxPanel() {
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        this.addCheckbox(rmaJPanel, this._topOfGuideCurveCheckbox, 1);
        this.addCheckbox(rmaJPanel, this._poolActualStorageCheckbox, 1);
        this.addCheckbox(rmaJPanel, this._wAActualStorageCheckbox, 1);
        this.addCheckbox(rmaJPanel, this._maxStorageCheckbox, 0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)5);
        rmaJPanel.add((Component)new JSeparator(), (Object)gridBagConstraints);
        this.addCheckbox(rmaJPanel, this._poolFlowInCheckbox, 1);
        this.addCheckbox(rmaJPanel, this._poolFlowOutCheckbox, 1);
        this.addCheckbox(rmaJPanel, this._wAFlowInCheckbox, 1);
        this.addCheckbox(rmaJPanel, this._ruleDemandCheckbox, 0);
        this.addCheckbox(rmaJPanel, this._demandCheckbox, 1);
        this.addCheckbox(rmaJPanel, this._flowLossesCheckbox, 1);
        this.addCheckbox(rmaJPanel, this._flowCreditsCheckbox, 1);
        this.addCheckbox(rmaJPanel, this._flowChargesCheckbox, 0);
        this.addCheckbox(rmaJPanel, this._flowPumpbackCheckbox, 1);
        this.addCheckbox(rmaJPanel, this._flowSurplusCheckbox, 1);
        this.addCheckbox(rmaJPanel, this._flowTransfersCheckbox, 0);
        return new CollapsableJPanel("Available Curves:", (JPanel)rmaJPanel);
    }

    @Override
    void loadAdditionalTimeSeriesDataFromDSS(WaterAccountPlotCache waterAccountPlotCache) {
        Object object = this._dataReader.a(this.getSelectedWaterAccount(), 191);
        object = new WaterAccountCurveMaxStorage(this, (TimeSeriesDataSet)object);
        this._maxStorageCheckbox.setCurve((WaterAccountCurveBase)object);
        waterAccountPlotCache.a((WaterAccountCurveMaxStorage)object);
        object = this._dataReader.a(this.getSelectedWaterAccount(), 207);
        object = new WaterAccountCurveFlowLosses(this, (TimeSeriesDataSet)object);
        this._flowLossesCheckbox.setCurve((WaterAccountCurveBase)object);
        waterAccountPlotCache.a((WaterAccountCurveFlowLosses)object);
        object = this._dataReader.a(this.getSelectedWaterAccount(), 206);
        object = new WaterAccountCurveFlowCredits(this, (TimeSeriesDataSet)object);
        this._flowCreditsCheckbox.setCurve((WaterAccountCurveBase)object);
        waterAccountPlotCache.a((WaterAccountCurveFlowCredits)object);
        object = this._dataReader.a(this.getSelectedWaterAccount(), 205);
        object = new WaterAccountCurveFlowCharges(this, (TimeSeriesDataSet)object);
        this._flowChargesCheckbox.setCurve((WaterAccountCurveBase)object);
        waterAccountPlotCache.a((WaterAccountCurveFlowCharges)object);
        object = this._dataReader.a(this.getSelectedWaterAccount(), 208);
        object = new WaterAccountCurveFlowPumpback(this, (TimeSeriesDataSet)object);
        this._flowPumpbackCheckbox.setCurve((WaterAccountCurveBase)object);
        waterAccountPlotCache.a((WaterAccountCurveFlowPumpback)object);
        object = this._dataReader.a(this.getSelectedWaterAccount(), 203);
        object = new WaterAccountCurveFlowSurplus(this, (TimeSeriesDataSet)object);
        this._flowSurplusCheckbox.setCurve((WaterAccountCurveBase)object);
        waterAccountPlotCache.a((WaterAccountCurveFlowSurplus)object);
        object = this._dataReader.a(this.getSelectedWaterAccount(), 204);
        object = new WaterAccountCurveFlowTransfers(this, (TimeSeriesDataSet)object);
        this._flowTransfersCheckbox.setCurve((WaterAccountCurveBase)object);
        waterAccountPlotCache.a((WaterAccountCurveFlowTransfers)object);
    }

    @Override
    List<WaterAccountCurveBase> addAdditionalFLowCurves() {
        ArrayList<WaterAccountCurveBase> arrayList = new ArrayList<WaterAccountCurveBase>();
        if (this._flowLossesCheckbox.isSelected()) {
            this.addCurveToListIfValid(arrayList, this._flowLossesCheckbox);
        }
        if (this._flowCreditsCheckbox.isSelected()) {
            this.addCurveToListIfValid(arrayList, this._flowCreditsCheckbox);
        }
        if (this._flowChargesCheckbox.isSelected()) {
            this.addCurveToListIfValid(arrayList, this._flowChargesCheckbox);
        }
        if (this._flowPumpbackCheckbox.isSelected()) {
            this.addCurveToListIfValid(arrayList, this._flowPumpbackCheckbox);
        }
        if (this._flowSurplusCheckbox.isSelected()) {
            this.addCurveToListIfValid(arrayList, this._flowSurplusCheckbox);
        }
        if (this._flowTransfersCheckbox.isSelected()) {
            this.addCurveToListIfValid(arrayList, this._flowTransfersCheckbox);
        }
        return arrayList;
    }

    @Override
    List<WaterAccountCurveBase> addAdditionalStorageCurves() {
        ArrayList<WaterAccountCurveBase> arrayList = new ArrayList<WaterAccountCurveBase>();
        if (this._maxStorageCheckbox.isSelected()) {
            this.addCurveToListIfValid(arrayList, this._maxStorageCheckbox);
        }
        return arrayList;
    }

    @Override
    void loadAdditionalCachedData(WaterAccountPlotCache waterAccountPlotCache) {
        this._maxStorageCheckbox.setCurve(waterAccountPlotCache.k());
        this._flowLossesCheckbox.setCurve(waterAccountPlotCache.l());
        this._flowCreditsCheckbox.setCurve(waterAccountPlotCache.m());
        this._flowChargesCheckbox.setCurve(waterAccountPlotCache.n());
        this._flowPumpbackCheckbox.setCurve(waterAccountPlotCache.o());
        this._flowSurplusCheckbox.setCurve(waterAccountPlotCache.p());
        this._flowTransfersCheckbox.setCurve(waterAccountPlotCache.q());
    }
}

