/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.gui.NameDialog;
import hec.gui.RenameDlg;
import hec.gui.SelectorPanel;
import hec.rss.client.WaterAccountPanel;
import hec.rss.client.WaterAccountSetEditor$1;
import hec.rss.client.WaterAccountSetEditor$2;
import hec.rss.client.WaterAccountZonePanel;
import hec.rss.model.RssSystem;
import hec.rss.model.WaterAccount;
import hec.rss.model.WaterAccountSet;
import hec.rss.model.YieldAnalysisRuleRef;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.text.Document;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.event.ReflectMultiListener;
import rma.swing.text.DssPathnamePartDocument;
import rma.util.RMAIO;

public class WaterAccountSetEditor
extends RmaJDialog
implements ActionListener,
ItemListener,
ButtonCmdPanelListener {
    private ReflectMultiListener _listener;
    private JMenuItem _newSetMenuItem;
    private JMenuItem _renameSetMenuItem;
    private JMenuItem _deleteSetMenuItem;
    private JMenuItem _newAccountMenuItem;
    private JMenuItem _renameAccountMenuItem;
    private JMenuItem _deleteAccountMenuItem;
    protected SelectorPanel _selectorPanel;
    private RssSystem _system;
    public WaterAccountSet _currentWaterSet;
    private WaterAccount _currentWaterAccount;
    private WaterAccountZonePanel _zonePanel;
    protected WaterAccountPanel _waterAccountPanel;
    private List<WaterAccountSet> _sets = new ArrayList<WaterAccountSet>();
    protected JTabbedPane _tabPane;

    public WaterAccountSetEditor(Frame frame, boolean bl, RssSystem rssSystem) {
        super(frame, bl);
        this._system = rssSystem;
        this.initialize();
        this.setTitle("Water Account Set Editor");
        this.buildControls();
        this.buildMenus();
        this.setSize(640, 480);
        this.setDefaultSize(640, 480);
        this.setLocation();
        this.setDefaultCloseOperation(2);
    }

    private void initialize() {
        List<WaterAccountSet> list = this._system.getWaterAccountSetList();
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            Object object = list.get(i);
            if ((object = ((WaterAccountSet)object).getWaterAccounts()) == null) continue;
            for (int j = 0; j < object.size(); ++j) {
                Object object2 = (WaterAccount)object.get(j);
                if ((object2 = ((WaterAccount)object2).getRuleRefs()) == null) continue;
                for (int k = 0; k < object2.size(); ++k) {
                    YieldAnalysisRuleRef yieldAnalysisRuleRef = (YieldAnalysisRuleRef)object2.get(k);
                    if (yieldAnalysisRuleRef == null || yieldAnalysisRuleRef.isInitialized() && (yieldAnalysisRuleRef.getRule() != null || yieldAnalysisRuleRef.getRuleOwner() != null)) continue;
                    yieldAnalysisRuleRef.initializeData(this._system);
                }
            }
        }
    }

    private void buildControls() {
        WaterAccountSetEditor waterAccountSetEditor = this;
        this._zonePanel = new WaterAccountZonePanel(waterAccountSetEditor, waterAccountSetEditor._system);
        WaterAccountSetEditor waterAccountSetEditor2 = this;
        this._waterAccountPanel = new WaterAccountPanel(waterAccountSetEditor2, waterAccountSetEditor2._system);
        this._listener = new ReflectMultiListener();
        this.setLayout(new GridBagLayout());
        this._selectorPanel = new SelectorPanel(1);
        this._selectorPanel.setNameLabel("Name:");
        this._selectorPanel.setNameLabelMnemonic('N');
        this._selectorPanel.setDescriptionLabel("Description:");
        this._selectorPanel.setDescriptionLabelMnemonic('D');
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        gridBagConstraints.weightx = 1.0;
        WaterAccountSetEditor waterAccountSetEditor3 = this;
        waterAccountSetEditor3.add((Component)waterAccountSetEditor3._selectorPanel, gridBagConstraints);
        this._selectorPanel.addItemListener((ItemListener)new WaterAccountSetEditor$1(this));
        this._tabPane = new WaterAccountSetEditor$2(this);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        WaterAccountSetEditor waterAccountSetEditor4 = this;
        waterAccountSetEditor4.add(waterAccountSetEditor4._tabPane, gridBagConstraints);
        this._tabPane.add(this._zonePanel.getTabname(), (Component)((Object)this._zonePanel));
        this._tabPane.add(this._waterAccountPanel.getTabname(), (Component)((Object)this._waterAccountPanel));
        ButtonCmdPanel buttonCmdPanel = new ButtonCmdPanel(14);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        this.add((Component)buttonCmdPanel, gridBagConstraints);
        buttonCmdPanel.addCmdPanelListener((ButtonCmdPanelListener)this);
    }

    public void fillWaterSet(WaterAccountSet waterAccountSet) {
        this._currentWaterSet = waterAccountSet;
        this._waterAccountPanel.clearPanel();
        this._zonePanel.fillPanel(this._currentWaterSet);
        this._waterAccountPanel.fillWaterSetPanel(this._currentWaterSet);
    }

    protected void buildMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Sets");
        jMenu.setMnemonic('A');
        jMenuBar.add(jMenu);
        this._newSetMenuItem = new JMenuItem("New", 78);
        this._newSetMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        WaterAccountSetEditor waterAccountSetEditor = this;
        this._newSetMenuItem.addActionListener((ActionListener)this._listener.add((Object)waterAccountSetEditor, (Object)waterAccountSetEditor._newSetMenuItem, "newWaterAccountSet"));
        jMenu.add(this._newSetMenuItem);
        this._renameSetMenuItem = new JMenuItem("Rename", 82);
        WaterAccountSetEditor waterAccountSetEditor2 = this;
        this._renameSetMenuItem.addActionListener((ActionListener)this._listener.add((Object)waterAccountSetEditor2, (Object)waterAccountSetEditor2._renameSetMenuItem, "renameWaterAccountSet"));
        jMenu.add(this._renameSetMenuItem);
        this._deleteSetMenuItem = new JMenuItem("Delete", 68);
        WaterAccountSetEditor waterAccountSetEditor3 = this;
        this._deleteSetMenuItem.addActionListener((ActionListener)this._listener.add((Object)waterAccountSetEditor3, (Object)waterAccountSetEditor3._deleteSetMenuItem, "deleteWaterAccountSet"));
        jMenu.add(this._deleteSetMenuItem);
        jMenu = new JMenu("Accounts");
        jMenu.setMnemonic('A');
        jMenuBar.add(jMenu);
        this._newAccountMenuItem = new JMenuItem("New", 78);
        this._newAccountMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        WaterAccountSetEditor waterAccountSetEditor4 = this;
        this._newAccountMenuItem.addActionListener((ActionListener)this._listener.add((Object)waterAccountSetEditor4, (Object)waterAccountSetEditor4._newAccountMenuItem, "newWaterAccount"));
        jMenu.add(this._newAccountMenuItem);
        this._renameAccountMenuItem = new JMenuItem("Rename", 82);
        WaterAccountSetEditor waterAccountSetEditor5 = this;
        this._renameAccountMenuItem.addActionListener((ActionListener)this._listener.add((Object)waterAccountSetEditor5, (Object)waterAccountSetEditor5._renameAccountMenuItem, "renameWaterAccount"));
        jMenu.add(this._renameAccountMenuItem);
        this._deleteAccountMenuItem = new JMenuItem("Delete", 68);
        WaterAccountSetEditor waterAccountSetEditor6 = this;
        this._deleteAccountMenuItem.addActionListener((ActionListener)this._listener.add((Object)waterAccountSetEditor6, (Object)waterAccountSetEditor6._deleteAccountMenuItem, "deleteWaterAccount"));
        jMenu.add(this._deleteAccountMenuItem);
        this.setJMenuBar(jMenuBar);
    }

    public void newWaterAccountSet() {
        Object object = new NameDialog((Dialog)((Object)this), "New Water Account Set", true);
        object.setNameFieldDocument((Document)new DssPathnamePartDocument());
        object.setVisible(true);
        if (object.isCanceled()) {
            return;
        }
        Object object2 = object.getName();
        object = object.getDescription();
        if (((String)object2).equals("")) {
            RMAIO.postError((Component)((Object)this), (String)"Cannot have blank name");
            return;
        }
        if (this._system.getWaterAccountSetList() != null && this._system.getWaterAccountSet((String)object2) != null) {
            RMAIO.postError((Component)((Object)this), (String)"Another Water Account Set already exists with that name.");
            this.newWaterAccountSet();
            return;
        }
        object2 = new WaterAccountSet((String)object2, (String)object, this._zonePanel._defaultZoneList, this._system.nextWaterAccountSetIndex());
        if (this._sets == null) {
            this._sets = new ArrayList<WaterAccountSet>();
        }
        this._selectorPanel.addSelectionItem(object2, true);
        this._selectorPanel.setDescription((String)object);
        this._sets.add(this._currentWaterSet);
        this.setModified(true);
    }

    public void renameWaterAccountSet() {
        if (this._currentWaterSet == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No Water Account Set available to rename", "Rename Water Account Set", 0);
            return;
        }
        if (this._system == null) {
            return;
        }
        RenameDlg renameDlg = new RenameDlg((Dialog)((Object)this), "Rename Water Account Set", true);
        renameDlg.setNameFieldDocument((Document)new DssPathnamePartDocument());
        renameDlg.removeFileComponents();
        renameDlg.setName(this._currentWaterSet.getName());
        renameDlg.setDescription(this._currentWaterSet.getDescription());
        renameDlg.setVisible(true);
        if (renameDlg.getCanceled()) {
            return;
        }
        this._system.renameWaterAccountSet(this._currentWaterSet.getName(), renameDlg.getName());
        this._selectorPanel.getComboBox().repaint();
        boolean bl = this._selectorPanel.getDescription().equals(renameDlg.getDescription());
        this._selectorPanel.setDescription(renameDlg.getDescription());
        this._currentWaterSet.setDescription(renameDlg.getDescription());
        this._currentWaterSet.setName(renameDlg.getName());
        this._waterAccountPanel.fillWaterSetPanel(this._currentWaterSet);
        if (bl) {
            this.setModified(bl);
        }
    }

    public void deleteWaterAccountSet() {
        if (this._currentWaterSet == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No Water Account Set available to delete", "Delete Water Account Set", 0);
            return;
        }
        WaterAccountSetEditor waterAccountSetEditor = this;
        int n = JOptionPane.showConfirmDialog((Component)((Object)waterAccountSetEditor), "Deleting a Water Account Set will also delete it from any Alternatives that reference it.  \nWould you still like to delete the Water Account Set - " + waterAccountSetEditor._currentWaterSet.getName() + "?", "Delete Water Account Set", 0);
        if (n == 0) {
            this._system.deleteWaterAccountSet(this._currentWaterSet);
            this._selectorPanel.removeSelectionItem((Object)this._currentWaterSet);
            this._selectorPanel.setDescription("");
        }
    }

    public void newWaterAccount() {
        if (this._currentWaterSet == null) {
            RMAIO.postError((Component)((Object)this), (String)"A Water Account Set must be created before a Water Account.");
            return;
        }
        if (this._zonePanel._activeReservoirs.size() <= 0) {
            RMAIO.postError((Component)((Object)this), (String)"At least one reservoir must be active before creating a Water Account.");
            return;
        }
        Object object = new NameDialog((Dialog)((Object)this), "New Water Account", true);
        object.setNameFieldDocument((Document)new DssPathnamePartDocument());
        object.setVisible(true);
        if (object.isCanceled()) {
            return;
        }
        String string = object.getName();
        object = object.getDescription();
        if (string.equals("")) {
            RMAIO.postError((Component)((Object)this), (String)"Cannot have blank name");
            return;
        }
        if (this._currentWaterSet.getWaterAccount(string) != null) {
            RMAIO.postError((Component)((Object)this), (String)"Another Water Account already exists with that name.");
            this.newWaterAccount();
            return;
        }
        object = this._currentWaterSet.createNewWaterAccount(string, (String)object, this._currentWaterSet.getIndex());
        this._currentWaterAccount = this._waterAccountPanel.getCurrentWaterAccount();
        if (this._currentWaterAccount != null) {
            this._waterAccountPanel.saveWaterAccount();
        }
        this._currentWaterAccount = object;
        this._waterAccountPanel.fillWaterSetPanel(this._currentWaterSet);
        this._waterAccountPanel._tree.setSelectionRow(this._waterAccountPanel._tree.getRowCount() - 1);
        if (!this.isEnabled()) {
            this.setEditable(true);
        }
        this.setModified(true);
    }

    protected boolean askToSave() {
        this._currentWaterAccount = this._waterAccountPanel.getCurrentWaterAccount();
        if (this.isModified() && this._currentWaterAccount != null) {
            WaterAccountSetEditor waterAccountSetEditor = this;
            int n = JOptionPane.showConfirmDialog((Component)((Object)waterAccountSetEditor), waterAccountSetEditor._currentWaterAccount.getName() + " has changed. Save Changes?", "Save", 1);
            if (n == 0) {
                return this._waterAccountPanel.saveWaterAccount();
            }
            return n == 1;
        }
        return true;
    }

    public void renameWaterAccount() {
        this._currentWaterAccount = this._waterAccountPanel.getCurrentWaterAccount();
        if (this._currentWaterSet == null) {
            return;
        }
        if (this._system == null) {
            return;
        }
        if (this._currentWaterAccount == null) {
            return;
        }
        RenameDlg renameDlg = new RenameDlg((Dialog)((Object)this), "Rename Water Account", true);
        renameDlg.setNameFieldDocument((Document)new DssPathnamePartDocument());
        renameDlg.removeFileComponents();
        renameDlg.setName(this._currentWaterAccount.getName());
        renameDlg.setDescription(this._currentWaterAccount.getDescription());
        renameDlg.setVisible(true);
        if (renameDlg.getCanceled()) {
            return;
        }
        this._currentWaterSet.renameWaterAccount(this._currentWaterAccount.getName(), renameDlg.getName());
        boolean bl = !this._currentWaterAccount.getDescription().equals(renameDlg.getDescription());
        this._currentWaterAccount.setDescription(renameDlg.getDescription());
        if (bl) {
            this.setModified(true);
        }
        this._waterAccountPanel.setDescription(renameDlg.getDescription());
        this._waterAccountPanel.fillWaterSetPanel(this._currentWaterSet);
    }

    public void deleteWaterAccount() {
        this._currentWaterAccount = this._waterAccountPanel.getCurrentWaterAccount();
        if (this._currentWaterAccount == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No Water Account Selected to delete", "Delete Water Account", 0);
            return;
        }
        WaterAccountSetEditor waterAccountSetEditor = this;
        int n = JOptionPane.showConfirmDialog((Component)((Object)waterAccountSetEditor), "Delete Water Account - " + waterAccountSetEditor._currentWaterAccount.getName(), "Delete Water Account", 0);
        if (n == 0) {
            this._currentWaterSet.deleteWaterAccount(this._currentWaterAccount);
            this._waterAccountPanel.fillWaterSetPanel(this._currentWaterSet);
        }
    }

    public void setSystem(RssSystem rssSystem) {
        this._system = rssSystem;
    }

    public void fillForm(List<WaterAccountSet> list, WaterAccountSet waterAccountSet) {
        this._sets = list;
        this._selectorPanel.setSelectionList(this._sets);
        if (waterAccountSet != null) {
            this._selectorPanel.setSelectedIndex(0);
        }
    }

    public boolean saveForm() {
        if (this._currentWaterSet == null) {
            return true;
        }
        this._currentWaterSet.setDescription(this._selectorPanel.getDescription());
        if (!this._zonePanel.savePanel() || !this._waterAccountPanel.saveWaterAccount()) {
            return false;
        }
        this._system.setWaterAccountSetList(this._sets);
        return true;
    }

    public void buttonCmdActionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getID() == 8) {
            this.cmdOK_Action();
            return;
        }
        if (actionEvent.getID() == 4) {
            this.cmdCancel_Action();
            return;
        }
        if (actionEvent.getID() == 2) {
            this.cmdApply_Action();
        }
    }

    private void cmdOK_Action() {
        if (!this.saveForm()) {
            return;
        }
        this.setVisible(false);
        this.dispose();
    }

    private void cmdCancel_Action() {
        this.setVisible(false);
        this.dispose();
    }

    private void cmdApply_Action() {
        if (!this.saveForm()) {
            return;
        }
        this.setModified(false);
    }

    public void valueChanged(TreeSelectionEvent object) {
        if (this._currentWaterSet == null) {
            return;
        }
        if (((TreeSelectionEvent)object).getNewLeadSelectionPath() == null) {
            return;
        }
        object = ((TreeSelectionEvent)object).getNewLeadSelectionPath();
        if ((object = (DefaultMutableTreeNode)((TreePath)object).getLastPathComponent()) != null && ((DefaultMutableTreeNode)object).getLevel() == 1) {
            this._currentWaterAccount = object = (WaterAccount)((DefaultMutableTreeNode)object).getUserObject();
            this._waterAccountPanel.fillPanel(this._currentWaterAccount);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }
}

