/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.rss.model.OpSet;
import hec.rss.model.ReservoirElement;
import hec.rss.model.WaterAccount;
import hec.rss.model.YieldAnalysisRuleRef;
import java.util.Vector;
import rma.swing.table.AbstractRmaTableModel;
import rma.swing.table.RmaTableModelInterface;

public class WaterAccountTableModel
extends AbstractRmaTableModel
implements RmaTableModelInterface {
    Vector<YieldAnalysisRuleRef> _rules = new Vector();
    WaterAccount _wa;
    int _selectedRule = -1;

    public WaterAccountTableModel() {
        this.m_columnNames = new String[]{"Location", "Rule", "Rule Type"};
    }

    public Object getValueAt(int n, int n2) {
        if (this._wa == null) {
            return null;
        }
        if (n2 == 0) {
            return this._rules.get(n);
        }
        if (n2 == 1) {
            return this._rules.get(n).getRuleName();
        }
        if (n2 == 2) {
            return this._rules.get(n).getRuleTypeString();
        }
        return "";
    }

    public void setValueAt(Object object, int n, int n2) {
        if (object instanceof YieldAnalysisRuleRef) {
            int n3;
            if (this.isRuleInAvalibleRuleList((YieldAnalysisRuleRef)object)) {
                return;
            }
            this._rules.add((YieldAnalysisRuleRef)object);
            int n4 = n3 = this._rules.size();
            this.fireTableRowsUpdated(n4, n4);
        }
    }

    private boolean isRuleInAvalibleRuleList(YieldAnalysisRuleRef yieldAnalysisRuleRef) {
        for (int i = 0; i < this._rules.size(); ++i) {
            if (this._rules.get(i).getLocationName() == null || !this._rules.get(i).getRuleName().equals(yieldAnalysisRuleRef.getRuleName()) || !this._rules.get(i).getLocationName().equals(yieldAnalysisRuleRef.getLocationName())) continue;
            return true;
        }
        return false;
    }

    public void activateRuleRow(YieldAnalysisRuleRef yieldAnalysisRuleRef) {
        if (yieldAnalysisRuleRef == null || yieldAnalysisRuleRef.getRuleName() == null) {
            this._selectedRule = -1;
            this.fireTableDataChanged();
            return;
        }
        for (int i = 0; i < this._rules.size(); ++i) {
            YieldAnalysisRuleRef yieldAnalysisRuleRef2 = this._rules.get(i);
            if (!yieldAnalysisRuleRef.getRuleName().equals(yieldAnalysisRuleRef2.getRuleName()) || !yieldAnalysisRuleRef.getLocationName().equals(yieldAnalysisRuleRef2.getLocationName())) continue;
            this._selectedRule = i;
            this.fireTableDataChanged();
            return;
        }
    }

    public boolean isCellEditable(int n, int n2) {
        return n != this._selectedRule;
    }

    public void updateZoneRules(ReservoirElement object, OpSet rssModelVariableConstants, WaterAccount waterAccount) {
        this._wa = waterAccount;
        if ((object = YieldAnalysisRuleRef.a((ReservoirElement)object, rssModelVariableConstants)) == null) {
            return;
        }
        for (int i = 0; i < object.size(); ++i) {
            rssModelVariableConstants = (YieldAnalysisRuleRef)object.get(i);
            if (this.isRuleInAvalibleRuleList((YieldAnalysisRuleRef)rssModelVariableConstants)) continue;
            this._rules.add((YieldAnalysisRuleRef)rssModelVariableConstants);
        }
        this.fireTableDataChanged();
    }

    public int getRowCount() {
        if (this._wa == null) {
            return 0;
        }
        return this._rules.size();
    }

    public boolean removeZoneRulesTable(ReservoirElement object, OpSet rssModelVariableConstants, WaterAccount waterAccount) {
        this._wa = waterAccount;
        boolean bl = false;
        if ((object = YieldAnalysisRuleRef.a((ReservoirElement)object, (OpSet)rssModelVariableConstants)).size() == 0) {
            return false;
        }
        for (int i = 0; i < object.size(); ++i) {
            YieldAnalysisRuleRef yieldAnalysisRuleRef = (YieldAnalysisRuleRef)object.get(i);
            for (int j = 0; j < this._rules.size(); ++j) {
                rssModelVariableConstants = this._rules.get(j);
                if (!((YieldAnalysisRuleRef)rssModelVariableConstants).getLocationName().equals(yieldAnalysisRuleRef.getLocationName()) || !((YieldAnalysisRuleRef)rssModelVariableConstants).getRuleName().equals(yieldAnalysisRuleRef.getRuleName())) continue;
                if (this.getActiveRule() != null && this.getActiveRule().getRuleName().equals(((YieldAnalysisRuleRef)rssModelVariableConstants).getRuleName())) {
                    bl = true;
                    this._selectedRule = -1;
                }
                this._rules.remove(rssModelVariableConstants);
            }
        }
        this.fireTableDataChanged();
        return bl;
    }

    public int getSelectedRow() {
        return this._selectedRule;
    }

    public YieldAnalysisRuleRef getActiveRule() {
        if (this._selectedRule == -1) {
            return null;
        }
        return this._rules.get(this._selectedRule);
    }

    public void deleteRow(int n) {
        if (n < 0) {
            return;
        }
        if (n < this._rules.size()) {
            this._rules.remove(n);
        }
        int n2 = n;
        this.fireTableRowsDeleted(n2, n2);
    }

    public void setWaterAccount(WaterAccount waterAccount) {
        this._wa = waterAccount;
        this.fireTableDataChanged();
    }

    public void clearAll() {
        this._rules.clear();
        this._selectedRule = -1;
        this._wa = null;
        this.fireTableDataChanged();
    }
}

