/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.lang.NamedType;
import hec.rss.client.AlternativeEditor;
import hec.rss.client.WaterAccountYieldAnalysisPanel$MissingInfo;
import hec.rss.client.YieldDemandWAcountPanel;
import hec.rss.model.OpRule;
import hec.rss.model.OpSet;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssAlt;
import hec.rss.model.StorageZone;
import hec.rss.model.StorageZoneRef;
import hec.rss.model.WaterAccount;
import hec.rss.model.WaterAccountSet;
import hec.rss.model.WaterAccountYieldAnalysis;
import hec.rss.model.YieldAnalysisRuleRef;
import hec.rss.model.YieldAnalysisType;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJLabel;
import rma.swing.list.RmaListModel;

public class WaterAccountYieldAnalysisPanel
extends JPanel {
    private YieldDemandWAcountPanel _demPanel;
    private RmaJIntegerField _maxIterationFld;
    private AlternativeEditor _editor;
    private RmaJComboBox<WaterAccount> _waterAccountCombo;
    private RmaJDecimalField _accountToleranceField;
    private RmaJIntegerField _demandVarLimitFld;
    private RmaJCheckBox _useDemandVarLimitCheck;

    WaterAccountYieldAnalysisPanel(AlternativeEditor alternativeEditor) {
        super(new GridBagLayout());
        this._editor = alternativeEditor;
        this.buildControls();
        this.addListeners();
    }

    private void buildControls() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        this.add((Component)jPanel, gridBagConstraints);
        JLabel jLabel = new JLabel("Water Account:");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._waterAccountCombo = new RmaJComboBox();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._waterAccountCombo, gridBagConstraints);
        this._waterAccountCombo.addActionListener(actionEvent -> this.waterAccountComboAction());
        jLabel = new RmaJLabel("Tolerance (%S):");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._accountToleranceField = new RmaJDecimalField();
        this._accountToleranceField.setDisplayUnitsSystem(ClientApp.app().getClientUnitSystem());
        jLabel.setLabelFor((Component)this._accountToleranceField);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._accountToleranceField, gridBagConstraints);
        this._demPanel = new YieldDemandWAcountPanel(this._editor);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        WaterAccountYieldAnalysisPanel waterAccountYieldAnalysisPanel = this;
        waterAccountYieldAnalysisPanel.add((Component)waterAccountYieldAnalysisPanel._demPanel, gridBagConstraints);
        jLabel = new JLabel("Maximum Iterations:");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        this.add((Component)jLabel, gridBagConstraints);
        this._maxIterationFld = new RmaJIntegerField();
        this._maxIterationFld.setMinValue(0);
        jLabel.setLabelFor((Component)this._maxIterationFld);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        WaterAccountYieldAnalysisPanel waterAccountYieldAnalysisPanel2 = this;
        waterAccountYieldAnalysisPanel2.add((Component)waterAccountYieldAnalysisPanel2._maxIterationFld, gridBagConstraints);
        this._useDemandVarLimitCheck = new RmaJCheckBox("Demand Variation Limit:");
        this._useDemandVarLimitCheck.setToolTipText("<html>When selected, demand will be varied within +/- this percent of the original demand rule<br>values to find the water account firm yield.");
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        WaterAccountYieldAnalysisPanel waterAccountYieldAnalysisPanel3 = this;
        waterAccountYieldAnalysisPanel3.add((Component)waterAccountYieldAnalysisPanel3._useDemandVarLimitCheck, gridBagConstraints);
        this._demandVarLimitFld = new RmaJIntegerField();
        this._demandVarLimitFld.setMinValue(1);
        jLabel.setLabelFor((Component)this._demandVarLimitFld);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        WaterAccountYieldAnalysisPanel waterAccountYieldAnalysisPanel4 = this;
        waterAccountYieldAnalysisPanel4.add((Component)waterAccountYieldAnalysisPanel4._demandVarLimitFld, gridBagConstraints);
        this.useDemandLimitCheckAction();
    }

    private void addListeners() {
        this._useDemandVarLimitCheck.addActionListener(actionEvent -> this.useDemandLimitCheckAction());
    }

    private void useDemandLimitCheckAction() {
        this._demandVarLimitFld.setEnabled(this._useDemandVarLimitCheck.isSelected());
    }

    public void fillPanel(NamedType object) {
        if (!(object instanceof RssAlt)) {
            return;
        }
        if (((RssAlt)(object = (RssAlt)object)).getWaterAccountSet() != null) {
            this.fillAccountCombo(((RssAlt)object).getWaterAccountSet());
        }
        this._demPanel.fillPanel(null, (RssAlt)object);
        if (((RssAlt)object).getReservoirYieldAnalysis() == null) {
            this._accountToleranceField.setValue(new ParamDouble(100.0, Parameter.PARAMID_STOR, ClientApp.frame().getDisplayUnitSystem()));
            return;
        }
        WaterAccountYieldAnalysis waterAccountYieldAnalysis = ((RssAlt)object).getWaterAccountYieldAnalysis();
        if (waterAccountYieldAnalysis != null) {
            this._useDemandVarLimitCheck.setSelected(waterAccountYieldAnalysis.f());
            int n = waterAccountYieldAnalysis.e();
            if (n <= 0) {
                n = Integer.MIN_VALUE;
            }
            this._demandVarLimitFld.setValue(n);
            this.useDemandLimitCheckAction();
            if (waterAccountYieldAnalysis.c() == Integer.MIN_VALUE || ((RssAlt)object).getWaterAccountSet() == null) {
                return;
            }
            WaterAccount waterAccount = ((RssAlt)object).getWaterAccountSet().getWaterAccountSet(waterAccountYieldAnalysis.c());
            if (waterAccount != null) {
                this._waterAccountCombo.setSelectedItem((Object)waterAccount);
            }
            this._accountToleranceField.setValue(new ParamDouble(waterAccountYieldAnalysis.a(), Parameter.PARAMID_STOR, object.getUnitSystem()));
            this._demPanel.fillPanel(waterAccountYieldAnalysis, (RssAlt)object);
            this._maxIterationFld.setValue(waterAccountYieldAnalysis.getMaxIterations());
        }
    }

    private void waterAccountComboAction() {
        if (this._waterAccountCombo.getSelectedItem() instanceof WaterAccount) {
            this._demPanel.clearPanel();
            this._demPanel.fillTable((WaterAccount)this._waterAccountCombo.getSelectedItem());
        }
    }

    void fillAccountCombo(WaterAccountSet waterAccountSet) {
        ArrayList<WaterAccount> arrayList = new ArrayList<WaterAccount>();
        if (waterAccountSet != null && waterAccountSet.getWaterAccounts() != null && !waterAccountSet.getWaterAccounts().isEmpty()) {
            for (int i = 0; i < waterAccountSet.getWaterAccounts().size(); ++i) {
                if (waterAccountSet.getWaterAccounts().get(i) == null) continue;
                arrayList.add(waterAccountSet.getWaterAccounts().get(i));
            }
        }
        this._waterAccountCombo.setModel((ComboBoxModel)new RmaListModel(false, arrayList));
        this._waterAccountCombo.setSelectedIndex(-1);
    }

    public boolean savePanel(RssAlt rssAlt) {
        WaterAccountYieldAnalysis waterAccountYieldAnalysis = new WaterAccountYieldAnalysis();
        waterAccountYieldAnalysis.setMaxIterations(this._maxIterationFld.getValue());
        waterAccountYieldAnalysis.a(this._useDemandVarLimitCheck.isSelected());
        waterAccountYieldAnalysis.b(this._demandVarLimitFld.getValue());
        waterAccountYieldAnalysis.a(this._accountToleranceField.getValue());
        if (this._waterAccountCombo.getSelectedItem() instanceof WaterAccount) {
            if (rssAlt.getSelectedYieldAnalysis() == YieldAnalysisType.WATER_ACCOUNT) {
                this.validateOpSet(rssAlt);
            }
            waterAccountYieldAnalysis.a(((WaterAccount)this._waterAccountCombo.getSelectedItem()).getIndex());
        }
        this._demPanel.savePanel(waterAccountYieldAnalysis);
        rssAlt.setWaterAccountYieldAnalysis(waterAccountYieldAnalysis);
        return true;
    }

    private void validateOpSet(RssAlt rssAlt) {
        Object object = (WaterAccount)this._waterAccountCombo.getSelectedItem();
        if (object == null) {
            return;
        }
        List<YieldAnalysisRuleRef> list = ((WaterAccount)object).getRuleRefs();
        object = rssAlt.getSystem().getWaterAccountSet(((WaterAccount)object).getWaterAccountSetIndex());
        if (object == null) {
            return;
        }
        object = ((WaterAccountSet)object).getResZoneRefs();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < object.size(); ++i) {
            List<OpRule> list2;
            Object object2 = (StorageZoneRef)object.get(0);
            int n = ((StorageZoneRef)object2).getReservoirIndex();
            object2 = rssAlt.getSystem().getElement(n);
            if (!(object2 instanceof ReservoirElement)) continue;
            object2 = (ReservoirElement)object2;
            int n2 = rssAlt.getResOpSetSelection(object2.getIndex());
            OpSet opSet = ((ReservoirElement)object2).getReservoirOp().getOperationSet(n2);
            if (opSet != null) {
                Vector vector = opSet.getZoneVector();
                for (int j = 0; j < list.size(); ++j) {
                    YieldAnalysisRuleRef yieldAnalysisRuleRef = list.get(j);
                    Object object3 = yieldAnalysisRuleRef.getRule();
                    if (object3 == null) continue;
                    boolean bl = false;
                    for (int k = 0; k < vector.size(); ++k) {
                        list2 = (StorageZone)vector.get(k);
                        list2 = ((StorageZone)((Object)list2)).getRules(null);
                        for (int i2 = 0; i2 < list2.size(); ++i2) {
                            OpRule opRule = list2.get(i2);
                            if (opRule == null || !object3.getName().equals(opRule.getName())) continue;
                            bl = true;
                        }
                    }
                    if (bl) continue;
                    object3 = new WaterAccountYieldAnalysisPanel$MissingInfo(this, object2.getName(), yieldAnalysisRuleRef.getLocationName(), opSet.getName(), yieldAnalysisRuleRef.getRuleName());
                    arrayList.add(object3);
                }
            }
            if (arrayList.size() <= 0) continue;
            list2 = new StringBuilder();
            ((StringBuilder)((Object)list2)).append("<html>The following Water Supply Rules are missing from the Operation Set for Reservoir<br><br>");
            for (int j = 0; j < arrayList.size(); ++j) {
                WaterAccountYieldAnalysisPanel$MissingInfo waterAccountYieldAnalysisPanel$MissingInfo = (WaterAccountYieldAnalysisPanel$MissingInfo)arrayList.get(j);
                ((StringBuilder)((Object)list2)).append("<b>  Reservoir:</b>");
                ((StringBuilder)((Object)list2)).append(waterAccountYieldAnalysisPanel$MissingInfo.a);
                ((StringBuilder)((Object)list2)).append("<b>  Operation Set:</b>");
                ((StringBuilder)((Object)list2)).append(waterAccountYieldAnalysisPanel$MissingInfo.c);
                ((StringBuilder)((Object)list2)).append("<b>  Location:</b>");
                ((StringBuilder)((Object)list2)).append(waterAccountYieldAnalysisPanel$MissingInfo.b);
                ((StringBuilder)((Object)list2)).append("<b>  Rule:</b>");
                ((StringBuilder)((Object)list2)).append(waterAccountYieldAnalysisPanel$MissingInfo.d);
                ((StringBuilder)((Object)list2)).append("<br> ");
            }
            JOptionPane.showMessageDialog(this, ((StringBuilder)((Object)list2)).toString(), "Missing Water Supply Rules", 2);
        }
    }

    public void clearPanel() {
        this._demPanel.clearPanel();
        this._accountToleranceField.setValue(new ParamDouble(0.0, Parameter.PARAMID_STOR, ClientApp.frame().getDisplayUnitSystem()));
        this._maxIterationFld.setValue(25);
        this._waterAccountCombo.setSelectedIndex(-1);
        this._useDemandVarLimitCheck.setSelected(false);
        this._demandVarLimitFld.clearPerformed();
        this.useDemandLimitCheckAction();
    }
}

