/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.rss.client.WaterAccountSetEditor;
import hec.rss.client.WaterAccountZonePanel$1;
import hec.rss.client.WaterAccountZonePanel$OperationSetComboItemListener;
import hec.rss.model.OpSet;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssSystem;
import hec.rss.model.StorageZone;
import hec.rss.model.StorageZoneRef;
import hec.rss.model.WaterAccountSet;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJTable;
import rma.util.RMAIO;

public class WaterAccountZonePanel
extends DefaultJPanel {
    private RssSystem _system;
    private RmaJTable _reservoirTable;
    private WaterAccountSetEditor _editor;
    private JCheckBox _isActiveCheckbox;
    public List<StorageZoneRef> _defaultZoneList = new ArrayList<StorageZoneRef>();
    public List<StorageZoneRef> _currentZoneList;
    public List<ReservoirElement> _activeReservoirs = new ArrayList<ReservoirElement>();

    public WaterAccountZonePanel(WaterAccountSetEditor waterAccountSetEditor, RssSystem rssSystem) {
        super((LayoutManager)new GridBagLayout());
        this._editor = waterAccountSetEditor;
        this._system = rssSystem;
        this.buildPanel();
    }

    private void buildPanel() {
        this._reservoirTable = new RmaJTable((Component)((Object)this), (Object[])new String[]{"Active", "Reservoir", "Operation Set", "Lower Limit of \nCon Pool"});
        this._reservoirTable.setMlHeaderRenderer();
        Vector vector = this._system.getElementVectorByClass("hec.rss.model.ReservoirElement");
        this._currentZoneList = new ArrayList<StorageZoneRef>();
        this._isActiveCheckbox = this._reservoirTable.setCheckBoxCellEditor(0);
        this._isActiveCheckbox.addActionListener(new WaterAccountZonePanel$1(this));
        this._reservoirTable.setComboBoxEditor(2, new Vector());
        this._reservoirTable.setComboBoxEditor(3, new Vector());
        this._reservoirTable.setAddRemoveEnabled(false);
        for (int i = 0; i < vector.size(); ++i) {
            this._reservoirTable.setValueAt(vector.get(i), i, 1);
            StorageZoneRef storageZoneRef = new StorageZoneRef();
            storageZoneRef.setReservoirIndex(((ReservoirElement)vector.get(i)).getIndex());
            this._defaultZoneList.add(storageZoneRef);
            this._currentZoneList.add((StorageZoneRef)storageZoneRef.clone());
            storageZoneRef = this._reservoirTable.setComboBoxRowEditor(i, 2, ((ReservoirElement)vector.get(i)).getReservoirOp().getOperationSets());
            ((JComboBox)((Object)storageZoneRef)).addItemListener(new WaterAccountZonePanel$OperationSetComboItemListener(this));
            this._reservoirTable.setCellEnabled(false, i, 0);
            this._reservoirTable.setCellEnabled(false, i, 1);
            this._reservoirTable.setCellEnabled(false, i, 2);
            this._reservoirTable.setCellEnabled(false, i, 3);
        }
        this._reservoirTable.setAddRemoveEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        WaterAccountZonePanel waterAccountZonePanel = this;
        waterAccountZonePanel.add(waterAccountZonePanel._reservoirTable.getScrollPane(), gridBagConstraints);
    }

    public void isActiveCheckboxAction() {
        int n = this._reservoirTable.getSelectedRow();
        if (this._isActiveCheckbox.isSelected()) {
            this._reservoirTable.setCellEnabled(true, n, 2);
            this._reservoirTable.setCellEnabled(true, n, 3);
            if (!this._activeReservoirs.contains(this._reservoirTable.getCell(n, 1))) {
                this._activeReservoirs.add((ReservoirElement)this._reservoirTable.getCell(n, 1));
                if (this._reservoirTable.getValueAt(n, 2) instanceof OpSet) {
                    this._editor._waterAccountPanel.updateZoneRulesTable((ReservoirElement)this._reservoirTable.getCell(n, 1), (OpSet)this._reservoirTable.getValueAt(n, 2));
                    this.setModified(true);
                    return;
                }
            }
        } else if (this._activeReservoirs.contains(this._reservoirTable.getCell(n, 1))) {
            this._activeReservoirs.remove(this._reservoirTable.getCell(n, 1));
            if (this._reservoirTable.getValueAt(n, 2) instanceof OpSet) {
                this._editor._waterAccountPanel.removeZoneRulesTable((ReservoirElement)this._reservoirTable.getCell(n, 1), (OpSet)this._reservoirTable.getValueAt(n, 2));
                this.setModified(true);
            }
        }
    }

    public String getTabname() {
        return "Reservoirs";
    }

    public void fillPanel(WaterAccountSet waterAccountSet) {
        if (waterAccountSet == null) {
            for (int i = 0; i < this._reservoirTable.getRowCount(); ++i) {
                this._reservoirTable.setCellEnabled(false, i, 0);
                this._reservoirTable.setCellEnabled(false, i, 1);
                this._reservoirTable.setCellEnabled(false, i, 2);
                this._reservoirTable.setCellEnabled(false, i, 3);
            }
        } else {
            for (int i = 0; i < this._reservoirTable.getRowCount(); ++i) {
                this._reservoirTable.setCellEnabled(true, i, 0);
                this._reservoirTable.setCellEnabled(false, i, 1);
                this._reservoirTable.setCellEnabled(true, i, 2);
                this._reservoirTable.setCellEnabled(true, i, 3);
            }
        }
        this.setReservoirTable(waterAccountSet);
    }

    public void setReservoirTable(WaterAccountSet waterAccountSet) {
        this._editor._waterAccountPanel.clearTable();
        this._activeReservoirs = new ArrayList<ReservoirElement>();
        for (int i = 0; i < this._reservoirTable.getRowCount(); ++i) {
            if (waterAccountSet != null && waterAccountSet.getResZoneRefs() != null && i < waterAccountSet.getResZoneRefs().size()) {
                Object object;
                Cloneable cloneable = waterAccountSet.getResZoneRefs().get(i);
                this._reservoirTable.setValueAt((Object)((StorageZoneRef)cloneable).isActive(), i, 0);
                ReservoirElement reservoirElement = (ReservoirElement)this._reservoirTable.getValueAt(i, 1);
                OpSet opSet = reservoirElement.getReservoirOp().getOperationSet(((StorageZoneRef)cloneable).getOpsetId());
                if (opSet != null) {
                    ((StorageZoneRef)cloneable).setOpID(opSet._index);
                    this._currentZoneList.add(i, (StorageZoneRef)cloneable);
                    if (((Boolean)this._reservoirTable.getValueAt(i, 0)).booleanValue()) {
                        this._activeReservoirs.add(reservoirElement);
                        this._editor._waterAccountPanel.updateZoneRulesTable(reservoirElement, opSet);
                    }
                    this._reservoirTable.setValueAt((Object)opSet, i, 2);
                    object = opSet.getSortedZoneVector();
                    this._reservoirTable.setComboBoxRowEditor(i, 3, (Vector)object);
                    cloneable = opSet.getZone(((StorageZoneRef)cloneable).getZoneIndex());
                    if (cloneable != null) {
                        this._reservoirTable.setValueAt((Object)cloneable, i, 3);
                        continue;
                    }
                    this._reservoirTable.setValueAt((Object)opSet.getInactiveZone(), i, 3);
                    continue;
                }
                if (reservoirElement.getReservoirOp().getOperationSets().size() > 0) {
                    object = reservoirElement.getReservoirOp().getOperationSets().get(0);
                    this._reservoirTable.setValueAt(object, i, 2);
                    cloneable = ((OpSet)object).getSortedZoneVector();
                    this._reservoirTable.setComboBoxRowEditor(i, 3, (Vector)cloneable);
                    if (((Boolean)this._reservoirTable.getValueAt(i, 0)).booleanValue()) {
                        this._activeReservoirs.add(reservoirElement);
                        this._editor._waterAccountPanel.updateZoneRulesTable((ReservoirElement)((OpSet)object).getElementOp().getOperationsElement(), (OpSet)object);
                    }
                    this._reservoirTable.setValueAt((Object)((OpSet)object).getInactiveZone(), i, 3);
                    continue;
                }
                this._reservoirTable.setValueAt(null, i, 2);
                this._reservoirTable.setValueAt(null, i, 3);
                continue;
            }
            this._reservoirTable.setValueAt((Object)Boolean.FALSE, i, 0);
            this._reservoirTable.setValueAt(null, i, 2);
            this._reservoirTable.setValueAt(null, i, 3);
        }
    }

    public boolean savePanel() {
        ArrayList<StorageZoneRef> arrayList = new ArrayList<StorageZoneRef>();
        int n = 0;
        for (int i = 0; i < this._reservoirTable.getRowCount(); ++i) {
            OpSet opSet;
            boolean bl;
            Object object = this._reservoirTable.getValueAt(i, 0);
            Object object2 = this._reservoirTable.getValueAt(i, 1);
            Object object3 = this._reservoirTable.getValueAt(i, 2);
            Object object4 = this._reservoirTable.getValueAt(i, 3);
            try {
                bl = (Boolean)object;
                object2 = (ReservoirElement)object2;
                opSet = (OpSet)object3;
                object3 = (StorageZone)object4;
            }
            catch (Exception exception) {
                return true;
            }
            if (opSet == null && object3 == null) {
                return true;
            }
            object = new StorageZoneRef((StorageZone)object3);
            ((StorageZoneRef)object).setActive(bl);
            if (bl) {
                ++n;
            }
            ((StorageZoneRef)object).setReservoirIndex(object2.getIndex());
            ((StorageZoneRef)object).setOpID(opSet.getIndex());
            ((StorageZoneRef)object).setZoneIndex(object3.getIndex());
            arrayList.add((StorageZoneRef)object);
        }
        if (n <= 0) {
            RMAIO.postError((Component)((Object)this), (String)"Please select at least one active reservoir");
            return false;
        }
        this._editor._currentWaterSet.setResZoneRefs(arrayList);
        return true;
    }
}

