/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.data.ParamDouble;
import hec.rss.client.WaterControlDevicePanel;
import hec.rss.model.ContinuousIntakeControlDevice;
import hec.rss.model.Element;
import hec.rss.model.ReservoirElement;
import hec.rss.model.WaterControlDeviceType;
import hec.rss.plugins.waterquality.model.RssWQGeometry;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import mil.army.usace.hec.metadata.Parameter;
import rma.swing.RmaInsets;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJPanel;
import rma.swing.RmaJRadioButton;

public class WaterControlDeviceContinuousIntakePanel
extends WaterControlDevicePanel<ContinuousIntakeControlDevice> {
    private RmaJDecimalField _intakeMinimumField;
    private RmaJDecimalField _intakeMaximumField;
    private RmaJRadioButton _intakeMinElevRadioButton;
    private RmaJRadioButton _intakeMinDepthRadioButton;
    private RmaJRadioButton _intakeMaxElevRadioButton;
    private RmaJRadioButton _intakeMaxDepthRadioButton;

    public WaterControlDeviceContinuousIntakePanel() {
        super(new GridBagLayout());
        this.initComponents();
        this.addListeners();
        this.initializeWaterControlDevice();
    }

    private void addListeners() {
        this._intakeMinDepthRadioButton.addActionListener(actionEvent -> this.intakeMinDepthRadioButtonClicked());
        this._intakeMaxDepthRadioButton.addActionListener(actionEvent -> this.intakeMaxDepthRadioButtonClicked());
        this._intakeMaxElevRadioButton.addActionListener(actionEvent -> this.intakeMaxElevRadioButtonClicked());
        this._intakeMinElevRadioButton.addActionListener(actionEvent -> this.intakeMinElevRadioButtonClicked());
    }

    private void intakeMinElevRadioButtonClicked() {
        this._intakeMinimumField.setMinValue(Double.NEGATIVE_INFINITY);
    }

    private void intakeMaxElevRadioButtonClicked() {
        this._intakeMaximumField.setMinValue(Double.NEGATIVE_INFINITY);
    }

    private void intakeMaxDepthRadioButtonClicked() {
        if (this._intakeMaximumField.getValue() < 0.0) {
            this._intakeMaximumField.setValue(new ParamDouble(0.0, hec.data.Parameter.PARAMID_ELEV, ClientApp.Workspace().getUnitSystem()));
        }
        this._intakeMaximumField.setMinValue(0.0);
    }

    private void intakeMinDepthRadioButtonClicked() {
        if (this._intakeMinimumField.getValue() < 0.0) {
            this._intakeMinimumField.setValue(new ParamDouble(0.0, hec.data.Parameter.PARAMID_ELEV, ClientApp.Workspace().getUnitSystem()));
        }
        this._intakeMinimumField.setMinValue(0.0);
    }

    private void initComponents() {
        JLabel jLabel = new JLabel("Highest Allowable Intake:");
        this._intakeMinimumField = new RmaJDecimalField();
        this._intakeMinElevRadioButton = new RmaJRadioButton("Elev (%S)");
        this._intakeMinElevRadioButton.setParameterId(Parameter.PARAMID_ELEV);
        this._intakeMinDepthRadioButton = new RmaJRadioButton("Depth (%S)");
        this._intakeMinDepthRadioButton.setParameterId(Parameter.PARAMID_ELEV);
        WaterControlDeviceContinuousIntakePanel waterControlDeviceContinuousIntakePanel = this;
        RmaJPanel rmaJPanel = waterControlDeviceContinuousIntakePanel.buildIntakePanel(waterControlDeviceContinuousIntakePanel._intakeMinimumField, this._intakeMinElevRadioButton, this._intakeMinDepthRadioButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add(jLabel, gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        this.add((Component)rmaJPanel, gridBagConstraints);
        jLabel = new JLabel("Lowest Allowable Intake:");
        this._intakeMaximumField = new RmaJDecimalField();
        this._intakeMaxElevRadioButton = new RmaJRadioButton("Elev (%S)");
        this._intakeMaxElevRadioButton.setParameterId(Parameter.PARAMID_ELEV);
        this._intakeMaxDepthRadioButton = new RmaJRadioButton("Depth (%S)");
        this._intakeMaxDepthRadioButton.setParameterId(Parameter.PARAMID_ELEV);
        WaterControlDeviceContinuousIntakePanel waterControlDeviceContinuousIntakePanel2 = this;
        rmaJPanel = waterControlDeviceContinuousIntakePanel2.buildIntakePanel(waterControlDeviceContinuousIntakePanel2._intakeMaximumField, this._intakeMaxElevRadioButton, this._intakeMaxDepthRadioButton);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add(jLabel, gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        this.add((Component)rmaJPanel, gridBagConstraints);
        jLabel = new RmaJPanel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        this.add(jLabel, gridBagConstraints);
    }

    private RmaJPanel buildIntakePanel(RmaJDecimalField rmaJDecimalField, RmaJRadioButton rmaJRadioButton, RmaJRadioButton rmaJRadioButton2) {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)rmaJRadioButton);
        buttonGroup.add((AbstractButton)rmaJRadioButton2);
        buttonGroup.setSelected(rmaJRadioButton.getModel(), true);
        buttonGroup = new RmaJPanel((LayoutManager)new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        buttonGroup.add((Component)rmaJDecimalField, gridBagConstraints);
        rmaJDecimalField = new RmaJPanel((LayoutManager)new GridBagLayout());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJDecimalField.add((Component)rmaJRadioButton, (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJDecimalField.add((Component)rmaJRadioButton2, (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        buttonGroup.add((Component)rmaJDecimalField, gridBagConstraints);
        return buttonGroup;
    }

    @Override
    public boolean savePanel() {
        if (this._device == null) {
            return false;
        }
        if (!this.validateEntries()) {
            return false;
        }
        ((ContinuousIntakeControlDevice)this._device).setMinIntake(this._intakeMinimumField.getValue());
        ((ContinuousIntakeControlDevice)this._device).setMaxIntake(this._intakeMaximumField.getValue());
        ((ContinuousIntakeControlDevice)this._device).setUseElevationForMinIntake(this._intakeMinElevRadioButton.isSelected());
        ((ContinuousIntakeControlDevice)this._device).setUseElevationForMaxIntake(this._intakeMaxElevRadioButton.isSelected());
        return true;
    }

    private boolean validateEntries() {
        Element element = this.getElement();
        element = (ReservoirElement)element.getTopParent();
        double d = RssWQGeometry.getReservoirMinElevation((ReservoirElement)element);
        double d2 = RssWQGeometry.getReservoirMaxElevation((ReservoirElement)element);
        double d3 = d2 - d;
        boolean bl = this._intakeMaxElevRadioButton.isSelected();
        boolean bl2 = this._intakeMinElevRadioButton.isSelected();
        double d4 = this._intakeMaximumField.getValue();
        double d5 = this._intakeMinimumField.getValue();
        String string = "";
        if (bl2 && bl && d4 > d5) {
            string = "The lowest allowable intake elevation cannot be greater than the highest allowable intake elevation.";
        }
        if (!bl2 && !bl && d4 < d5) {
            string = "The lowest allowable intake elevation cannot be greater than the highest allowable intake elevation.";
        }
        if (bl2 && d5 > d2) {
            string = "The highest allowable intake elevation cannot be greater than the maximum reservoir elevation.";
        }
        if (bl) {
            if (d4 < d) {
                string = "The lowest allowable intake elevation cannot be less than the minimum reservoir elevation.";
            }
        } else if (d4 > d3) {
            string = "The lowest allowable intake depth cannot be greater than the maximum reservoir depth.";
        }
        if (!string.isEmpty()) {
            JOptionPane.showMessageDialog((Component)((Object)this), string, "Invalid Water Control Device", 0);
            return false;
        }
        return true;
    }

    @Override
    public void fillPanel(ContinuousIntakeControlDevice continuousIntakeControlDevice) {
        int n = ClientApp.Workspace().getUnitSystem();
        this._intakeMinimumField.setValue(new ParamDouble(continuousIntakeControlDevice.getMinIntake(), hec.data.Parameter.PARAMID_ELEV, n));
        this._intakeMaximumField.setValue(new ParamDouble(continuousIntakeControlDevice.getMaxIntake(), hec.data.Parameter.PARAMID_ELEV, n));
        if (continuousIntakeControlDevice.getMinIntake() == -3.4028234663852886E38) {
            this._intakeMinimumField.setText("");
        }
        if (continuousIntakeControlDevice.getMaxIntake() == -3.4028234663852886E38) {
            this._intakeMaximumField.setText("");
        }
        if (continuousIntakeControlDevice.useElevationForMinIntake()) {
            this._intakeMinElevRadioButton.doClick(0);
        } else {
            this._intakeMinDepthRadioButton.doClick(0);
        }
        if (continuousIntakeControlDevice.useElevationForMaxIntake()) {
            this._intakeMaxElevRadioButton.doClick(0);
            return;
        }
        this._intakeMaxDepthRadioButton.doClick(0);
    }

    @Override
    void resetPanel() {
        this._intakeMinimumField.setValue(new ParamDouble(-3.4028234663852886E38, hec.data.Parameter.PARAMID_ELEV, ClientApp.Workspace().getUnitSystem()));
        this._intakeMaximumField.setValue(new ParamDouble(-3.4028234663852886E38, hec.data.Parameter.PARAMID_ELEV, ClientApp.Workspace().getUnitSystem()));
        this._intakeMaximumField.setText("");
        this._intakeMinimumField.setText("");
        this._intakeMinElevRadioButton.doClick(0);
        this._intakeMaxElevRadioButton.doClick(0);
    }

    @Override
    WaterControlDeviceType getWaterControlDeviceType() {
        return WaterControlDeviceType.CONTINUOUS_INTAKE;
    }

    @Override
    void initializeWaterControlDevice() {
        this._device = new ContinuousIntakeControlDevice();
    }
}

