/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.lang.Statistics;
import hec.rss.client.BedElevationPanel;
import hec.rss.client.WaterControlDeviceGatedIntakePanel$1;
import hec.rss.client.WaterControlDevicePanel;
import hec.rss.client.WaterControlDeviceTableModel;
import hec.rss.client.WaterControlPortGeometry;
import hec.rss.client.WaterControlPortRowItem;
import hec.rss.model.GatedIntakeControlDevice;
import hec.rss.model.IntakeOpening;
import hec.rss.model.IntakeOpeningType;
import hec.rss.model.WaterControlDeviceType;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import javax.swing.table.TableModel;
import rma.swing.EnabledJPanel;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJLabel;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaJTable;
import rma.swing.RmaSwingUtilities;
import rma.swing.list.RmaListModel;

public class WaterControlDeviceGatedIntakePanel
extends WaterControlDevicePanel<GatedIntakeControlDevice> {
    RmaJIntegerField _numberPortLevelsTxt;
    RmaJTable _portTable;
    private BedElevationPanel _bedElevationPanel;
    private RmaJRadioButton _rectangleRadioButton;
    private RmaJDecimalField _heightTextField;
    private RmaJDecimalField _widthTextField;
    private RmaJRadioButton _circularRadioButton;
    private RmaJDecimalField _diameterTextField;
    private RmaJComboBox<IntakeOpening> _opensFromComboBox;
    private WaterControlDeviceTableModel _tableModel;
    private EnabledJPanel _geometryPanel;
    private int _currentRowIndex;

    public WaterControlDeviceGatedIntakePanel() {
        super(new GridBagLayout());
        this.initComponents();
        this.addListeners();
        this.resetPanel();
    }

    private void initComponents() {
        JComponent jComponent = new JLabel("Number of Port Levels:");
        Serializable serializable = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0);
        this.add(jComponent, serializable);
        this._numberPortLevelsTxt = new RmaJIntegerField();
        this._numberPortLevelsTxt.setMinValue(1);
        ((JLabel)jComponent).setLabelFor((Component)this._numberPortLevelsTxt);
        serializable = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0);
        WaterControlDeviceGatedIntakePanel waterControlDeviceGatedIntakePanel = this;
        waterControlDeviceGatedIntakePanel.add((Component)waterControlDeviceGatedIntakePanel._numberPortLevelsTxt, serializable);
        jComponent = new JPanel(new GridBagLayout());
        serializable = new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0);
        this.add(jComponent, serializable);
        this._portTable = new RmaJTable((Component)((Object)this));
        this._tableModel = new WaterControlDeviceTableModel();
        this._portTable.setModel((TableModel)((Object)this._tableModel));
        this._portTable.setUnitsHeaderRenderer();
        this._portTable.setDoubleCellEditor(1, true);
        this._portTable.setDoubleCellEditor(2);
        this._portTable.setSelectionMode(0);
        this._portTable.removePopupMenuRowEditingOptions();
        serializable = new Dimension();
        ((Dimension)serializable).setSize(250, this._portTable.getRowHeight() * 5);
        this._portTable.setPreferredScrollableViewportSize((Dimension)serializable);
        serializable = new GridBagConstraints(0, 0, 1, 3, 1.0, 1.0, 18, 1, new Insets(10, 5, 0, 0), 0, 0);
        jComponent.add((Component)this._portTable.getScrollPane(), serializable);
        this._geometryPanel = new EnabledJPanel();
        this._geometryPanel.setLayout((LayoutManager)new GridBagLayout());
        this._geometryPanel.setBorder((Border)BorderFactory.createTitledBorder("Port Geometry"));
        serializable = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 12, 2, new Insets(5, 5, 5, 5), 0, 0);
        jComponent.add((Component)this._geometryPanel, serializable);
        serializable = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 12, 2, new Insets(5, 5, 5, 5), 0, 0);
        jComponent.add((Component)new JSeparator(), serializable);
        serializable = new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 12, 2, new Insets(5, 5, 5, 5), 0, 0);
        this._bedElevationPanel = new BedElevationPanel(true, Double.NEGATIVE_INFINITY);
        jComponent.add((Component)((Object)this._bedElevationPanel), serializable);
        this._rectangleRadioButton = new RmaJRadioButton("Rectangular");
        this._rectangleRadioButton.setMargin(new Insets(0, 0, 0, 0));
        serializable = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0);
        this._geometryPanel.add((Component)this._rectangleRadioButton, (Object)serializable);
        jComponent = new RmaJLabel("Height (%S):");
        serializable = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 25, 0, 0), 0, 0);
        this._geometryPanel.add((Component)jComponent, (Object)serializable);
        this._heightTextField = new RmaJDecimalField();
        ((JLabel)jComponent).setLabelFor((Component)this._heightTextField);
        serializable = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0);
        this._geometryPanel.add((Component)this._heightTextField, (Object)serializable);
        jComponent = new RmaJLabel("Width (%S):");
        serializable = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 25, 0, 0), 0, 0);
        this._geometryPanel.add((Component)jComponent, (Object)serializable);
        this._widthTextField = new RmaJDecimalField();
        ((JLabel)jComponent).setLabelFor((Component)this._widthTextField);
        serializable = new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0);
        this._geometryPanel.add((Component)this._widthTextField, (Object)serializable);
        this._circularRadioButton = new RmaJRadioButton("Circular");
        this._circularRadioButton.setMargin(new Insets(0, 0, 0, 0));
        serializable = new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0);
        this._geometryPanel.add((Component)this._circularRadioButton, (Object)serializable);
        jComponent = new RmaJLabel("Diameter (%S):");
        serializable = new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 25, 0, 0), 0, 0);
        this._geometryPanel.add((Component)jComponent, (Object)serializable);
        this._diameterTextField = new RmaJDecimalField();
        ((JLabel)jComponent).setLabelFor((Component)this._diameterTextField);
        serializable = new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0);
        this._geometryPanel.add((Component)this._diameterTextField, (Object)serializable);
        jComponent = new RmaJLabel("Opens From:");
        serializable = new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0);
        this._geometryPanel.add((Component)jComponent, (Object)serializable);
        this._opensFromComboBox = new RmaJComboBox((ComboBoxModel)new RmaListModel(false, (Object[])new IntakeOpening[]{IntakeOpening.Top, IntakeOpening.Bottom, IntakeOpening.Center}));
        this._opensFromComboBox.setModifiable(true);
        ((JLabel)jComponent).setLabelFor((Component)this._opensFromComboBox);
        serializable = new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0);
        this._geometryPanel.add(this._opensFromComboBox, (Object)serializable);
        this._circularRadioButton.setSelected(false);
        this._rectangleRadioButton.setSelected(true);
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add((AbstractButton)this._circularRadioButton);
        ((ButtonGroup)serializable).add((AbstractButton)this._rectangleRadioButton);
        this.radioSelectionChanged();
    }

    private void addListeners() {
        this._circularRadioButton.addActionListener(actionEvent -> this.radioSelectionChanged());
        this._rectangleRadioButton.addActionListener(actionEvent -> this.radioSelectionChanged());
        this._portTable.getSelectionModel().addListSelectionListener(listSelectionEvent -> {
            if (listSelectionEvent.getValueIsAdjusting() || this._device == null) {
                return;
            }
            int n = this._portTable.getSelectedRow();
            int n2 = this._currentRowIndex;
            this.storeCurrentGeometrySettings(n2);
            this.displayPortGeometry(n);
        });
        this._numberPortLevelsTxt.addFocusListener((FocusListener)new WaterControlDeviceGatedIntakePanel$1(this));
    }

    private void storeCurrentGeometrySettings(int n) {
        WaterControlPortRowItem waterControlPortRowItem;
        if (n >= 0 && n < ((GatedIntakeControlDevice)this._device).getPortRows().size() && (waterControlPortRowItem = ((GatedIntakeControlDevice)this._device).getPortRows().get(n)) != null) {
            waterControlPortRowItem.getGeometry().setHeight(this._heightTextField.getValue());
            waterControlPortRowItem.getGeometry().setWidth(this._widthTextField.getValue());
            if (this._rectangleRadioButton.isSelected()) {
                waterControlPortRowItem.getGeometry().setOpeningType(IntakeOpeningType.Rectangular);
            } else {
                waterControlPortRowItem.getGeometry().setOpeningType(IntakeOpeningType.Circular);
            }
            waterControlPortRowItem.getGeometry().setDiameter(this._diameterTextField.getValue());
            waterControlPortRowItem.getGeometry().setIntakeOpening((IntakeOpening)((Object)this._opensFromComboBox.getSelectedItem()));
        }
    }

    private void displayPortGeometry(int n) {
        int n2 = ClientApp.Workspace().getUnitSystem();
        this._currentRowIndex = n;
        List<WaterControlPortRowItem> list = ((GatedIntakeControlDevice)this._device).getPortRows();
        if (n >= 0 && n < ((GatedIntakeControlDevice)this._device).getPortRows().size()) {
            this._geometryPanel.setEnabled(true);
            Object object = list.get(n);
            if (object == null) {
                object = new WaterControlPortRowItem();
            }
            object = ((WaterControlPortRowItem)object).getGeometry();
            this._heightTextField.setValue(new ParamDouble(((WaterControlPortGeometry)object).getHeight(), Parameter.PARAMID_LENGTH, n2));
            this._widthTextField.setValue(new ParamDouble(((WaterControlPortGeometry)object).getWidth(), Parameter.PARAMID_LENGTH, n2));
            this._diameterTextField.setValue(new ParamDouble(((WaterControlPortGeometry)object).getDiameter(), Parameter.PARAMID_LENGTH, n2));
            this._opensFromComboBox.setSelectedItem((Object)((WaterControlPortGeometry)object).getIntakeOpening());
            object = ((WaterControlPortGeometry)object).getOpeningType();
            this._rectangleRadioButton.setSelected(((Enum)object).equals((Object)IntakeOpeningType.Rectangular));
            this._circularRadioButton.setSelected(((Enum)object).equals((Object)IntakeOpeningType.Circular));
            this.radioSelectionChanged();
            return;
        }
        this._geometryPanel.setEnabled(false);
        RmaSwingUtilities.clearForm((Container)this._geometryPanel);
    }

    private void radioSelectionChanged() {
        this._heightTextField.setEnabled(this._rectangleRadioButton.isSelected());
        this._widthTextField.setEnabled(this._rectangleRadioButton.isSelected());
        this._diameterTextField.setEnabled(!this._rectangleRadioButton.isSelected());
    }

    @Override
    public void fillPanel(GatedIntakeControlDevice object) {
        this._currentRowIndex = -1;
        object = ((GatedIntakeControlDevice)object).getPortRows();
        int n = ClientApp.Workspace().getUnitSystem();
        int n2 = object.size();
        this._numberPortLevelsTxt.setValue(n2);
        this._tableModel.setData((List<WaterControlPortRowItem>)object, n);
        this._bedElevationPanel.fillPanel(((GatedIntakeControlDevice)this._device).getUsePoolElevation(), ((GatedIntakeControlDevice)this._device).getBedElevation());
        this._portTable.setNumRows(n2);
        this.displayPortGeometry(-1);
    }

    @Override
    void resetPanel() {
        int n;
        this._portTable.deleteCells();
        ArrayList<WaterControlPortRowItem> arrayList = new ArrayList<WaterControlPortRowItem>();
        for (n = 0; n < 4; ++n) {
            arrayList.add(new WaterControlPortRowItem());
        }
        n = ClientApp.Workspace().getUnitSystem();
        int n2 = arrayList.size();
        this._numberPortLevelsTxt.setValue(n2);
        this._tableModel.setData(arrayList, n);
        this._portTable.setNumRows(n2);
        this._bedElevationPanel.fillPanel(true, Double.NEGATIVE_INFINITY);
        if (this._device == null) {
            this.initializeWaterControlDevice();
        }
        this.displayPortGeometry(-1);
    }

    @Override
    public GatedIntakeControlDevice getWaterControlDevice() {
        return (GatedIntakeControlDevice)this._device;
    }

    @Override
    WaterControlDeviceType getWaterControlDeviceType() {
        return WaterControlDeviceType.GATED_INTAKE;
    }

    @Override
    void initializeWaterControlDevice() {
        this._device = new GatedIntakeControlDevice();
    }

    @Override
    public boolean savePanel() {
        int n = this._portTable.getSelectedRow();
        this.storeCurrentGeometrySettings(n);
        this._portTable.commitEdit(true);
        ((GatedIntakeControlDevice)this._device).setNumberOfPortLevels(this._numberPortLevelsTxt.getValueUndefined());
        ((GatedIntakeControlDevice)this._device).setUsePoolElevation(this._bedElevationPanel.getUsePoolElevation());
        ((GatedIntakeControlDevice)this._device).setBedElevation(this._bedElevationPanel.getElevation());
        ((GatedIntakeControlDevice)this._device).setPortRows(this._tableModel.getPortRows());
        WaterControlDeviceGatedIntakePanel waterControlDeviceGatedIntakePanel = this;
        boolean bl = waterControlDeviceGatedIntakePanel.checkForMonotonicity(waterControlDeviceGatedIntakePanel._tableModel.getPortRows());
        n = bl ? 1 : 0;
        if (!bl) {
            return false;
        }
        this.setModified(false);
        return true;
    }

    private boolean checkForMonotonicity(List<WaterControlPortRowItem> list) {
        int n;
        int n2 = list.size();
        double[] dArray = new double[n2];
        for (n = 0; n < n2; ++n) {
            double d;
            dArray[n] = d = list.get(n).getInvertElevation();
        }
        boolean bl = Statistics.isMonotonicallyIncreasing((int)n2, (double[])dArray);
        n = bl ? 1 : 0;
        if (!bl) {
            String string = "WARNING: Data is not valid.  Invert Elevations values must be strictly monotonically increasing.\n";
            JOptionPane.showMessageDialog((Component)((Object)this), string, "Error", 0);
            return false;
        }
        return true;
    }
}

